/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.plaf.vsnet.VsnetDockableFrameUI;
import com.jidesoft.plaf.xerto.VerticalLabelUI;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class XertoDockableFrameUI
extends VsnetDockableFrameUI {
    private boolean _isVertical = true;
    private JPanel _buttonsPanel = null;
    private BasicDockableFrameTitlePane _dockableFrameTitlePane = null;

    public XertoDockableFrameUI(DockableFrame dockableFrame) {
        super(dockableFrame);
        if (dockableFrame.getKey() != null) {
            this._isVertical = UIDefaultsLookup.getBoolean("DockableFrame." + dockableFrame.getKey().toLowerCase() + ".isVertical");
        }
        this._dockableFrameTitlePane = this.createDockableFrameTitlePane(dockableFrame);
    }

    protected BasicDockableFrameTitlePane createDockableFrameTitlePane(DockableFrame dockableFrame) {
        return new XertoDockableFrameTitlePane(dockableFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new XertoDockableFrameUI((DockableFrame)jComponent);
    }

    @Override
    protected JComponent createNorthPane(DockableFrame dockableFrame) {
        if (this._titlePane == null) {
            this._titlePane = this._dockableFrameTitlePane;
        }
        return this._titlePane;
    }

    @Override
    protected JComponent createWestPane(DockableFrame dockableFrame) {
        if (this._isVertical) {
            this._westPane = this._dockableFrameTitlePane;
            return this._westPane;
        }
        return super.createWestPane(dockableFrame);
    }

    @Override
    public JComponent getNorthPane() {
        if (this._isVertical) {
            return null;
        }
        return super.getNorthPane();
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (this._isVertical) {
            Dimension dimension = this._frame.getContentPane().getMinimumSize();
            Dimension dimension2 = this.getWestPane().getMinimumSize();
            return new Dimension(dimension.width + dimension2.width, dimension.height > dimension2.height ? dimension.height : dimension2.height);
        }
        return super.getMinimumSize(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this._isVertical) {
            Dimension dimension = this._frame.getContentPane().getPreferredSize();
            Dimension dimension2 = this.getWestPane().getPreferredSize();
            return new Dimension(dimension.width + dimension2.width, dimension.height > dimension2.height ? dimension.height : dimension2.height);
        }
        return super.getPreferredSize(jComponent);
    }

    public JPanel getButtonsPanel() {
        if (this._buttonsPanel == null) {
            this._buttonsPanel = new JPanel();
            this._buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        }
        return this._buttonsPanel;
    }

    public class XertoDockableFrameTitlePane
    extends BasicDockableFrameTitlePane {
        private JButton _autoHideBtn;
        private JButton _hideBtn;
        private JButton _floatBtn;
        private boolean _installTitlePaneEnabled;

        public XertoDockableFrameTitlePane(DockableFrame dockableFrame) {
            super(dockableFrame);
            this._autoHideBtn = null;
            this._hideBtn = null;
            this._floatBtn = null;
            this._installTitlePaneEnabled = false;
            this._installTitlePaneEnabled = true;
            this.installTitlePane();
        }

        @Override
        protected void installTitlePane() {
            if (this._installTitlePaneEnabled) {
                super.installTitlePane();
            }
        }

        public void updateButtonsPanel() {
            if (XertoDockableFrameUI.this._buttonsPanel == null) {
                XertoDockableFrameUI.this._buttonsPanel = new JPanel();
                XertoDockableFrameUI.this._buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
                XertoDockableFrameUI.this._buttonsPanel.setBackground(Color.WHITE);
                XertoDockableFrameUI.this._buttonsPanel.setLayout(new FlowLayout(2, 0, 0));
            }
            if (this._autoHideBtn == null) {
                BasicButtonUI basicButtonUI = new BasicButtonUI(){

                    @Override
                    public Dimension getMinimumSize(JComponent jComponent) {
                        if (jComponent instanceof JButton) {
                            Icon icon = ((JButton)jComponent).getIcon();
                            return new Dimension(icon.getIconWidth(), icon.getIconHeight());
                        }
                        return new Dimension(8, 8);
                    }

                    @Override
                    public Dimension getPreferredSize(JComponent jComponent) {
                        return this.getMinimumSize(jComponent);
                    }

                    @Override
                    public Dimension getMaximumSize(JComponent jComponent) {
                        return this.getMinimumSize(jComponent);
                    }
                };
                this._autoHideBtn = new JButton(this._hideAutohideIcon);
                this._autoHideBtn.setBackground(Color.WHITE);
                this._autoHideBtn.setBorder(null);
                this._autoHideBtn.setUI(basicButtonUI);
                this._autoHideBtn.addActionListener(this._frame.getAutohideAction());
                this._autoHideBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        XertoDockableFrameTitlePane.this._autoHideBtn.getModel().setRollover(false);
                    }
                });
                this._hideBtn = new JButton(this._closeIcon);
                this._hideBtn.setBackground(Color.WHITE);
                this._hideBtn.setBorder(null);
                this._hideBtn.setUI(basicButtonUI);
                this._hideBtn.addActionListener(this._frame.getCloseAction());
                this._hideBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        XertoDockableFrameTitlePane.this._hideBtn.getModel().setRollover(false);
                    }
                });
                this._floatBtn = new JButton(this._floatIcon);
                this._floatBtn.setBackground(Color.WHITE);
                this._floatBtn.setBorder(null);
                this._floatBtn.setUI(basicButtonUI);
                this._floatBtn.addActionListener(this._frame.getFloatingAction());
                this._floatBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        XertoDockableFrameTitlePane.this._floatBtn.getModel().setRollover(false);
                    }
                });
            }
            if (this._alwaysShowAllButtons) {
                XertoDockableFrameUI.this._buttonsPanel.add(this._floatBtn);
                XertoDockableFrameUI.this._buttonsPanel.add(this._autoHideBtn);
                XertoDockableFrameUI.this._buttonsPanel.add(this._hideBtn);
            } else {
                if (this._frame.isFloatable() && (this._frame.getDockingManager() == null || this._frame.getDockingManager().isFloatable())) {
                    if (this._frame.isDockable()) {
                        XertoDockableFrameUI.this._buttonsPanel.add(this._floatBtn);
                    } else {
                        XertoDockableFrameUI.this._buttonsPanel.remove(this._floatBtn);
                    }
                } else {
                    XertoDockableFrameUI.this._buttonsPanel.remove(this._floatBtn);
                }
                if (this._frame.isAutohidable() && (this._frame.getDockingManager() == null || this._frame.getDockingManager().isAutohidable())) {
                    XertoDockableFrameUI.this._buttonsPanel.add(this._autoHideBtn);
                } else {
                    XertoDockableFrameUI.this._buttonsPanel.remove(this._autoHideBtn);
                }
                if (this._frame.isHidable() && (this._frame.getDockingManager() == null || this._frame.getDockingManager().isHidable())) {
                    XertoDockableFrameUI.this._buttonsPanel.add(this._hideBtn);
                } else {
                    XertoDockableFrameUI.this._buttonsPanel.remove(this._hideBtn);
                }
            }
            if (!this._frame.isFloated()) {
                this._floatBtn.setIcon(this._floatIcon);
            } else {
                this._floatBtn.setIcon(this._unfloatIcon);
            }
            XertoDockableFrameUI.this._buttonsPanel.invalidate();
        }

        @Override
        public Dimension getMinimumSize() {
            return super.getMinimumSize();
        }

        @Override
        protected void paintTitleBackground(Graphics graphics) {
            boolean bl = this._frame.isActive();
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getTitleBarHeight());
            this.getPainter().paintDockableFrameTitlePane(this, graphics, rectangle, XertoDockableFrameUI.this._isVertical ? 1 : 0, bl ? 3 : 0);
        }

        @Override
        protected LayoutManager createLayout() {
            if (XertoDockableFrameUI.this._isVertical) {
                return new GridLayout(1, 1, 0, 0);
            }
            return super.createLayout();
        }

        @Override
        public Component add(Component component) {
            if (!XertoDockableFrameUI.this._isVertical || component != this._floatButton && component != this._closeButton && component != this._autohideButton && component != this._maximizeButton && component != this._gripper) {
                return super.add(component);
            }
            return null;
        }

        @Override
        protected void addSubComponents() {
            super.addSubComponents();
            if (XertoDockableFrameUI.this._isVertical) {
                if (this._title instanceof JLabel) {
                    ((JLabel)this._title).setUI(new VerticalLabelUI(false));
                    ((JLabel)this._title).setHorizontalAlignment(0);
                }
                if (this._frame.isActive()) {
                    this._title.setForeground(this._selectedTextColor);
                } else {
                    this._title.setForeground(this._notSelectedTextColor);
                }
                this.updateButtonsPanel();
            }
        }

        @Override
        protected void enableButton(AbstractButton abstractButton, boolean bl) {
            super.enableButton(abstractButton, bl);
            if (XertoDockableFrameUI.this._isVertical) {
                if (abstractButton == this._closeButton) {
                    this._hideBtn.setVisible(bl);
                }
                if (abstractButton == this._autohideButton) {
                    this._autoHideBtn.setVisible(bl);
                }
                if (abstractButton == this._floatButton) {
                    this._floatBtn.setVisible(bl);
                }
                this.updateButtonsPanel();
            }
        }

        @Override
        protected AbstractButton createTitleBarButton() {
            return new XertoNoFocusButton();
        }

        public class XertoNoFocusButton
        extends BasicDockableFrameTitlePane.NoFocusButton
        implements MouseMotionListener,
        MouseListener {
            private int _type;
            private boolean _mouseOver = false;
            private boolean _mousePressed = false;

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFocusPainted(false);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorder(null);
            }

            public XertoNoFocusButton() {
                this.setOpaque(false);
                this.setContentAreaFilled(false);
                this.addMouseMotionListener(this);
                this.addMouseListener(this);
            }

            public XertoNoFocusButton(Action action) {
                this();
                this.setAction(action);
                this._type = 100;
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                if (this._type != 101 || this.isEnabled()) {
                    if (this._mouseOver && this._mousePressed) {
                        graphics.setColor(new Color(0, 0, 0, 50));
                        graphics.fillRoundRect(0, 1, this.getWidth(), this.getHeight() - 2, 3, 3);
                        graphics.setColor(new Color(0, 0, 0, 25));
                        graphics.drawRoundRect(0, 1, this.getWidth() - 1, this.getHeight() - 3, 2, 2);
                    } else if (this._mouseOver) {
                        graphics.setColor(new Color(0, 0, 0, 50));
                        graphics.fillRoundRect(0, 1, this.getWidth(), this.getHeight() - 2, 3, 3);
                    }
                }
                Color color = XertoDockableFrameTitlePane.this._frame.isActive() ? XertoDockableFrameTitlePane.this._selectedTextColor : XertoDockableFrameTitlePane.this._notSelectedTextColor;
                Icon icon = null;
                int n = 0;
                int n2 = 0;
                switch (this._type) {
                    case 100: 
                    case 101: {
                        icon = (Icon)this.getAction().getValue("SmallIcon");
                        int n3 = icon.getIconWidth() / 2;
                        int n4 = icon.getIconHeight() / 2;
                        n = this.getWidth() / 2 - n3;
                        n2 = this.getHeight() / 2 - n4;
                        if (this._type != 101 || this.isEnabled() || !(icon instanceof ImageIcon)) break;
                        icon = IconsFactory.createGrayImage(((ImageIcon)icon).getImage());
                        break;
                    }
                    case 0: {
                        icon = XertoDockableFrameTitlePane.this._closeIcon;
                        int n5 = icon.getIconWidth() / 2;
                        int n6 = icon.getIconHeight() / 2;
                        n = this.getWidth() / 2 - n5;
                        n2 = this.getHeight() / 2 - n6;
                        break;
                    }
                    case 7: {
                        icon = XertoDockableFrameTitlePane.this._hideAutohideIcon;
                        int n7 = icon.getIconWidth() / 2;
                        int n8 = icon.getIconHeight() / 2;
                        n = this.getWidth() / 2 - n7;
                        n2 = this.getHeight() / 2 - n8;
                        break;
                    }
                    case 1: {
                        icon = XertoDockableFrameTitlePane.this._autohideIcon;
                        int n9 = icon.getIconWidth() / 2;
                        int n10 = icon.getIconHeight() / 2;
                        n = this.getWidth() / 2 - n9;
                        n2 = this.getHeight() / 2 - n10;
                        break;
                    }
                    case 2: {
                        icon = XertoDockableFrameTitlePane.this._stopAutohideIcon;
                        int n11 = icon.getIconWidth() / 2;
                        int n12 = icon.getIconHeight() / 2;
                        n = this.getWidth() / 2 - n11;
                        n2 = this.getHeight() / 2 - n12;
                        break;
                    }
                    case 3: {
                        icon = XertoDockableFrameTitlePane.this._floatIcon;
                        int n13 = icon.getIconWidth() / 2;
                        int n14 = icon.getIconHeight() / 2;
                        n = this.getWidth() / 2 - n13;
                        n2 = this.getHeight() / 2 - n14;
                        break;
                    }
                    case 4: {
                        icon = XertoDockableFrameTitlePane.this._unfloatIcon;
                        int n15 = icon.getIconWidth() / 2;
                        int n16 = icon.getIconHeight() / 2;
                        n = this.getWidth() / 2 - n15;
                        n2 = this.getHeight() / 2 - n16;
                        break;
                    }
                    case 5: {
                        icon = XertoDockableFrameTitlePane.this._maximizeIcon;
                        int n17 = icon.getIconWidth() / 2;
                        int n18 = icon.getIconHeight() / 2;
                        n = this.getWidth() / 2 - n17;
                        n2 = this.getHeight() / 2 - n18;
                        break;
                    }
                    case 6: {
                        icon = XertoDockableFrameTitlePane.this._restoreIcon;
                        int n19 = icon.getIconWidth() / 2;
                        int n20 = icon.getIconHeight() / 2;
                        n = this.getWidth() / 2 - n19;
                        n2 = this.getHeight() / 2 - n20;
                    }
                }
                if (icon != null) {
                    if (icon instanceof ImageIcon) {
                        new ImageIcon(MaskFilter.createImage(((ImageIcon)icon).getImage(), Color.black, color)).paintIcon(this, graphics, n, n2);
                    } else {
                        icon.paintIcon(this, graphics, n, n2);
                    }
                }
            }

            @Override
            public boolean isFocusable() {
                return false;
            }

            @Override
            public void requestFocus() {
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                JideSwingUtilities.retargetMouseEvent(506, mouseEvent, XertoDockableFrameTitlePane.this._frame);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this._mouseOver = true;
                this.repaint();
                JideSwingUtilities.retargetMouseEvent(503, mouseEvent, XertoDockableFrameTitlePane.this._frame);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this._mousePressed = false;
                this._mouseOver = false;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this._mousePressed = true;
                this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this._mousePressed = false;
                this._mouseOver = false;
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this._mouseOver = true;
                this.repaint();
                JideSwingUtilities.retargetMouseEvent(504, mouseEvent, XertoDockableFrameTitlePane.this._frame);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this._mouseOver = false;
                this._mousePressed = false;
                this.repaint();
                JideSwingUtilities.retargetMouseEvent(504, mouseEvent, XertoDockableFrameTitlePane.this._frame);
            }

            @Override
            public int getType() {
                return this._type;
            }

            @Override
            public void setType(int n) {
                this._type = n;
            }
        }
    }
}

