/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.GroupTableHeader;
import com.jidesoft.grid.GroupableTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortableTableHeader;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableHeaderCellDecorator;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.plaf.GroupTableHeaderUIDelegate;
import com.jidesoft.plaf.basic.BasicAutoFilterTableHeaderUIDelegate;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import com.jidesoft.utils.PortingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class BasicGroupTableHeaderUIDelegate
extends BasicAutoFilterTableHeaderUIDelegate
implements GroupTableHeaderUIDelegate {
    private StyledLabel[] _groupColumnStyledLabels;
    private int[] _groupColumnHeights;
    private int[] _columnWidths;
    private static final String CLIENT_PROPERTY_PAINTING_GROUP_COLUMN_INDEX = "TableHeaderUIDelegate.paintingGroupColumnIndex";
    private static final String CLIENT_PROPERTY_MOUSEOVER_GROUP_COLUMN_INDEX = "TableHeaderUIDelegate.mouseoverGroupColumnIndex";
    private static final String CLIENT_PROPERTY_POPUP_GROUP_COLUMN_INDEX = "TableHeaderUIDelegate.popupGroupColumnIndex";
    public static final int GROUP_COLUMN_RESERVED = -2;

    public BasicGroupTableHeaderUIDelegate(JTableHeader jTableHeader, CellRendererPane cellRendererPane) {
        super(jTableHeader, cellRendererPane);
    }

    protected void paintGroupAreaBackground(Graphics graphics) {
        if (((GroupTableHeader)this._header).getGroupAreaBackground() == null) {
            return;
        }
        Color color = graphics.getColor();
        int n = this.getLeftMargin();
        int n2 = ((GroupTableHeader)this._header).getMargin().top;
        int n3 = ((GroupTableHeader)this._header).getActualHeaderY() - ((GroupTableHeader)this._header).getMargin().bottom - n2;
        int n4 = this._header.getWidth() - n - this.getRightMargin();
        graphics.setColor(((GroupTableHeader)this._header).getGroupAreaBackground());
        graphics.fillRect(n, n2, n4, n3);
        graphics.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (!(this._header instanceof GroupTableHeader) || !((GroupTableHeader)this._header).isGroupHeaderEnabled()) {
            return;
        }
        this._header.putClientProperty("TableHeaderUIDelegate.filterCellDecoratorProperties", this.getFilterCellDecoratorProperties());
        try {
            int n;
            this.paintGroupAreaBackground(graphics);
            boolean bl = this._header.getComponentOrientation().isLeftToRight();
            GroupModelProvider groupModelProvider = (GroupModelProvider)((Object)TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), GroupModelProvider.class));
            if (!(groupModelProvider instanceof TableModelWrapper)) {
                return;
            }
            if (this._columnWidths == null) {
                this.buildColumnWidthCache();
            }
            int n2 = this.getLeftMargin();
            int n3 = ((GroupTableHeader)this._header).getMargin().top;
            int n4 = groupModelProvider.getGroupColumnCount();
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                int n5 = groupModelProvider.getGroupColumnAt(i);
                n = ((GroupTableHeader)this._header).getRollOverGroupColumn() == i ? 1 : 0;
                int n6 = n2;
                if (!bl) {
                    n6 = this._header.getWidth() - n2;
                }
                int n7 = this.getActualModelPreferredWidth(n5);
                Rectangle rectangle = new Rectangle(n6, n3, n7, this.getGroupColumnPreferredHeight(i));
                if (!bl) {
                    rectangle.x -= rectangle.width;
                }
                this.paintGroupCell(graphics, rectangle, i, ((TableModelWrapper)((Object)groupModelProvider)).getActualModel().getColumnName(n5), n != 0, n != 0);
                if (i < n4 - 1 && ((GroupTableHeader)this._header).isConnectionLineVisible()) {
                    this.drawConnectionLine(graphics, rectangle);
                }
                nArray[i] = n7 = rectangle.width + ((GroupTableHeader)this._header).getMargin().left + ((GroupTableHeader)this._header).getMargin().right;
                n2 += n7;
                n3 += this.getGroupColumnPreferredHeight(i);
                if (i >= n4 - 1) continue;
                n3 -= this.getActualVerticalIndention(i + 1);
            }
            ((GroupTableHeader)this._header).setGroupedWidths(nArray);
            if (n4 == 0) {
                Color color = graphics.getColor();
                Font font = graphics.getFont();
                if (((GroupTableHeader)this._header).getLabelFont() != null) {
                    graphics.setFont(((GroupTableHeader)this._header).getLabelFont());
                }
                graphics.setColor(((GroupTableHeader)this._header).getGroupAreaForeground());
                n = 5;
                String string = ((GroupTableHeader)this._header).getResourceString("GroupTable.dragColumns");
                if (!bl) {
                    n = this._header.getWidth() - SwingUtilities.computeStringWidth(graphics.getFontMetrics(), string) - n;
                }
                graphics.drawString(string, n, ((GroupTableHeader)this._header).getActualHeaderY() - 5 - ((GroupTableHeader)this._header).getMargin().bottom);
                graphics.setColor(color);
                graphics.setFont(font);
            }
        }
        finally {
            this._header.putClientProperty("TableHeaderUIDelegate.filterCellDecoratorProperties", null);
        }
    }

    protected void paintGroupCell(Graphics graphics, Rectangle rectangle, int n, Object object, boolean bl, boolean bl2) {
        this.paintGroupCell(graphics, rectangle, n, object, bl, bl2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintGroupCell(Graphics graphics, Rectangle rectangle, int n, Object object, boolean bl, boolean bl2, boolean bl3) {
        this._header.putClientProperty(CLIENT_PROPERTY_PAINTING_GROUP_COLUMN_INDEX, n);
        this._header.putClientProperty("TableHeaderUIDelegate.cellDecoratorProperties", new Object[]{bl, bl2});
        try {
            Object object2;
            Insets insets;
            Object object3;
            Component component = this._header.getDefaultRenderer().getTableCellRendererComponent(this._header.getTable(), object, bl, bl2, 0, -2);
            component.setEnabled(this._header.isEnabled());
            component.applyComponentOrientation(this._header.getComponentOrientation());
            Insets insets2 = this.getBorderInsets(graphics, -2 - n, rectangle);
            JPanel jPanel = null;
            if (insets2 != null) {
                object3 = ((JComponent)component).getBorder();
                TableHeaderCellDecorator[] tableHeaderCellDecoratorArray = this.createMarginBorder(insets2, (Border)object3);
                ((JComponent)component).setBorder((Border)tableHeaderCellDecoratorArray);
                if (((JComponent)component).getBorder() != tableHeaderCellDecoratorArray) {
                    jPanel = new JPanel(new BorderLayout());
                    jPanel.add(component);
                    jPanel.setBorder(BorderFactory.createEmptyBorder(insets2.top, insets2.left, insets2.bottom, insets2.right));
                }
            }
            if (this._groupColumnStyledLabels != null && n < this._groupColumnStyledLabels.length && this._groupColumnStyledLabels[n] != null && component instanceof JLabel) {
                ((JLabel)component).setText("");
            }
            if (jPanel != null) {
                this.customizeRendererComponent(jPanel, -1, -1, rectangle);
                this._rendererPane.paintComponent(graphics, jPanel, this._header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                this._rendererPane.remove(jPanel);
                this.releaseRendererComponent(jPanel, -1, -1, rectangle);
            } else {
                this.customizeRendererComponent(component, -1, -1, rectangle);
                this._rendererPane.paintComponent(graphics, component, this._header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
                this._rendererPane.remove(component);
                this.releaseRendererComponent(component, -1, -1, rectangle);
            }
            if (this._groupColumnStyledLabels != null && n < this._groupColumnStyledLabels.length && this._groupColumnStyledLabels[n] != null && component instanceof JLabel) {
                object3 = this._groupColumnStyledLabels[n];
                int n2 = rectangle.x;
                int n3 = rectangle.y;
                int n4 = rectangle.width;
                int n5 = rectangle.height;
                insets = null;
                object2 = ((JLabel)component).getBorder();
                if (object2 != null) {
                    insets = object2.getBorderInsets(component);
                }
                if (insets != null) {
                    n3 += insets.top;
                    n5 -= insets.top + insets.bottom;
                    n4 -= insets.left + insets.right;
                    n2 = this._header.getComponentOrientation().isLeftToRight() ? (n2 += insets.left) : (n2 += insets.right);
                }
                ((JComponent)object3).setOpaque(false);
                this.configureStyledLabel(component, (StyledLabel)object3);
                ((Component)object3).setSize(n4, n5);
                this.customizeRendererComponent((Component)object3, -1, -1, new Rectangle(n2, n3, n4, n5));
                int n6 = ((StyledLabel)object3).getPreferredWidth();
                try {
                    ((StyledLabel)object3).setPreferredWidth(n4);
                    this._rendererPane.paintComponent(graphics, (Component)object3, this._header, n2, n3, n4, n5);
                    this._rendererPane.remove((Component)object3);
                }
                finally {
                    ((StyledLabel)object3).setPreferredWidth(n6);
                }
                this.releaseRendererComponent((Component)object3, -1, -1, new Rectangle(n2, n3, n4, n5));
            }
            if (this._header instanceof SortableTableHeader && bl3) {
                object3 = new Rectangle(rectangle);
                for (TableHeaderCellDecorator tableHeaderCellDecorator : ((SortableTableHeader)this._header).getCellDecorators()) {
                    if (tableHeaderCellDecorator == null) continue;
                    insets = tableHeaderCellDecorator.getInsets(graphics, this._header, -2 - n, (Rectangle)object3);
                    object2 = insets == null ? new Rectangle(rectangle) : new Rectangle((Rectangle)object3);
                    tableHeaderCellDecorator.paint(graphics, this._header, -2 - n, (Rectangle)object2, this.isMouseOverPaintArea(this._currentMousePoint, (Rectangle)object2, insets));
                    object3 = this.adjustPaintCellRect((Rectangle)object3, insets);
                }
            }
        }
        finally {
            this._header.putClientProperty(CLIENT_PROPERTY_PAINTING_GROUP_COLUMN_INDEX, null);
            this._header.putClientProperty("TableHeaderUIDelegate.cellDecoratorProperties", null);
        }
    }

    private int getLeftMargin() {
        if (this._header instanceof GroupTableHeader) {
            boolean bl = this._header.getComponentOrientation().isLeftToRight();
            return bl ? ((GroupTableHeader)this._header).getMargin().left : ((GroupTableHeader)this._header).getMargin().right;
        }
        return 0;
    }

    private int getRightMargin() {
        if (this._header instanceof GroupTableHeader) {
            boolean bl = this._header.getComponentOrientation().isLeftToRight();
            return bl ? ((GroupTableHeader)this._header).getMargin().right : ((GroupTableHeader)this._header).getMargin().left;
        }
        return 0;
    }

    private int getActualVerticalIndention(int n) {
        if (((GroupTableHeader)this._header).getVerticalIndention() < 0) {
            return this.getGroupColumnPreferredHeight(n) / 2;
        }
        return this.getGroupColumnPreferredHeight(n) - ((GroupTableHeader)this._header).getVerticalIndention();
    }

    private Color getConnectLineColor() {
        Color color = UIManager.getColor("GroupTableHeader.lineColor");
        if (color == null) {
            color = Color.GRAY;
        }
        return color;
    }

    protected void drawConnectionLine(Graphics graphics, Rectangle rectangle) {
        if (!(this._header instanceof GroupTableHeader) || ((GroupTableHeader)this._header).getVerticalIndention() < 2 && ((GroupTableHeader)this._header).getVerticalIndention() >= 0) {
            return;
        }
        Color color = this.getConnectLineColor();
        Color color2 = graphics.getColor();
        if (color != null) {
            graphics.setColor(color);
        }
        if (this._header.getComponentOrientation().isLeftToRight()) {
            graphics.drawLine(rectangle.x + rectangle.width - 6, rectangle.y + rectangle.height, rectangle.x + rectangle.width - 6, rectangle.y + rectangle.height + 2);
            graphics.drawLine(rectangle.x + rectangle.width - 6, rectangle.y + rectangle.height + 2, rectangle.x + rectangle.width + ((GroupTableHeader)this._header).getMargin().left, rectangle.y + rectangle.height + 2);
        } else {
            graphics.drawLine(rectangle.x + 6, rectangle.y + rectangle.height, rectangle.x + 6, rectangle.y + rectangle.height + 2);
            graphics.drawLine(rectangle.x + 6, rectangle.y + rectangle.height + 2, rectangle.x - ((GroupTableHeader)this._header).getMargin().left, rectangle.y + rectangle.height + 2);
        }
        graphics.setColor(color2);
    }

    private void buildGroupColumnStyledLabelCache(GroupModelProvider groupModelProvider) {
        this._groupColumnStyledLabels = null;
        if (this._header.getTable() == null || this._header.getTable().getModel() == null || !(groupModelProvider instanceof TableModelWrapper)) {
            this._groupColumnStyledLabels = new StyledLabel[0];
            return;
        }
        int n = groupModelProvider.getGroupColumnCount();
        TableModel tableModel = ((TableModelWrapper)((Object)groupModelProvider)).getActualModel();
        this._groupColumnStyledLabels = new StyledLabel[n];
        for (int i = 0; i < n; ++i) {
            StyledLabel styledLabel;
            String string;
            int n2 = groupModelProvider.getGroupColumnAt(i);
            if (n2 < 0 || n2 >= tableModel.getColumnCount() || (string = tableModel.getColumnName(n2)) == null || JideSwingUtilities.equals(string, (styledLabel = StyledLabelBuilder.createStyledLabel(string)).getText())) continue;
            this._groupColumnStyledLabels[i] = styledLabel;
        }
    }

    public int getActualHeaderHeight() {
        return super.getPreferredSize((JComponent)this._header).height;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        TableModel tableModel;
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this._header instanceof GroupTableHeader && this._header.getTable() != null && ((GroupTableHeader)this._header).isGroupHeaderEnabled() && (tableModel = TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), GroupModelProvider.class)) instanceof GroupModelProvider && dimension.height > 0) {
            Insets insets = ((GroupTableHeader)this._header).getMargin();
            dimension.height += insets.top + insets.bottom;
            int n = ((GroupModelProvider)((Object)tableModel)).getGroupColumnCount();
            if (n >= 1) {
                dimension.height += this.getGroupColumnPreferredHeight(0);
                for (int i = 1; i < n; ++i) {
                    dimension.height += this.getGroupColumnPreferredHeight(i) - this.getActualVerticalIndention(i);
                }
            } else {
                dimension.height = dimension.height + (((GroupTableHeader)this._header).getLabelHeight() <= 0 ? dimension.height : ((GroupTableHeader)this._header).getLabelHeight());
            }
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getGroupColumnPreferredHeight(int n) {
        TableCellRenderer tableCellRenderer;
        if (this._header == null || this._header.getTable() == null) {
            return -1;
        }
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), GroupModelProvider.class);
        if (!(tableModel instanceof GroupModelProvider) || !(tableModel instanceof TableModelWrapper)) {
            return -1;
        }
        int n2 = ((GroupModelProvider)((Object)tableModel)).getGroupColumnCount();
        if (this._groupColumnHeights == null || this._groupColumnHeights.length != n2) {
            this._groupColumnHeights = new int[n2];
            Arrays.fill(this._groupColumnHeights, -1);
        }
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this._groupColumnHeights[n] >= 0) {
            return this._groupColumnHeights[n];
        }
        if (this._groupColumnStyledLabels == null || n >= this._groupColumnStyledLabels.length) {
            this.buildGroupColumnStyledLabelCache((GroupModelProvider)((Object)tableModel));
        }
        if ((tableCellRenderer = this._header.getDefaultRenderer()) != null) {
            StyledLabel styledLabel;
            int n3 = ((GroupModelProvider)((Object)tableModel)).getGroupColumnAt(n);
            if (n3 < 0 || n3 >= ((TableModelWrapper)((Object)tableModel)).getActualModel().getColumnCount()) {
                return -1;
            }
            Component component = tableCellRenderer.getTableCellRendererComponent(this._header.getTable(), ((TableModelWrapper)((Object)tableModel)).getActualModel().getColumnName(n3), false, false, 0, -2);
            Dimension dimension = component.getPreferredSize();
            if (this._groupColumnStyledLabels != null && n < this._groupColumnStyledLabels.length && n >= 0 && (styledLabel = this._groupColumnStyledLabels[n]) != null && component instanceof JLabel) {
                int n4 = this.getActualModelPreferredWidth(n3);
                Border border = ((JComponent)component).getBorder();
                Insets insets = border != null ? border.getBorderInsets(component) : UIManager.getInsets("TableHeader.DefaultRendererInsets");
                if (insets != null) {
                    n4 -= insets.left + insets.right;
                }
                int n5 = styledLabel.getPreferredWidth();
                try {
                    this.configureStyledLabel(component, styledLabel);
                    styledLabel.setPreferredWidth(n4);
                    styledLabel.setSize(new Dimension(n4, 0));
                    dimension = styledLabel.getPreferredSize();
                }
                finally {
                    styledLabel.setPreferredWidth(n5);
                }
                if (insets != null) {
                    dimension.height += insets.top + insets.bottom;
                }
            }
            this._groupColumnHeights[n] = dimension.height;
            return dimension.height;
        }
        return this._groupColumnHeights[n];
    }

    @Override
    public int getActualModelPreferredWidth(int n) {
        if (this._columnWidths == null) {
            this.buildColumnWidthCache();
        }
        return this._columnWidths == null || n >= this._columnWidths.length || n < 0 ? 75 : this._columnWidths[n];
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if ((tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) && (!(tableModelEvent instanceof CompoundTableModelEvent) || ((CompoundTableModelEvent)tableModelEvent).isOriginalChanged())) {
            this.clearColumnWidthCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildColumnWidthCache() {
        if (this._header == null || this._header.getTable() == null) {
            return;
        }
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), GroupModelProvider.class);
        if (tableModel instanceof GroupModelProvider && tableModel instanceof TableModelWrapper) {
            TableModel tableModel2 = ((TableModelWrapper)((Object)tableModel)).getActualModel();
            if (this._columnWidths == null || this._columnWidths.length != tableModel2.getColumnCount()) {
                this._columnWidths = new int[tableModel2.getColumnCount()];
                Arrays.fill(this._columnWidths, 75);
            }
            for (int i = 0; i < this._columnWidths.length; ++i) {
                int n;
                int n2 = TableModelWrapperUtils.getColumnAt(this._header.getTable().getModel(), tableModel2, i);
                if (n2 >= 0) {
                    n = this._header.getTable().convertColumnIndexToView(n2);
                    if (n < 0 || n >= this._header.getColumnModel().getColumnCount()) continue;
                    this._columnWidths[i] = this._header.getColumnModel().getColumn(n).getWidth();
                    continue;
                }
                n = ((GroupModelProvider)((Object)tableModel)).getGroupColumnCount();
                int n3 = -1;
                for (int j = 0; j < n; ++j) {
                    if (((GroupModelProvider)((Object)tableModel)).getGroupColumnAt(j) != i) continue;
                    n3 = j;
                    break;
                }
                if (n3 < 0) continue;
                this._header.putClientProperty(CLIENT_PROPERTY_PAINTING_GROUP_COLUMN_INDEX, n3);
                try {
                    TableCellRenderer tableCellRenderer = this._header.getDefaultRenderer();
                    if (tableCellRenderer == null) continue;
                    JTable jTable = this._header.getTable();
                    Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableModel2.getColumnName(i), false, false, -1, -1);
                    int n4 = component.getPreferredSize().width + jTable.getIntercellSpacing().width;
                    if (this._header instanceof SortableTableHeader) {
                        TableHeaderCellDecorator[] tableHeaderCellDecoratorArray;
                        for (TableHeaderCellDecorator tableHeaderCellDecorator : tableHeaderCellDecoratorArray = ((SortableTableHeader)this._header).getCellDecorators()) {
                            Insets insets = tableHeaderCellDecorator.getInsets(null, this._header, -2 - n3, new Rectangle());
                            if (insets == null) continue;
                            n4 += insets.left + insets.right;
                        }
                    }
                    if (n4 < this._columnWidths[i]) continue;
                    this._columnWidths[i] = n4;
                    continue;
                }
                finally {
                    this._header.putClientProperty(CLIENT_PROPERTY_PAINTING_GROUP_COLUMN_INDEX, null);
                }
            }
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        super.columnAdded(tableColumnModelEvent);
        this.clearColumnWidthCache();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnRemoved(tableColumnModelEvent);
        this.clearColumnWidthCache();
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        super.columnMarginChanged(changeEvent);
        this.clearColumnWidthCache();
    }

    private void clearColumnWidthCache() {
        this._columnWidths = null;
    }

    @Override
    void clearStyledLabelCache() {
        super.clearStyledLabelCache();
        this._groupColumnStyledLabels = null;
    }

    @Override
    void clearHeightsCache(boolean bl, boolean bl2) {
        super.clearHeightsCache(bl, bl2);
        if (this._groupColumnHeights != null) {
            if (!bl2 || this._groupColumnStyledLabels == null || this._groupColumnStyledLabels.length != this._groupColumnHeights.length) {
                this._groupColumnHeights = null;
            } else {
                for (int i = 0; i < this._groupColumnStyledLabels.length; ++i) {
                    if (this._groupColumnStyledLabels[i] == null) continue;
                    this._groupColumnHeights[i] = -1;
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        if (!(this._header instanceof GroupTableHeader) || !((GroupTableHeader)this._header).isGroupHeaderEnabled() || this._header.getTable() == null) {
            return;
        }
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), GroupModelProvider.class);
        if (tableModel == null) {
            return;
        }
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, FilterableTableModel.class);
        if (tableModel2 != null) {
            this._header.putClientProperty(CLIENT_PROPERTY_MOUSEOVER_GROUP_COLUMN_INDEX, ((GroupTableHeader)this._header).groupedColumnAtPoint(mouseEvent.getPoint()));
            this._header.invalidate();
            this._header.repaint();
        }
    }

    @Override
    protected boolean mouseOverFilterButton(Point point) {
        boolean bl = super.mouseOverFilterButton(point);
        if (bl) {
            return true;
        }
        Object object = this._header.getClientProperty(CLIENT_PROPERTY_MOUSEOVER_GROUP_COLUMN_INDEX);
        if (object instanceof Integer && this._header instanceof GroupTableHeader) {
            int n = (Integer)object;
            if (n < 0) {
                return false;
            }
            Rectangle rectangle = ((GroupTableHeader)this._header).getGroupedHeaderRect(n);
            TableHeaderCellDecorator tableHeaderCellDecorator = ((AutoFilterTableHeader)this._header).getFilterableTableHeaderCellDecorator();
            Insets insets = tableHeaderCellDecorator.getInsets(null, this._header, -2 - n, rectangle);
            if (insets != null) {
                int n2;
                int n3 = this._header.getComponentOrientation().isLeftToRight() ? insets.left : insets.right;
                int n4 = n2 = this._header.getComponentOrientation().isLeftToRight() ? insets.right : insets.left;
                if (this._header.getComponentOrientation().isLeftToRight()) {
                    return point.x >= rectangle.x + rectangle.width - n2 && point.x < rectangle.x + rectangle.width && point.y >= rectangle.y && point.y < rectangle.y + rectangle.height;
                }
                return point.x >= rectangle.x && point.x < rectangle.x + n3 && point.y >= rectangle.y && point.y < rectangle.y + rectangle.height;
            }
        }
        return false;
    }

    @Override
    Comparator preparePopupFields() {
        GroupModelProvider groupModelProvider;
        if (this._mouseOverColumn >= 0) {
            return super.preparePopupFields();
        }
        Object object = this._header.getClientProperty(CLIENT_PROPERTY_MOUSEOVER_GROUP_COLUMN_INDEX);
        if (object instanceof Integer) {
            this._popupColumnIndex = -2 - (Integer)object;
        }
        if (!((groupModelProvider = (GroupModelProvider)((Object)TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), GroupModelProvider.class))) instanceof TableModel) || !(groupModelProvider instanceof TableModelWrapper)) {
            return null;
        }
        int n = groupModelProvider.getGroupColumnAt((Integer)object);
        this._filterableTableModel = (IFilterableTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)((Object)groupModelProvider), IFilterableTableModel.class);
        this._filterableTableModelColumnIndex = TableModelWrapperUtils.getActualColumnAt(((TableModelWrapper)((Object)groupModelProvider)).getActualModel(), n, this._filterableTableModel);
        this._groupableTableModel = (GroupableTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)((Object)groupModelProvider), GroupableTableModel.class);
        this._groupableTableModelColumnIndex = n;
        this._actualTableModel = TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel());
        this._actualTableModelColumnIndex = TableModelWrapperUtils.getActualColumnAt((TableModel)((Object)groupModelProvider), n);
        int n2 = TableModelWrapperUtils.getColumnAt(this._header.getTable().getModel(), ((TableModelWrapper)((Object)groupModelProvider)).getActualModel(), n);
        Comparator comparator = null;
        if (n2 >= 0) {
            ISortableTableModel iSortableTableModel = (ISortableTableModel)TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), ISortableTableModel.class);
            int n3 = TableModelWrapperUtils.getActualColumnAt(this._header.getTable().getModel(), n2, iSortableTableModel);
            comparator = iSortableTableModel instanceof SortableTableModel ? ObjectComparatorManager.getComparator(iSortableTableModel.getColumnClass(n3), ((SortableTableModel)iSortableTableModel).getColumnComparatorContext(n3)) : ObjectComparatorManager.getComparator(this._filterableTableModel.getColumnClass(this._filterableTableModelColumnIndex));
        } else if (groupModelProvider instanceof DefaultGroupTableModel) {
            comparator = ((DefaultGroupTableModel)groupModelProvider).getComparator(n);
        }
        return comparator;
    }

    @Override
    protected Point calculatePopupLocation() {
        if (this._popupColumnIndex >= 0) {
            return super.calculatePopupLocation();
        }
        Border border = this._popup.getPopupBorder();
        int n = 0;
        int n2 = 0;
        Insets insets = null;
        if (border != null && (insets = border.getBorderInsets(this._popupPanel)) != null) {
            n = insets.left + insets.right;
            n2 = insets.top + insets.bottom;
        }
        Rectangle rectangle = ((GroupTableHeader)this._header).getGroupedHeaderRect(-2 - this._popupColumnIndex);
        Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
        SwingUtilities.convertPointToScreen(point, this._header);
        Dimension dimension = this._popupPanel.getPreferredSize();
        point.x -= dimension.width - rectangle.width + n;
        int n3 = point.y + dimension.height;
        Rectangle rectangle2 = PortingUtils.getContainingScreenBounds(new Rectangle(point, dimension), true);
        if (n3 > rectangle2.y + rectangle2.height) {
            point.y = point.y - dimension.height - rectangle.height - n2;
        }
        Rectangle rectangle3 = PortingUtils.containsInScreenBounds(this._header, new Rectangle(point, dimension));
        point.x = rectangle3.x;
        point.y = rectangle3.y;
        return point;
    }
}

