/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.filter.Filter;
import com.jidesoft.filter.InFilter;
import com.jidesoft.filter.NotInFilter;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.pivot.PivotDataSource;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TableModelPivotDataSource
implements PivotDataSource {
    private static final String NULL_VALUE = "NULL_VALUE";
    protected TableModel _originalTableModel;
    protected IFilterableTableModel _filterTableModel;
    protected IFilterableTableModel _tableModel;

    public TableModelPivotDataSource(TableModel tableModel) {
        this.setTableModel(tableModel);
    }

    public void setTableModel(TableModel tableModel) {
        this._originalTableModel = tableModel;
        this._filterTableModel = this.createFilterableTableModel(this._originalTableModel);
        this._tableModel = this.createFilterableTableModel(this._filterTableModel);
    }

    protected IFilterableTableModel createFilterableTableModel(TableModel tableModel) {
        return new FilterableTableModel(tableModel);
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public int getFieldCount() {
        return this._originalTableModel.getColumnCount();
    }

    @Override
    public String getFieldName(int n) {
        if (this._originalTableModel instanceof ColumnIdentifierTableModel) {
            return ((ColumnIdentifierTableModel)((Object)this._originalTableModel)).getColumnIdentifier(n).toString();
        }
        return this._originalTableModel.getColumnName(n);
    }

    @Override
    public String getFieldTitle(int n) {
        return this._originalTableModel.getColumnName(n);
    }

    @Override
    public Class<?> getFieldType(int n) {
        return this._originalTableModel.getColumnClass(n);
    }

    @Override
    public int getRowCount() {
        return this._tableModel.getRowCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this._tableModel.getValueAt(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this._tableModel.setValueAt(object, n, n2);
    }

    protected void updatePossibleValues(Set<Object> set, int n, int n2, int n3, boolean bl, boolean bl2) {
        if (bl) {
            Object object = this._originalTableModel.getValueAt(n2, n);
            if (object != null) {
                set.add(object);
            } else if (bl2) {
                set.add(NULL_VALUE);
            }
        } else if (n3 != -1) {
            Object object = this._filterTableModel.getValueAt(n3, n);
            if (object != null) {
                set.add(object);
            } else if (bl2) {
                set.add(NULL_VALUE);
            }
        }
    }

    @Override
    public Set<Object> getPossibleValues(int n, boolean bl, boolean bl2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        boolean bl3 = this._filterTableModel.hasFilter();
        int n2 = this._originalTableModel.getRowCount();
        for (int i = 0; i < n2; ++i) {
            if (bl3) {
                this.updatePossibleValues(hashSet, n, i, this._filterTableModel instanceof FilterableTableModel ? ((FilterableTableModel)this._filterTableModel).getVisualRowAt(i) : -1, bl, bl2);
                continue;
            }
            this.updatePossibleValues(hashSet, n, i, i, bl, bl2);
        }
        return hashSet;
    }

    @Override
    public boolean hasFilter() {
        return this._filterTableModel.getFilterItems().size() > 0 || this._tableModel.getFilterItems().size() > 0;
    }

    @Override
    public void clearFilters() {
        this._filterTableModel.clearFilters();
        this._tableModel.clearFilters();
        this._filterTableModel.setFiltersApplied(false);
        this._tableModel.setFiltersApplied(false);
    }

    @Override
    public void applyFilters() {
        this._filterTableModel.setFiltersApplied(true);
        this._tableModel.setFiltersApplied(true);
    }

    @Override
    public void applyFilters(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.applyFilters();
    }

    @Override
    public void setFilter(Object[] objectArray, int n, boolean bl) {
        this._filterTableModel.removeAllFilters(n);
        this._tableModel.removeAllFilters(n);
        if (objectArray != null) {
            if (bl) {
                this._filterTableModel.addFilter(n, new InFilter<Object>(objectArray));
            } else {
                this._tableModel.addFilter(n, new InFilter<Object>(objectArray));
            }
        }
    }

    @Override
    public void setExcludeFilter(Object[] objectArray, int n, boolean bl) {
        this._filterTableModel.removeAllFilters(n);
        this._tableModel.removeAllFilters(n);
        if (objectArray != null) {
            if (bl) {
                this._filterTableModel.addFilter(n, new NotInFilter<Object>(objectArray));
            } else {
                this._tableModel.addFilter(n, new NotInFilter<Object>(objectArray));
            }
        }
    }

    @Override
    public void setFilter(Filter filter, int n, boolean bl) {
        this._filterTableModel.removeAllFilters(n);
        this._tableModel.removeAllFilters(n);
        if (filter != null) {
            if (bl) {
                this._filterTableModel.addFilter(n, filter);
            } else {
                this._tableModel.addFilter(n, filter);
            }
        }
    }

    @Override
    public int getFilteredRowIndex(int n) {
        if (!(this._tableModel.isFiltersApplied() && this._tableModel.hasFilter() || this._filterTableModel.isFiltersApplied() && this._filterTableModel.hasFilter())) {
            return n;
        }
        return TableModelWrapperUtils.getRowAt(this._tableModel, this._originalTableModel, n);
    }

    @Override
    public int getActualRowIndex(int n) {
        return TableModelWrapperUtils.getActualRowAt((TableModel)this._tableModel, n, this._originalTableModel);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        if (this._originalTableModel instanceof AbstractTableModel) {
            TableModelListener[] tableModelListenerArray;
            for (TableModelListener tableModelListener2 : tableModelListenerArray = ((AbstractTableModel)this._originalTableModel).getTableModelListeners()) {
                this._originalTableModel.removeTableModelListener(tableModelListener2);
            }
            this._originalTableModel.addTableModelListener(tableModelListener);
            for (TableModelListener tableModelListener2 : tableModelListenerArray) {
                this._originalTableModel.addTableModelListener(tableModelListener2);
            }
            this._originalTableModel.addTableModelListener(tableModelListener);
        } else {
            this._originalTableModel.addTableModelListener(tableModelListener);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this._originalTableModel.removeTableModelListener(tableModelListener);
        this._originalTableModel.removeTableModelListener(tableModelListener);
    }
}

