/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.pivot.CompoundKey;
import com.jidesoft.pivot.CopiedExpandableValue;
import com.jidesoft.pivot.DefaultValues;
import com.jidesoft.pivot.ExpandableValue;
import com.jidesoft.pivot.SummaryValue;
import com.jidesoft.pivot.Value;
import java.util.List;

public class SummaryValues
extends DefaultValues {
    private int _summaryType = -1;

    public SummaryValues(List<Value> list) {
        super(list);
    }

    public SummaryValues(Value[] valueArray) {
        super(valueArray);
    }

    public SummaryValues(ExpandableValue expandableValue) {
        super(expandableValue);
    }

    public SummaryValues(ExpandableValue expandableValue, int n) {
        super(expandableValue);
        this._summaryType = n;
    }

    public int getSummaryType() {
        return this._summaryType;
    }

    public void setSummaryType(int n) {
        this._summaryType = n;
    }

    @Override
    public CompoundKey toCompoundKey() {
        int n = this.getCount();
        if (n > 1) {
            Value value = this.getValueAt(n - 1);
            Value value2 = this.getValueAt(n - 2);
            if (value instanceof SummaryValue && value2 instanceof CopiedExpandableValue && ((SummaryValue)value).getActualValue() == ((CopiedExpandableValue)value2).getOriginal()) {
                Object[] objectArray = new Object[n - 1];
                for (int i = 0; i < objectArray.length - 1; ++i) {
                    Value value3 = this.getValueAt(i);
                    Object object = value3.getValue();
                    objectArray[i] = object instanceof SummaryValue ? ((SummaryValue)object).getValue() : object;
                }
                objectArray[objectArray.length - 1] = value.getValue();
                return CompoundKey.newInstance(objectArray);
            }
        }
        return super.toCompoundKey();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SummaryValues summaryValues = (SummaryValues)object;
        return this._summaryType == summaryValues._summaryType;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + this._summaryType;
        return n;
    }

    @Override
    public String toString() {
        return "[SummaryValues] type: " + this._summaryType;
    }

    SummaryValues shorten() {
        Value[] valueArray = new Value[this.getCount() - 1];
        for (int i = 0; i < valueArray.length - 1; ++i) {
            valueArray[i] = this.getValueAt(i);
        }
        valueArray[valueArray.length - 1] = this.getValueAt(this.getCount() - 1);
        return new SummaryValues(valueArray);
    }
}

