/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.Field;
import com.jidesoft.grid.SummaryCalculator;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.pivot.CompoundKey;
import com.jidesoft.pivot.CornerTableModel;
import com.jidesoft.pivot.DataTableModel;
import com.jidesoft.pivot.DefaultPivotSummaryCalculator;
import com.jidesoft.pivot.DefaultValues;
import com.jidesoft.pivot.DummyValues;
import com.jidesoft.pivot.ExpandableValue;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotCellStyleProvider;
import com.jidesoft.pivot.PivotCornerCellStyleProvider;
import com.jidesoft.pivot.PivotDataCube;
import com.jidesoft.pivot.PivotDataEditingProvider;
import com.jidesoft.pivot.PivotDataSource;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotSummaryCalculator;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.PivotValueProvider;
import com.jidesoft.pivot.PivotValueProviderEvent;
import com.jidesoft.pivot.PivotValueProviderListener;
import com.jidesoft.pivot.RowIndexValue;
import com.jidesoft.pivot.RowIndexesValue;
import com.jidesoft.pivot.SummaryCalculatorFactory;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.TableModelPivotDataSource;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class PivotDataModel
implements IPivotDataModel,
PivotValueProvider {
    private static final String NULL_VALUE = "NULL_VALUE";
    protected PivotDataSource _dataSource;
    PivotField[] _fields;
    private final PivotDataCube _dataCube;
    private PropertyChangeSupport _changeSupport;
    private PivotField[] _rowFields;
    private PivotField[] _columnFields;
    private PivotField[] _dataFields;
    private PivotField[] _filterFields;
    private PivotField[] _unassignedFields;
    HeaderTableModel _rowHeaderTableModel;
    HeaderTableModel _columnHeaderTableModel;
    CornerTableModel _cornerTableModel;
    DataTableModel _dataTableModel;
    private Set<Object>[] _possibleValues;
    private boolean _alwaysColumnDataFields = false;
    private boolean _alwaysRowDataFields = false;
    private boolean _rowDataFields = false;
    private boolean _columnDataFields = true;
    private boolean _hideSingleDataField = true;
    private boolean _showGrandTotalForRow = false;
    private boolean _showGrandTotalForColumn = false;
    private boolean _displayGrandTotalFirst = false;
    private boolean _displayGrandTotalFirstForRow = false;
    private boolean _displayGrandTotalFirstForColumn = false;
    private boolean _showSummaryOnAggregate = false;
    private boolean _allowEmptyRowHeader = false;
    private boolean _allowEmptyColumnHeader = false;
    private boolean _hideExpandIconOnSingleRow = true;
    private boolean _autoUpdate = false;
    private boolean _calculated = false;
    private boolean _isAdjusting = false;
    private boolean _summaryMode = true;
    private boolean _aggregateMode = false;
    private boolean _singleValueMode = false;
    private boolean _autoSortKeys = true;
    private boolean _expandByDefault = true;
    private boolean _showSubtotalAsChild = false;
    private boolean _hideRedundantSubtotal = false;
    private int _maximumAggregatedRows = -1;
    private PivotCellStyleProvider _cellStyleProvider;
    private PivotDataEditingProvider _dataEditingProvider;
    private PivotDataEditingProvider _columnHeaderEditingProvider;
    private PivotDataEditingProvider _rowHeaderEditingProvider;
    private SummaryCalculator _summaryCalculator;
    private SummaryCalculatorFactory _summaryCalculatorFactory;
    private boolean _summaryCalculatorCreatedByFactory;
    private boolean _layoutDataFieldsFirst = false;
    private boolean _highPerformanceMode = false;
    private String _expansionStateSeparator = ".";
    private PropertyChangeListener _fieldPropertyChangeListener;
    private TableModelListener _headerTableModelListener;
    private TableModelListener _originalTableModelListener;
    private boolean _computeAffectedCellOnUpdate = false;
    protected EventListenerList listenerList = new EventListenerList();
    public static final String PROPERTY_SHOW_GRAND_TOTAL_FOR_ROW = "showGrandTotalForRow";
    public static final String PROPERTY_SHOW_GRAND_TOTAL_FOR_COLUMN = "showGrandTotalForColumn";
    public static final String PROPERTY_HIDE_REDUNDANT_SUBTOTAL = "hideRedundantSubtotal";
    public static final String PROPERTY_SHOW_SUBTOTAL_AS_CHILD = "showSubtotalAsChild";
    public static final String PROPERTY_HIDE_SINGLE_DATA_FIELD = "hideSingleDataField";
    static final String ADJUST_ROW_FIELDS_WIDTH = "layoutDataFieldsFirstFlagChanged";
    private static final Logger LOGGER_EVENT;
    private List<Values> _impactedKeys = null;
    private Set<Values> _impactedRowKeys;
    private Set<Values> _impactedColumnKeys;
    private Map<String, Boolean> _rowExpansion;
    private Map<String, Boolean> _columnExpansion;
    private boolean _originalDataUpdate;
    private Map<Integer, Map<Values, Map<Values, Object>>> _sortingValuesMap;
    private static boolean _valueImmutable;
    private static boolean _useComparable;
    private RowMerger _rowMerger;
    private Set<Values> _hiddenRowValues;
    private Set<Values> _hiddenColumnValues;
    private boolean _hideSummaryValues = true;
    private Map<Values, Map<PivotField, String>> _hiddenColumns;
    private Map<Values, Map<PivotField, String>> _hiddenRows;
    private List<Values> _filteredRowValues;
    private List<Values> _fitleredColumnValues;
    private boolean _keepRowChildrenOnSummaryFilter = true;
    private boolean _summaryLayer = true;

    public PivotDataModel() {
        this._dataCube = this.createPivotDataCube();
    }

    public PivotDataModel(TableModel tableModel) {
        this._dataCube = this.createPivotDataCube();
        this.setOriginalTableModel(tableModel);
    }

    public PivotDataModel(PivotDataSource pivotDataSource) {
        this._dataCube = this.createPivotDataCube();
        this.setDataSource(pivotDataSource);
    }

    protected PivotDataCube createPivotDataCube() {
        return new PivotDataCube();
    }

    @Override
    public void initialize() {
        this.removeExistingPivotFieldPropertyChangeListeners();
        Map<String, PivotField> map = Collections.synchronizedMap(new HashMap());
        if (this._fields != null) {
            for (PivotField object : this._fields) {
                map.put(object.getName(), object);
            }
        }
        this._fields = new PivotField[this.getDataSource().getFieldCount()];
        for (int i = 0; i < this._fields.length; ++i) {
            String string = this.getDataSource().getFieldName(i);
            PivotField pivotField = (PivotField)map.get(string);
            if (pivotField != null) {
                this._fields[i] = pivotField;
                map.remove(string);
                this._fields[i].updateFromDataSource(this.getDataSource(), i, false);
            } else {
                String string2;
                this._fields[i] = this.createPivotField(this.getDataSource(), i);
                String string3 = string2 = this._fields[i].getName();
                boolean bl = true;
                int n = 1;
                block2: while (bl) {
                    bl = false;
                    for (int j = 0; j < i; ++j) {
                        if (!string3.equals(this._fields[j].getName())) continue;
                        string3 = string2 + n;
                        ++n;
                        bl = true;
                        continue block2;
                    }
                }
                if (!JideSwingUtilities.equals(string2, string3)) {
                    this._fields[i].setName(string3);
                }
            }
            int[] nArray = this.getSummaryCalculator().getAllowedSummaries(this._fields[i].getType(), this._fields[i].getConverterContext());
            if (this._fields[i].getSummaryType() < 0 || Arrays.binarySearch(nArray, this._fields[i].getSummaryType()) != -1) continue;
            if (nArray.length > 0) {
                this._fields[i].setSummaryType(nArray[0]);
                continue;
            }
            this._fields[i].setSummaryType(-2);
        }
    }

    public void setOriginalTableModel(TableModel tableModel) {
        if (this._originalTableModelListener == null) {
            this._originalTableModelListener = this.createAutoUpdateTableModelListener();
        }
        if (this.getDataSource() != null) {
            this.getDataSource().removeTableModelListener(this._originalTableModelListener);
            if (tableModel == null) {
                return;
            }
            if (this.getDataSource() instanceof TableModelPivotDataSource) {
                ((TableModelPivotDataSource)this.getDataSource()).setTableModel(tableModel);
            }
        } else {
            if (tableModel == null) {
                throw new IllegalArgumentException("When first initialization, the table model should not be null.");
            }
            this._dataSource = this.createDefaultPivotDataSource(tableModel);
        }
        this.getDataSource().addTableModelListener(this._originalTableModelListener);
        this.initialize();
    }

    protected TableModelPivotDataSource createDefaultPivotDataSource(TableModel tableModel) {
        return new TableModelPivotDataSource(tableModel);
    }

    @Override
    public void setDataSource(PivotDataSource pivotDataSource) {
        if (this._originalTableModelListener == null) {
            this._originalTableModelListener = this.createAutoUpdateTableModelListener();
        }
        if (this.getDataSource() != null) {
            this.getDataSource().removeTableModelListener(this._originalTableModelListener);
        }
        this._dataSource = pivotDataSource;
        if (this.getDataSource() != null) {
            this.getDataSource().addTableModelListener(this._originalTableModelListener);
        }
        this.initialize();
    }

    private TableModelListener createAutoUpdateTableModelListener() {
        return new TableModelListener(){
            TableModelEvent _savedEvent = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (!PivotDataModel.this.isAutoUpdate()) {
                    return;
                }
                switch (tableModelEvent.getType()) {
                    case 1: {
                        if (this._savedEvent == null) break;
                        PivotDataModel.this.firePivotValueProviderChanged(1, PivotDataModel.this.isComputeAffectedCellOnUpdate() ? "doNotCacheAllValue" : null);
                        PivotDataCube pivotDataCube = PivotDataModel.this._dataCube;
                        synchronized (pivotDataCube) {
                            PivotDataModel.this._dataCube.clearEmptyValues();
                        }
                        PivotDataModel.this._impactedKeys = null;
                        if (PivotDataModel.this.tableRowsInserted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                            PivotDataModel.this.firePivotValueProviderChanged(2, PivotDataModel.this._impactedKeys == null ? Integer.valueOf(1) : PivotDataModel.this._impactedKeys.toArray());
                        } else {
                            PivotDataModel.this.firePivotValueProviderChanged(3, PivotDataModel.this._impactedKeys == null ? null : PivotDataModel.this._impactedKeys.toArray());
                        }
                        PivotDataModel.this._impactedKeys = null;
                        break;
                    }
                    case -1: {
                        if (this._savedEvent != null) break;
                        PivotDataModel.this.firePivotValueProviderChanged(1, PivotDataModel.this.isComputeAffectedCellOnUpdate() ? "doNotCacheAllValue" : null);
                        PivotDataModel.this._impactedKeys = null;
                        if (PivotDataModel.this.tableRowsDeleted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                            PivotDataModel.this.firePivotValueProviderChanged(2, PivotDataModel.this._impactedKeys == null ? Integer.valueOf(1) : PivotDataModel.this._impactedKeys.toArray());
                        } else {
                            PivotDataModel.this.firePivotValueProviderChanged(3, PivotDataModel.this._impactedKeys == null ? null : PivotDataModel.this._impactedKeys.toArray());
                        }
                        PivotDataModel.this._impactedKeys = null;
                        break;
                    }
                    case 0: {
                        if (this._savedEvent != null) break;
                        if (tableModelEvent.getFirstRow() == -1) {
                            PivotDataModel.this.initialize();
                            PivotDataModel.this.calculate();
                            if (!PivotDataModel.this.isAggregateMode()) break;
                            PivotDataModel.this.updateAllTableModels(true);
                            break;
                        }
                        if (tableModelEvent.getLastRow() == Integer.MAX_VALUE || PivotDataModel.this.getDataSource().hasFilter()) {
                            PivotDataModel.this.firePivotValueProviderChanged(1, false);
                            for (int i = 0; i < PivotDataModel.this._fields.length; ++i) {
                                PivotDataModel.this._fields[i].updateFromDataSource(PivotDataModel.this.getDataSource(), i, true);
                            }
                            PivotDataModel.this.forceCalculate(true);
                            break;
                        }
                        if (tableModelEvent.getColumn() == -1) {
                            PivotDataModel.this.firePivotValueProviderChanged(1, PivotDataModel.this.isComputeAffectedCellOnUpdate() ? "doNotCacheAllValue" : null);
                            PivotDataCube pivotDataCube = PivotDataModel.this._dataCube;
                            synchronized (pivotDataCube) {
                                PivotDataModel.this._dataCube.clearEmptyValues();
                            }
                            PivotDataModel.this._impactedKeys = null;
                            if (PivotDataModel.this.tableRowsUpdated(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                                PivotDataModel.this.firePivotValueProviderChanged(2, PivotDataModel.this._impactedKeys == null ? Integer.valueOf(1) : PivotDataModel.this._impactedKeys.toArray());
                            } else {
                                PivotDataModel.this.firePivotValueProviderChanged(3, PivotDataModel.this._impactedKeys == null ? null : PivotDataModel.this._impactedKeys.toArray());
                            }
                            PivotDataModel.this._impactedKeys = null;
                            break;
                        }
                        PivotDataModel.this.tableCellsUpdated(tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        break;
                    }
                    default: {
                        if (this._savedEvent != null) break;
                        PivotDataCube pivotDataCube = PivotDataModel.this._dataCube;
                        synchronized (pivotDataCube) {
                            PivotDataModel.this._dataCube.clearEmptyValues();
                        }
                        PivotDataModel.this.calculate();
                    }
                }
                PivotDataModel.this.invalidatePossibleValues();
                if (this._savedEvent != tableModelEvent) {
                    if (this._savedEvent != null && LOGGER_EVENT.isLoggable(Level.FINE)) {
                        LOGGER_EVENT.fine("PivotDataModel \" lost an event " + this._savedEvent + ". Current event is " + tableModelEvent + ".");
                    }
                    this._savedEvent = tableModelEvent;
                } else {
                    this._savedEvent = null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tableCellsUpdated(int n, int n2, int n3) {
        boolean bl = false;
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            this.firePivotValueProviderChanged(1, this.isComputeAffectedCellOnUpdate() ? "doNotCacheAllValue" : null);
            this._dataCube.clearEmptyValues();
            this._impactedKeys = null;
            PivotField pivotField = this.getField(n);
            switch (pivotField.getAreaType()) {
                case 0: 
                case 1: {
                    Object object;
                    CompoundKey compoundKey;
                    CompoundKey compoundKey2;
                    HashSet<Object> hashSet = new HashSet<Object>();
                    for (int i = n3; i >= n2; --i) {
                        int n4 = this.getDataSource().getFilteredRowIndex(i);
                        if (n4 == -1) continue;
                        compoundKey2 = this.getRowKeyAt(n4);
                        compoundKey = this.getColumnKeyAt(n4);
                        if (this.isAggregateMode() && compoundKey2.getKeyCount() > 0) {
                            object = compoundKey2.getKeys();
                            Object[] objectArray = new Object[((Object[])object).length + 1];
                            System.arraycopy(object, 0, objectArray, 0, ((Object)object).length);
                            objectArray[((Object)object).length] = new RowIndexValue(i);
                            this.addImpactKey(CompoundKey.newInstance(objectArray), compoundKey);
                        } else {
                            this.addImpactKey(compoundKey2, compoundKey);
                        }
                        object = this._dataCube.removeValue(n4);
                        if (object != null) {
                            for (Object object2 : object) {
                                if (object2 == null) continue;
                                hashSet.add(object2);
                                CompoundKey compoundKey3 = (CompoundKey)((CompoundKey)object2).getKeys()[0];
                                CompoundKey compoundKey4 = (CompoundKey)((CompoundKey)object2).getKeys()[1];
                                if (this.isAggregateMode()) {
                                    if (compoundKey3.getKeyCount() <= 0 || compoundKey3.equals(compoundKey2)) continue;
                                    Object[] objectArray = compoundKey3.getKeys();
                                    Object[] objectArray2 = new Object[objectArray.length + 1];
                                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                                    objectArray2[objectArray.length] = new RowIndexValue(i);
                                    this.addImpactKey(CompoundKey.newInstance(objectArray2), compoundKey4);
                                    continue;
                                }
                                if (compoundKey3.equals(compoundKey2) && compoundKey4.equals(compoundKey)) continue;
                                this.addImpactKey(compoundKey3, compoundKey4);
                            }
                        }
                        if (!this.addRowIndex(compoundKey2, compoundKey, n4)) continue;
                        bl = true;
                    }
                    for (CompoundKey compoundKey5 : hashSet) {
                        if (compoundKey5 == null || (object = this._dataCube.getValues(compoundKey2 = (CompoundKey)compoundKey5.getKeys()[0], compoundKey = (CompoundKey)compoundKey5.getKeys()[1])) != null && object.size() != 0) continue;
                        bl = true;
                        this._dataCube.removeKey(compoundKey5);
                        if (pivotField.getAreaType() == 0 && ((object = this._dataCube.getValues(compoundKey2, CompoundKey.newInstance(new Object[0]))) == null || object.size() == 0)) {
                            this._dataCube.removeRowKey(compoundKey2);
                        }
                        if (pivotField.getAreaType() != 1 || (object = this._dataCube.getValues(CompoundKey.newInstance(new Object[0]), compoundKey)) != null && object.size() != 0) continue;
                        this._dataCube.removeColumnKey(compoundKey);
                    }
                    if (this.isAdjusting()) break;
                    if (bl) {
                        this.firePivotValueProviderChanged(2, this._impactedKeys == null ? Integer.valueOf(1) : this._impactedKeys.toArray());
                        break;
                    }
                    this.firePivotValueProviderChanged(3, this._impactedKeys == null ? null : this._impactedKeys.toArray());
                    break;
                }
                default: {
                    for (int i = n2; i <= n3; ++i) {
                        int n5 = this.getDataSource().getFilteredRowIndex(i);
                        if (n5 == -1) continue;
                        CompoundKey compoundKey = this.getRowKeyAt(n5);
                        CompoundKey compoundKey6 = this.getColumnKeyAt(n5);
                        if (this.isAggregateMode() && compoundKey.getKeyCount() > 0) {
                            Object[] objectArray = compoundKey.getKeys();
                            Object[] objectArray3 = new Object[objectArray.length + 1];
                            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                            objectArray3[objectArray.length] = new RowIndexValue(i);
                            this.addImpactKey(CompoundKey.newInstance(objectArray3), compoundKey6);
                            continue;
                        }
                        this.addImpactKey(compoundKey, compoundKey6);
                    }
                    this.firePivotValueProviderChanged(3, this._impactedKeys == null ? null : this._impactedKeys.toArray());
                }
            }
        }
        this._impactedKeys = null;
        this.invalidatePossibleValues(n);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addRowIndex(CompoundKey compoundKey, CompoundKey compoundKey2, int n) {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            RowMerger rowMerger;
            boolean bl = true;
            if (this._dataCube.hasRowKey(compoundKey) && this._dataCube.hasColumnKey(compoundKey2)) {
                bl = false;
            }
            List list = this._dataCube.addValue(compoundKey, compoundKey2, n);
            if (this.isSingleValueMode() && list != null && list.size() > 1 && (rowMerger = this.getRowMerger()) != null) {
                rowMerger.mergeRow(this, list, n);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addPrefixRowIndex(CompoundKey compoundKey, CompoundKey compoundKey2, int n) {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            boolean bl = true;
            if (this._dataCube.hasRowKey(compoundKey) && this._dataCube.hasColumnKey(compoundKey2)) {
                bl = false;
            }
            this._dataCube.addPrefixValue(compoundKey, compoundKey2, n);
            return bl;
        }
    }

    private void addImpactKey(CompoundKey compoundKey, CompoundKey compoundKey2) {
        if (this._impactedKeys == null) {
            this._impactedKeys = new ArrayList<Values>();
        }
        this._impactedKeys.add(compoundKey.getKeyCount() == 0 ? new DummyValues() : compoundKey.toValues());
        this._impactedKeys.add(compoundKey2.getKeyCount() == 0 ? new DummyValues() : compoundKey2.toValues());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tableRowsUpdated(int n, int n2) {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            Object object;
            CompoundKey compoundKey;
            CompoundKey compoundKey2;
            boolean bl = false;
            HashSet<Object> hashSet = new HashSet<Object>();
            for (int i = n2; i >= n; --i) {
                int n3 = this.getDataSource().getFilteredRowIndex(i);
                if (n3 == -1) continue;
                compoundKey2 = this.getRowKeyAt(n3);
                compoundKey = this.getColumnKeyAt(n3);
                if (this.isAggregateMode() && compoundKey2.getKeyCount() > 0) {
                    object = compoundKey2.getKeys();
                    Object[] objectArray = new Object[((Object[])object).length + 1];
                    System.arraycopy(object, 0, objectArray, 0, ((Object)object).length);
                    objectArray[((Object)object).length] = new RowIndexValue(i);
                    this.addImpactKey(CompoundKey.newInstance(objectArray), compoundKey);
                } else {
                    this.addImpactKey(compoundKey2, compoundKey);
                }
                object = this._dataCube.removeValue(n3);
                if (object != null) {
                    for (Object object2 : object) {
                        if (object2 == null) continue;
                        hashSet.add(object2);
                        CompoundKey compoundKey3 = (CompoundKey)((CompoundKey)object2).getKeys()[0];
                        CompoundKey compoundKey4 = (CompoundKey)((CompoundKey)object2).getKeys()[1];
                        if (this.isAggregateMode()) {
                            if (compoundKey3.getKeyCount() <= 0 || compoundKey3.equals(compoundKey2)) continue;
                            Object[] objectArray = compoundKey3.getKeys();
                            Object[] objectArray2 = new Object[objectArray.length + 1];
                            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                            objectArray2[objectArray.length] = new RowIndexValue(i);
                            this.addImpactKey(CompoundKey.newInstance(objectArray2), compoundKey4);
                            continue;
                        }
                        if (compoundKey3.equals(compoundKey2) && compoundKey4.equals(compoundKey)) continue;
                        this.addImpactKey(compoundKey3, compoundKey4);
                    }
                }
                if (!this.addRowIndex(compoundKey2, compoundKey, n3)) continue;
                bl = true;
            }
            for (CompoundKey compoundKey5 : hashSet) {
                if (compoundKey5 == null || (object = this._dataCube.getValues(compoundKey2 = (CompoundKey)compoundKey5.getKeys()[0], compoundKey = (CompoundKey)compoundKey5.getKeys()[1])) != null && object.size() != 0) continue;
                bl = true;
                this._dataCube.removeKey(compoundKey5);
                object = this._dataCube.getValues(compoundKey2, CompoundKey.newInstance(new Object[0]));
                if (object == null || object.size() == 0) {
                    this._dataCube.removeRowKey(compoundKey2);
                }
                if ((object = this._dataCube.getValues(CompoundKey.newInstance(new Object[0]), compoundKey)) != null && object.size() != 0) continue;
                this._dataCube.removeColumnKey(compoundKey);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tableRowsInserted(int n, int n2) {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            this._dataCube.rowsInserted(n, n2);
            boolean bl = false;
            for (int i = n; i <= n2; ++i) {
                int n3 = this.getDataSource().getFilteredRowIndex(i);
                if (n3 == -1) continue;
                CompoundKey compoundKey = this.getRowKeyAt(n3);
                CompoundKey compoundKey2 = this.getColumnKeyAt(n3);
                if (this.isAggregateMode() && compoundKey.getKeyCount() > 0) {
                    Object[] objectArray = compoundKey.getKeys();
                    Object[] objectArray2 = new Object[objectArray.length + 1];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray2[objectArray.length] = new RowIndexValue(i);
                    this.addImpactKey(CompoundKey.newInstance(objectArray2), compoundKey2);
                } else {
                    this.addImpactKey(compoundKey, compoundKey2);
                }
                if (!this.addRowIndex(compoundKey, compoundKey2, n3) || this.isAggregateMode()) continue;
                bl = true;
            }
            return bl;
        }
    }

    void updateRowHeaderTableModel(Map<String, Boolean> map) {
        if (this._rowHeaderTableModel != null) {
            CompoundKey[] compoundKeyArray = this.getRowKeys();
            this._rowExpansion = map == null && !this.isOriginalDataUpdate() ? this._rowHeaderTableModel.getExpansionState() : map;
            if (this.isOriginalDataUpdate() && this.isAutoSortKeys() && this._rowHeaderTableModel.getPreviousRows() != null && this._impactedRowKeys != null && this._rowHeaderTableModel.shouldOptimize(this._impactedRowKeys.size(), compoundKeyArray.length)) {
                int n;
                CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(this._rowHeaderTableModel);
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (Values values : this._impactedRowKeys) {
                    int n2 = this._rowHeaderTableModel.indexOf(values);
                    if (n2 < 0) continue;
                    hashSet.add(n2);
                }
                Object[] objectArray2 = hashSet.toArray(new Integer[hashSet.size()]);
                Arrays.sort(objectArray2);
                for (int i = objectArray2.length - 1; i >= 0; --i) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this._rowHeaderTableModel, (Integer)objectArray2[i], (Integer)objectArray2[i], -1, -1));
                }
                if (this.isAggregateMode()) {
                    this._rowHeaderTableModel.setRows(this.sortCompoundKeys(compoundKeyArray, this.getRowFields()));
                } else {
                    this._rowHeaderTableModel.setRows(this.sortCompoundKeysOptimized(compoundKeyArray, this.getRowFields(), this._rowHeaderTableModel.getPreviousRows(), this._impactedRowKeys));
                }
                HashSet<Integer> hashSet2 = new HashSet<Integer>();
                for (Values objectArray3 : this._impactedRowKeys) {
                    n = this._rowHeaderTableModel.indexOf(objectArray3);
                    if (n < 0) continue;
                    hashSet2.add(n);
                }
                Object[] objectArray4 = hashSet2.toArray(new Integer[hashSet2.size()]);
                Arrays.sort(objectArray4);
                Object[] objectArray = objectArray4;
                n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = (Integer)objectArray[i];
                    compoundTableModelEvent.addEvent(new TableModelEvent(this._rowHeaderTableModel, n2, n2, -1, 1));
                }
                CompoundTableModelEvent.fireTableModelEvent(this._rowHeaderTableModel, compoundTableModelEvent);
            } else {
                this._rowHeaderTableModel.setRows(this.sortCompoundKeys(compoundKeyArray, this.getRowFields()));
                this._rowHeaderTableModel.fireTableDataChanged();
            }
            this._rowExpansion = null;
        } else {
            this.getRowHeaderTableModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tableRowsDeleted(int n, int n2) {
        int n3 = -1;
        while (n <= n2 && (n3 = this.getDataSource().getFilteredRowIndex(n)) == -1) {
            ++n;
        }
        int n4 = -1;
        while (n <= n2 && (n4 = this.getDataSource().getFilteredRowIndex(n2)) == -1) {
            --n2;
        }
        if (n3 == -1 || n4 == -1) {
            return false;
        }
        boolean bl = false;
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            if (!this.isAggregateMode()) {
                CompoundKey[] compoundKeyArray;
                for (CompoundKey compoundKey : compoundKeyArray = this._dataCube.rowsDeleted(n3, n4)) {
                    CompoundKey compoundKey2;
                    CompoundKey list;
                    List list2;
                    if (compoundKey == null || (list2 = this._dataCube.getValues(list = (CompoundKey)compoundKey.getKeys()[0], compoundKey2 = (CompoundKey)compoundKey.getKeys()[1])) != null && list2.size() != 0) continue;
                    this._dataCube.removeKey(compoundKey);
                    list2 = this._dataCube.getValues(list, CompoundKey.newInstance(new Object[0]));
                    if (list2 == null || list2.size() == 0) {
                        this._dataCube.removeRowKey(list);
                        bl = true;
                    }
                    if ((list2 = this._dataCube.getValues(CompoundKey.newInstance(new Object[0]), compoundKey2)) == null || list2.size() == 0) {
                        this._dataCube.removeColumnKey(compoundKey2);
                        bl = true;
                    }
                    this.addImpactKey(list, compoundKey2);
                }
            } else {
                Object object;
                HashSet<CompoundKey> hashSet = new HashSet<CompoundKey>();
                for (int i = n4; i >= n3; --i) {
                    CompoundKey[] object2 = this._dataCube.rowsDeleted(i, i);
                    if (object2 == null) continue;
                    object = object2;
                    int n5 = ((CompoundKey[])object).length;
                    for (int j = 0; j < n5; ++j) {
                        CompoundKey compoundKey = object[j];
                        if (compoundKey == null) continue;
                        hashSet.add(compoundKey);
                        CompoundKey compoundKey3 = (CompoundKey)compoundKey.getKeys()[0];
                        CompoundKey compoundKey4 = (CompoundKey)compoundKey.getKeys()[1];
                        if (compoundKey3.getKeyCount() <= 0) continue;
                        Object[] objectArray = compoundKey3.getKeys();
                        Object[] objectArray2 = new Object[objectArray.length + 1];
                        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                        objectArray2[objectArray.length] = new RowIndexValue(this.getDataSource().getActualRowIndex(i));
                        this.addImpactKey(CompoundKey.newInstance(objectArray2), compoundKey4);
                    }
                }
                for (CompoundKey compoundKey : hashSet) {
                    CompoundKey compoundKey5;
                    List list;
                    if (compoundKey == null || (list = this._dataCube.getValues((CompoundKey)(object = (CompoundKey)compoundKey.getKeys()[0]), compoundKey5 = (CompoundKey)compoundKey.getKeys()[1])) != null && list.size() != 0) continue;
                    this._dataCube.removeKey(compoundKey);
                    list = this._dataCube.getValues((CompoundKey)object, CompoundKey.newInstance(new Object[0]));
                    if (list == null || list.size() == 0) {
                        this._dataCube.removeRowKey((CompoundKey)object);
                    }
                    if ((list = this._dataCube.getValues(CompoundKey.newInstance(new Object[0]), compoundKey5)) != null && list.size() != 0) continue;
                    this._dataCube.removeColumnKey(compoundKey5);
                }
            }
        }
        return bl;
    }

    private void updateAllTableModels(boolean bl) {
        TableModel tableModel = this.getDataTableModel();
        if (tableModel instanceof AbstractTableModel) {
            if (bl) {
                ((AbstractTableModel)tableModel).fireTableStructureChanged();
            } else {
                ((AbstractTableModel)tableModel).fireTableDataChanged();
            }
        }
        this.updateRowHeaderTableModel(null);
        this.updateColumnHeaderTableModel(null);
        this.invalidatePossibleValues();
    }

    void updateColumnHeaderTableModel(Map<String, Boolean> map) {
        if (this._columnHeaderTableModel != null) {
            CompoundKey[] compoundKeyArray = this.getColumnKeys();
            this._columnExpansion = map == null ? this._columnHeaderTableModel.getExpansionState() : map;
            if (this.isOriginalDataUpdate() && this.isAutoSortKeys() && this._columnHeaderTableModel.getPreviousRows() != null && this._impactedColumnKeys != null && this._columnHeaderTableModel.shouldOptimize(this._impactedColumnKeys.size(), compoundKeyArray.length)) {
                this._columnHeaderTableModel.setRows(this.sortCompoundKeysOptimized(compoundKeyArray, this.getColumnFields(), this._columnHeaderTableModel.getPreviousRows(), this._impactedColumnKeys));
            } else {
                this._columnHeaderTableModel.setRows(this.sortCompoundKeys(compoundKeyArray, this.getColumnFields()));
            }
            this._columnExpansion = null;
        } else {
            this.getColumnHeaderTableModel();
        }
    }

    protected PivotField createPivotField(PivotDataSource pivotDataSource, int n) {
        return new PivotField(pivotDataSource, n);
    }

    public TableModel getTableModel() {
        if (this.getDataSource() instanceof TableModelPivotDataSource) {
            return ((TableModelPivotDataSource)this.getDataSource()).getTableModel();
        }
        return null;
    }

    @Override
    public PivotDataSource getDataSource() {
        return this._dataSource;
    }

    @Override
    public PivotField getField(String string) {
        for (PivotField pivotField : this._fields) {
            if (!string.equals(pivotField.getName())) continue;
            return pivotField;
        }
        return null;
    }

    @Override
    public PivotField getField(int n) {
        if (n >= 0 && n <= this._fields.length - 1) {
            return this._fields[n];
        }
        return null;
    }

    @Override
    public PivotField[] getFields() {
        return this._fields;
    }

    void setFields(PivotField[] pivotFieldArray) {
        this._fields = pivotFieldArray;
    }

    @Override
    public void setPivotFields(PivotField[] pivotFieldArray, PivotField[] pivotFieldArray2, PivotField[] pivotFieldArray3, PivotField[] pivotFieldArray4) {
        this.removeExistingPivotFieldPropertyChangeListeners();
        this._rowFields = pivotFieldArray;
        this._columnFields = pivotFieldArray2;
        this._dataFields = pivotFieldArray3;
        this._filterFields = pivotFieldArray4;
        this.configureDataFieldsFlag();
        if (this._fieldPropertyChangeListener == null) {
            this._fieldPropertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PivotDataModel.this.handleFieldPropertyEvent(propertyChangeEvent);
                }
            };
        }
        if (this._rowFields != null) {
            for (PivotField pivotField : this._rowFields) {
                pivotField.addPropertyChangeListener(this._fieldPropertyChangeListener);
            }
        }
        if (this._columnFields != null) {
            for (PivotField pivotField : this._columnFields) {
                pivotField.addPropertyChangeListener(this._fieldPropertyChangeListener);
            }
        }
        if (this._dataFields != null) {
            for (PivotField pivotField : this._dataFields) {
                pivotField.addPropertyChangeListener(this._fieldPropertyChangeListener);
            }
        }
        if (this._filterFields != null) {
            for (PivotField pivotField : this._filterFields) {
                pivotField.addPropertyChangeListener(this._fieldPropertyChangeListener);
            }
        }
    }

    private void removeExistingPivotFieldPropertyChangeListeners() {
        if (this._fieldPropertyChangeListener != null) {
            if (this._rowFields != null) {
                for (PivotField pivotField : this._rowFields) {
                    pivotField.removePropertyChangeListener(this._fieldPropertyChangeListener);
                }
            }
            if (this._columnFields != null) {
                for (PivotField pivotField : this._columnFields) {
                    pivotField.removePropertyChangeListener(this._fieldPropertyChangeListener);
                }
            }
            if (this._dataFields != null) {
                for (PivotField pivotField : this._dataFields) {
                    pivotField.removePropertyChangeListener(this._fieldPropertyChangeListener);
                }
            }
            if (this._filterFields != null) {
                for (PivotField pivotField : this._filterFields) {
                    pivotField.removePropertyChangeListener(this._fieldPropertyChangeListener);
                }
            }
        }
    }

    protected void handleFieldPropertyEvent(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedPossibleValues".equals(propertyChangeEvent.getPropertyName()) || "deselectedPossibleValues".equals(propertyChangeEvent.getPropertyName())) {
            PivotField pivotField = (PivotField)propertyChangeEvent.getSource();
            if (pivotField.getAreaType() == 3 && pivotField.isDataFieldFilterOnSummary()) {
                this.filterDataFieldsOnSummary();
                return;
            }
            int n = pivotField.getModelIndex();
            PivotDataSource pivotDataSource = this.getDataSource();
            Object[] objectArray = pivotField.getSelectedPossibleValues();
            if (objectArray != null) {
                pivotDataSource.setFilter(objectArray, n, pivotField.getAreaType() == 2);
            } else {
                objectArray = pivotField.getFilteredPossibleValues();
                if (objectArray != null) {
                    pivotDataSource.setExcludeFilter(objectArray, n, pivotField.getAreaType() == 2);
                }
            }
            pivotDataSource.applyFilters(this.getRowFieldIndices(), this.getColumnFieldIndices(), this.getDataFieldIndices(), this.getFilterFieldIndices());
            this.calculate();
        } else if ("filter".equals(propertyChangeEvent.getPropertyName()) || "filterOnSummary".equals(propertyChangeEvent.getPropertyName())) {
            PivotField pivotField = (PivotField)propertyChangeEvent.getSource();
            if (pivotField.getAreaType() == 3 && pivotField.isDataFieldFilterOnSummary()) {
                this.filterDataFieldsOnSummary();
                return;
            }
            int n = pivotField.getModelIndex();
            PivotDataSource pivotDataSource = this.getDataSource();
            Filter filter = (Filter)propertyChangeEvent.getNewValue();
            pivotDataSource.setFilter(filter, n, pivotField.getAreaType() == 2);
            pivotDataSource.applyFilters(this.getRowFieldIndices(), this.getColumnFieldIndices(), this.getDataFieldIndices(), this.getFilterFieldIndices());
            this.calculate();
        } else if ("sortOrder".equals(propertyChangeEvent.getPropertyName()) || "sortBy".equals(propertyChangeEvent.getPropertyName()) || "sortByRow".equals(propertyChangeEvent.getPropertyName())) {
            if (this.getPivotValueProviderListeners().length > 0) {
                PivotField pivotField = (PivotField)propertyChangeEvent.getSource();
                switch (pivotField.getAreaType()) {
                    case 0: {
                        this.firePivotValueProviderChanged(4, this.getRowHeaderTableModel());
                        this.firePivotValueProviderChanged(5);
                        break;
                    }
                    case 1: {
                        this.firePivotValueProviderChanged(4, this.getColumnHeaderTableModel());
                        this.firePivotValueProviderChanged(6);
                    }
                }
            }
        } else if (("summaryType".equals(propertyChangeEvent.getPropertyName()) || "subtotalType".equals(propertyChangeEvent.getPropertyName()) || "grandTotalSummaryType".equals(propertyChangeEvent.getPropertyName())) && this.getPivotValueProviderListeners().length > 0) {
            this.firePivotValueProviderChanged(4);
            this.firePivotValueProviderChanged(8);
        }
    }

    void filterDataFieldsOnSummary() {
        this.firePivotValueProviderChanged(4);
        this.updateDataFieldFilters();
        this.firePivotValueProviderChanged(7);
    }

    private void configureDataFieldsFlag() {
        this._columnDataFields = this.isAggregateMode() || this._columnFields.length == 0 || (!this.isHideSingleDataField() || this._dataFields.length > 1) && this._rowFields.length != 0;
        boolean bl = this._rowDataFields = !this._columnDataFields && (this._rowFields.length == 0 || this._dataFields.length > 1 && this._columnFields.length != 0);
        if (this.isAlwaysColumnDataFields()) {
            this._columnDataFields = true;
            this._rowDataFields = false;
        } else if (this.isAlwaysRowDataFields()) {
            this._columnDataFields = false;
            this._rowDataFields = true;
        }
    }

    @Override
    public void updateFields() {
        ArrayList<PivotField> arrayList = new ArrayList<PivotField>();
        ArrayList<PivotField> arrayList2 = new ArrayList<PivotField>();
        ArrayList<PivotField> arrayList3 = new ArrayList<PivotField>();
        ArrayList<PivotField> arrayList4 = new ArrayList<PivotField>();
        ArrayList<PivotField> arrayList5 = new ArrayList<PivotField>();
        block7: for (PivotField objectArray2 : this._fields) {
            switch (objectArray2.getAreaType()) {
                case 0: {
                    arrayList.add(objectArray2);
                    continue block7;
                }
                case 1: {
                    arrayList2.add(objectArray2);
                    continue block7;
                }
                case 3: {
                    arrayList3.add(objectArray2);
                    continue block7;
                }
                case 2: {
                    arrayList4.add(objectArray2);
                    continue block7;
                }
                case -1: {
                    arrayList5.add(objectArray2);
                }
            }
        }
        Object[] objectArray3 = arrayList.toArray(new PivotField[arrayList.size()]);
        Arrays.sort(objectArray3);
        Object[] objectArray4 = arrayList2.toArray(new PivotField[arrayList2.size()]);
        Arrays.sort(objectArray4);
        Object[] objectArray5 = arrayList3.toArray(new PivotField[arrayList3.size()]);
        Arrays.sort(objectArray5);
        Object[] objectArray = arrayList4.toArray(new PivotField[arrayList4.size()]);
        Arrays.sort(objectArray);
        this._unassignedFields = arrayList5.toArray(new PivotField[arrayList5.size()]);
        Arrays.sort(this._unassignedFields);
        this.setPivotFields((PivotField[])objectArray3, (PivotField[])objectArray4, (PivotField[])objectArray5, (PivotField[])objectArray);
    }

    @Override
    public void calculate() {
        this.firePivotValueProviderChanged(0);
        this.updateFields();
        this.forceCalculate();
    }

    @Override
    public void forceCalculate() {
        this.forceCalculate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceCalculate(boolean bl) {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            CompoundKey.clearCache();
            this.updateFilters();
            this._dataCube.clear();
            this._dataCube.setRowKeyLength(this._rowFields.length);
            this._dataCube.setColumnKeyLength(this._columnFields.length);
            this._dataCube.calculateStartNotice();
            try {
                int n = this.getDataSource().getRowCount();
                for (int i = 0; i < n; ++i) {
                    CompoundKey compoundKey = this.getRowKeyAt(i);
                    CompoundKey compoundKey2 = this.getColumnKeyAt(i);
                    this.addRowIndex(compoundKey, compoundKey2, i);
                }
                this.manageCompoundKeys();
                this.invalidatePossibleValues();
            }
            finally {
                this._dataCube.calculateEndNotice();
                if (bl) {
                    this.firePivotValueProviderChanged(2, false);
                } else {
                    this.firePivotValueProviderChanged(2);
                }
            }
            this._calculated = true;
        }
    }

    protected void manageCompoundKeys() {
    }

    protected void removeRowKey(CompoundKey compoundKey) {
        this._dataCube.removeRowKey(compoundKey);
    }

    protected void removeColumnKey(CompoundKey compoundKey) {
        this._dataCube.removeColumnKey(compoundKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCalculating() {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            return this._dataCube.isCalculating();
        }
    }

    protected void updateFilters() {
        PivotField[] pivotFieldArray;
        this.getDataSource().clearFilters();
        for (PivotField pivotField : pivotFieldArray = this.getFields()) {
            if (pivotField.getAreaType() == -1) continue;
            int n = pivotField.getModelIndex();
            Filter filter = pivotField.getFilter();
            if (pivotField.getAreaType() == 3 && pivotField.isDataFieldFilterOnSummary()) continue;
            if (filter != null) {
                this.getDataSource().setFilter(filter, n, pivotField.getAreaType() == 2);
                continue;
            }
            Object[] objectArray = pivotField.getSelectedPossibleValues();
            if (objectArray != null) {
                this.getDataSource().setFilter(objectArray, n, pivotField.getAreaType() == 2);
                continue;
            }
            Object[] objectArray2 = pivotField.getFilteredPossibleValues();
            if (objectArray2 == null) continue;
            this.getDataSource().setExcludeFilter(objectArray2, n, pivotField.getAreaType() == 2);
        }
        this.getDataSource().applyFilters(this.getRowFieldIndices(), this.getColumnFieldIndices(), this.getDataFieldIndices(), this.getFilterFieldIndices());
    }

    @Override
    public boolean isCalculated() {
        return this._calculated;
    }

    protected CompoundKey getCompoundKeyAt(int n, int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("The area type has to be AREA_ROW or AREA_COLUMN.");
        }
        PivotField[] pivotFieldArray = n2 == 0 ? this._rowFields : this._columnFields;
        Object[] objectArray = new Object[pivotFieldArray.length];
        for (int i = 0; i < pivotFieldArray.length; ++i) {
            objectArray[i] = this.getDataSource().getValueAt(n, pivotFieldArray[i].getModelIndex());
        }
        return CompoundKey.newInstance(objectArray);
    }

    public CompoundKey getColumnKeyAt(int n) {
        return this.getCompoundKeyAt(n, 1);
    }

    public CompoundKey getRowKeyAt(int n) {
        return this.getCompoundKeyAt(n, 0);
    }

    public int getRowAt(int n) {
        return this.getVisualIndexAt(n, 0);
    }

    public int getColumnAt(int n) {
        return this.getVisualIndexAt(n, 1);
    }

    private int getVisualIndexAt(int n, int n2) {
        int n3 = n;
        if (this.getDataSource() instanceof TableModelPivotDataSource) {
            n3 = TableModelWrapperUtils.getRowAt(this.getTableModel(), n3);
        }
        CompoundKey compoundKey = n2 == 0 ? this.getRowKeyAt(n3) : this.getColumnKeyAt(n3);
        Values values = compoundKey.toValues();
        HeaderTableModel headerTableModel = n2 == 0 ? this.getRowHeaderTableModel() : this.getColumnHeaderTableModel();
        int n4 = headerTableModel.indexOf(values);
        while (n4 < 0 && compoundKey.getKeyCount() > 1) {
            Object[] objectArray = compoundKey.getKeys();
            Object[] objectArray2 = new Object[objectArray.length - 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
            compoundKey = CompoundKey.newInstance(objectArray2);
            values = compoundKey.toValues();
            n4 = headerTableModel.indexOf(values);
        }
        if (n4 < 0) {
            return -1;
        }
        return headerTableModel.getVisualIndex(n4);
    }

    private void invalidatePossibleValues() {
        this._possibleValues = new Set[this._fields.length];
        for (int i = 0; i < this._fields.length; ++i) {
            this._possibleValues[i] = null;
        }
    }

    private void invalidatePossibleValues(int n) {
        if (this._possibleValues != null) {
            this._possibleValues[n] = null;
        }
    }

    private void updatePossibleValues(int n) {
        PivotField pivotField = this.getField(n);
        if (n != pivotField.getModelIndex() && LOGGER_EVENT.isLoggable(Level.SEVERE)) {
            LOGGER_EVENT.severe("PivotDataModel has inconsistent PivotField order with its model index. The order is " + n + " however the model index is " + pivotField.getModelIndex() + ".");
        }
        this._possibleValues[n] = this.getDataSource().getPossibleValues(n, pivotField.getAreaType() == 2, pivotField.isNullValueAllowed());
    }

    @Override
    public void invalidateRowHeaderTableModel() {
        this.updateRowHeaderTableModel(null);
        if (this._dataTableModel != null) {
            this._dataTableModel.fireTableDataChanged();
        }
        this._cornerTableModel = null;
    }

    @Override
    public void invalidateColumnHeaderTableModel() {
        this.updateColumnHeaderTableModel(null);
        if (this._dataTableModel != null) {
            this._dataTableModel.fireTableDataChanged();
        }
        this._cornerTableModel = null;
    }

    @Override
    public void invalidateCornerTableModel() {
        this._cornerTableModel = null;
    }

    @Override
    public void invalidateDataTableModel() {
        this._dataTableModel = null;
    }

    @Override
    @Deprecated
    public Object[] getPossibleValues(int n) {
        return this.getPossibleValues(n, ObjectComparatorManager.getComparator(this.getDataSource().getFieldType(n)));
    }

    @Override
    public Object[] getPossibleValues(PivotField pivotField) {
        return this.getPossibleValues(pivotField.getModelIndex(), ObjectComparatorManager.getComparator(pivotField.getType(), pivotField.getComparatorContext()));
    }

    @Override
    public Object[] getPossibleValues(int n, Comparator comparator) {
        if (n >= 0 && n < this._possibleValues.length) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = false;
            if (this._possibleValues[n] == null) {
                this.updatePossibleValues(n);
                if (this._possibleValues[n] == null) {
                    this.updatePossibleValues(n);
                }
            }
            if (this._possibleValues[n] == null) {
                return new Object[0];
            }
            Object[] objectArray = this.getField(n).getSelectedPossibleValues();
            Object[] objectArray2 = this.getField(n).getFilteredPossibleValues();
            if (objectArray != null) {
                this._possibleValues[n].addAll(Arrays.asList(objectArray));
            }
            if (objectArray2 != null) {
                this._possibleValues[n].addAll(Arrays.asList(objectArray2));
            }
            for (Object object : this._possibleValues[n]) {
                if (object == null) continue;
                if (NULL_VALUE.equals(object)) {
                    bl = true;
                    arrayList.add(0, null);
                    continue;
                }
                arrayList.add(object);
            }
            Object[] objectArray3 = arrayList.toArray();
            if (objectArray3.length >= 2) {
                if (bl) {
                    Arrays.sort(objectArray3, 1, objectArray3.length, comparator);
                } else {
                    Arrays.sort(objectArray3, comparator);
                }
            }
            return objectArray3;
        }
        return null;
    }

    private TableModelListener getHeaderTableModelListener() {
        if (this._headerTableModelListener == null) {
            this._headerTableModelListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    PivotDataModel.this.headerChanged(tableModelEvent);
                }
            };
        }
        return this._headerTableModelListener;
    }

    @Override
    public HeaderTableModel getRowHeaderTableModel() {
        if (this._rowHeaderTableModel == null) {
            CompoundKey[] compoundKeyArray = this.getRowKeys();
            this._rowHeaderTableModel = this.createRowHeaderTableModel(compoundKeyArray);
            this._rowExpansion = null;
            this._rowHeaderTableModel.addTableModelListener(this.getHeaderTableModelListener());
        }
        return this._rowHeaderTableModel;
    }

    protected HeaderTableModel createRowHeaderTableModel(CompoundKey[] compoundKeyArray) {
        return new HeaderTableModel(this, this.sortCompoundKeys(compoundKeyArray, this._rowFields), true);
    }

    @Override
    public TableModel getCornerTableModel() {
        if (this._cornerTableModel == null) {
            this._cornerTableModel = new CornerTableModel(this);
        }
        return this._cornerTableModel;
    }

    Map<String, Boolean> getRowExpansion() {
        return this._rowExpansion;
    }

    Map<String, Boolean> getColumnExpansion() {
        return this._columnExpansion;
    }

    @Override
    public HeaderTableModel getColumnHeaderTableModel() {
        if (this._columnHeaderTableModel == null) {
            CompoundKey[] compoundKeyArray = this.getColumnKeys();
            this._columnHeaderTableModel = this.createColumnHeaderTableModel(compoundKeyArray);
            this._columnExpansion = null;
            this._columnHeaderTableModel.addTableModelListener(this.getHeaderTableModelListener());
        }
        return this._columnHeaderTableModel;
    }

    protected HeaderTableModel createColumnHeaderTableModel(CompoundKey[] compoundKeyArray) {
        return new HeaderTableModel(this, this.sortCompoundKeys(compoundKeyArray, this._columnFields), false);
    }

    @Override
    public TableModel getDataTableModel() {
        if (this._dataTableModel == null) {
            this._dataTableModel = this.createDataTableModel();
        }
        return this._dataTableModel;
    }

    protected DataTableModel createDataTableModel() {
        return new DataTableModel(this);
    }

    private void headerChanged(TableModelEvent tableModelEvent) {
        TableModel tableModel = this.getDataTableModel();
        if (tableModel instanceof AbstractTableModel && !this.isAggregateMode()) {
            if (tableModelEvent instanceof CompoundTableModelEvent) {
                CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(tableModel);
                compoundTableModelEvent.setOriginalEvent(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent());
                for (TableModelEvent tableModelEvent2 : ((CompoundTableModelEvent)tableModelEvent).getEvents()) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(tableModel, tableModelEvent2.getFirstRow(), tableModelEvent2.getLastRow(), tableModelEvent2.getColumn(), tableModelEvent2.getType()));
                }
                CompoundTableModelEvent.fireTableModelEvent((AbstractTableModel)tableModel, compoundTableModelEvent);
                return;
            }
            if (tableModelEvent.getFirstRow() == -1) {
                if (tableModelEvent.getSource() instanceof HeaderTableModel && ((HeaderTableModel)tableModelEvent.getSource()).isRowHeader()) {
                    ((AbstractTableModel)tableModel).fireTableDataChanged();
                } else {
                    ((AbstractTableModel)tableModel).fireTableStructureChanged();
                }
            } else if (tableModelEvent.getColumn() == -1) {
                if (tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                    ((AbstractTableModel)tableModel).fireTableDataChanged();
                } else {
                    ((AbstractTableModel)tableModel).fireTableRowsUpdated(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                }
            }
        }
    }

    @Override
    public PivotField[] getRowFields() {
        return this._rowFields;
    }

    protected int[] getFieldIndices(PivotField[] pivotFieldArray) {
        int[] nArray = new int[pivotFieldArray.length];
        for (int i = 0; i < pivotFieldArray.length; ++i) {
            PivotField pivotField = pivotFieldArray[i];
            nArray[i] = pivotField.getModelIndex();
        }
        return nArray;
    }

    @Override
    public int[] getRowFieldIndices() {
        return this.getFieldIndices(this._rowFields);
    }

    @Override
    public PivotField[] getColumnFields() {
        return this._columnFields;
    }

    @Override
    public int[] getColumnFieldIndices() {
        return this.getFieldIndices(this._columnFields);
    }

    @Override
    public PivotField[] getDataFields() {
        return this._dataFields;
    }

    @Override
    public void resetDataFields() {
        ArrayList<PivotField> arrayList = new ArrayList<PivotField>();
        for (PivotField pivotField : this._fields) {
            if (pivotField.getAreaType() != 3) continue;
            arrayList.add(pivotField);
        }
        this._dataFields = arrayList.toArray(new PivotField[arrayList.size()]);
        Arrays.sort(this._dataFields);
    }

    @Override
    public int[] getDataFieldIndices() {
        return this.getFieldIndices(this._dataFields);
    }

    @Override
    public PivotField[] getFilterFields() {
        return this._filterFields;
    }

    @Override
    public int[] getFilterFieldIndices() {
        return this.getFieldIndices(this._filterFields);
    }

    @Override
    public PivotField[] getUnassignedFields() {
        return this._unassignedFields;
    }

    @Override
    public int[] getUnassignedFieldIndices() {
        return this.getFieldIndices(this._unassignedFields);
    }

    @Override
    public List<Integer> getDataAt(int n, int n2) {
        DefaultValues defaultValues;
        DefaultValues defaultValues2;
        if (this.isAggregateMode() && this.getRowFields().length == 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(n);
            return arrayList;
        }
        DefaultValues defaultValues3 = (DefaultValues)this.getRowHeaderTableModel().getValuesAt(n);
        if (this.isShowSubtotalAsChild() && defaultValues3 instanceof SummaryValues) {
            defaultValues3 = ((SummaryValues)defaultValues3).shorten();
        }
        DefaultValues defaultValues4 = defaultValues2 = n < 0 ? new DefaultValues(new Value[0]) : defaultValues3;
        if (defaultValues2 == null) {
            return null;
        }
        CompoundKey compoundKey = defaultValues2.toCompoundKey();
        if (n2 < 0) {
            compoundKey = compoundKey.getCompoundKeyPrefix(-n2);
        }
        DefaultValues defaultValues5 = (DefaultValues)this.getColumnHeaderTableModel().getValuesAt(n2);
        if (this.isShowSubtotalAsChild() && defaultValues5 instanceof SummaryValues) {
            defaultValues5 = ((SummaryValues)defaultValues5).shorten();
        }
        DefaultValues defaultValues6 = defaultValues = n2 < 0 ? new DefaultValues(new Value[0]) : defaultValues5;
        if (defaultValues == null) {
            return null;
        }
        CompoundKey compoundKey2 = defaultValues.toCompoundKey();
        if (n < 0) {
            compoundKey2 = compoundKey2.getCompoundKeyPrefix(-n);
        }
        return this.getDataAt(compoundKey, compoundKey2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getDataAt(CompoundKey compoundKey, CompoundKey compoundKey2) {
        List<Object> list = null;
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            if (compoundKey.getKeyCount() == 0 && compoundKey2.getKeyCount() == 0) {
                list = new ArrayList();
                int n = this.getDataSource().getRowCount();
                for (int i = 0; i < n; ++i) {
                    list.add(i);
                }
                return list;
            }
            ArrayList<Integer> arrayList = compoundKey.getLastKey();
            if (arrayList instanceof RowIndexValue) {
                Set set = this._dataCube.getValuesAsSet(compoundKey.getCompoundKeyPrefix(), compoundKey2);
                if (set == null) {
                    return new ArrayList<Integer>();
                }
                if (set.contains(((RowIndexValue)((Object)arrayList)).getRowIndex())) {
                    list = new ArrayList();
                    list.add(((RowIndexValue)((Object)arrayList)).getRowIndex());
                }
            } else if (arrayList instanceof RowIndexesValue) {
                list = ((RowIndexesValue)((Object)arrayList)).getRowIndexes();
            }
            if (list == null) {
                list = this._dataCube.getValues(compoundKey, compoundKey2);
            }
            if (this.getMaximumAggregatedRows() > 0 && list != null && list.size() > this.getMaximumAggregatedRows()) {
                arrayList = new ArrayList<Integer>();
                for (int i = 0; i < list.size(); ++i) {
                    int n = (Integer)list.get(i);
                    if (i >= this.getMaximumAggregatedRows()) break;
                    arrayList.add(n);
                }
                return arrayList;
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompoundKey[] sortCompoundKeysOptimized(CompoundKey[] compoundKeyArray, PivotField[] pivotFieldArray, CompoundKey[] compoundKeyArray2, Set<Values> set) {
        int[] nArray = new int[pivotFieldArray.length];
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            Object object;
            Object object2 = pivotFieldArray[i].getAreaType() == 0 ? pivotFieldArray[i].getSortByColumnKeys() : (object = pivotFieldArray[i].getAreaType() == 1 ? pivotFieldArray[i].getSortByRowKeys() : null);
            nArray[i] = object != null ? (pivotFieldArray[i].isSortByAscending() ? 1 : -1) : pivotFieldArray[i].getSortOrder();
            if (bl) continue;
            bl = nArray[i] != 0;
        }
        if (!bl) {
            return compoundKeyArray;
        }
        ArrayList<CompoundKey> arrayList = new ArrayList<CompoundKey>();
        arrayList.addAll(Arrays.asList(compoundKeyArray2));
        this.prepareSortingMap();
        try {
            for (Values values : set) {
                if (!(values instanceof DefaultValues)) continue;
                CompoundKey compoundKey = ((DefaultValues)values).toCompoundKey();
                int n = 0;
                int n2 = arrayList.size();
                int n3 = n2 / 2;
                int n4 = -1;
                while (n < n2 && (n4 = ((CompoundKey)arrayList.get(n3)).compareTo(compoundKey, this, pivotFieldArray, nArray)) != 0) {
                    if (n4 < 0) {
                        n = n3 + 1;
                    } else {
                        n2 = n3;
                    }
                    n3 = n + (n2 - n) / 2;
                }
                if (n4 != 0) {
                    arrayList.add(n3, compoundKey);
                    continue;
                }
                if (set.size() == 1 && compoundKeyArray.length + 1 == compoundKeyArray2.length) {
                    arrayList.remove(n3);
                    continue;
                }
                boolean bl2 = true;
                for (CompoundKey compoundKey2 : compoundKeyArray) {
                    if (compoundKey2.compareTo(compoundKey, this, pivotFieldArray, nArray) != 0) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                arrayList.remove(n3);
            }
        }
        finally {
            this.disposeSortingMap();
        }
        return arrayList.toArray(new CompoundKey[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompoundKey[] sortCompoundKeys(CompoundKey[] compoundKeyArray, final PivotField[] pivotFieldArray) {
        if (this.isAutoSortKeys()) {
            final int[] nArray = new int[pivotFieldArray.length];
            boolean bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                Values values;
                Values values2 = pivotFieldArray[i].getAreaType() == 0 ? pivotFieldArray[i].getSortByColumnKeys() : (values = pivotFieldArray[i].getAreaType() == 1 ? pivotFieldArray[i].getSortByRowKeys() : null);
                nArray[i] = values != null ? (pivotFieldArray[i].isSortByAscending() ? 1 : -1) : pivotFieldArray[i].getSortOrder();
                if (!bl) continue;
                bl = nArray[i] != 0;
            }
            if (bl) {
                this.prepareSortingMap();
                try {
                    Arrays.sort(compoundKeyArray, new Comparator(){

                        public int compare(Object object, Object object2) {
                            CompoundKey compoundKey = (CompoundKey)object;
                            CompoundKey compoundKey2 = (CompoundKey)object2;
                            try {
                                return compoundKey.compareTo(compoundKey2, PivotDataModel.this, pivotFieldArray, nArray);
                            }
                            catch (Exception exception) {
                                return 0;
                            }
                        }
                    });
                }
                finally {
                    this.disposeSortingMap();
                }
            }
        }
        return compoundKeyArray;
    }

    private void prepareSortingMap() {
        this._sortingValuesMap = Collections.synchronizedMap(new HashMap());
    }

    Object getValueFromSortingMap(int n, Values values, Values values2) {
        Map<Values, Map<Values, Object>> map;
        if (this._sortingValuesMap == null) {
            this.prepareSortingMap();
        }
        if ((map = this._sortingValuesMap.get(n)) == null) {
            return null;
        }
        Map<Values, Object> map2 = map.get(values);
        if (map2 == null) {
            return null;
        }
        return map2.get(values2);
    }

    void putValueToSortingMap(int n, Values values, Values values2, Object object) {
        Map<Values, Object> map;
        Map<Values, Map<Values, Object>> map2;
        if (this._sortingValuesMap == null) {
            this.prepareSortingMap();
        }
        if ((map2 = this._sortingValuesMap.get(n)) == null) {
            map2 = Collections.synchronizedMap(new HashMap());
            this._sortingValuesMap.put(n, map2);
        }
        if ((map = map2.get(values)) == null) {
            map = Collections.synchronizedMap(new HashMap());
            map2.put(values, map);
        }
        map.put(values2, object);
    }

    void disposeSortingMap() {
        if (this._sortingValuesMap == null) {
            return;
        }
        Set<Integer> set = this._sortingValuesMap.keySet();
        for (Integer n : set) {
            Map<Values, Map<Values, Object>> map = this._sortingValuesMap.get(n);
            if (map == null) continue;
            Set<Values> set2 = map.keySet();
            for (Values values : set2) {
                Map<Values, Object> map2 = map.get(values);
                if (map2 == null) continue;
                map2.clear();
            }
            map.clear();
        }
        this._sortingValuesMap.clear();
        this._sortingValuesMap = null;
    }

    @Override
    public boolean isRowDataFields() {
        return this._rowDataFields;
    }

    @Override
    public boolean isColumnDataFields() {
        return this._columnDataFields;
    }

    @Override
    public boolean isAlwaysColumnDataFields() {
        return this._alwaysColumnDataFields;
    }

    @Override
    public void setAlwaysColumnDataFields(boolean bl) {
        if (this._alwaysColumnDataFields != bl) {
            this._alwaysColumnDataFields = bl;
            this.calculate();
        }
    }

    @Override
    public boolean isAlwaysRowDataFields() {
        return this._alwaysRowDataFields;
    }

    @Override
    public void setAlwaysRowDataFields(boolean bl) {
        if (this._alwaysRowDataFields != bl) {
            this._alwaysRowDataFields = bl;
            this.calculate();
        }
    }

    @Override
    public boolean isHideSingleDataField() {
        return this._hideSingleDataField;
    }

    @Override
    public void setHideSingleDataField(boolean bl) {
        if (this._hideSingleDataField != bl) {
            boolean bl2 = this._hideSingleDataField;
            this._hideSingleDataField = bl;
            this.firePropertyChange(PROPERTY_HIDE_SINGLE_DATA_FIELD, bl2, this._hideSingleDataField);
        }
    }

    @Override
    public boolean isShowGrandTotalForRow() {
        return this._showGrandTotalForRow;
    }

    @Override
    public void setShowGrandTotalForRow(boolean bl) {
        if (this._showGrandTotalForRow != bl) {
            boolean bl2 = this._showGrandTotalForRow;
            this._showGrandTotalForRow = bl;
            this.firePropertyChange(PROPERTY_SHOW_GRAND_TOTAL_FOR_ROW, bl2, this._showGrandTotalForRow);
        }
    }

    @Override
    public boolean isShowGrandTotalForColumn() {
        return this._showGrandTotalForColumn;
    }

    @Override
    public void setShowGrandTotalForColumn(boolean bl) {
        if (this._showGrandTotalForColumn != bl) {
            boolean bl2 = this._showGrandTotalForColumn;
            this._showGrandTotalForColumn = bl;
            this.firePropertyChange(PROPERTY_SHOW_GRAND_TOTAL_FOR_COLUMN, bl2, this._showGrandTotalForColumn);
        }
    }

    @Override
    public PivotCellStyleProvider getCellStyleProvider() {
        return this._cellStyleProvider;
    }

    @Override
    public void setCellStyleProvider(PivotCellStyleProvider pivotCellStyleProvider) {
        if (this._cellStyleProvider != pivotCellStyleProvider) {
            this._cellStyleProvider = pivotCellStyleProvider;
            if (this._dataTableModel != null) {
                this._dataTableModel.fireTableRowsUpdated(0, this._dataTableModel.getRowCount() - 1);
            }
            if (this._rowHeaderTableModel != null) {
                this._rowHeaderTableModel.fireTableRowsUpdated(0, this._rowHeaderTableModel.getRowCount() - 1);
            }
            if (this._columnHeaderTableModel != null) {
                this._columnHeaderTableModel.fireTableRowsUpdated(0, this._columnHeaderTableModel.getRowCount() - 1);
            }
            if (pivotCellStyleProvider instanceof PivotCornerCellStyleProvider && this._cornerTableModel != null) {
                this._cornerTableModel.fireTableRowsUpdated(0, this._cornerTableModel.getRowCount() - 1);
            }
        }
    }

    @Override
    public void setRowHeaderEditingProvider(PivotDataEditingProvider pivotDataEditingProvider) {
        if (this._rowHeaderEditingProvider != pivotDataEditingProvider) {
            this._rowHeaderEditingProvider = pivotDataEditingProvider;
        }
    }

    @Override
    public PivotDataEditingProvider getRowHeaderEditingProvider() {
        return this._rowHeaderEditingProvider;
    }

    @Override
    public void setColumnHeaderEditingProvider(PivotDataEditingProvider pivotDataEditingProvider) {
        if (this._columnHeaderEditingProvider != pivotDataEditingProvider) {
            this._columnHeaderEditingProvider = pivotDataEditingProvider;
        }
    }

    @Override
    public PivotDataEditingProvider getColumnHeaderEditingProvider() {
        return this._columnHeaderEditingProvider;
    }

    @Override
    public PivotDataEditingProvider getDataEditingProvider() {
        return this._dataEditingProvider;
    }

    @Override
    public void setDataEditingProvider(PivotDataEditingProvider pivotDataEditingProvider) {
        if (this._dataEditingProvider != pivotDataEditingProvider) {
            this._dataEditingProvider = pivotDataEditingProvider;
        }
    }

    @Override
    public SummaryCalculator getSummaryCalculator() {
        if (this._summaryCalculator == null) {
            SummaryCalculatorFactory summaryCalculatorFactory = this.getSummaryCalculatorFactory();
            this._summaryCalculator = summaryCalculatorFactory != null ? summaryCalculatorFactory.create() : new DefaultPivotSummaryCalculator();
            this._summaryCalculatorCreatedByFactory = true;
        }
        return this._summaryCalculator;
    }

    @Override
    public void setSummaryCalculator(SummaryCalculator summaryCalculator) {
        this._summaryCalculator = summaryCalculator;
        this._summaryCalculatorCreatedByFactory = false;
    }

    @Override
    public SummaryCalculatorFactory getSummaryCalculatorFactory() {
        if (this._summaryCalculatorFactory == null) {
            this._summaryCalculatorFactory = new SummaryCalculatorFactory(){

                @Override
                public PivotSummaryCalculator create() {
                    return new DefaultPivotSummaryCalculator();
                }
            };
        }
        return this._summaryCalculatorFactory;
    }

    @Override
    public void setSummaryCalculatorFactory(SummaryCalculatorFactory summaryCalculatorFactory) {
        if (this._summaryCalculatorFactory != summaryCalculatorFactory) {
            if (this._summaryCalculatorCreatedByFactory) {
                this._summaryCalculator = null;
            }
            this._summaryCalculatorFactory = summaryCalculatorFactory;
        }
    }

    @Override
    public boolean isDisplayGrandTotalFirstForRow() {
        return this._displayGrandTotalFirstForRow;
    }

    @Override
    public void setDisplayGrandTotalFirstForRow(boolean bl) {
        this._displayGrandTotalFirstForRow = bl;
    }

    @Override
    public boolean isDisplayGrandTotalFirstForColumn() {
        return this._displayGrandTotalFirstForColumn;
    }

    @Override
    public void setDisplayGrandTotalFirstForColumn(boolean bl) {
        this._displayGrandTotalFirstForColumn = bl;
    }

    @Override
    public boolean isDisplayGrandTotalFirst() {
        return this._displayGrandTotalFirst;
    }

    @Override
    @Deprecated
    public void setDisplayGrandTotalFirst(boolean bl) {
        this._displayGrandTotalFirst = bl;
        this._displayGrandTotalFirstForRow = bl;
        this._displayGrandTotalFirstForColumn = bl;
    }

    @Override
    public boolean isAutoUpdate() {
        return this._autoUpdate;
    }

    @Override
    public void setAutoUpdate(boolean bl) {
        this._autoUpdate = bl;
    }

    @Override
    public boolean isAdjusting() {
        return this._isAdjusting;
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (this._isAdjusting != bl) {
            this._isAdjusting = bl;
        }
    }

    @Override
    public boolean isSummaryMode() {
        return this._summaryMode;
    }

    @Override
    public void setSummaryMode(boolean bl) {
        this._summaryMode = bl;
    }

    @Override
    public boolean isAggregateMode() {
        return this._aggregateMode;
    }

    void setAggregateMode(boolean bl) {
        this._aggregateMode = bl;
    }

    boolean isShowSummaryOnAggregate() {
        return this._showSummaryOnAggregate;
    }

    void setShowSummaryOnAggregate(boolean bl) {
        this._showSummaryOnAggregate = bl;
    }

    @Override
    public boolean isSingleValueMode() {
        return this._singleValueMode;
    }

    @Override
    public void setSingleValueMode(boolean bl) {
        this._singleValueMode = bl;
    }

    int getMaximumAggregatedRows() {
        return this._maximumAggregatedRows;
    }

    void setMaximumAggregatedRows(int n) {
        this._maximumAggregatedRows = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify() {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            return this._dataCube.verify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowHeaderRowIndexAt(int n) {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            Set<CompoundKey> set = this._dataCube.getKeys();
            for (CompoundKey compoundKey : set) {
                Object object = this._dataCube.getValue(compoundKey);
                CompoundKey compoundKey2 = (CompoundKey)compoundKey.getKeys()[0];
                if (object instanceof Integer) {
                    int n2 = (Integer)object;
                    if (n2 != n) continue;
                    return this.getRowHeaderTableModel().indexOf(compoundKey2.getKeys());
                }
                if (!(object instanceof List)) continue;
                List list = (List)object;
                for (Integer n3 : list) {
                    if (n3 != n) continue;
                    return this.getRowHeaderTableModel().indexOf(compoundKey2.getKeys());
                }
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnHeaderColumnIndexAt(int n) {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            Set<CompoundKey> set = this._dataCube.getKeys();
            for (CompoundKey compoundKey : set) {
                Object object = this._dataCube.getValue(compoundKey);
                CompoundKey compoundKey2 = (CompoundKey)compoundKey.getKeys()[1];
                if (object instanceof Integer) {
                    int n2 = (Integer)object;
                    if (n2 != n) continue;
                    return this.getColumnHeaderTableModel().indexOf(compoundKey2.getKeys());
                }
                if (!(object instanceof List)) continue;
                List list = (List)object;
                for (Integer n3 : list) {
                    if (n3 != n) continue;
                    return this.getColumnHeaderTableModel().indexOf(compoundKey2.getKeys());
                }
            }
            return -1;
        }
    }

    public static boolean isValueImmutable() {
        return _valueImmutable;
    }

    public static void setValueImmutable(boolean bl) {
        _valueImmutable = bl;
    }

    public static boolean isUseComparable() {
        return _useComparable;
    }

    public static void setUseComparable(boolean bl) {
        _useComparable = bl;
    }

    @Override
    public boolean isHideSummaryValues() {
        return this._hideSummaryValues;
    }

    @Override
    public void setHideSummaryValues(boolean bl) {
        this._hideSummaryValues = bl;
    }

    List<Values> getFilteredRowValues() {
        return this._filteredRowValues;
    }

    void setFilteredRowValues(List<Values> list) {
        this._filteredRowValues = list;
    }

    List<Values> getFitleredColumnValues() {
        return this._fitleredColumnValues;
    }

    void setFitleredColumnValues(List<Values> list) {
        this._fitleredColumnValues = list;
    }

    @Override
    public boolean isKeepRowChildrenOnSummaryFilter() {
        return this._keepRowChildrenOnSummaryFilter;
    }

    @Override
    public void setKeepRowChildrenOnSummaryFilter(boolean bl) {
        this._keepRowChildrenOnSummaryFilter = bl;
    }

    public boolean isHideExpandIconOnSingleRow() {
        return this._hideExpandIconOnSingleRow;
    }

    public void setHideExpandIconOnSingleRow(boolean bl) {
        this._hideExpandIconOnSingleRow = bl;
    }

    boolean isOriginalDataUpdate() {
        return this._originalDataUpdate;
    }

    public void setOriginalDataUpdate(Object object) {
        boolean bl = this._originalDataUpdate = object != null;
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length <= 1 || objectArray.length % 2 != 0) {
                this._impactedRowKeys = null;
                this._impactedColumnKeys = null;
                return;
            }
            this._impactedRowKeys = new HashSet<Values>();
            this._impactedColumnKeys = new HashSet<Values>();
            for (int i = 0; i < objectArray.length - 1; i += 2) {
                if (objectArray[i] instanceof Values && ((Values)objectArray[i]).getCount() > 0) {
                    this._impactedRowKeys.add((Values)objectArray[i]);
                }
                if (!(objectArray[i + 1] instanceof Values) || ((Values)objectArray[i + 1]).getCount() <= 0) continue;
                this._impactedColumnKeys.add((Values)objectArray[i + 1]);
            }
        } else {
            this._impactedRowKeys = null;
            this._impactedColumnKeys = null;
        }
    }

    @Override
    public boolean isLayoutDataFieldsFirst() {
        return this._layoutDataFieldsFirst;
    }

    @Override
    public void setLayoutDataFieldsFirst(boolean bl) {
        if (this._layoutDataFieldsFirst != bl) {
            this._layoutDataFieldsFirst = bl;
            this.invalidateRowHeaderTableModel();
            this.invalidateColumnHeaderTableModel();
            this.firePivotValueProviderChanged(4);
            this.firePivotValueProviderChanged(8, ADJUST_ROW_FIELDS_WIDTH);
        }
    }

    @Override
    public boolean isHighPerformanceMode() {
        return this._highPerformanceMode;
    }

    @Override
    public void setHighPerformanceMode(boolean bl) {
        this._highPerformanceMode = bl;
    }

    public RowMerger getRowMerger() {
        return this._rowMerger;
    }

    public void setRowMerger(RowMerger rowMerger) {
        this._rowMerger = rowMerger;
    }

    public boolean isAutoSortKeys() {
        return this._autoSortKeys;
    }

    public void setAutoSortKeys(boolean bl) {
        this._autoSortKeys = bl;
    }

    private boolean isSubtotalRowOrColumn(Values values) {
        DefaultValues defaultValues = (DefaultValues)values;
        if (defaultValues == null || defaultValues.getCount() == 0) {
            return false;
        }
        if (defaultValues.getValueAt(defaultValues.getCount() - 1) instanceof RowIndexesValue) {
            return true;
        }
        return defaultValues instanceof SummaryValues;
    }

    private boolean isGrandTotalRowOrColumn(Values values) {
        return values instanceof GrandTotalValues;
    }

    private boolean shouldCalculateSummary(Values values) {
        return this.isSummaryMode() || this.isSubtotalRowOrColumn(values) || this.isGrandTotalRowOrColumn(values);
    }

    @Override
    public int getStatisticsType(Values values, Values values2, PivotField pivotField) {
        return 0;
    }

    int getSummaryTypeAt(Values values, Values values2, PivotField pivotField) {
        if (pivotField == null) {
            return -1;
        }
        if (pivotField.getSummaryType() == -2) {
            return -2;
        }
        if (values2 instanceof SummaryValues) {
            int n = ((SummaryValues)values2).getSummaryType();
            if (n == -1) {
                return pivotField.getSubtotalSummaryType();
            }
            return n;
        }
        if (values instanceof SummaryValues) {
            int n = ((SummaryValues)values).getSummaryType();
            if (n == -1) {
                return pivotField.getSubtotalSummaryType();
            }
            return n;
        }
        if (values2 instanceof GrandTotalValues || values instanceof GrandTotalValues) {
            return pivotField.getGrandTotalSummaryType();
        }
        int n = pivotField.getSummaryType();
        if (n == -1 && this.isSummaryMode()) {
            return n;
        }
        return n;
    }

    protected Object calculateStatistics(PivotField pivotField, Values values, Values values2, int n, Object[] objectArray) {
        if (n == -1 && pivotField != null) {
            if (pivotField.getCustomSummary() != null) {
                return pivotField.getCustomSummary().getResult(objectArray);
            }
            return null;
        }
        if (n == -2) {
            return null;
        }
        if (pivotField != null) {
            SummaryCalculator summaryCalculator = null;
            if (SwingUtilities.isEventDispatchThread()) {
                summaryCalculator = this.getSummaryCalculator();
            }
            if (summaryCalculator == null) {
                Object[] objectArray2 = this.getSummaryCalculatorFactory();
                SummaryCalculator summaryCalculator2 = summaryCalculator = objectArray2 == null ? this.getSummaryCalculator() : objectArray2.create();
            }
            if (summaryCalculator != null) {
                summaryCalculator.clear();
                for (Object object : objectArray) {
                    if (summaryCalculator instanceof PivotSummaryCalculator) {
                        ((PivotSummaryCalculator)summaryCalculator).addValue(this, pivotField, values, values2, object);
                        continue;
                    }
                    summaryCalculator.addValue(object);
                }
                if (n != 6 && summaryCalculator.getCount() == 0L) {
                    return null;
                }
                return summaryCalculator.getSummaryResult(n);
            }
        }
        return objectArray.length;
    }

    @Deprecated
    protected Object calculateStatistics(PivotField pivotField, int n, int n2, int n3, Object[] objectArray) {
        Values values = this.getRowHeaderTableModel().getValuesAt(n);
        Values values2 = this.getColumnHeaderTableModel().getValuesAt(n2);
        return this.calculateStatistics(pivotField, values, values2, n3, objectArray);
    }

    protected Object[] collectValuesForCell(PivotField pivotField, Values values, Values values2, int n) {
        int n2 = pivotField != null && pivotField.getStatisticsCalculationType() >= 0 ? pivotField.getStatisticsCalculationType() : 0;
        switch (n2) {
            default: 
        }
        List<Integer> list = this.getDataAt(((DefaultValues)values).toCompoundKey(), ((DefaultValues)values2).toCompoundKey());
        if (list == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer n3 = list.get(i);
            objectArray[i] = pivotField != null ? this.getDataSource().getValueAt(n3, pivotField.getModelIndex()) : null;
        }
        return objectArray;
    }

    protected Object[] collectValuesForCell(PivotField pivotField, int n, int n2, int n3) {
        int n4 = pivotField != null && pivotField.getStatisticsCalculationType() >= 0 ? pivotField.getStatisticsCalculationType() : 0;
        switch (n4) {
            default: 
        }
        List<Integer> list = this.getDataAt(n, n2);
        if (list == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer n5 = list.get(i);
            objectArray[i] = pivotField != null ? this.getDataSource().getValueAt(n5, pivotField.getModelIndex()) : null;
        }
        return objectArray;
    }

    @Override
    public Object getValueAt(PivotField pivotField, Values values, Values values2) {
        if (this.shouldCalculateSummary(values)) {
            int n = this.getSummaryTypeAt(values, values2, pivotField);
            Object[] objectArray = this.collectValuesForCell(pivotField, values, values2, n);
            return this.calculateStatistics(pivotField, values, values2, n, objectArray);
        }
        Object[] objectArray = this.collectValuesForCell(pivotField, values, values2, -1);
        return objectArray != null && objectArray.length > 0 ? objectArray[0] : null;
    }

    protected boolean shouldCalculateSummary(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this.isSummaryMode() && !this.isAggregateMode() || this.getRowHeaderTableModel().isSubtotalRowOrColumn(n) || this.getRowHeaderTableModel().isGrandTotalRowOrColumn(n) || !this.isAggregateMode() && (this.getColumnHeaderTableModel().isSubtotalRowOrColumn(n2) || this.getColumnHeaderTableModel().isGrandTotalRowOrColumn(n2) || this.getColumnHeaderTableModel().isRunningSummaryRowOrColumn(n2) || this.getRowHeaderTableModel().isRunningSummaryRowOrColumn(n));
        if (this.isAggregateMode() && !bl) {
            List list = this.getRowHeaderTableModel().getFlatData();
            if (n >= list.size() || n < 0) {
                return false;
            }
            Object e = list.get(n);
            if (e instanceof DefaultValues) {
                for (int i = 0; i < ((DefaultValues)e).getCount(); ++i) {
                    Value value = ((DefaultValues)e).getValueAt(i);
                    if (!(value instanceof ExpandableValue) || !((ExpandableValue)value).hasChildren() || ((ExpandableValue)value).isExpanded()) continue;
                    return true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isValuesVisible(Values values) {
        return !(this._hiddenRowValues != null && this._hiddenRowValues.contains(values) || this._hiddenColumnValues != null && this._hiddenColumnValues.contains(values));
    }

    @Override
    public void addHiddenValues(Values values) {
        boolean bl;
        if (this.getRowHeaderTableModel().getFlatData().indexOf(values) >= 0) {
            bl = true;
        } else if (this.getColumnHeaderTableModel().getFlatData().indexOf(values) >= 0) {
            bl = false;
        } else {
            return;
        }
        if (bl) {
            if (this._hiddenRowValues == null) {
                this._hiddenRowValues = new HashSet<Values>();
            }
            this._hiddenRowValues.add(values);
            if (this._hiddenRows != null) {
                this._hiddenRows.remove(values);
            }
        } else {
            if (this._hiddenColumnValues == null) {
                this._hiddenColumnValues = new HashSet<Values>();
            }
            this._hiddenColumnValues.add(values);
            if (this._hiddenColumns != null) {
                this._hiddenColumns.remove(values);
            }
        }
    }

    @Override
    public void removeHiddenValues(Values values) {
        if (this._hiddenRowValues != null) {
            this._hiddenRowValues.remove(values);
        }
        if (this._hiddenColumnValues != null) {
            this._hiddenColumnValues.remove(values);
        }
    }

    @Override
    public void clearHiddenValues() {
        if (this._hiddenRowValues != null) {
            this._hiddenRowValues.clear();
        }
        if (this._hiddenColumnValues != null) {
            this._hiddenColumnValues.clear();
        }
    }

    @Override
    public boolean hasHiddenValues() {
        return this._hiddenRowValues != null && this._hiddenRowValues.size() > 0 || this._hiddenColumnValues != null && this._hiddenColumnValues.size() > 0;
    }

    @Override
    public Values[] getHiddenValues() {
        Values[] valuesArray;
        int n = 0;
        if (this._hiddenRowValues != null) {
            n += this._hiddenRowValues.size();
        }
        if (this._hiddenColumnValues != null) {
            n += this._hiddenColumnValues.size();
        }
        if (n <= 0) {
            return new Values[0];
        }
        int n2 = 0;
        Values[] valuesArray2 = new Values[n];
        if (this._hiddenRowValues != null && this._hiddenRowValues.size() > 0) {
            valuesArray = this._hiddenRowValues.toArray(new Values[this._hiddenRowValues.size()]);
            System.arraycopy(valuesArray, 0, valuesArray2, n2, valuesArray.length);
            n2 = valuesArray.length;
        }
        if (this._hiddenColumnValues != null && this._hiddenColumnValues.size() > 0) {
            valuesArray = this._hiddenColumnValues.toArray(new Values[this._hiddenColumnValues.size()]);
            System.arraycopy(valuesArray, 0, valuesArray2, n2, valuesArray.length);
        }
        return valuesArray2;
    }

    Values[] getHiddenRowValues() {
        if (this._hiddenRowValues != null) {
            return this._hiddenRowValues.toArray(new Values[this._hiddenRowValues.size()]);
        }
        return new Values[0];
    }

    Values[] getHiddenColumnValues() {
        if (this._hiddenColumnValues != null) {
            return this._hiddenColumnValues.toArray(new Values[this._hiddenColumnValues.size()]);
        }
        return new Values[0];
    }

    @Override
    public boolean isRowVisible(Values values, PivotField pivotField) {
        int n;
        if (this._hiddenRows == null) {
            return true;
        }
        Map<PivotField, String> map = this._hiddenRows.get(values);
        if (map != null && map.get(pivotField) != null) {
            return false;
        }
        int n2 = values.getCount();
        Value[] valueArray = new Value[n2];
        for (n = 0; n < n2; ++n) {
            valueArray[n] = values.getValueAt(n);
        }
        for (n = 1; n < n2; ++n) {
            Value[] valueArray2 = new Value[n];
            System.arraycopy(valueArray, 0, valueArray2, 0, n);
            DefaultValues defaultValues = new DefaultValues(valueArray2);
            map = this._hiddenRows.get(defaultValues);
            if (map == null || map.get(pivotField) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addHiddenRow(Values values, PivotField pivotField) {
        Map<PivotField, String> map;
        if (this._hiddenRows == null) {
            this._hiddenRows = Collections.synchronizedMap(new HashMap());
        }
        if ((map = this._hiddenRows.get(values)) == null) {
            map = Collections.synchronizedMap(new HashMap());
            this._hiddenRows.put(values, map);
        }
        map.put(pivotField, "true");
    }

    public String removeHiddenRow(Values values, PivotField pivotField) {
        Map<PivotField, String> map;
        String string = null;
        if (this._hiddenRows != null && (map = this._hiddenRows.get(values)) != null) {
            string = map.remove(pivotField);
            if (map.size() <= 0) {
                this._hiddenRows.remove(values);
            }
        }
        return string;
    }

    @Override
    public void clearHiddenRows() {
        if (this._hiddenRows == null) {
            return;
        }
        this._hiddenRows.clear();
        this._hiddenRows = null;
    }

    @Override
    public boolean hasHiddenRows() {
        return this._hiddenRows != null && this._hiddenRows.size() > 0;
    }

    public Object[][] getHiddenRows() {
        if (!this.hasHiddenRows()) {
            return new Object[0][0];
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (Values values : this._hiddenRows.keySet()) {
            Map<PivotField, String> map = this._hiddenRows.get(values);
            if (map == null || map.size() == 0) continue;
            for (PivotField pivotField : map.keySet()) {
                String string = map.get(pivotField);
                if (string == null) continue;
                Object[] objectArray = new Object[]{values, pivotField, string};
                arrayList.add(objectArray);
            }
        }
        Object[][] objectArray = new Object[arrayList.size()][];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray[i] = (Object[])arrayList.get(i);
        }
        return objectArray;
    }

    @Override
    public boolean isColumnVisible(Values values, PivotField pivotField) {
        int n;
        if (this._hiddenColumns == null) {
            return true;
        }
        Map<PivotField, String> map = this._hiddenColumns.get(values);
        if (map != null && map.get(pivotField) != null) {
            return false;
        }
        int n2 = values.getCount();
        Value[] valueArray = new Value[n2];
        for (n = 0; n < n2; ++n) {
            valueArray[n] = values.getValueAt(n);
        }
        for (n = 1; n < n2; ++n) {
            Value[] valueArray2 = new Value[n];
            System.arraycopy(valueArray, 0, valueArray2, 0, n);
            DefaultValues defaultValues = new DefaultValues(valueArray2);
            map = this._hiddenColumns.get(defaultValues);
            if (map == null || map.get(pivotField) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addHiddenColumn(Values values, PivotField pivotField) {
        this.addHiddenColumn(values, pivotField, "15\t75\t75");
    }

    @Override
    public void addHiddenColumn(Values values, PivotField pivotField, String string) {
        Map<PivotField, String> map;
        if (this._hiddenColumns == null) {
            this._hiddenColumns = Collections.synchronizedMap(new HashMap());
        }
        if ((map = this._hiddenColumns.get(values)) == null) {
            map = Collections.synchronizedMap(new HashMap());
            this._hiddenColumns.put(values, map);
        }
        map.put(pivotField, string);
    }

    @Override
    public String removeHiddenColumn(Values values, PivotField pivotField) {
        Map<PivotField, String> map;
        String string = null;
        if (this._hiddenColumns != null && (map = this._hiddenColumns.get(values)) != null) {
            string = map.remove(pivotField);
            if (map.size() <= 0) {
                this._hiddenColumns.remove(values);
            }
        }
        return string;
    }

    @Override
    public void clearHiddenColumns() {
        if (this._hiddenColumns == null) {
            return;
        }
        this._hiddenColumns.clear();
        this._hiddenColumns = null;
    }

    @Override
    public boolean hasHiddenColumns() {
        return this._hiddenColumns != null && this._hiddenColumns.size() > 0;
    }

    @Override
    public Object[][] getHiddenColumns() {
        if (!this.hasHiddenColumns()) {
            return new Object[0][0];
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (Values values : this._hiddenColumns.keySet()) {
            Map<PivotField, String> map = this._hiddenColumns.get(values);
            if (map == null || map.size() == 0) continue;
            for (PivotField pivotField : map.keySet()) {
                String string = map.get(pivotField);
                if (string == null) continue;
                Object[] objectArray = new Object[]{values, pivotField, string};
                arrayList.add(objectArray);
            }
        }
        Object[][] objectArray = new Object[arrayList.size()][];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray[i] = (Object[])arrayList.get(i);
        }
        return objectArray;
    }

    void updateDataFieldFilters() {
        boolean bl = false;
        for (PivotField pivotField : this.getDataFields()) {
            if ((!pivotField.isDataFieldFilterOnSummary() || pivotField.getFilter() == null && pivotField.getSelectedPossibleValues() == null) && pivotField.getFilteredPossibleValues() == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this._filteredRowValues = null;
            this._fitleredColumnValues = null;
            return;
        }
        if (this._fitleredColumnValues != null) {
            this._fitleredColumnValues.clear();
        } else {
            this._fitleredColumnValues = new ArrayList<Values>();
        }
        if (this._filteredRowValues != null) {
            this._filteredRowValues.clear();
        } else {
            this._filteredRowValues = new ArrayList<Values>();
        }
        DataTableModel dataTableModel = (DataTableModel)this.getDataTableModel();
        HeaderTableModel headerTableModel = this.getRowHeaderTableModel();
        HeaderTableModel headerTableModel2 = this.getColumnHeaderTableModel();
        if (this.isKeepRowChildrenOnSummaryFilter()) {
            Object[] objectArray;
            Object[] objectArray2;
            Cloneable cloneable;
            Object object;
            Object object2;
            int n;
            int n2 = headerTableModel.getDataIndex();
            for (n = 0; n < dataTableModel.getRowCount(); ++n) {
                int n3;
                if (n2 >= 0) {
                    object2 = headerTableModel.getFieldAt(n, n2);
                    Filter filter = ((Field)object2).getFilter();
                    if (!((PivotField)object2).isDataFieldFilterOnSummary() || filter == null && ((Field)object2).getSelectedPossibleValues() == null && ((Field)object2).getFilteredPossibleValues() == null) continue;
                }
                if (!((object2 = headerTableModel.getValuesAt(n, headerTableModel.getColumnCount() - 1)) instanceof SummaryValues)) continue;
                for (n3 = dataTableModel.getColumnCount() - 1; n3 >= 0; --n3) {
                    Object object3 = headerTableModel2.getValuesAt(headerTableModel2.getRowCount() - 1, n3);
                    if (object3 instanceof SummaryValues || object3 instanceof GrandTotalValues || object3 instanceof DummyValues) continue;
                    object = dataTableModel.getDataFieldAt(n, n3);
                    cloneable = ((Field)object).getFilter();
                    objectArray2 = ((Field)object).getSelectedPossibleValues();
                    objectArray = ((Field)object).getFilteredPossibleValues();
                    if (((PivotField)object).isDataFieldFilterOnSummary() && (cloneable != null || objectArray2 != null || objectArray != null) && !this.isValueFiltered(dataTableModel.getValueAt(n, n3), (Filter)cloneable, objectArray2, objectArray)) break;
                }
                if (n3 >= 0) continue;
                this._filteredRowValues.add((SummaryValues)object2);
            }
            n2 = headerTableModel2.getDataIndex();
            for (n = 0; n < dataTableModel.getColumnCount(); ++n) {
                int n4;
                object2 = headerTableModel2.getValuesAt(headerTableModel2.getRowCount() - 1, n);
                if (object2 instanceof SummaryValues || object2 instanceof GrandTotalValues || object2 instanceof DummyValues) continue;
                if (n2 >= 0) {
                    PivotField pivotField = headerTableModel2.getFieldAt(n2, n);
                    Filter filter = pivotField.getFilter();
                    if (!pivotField.isDataFieldFilterOnSummary() || filter == null && pivotField.getSelectedPossibleValues() == null && pivotField.getFilteredPossibleValues() == null) continue;
                }
                boolean bl2 = false;
                for (n4 = dataTableModel.getRowCount() - 1; n4 >= 0; --n4) {
                    object = headerTableModel.getValuesAt(n4, headerTableModel.getColumnCount() - 1);
                    if (!(object instanceof SummaryValues)) continue;
                    cloneable = headerTableModel.getFieldAt(n4, headerTableModel.getDataIndex());
                    objectArray2 = ((Field)((Object)cloneable)).getFilter();
                    objectArray = ((Field)((Object)cloneable)).getSelectedPossibleValues();
                    Object[] objectArray3 = ((Field)((Object)cloneable)).getFilteredPossibleValues();
                    if (!((PivotField)cloneable).isDataFieldFilterOnSummary() || objectArray2 == null && objectArray == null && objectArray3 == null) continue;
                    if (!this.isValueFiltered(dataTableModel.getValueAt(n4, n), (Filter)objectArray2, objectArray, objectArray3)) break;
                    bl2 = true;
                }
                if (n4 >= 0 || !bl2) continue;
                this._fitleredColumnValues.add((DefaultValues)object2);
            }
        } else {
            Object[] objectArray;
            Object[] objectArray4;
            Cloneable cloneable;
            Object object;
            Object object4;
            int n;
            int n5 = headerTableModel2.getDataIndex();
            for (n = 0; n < dataTableModel.getColumnCount(); ++n) {
                int n6;
                if (n5 >= 0) {
                    object4 = headerTableModel2.getFieldAt(n5, n);
                    Filter filter = ((Field)object4).getFilter();
                    if (!((PivotField)object4).isDataFieldFilterOnSummary() || filter == null && ((Field)object4).getSelectedPossibleValues() == null && ((Field)object4).getFilteredPossibleValues() == null) continue;
                }
                if (!((object4 = headerTableModel2.getValuesAt(headerTableModel2.getRowCount() - 1, n)) instanceof SummaryValues)) continue;
                for (n6 = dataTableModel.getRowCount() - 1; n6 >= 0; --n6) {
                    Object object5 = headerTableModel.getValuesAt(n6, headerTableModel.getColumnCount() - 1);
                    if (object5 instanceof SummaryValues || object5 instanceof GrandTotalValues || object5 instanceof DummyValues) continue;
                    object = dataTableModel.getDataFieldAt(n6, n);
                    cloneable = ((Field)object).getFilter();
                    objectArray4 = ((Field)object).getSelectedPossibleValues();
                    objectArray = ((Field)object).getFilteredPossibleValues();
                    if (((PivotField)object).isDataFieldFilterOnSummary() && (cloneable != null || objectArray4 != null || objectArray != null) && !this.isValueFiltered(dataTableModel.getValueAt(n6, n), (Filter)cloneable, objectArray4, objectArray)) break;
                }
                if (n6 >= 0) continue;
                this._fitleredColumnValues.add((SummaryValues)object4);
            }
            n5 = headerTableModel.getDataIndex();
            for (n = 0; n < dataTableModel.getRowCount(); ++n) {
                int n7;
                object4 = headerTableModel.getValuesAt(n, headerTableModel.getColumnCount() - 1);
                if (object4 instanceof SummaryValues || object4 instanceof GrandTotalValues || object4 instanceof DummyValues) continue;
                if (n5 >= 0) {
                    PivotField pivotField = headerTableModel.getFieldAt(n, n5);
                    Filter filter = pivotField.getFilter();
                    if (!pivotField.isDataFieldFilterOnSummary() || filter == null && pivotField.getSelectedPossibleValues() == null && pivotField.getFilteredPossibleValues() == null) continue;
                }
                boolean bl3 = false;
                for (n7 = dataTableModel.getColumnCount() - 1; n7 >= 0; --n7) {
                    object = headerTableModel2.getValuesAt(headerTableModel2.getRowCount() - 1, n7);
                    if (!(object instanceof SummaryValues)) continue;
                    cloneable = headerTableModel2.getFieldAt(headerTableModel2.getDataIndex(), n7);
                    objectArray4 = ((Field)((Object)cloneable)).getFilter();
                    objectArray = ((Field)((Object)cloneable)).getSelectedPossibleValues();
                    Object[] objectArray5 = ((Field)((Object)cloneable)).getFilteredPossibleValues();
                    if (!((PivotField)cloneable).isDataFieldFilterOnSummary() || objectArray4 == null && objectArray == null && objectArray5 == null) continue;
                    if (!this.isValueFiltered(dataTableModel.getValueAt(n, n7), (Filter)objectArray4, objectArray, objectArray5)) break;
                    bl3 = true;
                }
                if (n7 >= 0 || !bl3) continue;
                this._filteredRowValues.add((DefaultValues)object4);
            }
        }
    }

    private boolean isValueFiltered(Object object, Filter filter, Object[] objectArray, Object[] objectArray2) {
        if (filter != null) {
            return filter.isValueFiltered(object);
        }
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                if (!object2.equals(object)) continue;
                return false;
            }
            return true;
        }
        if (objectArray2 != null) {
            for (Object object3 : objectArray2) {
                if (!object3.equals(object)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isAllowEmptyColumnHeader() {
        return this._allowEmptyColumnHeader;
    }

    @Override
    public void setAllowEmptyColumnHeader(boolean bl) {
        this._allowEmptyColumnHeader = bl;
    }

    @Override
    public boolean isAllowEmptyRowHeader() {
        return this._allowEmptyRowHeader;
    }

    @Override
    public void setAllowEmptyRowHeader(boolean bl) {
        this._allowEmptyRowHeader = bl;
    }

    @Override
    public boolean isExpandByDefault() {
        return this._expandByDefault;
    }

    @Override
    public void setExpandByDefault(boolean bl) {
        this._expandByDefault = bl;
    }

    @Override
    public boolean isShowSubtotalAsChild() {
        return this._showSubtotalAsChild;
    }

    @Override
    public void setShowSubtotalAsChild(boolean bl) {
        if (this._showSubtotalAsChild != bl) {
            boolean bl2 = this._showSubtotalAsChild;
            this._showSubtotalAsChild = bl;
            this.firePropertyChange(PROPERTY_SHOW_SUBTOTAL_AS_CHILD, bl2, bl);
        }
    }

    @Override
    public boolean isHideRedundantSubtotal() {
        return this._hideRedundantSubtotal;
    }

    @Override
    public void setHideRedundantSubtotal(boolean bl) {
        if (this._hideRedundantSubtotal != bl) {
            boolean bl2 = this._hideRedundantSubtotal;
            this._hideRedundantSubtotal = bl;
            this.firePropertyChange(PROPERTY_HIDE_REDUNDANT_SUBTOTAL, bl2, bl);
        }
    }

    @Override
    public void addPivotValueProviderListener(PivotValueProviderListener pivotValueProviderListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, PivotValueProviderListener.class, (EventListener)pivotValueProviderListener)) {
            this.listenerList.add(PivotValueProviderListener.class, pivotValueProviderListener);
        }
    }

    @Override
    public void removePivotValueProviderListener(PivotValueProviderListener pivotValueProviderListener) {
        this.listenerList.remove(PivotValueProviderListener.class, pivotValueProviderListener);
    }

    public PivotValueProviderListener[] getPivotValueProviderListeners() {
        return (PivotValueProviderListener[])this.listenerList.getListeners(PivotValueProviderListener.class);
    }

    public void firePivotValueProviderChanged(int n) {
        int n2;
        PivotValueProviderListener[] pivotValueProviderListenerArray = this.getPivotValueProviderListeners();
        for (n2 = pivotValueProviderListenerArray.length - 1; n2 >= 0; --n2) {
            if (!(pivotValueProviderListenerArray[n2] instanceof PivotDataModel) && !(pivotValueProviderListenerArray[n2] instanceof PivotTablePane)) continue;
            pivotValueProviderListenerArray[n2].pivotValueProviderEventHandler(new PivotValueProviderEvent(this, n));
        }
        for (n2 = pivotValueProviderListenerArray.length - 1; n2 >= 0; --n2) {
            if (pivotValueProviderListenerArray[n2] instanceof PivotDataModel || pivotValueProviderListenerArray[n2] instanceof PivotTablePane) continue;
            pivotValueProviderListenerArray[n2].pivotValueProviderEventHandler(new PivotValueProviderEvent(this, n));
        }
    }

    public void firePivotValueProviderChanged(int n, Object object) {
        PivotValueProviderListener[] pivotValueProviderListenerArray = this.getPivotValueProviderListeners();
        for (int i = pivotValueProviderListenerArray.length - 1; i >= 0; --i) {
            pivotValueProviderListenerArray[i].pivotValueProviderEventHandler(new PivotValueProviderEvent(this, n, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompoundKey[] getRowKeys() {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            return this._dataCube.getRowKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompoundKey[] getColumnKeys() {
        PivotDataCube pivotDataCube = this._dataCube;
        synchronized (pivotDataCube) {
            return this._dataCube.getColumnKeys();
        }
    }

    @Override
    public boolean isSummaryLayer() {
        return this._summaryLayer;
    }

    @Override
    public void setSummaryLayer(boolean bl) {
        this._summaryLayer = bl;
    }

    PivotField duplicateField(PivotField pivotField) {
        PivotField pivotField2;
        try {
            pivotField2 = (PivotField)pivotField.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        pivotField2.setDuplicated(true);
        PivotField[] pivotFieldArray = this.getFields();
        if (pivotField.isDuplicated()) {
            pivotField = this.getField(pivotField.getModelIndex());
        }
        pivotField2.setName(pivotField.getName() + ": " + pivotFieldArray.length);
        pivotField2.setTitle(pivotField.getTitle());
        if (this._fieldPropertyChangeListener != null) {
            pivotField2.addPropertyChangeListener(this._fieldPropertyChangeListener);
        }
        PivotField[] pivotFieldArray2 = new PivotField[pivotFieldArray.length + 1];
        System.arraycopy(pivotFieldArray, 0, pivotFieldArray2, 0, pivotFieldArray.length);
        pivotFieldArray2[pivotFieldArray.length] = pivotField2;
        this.setFields(pivotFieldArray2);
        return pivotField2;
    }

    boolean removeDuplicatedField(PivotField pivotField) {
        int n;
        if (pivotField == null) {
            return false;
        }
        PivotField[] pivotFieldArray = this.getFields();
        if (!pivotField.isDuplicated()) {
            n = pivotField.getModelIndex();
            boolean bl = false;
            for (PivotField pivotField2 : pivotFieldArray) {
                if (pivotField2.getModelIndex() != n || pivotField2.getAreaType() != -1 || !pivotField2.isDuplicated()) continue;
                pivotField = pivotField2;
                bl = true;
                break;
            }
            if (!bl) {
                for (PivotField pivotField2 : pivotFieldArray) {
                    if (pivotField2.getModelIndex() != n || pivotField2.getAreaType() != 3 || !pivotField2.isDuplicated()) continue;
                    pivotField = pivotField2;
                    break;
                }
            }
        }
        if (pivotField.isDuplicated()) {
            for (n = pivotFieldArray.length - 1; n >= 0 && pivotFieldArray[n] != pivotField; --n) {
            }
            if (n >= 0 && pivotFieldArray.length > 0) {
                PivotField[] pivotFieldArray2 = new PivotField[pivotFieldArray.length - 1];
                System.arraycopy(pivotFieldArray, 0, pivotFieldArray2, 0, n);
                System.arraycopy(pivotFieldArray, n + 1, pivotFieldArray2, n, pivotFieldArray.length - 1 - n);
                this.setFields(pivotFieldArray2);
                return true;
            }
        }
        return false;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this._changeSupport;
        if (propertyChangeSupport == null || object == object2) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this._changeSupport == null) {
            return;
        }
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isComputeAffectedCellOnUpdate() {
        return this._computeAffectedCellOnUpdate;
    }

    public void setComputeAffectedCellOnUpdate(boolean bl) {
        this._computeAffectedCellOnUpdate = bl;
    }

    @Override
    public String getExpansionStateSeparator() {
        return this._expansionStateSeparator;
    }

    @Override
    public void setExpansionStateSeparator(String string) {
        this._expansionStateSeparator = string;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(32)) {
            Lm.showInvalidProductMessage(PivotDataModel.class.getName(), 32);
        }
        LOGGER_EVENT = Logger.getLogger(PivotDataModel.class.getName());
        _valueImmutable = true;
        _useComparable = true;
    }

    public static interface RowMerger {
        public void mergeRow(PivotDataModel var1, List<?> var2, int var3);
    }
}

