/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableProvider;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.TableSelectionEvent;
import com.jidesoft.grid.TableSelectionListener;
import com.jidesoft.grid.ValueConverter;
import com.jidesoft.grid.ValueStringAdjustProvider;
import com.jidesoft.pivot.CompareToConverter;
import com.jidesoft.pivot.DataTable;
import com.jidesoft.pivot.DefaultValues;
import com.jidesoft.pivot.GrandTotalValue;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.HeaderTableCellRenderer;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.RunningSummary;
import com.jidesoft.pivot.RunningSummaryValue;
import com.jidesoft.pivot.RunningSummaryValues;
import com.jidesoft.pivot.SummaryValue;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.AutoScroll;
import com.jidesoft.swing.DelegateMouseInputListener;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.SystemInfo;
import com.jidesoft.utils.TypeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HeaderTable
extends CategorizedTable
implements PropertyChangeListener,
ExpandableProvider,
TableSelectionListener,
ValueStringAdjustProvider {
    private PivotTablePane _pivotTablePane;
    private TableCellRenderer _renderer;
    private boolean _init;
    public static final String PROPERTY_DOUBLE_CLICK_ENABLED = "doubleClickEnabled";
    private AutoScroll _autoScroll;
    private Point _startDraggingPoint;
    private boolean _showContextMenu = true;
    private boolean _useNativeRenderer = true;
    private boolean _adjusting = false;
    private int _anchorRow = -1;
    private int _anchorCol = -1;
    private static final CellStyle HEADER_STYLE = new CellStyle();

    public HeaderTable(PivotTablePane pivotTablePane) {
        this.initializeTable();
        this._pivotTablePane = pivotTablePane;
        this.setAutoConvertCellSpan(false);
        this.adjustProperty();
    }

    public HeaderTable(PivotTablePane pivotTablePane, TableModel tableModel) {
        super(tableModel);
        this.initializeTable();
        this._pivotTablePane = pivotTablePane;
        this.setAutoConvertCellSpan(false);
        this.adjustProperty();
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        super.addColumn(tableColumn);
        if (this.getModel() instanceof HeaderTableModel && !((HeaderTableModel)this.getModel()).isRowHeader() && this._pivotTablePane.isColumnHidden(tableColumn.getModelIndex())) {
            tableColumn.setPreferredWidth(0);
            tableColumn.setMinWidth(0);
            tableColumn.setWidth(0);
            this._pivotTablePane.installPropertyChangeListenerForColumn(tableColumn);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this.getModel() instanceof HeaderTableModel && ((HeaderTableModel)this.getModel()).isRowHeader() && (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0 || tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE && tableModelEvent.getColumn() == -1)) {
            this.clearHiddenRows();
            PivotTablePane pivotTablePane = this.getPivotTablePane();
            if (pivotTablePane != null) {
                JTable jTable = pivotTablePane.getDataTable();
                if (jTable != null) {
                    ((DataTable)jTable).clearHiddenRows();
                }
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (!pivotTablePane.isRowHidden(i)) continue;
                    this.addHiddenRow(i);
                    if (jTable == null) continue;
                    ((DataTable)jTable).addHiddenRow(i);
                }
            }
        }
    }

    void setAutoScrolls() {
        final HeaderTable headerTable = this;
        this._autoScroll = new AutoScroll(headerTable){
            int _rowIndex;
            int _columnIndex;

            @Override
            public void autoScrollingStarted(int n) {
                Point point;
                Rectangle rectangle = HeaderTable.this._pivotTablePane.getDataTable().getVisibleRect();
                Dimension dimension = HeaderTable.this._pivotTablePane.getDataTable().getSize();
                Rectangle rectangle2 = HeaderTable.this._pivotTablePane.getScrollPane().getVisibleRect();
                if (n == 0 || n == 1) {
                    if (rectangle2.getHeight() >= dimension.getHeight()) {
                        this.stopAutoScrolling();
                        return;
                    }
                } else if (rectangle2.getWidth() >= dimension.getWidth()) {
                    this.stopAutoScrolling();
                    return;
                }
                switch (n) {
                    case 0: {
                        point = new Point(rectangle.x + rectangle.width - 2, rectangle.y);
                        break;
                    }
                    case 1: {
                        point = new Point(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
                        break;
                    }
                    case 2: {
                        point = new Point(rectangle.x, rectangle.y + rectangle.height - 2);
                        break;
                    }
                    case 4: {
                        point = new Point(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid parameter direction" + n);
                    }
                }
                this._rowIndex = HeaderTable.this.rowAtPoint(point);
                this._columnIndex = HeaderTable.this.columnAtPoint(point);
            }

            @Override
            public void autoScrolling(int n) {
                if (!this.isAutoScrolling()) {
                    return;
                }
                Rectangle rectangle = HeaderTable.this._pivotTablePane.getScrollPane().getViewport().getViewRect();
                switch (n) {
                    case 0: {
                        if (this._rowIndex <= 0 || HeaderTable.this._pivotTablePane.getRowHeaderTable() != headerTable) {
                            return;
                        }
                        --this._rowIndex;
                        Rectangle rectangle2 = HeaderTable.this._pivotTablePane.getDataTable().getCellRect(this._rowIndex, this._columnIndex, true);
                        rectangle.y = (int)rectangle2.getMinY();
                        break;
                    }
                    case 1: {
                        if (this._rowIndex >= HeaderTable.this._pivotTablePane.getDataTable().getModel().getRowCount() - 1 || HeaderTable.this._pivotTablePane.getRowHeaderTable() != headerTable) {
                            return;
                        }
                        ++this._rowIndex;
                        Rectangle rectangle3 = HeaderTable.this._pivotTablePane.getDataTable().getCellRect(this._rowIndex, this._columnIndex, true);
                        rectangle.y = (int)((double)rectangle.y + (rectangle3.getMaxY() - rectangle.getMaxY()));
                        break;
                    }
                    case 2: {
                        if (this._columnIndex == 0 || HeaderTable.this._pivotTablePane.getColumnHeaderTable() != headerTable) {
                            return;
                        }
                        --this._columnIndex;
                        Rectangle rectangle4 = HeaderTable.this._pivotTablePane.getDataTable().getCellRect(this._rowIndex, this._columnIndex, true);
                        rectangle.x = (int)rectangle4.getMinX();
                        break;
                    }
                    case 4: {
                        if (this._columnIndex >= HeaderTable.this._pivotTablePane.getDataTable().getModel().getColumnCount() - 1 || HeaderTable.this._pivotTablePane.getColumnHeaderTable() != headerTable) {
                            return;
                        }
                        ++this._columnIndex;
                        Rectangle rectangle5 = HeaderTable.this._pivotTablePane.getDataTable().getCellRect(this._rowIndex, this._columnIndex, true);
                        rectangle.x = (int)((double)rectangle.x + (rectangle5.getMaxX() - rectangle.getMaxX()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid parameter direction" + n);
                    }
                }
                Point point = new Point(rectangle.x, rectangle.y);
                HeaderTable.this._pivotTablePane.getScrollPane().getViewport().setViewPosition(point);
            }

            @Override
            public void updateSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
            }
        };
        this._autoScroll.setComponentSelfScrollable(false);
    }

    private void adjustProperty() {
        this.setClickCountToStart(2);
        this._pivotTablePane.addPropertyChangeListener(this);
        this.updateTable(this._pivotTablePane.isPlainHeaderTables(), this._pivotTablePane.getHeaderSelectionMode());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    private void initializeTable() {
        if (!this._init) {
            Object object;
            this.setNonContiguousCellSelection(true);
            this.setCellSelectionEnabled(true);
            this.setAutoResizeMode(0);
            boolean bl = false;
            if (SystemInfo.isJdk6Above() && !SystemInfo.isJdk7Above()) {
                object = this.getMouseListeners();
                MouseListener mouseListener = null;
                for (MouseListener mouseListener2 : object) {
                    if (mouseListener2.getClass().getName().indexOf("TableUI") == -1) continue;
                    mouseListener = mouseListener2;
                    this.removeMouseListener(mouseListener2);
                    if (!(mouseListener2 instanceof MouseMotionListener)) break;
                    this.removeMouseMotionListener((MouseMotionListener)((Object)mouseListener2));
                    break;
                }
                if (mouseListener != null && mouseListener instanceof MouseInputListener) {
                    MouseInputListener mouseInputListener = this.createExpandMouseInputListener((MouseInputListener)mouseListener);
                    JideSwingUtilities.insertMouseListener(this, mouseInputListener, 0);
                    JideSwingUtilities.insertMouseMotionListener(this, mouseInputListener, 0);
                    bl = true;
                }
            }
            if (!bl) {
                object = this.createExpandMouseListener();
                JideSwingUtilities.insertMouseListener(this, (MouseListener)object, 0);
                JideSwingUtilities.insertMouseMotionListener(this, (MouseMotionListener)object, 0);
            }
            this.setColumnResizable(true);
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this._init = true;
        }
    }

    @Override
    public void valueChanged(TableSelectionEvent tableSelectionEvent) {
        if (!tableSelectionEvent.getValueIsAdjusting() && !this._adjusting) {
            this._anchorCol = -1;
            this._anchorRow = -1;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("gridColor".equals(propertyChangeEvent.getPropertyName())) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof Color) {
                this.setGridColor((Color)object);
            }
        } else if ("plainHeaderTables".equals(propertyChangeEvent.getPropertyName()) || "headerSelectionModel".equals(propertyChangeEvent.getPropertyName())) {
            this.updateTable(this._pivotTablePane.isPlainHeaderTables(), this._pivotTablePane.getHeaderSelectionMode());
            this._renderer = this.createCellRenderer();
        }
    }

    private void updateTable(boolean bl, int n) {
        if (bl) {
            this.setBackground(UIDefaultsLookup.getColor("Table.background"));
            this.setSelectionBackground(UIDefaultsLookup.getColor("Table.selectionBackground"));
            this.setSelectionForeground(UIDefaultsLookup.getColor("Table.selectionForeground"));
            this.setShowGrid(true);
        } else {
            this.setBackground(UIDefaultsLookup.getColor("Panel.background"));
            this.setSelectionBackground(ColorUtils.getDerivedColor(UIDefaultsLookup.getColor("Table.selectionBackground"), 0.85f));
            this.setSelectionForeground(UIDefaultsLookup.getColor("Table.foreground"));
            this.setShowGrid(false);
        }
        if (n == 1) {
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
        } else {
            this.setFocusable(true);
            this.setRequestFocusEnabled(true);
        }
    }

    protected TableCellRenderer createCellRenderer() {
        return new HeaderTableCellRenderer(this._pivotTablePane);
    }

    protected ExpandMouseListener createExpandMouseListener() {
        return new ExpandMouseListener();
    }

    protected MouseInputListener createExpandMouseInputListener(MouseInputListener mouseInputListener) {
        return new DelegateExpandMouseInputListener(mouseInputListener);
    }

    public boolean isExpandIconVisible(Node node) {
        boolean bl = true;
        if (!this.isCellSpanOn()) {
            bl = false;
        }
        if (bl && (this.getPivotTablePane().isHideExpandIconOnSingleRow() || !this.getPivotTablePane().getPivotDataModel().isSummaryMode())) {
            boolean bl2 = bl = node instanceof Expandable && ((Expandable)node).getAllVisibleChildrenCount() > 1;
        }
        if (node == null) {
            bl = false;
        } else if (bl && this.getModel() instanceof HeaderTableModel) {
            boolean bl3 = ((HeaderTableModel)this.getModel()).isRowHeader();
            int n = node.getLevel();
            PivotField[] pivotFieldArray = this.getPivotTablePane().getPivotDataModel().getRowFields();
            PivotField[] pivotFieldArray2 = this.getPivotTablePane().getPivotDataModel().getColumnFields();
            if (bl3 && pivotFieldArray.length > n && n >= 0) {
                PivotField pivotField = pivotFieldArray[n];
                bl = pivotField.isExpandable();
            } else if (pivotFieldArray2.length > n && n >= 0) {
                PivotField pivotField = pivotFieldArray2[n];
                bl = pivotField.isExpandable();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMousePressedEvent(MouseEvent mouseEvent) {
        Rectangle rectangle;
        if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isConsumed()) {
            return;
        }
        if (!(this.getModel() instanceof HeaderTableModel)) {
            return;
        }
        HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this.isClickOnIcon(point) || mouseEvent.getClickCount() == 2) {
            Map<Integer, Integer>[] mapArray = null;
            if (!headerTableModel.isRowHeader()) {
                mapArray = PivotTablePane.getTableColumnWidth(this);
            }
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            Object[] objectArray = this.getPivotTablePane().saveSelection();
            headerTableModel.toggle(n, n2);
            this.getPivotTablePane().loadSelection(objectArray, false, true);
            if (mapArray != null) {
                PivotTablePane.setTableColumnWidth(this, mapArray);
            }
            mouseEvent.consume();
        } else if (this._pivotTablePane.getHeaderSelectionMode() != 0 && (rectangle = this.getCellRect(n, n2, false)).contains(point)) {
            if (!mouseEvent.isShiftDown()) {
                this._anchorRow = n;
                this._anchorCol = n2;
                this._adjusting = true;
                try {
                    this._pivotTablePane.selectDataCells(headerTableModel.isRowHeader(), n, n2, mouseEvent.isControlDown());
                }
                finally {
                    this._adjusting = false;
                }
                this.setStartDraggingPoint(point);
            } else if (this._anchorRow >= 0 && this._anchorCol >= 0) {
                this._adjusting = true;
                try {
                    this._pivotTablePane.selectDataCellsBetween(headerTableModel.isRowHeader(), this._anchorRow, this._anchorCol, n, n2, mouseEvent.isControlDown());
                }
                finally {
                    this._adjusting = false;
                }
            }
        }
    }

    protected boolean isClickOnIcon(Point point) {
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        if (n < 0 || n2 < 0 || this.getHeaderTableModel() == null) {
            return false;
        }
        Rectangle rectangle = this.getCellRect(n, n2, false);
        boolean bl = true;
        Expandable expandable = this.getHeaderTableModel().getExpandable(n, n2);
        if (expandable == null || !this.isExpandIconVisible(expandable)) {
            bl = false;
        }
        int n3 = (16 - this.getCollapsedIcon().getIconWidth()) / 2 + 2;
        int n4 = n3 + this.getCollapsedIcon().getIconWidth();
        boolean bl2 = this.getComponentOrientation().isLeftToRight();
        boolean bl3 = bl2 ? point.x > rectangle.x + n3 && point.x < rectangle.x + n4 : point.x > rectangle.x + rectangle.width - n4 && point.x < rectangle.x + rectangle.width - n3;
        return bl && bl3 && point.y > rectangle.y && point.y < rectangle.y + this.getRowHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMouseDraggedEvent(MouseEvent mouseEvent, Point point) {
        if (point == null) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isConsumed()) {
            return;
        }
        if (!(this.getModel() instanceof HeaderTableModel)) {
            return;
        }
        HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        Point point2 = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        int n3 = this.rowAtPoint(point2);
        int n4 = this.columnAtPoint(point2);
        if (!(n3 == -1 && n4 == -1 || this._pivotTablePane.getHeaderSelectionMode() == 0 || mouseEvent.isShiftDown() || mouseEvent.isControlDown())) {
            this._adjusting = true;
            try {
                this._pivotTablePane.selectDataCellsBetween(headerTableModel.isRowHeader(), n, n2, n3, n4);
            }
            finally {
                this._adjusting = false;
            }
        }
    }

    private void showContextMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && !mouseEvent.isConsumed() && this.isShowContextMenu()) {
            int n;
            Point point = mouseEvent.getPoint();
            int n2 = this.rowAtPoint(point);
            JPopupMenu jPopupMenu = this.createContextMenu(n2, n = this.columnAtPoint(point));
            if (jPopupMenu == null) {
                return;
            }
            if (jPopupMenu.getComponentCount() > 0) {
                JideSwingUtilities.showPopupMenu(jPopupMenu, this, point.x, point.y);
            }
        }
    }

    protected String convertValuesToString(Values values, boolean bl) {
        PivotField[] pivotFieldArray = bl ? this._pivotTablePane.getPivotDataModel().getRowFields() : this._pivotTablePane.getPivotDataModel().getColumnFields();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < values.getCount(); ++i) {
            Value value = values.getValueAt(i);
            if (value != null && value.getValue() != null) {
                Class<?> clazz = TypeUtils.convertPrimitiveToWrapperType(pivotFieldArray[i].getType());
                if (!clazz.isAssignableFrom(TypeUtils.convertPrimitiveToWrapperType(value.getValue().getClass()))) {
                    stringBuffer = new StringBuffer();
                    break;
                }
                stringBuffer.append(ObjectConverterManager.toString(value.getValue(), pivotFieldArray[i].getType(), pivotFieldArray[i].getConverterContext()));
            }
            if (i == values.getCount() - 1) continue;
            stringBuffer.append("; ");
        }
        return stringBuffer.toString();
    }

    protected JPopupMenu createContextMenu(final int n, final int n2) {
        Object object;
        Object object2;
        int n3;
        JMenuItem jMenuItem;
        boolean bl;
        Object object3;
        boolean bl2;
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        if (!(this.getModel() instanceof HeaderTableModel) || n < 0 || n2 < 0) {
            return null;
        }
        final HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        boolean bl3 = headerTableModel.isExpandable(n, n2);
        boolean bl4 = bl2 = bl3 && headerTableModel.isExpanded(n, n2);
        if (bl3) {
            String string = ObjectConverterManager.toString(headerTableModel.getValueAt(n, n2), headerTableModel.getCellClassAt(n, n2), headerTableModel.getConverterContextAt(n, n2));
            object3 = new JMenuItem(new AbstractAction(MessageFormat.format(bl2 ? this._pivotTablePane.getResourceString("HeaderTable.collapse") : this._pivotTablePane.getResourceString("HeaderTable.expand"), string)){
                private static final long serialVersionUID = -1922964687650823793L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (bl2) {
                        headerTableModel.collapse(n, n2);
                    } else {
                        headerTableModel.expand(n, n2);
                    }
                }
            });
            ((Component)object3).setName("HeaderTable.expand");
            jidePopupMenu.add((JMenuItem)object3);
            jidePopupMenu.addSeparator();
        }
        boolean bl5 = headerTableModel.isRowHeader() ? n2 == headerTableModel.getColumnCount() - 1 : (bl = n == headerTableModel.getRowCount() - 1);
        if (!bl) {
            object3 = null;
            if (headerTableModel.isRowHeader() && headerTableModel.getPivotDataModel().getRowFields().length > n2) {
                object3 = headerTableModel.getPivotDataModel().getRowFields()[n2].getTitle();
            } else if (!headerTableModel.isRowHeader() && headerTableModel.getPivotDataModel().getColumnFields().length > n) {
                object3 = headerTableModel.getPivotDataModel().getColumnFields()[n].getTitle();
            }
            if (object3 != null) {
                jMenuItem = new JMenuItem(new AbstractAction(MessageFormat.format(this._pivotTablePane.getResourceString("HeaderTable.expand"), object3)){
                    private static final long serialVersionUID = -1440227287587987403L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        headerTableModel.expand(headerTableModel.isRowHeader() ? n2 : n);
                    }
                });
                jMenuItem.setName("HeaderTable.expandColumn");
                jidePopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem(new AbstractAction(MessageFormat.format(this._pivotTablePane.getResourceString("HeaderTable.collapse"), object3)){
                    private static final long serialVersionUID = -3276704545148986941L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        headerTableModel.collapse(headerTableModel.isRowHeader() ? n2 : n);
                    }
                });
                jMenuItem.setName("HeaderTable.collapseColumn");
                jidePopupMenu.add(jMenuItem);
                jidePopupMenu.addSeparator();
            }
        }
        object3 = new JMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("HeaderTable.expandAll")){
            private static final long serialVersionUID = 2012145597420606832L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (headerTableModel.isRowHeader()) {
                    PivotField[] pivotFieldArray = HeaderTable.this.getPivotTablePane().getHiddenRowFields();
                    int[] nArray = new int[pivotFieldArray.length];
                    PivotField[] pivotFieldArray2 = HeaderTable.this.getPivotTablePane().getPivotDataModel().getRowFields();
                    block0: for (int i = 0; i < nArray.length; ++i) {
                        for (int j = 0; j < pivotFieldArray2.length; ++j) {
                            if (pivotFieldArray[i] != pivotFieldArray2[j]) continue;
                            nArray[i] = j;
                            continue block0;
                        }
                    }
                    headerTableModel.expandAll(nArray);
                } else {
                    headerTableModel.expandAll();
                }
            }
        });
        ((Component)object3).setName("HeaderTable.expandAll");
        jidePopupMenu.add((JMenuItem)object3);
        object3 = new JMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("HeaderTable.collapseAll")){
            private static final long serialVersionUID = 8212290915900686491L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (headerTableModel.isRowHeader()) {
                    PivotField[] pivotFieldArray = HeaderTable.this.getPivotTablePane().getHiddenRowFields();
                    int[] nArray = new int[pivotFieldArray.length];
                    PivotField[] pivotFieldArray2 = HeaderTable.this.getPivotTablePane().getPivotDataModel().getRowFields();
                    block0: for (int i = 0; i < nArray.length; ++i) {
                        for (int j = 0; j < pivotFieldArray2.length; ++j) {
                            if (pivotFieldArray[i] != pivotFieldArray2[j]) continue;
                            nArray[i] = j;
                            continue block0;
                        }
                    }
                    headerTableModel.collapseAll(nArray);
                } else {
                    headerTableModel.collapseAll();
                }
            }
        });
        ((Component)object3).setName("HeaderTable.collapseAll");
        jidePopupMenu.add((JMenuItem)object3);
        if (jidePopupMenu.getComponentCount() > 0) {
            jidePopupMenu.addSeparator();
        }
        if (!headerTableModel.isDataCell(n, n2)) {
            jidePopupMenu.add(new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this._pivotTablePane.getLocale()).getString("Sort.ascending")){
                private static final long serialVersionUID = 5582099941772432905L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this.sort(n, n2, 1);
                }
            }));
            jidePopupMenu.add(new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this._pivotTablePane.getLocale()).getString("Sort.descending")){
                private static final long serialVersionUID = -7359840126731625241L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this.sort(n, n2, -1);
                }
            }));
            jidePopupMenu.add(new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this._pivotTablePane.getLocale()).getString("Sort.unsort")){
                private static final long serialVersionUID = 6728823837181610987L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this.sort(n, n2, 0);
                }
            }));
            if (jidePopupMenu.getComponentCount() > 0) {
                jidePopupMenu.addSeparator();
            }
        }
        if (this._pivotTablePane.getHeaderSelectionMode() != 1) {
            jMenuItem = new JMenu(this._pivotTablePane.getResourceString("HeaderTable.filter"));
            jMenuItem.setName("HeaderTable.filter");
            n3 = 3;
            JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("HeaderTable.keepSelectedValues")){
                private static final long serialVersionUID = 4097882012902520185L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this._pivotTablePane.filterSelectedHeaderValues(headerTableModel.isRowHeader(), false);
                }
            });
            jMenuItem2.setName("HeaderTable.keepSelectedValues");
            ((JMenu)jMenuItem).add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("HeaderTable.filterSelectedCells")){
                private static final long serialVersionUID = 4913404928467771126L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this._pivotTablePane.filterSelectedHeaderValues(headerTableModel.isRowHeader(), true);
                }
            });
            jMenuItem3.setName("HeaderTable.filterSelectedCells");
            ((JMenu)jMenuItem).add(jMenuItem3);
            object2 = new JMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("HeaderTable.clearFilter")){
                private static final long serialVersionUID = -1510545609357884280L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (HeaderTable.this.getTableSelectionModel().getMaxSelectedRowIndex() == -1) {
                        HeaderTable.this._pivotTablePane.clearFilter(headerTableModel.isRowHeader(), n, n, n2, n2);
                    } else {
                        HeaderTable.this._pivotTablePane.clearFilter(headerTableModel.isRowHeader(), HeaderTable.this.getTableSelectionModel().getMinSelectedRowIndex(), HeaderTable.this.getTableSelectionModel().getMaxSelectedRowIndex(), HeaderTable.this.getTableSelectionModel().getMinSelectedColumnIndex(), HeaderTable.this.getTableSelectionModel().getMaxSelectedColumnIndex());
                    }
                }
            });
            ((Component)object2).setName("HeaderTable.clearFilter");
            ((JMenu)jMenuItem).add((JMenuItem)object2);
            if (!this._pivotTablePane.isSelectedHeaderFilterable(headerTableModel.isRowHeader(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMinSelectedRowIndex() : this.getSelectionModel().getMinSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMaxSelectedRowIndex() : this.getSelectionModel().getMaxSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMinSelectedColumnIndex() : this.getColumnModel().getSelectionModel().getMinSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMaxSelectedColumnIndex() : this.getColumnModel().getSelectionModel().getMaxSelectionIndex())) {
                jMenuItem2.setEnabled(false);
                jMenuItem3.setEnabled(false);
                n3 -= 2;
            }
            if (this.getTableSelectionModel().getMaxSelectedRowIndex() == -1) {
                if (!this._pivotTablePane.isFiltering(headerTableModel.isRowHeader(), n, n, n2, n2)) {
                    ((JMenuItem)object2).setEnabled(false);
                    --n3;
                }
            } else if (!this._pivotTablePane.isFiltering(headerTableModel.isRowHeader(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMinSelectedRowIndex() : this.getSelectionModel().getMinSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMaxSelectedRowIndex() : this.getSelectionModel().getMaxSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMinSelectedColumnIndex() : this.getColumnModel().getSelectionModel().getMinSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMaxSelectedColumnIndex() : this.getColumnModel().getSelectionModel().getMaxSelectionIndex())) {
                ((JMenuItem)object2).setEnabled(false);
                --n3;
            }
            if (n3 != 0) {
                jidePopupMenu.add(jMenuItem);
                jidePopupMenu.addSeparator();
            }
        }
        if (this.getPivotTablePane().getHeaderSelectionMode() == 1) {
            int n4;
            int n5 = headerTableModel.isRowHeader() ? n2 : n;
            n3 = -1;
            if (this.getPivotTablePane().getPivotDataModel().getDataFields().length > 0) {
                n3 = headerTableModel.isRowHeader() ? n : n2;
            }
            int n6 = headerTableModel.isRowHeader() ? headerTableModel.getColumnCount() : headerTableModel.getRowCount();
            int n7 = headerTableModel.isDataFieldAdded() ? n6 - 2 : n6 - 1;
            object2 = headerTableModel.getFlatData();
            int n8 = n4 = headerTableModel.isDataFieldAdded() ? this.getPivotTablePane().getPivotDataModel().getDataFields().length : 1;
            if (n5 <= n7 && n3 >= 0 && n3 < object2.size() * n4 && (object = object2.get(n3 / n4)) instanceof Values && !(object instanceof SummaryValues) && !(object instanceof GrandTotalValues) && !(object instanceof RunningSummaryValues)) {
                Object object4;
                int n9 = (headerTableModel.isRowHeader() ? n2 : n) + 1;
                if (((Values)object).getCount() > n9) {
                    object4 = new Value[n9];
                    for (int i = 0; i < ((Value[])object4).length; ++i) {
                        object4[i] = ((Values)object).getValueAt(i);
                    }
                    object = new DefaultValues((Value[])object4);
                }
                if ((object4 = this.convertValuesToString((Values)object, headerTableModel.isRowHeader())) != null && ((String)object4).length() > 0) {
                    object3 = new JMenuItem(new AbstractAction(MessageFormat.format(this._pivotTablePane.getResourceString("HeaderTable.hide"), object4)){
                        private static final long serialVersionUID = -187727219542746580L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            HeaderTable.this._pivotTablePane.hideValuesAt(headerTableModel.isRowHeader(), n, n2);
                        }
                    });
                    ((Component)object3).setName("HeaderTable.hide");
                    jidePopupMenu.add((JMenuItem)object3);
                }
            }
        } else {
            object3 = new JMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("HeaderTable.hideSelect")){
                private static final long serialVersionUID = -187727219542746580L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this._pivotTablePane.hideSelectedHeaderValues(headerTableModel.isRowHeader());
                }
            });
            ((Component)object3).setName("HeaderTable.hide");
            jidePopupMenu.add((JMenuItem)object3);
        }
        if (this._pivotTablePane.getPivotDataModel().hasHiddenValues()) {
            JMenu jMenu = new JMenu(this._pivotTablePane.getResourceString("HeaderTable.show"));
            Values[] valuesArray = this._pivotTablePane.getPivotDataModel().getHiddenValues();
            if (this._pivotTablePane.getPivotDataModel() instanceof PivotDataModel) {
                valuesArray = headerTableModel.isRowHeader() ? ((PivotDataModel)this._pivotTablePane.getPivotDataModel()).getHiddenRowValues() : ((PivotDataModel)this._pivotTablePane.getPivotDataModel()).getHiddenColumnValues();
            }
            for (final Values values : valuesArray) {
                if (values == null || ((String)(object = this.convertValuesToString(values, headerTableModel.isRowHeader()))).length() <= 0) continue;
                JMenuItem jMenuItem4 = new JMenuItem(new AbstractAction((String)object){
                    private static final long serialVersionUID = 6973874074653119777L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HeaderTable.this._pivotTablePane.removeHiddenValues(values);
                    }
                });
                jMenu.add(jMenuItem4);
            }
            jMenu.setName("HeaderTable.show");
            jMenu.setEnabled(this._pivotTablePane.getPivotDataModel().hasHiddenValues());
            if (jMenu.getPopupMenu().getComponentCount() > 0) {
                jidePopupMenu.add(jMenu);
            }
        }
        object3 = new JMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("HeaderTable.showAll")){
            private static final long serialVersionUID = 6973874074653119776L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeaderTable.this._pivotTablePane.clearHiddenValues();
            }
        });
        ((Component)object3).setName("HeaderTable.showAll");
        ((JMenuItem)object3).setEnabled(this._pivotTablePane.getPivotDataModel().hasHiddenValues());
        jidePopupMenu.add((JMenuItem)object3);
        jidePopupMenu.addSeparator();
        if (headerTableModel.isRowHeader()) {
            object3 = new JMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("HeaderTable.hideColumn")){
                private static final long serialVersionUID = -3592530306539431491L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PivotField[] pivotFieldArray = HeaderTable.this._pivotTablePane.getPivotDataModel().getRowFields();
                    if (n2 >= 0 && n2 < pivotFieldArray.length) {
                        HeaderTable.this._pivotTablePane.addHiddenRowField(pivotFieldArray[n2]);
                    }
                }
            });
            ((Component)object3).setName("HeaderTable.hideColumn");
            ((JMenuItem)object3).setEnabled(this._pivotTablePane.getVisibleHeaderTableColumnCount() > 1);
            jidePopupMenu.add((JMenuItem)object3);
            object3 = new JMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("HeaderTable.showAllColumn")){
                private static final long serialVersionUID = 441529161140264925L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this._pivotTablePane.clearHiddenRowFields();
                }
            });
            ((Component)object3).setName("HeaderTable.showAllColumn");
            ((JMenuItem)object3).setEnabled(this._pivotTablePane.hasHiddenRowField());
            jidePopupMenu.add((JMenuItem)object3);
            jidePopupMenu.addSeparator();
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("HeaderTable.showGrandTotal")){
            private static final long serialVersionUID = -3592530306539431491L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (headerTableModel.isRowHeader()) {
                    HeaderTable.this._pivotTablePane.getPivotDataModel().setShowGrandTotalForRow(jCheckBoxMenuItem.isSelected());
                } else {
                    HeaderTable.this._pivotTablePane.getPivotDataModel().setShowGrandTotalForColumn(jCheckBoxMenuItem.isSelected());
                }
                HeaderTable.this._pivotTablePane.bothHeadersUpdated();
            }
        });
        jCheckBoxMenuItem.setSelected(headerTableModel.isRowHeader() ? this._pivotTablePane.getPivotDataModel().isShowGrandTotalForRow() : this._pivotTablePane.getPivotDataModel().isShowGrandTotalForColumn());
        jidePopupMenu.add(jCheckBoxMenuItem);
        PivotTablePane.PopupMenuCustomizer popupMenuCustomizer = this._pivotTablePane.getHeaderTablePopupMenuCustomizer();
        if (popupMenuCustomizer != null) {
            if (popupMenuCustomizer instanceof PivotTablePane.TablePopupMenuCustomizer) {
                ((PivotTablePane.TablePopupMenuCustomizer)popupMenuCustomizer).customize(jidePopupMenu, this, n, n2);
            } else {
                popupMenuCustomizer.customize(jidePopupMenu, this);
            }
        }
        return jidePopupMenu;
    }

    public void expandAll() {
        HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        headerTableModel.expandAll();
    }

    public void collapseAll() {
        HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        headerTableModel.collapseAll();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this._renderer == null) {
            this._renderer = this.createCellRenderer();
        }
        if (this._renderer instanceof HeaderTableCellRenderer) {
            TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
            ((HeaderTableCellRenderer)this._renderer).setActualCellRenderer(tableCellRenderer);
            return this._renderer;
        }
        return super.getCellRenderer(n, n2);
    }

    @Override
    protected void collectCellStyles(int n, int n2) {
        super.collectCellStyles(n, n2);
        this._cellStyleList.add(0, HEADER_STYLE);
    }

    @Override
    public boolean isCellSelected(int n, int n2) {
        return this._pivotTablePane.getHeaderSelectionMode() != 1 && super.isCellSelected(n, n2);
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (this._pivotTablePane.getHeaderSelectionMode() != 1) {
            super.changeSelection(n, n2, bl, bl2);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._init) {
            this._renderer = this.createCellRenderer();
            this.updateTable(this._pivotTablePane.isPlainHeaderTables(), this._pivotTablePane.getHeaderSelectionMode());
        }
    }

    public PivotTablePane getPivotTablePane() {
        return this._pivotTablePane;
    }

    @Override
    public Expandable getExpandableAt(int n, int n2) {
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        return headerTableModel == null ? null : headerTableModel.getExpandable(n, n2);
    }

    public HeaderTableModel getHeaderTableModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof HeaderTableModel) {
            return (HeaderTableModel)tableModel;
        }
        return null;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        Point point;
        MouseEvent mouseEvent;
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton(mouseEvent = (MouseEvent)eventObject) && this.isClickOnIcon(point = mouseEvent.getPoint())) {
            return false;
        }
        return super.editCellAt(n, n2, eventObject);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        CellSpan cellSpan;
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        if (headerTableModel != null && headerTableModel.isRowHeader() && (cellSpan = this.getCellSpanAt(n, n2)) != null && cellSpan.getColumnSpan() > 1) {
            PivotField[] pivotFieldArray;
            PivotField pivotField = headerTableModel.getFieldAt(cellSpan.getRow(), cellSpan.getColumn());
            for (PivotField pivotField2 : pivotFieldArray = this.getPivotTablePane().getHiddenRowFields()) {
                if (pivotField2 != pivotField) continue;
                return null;
            }
        }
        return super.getValueAt(n, n2);
    }

    @Override
    public boolean needAdjustCellValueString(int n, int n2) {
        return false;
    }

    @Override
    public String getValueAtInString(int n, int n2, ValueConverter valueConverter) {
        Object object = this.getValueAt(n, n2);
        if (valueConverter != null) {
            object = valueConverter.convert(this, object, n, n2);
        }
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        Class<?> clazz = this.getCellClassAt(n, n2);
        ConverterContext converterContext = this.getConverterContextAt(n, n2);
        String string = ObjectConverterManager.toString(object, clazz, converterContext);
        if (headerTableModel == null) {
            return string;
        }
        Expandable expandable = headerTableModel.getExpandable(n, n2);
        return this.appendSummaryOrTotal(n, n2, (Value)((Object)expandable), string);
    }

    private String appendSummaryOrTotal(int n, int n2, Value value, String string) {
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        if (headerTableModel == null) {
            return string;
        }
        if (value instanceof SummaryValue && !headerTableModel.isDataCell(n, n2)) {
            int n3 = ((SummaryValue)value).getSummaryType();
            string = MessageFormat.format(this._pivotTablePane.getResourceString("Renderer.totalPhrase"), string, n3 == -1 ? this._pivotTablePane.getResourceString("Renderer.total") : headerTableModel.getPivotDataModel().getSummaryCalculator().getSummaryName(this.getLocale(), n3));
        } else if (value instanceof RunningSummaryValue && !headerTableModel.isDataCell(n, n2)) {
            string = this.getRunningSummaryTitle((RunningSummaryValue)value, string);
        } else if (value instanceof GrandTotalValue && !headerTableModel.isDataCell(n, n2)) {
            String string2;
            PivotField[] pivotFieldArray = headerTableModel.getPivotDataModel().getDataFields();
            int n4 = 0;
            boolean bl = false;
            if (pivotFieldArray != null) {
                for (int i = 0; i < pivotFieldArray.length; ++i) {
                    if (i == 0) {
                        n4 = pivotFieldArray[i].getGrandTotalSummaryType();
                        continue;
                    }
                    if (n4 == pivotFieldArray[i].getGrandTotalSummaryType()) continue;
                    bl = true;
                }
            }
            if (headerTableModel.isRowHeader()) {
                try {
                    string2 = this._pivotTablePane.getResourceString("Renderer.grandTotal.row");
                }
                catch (Exception exception) {
                    string2 = null;
                }
            } else {
                try {
                    string2 = this._pivotTablePane.getResourceString("Renderer.grandTotal.column");
                }
                catch (Exception exception) {
                    string2 = null;
                }
            }
            string = string2 != null ? string2 : (bl ? MessageFormat.format(this._pivotTablePane.getResourceString("Renderer.grandTotalPhrase"), this._pivotTablePane.getResourceString("Renderer.grandTotal"), this._pivotTablePane.getResourceString("Renderer.mixed")) : (n4 == 0 ? this._pivotTablePane.getResourceString("Renderer.grandTotal") : MessageFormat.format(this._pivotTablePane.getResourceString("Renderer.grandTotalPhrase"), this._pivotTablePane.getResourceString("Renderer.grandTotal"), n4 == -1 ? this._pivotTablePane.getResourceString("Renderer.total") : headerTableModel.getPivotDataModel().getSummaryCalculator().getSummaryName(this.getLocale(), n4))));
        }
        return string;
    }

    protected String getRunningSummaryTitle(RunningSummaryValue runningSummaryValue, String string) {
        if (runningSummaryValue == null) {
            return string;
        }
        if (runningSummaryValue.getRunningType() == 3 || runningSummaryValue.getRunningType() == 4) {
            return MessageFormat.format(this._pivotTablePane.getResourceString("Renderer.runningTotalPhrase"), string, this._pivotTablePane.getRunningTypeName(runningSummaryValue.getRunningType()));
        }
        if (runningSummaryValue.getRunningType() == 1 || runningSummaryValue.getRunningType() == 2) {
            return MessageFormat.format(this._pivotTablePane.getResourceString("Renderer.runningTotalPhrase"), string, this._pivotTablePane.getRunningTypeName(runningSummaryValue.getRunningType()) + " " + ObjectConverterManager.toString(runningSummaryValue.getCompareTo(), RunningSummary.CompareToObject.class, CompareToConverter.CONTEXT));
        }
        return MessageFormat.format(this._pivotTablePane.getResourceString("Renderer.runningTotalPhrase2"), string, this._pivotTablePane.getRunningTypeName(runningSummaryValue.getRunningType()), ObjectConverterManager.toString(runningSummaryValue.getCompareTo(), RunningSummary.CompareToObject.class, CompareToConverter.CONTEXT));
    }

    private void sort(int n, int n2, int n3) {
        CellSpan cellSpan;
        HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        PivotField pivotField = headerTableModel.getFieldAt((cellSpan = headerTableModel.getCellSpanAt(n, n2)).getRow(), cellSpan.getColumn());
        if (pivotField != null) {
            pivotField.setSortOrder(n3);
        }
    }

    private Point getStartDraggingPoint() {
        return this._startDraggingPoint;
    }

    private void setStartDraggingPoint(Point point) {
        this._startDraggingPoint = point;
    }

    public boolean isShowContextMenu() {
        return this._showContextMenu;
    }

    public void setShowContextMenu(boolean bl) {
        this._showContextMenu = bl;
    }

    public boolean isUseNativeRenderer() {
        return this._useNativeRenderer;
    }

    public void setUseNativeRenderer(boolean bl) {
        this._useNativeRenderer = bl;
    }

    static {
        HEADER_STYLE.setHorizontalAlignment(10);
        HEADER_STYLE.setVerticalAlignment(1);
        HEADER_STYLE.setPriority(-1);
    }

    protected class DelegateExpandMouseInputListener
    extends DelegateMouseInputListener {
        public DelegateExpandMouseInputListener(MouseInputListener mouseInputListener) {
            super(mouseInputListener);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            HeaderTable.this.handleMousePressedEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                HeaderTable.this.showContextMenu(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                super.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            HeaderTable.this.showContextMenu(mouseEvent);
            if (HeaderTable.this._autoScroll != null) {
                HeaderTable.this._autoScroll.mouseReleased(mouseEvent);
            }
            HeaderTable.this.setStartDraggingPoint(null);
            if (!mouseEvent.isConsumed()) {
                super.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            HeaderTable.this.handleMouseDraggedEvent(mouseEvent, HeaderTable.this.getStartDraggingPoint());
            if (HeaderTable.this._autoScroll != null) {
                HeaderTable.this._autoScroll.mouseDragged(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                super.mouseDragged(mouseEvent);
            }
        }
    }

    protected class ExpandMouseListener
    implements MouseMotionListener,
    MouseListener {
        protected ExpandMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            HeaderTable.this.showContextMenu(mouseEvent);
            if (HeaderTable.this._autoScroll != null) {
                HeaderTable.this._autoScroll.mouseReleased(mouseEvent);
            }
            HeaderTable.this.setStartDraggingPoint(null);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            HeaderTable.this.handleMouseDraggedEvent(mouseEvent, HeaderTable.this.getStartDraggingPoint());
            if (HeaderTable.this._autoScroll != null) {
                HeaderTable.this._autoScroll.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            HeaderTable.this.handleMousePressedEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                HeaderTable.this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

