/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.combobox.CheckBoxListChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.filter.CustomFilterEditor;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.FilterFactoryManager;
import com.jidesoft.grid.AbstractDynamicTableFilter;
import com.jidesoft.grid.CustomFilterEditorDialog;
import com.jidesoft.grid.CustomValueFilterListSelectionModel;
import com.jidesoft.grid.DynamicTableFilter;
import com.jidesoft.grid.GridResource;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.pivot.FieldBoxInputListener;
import com.jidesoft.pivot.FieldListCellRenderer;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import com.jidesoft.swing.HeaderBox;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.ListSearchable;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.TypeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicButtonListener;

public class FieldBox
extends HeaderBox
implements PropertyChangeListener {
    public static final String PROPERTY_SORT_ARROW_VISIBLE = "sortArrowVisible";
    public static final String PROPERTY_FILTER_BUTTON_VISIBLE = "filterButtonVisible";
    public static final String PROPERTY_ASCENDING = "ascending";
    public static final String PROPERTY_SORT_ORDER = "sortOrder";
    public static final String PROPERTY_SORT_BY = "sortBy";
    public static final String PROPERTY_SORT_BY_ROW = "sortByRow";
    public static final String PROPERTY_POSSIBLE_VALUES = "possibleValues";
    public static final String PROPERTY_SELECTED_POSSIBLE_VALUES = "selectedPossibleValues";
    public static final String PROPERTY_FILTER = "filter";
    private JLabel _label;
    private JLabel _sortArrow;
    private JLabel _filterIcon;
    AbstractButton _filterButton;
    private Icon _downIcon = new ArrowIcon(5);
    private Icon _upIcon = new ArrowIcon(1);
    private PivotField _field;
    private PivotTablePane _pivotTablePane;
    protected Object HIDE_POPUP_KEY = null;
    private List<DynamicTableFilter> _dynamicFilters;
    private boolean _sortArrowVisible = true;
    private boolean _filterButtonVisible = true;
    private Object[] _possibleValues;
    private JidePopup _popup;
    private Dimension _preferredSize = null;
    private transient boolean _isLast;
    private transient boolean _isFirst;

    public FieldBox() {
        this.initComponents(null, "", null, "", false, false);
    }

    public FieldBox(PivotField pivotField) {
        this.initComponents(pivotField, pivotField.getTitle(), pivotField.getIcon(), pivotField.getDescription(), true, pivotField.isFilterable());
    }

    public FieldBox(PivotField pivotField, String string) {
        this.initComponents(pivotField, string, pivotField.getIcon(), pivotField.getDescription(), true, pivotField.isFilterable());
    }

    public FieldBox(PivotField pivotField, Icon icon) {
        this.initComponents(pivotField, pivotField.getTitle(), icon, pivotField.getDescription(), true, pivotField.isFilterable());
    }

    public FieldBox(PivotField pivotField, String string, Icon icon) {
        this.initComponents(pivotField, string, icon, string, true, true);
    }

    public FieldBox(PivotField pivotField, boolean bl, boolean bl2) {
        this.initComponents(pivotField, pivotField.getTitle(), pivotField.getIcon(), pivotField.getDescription(), bl, bl2);
    }

    public FieldBox(PivotField pivotField, String string, Icon icon, boolean bl, boolean bl2) {
        this.initComponents(pivotField, string, icon, string, bl, bl2);
    }

    public FieldBox(PivotField pivotField, String string, Icon icon, String string2, boolean bl, boolean bl2) {
        this.initComponents(pivotField, string, icon, string2, bl, bl2);
    }

    protected void initComponents(PivotField pivotField, String string, Icon icon, String string2, boolean bl, boolean bl2) {
        this._field = pivotField;
        this.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = -8648094766925746268L;

            @Override
            public boolean isPressed() {
                return (FieldBox.this._field == null || FieldBox.this._field.isSortable()) && super.isPressed();
            }
        });
        if (bl2) {
            bl2 = pivotField.isFilterable();
        }
        this._filterButtonVisible = bl2;
        this._sortArrowVisible = bl;
        this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 4));
        this.setBorderPainted(true);
        JideBoxLayout jideBoxLayout = new JideBoxLayout(this, 0, 4);
        jideBoxLayout.setAlwaysLayout(true);
        this.setLayout(jideBoxLayout);
        this._filterIcon = new JLabel();
        this._filterIcon.setOpaque(false);
        this._filterIcon.setVerticalAlignment(0);
        this.add((Component)this._filterIcon, "fix");
        this.setFilterIconVisible(false);
        this._label = new JLabel(icon, 10);
        this.setTitle(string == null ? this.getField().getTitle() : string);
        this._label.setOpaque(false);
        this.setToolTipText(string2);
        this.add(this._label);
        this._sortArrow = new JLabel(this._upIcon);
        this._sortArrow.setOpaque(false);
        this._sortArrow.setVerticalAlignment(0);
        if (this.getField().getSortByColumnKeys() == null && this.getField().getSortByRowKeys() == null) {
            if (this.getField().getSortOrder() != 0) {
                this._sortArrow.setIcon(this.getField().isAscending() ? this._upIcon : this._downIcon);
            } else {
                this._sortArrow.setIcon(null);
            }
        } else {
            this._sortArrow.setIcon(null);
        }
        this.add((Component)this._sortArrow, "fix");
        this._sortArrow.setVisible(this.isSortArrowVisible() && this.getField().isSortable());
        this.addFilterButton();
        this.installListeners();
    }

    private void addFilterButton() {
        this._filterButton = this.createDefaultButton();
        this._filterButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 8599992033335287609L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FieldBox.this.isPopupVisible()) {
                    FieldBox.this.hidePopup();
                } else {
                    Object object;
                    FieldBox.this._pivotTablePane.updatePossibleValues(FieldBox.this);
                    Object[] objectArray = FieldBox.this.getPossibleValues();
                    PopupPanel popupPanel = FieldBox.this.createPopupPanel(FieldBox.this._pivotTablePane, FieldBox.this._field, objectArray);
                    JideSwingUtilities.putClientPropertyRecursively(popupPanel, "doNotCancelPopup", FieldBox.this.HIDE_POPUP_KEY);
                    FieldBox.this.requestFocus();
                    FieldBox.this._popup = FieldBox.this.createPopupWindow();
                    FieldBox.this._popup.addPopupMenuListener(new PopupMenuListener(){

                        @Override
                        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                        }

                        @Override
                        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                            if (FieldBox.this._popup != null) {
                                FieldBox.this._preferredSize = FieldBox.this._popup.getSize();
                                if (FieldBox.this._pivotTablePane != null && FieldBox.this._pivotTablePane.isShowFilterButtonsOnMouseOver()) {
                                    FieldBox.this.showFilterButtonVisible(false);
                                }
                            }
                        }

                        @Override
                        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                        }
                    });
                    FieldBox.this._popup.setOwner(FieldBox.this._filterButton);
                    if (FieldBox.this._preferredSize != null) {
                        FieldBox.this._popup.setPreferredSize(FieldBox.this._preferredSize);
                    }
                    FieldBox.this.customizePopupWindow(FieldBox.this._popup, popupPanel);
                    if (popupPanel.isStretchToFit() && popupPanel.getActualPreferredSize().width != FieldBox.this.getWidth()) {
                        object = FieldBox.this._popup.getPopupBorder();
                        int n = 0;
                        if (object != null) {
                            Insets insets = object.getBorderInsets(popupPanel);
                            n = insets.left + insets.right;
                        }
                        int n2 = Math.max(popupPanel.getActualPreferredSize().width, FieldBox.this.getWidth() - n);
                        popupPanel.setPreferredSize(new Dimension(n2, popupPanel.getPreferredSize().height));
                    }
                    if (!FieldBox.this._popup.isPopupVisible()) {
                        object = FieldBox.this.calculatePopupLocation(popupPanel);
                        if (popupPanel.getDefaultFocusComponent() != null) {
                            FieldBox.this._popup.setDefaultFocusComponent(popupPanel.getDefaultFocusComponent());
                        }
                        FieldBox.this._popup.setResizable(popupPanel.isResizable());
                        FieldBox.this._popup.showPopup(((Point)object).x, ((Point)object).y, FieldBox.this._filterButton);
                    } else {
                        FieldBox.this.hidePopup();
                        FieldBox.this._popup = null;
                    }
                }
            }
        });
        this._filterButton.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                FieldBox.this.getModel().setRollover(true);
            }
        });
        this.add((Component)this._filterButton, "fix");
        this._filterButton.setVisible(this.isFilterButtonVisible());
    }

    protected void installListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && FieldBox.this.getField().isSortable()) {
                    FieldBox.this.toggleAscending();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (FieldBox.PROPERTY_ASCENDING.equals(propertyChangeEvent.getPropertyName())) {
                    if (FieldBox.this._sortArrow != null) {
                        FieldBox.this._sortArrow.setIcon(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) ? FieldBox.this._upIcon : FieldBox.this._downIcon);
                    }
                } else if (FieldBox.PROPERTY_SORT_BY.equals(propertyChangeEvent.getPropertyName()) || FieldBox.PROPERTY_SORT_BY_ROW.equals(propertyChangeEvent.getPropertyName())) {
                    if (FieldBox.this._sortArrow != null && propertyChangeEvent.getNewValue() != null) {
                        FieldBox.this._sortArrow.setIcon(null);
                    }
                } else if (FieldBox.PROPERTY_SORT_ORDER.equals(propertyChangeEvent.getPropertyName()) && FieldBox.this._sortArrow != null && (object = propertyChangeEvent.getNewValue()) instanceof Integer) {
                    int n = (Integer)object;
                    switch (n) {
                        case 0: {
                            FieldBox.this._sortArrow.setIcon(null);
                            break;
                        }
                        case 1: {
                            FieldBox.this._sortArrow.setIcon(FieldBox.this._upIcon);
                            break;
                        }
                        case -1: {
                            FieldBox.this._sortArrow.setIcon(FieldBox.this._downIcon);
                        }
                    }
                }
            }
        });
        this._field.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("title".equals(propertyChangeEvent.getPropertyName())) {
            this.setTitle("" + propertyChangeEvent.getNewValue());
        } else if ("description".equals(propertyChangeEvent.getPropertyName())) {
            this.setToolTipText("" + propertyChangeEvent.getNewValue());
        } else if (PROPERTY_FILTER.equals(propertyChangeEvent.getPropertyName())) {
            this.setTitle(this.getField().getTitle());
            this.updateFilterIcon();
        } else if (PROPERTY_SELECTED_POSSIBLE_VALUES.equals(propertyChangeEvent.getPropertyName())) {
            this.setTitle(this.getField().getTitle());
            this.updateFilterIcon();
        } else if ("deselectedPossibleValues".equals(propertyChangeEvent.getPropertyName())) {
            this.setTitle(this.getField().getTitle());
            this.updateFilterIcon();
        } else if ("icon".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue() instanceof Icon) {
                this.setIcon((Icon)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() == null) {
                this.setIcon(null);
            }
        } else if ("filterable".equals(propertyChangeEvent.getPropertyName())) {
            this.setFilterButtonVisible(Boolean.TRUE.equals(propertyChangeEvent.getNewValue()));
        } else if (PROPERTY_SORT_ORDER.equals(propertyChangeEvent.getPropertyName())) {
            this.firePropertyChange(PROPERTY_SORT_ORDER, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        } else if (PROPERTY_ASCENDING.equals(propertyChangeEvent.getPropertyName())) {
            this.firePropertyChange(PROPERTY_ASCENDING, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        } else if (PROPERTY_SORT_BY.equals(propertyChangeEvent.getPropertyName())) {
            this.firePropertyChange(PROPERTY_SORT_BY, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        } else if (PROPERTY_SORT_BY_ROW.equals(propertyChangeEvent.getPropertyName())) {
            this.firePropertyChange(PROPERTY_SORT_BY_ROW, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        } else if ("expandable".equals(propertyChangeEvent.getPropertyName())) {
            if (this._pivotTablePane != null) {
                JTable jTable;
                JTable jTable2 = this._pivotTablePane.getRowHeaderTable();
                if (jTable2 != null) {
                    jTable2.repaint();
                }
                if ((jTable = this._pivotTablePane.getColumnHeaderTable()) != null) {
                    jTable.repaint();
                }
            }
        } else if ("sortable".equals(propertyChangeEvent.getPropertyName())) {
            this._sortArrow.setVisible(this.isSortArrowVisible() && this.getField().isSortable());
        }
    }

    private void initializeDynamicTableFilters() {
        if (this._dynamicFilters == null) {
            this._dynamicFilters = new ArrayList<DynamicTableFilter>();
        }
    }

    public void addDynamicTableFilter(DynamicTableFilter dynamicTableFilter) {
        this.initializeDynamicTableFilters();
        this._dynamicFilters.add(dynamicTableFilter);
    }

    public void removeDynamicTableFilter(DynamicTableFilter dynamicTableFilter) {
        this.initializeDynamicTableFilters();
        this._dynamicFilters.remove(dynamicTableFilter);
    }

    public DynamicTableFilter[] getDynamicTableFilters() {
        this.initializeDynamicTableFilters();
        return this._dynamicFilters.toArray(new DynamicTableFilter[this._dynamicFilters.size()]);
    }

    public void updateFilterIcon() {
        if (this._pivotTablePane != null && this._pivotTablePane.isShowFilterIcon() && this._field.getAreaType() != -1) {
            this.setFilterIconVisible(this._field.getFilter() != null || this._field.getSelectedPossibleValues() != null || this._field.getFilteredPossibleValues() != null);
        } else {
            this.setFilterIconVisible(false);
        }
    }

    protected void uninstallListeners() {
        this._field.removePropertyChangeListener(this);
    }

    public boolean isSortArrowVisible() {
        return this._sortArrowVisible;
    }

    public void setSortArrowVisible(boolean bl) {
        boolean bl2 = this._sortArrowVisible;
        if (bl2 != bl) {
            this._sortArrowVisible = bl;
            this.firePropertyChange(PROPERTY_SORT_ARROW_VISIBLE, bl2, this._sortArrowVisible);
            this._sortArrow.setVisible(this.isSortArrowVisible() && this.getField().isSortable());
        }
    }

    public boolean isFilterButtonVisible() {
        return this._filterButtonVisible;
    }

    void showFilterButtonVisible(boolean bl) {
        this._filterButton.setVisible(bl);
        if (this.isFilterButtonVisible()) {
            this.updateFilterIcon();
            this.doLayout();
        }
    }

    public void setFilterButtonVisible(boolean bl) {
        boolean bl2 = this._filterButtonVisible;
        if (bl2 != bl) {
            this._filterButtonVisible = bl;
            this.firePropertyChange(PROPERTY_FILTER_BUTTON_VISIBLE, bl2, bl);
            this.showFilterButtonVisible(bl && (this._pivotTablePane == null || !this._pivotTablePane.isShowFilterButtonsOnMouseOver()));
        }
    }

    public void setTitle(String string) {
        this._label.setText(string);
    }

    @Override
    public void setIcon(Icon icon) {
        this._label.setIcon(icon);
    }

    @Override
    public void setFont(Font font) {
        if (this._label != null) {
            this._label.setFont(font);
        }
    }

    private void setFilterIconVisible(boolean bl) {
        this._filterIcon.setVisible(bl);
        if (bl && this._pivotTablePane != null) {
            this._filterIcon.setIcon(this._pivotTablePane.getFilterIcon());
        }
    }

    public boolean isAscending() {
        return this.getField().isAscending();
    }

    public void toggleAscending() {
        this.setAscending(!this.isAscending());
    }

    public void setAscending(boolean bl) {
        boolean bl2 = this.getField().isAscending();
        if (bl2 != bl) {
            this.getField().setAscending(bl);
            this.firePropertyChange(PROPERTY_ASCENDING, bl2, bl);
        }
    }

    public Object[] getPossibleValues() {
        return this._possibleValues;
    }

    public void setPossibleValues(Object[] objectArray) {
        Object[] objectArray2 = this._possibleValues;
        this._possibleValues = objectArray;
        this.firePropertyChange(PROPERTY_POSSIBLE_VALUES, objectArray2, objectArray);
    }

    public void setSelectedPossibleValues(Object[] objectArray) {
        this.getField().setSelectedPossibleValues(objectArray);
    }

    public void setFilter(Filter filter) {
        this.getField().setFilter(filter);
    }

    public Object[] getSelectedPossibleValues() {
        return this.getField().getSelectedPossibleValues();
    }

    public Filter getFilter() {
        return this.getField().getFilter();
    }

    protected AbstractButton createDefaultButton() {
        int n;
        Object object;
        JComponent jComponent;
        boolean bl;
        Component component = null;
        boolean bl2 = !UIDefaultsLookup.getBoolean("AbstractComboBox.useJButton");
        boolean bl3 = bl = LookAndFeelFactory.isLnfInstalled("apple.laf.AquaLookAndFeel") && LookAndFeelFactory.isLnfInUse("apple.laf.AquaLookAndFeel") || LookAndFeelFactory.isLnfInstalled("com.apple.laf.AquaLookAndFeel") && LookAndFeelFactory.isLnfInUse("com.apple.laf.AquaLookAndFeel");
        if (!bl) {
            try {
                jComponent = new JComboBox();
                ((JComboBox)jComponent).setEnabled(this.isEnabled());
                ((JComboBox)jComponent).setEditable(true);
                jComponent.doLayout();
                Component[] componentArray = object = jComponent.getComponents();
                int n2 = componentArray.length;
                for (n = 0; n < n2; ++n) {
                    MouseListener[] mouseListenerArray;
                    Component component2 = componentArray[n];
                    if (!(component2 instanceof AbstractButton)) continue;
                    component2.setName("AbstractComboBox.arrowButton");
                    component = (AbstractButton)component2;
                    ((JComponent)component).setBorder(BorderFactory.createEmptyBorder());
                    Dimension dimension = ((JComponent)component).getPreferredSize();
                    int n3 = jComponent.getPreferredSize().height;
                    Insets insets = jComponent.getInsets();
                    int n4 = n3 - (insets != null ? insets.top + insets.bottom : 0);
                    if (dimension.height < 16) {
                        dimension.height = n4;
                    }
                    if (dimension.width < 16) {
                        dimension.width = n4;
                    }
                    ((JComponent)component).setPreferredSize(dimension);
                    ((JComponent)component).setMaximumSize(dimension);
                    for (MouseListener mouseListener : mouseListenerArray = component.getMouseListeners()) {
                        if (mouseListener instanceof BasicButtonListener) continue;
                        component.removeMouseListener(mouseListener);
                    }
                    ((JComponent)component).setRequestFocusEnabled(false);
                    component.setFocusable(false);
                    this.HIDE_POPUP_KEY = ((JComponent)component).getClientProperty("doNotCancelPopup");
                    ((JComponent)component).putClientProperty("doNotCancelPopup", null);
                    break;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (!bl2 || component == null) {
            jComponent = bl ? new JideButton(JideIconsFactory.getImageIcon("jide/direction_down.gif")) : new JButton(JideIconsFactory.getImageIcon("jide/direction_down.gif"));
            jComponent.setRequestFocusEnabled(false);
            jComponent.setFocusable(false);
            jComponent.putClientProperty("doNotCancelPopup", null);
            ((AbstractButton)jComponent).setMargin(component != null ? ((AbstractButton)component).getMargin() : new Insets(0, 0, 0, 0));
            if (component != null) {
                object = ((JComponent)component).getPreferredSize();
                if (object.height < 16) {
                    int n5 = this.getHeight();
                    Insets insets = this.getInsets();
                    object.height = n = n5 - (insets.top + insets.bottom);
                    object.width = n;
                }
                jComponent.setPreferredSize((Dimension)object);
                jComponent.setMaximumSize((Dimension)object);
            } else {
                jComponent.setPreferredSize(new Dimension(16, 16));
                jComponent.setMaximumSize(jComponent.getPreferredSize());
            }
            ((AbstractButton)jComponent).setEnabled(this.isEnabled());
            component = jComponent;
        }
        component.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (FieldBox.this.isFilterButtonVisible() && FieldBox.this._pivotTablePane.isShowFilterButtonsOnMouseOver() && !FieldBox.this.isPopupVisible()) {
                    for (MouseListener mouseListener : FieldBox.this.getMouseListeners()) {
                        if (!(mouseListener instanceof FieldBoxInputListener)) continue;
                        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                        if (((FieldBoxInputListener)mouseListener)._isAboutToDrag || ((FieldBoxInputListener)mouseListener)._isDragging || mouseEvent.getX() >= 0 && mouseEvent.getX() < abstractButton.getWidth() && mouseEvent.getY() >= 0 && mouseEvent.getY() < abstractButton.getHeight()) break;
                        FieldBox.this.showFilterButtonVisible(false);
                        break;
                    }
                }
            }
        });
        return component;
    }

    protected JidePopup createPopupWindow() {
        JidePopup jidePopup = JidePopupFactory.getSharedInstance().createPopup();
        jidePopup.setDetached(false);
        jidePopup.setDefaultMoveOperation(1);
        jidePopup.setPopupBorder(UIDefaultsLookup.getBorder("PopupMenu.border"));
        return jidePopup;
    }

    protected PopupPanel createPopupPanel(final PivotTablePane pivotTablePane, final PivotField pivotField, final Object[] objectArray) {
        final boolean bl = pivotField.isCustomFilterAllowed();
        final DynamicTableFilter[] dynamicTableFilterArray = this.getDynamicTableFilters();
        final int n = bl ? 2 : 1;
        final int n2 = n + (dynamicTableFilterArray != null ? dynamicTableFilterArray.length : 0);
        final CheckBoxListChooserPanel checkBoxListChooserPanel = new CheckBoxListChooserPanel(objectArray, pivotField.getType()){

            @Override
            protected Vector<Object> convertComboBoxModelToVector(ComboBoxModel comboBoxModel) {
                Vector<Object> vector = super.convertComboBoxModelToVector(comboBoxModel);
                vector.add(0, "(All)");
                int n3 = 1;
                if (bl) {
                    vector.add(n3++, "(Custom...)");
                }
                if (dynamicTableFilterArray != null && dynamicTableFilterArray.length > 0) {
                    for (DynamicTableFilter dynamicTableFilter : dynamicTableFilterArray) {
                        vector.add(n3++, dynamicTableFilter);
                    }
                }
                return vector;
            }

            @Override
            protected void setupList(final JList jList) {
                Filter filter;
                super.setupList(jList);
                jList.setLocale(pivotTablePane.getLocale());
                final FieldListCellRenderer fieldListCellRenderer = new FieldListCellRenderer(FieldBox.this.getField().getType()){

                    @Override
                    public String convertElementToString(Locale locale, Object object, Class<?> clazz, ConverterContext converterContext) {
                        return pivotTablePane.convertElementToString(locale, object, clazz, converterContext);
                    }
                };
                fieldListCellRenderer.setConverterContext(FieldBox.this.getField().getConverterContext());
                jList.setCellRenderer(fieldListCellRenderer);
                new ListSearchable(jList){

                    @Override
                    protected String convertElementToString(Object object) {
                        return pivotTablePane.convertElementToString(pivotTablePane.getLocale(), object, fieldListCellRenderer.getType(), fieldListCellRenderer.getConverterContext());
                    }
                };
                CustomValueFilterListSelectionModel customValueFilterListSelectionModel = new CustomValueFilterListSelectionModel(n, n2);
                ((CheckBoxList)jList).setCheckBoxListSelectionModel(customValueFilterListSelectionModel);
                Filter filter2 = filter = bl || dynamicTableFilterArray != null && dynamicTableFilterArray.length > 0 ? FieldBox.this.getFilter() : null;
                if (filter != null) {
                    if (filter instanceof AbstractDynamicTableFilter && dynamicTableFilterArray != null) {
                        int n3;
                        customValueFilterListSelectionModel.clearSelection();
                        for (n3 = 0; n3 < dynamicTableFilterArray.length && dynamicTableFilterArray[n3] != filter; ++n3) {
                        }
                        int n22 = n3 + n;
                        ((CheckBoxListSelectionModel)customValueFilterListSelectionModel).addSelectionInterval(n22, n22);
                    } else {
                        customValueFilterListSelectionModel.clearSelection();
                        ((CheckBoxListSelectionModel)customValueFilterListSelectionModel).addSelectionInterval(1, 1);
                    }
                } else {
                    Object[] objectArray3 = FieldBox.this.getSelectedPossibleValues();
                    if (objectArray3 != null) {
                        customValueFilterListSelectionModel.setValueIsAdjusting(true);
                        block1: for (Object object : objectArray3) {
                            ListModel listModel = jList.getModel();
                            for (int i = 0; i < listModel.getSize(); ++i) {
                                Object e = listModel.getElementAt(i);
                                if (!JideSwingUtilities.equals(e, object)) continue;
                                ((CheckBoxListSelectionModel)customValueFilterListSelectionModel).addSelectionInterval(i, i);
                                continue block1;
                            }
                        }
                        customValueFilterListSelectionModel.setValueIsAdjusting(false);
                    } else {
                        Object[] objectArray2 = FieldBox.this.getField().getFilteredPossibleValues();
                        if (objectArray2 == null) {
                            ((CheckBoxListSelectionModel)customValueFilterListSelectionModel).addSelectionInterval(0, 0);
                        } else {
                            customValueFilterListSelectionModel.setValueIsAdjusting(true);
                            ListModel listModel = jList.getModel();
                            if (listModel.getSize() > n2) {
                                ((CheckBoxListSelectionModel)customValueFilterListSelectionModel).addSelectionInterval(n2, listModel.getSize() - 1);
                            }
                            block3: for (Object object : objectArray2) {
                                for (int i = 0; i < listModel.getSize(); ++i) {
                                    Object e = listModel.getElementAt(i);
                                    if (!JideSwingUtilities.equals(e, object)) continue;
                                    ((CheckBoxListSelectionModel)customValueFilterListSelectionModel).removeSelectionInterval(i, i);
                                    continue block3;
                                }
                            }
                            customValueFilterListSelectionModel.setValueIsAdjusting(false);
                        }
                    }
                }
                JideSwingUtilities.insertMouseListener(jList, new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        if (bl && jList.getCellBounds(1, 1).contains(mouseEvent.getPoint())) {
                            mouseEvent.consume();
                        }
                        if (dynamicTableFilterArray != null && dynamicTableFilterArray.length > 0) {
                            int n = n;
                            int n2 = jList.getModel().getSize();
                            for (int i = 0; i < dynamicTableFilterArray.length && n < n2; ++i, ++n) {
                                if (!jList.getCellBounds(n, n).contains(mouseEvent.getPoint())) continue;
                                mouseEvent.consume();
                                break;
                            }
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (bl && jList.getCellBounds(1, 1).contains(mouseEvent.getPoint())) {
                            FieldBox.this.showCustomFilterDialog(pivotField, objectArray);
                            mouseEvent.consume();
                        }
                        if (dynamicTableFilterArray != null && dynamicTableFilterArray.length > 0) {
                            int n = jList.getModel().getSize();
                            int n2 = n;
                            for (int i = 0; i < dynamicTableFilterArray.length && n2 < n; ++i, ++n2) {
                                if (!jList.getCellBounds(n2, n2).contains(mouseEvent.getPoint())) continue;
                                DynamicTableFilter dynamicTableFilter = dynamicTableFilterArray[i];
                                if (dynamicTableFilter.initializeFilter(null, pivotField.getModelIndex(), FieldBox.this.getPossibleValues())) {
                                    pivotField.setFilter(dynamicTableFilter);
                                } else {
                                    pivotField.setFilter(null);
                                }
                                mouseEvent.consume();
                                break;
                            }
                        }
                    }
                }, 0);
                jList.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                    }

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 10) {
                            int n = jList.getSelectedIndex();
                            if (bl && n == 1) {
                                FieldBox.this.showCustomFilterDialog(pivotField, objectArray);
                                keyEvent.consume();
                            }
                            if (dynamicTableFilterArray != null && dynamicTableFilterArray.length > 0 && n >= n && n < n2) {
                                DynamicTableFilter dynamicTableFilter = dynamicTableFilterArray[n - n];
                                if (dynamicTableFilter.initializeFilter(null, pivotField.getModelIndex(), FieldBox.this.getPossibleValues())) {
                                    pivotField.setFilter(dynamicTableFilter);
                                } else {
                                    pivotField.setFilter(null);
                                }
                                keyEvent.consume();
                            }
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent keyEvent) {
                    }
                });
            }
        };
        checkBoxListChooserPanel.setMaximumRowCount(8);
        checkBoxListChooserPanel.setOkAction(new AbstractAction(JideSwingUtilities.getOKString(this._pivotTablePane.getLocale())){
            private static final long serialVersionUID = 2702038447764295109L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckBoxList checkBoxList;
                CheckBoxListSelectionModel checkBoxListSelectionModel;
                if (FieldBox.this._pivotTablePane != null) {
                    FieldBox.this._pivotTablePane.stopCellEditing();
                }
                if ((checkBoxListSelectionModel = (checkBoxList = (CheckBoxList)checkBoxListChooserPanel.getList()).getCheckBoxListSelectionModel()) != null) {
                    if (checkBoxListSelectionModel.isSelectedIndex(0)) {
                        FieldBox.this.setSelectedPossibleValues(null);
                        FieldBox.this.getField().setFilteredPossibleValues(null);
                        FieldBox.this.setFilter(null);
                    } else if (!bl || !checkBoxListSelectionModel.isSelectedIndex(1)) {
                        if (FieldBox.this.getField().isPreferSelectedPossibleValues()) {
                            FieldBox.this.setFilter(null);
                            Object[] objectArray = FieldBox.this.getPossibleValues();
                            Vector<Object> vector = new Vector<Object>();
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (!checkBoxListSelectionModel.isSelectedIndex(i + n2)) continue;
                                vector.add(objectArray[i]);
                            }
                            FieldBox.this.setSelectedPossibleValues(vector.toArray(new Object[vector.size()]));
                        } else {
                            FieldBox.this.setFilter(null);
                            Object[] objectArray = FieldBox.this.getPossibleValues();
                            Vector<Object> vector = new Vector<Object>();
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (checkBoxListSelectionModel.isSelectedIndex(i + n2)) continue;
                                vector.add(objectArray[i]);
                            }
                            if (!FieldBox.this.getField().isNullValueAllowed() && !TypeUtils.isPrimitive(FieldBox.this.getField().getType())) {
                                vector.add(null);
                            }
                            FieldBox.this.getField().setFilteredPossibleValues(vector.toArray(new Object[vector.size()]));
                        }
                    }
                }
                FieldBox.this.hidePopup();
            }
        });
        checkBoxListChooserPanel.setCancelAction(new AbstractAction(JideSwingUtilities.getCancelString(this._pivotTablePane.getLocale())){
            private static final long serialVersionUID = 9088271180396048607L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FieldBox.this.hidePopup();
            }
        });
        checkBoxListChooserPanel.setResizable(true);
        return checkBoxListChooserPanel;
    }

    private void showCustomFilterDialog(PivotField pivotField, Object[] objectArray) {
        Filter filter;
        this.hidePopup();
        CustomFilterEditor customFilterEditor = this.createCustomFilterEditor(FilterFactoryManager.getDefaultInstance(), pivotField.getType(), pivotField.getConverterContext(), objectArray);
        customFilterEditor.setLocale(this.getLocale());
        Filter filter2 = this.getFilter();
        customFilterEditor.setFilter(filter2);
        customFilterEditor.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Container container = this.getTopLevelAncestor();
        String string = MessageFormat.format(GridResource.getResourceBundle(this.getLocale()).getString("Filter.customFilterTitle"), pivotField.getTitle());
        CustomFilterEditorDialog customFilterEditorDialog = this._pivotTablePane.createCustomFilterEditorDialog(container, string, customFilterEditor);
        customFilterEditorDialog.setLocationRelativeTo(this);
        customFilterEditorDialog.pack();
        customFilterEditorDialog.setVisible(true);
        if (customFilterEditorDialog.getDialogResult() == 0 && (filter = customFilterEditor.getFilter()) != null && !filter.equals(filter2)) {
            this.setFilter(filter);
        }
    }

    protected CustomFilterEditor createCustomFilterEditor(FilterFactoryManager filterFactoryManager, Class<?> clazz, ConverterContext converterContext, Object[] objectArray) {
        return new CustomFilterEditor(filterFactoryManager, clazz, converterContext, objectArray);
    }

    protected void customizePopupWindow(JidePopup jidePopup, PopupPanel popupPanel) {
        jidePopup.setLayout(new BorderLayout(2, 2));
        jidePopup.add(popupPanel);
    }

    protected Point calculatePopupLocation(PopupPanel popupPanel) {
        Cloneable cloneable;
        Border border = this._popup.getPopupBorder();
        int n = 0;
        int n2 = 0;
        if (border != null) {
            cloneable = border.getBorderInsets(popupPanel);
            n = cloneable.left + cloneable.right;
            n2 = cloneable.top + cloneable.bottom;
        }
        try {
            cloneable = this.getLocationOnScreen();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cloneable = this.getLocation();
        }
        ((Point)cloneable).y += this.getHeight();
        Dimension dimension = popupPanel.getPreferredSize();
        ((Point)cloneable).x -= dimension.width - this.getWidth() + n;
        int n3 = ((Point)cloneable).y + dimension.height;
        Rectangle rectangle = PortingUtils.getContainingScreenBounds(new Rectangle((Point)cloneable, dimension), true);
        if (n3 > rectangle.y + rectangle.height) {
            ((Point)cloneable).y = ((Point)cloneable).y - dimension.height - this.getHeight() - n2;
        }
        Rectangle rectangle2 = PortingUtils.containsInScreenBounds(this, new Rectangle((Point)cloneable, dimension));
        ((Point)cloneable).x = rectangle2.x;
        ((Point)cloneable).y = rectangle2.y;
        return cloneable;
    }

    public void hidePopup() {
        if (this.isPopupVisible()) {
            this._popup.hidePopup();
        }
    }

    public boolean isPopupVisible() {
        return this._popup != null && this._popup.isPopupVisible();
    }

    public PivotField getField() {
        return this._field;
    }

    public PivotTablePane getPivotTablePane() {
        return this._pivotTablePane;
    }

    public void setPivotTablePane(PivotTablePane pivotTablePane) {
        this._pivotTablePane = pivotTablePane;
        if (this._pivotTablePane != null) {
            this.updateFilterIcon();
        }
    }

    boolean isLast() {
        return this._isLast;
    }

    void setLast(boolean bl) {
        this._isLast = bl;
    }

    boolean isFirst() {
        return this._isFirst;
    }

    void setFirst(boolean bl) {
        this._isFirst = bl;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this._pivotTablePane != null && !this._pivotTablePane.isKeepFieldAreaFit() && this.getField().getAreaType() == 0 && this.getField().getPreferredWidth() != 0) {
            dimension.width = this.getField().getPreferredWidth();
        }
        return dimension;
    }

    public Dimension getActualPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._filterButton != null) {
            this.remove(this._filterButton);
            this.addFilterButton();
        }
    }

    public class ArrowIcon
    implements Icon,
    Serializable {
        private int _direction = 1;
        private static final long serialVersionUID = 6213406821880564676L;

        public ArrowIcon(int n) {
            this._direction = n;
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(new Color(172, 168, 153));
            switch (this._direction) {
                case 1: {
                    for (int i = 0; i < 7; ++i) {
                        graphics.drawLine(n + i, n2 + Math.abs(3 - i), n + i, n2 + Math.abs(3 - i) + 1);
                    }
                    graphics.drawLine(n + 3, n2, n + 3, n2 + this.getIconHeight());
                    break;
                }
                case 5: {
                    for (int i = 0; i < 7; ++i) {
                        graphics.drawLine(n + i, n2 + 8 - Math.abs(3 - i), n + i, n2 + 8 - Math.abs(3 - i) + 1);
                    }
                    graphics.drawLine(n + 3, n2, n + 3, n2 + this.getIconHeight());
                }
            }
        }
    }
}

