/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.GridResource;
import com.jidesoft.pivot.DataTableModel;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.Values;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumn;

public class DataTable
extends CategorizedTable {
    private PivotTablePane _pivotTablePane;
    private boolean _init;
    private boolean _showContextMenu = true;

    public DataTable(PivotTablePane pivotTablePane) {
        this.initializeTable();
        this._pivotTablePane = pivotTablePane;
    }

    private void initializeTable() {
        if (!this._init) {
            this.setNonContiguousCellSelection(true);
            this.setCellSelectionEnabled(true);
            this.setClearSelectionOnTableDataChanges(true);
            this.setAutoResizeMode(0);
            this.addMouseListener(this.createPopupMenuMouseListener());
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this._init = true;
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        if (this._pivotTablePane != null) {
            this._pivotTablePane.configureEnclosingScrollPaneForDataTable(this);
        }
    }

    public PivotTablePane getPivotTablePane() {
        return this._pivotTablePane;
    }

    public void setPivotTablePane(PivotTablePane pivotTablePane) {
        this._pivotTablePane = pivotTablePane;
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        super.addColumn(tableColumn);
        if (this._pivotTablePane.isColumnHidden(this.convertColumnIndexToView(tableColumn.getModelIndex()))) {
            tableColumn.setPreferredWidth(0);
            tableColumn.setMinWidth(0);
            tableColumn.setWidth(0);
            this._pivotTablePane.installPropertyChangeListenerForColumn(tableColumn);
        }
    }

    protected MouseListener createPopupMenuMouseListener() {
        return new PopupMenuMouseListener();
    }

    private void showContextMenu(MouseEvent mouseEvent) {
        int n;
        Point point;
        int n2;
        JPopupMenu jPopupMenu;
        if (mouseEvent.isPopupTrigger() && !mouseEvent.isConsumed() && this.isShowContextMenu() && (jPopupMenu = this.createContextMenu(n2 = this.rowAtPoint(point = mouseEvent.getPoint()), n = this.columnAtPoint(point))).getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jPopupMenu, this, point.x, point.y);
        }
    }

    protected JPopupMenu createContextMenu(final int n, final int n2) {
        Object object;
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this._pivotTablePane.getLocale()).getString("Sort.ascending")){
            private static final long serialVersionUID = 3888745479160147641L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTable.this.sortBy(n, n2, true);
            }
        });
        jMenuItem.setName("Sort.ascending");
        jidePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this._pivotTablePane.getLocale()).getString("Sort.descending")){
            private static final long serialVersionUID = 7303901333068948260L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTable.this.sortBy(n, n2, false);
            }
        });
        jMenuItem.setName("Sort.descending");
        jidePopupMenu.add(jMenuItem);
        if (this.getPivotTablePane().isAllowSortByRow()) {
            jMenuItem = new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this._pivotTablePane.getLocale()).getString("Sort.ascendingByRow")){
                private static final long serialVersionUID = 3888745479160147641L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataTable.this.sortByRowKeys(n, n2, true);
                }
            });
            jMenuItem.setName("Sort.ascendingByRow");
            jidePopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this._pivotTablePane.getLocale()).getString("Sort.descendingByRow")){
                private static final long serialVersionUID = 7303901333068948260L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataTable.this.sortByRowKeys(n, n2, false);
                }
            });
            jMenuItem.setName("Sort.descendingByRow");
            jidePopupMenu.add(jMenuItem);
        }
        if (!this._pivotTablePane.getPivotDataModel().isRowDataFields()) {
            object = new ArrayList();
            for (int i = this.getColumnCount() - 1; i >= 0; --i) {
                if (!this.isColumnSelected(i) || this._pivotTablePane.isColumnHidden(i)) continue;
                object.add(i);
            }
            if (object.size() == 0) {
                jMenuItem = new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this._pivotTablePane.getLocale()).getString("TableColumnChooser.hide")){
                    private static final long serialVersionUID = -2707937470939029264L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DataTable.this._pivotTablePane.hideColumns(new int[]{n2});
                    }
                });
                jMenuItem.setName("TableColumnChooser.hide");
                jidePopupMenu.add(jMenuItem);
            } else {
                jMenuItem = new JMenuItem(new AbstractAction(this._pivotTablePane.getResourceString("DataTable.hideSelect"), (List)object){
                    private static final long serialVersionUID = 492357933888482127L;
                    final /* synthetic */ List val$hiddenColumns;
                    {
                        this.val$hiddenColumns = list;
                        super(string);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray = new int[this.val$hiddenColumns.size()];
                        for (int i = 0; i < this.val$hiddenColumns.size(); ++i) {
                            nArray[i] = (Integer)this.val$hiddenColumns.get(i);
                        }
                        DataTable.this._pivotTablePane.hideColumns(nArray);
                    }
                });
                jMenuItem.setName("DataTable.hideSelect");
                jidePopupMenu.add(jMenuItem);
            }
            if (this._pivotTablePane.getPivotDataModel().hasHiddenColumns() || this._pivotTablePane.getPivotDataModel().hasHiddenRows()) {
                jMenuItem = new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this._pivotTablePane.getLocale()).getString("TableColumnChooser.showAll")){
                    private static final long serialVersionUID = -2342027090602765133L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DataTable.this._pivotTablePane.showAllColumns();
                        DataTable.this._pivotTablePane.showAllRows();
                    }
                });
                jMenuItem.setName("TableColumnChooser.showAll");
                jidePopupMenu.add(jMenuItem);
            }
        }
        if ((object = this._pivotTablePane.getDataTablePopupMenuCustomizer()) != null) {
            if (object instanceof PivotTablePane.TablePopupMenuCustomizer) {
                ((PivotTablePane.TablePopupMenuCustomizer)object).customize(jidePopupMenu, this, n, n2);
            } else {
                object.customize(jidePopupMenu, this);
            }
        }
        return jidePopupMenu;
    }

    public void sortBy(int n, int n2, boolean bl) {
        IPivotDataModel iPivotDataModel = this._pivotTablePane.getPivotDataModel();
        HeaderTableModel headerTableModel = iPivotDataModel.getRowHeaderTableModel();
        int n3 = headerTableModel.getKeyValuesAt(n).length;
        if (n3 == 0) {
            return;
        }
        PivotField pivotField = headerTableModel.getFieldAt(n, n3 - 1);
        if (pivotField == null) {
            return;
        }
        Values values = iPivotDataModel.getColumnHeaderTableModel().getValuesAt(n2);
        Values values2 = iPivotDataModel.getRowHeaderTableModel().getValuesAt(n);
        PivotField pivotField2 = ((DataTableModel)iPivotDataModel.getDataTableModel()).getDataFieldAt(n, n2);
        pivotField.setSortByDataFieldModelIndex(pivotField2 == null ? -1 : pivotField2.getModelIndex());
        pivotField.setSortByAscending(bl);
        if (values instanceof SummaryValues) {
            pivotField.setSortBySummaryType(((SummaryValues)values).getSummaryType());
        } else if (values2 instanceof SummaryValues) {
            pivotField.setSortBySummaryType(((SummaryValues)values2).getSummaryType());
        } else {
            pivotField.setSortBySummaryType(pivotField2 == null ? -2 : pivotField2.getSummaryType());
        }
        pivotField.setSortByColumnKeys(values);
    }

    public void sortByRowKeys(int n, int n2, boolean bl) {
        IPivotDataModel iPivotDataModel = this._pivotTablePane.getPivotDataModel();
        HeaderTableModel headerTableModel = iPivotDataModel.getColumnHeaderTableModel();
        int n3 = headerTableModel.getKeyValuesAt(n2).length;
        if (n3 == 0) {
            return;
        }
        PivotField pivotField = headerTableModel.getFieldAt(n3 - 1, n2);
        if (pivotField == null) {
            return;
        }
        Values values = iPivotDataModel.getRowHeaderTableModel().getValuesAt(n);
        Values values2 = iPivotDataModel.getRowHeaderTableModel().getValuesAt(n);
        PivotField pivotField2 = ((DataTableModel)iPivotDataModel.getDataTableModel()).getDataFieldAt(n, n2);
        pivotField.setSortByDataFieldModelIndex(pivotField2 == null ? -1 : pivotField2.getModelIndex());
        pivotField.setSortByAscending(bl);
        if (values instanceof SummaryValues) {
            pivotField.setSortBySummaryType(((SummaryValues)values).getSummaryType());
        } else if (values2 instanceof SummaryValues) {
            pivotField.setSortBySummaryType(((SummaryValues)values2).getSummaryType());
        } else {
            pivotField.setSortBySummaryType(pivotField2 == null ? -2 : pivotField2.getSummaryType());
        }
        pivotField.setSortByRowKeys(values);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(dimension.width, this._pivotTablePane.getColumnHeaderTable().getPreferredSize().width);
        dimension.height = Math.max(dimension.height, this._pivotTablePane.getRowHeaderTable().getPreferredSize().height);
        return dimension;
    }

    public boolean isShowContextMenu() {
        return this._showContextMenu;
    }

    public void setShowContextMenu(boolean bl) {
        this._showContextMenu = bl;
    }

    protected class PopupMenuMouseListener
    extends MouseAdapter {
        protected PopupMenuMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DataTable.this.showContextMenu(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            DataTable.this.showContextMenu(mouseEvent);
        }
    }
}

