/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableProvider;
import com.jidesoft.grid.Field;
import com.jidesoft.grid.GroupHeaderTableProvider;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.JoinTableModel;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grid.ToolTipSupport;
import com.jidesoft.grid.ValueConverter;
import com.jidesoft.grid.ValueStringAdjustProvider;
import com.jidesoft.pivot.AggregateTableHeader;
import com.jidesoft.pivot.AggregateTableModel;
import com.jidesoft.pivot.AggregateTablePane;
import com.jidesoft.pivot.AggregateTableUtils;
import com.jidesoft.pivot.GrandTotalValue;
import com.jidesoft.pivot.HeaderTableCellRenderer;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotDataSource;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotResources;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.SortableAggregateTableModel;
import com.jidesoft.pivot.SummaryValue;
import com.jidesoft.pivot.TableModelPivotDataSource;
import com.jidesoft.pivot.Value;
import com.jidesoft.swing.DelegateMouseInputListener;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AggregateTable
extends SortableTable
implements ExpandableProvider,
ValueStringAdjustProvider,
GroupHeaderTableProvider {
    private TableCellRenderer _renderer;
    private boolean _init;
    public static final String PROPERTY_DOUBLE_CLICK_ENABLED = "doubleClickEnabled";
    private DraggingHandler _draggingColumnPropertyChangeListener;
    private boolean _rememberColumnOrderBeforeGroup;
    private boolean _rememberColumnOrderBeforeUngroup;
    private boolean _aggregating;
    private PropertyChangeListener _fieldPropertyListener;
    private int[][] _fieldsAreaType;
    private boolean _autoAdjustGrouping = false;
    private boolean _autoGrouping = false;
    private boolean _synchronizing = false;
    private String _version;
    private PopupMenuCustomizer _cellPopupMenuCustomizer;
    private boolean _showContextMenu = true;
    private boolean _useNativeRenderer = true;

    public AggregateTable() {
        this.initializeTable();
    }

    public AggregateTable(TableModel tableModel) {
        super(TableModelWrapperUtils.getActualTableModel(tableModel, AggregateTableModel.class) != null ? tableModel : new AggregateTableModel(tableModel));
        this.initializeTable();
        AggregateTableModel aggregateTableModel = this.getAggregateTableModel();
        if (aggregateTableModel != null && aggregateTableModel.isAggregated()) {
            this.configureSortableTableModel(aggregateTableModel);
        }
    }

    @Override
    protected ISortableTableModel createSortableTableModel(TableModel tableModel) {
        return new SortableAggregateTableModel(tableModel);
    }

    @Override
    public void setModel(TableModel tableModel) {
        PivotField[] pivotFieldArray;
        AggregateTableModel aggregateTableModel = this.getAggregateTableModel();
        if (aggregateTableModel != null && TableModelWrapperUtils.getActualTableModel(tableModel, AggregateTableModel.class) != aggregateTableModel) {
            aggregateTableModel.removePropertyChangeListener("aggregateColumnsChanging", this._fieldPropertyListener);
            if (aggregateTableModel.getPivotDataModel() instanceof PivotDataModel) {
                ((PivotDataModel)aggregateTableModel.getPivotDataModel()).setOriginalTableModel(null);
            }
        }
        super.setModel(TableModelWrapperUtils.getActualTableModel(tableModel, AggregateTableModel.class) != null ? tableModel : new AggregateTableModel(tableModel));
        aggregateTableModel = this.getAggregateTableModel();
        if (aggregateTableModel != null && aggregateTableModel.isAggregated()) {
            this.configureSortableTableModel(aggregateTableModel);
        }
        if (aggregateTableModel == null) {
            return;
        }
        for (PivotField pivotField : pivotFieldArray = aggregateTableModel.getPivotDataModel().getFields()) {
            if (this._fieldPropertyListener != null) {
                pivotField.removePropertyChangeListener(this._fieldPropertyListener);
            } else {
                this.initFieldPropertyListener();
            }
            pivotField.addPropertyChangeListener("areaType", this._fieldPropertyListener);
        }
        aggregateTableModel.addPropertyChangeListener("aggregateColumnsChanging", this._fieldPropertyListener);
        this._fieldsAreaType = new int[2][pivotFieldArray.length];
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        AggregateTableModel aggregateTableModel = this.getAggregateTableModel();
        if (tableModelEvent.getFirstRow() == -1 && aggregateTableModel != null) {
            PivotField[] pivotFieldArray;
            this._fieldsAreaType = new int[2][aggregateTableModel.getPivotDataModel().getFields().length];
            for (PivotField pivotField : pivotFieldArray = aggregateTableModel.getPivotDataModel().getFields()) {
                pivotField.removePropertyChangeListener("areaType", this._fieldPropertyListener);
                pivotField.addPropertyChangeListener("areaType", this._fieldPropertyListener);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initializeTable() {
        if (!this._init) {
            Object object;
            this.setNonContiguousCellSelection(true);
            this.setCellSelectionEnabled(true);
            this.setColumnResizable(true);
            this.setAutoResizeMode(0);
            this.setClearPropertyAtStructureChange(false);
            boolean bl = false;
            if (SystemInfo.isJdk6Above() && !SystemInfo.isJdk7Above()) {
                void var3_5;
                object = this.getMouseListeners();
                Object object2 = null;
                Object object3 = object;
                int n = ((MouseListener[])object3).length;
                for (int i = 0; i < n; ++i) {
                    MouseListener mouseListener = object3[i];
                    if (mouseListener.getClass().getName().indexOf("TableUI") == -1) continue;
                    MouseListener mouseListener2 = mouseListener;
                    this.removeMouseListener(mouseListener);
                    if (!(mouseListener instanceof MouseMotionListener)) break;
                    this.removeMouseMotionListener((MouseMotionListener)((Object)mouseListener));
                    break;
                }
                if (var3_5 != null && var3_5 instanceof MouseInputListener) {
                    object3 = this.createExpandMouseInputListener((MouseInputListener)var3_5);
                    JideSwingUtilities.insertMouseListener(this, (MouseListener)object3, 0);
                    JideSwingUtilities.insertMouseMotionListener(this, (MouseMotionListener)object3, 0);
                    bl = true;
                }
            }
            if (!bl) {
                object = this.createExpandMouseListener();
                JideSwingUtilities.insertMouseListener(this, (MouseListener)object, 0);
                if (object instanceof MouseInputListener) {
                    JideSwingUtilities.insertMouseMotionListener(this, (MouseInputListener)object, 0);
                }
            }
            if (this._draggingColumnPropertyChangeListener == null) {
                this._draggingColumnPropertyChangeListener = this.createDraggingColumnPropertyChangeListener();
            }
            this.getTableHeader().addPropertyChangeListener("draggedColumn", this._draggingColumnPropertyChangeListener);
            this.getColumnModel().addColumnModelListener(this._draggingColumnPropertyChangeListener);
            this.addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getOldValue() instanceof JTableHeader) {
                        ((JTableHeader)propertyChangeEvent.getOldValue()).removePropertyChangeListener("draggedColumn", AggregateTable.this._draggingColumnPropertyChangeListener);
                    }
                    if (propertyChangeEvent.getNewValue() instanceof JTableHeader) {
                        ((JTableHeader)propertyChangeEvent.getNewValue()).addPropertyChangeListener("draggedColumn", AggregateTable.this._draggingColumnPropertyChangeListener);
                    }
                }
            });
            this.addPropertyChangeListener("columnModel", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getOldValue() instanceof TableColumnModel) {
                        ((TableColumnModel)propertyChangeEvent.getOldValue()).removeColumnModelListener(AggregateTable.this._draggingColumnPropertyChangeListener);
                    }
                    if (propertyChangeEvent.getNewValue() instanceof TableColumnModel) {
                        ((TableColumnModel)propertyChangeEvent.getOldValue()).addColumnModelListener(AggregateTable.this._draggingColumnPropertyChangeListener);
                    }
                }
            });
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.putClientProperty("AutoResize.highPerformance", Boolean.FALSE);
            this._renderer = this.createCellRenderer();
            this._init = true;
            this.initSnapshotFlags();
            this.initFieldPropertyListener();
            for (MouseListener mouseListener : object = this.getAggregateTableModel().getPivotDataModel().getFields()) {
                ((Field)((Object)mouseListener)).addPropertyChangeListener("areaType", this._fieldPropertyListener);
            }
            this.getAggregateTableModel().addPropertyChangeListener("aggregateColumnsChanging", this._fieldPropertyListener);
            this._fieldsAreaType = new int[2][((MouseListener[])object).length];
        }
    }

    @Override
    protected void tableStructureChanged(TableModelEvent tableModelEvent) {
        try {
            this.getColumnModel().removeColumnModelListener(this._draggingColumnPropertyChangeListener);
            super.tableStructureChanged(tableModelEvent);
        }
        finally {
            this.getColumnModel().removeColumnModelListener(this._draggingColumnPropertyChangeListener);
            this.getColumnModel().addColumnModelListener(this._draggingColumnPropertyChangeListener);
        }
    }

    private void initFieldPropertyListener() {
        this._fieldPropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("areaType")) {
                    if (!(propertyChangeEvent.getSource() instanceof PivotField) || AggregateTable.this.isAggregating() || AggregateTable.this.isSynchronizing()) {
                        return;
                    }
                    PivotField pivotField = (PivotField)propertyChangeEvent.getSource();
                    PivotField[] pivotFieldArray = AggregateTable.this.getAggregateTableModel().getPivotDataModel().getFields();
                    for (int i = 0; i < pivotFieldArray.length; ++i) {
                        if (pivotFieldArray[i] != pivotField) continue;
                        ((AggregateTable)AggregateTable.this)._fieldsAreaType[1][i] = (Integer)propertyChangeEvent.getNewValue();
                        break;
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("aggregateColumnsChanging")) {
                    AggregateTable.this.setSynchronizing((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        };
    }

    public AggregateTableModel getAggregateTableModel() {
        return (AggregateTableModel)TableModelWrapperUtils.getActualTableModel(this.getModel(), AggregateTableModel.class);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this._renderer = this.createCellRenderer();
    }

    @Override
    public String getTableHeaderToolTipText(int n) {
        String string = super.getTableHeaderToolTipText(n);
        if (string != null) {
            return string;
        }
        AggregateTableModel aggregateTableModel = this.getAggregateTableModel();
        if (aggregateTableModel != null) {
            int n2 = TableModelWrapperUtils.getActualColumnAt(this.getModel(), n, aggregateTableModel);
            return aggregateTableModel.getTableHeaderToolTipText(n2);
        }
        return null;
    }

    protected TableCellRenderer createCellRenderer() {
        return new HeaderTableCellRenderer();
    }

    protected MouseListener createExpandMouseListener() {
        return new ExpandMouseListener();
    }

    private boolean isSynchronizing() {
        return this._synchronizing;
    }

    void setSynchronizing(boolean bl) {
        this._synchronizing = bl;
    }

    public boolean isShowContextMenu() {
        return this._showContextMenu;
    }

    public void setShowContextMenu(boolean bl) {
        this._showContextMenu = bl;
    }

    public boolean isUseNativeRenderer() {
        return this._useNativeRenderer;
    }

    public void setUseNativeRenderer(boolean bl) {
        this._useNativeRenderer = bl;
    }

    protected MouseInputListener createExpandMouseInputListener(MouseInputListener mouseInputListener) {
        return new DelegateExpandMouseInputListener(mouseInputListener);
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        int n;
        HeaderTableModel headerTableModel;
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!this.isExpandIconVisible()) {
            return;
        }
        if (!this.getAggregateTableModel().hasAggregateColumns()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        int n2 = this.rowAtPoint(point);
        int n3 = this.columnAtPoint(point);
        int n4 = this.convertColumnIndexToModel(n3);
        if (this.getHeaderTableModel() == null || n4 < 0 || n4 >= this.getHeaderTableModel().getColumnCount()) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n2, n3, false);
        int n5 = (16 - this.getCollapsedIcon().getIconWidth()) / 2 + 2;
        int n6 = n5 + this.getCollapsedIcon().getIconWidth();
        if (!this.getComponentOrientation().isLeftToRight()) {
            n6 = rectangle.width - n5;
            n5 = n6 - this.getCollapsedIcon().getIconWidth();
        }
        if (point.x > rectangle.x + n5 && point.x < rectangle.x + n6 && point.y > rectangle.y && point.y < rectangle.y + this.getRowHeight() && (headerTableModel = this.getHeaderTableModel()) != null && (n = TableModelWrapperUtils.getActualRowAt(this.getModel(), n2, AggregateTableModel.class)) != -1) {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            headerTableModel.toggle(n, n4);
            mouseEvent.consume();
        }
    }

    private void showContextMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && !mouseEvent.isConsumed() && this.isShowContextMenu()) {
            Object object;
            Point point = mouseEvent.getPoint();
            final int n = this.rowAtPoint(point);
            final int n2 = this.columnAtPoint(point);
            JidePopupMenu jidePopupMenu = new JidePopupMenu();
            HeaderTableModel headerTableModel = this.getHeaderTableModel();
            boolean bl = headerTableModel.isExpandable(n, n2);
            final boolean bl2 = bl && headerTableModel.isExpanded(n, n2);
            ResourceBundle resourceBundle = PivotResources.getResourceBundle(this.getLocale());
            if (bl) {
                object = ObjectConverterManager.toString(headerTableModel.getValueAt(n, n2), headerTableModel.getCellClassAt(n, n2), headerTableModel.getConverterContextAt(n, n2));
                jidePopupMenu.add(new JMenuItem(new AbstractAction(MessageFormat.format(bl2 ? resourceBundle.getString("AggregateTable.collapse") : resourceBundle.getString("AggregateTable.expand"), object)){
                    private static final long serialVersionUID = -2859613169742174871L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (bl2) {
                            AggregateTable.this.collapse(n, n2);
                        } else {
                            AggregateTable.this.expand(n, n2);
                        }
                    }
                }));
                jidePopupMenu.addSeparator();
            }
            jidePopupMenu.add(new JMenuItem(new AbstractAction(resourceBundle.getString("HeaderTable.expandAll")){
                private static final long serialVersionUID = 2693924602911725000L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AggregateTable.this.expandAll();
                }
            }));
            jidePopupMenu.add(new JMenuItem(new AbstractAction(resourceBundle.getString("HeaderTable.collapseAll")){
                private static final long serialVersionUID = 1548129346804104204L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AggregateTable.this.collapseAll();
                }
            }));
            object = this.getCellPopupMenuCustomizer();
            if (object != null) {
                if (object instanceof TablePopupMenuCustomizer) {
                    ((TablePopupMenuCustomizer)object).customize(jidePopupMenu, this, n, n2);
                } else {
                    object.customize(jidePopupMenu, this);
                }
            }
            if (jidePopupMenu.getComponentCount() > 0) {
                JideSwingUtilities.showPopupMenu(jidePopupMenu, this, point.x, point.y);
            }
        }
    }

    public PopupMenuCustomizer getCellPopupMenuCustomizer() {
        return this._cellPopupMenuCustomizer;
    }

    public void setCellPopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this._cellPopupMenuCustomizer = popupMenuCustomizer;
    }

    public void expand(int n, int n2) {
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        if (headerTableModel != null) {
            headerTableModel.expand(n, n2);
        }
    }

    public void collapse(int n, int n2) {
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        if (headerTableModel != null) {
            headerTableModel.collapse(n, n2);
        }
    }

    public void expandAll() {
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        if (headerTableModel != null) {
            headerTableModel.expandAll();
        }
    }

    public void collapseAll() {
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        if (headerTableModel != null) {
            headerTableModel.collapseAll();
        }
    }

    protected DraggingHandler createDraggingColumnPropertyChangeListener() {
        return new DraggingHandler();
    }

    DraggingHandler getDraggingHandler() {
        return this._draggingColumnPropertyChangeListener;
    }

    protected void updateAggregateColumns(TableColumn tableColumn, int n) {
        int n2;
        int n3;
        TableColumnModel tableColumnModel = this.getColumnModel();
        AggregateTableModel aggregateTableModel = this.getAggregateTableModel();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        boolean bl2 = false;
        int n4 = -1;
        int n5 = -1;
        for (n3 = tableColumnModel.getColumnCount() - 1; n3 >= 0; --n3) {
            TableColumn tableColumn2 = tableColumnModel.getColumn(n3);
            n2 = aggregateTableModel.getActualModelColumnIndex(tableColumn2.getModelIndex());
            if (bl) {
                arrayList.add(0, n2);
            }
            if (tableColumn2 == tableColumn) {
                n4 = n3;
                bl2 = aggregateTableModel.isColumnAggregated(n2);
                continue;
            }
            if (bl || !aggregateTableModel.isColumnAggregated(n2)) continue;
            n5 = n3;
            bl = true;
            arrayList.add(0, n2);
        }
        n3 = 0;
        int n6 = aggregateTableModel.getActualModelColumnIndex(tableColumn.getModelIndex());
        if (!bl2) {
            if (n >= n5 && n4 <= n5 + (this.isAutoAdjustGrouping() ? 1 : 0) && (n5 != -1 || this.isAutoGrouping())) {
                n3 = 1;
            }
            if (n3 != 0) {
                if (n4 >= 0 && n4 < this.getColumnCount() && n >= 0 && n < this.getColumnCount()) {
                    this.moveColumn(n4, n);
                }
                TableUtils.saveColumnOrders(this, false);
                this.getAggregateTableModel().addAggregatedColumn(n4, n6);
            }
        }
        if (bl2) {
            if (n4 > n5 + (this.isAutoAdjustGrouping() ? 0 : 1)) {
                this.getAggregateTableModel().removeAggregatedColumn(n6);
                n3 = 1;
            } else if (n <= n5) {
                n2 = aggregateTableModel.getActualModelColumnIndex(tableColumn.getModelIndex());
                boolean bl3 = false;
                if (!this.isAutoAdjustGrouping() && !arrayList.contains(n2)) {
                    bl3 = true;
                }
                int[] nArray = new int[arrayList.size() + (bl3 ? 1 : 0)];
                for (int i = 0; i < arrayList.size(); ++i) {
                    nArray[i] = (Integer)arrayList.get(i);
                }
                if (bl3) {
                    nArray[arrayList.size()] = aggregateTableModel.getActualModelColumnIndex(tableColumn.getModelIndex());
                }
                this.getAggregateTableModel().setAggregatedColumns(nArray);
                n3 = 1;
            }
        }
        if (n3 != 0) {
            this.setRememberColumnOrderBeforeGroup(false);
            this.setRememberColumnOrderBeforeUngroup(true);
            this.aggregate();
        } else {
            this.syncColumnModelToAreaIndex();
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this.getAggregateTableModel().hasAggregateColumns()) {
            int n3 = this.convertColumnIndexToModel(n2);
            if (this.getHeaderTableModel() != null && this._renderer instanceof HeaderTableCellRenderer && n3 >= 0 && n3 < this.getHeaderTableModel().getColumnCount()) {
                TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
                ((HeaderTableCellRenderer)this._renderer).setActualCellRenderer(tableCellRenderer);
                return this._renderer;
            }
        }
        return super.getCellRenderer(n, n2);
    }

    @Override
    public Expandable getExpandableAt(int n, int n2) {
        if (this.getAggregateTableModel().hasAggregateColumns()) {
            int n3 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, AggregateTableModel.class);
            return this.getHeaderTableModel().getExpandable(n3, n2);
        }
        return null;
    }

    public HeaderTableModel getHeaderTableModel() {
        TableModel tableModel = this.getModel();
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, JoinTableModel.class);
        if (tableModel2 instanceof JoinTableModel) {
            return (HeaderTableModel)((JoinTableModel)tableModel2).getTableModel(0);
        }
        return null;
    }

    public void setAggregatedColumns(String[] stringArray) {
        AggregateTableModel aggregateTableModel = this.getAggregateTableModel();
        if (aggregateTableModel != null) {
            aggregateTableModel.setAggregatedColumns(stringArray);
        }
    }

    public void setAggregatedColumns(int[] nArray) {
        AggregateTableModel aggregateTableModel = this.getAggregateTableModel();
        if (aggregateTableModel != null) {
            aggregateTableModel.setAggregatedColumns(nArray);
        }
    }

    public void aggregate(String[] stringArray) {
        AggregateTableModel aggregateTableModel = this.getAggregateTableModel();
        if (aggregateTableModel != null && stringArray != null) {
            aggregateTableModel.setAggregatedColumns(stringArray);
        }
        this.aggregate((int[])null);
    }

    public void aggregate(int[] nArray) {
        AggregateTableModel aggregateTableModel = this.getAggregateTableModel();
        if (aggregateTableModel == null) {
            System.err.println("AggregateTableModel in AggregateTable should not be null.");
            return;
        }
        if (nArray != null) {
            aggregateTableModel.setAggregatedColumns(nArray);
        }
        int[] nArray2 = aggregateTableModel.getAggregatedColumns();
        int[] nArray3 = aggregateTableModel.getAggregatedColumnsInPivotFields();
        if (nArray2 == null) {
            nArray2 = new int[]{};
        }
        if (nArray3 == null) {
            nArray3 = new int[]{};
        }
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = true;
        if (nArray2.length > nArray3.length) {
            bl = false;
        } else if (nArray2.length < nArray3.length) {
            bl2 = false;
        }
        while (n < nArray2.length && n2 < nArray3.length && (bl || bl2)) {
            int n3;
            if (nArray3[n2] == nArray2[n]) {
                ++n;
                ++n2;
                continue;
            }
            if (bl) {
                n3 = n2;
                while (++n3 < nArray3.length && nArray3[n3] != nArray2[n]) {
                }
                if (n3 >= nArray3.length) {
                    bl = false;
                } else {
                    bl2 = false;
                    n2 = n3 + 1;
                    ++n;
                }
            }
            if (!bl2) continue;
            n3 = n;
            while (++n3 < nArray2.length && nArray2[n3] != nArray3[n2]) {
            }
            if (n3 >= nArray2.length) {
                bl2 = false;
                continue;
            }
            bl = false;
            n = n3 + 1;
            ++n2;
        }
        if (bl && bl2) {
            bl = false;
            bl2 = false;
        }
        this.setAggregating(true);
        AggregateTablePane aggregateTablePane = null;
        Object object = this.getClientProperty("TableScrollPane.Parent");
        if (object != null && object instanceof AggregateTablePane) {
            aggregateTablePane = (AggregateTablePane)object;
        }
        if (bl && this.isRememberColumnOrderBeforeGroup() || bl2 && this.isRememberColumnOrderBeforeUngroup()) {
            if (aggregateTablePane == null) {
                TableUtils.saveColumnOrders(this, bl2);
            } else {
                TableUtils.saveColumnOrders(aggregateTablePane);
            }
        }
        this.handleFieldAreaTypeChangeBeforeAggregating();
        this.configureSortableTableModel(aggregateTableModel);
        String string = TableUtils.getTablePreferenceByName(this);
        String string2 = TableUtils.getSortableTablePreference(this, true);
        this.unsort();
        if (aggregateTablePane != null) {
            string = TableUtils.getTablePreferenceByName(aggregateTablePane);
        }
        aggregateTableModel.aggregate();
        this.resetModelIndex();
        if (aggregateTablePane == null) {
            TableUtils.setTablePreferenceByName(this, string);
        } else {
            TableUtils.setTablePreferenceByName(aggregateTablePane, string);
        }
        this.handleFieldAreaTypeChangeAfterAggregating();
        this.syncColumnModelToAreaIndex();
        if (bl2 && !this.isRememberColumnOrderBeforeUngroup()) {
            TableUtils.clearColumnOrdersMemory(this);
        }
        this.initSnapshotFlags();
        this.setInitialFieldsAreaType();
        TableUtils.setSortableTablePreference(this, string2, true);
        if (aggregateTablePane != null) {
            aggregateTablePane.resizeRowHeaderTableToFit();
        }
    }

    void handleFieldAreaTypeChangeAfterShowing(int n) {
        PivotField[] pivotFieldArray = this.getAggregateTableModel().getPivotDataModel().getFields();
        if (n == -1) {
            for (int i = 0; i < pivotFieldArray.length; ++i) {
                if (this._fieldsAreaType[1][i] != -1) continue;
                this._fieldsAreaType[1][i] = 3;
            }
        } else if (n >= 0 && n < pivotFieldArray.length && this._fieldsAreaType[1][n] == -1) {
            this._fieldsAreaType[1][n] = 3;
        }
    }

    private void handleFieldAreaTypeChangeBeforeAggregating() {
        PivotField[] pivotFieldArray = this.getAggregateTableModel().getPivotDataModel().getFields();
        for (int i = 0; i < pivotFieldArray.length && i < this._fieldsAreaType[0].length; ++i) {
            if (this._fieldsAreaType[0][i] == this._fieldsAreaType[1][i]) {
                if (this._fieldsAreaType[1][i] != -1) continue;
                pivotFieldArray[i].setAreaType(3);
                continue;
            }
            if (this._fieldsAreaType[1][i] != -1) continue;
            pivotFieldArray[i].setAreaType(3);
        }
    }

    private void resetModelIndex() {
        TableModel tableModel = this.getModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        block0: for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            Object object = tableModel instanceof ColumnIdentifierTableModel ? ((ColumnIdentifierTableModel)((Object)tableModel)).getColumnIdentifier(tableColumn.getModelIndex()) : tableModel.getColumnName(tableColumn.getModelIndex());
            Object object2 = tableColumnModel.getColumn(i).getIdentifier();
            object = TableUtils.eraseIdentifierFlag(object, ":::HEADER");
            object = TableUtils.eraseIdentifierFlag(object, ":::DATA:::");
            object2 = TableUtils.eraseIdentifierFlag(object2, ":::HEADER");
            if (JideSwingUtilities.equals(object, object2 = TableUtils.eraseIdentifierFlag(object2, ":::DATA:::"))) continue;
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                object = tableModel instanceof ColumnIdentifierTableModel ? ((ColumnIdentifierTableModel)((Object)tableModel)).getColumnIdentifier(j) : tableModel.getColumnName(j);
                object = TableUtils.eraseIdentifierFlag(object, ":::HEADER");
                if (!JideSwingUtilities.equals(object = TableUtils.eraseIdentifierFlag(object, ":::DATA:::"), object2)) continue;
                tableColumn.setModelIndex(j);
                continue block0;
            }
        }
    }

    private void handleFieldAreaTypeChangeAfterAggregating() {
        PivotField[] pivotFieldArray = this.getAggregateTableModel().getPivotDataModel().getFields();
        for (int i = 0; i < pivotFieldArray.length && i < this._fieldsAreaType[0].length; ++i) {
            Object object;
            int n;
            if (this._fieldsAreaType[0][i] == this._fieldsAreaType[1][i]) {
                if (this._fieldsAreaType[1][i] != -1) continue;
                n = pivotFieldArray[i].getModelIndex();
                object = AggregateTableUtils.getColumnIdentifier(this, n);
                AggregateTableUtils.hideColumn(this, object, AggregateTableUtils.getTableModelIndex(this, n));
                continue;
            }
            if (this._fieldsAreaType[1][i] == -1) {
                if (this._fieldsAreaType[0][i] != 3 && this._fieldsAreaType[0][i] != 0) continue;
                n = pivotFieldArray[i].getModelIndex();
                object = AggregateTableUtils.getColumnIdentifier(this, n);
                AggregateTableUtils.hideColumn(this, object, AggregateTableUtils.getTableModelIndex(this, n));
                continue;
            }
            if (this._fieldsAreaType[0][i] != -1 || this._fieldsAreaType[1][i] != 3 && this._fieldsAreaType[1][i] != 0) continue;
            n = pivotFieldArray[i].getModelIndex();
            object = AggregateTableUtils.getColumnIdentifier(this, n);
            AggregateTableUtils.showColumn(this, object, AggregateTableUtils.getTableModelIndex(this, n));
        }
    }

    private void setInitialFieldsAreaType() {
        PivotField[] pivotFieldArray = this.getAggregateTableModel().getPivotDataModel().getFields();
        for (int i = 0; i < pivotFieldArray.length; ++i) {
            this._fieldsAreaType[0][i] = pivotFieldArray[i].getAreaType();
            this._fieldsAreaType[1][i] = this._fieldsAreaType[0][i];
        }
    }

    private void initSnapshotFlags() {
        this._rememberColumnOrderBeforeGroup = true;
        this._rememberColumnOrderBeforeUngroup = false;
        this.setAggregating(false);
    }

    private void setRememberColumnOrderBeforeGroup(boolean bl) {
        this._rememberColumnOrderBeforeGroup = bl;
    }

    private boolean isRememberColumnOrderBeforeGroup() {
        return this._rememberColumnOrderBeforeGroup;
    }

    private void setRememberColumnOrderBeforeUngroup(boolean bl) {
        this._rememberColumnOrderBeforeUngroup = bl;
    }

    private boolean isRememberColumnOrderBeforeUngroup() {
        return this._rememberColumnOrderBeforeUngroup;
    }

    void setAggregating(boolean bl) {
        this._aggregating = bl;
    }

    boolean isAggregating() {
        return this._aggregating;
    }

    void configureSortableTableModel(AggregateTableModel aggregateTableModel) {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        if (iSortableTableModel != null) {
            int n = aggregateTableModel.getAggregatedColumnCount();
            int[] nArray = new int[n];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            iSortableTableModel.setMasterSortColumns(nArray);
        }
    }

    private void syncColumnModelToAreaIndex() {
        int n;
        int n2;
        AggregateTablePane aggregateTablePane = null;
        Object object = this.getClientProperty("TableScrollPane.Parent");
        if (object != null && object instanceof AggregateTablePane) {
            aggregateTablePane = (AggregateTablePane)object;
        }
        if (aggregateTablePane != null) {
            return;
        }
        AggregateTableModel aggregateTableModel = this.getAggregateTableModel();
        if (aggregateTableModel == null) {
            return;
        }
        PivotField[] pivotFieldArray = aggregateTableModel.getPivotDataModel().getFields();
        boolean[] blArray = new boolean[pivotFieldArray.length];
        for (n2 = 0; n2 < pivotFieldArray.length; ++n2) {
            blArray[n2] = false;
        }
        n2 = 0;
        for (n = 0; n < pivotFieldArray.length; ++n) {
            PivotField pivotField = pivotFieldArray[n];
            if (pivotField.getAreaType() == 0) continue;
            for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                Object object2 = this.getColumnModel().getColumn(i).getIdentifier();
                if (object2 == null || !(object2 instanceof String) || !((String)object2).contains(pivotField.getName())) continue;
                pivotField.setAreaType(3);
                pivotField.setAreaIndex(n2 * 2 + 1);
                ++n2;
                blArray[n] = true;
            }
        }
        for (n = 0; n < pivotFieldArray.length; ++n) {
            if (blArray[n] || pivotFieldArray[n].getAreaType() == 0) continue;
            pivotFieldArray[n].setAreaType(-1);
        }
    }

    public void aggregate() {
        this.aggregate((int[])null);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        MouseEvent mouseEvent;
        if (this.getAggregateTableModel().hasAggregateColumns() && eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton(mouseEvent = (MouseEvent)eventObject)) {
            Point point = mouseEvent.getPoint();
            int n3 = this.rowAtPoint(point);
            int n4 = this.columnAtPoint(point);
            int n5 = this.convertColumnIndexToModel(n4);
            if (this.getHeaderTableModel() != null && n5 >= 0 && n5 < this.getHeaderTableModel().getColumnCount()) {
                Rectangle rectangle = this.getCellRect(n3, n4, false);
                int n6 = (16 - this.getCollapsedIcon().getIconWidth()) / 2 + 2;
                int n7 = n6 + this.getCollapsedIcon().getIconWidth();
                if (point.x > rectangle.x + n6 && point.x < rectangle.x + n7 && point.y > rectangle.y && point.y < rectangle.y + this.getRowHeight()) {
                    return false;
                }
            }
        }
        return super.editCellAt(n, n2, eventObject);
    }

    public boolean isAutoAdjustGrouping() {
        return this._autoAdjustGrouping;
    }

    public void setAutoAdjustGrouping(boolean bl) {
        this._autoAdjustGrouping = bl;
    }

    public boolean isAutoGrouping() {
        return this._autoGrouping;
    }

    public void setAutoGrouping(boolean bl) {
        this._autoGrouping = bl;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    public boolean isExpandIconVisible(Node node) {
        boolean bl = true;
        if (!this.isCellSpanOn()) {
            bl = false;
        }
        if (bl && !this.getAggregateTableModel().getPivotDataModel().isSummaryMode()) {
            boolean bl2 = bl = node instanceof Expandable && ((Expandable)node).getAllVisibleChildrenCount() > 1;
        }
        if (bl && node != null) {
            int n = node.getLevel();
            PivotField[] pivotFieldArray = this.getAggregateTableModel().getPivotDataModel().getRowFields();
            if (pivotFieldArray.length > n && n >= 0) {
                PivotField pivotField = pivotFieldArray[n];
                bl = pivotField.isExpandable();
            }
        }
        return bl;
    }

    public String getResourceString(String string) {
        try {
            return PivotResources.getResourceBundle(this.getLocale()).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Override
    public String getValueAtInString(int n, int n2, ValueConverter valueConverter) {
        Object object = this.getValueAt(n, n2);
        if (valueConverter != null) {
            object = valueConverter.convert(this, object, n, n2);
        }
        Class<?> clazz = this.getCellClassAt(n, n2);
        ConverterContext converterContext = this.getConverterContextAt(n, n2);
        String string = ObjectConverterManager.toString(object, clazz, converterContext);
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        int n3 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, AggregateTableModel.class);
        Expandable expandable = headerTableModel.getExpandable(n3, n2);
        return this.appendSummaryOrTotal(n3, n2, (Value)((Object)expandable), string);
    }

    @Override
    public boolean needAdjustCellValueString(int n, int n2) {
        int n3;
        if (n2 >= this.getAggregateTableModel().getAggregatedColumnCount()) {
            return false;
        }
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        Expandable expandable = headerTableModel.getExpandable(n3 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, AggregateTableModel.class), n2);
        return (expandable instanceof SummaryValue || expandable instanceof GrandTotalValue) && !headerTableModel.isDataCell(n, n2);
    }

    private String appendSummaryOrTotal(int n, int n2, Value value, String string) {
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        if (value instanceof SummaryValue && !headerTableModel.isDataCell(n, n2)) {
            int n3 = ((SummaryValue)value).getSummaryType();
            string = MessageFormat.format(this.getResourceString("Renderer.totalPhrase"), string, n3 == -1 ? this.getResourceString("Renderer.total") : headerTableModel.getPivotDataModel().getSummaryCalculator().getSummaryName(this.getLocale(), n3));
        } else if (value instanceof GrandTotalValue && !headerTableModel.isDataCell(n, n2)) {
            String string2;
            PivotField[] pivotFieldArray = headerTableModel.getPivotDataModel().getDataFields();
            int n4 = 0;
            boolean bl = false;
            if (pivotFieldArray != null) {
                for (int i = 0; i < pivotFieldArray.length; ++i) {
                    if (i == 0) {
                        n4 = pivotFieldArray[i].getGrandTotalSummaryType();
                        continue;
                    }
                    if (n4 == pivotFieldArray[i].getGrandTotalSummaryType()) continue;
                    bl = true;
                }
            }
            if (headerTableModel.isRowHeader()) {
                try {
                    string2 = this.getResourceString("Renderer.grandTotal.row");
                }
                catch (Exception exception) {
                    string2 = null;
                }
            } else {
                try {
                    string2 = this.getResourceString("Renderer.grandTotal.column");
                }
                catch (Exception exception) {
                    string2 = null;
                }
            }
            string = string2 != null ? string2 : (bl ? MessageFormat.format(this.getResourceString("Renderer.grandTotalPhrase"), this.getResourceString("Renderer.grandTotal"), this.getResourceString("Renderer.mixed")) : (n4 == 0 ? this.getResourceString("Renderer.grandTotal") : MessageFormat.format(this.getResourceString("Renderer.grandTotalPhrase"), this.getResourceString("Renderer.grandTotal"), n4 == -1 ? this.getResourceString("Renderer.total") : headerTableModel.getPivotDataModel().getSummaryCalculator().getSummaryName(this.getLocale(), n4))));
        }
        return string;
    }

    public void setColumnVisible(String string, boolean bl) {
        int n = AggregateTableUtils.getTableModelIndex(this, AggregateTableUtils.getFieldIndex(this, string));
        if (bl) {
            AggregateTableUtils.showColumn(this, string, n);
        } else {
            AggregateTableUtils.hideColumn(this, string, n);
        }
    }

    @Override
    public String getTableHeaderToolTipText(MouseEvent mouseEvent) {
        String string = super.getTableHeaderToolTipText(mouseEvent);
        if (string != null || !(this.getTableHeader() instanceof AggregateTableHeader) || !((AggregateTableHeader)this.getTableHeader()).isGroupHeaderEnabled()) {
            return string;
        }
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel(), AggregateTableModel.class);
        if (!(tableModel instanceof AggregateTableModel)) {
            return null;
        }
        PivotDataSource pivotDataSource = ((AggregateTableModel)tableModel).getPivotDataModel().getDataSource();
        if (!(pivotDataSource instanceof TableModelPivotDataSource)) {
            return null;
        }
        ToolTipSupport toolTipSupport = (ToolTipSupport)((Object)TableModelWrapperUtils.getActualTableModel(((TableModelPivotDataSource)pivotDataSource).getTableModel(), ToolTipSupport.class));
        if (toolTipSupport == null) {
            return null;
        }
        for (int i = 0; i < ((AggregateTableModel)tableModel).getAggregatedColumnCount(); ++i) {
            Rectangle rectangle = ((AggregateTableHeader)this.getTableHeader()).getGroupedHeaderRect(i);
            if (rectangle == null || !rectangle.contains(mouseEvent.getPoint())) continue;
            int n = ((AggregateTableModel)tableModel).getGroupColumnAt(i);
            int n2 = TableModelWrapperUtils.getActualColumnAt(((TableModelPivotDataSource)pivotDataSource).getTableModel(), n, (TableModel)((Object)toolTipSupport));
            if (n2 < 0 || n2 >= ((TableModel)((Object)toolTipSupport)).getColumnCount()) break;
            string = toolTipSupport.getToolTipText(n2);
            break;
        }
        return string;
    }

    @Override
    public void prepareBeforeGroup() {
        this.configureSortableTableModel(this.getAggregateTableModel());
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(32)) {
            Lm.showInvalidProductMessage(AggregateTable.class.getName(), 32);
        }
    }

    public class DraggingHandler
    implements PropertyChangeListener,
    TableColumnModelListener {
        private boolean _moved = false;
        private int _originalColumnIndex = -1;

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            AggregateTable.this.syncColumnModelToAreaIndex();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            AggregateTable.this.syncColumnModelToAreaIndex();
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (!AggregateTable.this.isAggregating() && tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex() && !this._moved) {
                this._moved = true;
                this._originalColumnIndex = tableColumnModelEvent.getFromIndex();
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    public static interface TablePopupMenuCustomizer
    extends PivotTablePane.PopupMenuCustomizer {
        public void customize(JPopupMenu var1, Component var2, int var3, int var4);
    }

    public static interface PopupMenuCustomizer {
        public void customize(JPopupMenu var1, Component var2);
    }

    protected class DelegateExpandMouseInputListener
    extends DelegateMouseInputListener {
        public DelegateExpandMouseInputListener(MouseInputListener mouseInputListener) {
            super(mouseInputListener);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (AggregateTable.this.isColumnResizable() && TableUtils.getResizingColumn(AggregateTable.this, mouseEvent.getPoint(), AggregateTable.this.columnAtPoint(mouseEvent.getPoint())) != null) {
                return;
            }
            AggregateTable.this.showContextMenu(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                AggregateTable.this.handleMouseEvent(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                super.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            AggregateTable.this.showContextMenu(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (AggregateTable.this._columnResizer != null && AggregateTable.this._columnResizer.isResizing()) {
                return;
            }
            AggregateTable.this.showContextMenu(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (AggregateTable.this._columnResizer != null && AggregateTable.this._columnResizer.isResizing()) {
                return;
            }
            super.mouseDragged(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (AggregateTable.this._columnResizer != null && AggregateTable.this._columnResizer.isResizing()) {
                return;
            }
            super.mouseMoved(mouseEvent);
        }
    }

    protected class ExpandMouseListener
    extends MouseAdapter {
        protected ExpandMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            AggregateTable.this.handleMouseEvent(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            AggregateTable.this.showContextMenu(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            AggregateTable.this.showContextMenu(mouseEvent);
        }
    }
}

