/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pane;

import com.jidesoft.animation.CustomAnimation;
import com.jidesoft.animation.Function;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.pane.event.CollapsiblePaneEvent;
import com.jidesoft.pane.event.CollapsiblePaneListener;
import com.jidesoft.plaf.CollapsiblePaneUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.swing.VisibilityFocusTraversalPolicy;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.ReflectionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.plaf.PanelUI;

public class CollapsiblePane
extends JPanel
implements SwingConstants,
WindowConstants {
    private static final Logger LOGGER_EVENT;
    private static final String uiClassID = "CollapsiblePaneUI";
    private JComponent _contentPane;
    private boolean _contentPaneCheckingEnabled = false;
    private Icon _icon;
    private Icon _titleIcon;
    private Icon _collapsedIcon;
    private Icon _expandedIcon;
    private String _title;
    private int _verticalAlignment = 0;
    private int _horizontalAlignment = 10;
    private int _verticalTextPosition = 0;
    private int _horizontalTextPosition = 11;
    private int _iconTextGap = 4;
    private int _titleLabelGap = 4;
    private boolean _rotateIcon = true;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String TITLE_PROPERTY = "title";
    public static final String ICON_PROPERTY = "icon";
    public static final String PROPERTY_TITLE_ICON = "titleIcon";
    public static final String COLLAPSED_PROPERTY = "collapsed";
    public static final String STYLE_PROPERTY = "style";
    public static final String PROPERTY_COLLAPSED_ICON = "collapsedIcon";
    public static final String PROPERTY_EXPANDED_ICON = "expandedIcon";
    protected boolean _collapsed = false;
    protected int _collapsedPercentage = 0;
    protected int _contentPaneHeight = -1;
    protected int _contentPaneWidth = -1;
    private ScrollPanel _scrollPane;
    private int _initDelay = 50;
    private int _stepDelay = 5;
    private int _steps = 10;
    private Function _animationFunction;
    public static final int DROPDOWN_STYLE = 0;
    public static final int TREE_STYLE = 1;
    public static final int PLAIN_STYLE = 2;
    public static final int SEPARATOR_STYLE = 3;
    private int _style;
    private boolean _emphasized;
    private boolean _collapsible = true;
    public static final String EMPHASIZED_PROPERTY = "emphasized";
    private int _slidingDirection = 5;
    private boolean _showTitleBar = true;
    private boolean _showExpandButton = true;
    private boolean _focusPainted = true;
    private boolean _contentAreaFilled = true;
    private boolean _titlePaneOpaque = true;
    private Component _titleComponent;
    private JComponent _titleLabelComponent;
    private boolean _autoExpandOnDragover = true;
    protected boolean _rollover = false;
    private boolean _collapseOnTitleClick = true;
    private Action _toggleAction = null;
    private boolean _contentBorderVisible = true;
    public static final String ICONTEXTGAP_PROPERTY = "iconTextGap";
    public static final String VERTICAL_ALIGNMENT_PROPERTY = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT_PROPERTY = "horizontalAlignment";
    public static final String VERTICAL_TEXTPOSITION_PROPERTY = "verticalTextPosition";
    public static final String HORIZONTAL_TEXTPOSITION_PROPERTY = "horizontalTextPosition";
    public static final String PROPERTY_COLLAPSIBLE = "collapsible";
    public static final String PROPERTY_SHOW_TITLE_BAR = "showTitleBar";
    public static final String PROPERTY_SHOW_EXPAND_BUTTON = "showExpandButton";
    public static final String PROPERTY_SLIDING_DIRECTION = "slidingDirection";
    public static final String PROPERTY_FOCUS_PAINTED = "focusPainted";
    public static final String PROPERTY_CONTENTAREA_FILLED = "contentAreaFilled";
    public static final String PROPERTY_TITLE_PANE_OPAQUE = "titlePaneOpaque";
    public static final String PROPERTY_AUTO_EXPAND_ON_DRAGOVER = "autoExpandOnDragover";
    public static final String PROPERTY_TITLE_COMPONENT = "titleComponent";
    public static final String PROPERTY_TITLE_LABEL_COMPONENT = "titleLabelComponent";
    public static final String PROPERTY_COLLAPSE_ON_TITLE_CLICK = "collapseOnTitleClick";
    public static final String PROPERTY_COLLAPSED_PERCENTAGE = "collapsedPercentage";
    public static final String PROPERTY_TOGGLE_ACTION = "toggleAction";
    public static final String PROPERTY_CONTENT_BORDER_VISIBLE = "contentBorderVisible";

    public CollapsiblePane() {
        this("");
    }

    public CollapsiblePane(String string) {
        this(string, UIDefaultsLookup.getIcon("CollapsiblePane.defaultIcon"));
    }

    public CollapsiblePane(String string, int n) {
        this(string, UIDefaultsLookup.getIcon("CollapsiblePane.defaultIcon"), n);
    }

    public CollapsiblePane(String string, Icon icon, int n, int n2, int n3) {
        this(string, icon);
        this._initDelay = n;
        this._stepDelay = n2;
        this._steps = n3;
    }

    public CollapsiblePane(String string, Icon icon, int n, int n2, int n3, int n4) {
        this(string, icon);
        this._initDelay = n;
        this._stepDelay = n2;
        this._steps = n3;
        this._slidingDirection = n4;
    }

    public CollapsiblePane(String string, Icon icon) {
        this(string, icon, 5);
    }

    public CollapsiblePane(String string, Icon icon, int n) {
        if (string == null) {
            throw new IllegalArgumentException("title cannot be null");
        }
        this.setContentPaneCheckingEnabled(false);
        this.setOpaque(false);
        this.setFocusable(true);
        this._scrollPane = new ScrollPanel();
        this._scrollPane.setOpaque(false);
        this.add(this._scrollPane);
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        this.setContentPane(jPanel);
        this.setTitle(string);
        this.setIcon(icon);
        this.setSlidingDirection(n);
        this.setContentPaneCheckingEnabled(true);
        this.updateUI();
    }

    @Override
    public PanelUI getUI() {
        return (CollapsiblePaneUI)this.ui;
    }

    public void setUI(CollapsiblePaneUI collapsiblePaneUI) {
        boolean bl = this.isContentPaneCheckingEnabled();
        try {
            this.setContentPaneCheckingEnabled(false);
            super.setUI(collapsiblePaneUI);
        }
        finally {
            this.setContentPaneCheckingEnabled(bl);
        }
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((CollapsiblePaneUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected boolean isContentPaneCheckingEnabled() {
        return this._contentPaneCheckingEnabled;
    }

    protected void setContentPaneCheckingEnabled(boolean bl) {
        this._contentPaneCheckingEnabled = bl;
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (this.isContentPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    @Override
    public void remove(Component component) {
        int n = this.getComponentCount();
        super.remove(component);
        if (n == this.getComponentCount()) {
            this.getContentPane().remove(component);
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.isContentPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public JComponent getContentPane() {
        return this._contentPane;
    }

    public void setContentPane(JComponent jComponent) {
        JComponent jComponent2 = this.getContentPane();
        if (this._contentPane == null || !this._contentPane.equals(jComponent)) {
            this._scrollPane.removeAll();
            this._scrollPane.add(jComponent);
            this._contentPane = jComponent;
            this.firePropertyChange(CONTENT_PANE_PROPERTY, jComponent2, jComponent);
        }
    }

    public void setCollapsed(boolean bl) throws PropertyVetoException {
        Boolean bl2 = this.isCollapsed() ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(COLLAPSED_PROPERTY, bl2, bl3);
        this._collapsed = bl;
        if (this._collapsed) {
            this.fireCollapsiblePaneEvent(6102);
        } else {
            this.fireCollapsiblePaneEvent(6100);
        }
        this.firePropertyChange(COLLAPSED_PROPERTY, bl2, bl3);
    }

    public boolean isCollapsed() {
        return this._collapsed;
    }

    public boolean isExpanded() {
        return !this.isCollapsed();
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Title cannot be null or empty");
        }
        String string2 = this._title;
        if (!string.equals(string2)) {
            this._title = string;
            this.firePropertyChange(TITLE_PROPERTY, string2, string);
        }
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this._icon;
        this._icon = icon;
        this.firePropertyChange(ICON_PROPERTY, icon2, icon);
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setTitleIcon(Icon icon) {
        Icon icon2 = this._titleIcon;
        this._titleIcon = icon;
        this.firePropertyChange(PROPERTY_TITLE_ICON, icon2, icon);
    }

    public Icon getTitleIcon() {
        return this._titleIcon;
    }

    protected int checkHorizontalKey(int n, String string) {
        if (n == 2 || n == 0 || n == 4 || n == 10 || n == 11) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    protected int checkVerticalKey(int n, String string) {
        if (n == 1 || n == 0 || n == 3) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    public int getIconTextGap() {
        return this._iconTextGap;
    }

    public void setIconTextGap(int n) {
        int n2 = this._iconTextGap;
        this._iconTextGap = n;
        this.firePropertyChange(ICONTEXTGAP_PROPERTY, n2, n);
        if (n != n2) {
            this.revalidate();
            this.repaint();
        }
    }

    public int getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (n == this._verticalAlignment) {
            return;
        }
        int n2 = this._verticalAlignment;
        this._verticalAlignment = this.checkVerticalKey(n, VERTICAL_ALIGNMENT_PROPERTY);
        this.firePropertyChange(VERTICAL_ALIGNMENT_PROPERTY, n2, this._verticalAlignment);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this._horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (n == this._horizontalAlignment) {
            return;
        }
        int n2 = this._horizontalAlignment;
        this._horizontalAlignment = this.checkHorizontalKey(n, HORIZONTAL_ALIGNMENT_PROPERTY);
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_PROPERTY, n2, this._horizontalAlignment);
        this.repaint();
    }

    public int getVerticalTextPosition() {
        return this._verticalTextPosition;
    }

    public void setVerticalTextPosition(int n) {
        if (n == this._verticalTextPosition) {
            return;
        }
        int n2 = this._verticalTextPosition;
        this._verticalTextPosition = this.checkVerticalKey(n, VERTICAL_TEXTPOSITION_PROPERTY);
        this.firePropertyChange(VERTICAL_TEXTPOSITION_PROPERTY, n2, this._verticalTextPosition);
        this.repaint();
    }

    public int getHorizontalTextPosition() {
        return this._horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int n) {
        int n2 = this._horizontalTextPosition;
        this._horizontalTextPosition = this.checkHorizontalKey(n, HORIZONTAL_TEXTPOSITION_PROPERTY);
        this.firePropertyChange(HORIZONTAL_TEXTPOSITION_PROPERTY, n2, this._horizontalTextPosition);
        this.repaint();
    }

    public void addCollapsiblePaneListener(CollapsiblePaneListener collapsiblePaneListener) {
        this.listenerList.add(CollapsiblePaneListener.class, collapsiblePaneListener);
        this.enableEvents(0L);
    }

    public void removeCollapsiblePaneListener(CollapsiblePaneListener collapsiblePaneListener) {
        this.listenerList.remove(CollapsiblePaneListener.class, collapsiblePaneListener);
    }

    public CollapsiblePaneListener[] getCollapsiblePaneListeners() {
        return (CollapsiblePaneListener[])this.listenerList.getListeners(CollapsiblePaneListener.class);
    }

    public void fireCollapsiblePaneEvent(int n) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 6099: {
                    LOGGER_EVENT.fine("CollapsiblePane \"" + this.getTitle() + "\" is expanding.");
                    break;
                }
                case 6100: {
                    LOGGER_EVENT.fine("CollapsiblePane \"" + this.getTitle() + "\" is expanded.");
                    break;
                }
                case 6101: {
                    LOGGER_EVENT.fine("CollapsiblePane \"" + this.getTitle() + "\" is collapsing.");
                    break;
                }
                case 6102: {
                    LOGGER_EVENT.fine("CollapsiblePane \"" + this.getTitle() + "\" is collapsed.");
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        CollapsiblePaneEvent collapsiblePaneEvent = null;
        block12: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CollapsiblePaneListener.class) continue;
            if (collapsiblePaneEvent == null) {
                collapsiblePaneEvent = new CollapsiblePaneEvent(this, n);
            }
            switch (n) {
                case 6099: {
                    ((CollapsiblePaneListener)objectArray[i + 1]).paneExpanding(collapsiblePaneEvent);
                    continue block12;
                }
                case 6100: {
                    ((CollapsiblePaneListener)objectArray[i + 1]).paneExpanded(collapsiblePaneEvent);
                    continue block12;
                }
                case 6101: {
                    ((CollapsiblePaneListener)objectArray[i + 1]).paneCollapsing(collapsiblePaneEvent);
                    continue block12;
                }
                case 6102: {
                    ((CollapsiblePaneListener)objectArray[i + 1]).paneCollapsed(collapsiblePaneEvent);
                }
            }
        }
        if (n == 6102) {
            Container container;
            for (container = this; container != null && !container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot(); container = container.getParent()) {
            }
            if (container != null) {
                FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                if (focusTraversalPolicy instanceof VisibilityFocusTraversalPolicy) {
                    ((VisibilityFocusTraversalPolicy)focusTraversalPolicy).addContainer(this);
                } else if (focusTraversalPolicy == null || !ReflectionUtils.isSubClassOf(focusTraversalPolicy, "LegacyGlueFocusTraversalPolicy")) {
                    container.setFocusTraversalPolicy(new VisibilityFocusTraversalPolicy(focusTraversalPolicy, this));
                }
            }
        } else if (n == 6100) {
            Container container;
            for (container = this; container != null && !container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot(); container = container.getParent()) {
            }
            if (container != null && container.getFocusTraversalPolicy() instanceof VisibilityFocusTraversalPolicy) {
                VisibilityFocusTraversalPolicy visibilityFocusTraversalPolicy = (VisibilityFocusTraversalPolicy)container.getFocusTraversalPolicy();
                visibilityFocusTraversalPolicy.removeContainer(this);
                if (visibilityFocusTraversalPolicy.getContainers().length == 0) {
                    container.setFocusTraversalPolicy(visibilityFocusTraversalPolicy.getDefaultPolicy());
                }
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCollapsiblePane();
        }
        return this.accessibleContext;
    }

    public boolean isCollapseOnTitleClick() {
        return this._collapseOnTitleClick;
    }

    public void setCollapseOnTitleClick(boolean bl) {
        if (this._collapseOnTitleClick != bl) {
            boolean bl2 = this._collapseOnTitleClick;
            this._collapseOnTitleClick = bl;
            this.firePropertyChange(PROPERTY_COLLAPSE_ON_TITLE_CLICK, bl2, this._collapseOnTitleClick);
        }
    }

    public int getTitleLabelGap() {
        return this._titleLabelGap;
    }

    public void setTitleLabelGap(int n) {
        this._titleLabelGap = n;
    }

    public int getContentPaneHeight() {
        if (this._contentPaneHeight < 0) {
            return this.getContentPane().getPreferredSize().height;
        }
        return this._contentPaneHeight;
    }

    public void setContentPaneHeight(int n) {
        this._contentPaneHeight = n;
    }

    public int getContentPaneWidth() {
        if (this._contentPaneWidth < 0) {
            return this.getContentPane().getPreferredSize().width;
        }
        return this._contentPaneWidth;
    }

    public void setContentPaneWidth(int n) {
        this._contentPaneWidth = n;
    }

    public JComponent getActualComponent() {
        return this._scrollPane;
    }

    public int getInitDelay() {
        return this._initDelay;
    }

    public void setInitDelay(int n) {
        this._initDelay = n;
    }

    public int getStepDelay() {
        return this._stepDelay;
    }

    public void setStepDelay(int n) {
        this._stepDelay = n;
    }

    public int getSteps() {
        return this._steps;
    }

    public void setSteps(int n) {
        this._steps = n;
    }

    public int getStyle() {
        return this._style;
    }

    public void setStyle(int n) {
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            if (n == this._style) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Invalid style. Valid styles are DROPDOWN_STYLE, TREE_STYLE, PLAIN_STYLE and SEPARATOR_STYLE that are defined in CollapsiblePane.");
        }
        int n2 = this._style;
        this._style = n;
        this.firePropertyChange(STYLE_PROPERTY, n2, this._style);
    }

    public int getSlidingDirection() {
        return this._slidingDirection;
    }

    public void setSlidingDirection(int n) {
        if (n != 1 && n != 5 && n != 7 && n != 3) {
            throw new IllegalArgumentException("Sliding direction can be either SwingConstants.NORTH or SwingConstants.SOUTH.");
        }
        int n2 = this._slidingDirection;
        this._slidingDirection = n;
        this.firePropertyChange(PROPERTY_SLIDING_DIRECTION, n2, n);
    }

    public boolean isEmphasized() {
        return this._emphasized;
    }

    public void setEmphasized(boolean bl) {
        boolean bl2 = this._emphasized;
        if (this._emphasized != bl) {
            this._emphasized = bl;
            this.firePropertyChange(EMPHASIZED_PROPERTY, bl2, bl);
        }
    }

    public boolean isCollapsible() {
        return this._collapsible;
    }

    public void setCollapsible(boolean bl) {
        boolean bl2 = this._collapsible;
        if (this._collapsible != bl) {
            this._collapsible = bl;
            this.firePropertyChange(PROPERTY_COLLAPSIBLE, bl2, bl);
        }
    }

    public boolean isShowTitleBar() {
        return this._showTitleBar;
    }

    public void setShowTitleBar(boolean bl) {
        boolean bl2 = this._showTitleBar;
        if (bl2 != bl) {
            this._showTitleBar = bl;
            this.firePropertyChange(PROPERTY_SHOW_TITLE_BAR, bl2, this._showTitleBar);
        }
    }

    public boolean isShowExpandButton() {
        return this._showExpandButton;
    }

    public void setShowExpandButton(boolean bl) {
        boolean bl2 = this._showExpandButton;
        if (bl2 != bl) {
            this._showExpandButton = bl;
            this.firePropertyChange(PROPERTY_SHOW_EXPAND_BUTTON, bl2, this._showExpandButton);
        }
    }

    public void collapse(boolean bl) {
        if (!this.isVisible() || !this.isShowing()) {
            try {
                this.setCollapsed(bl);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            Action action = this.getToggleAction();
            if (action != null) {
                if (this.isCollapsed() && !bl) {
                    action.actionPerformed(new ActionEvent(this, 0, ""));
                } else if (!this.isCollapsed() && bl) {
                    action.actionPerformed(new ActionEvent(this, 0, ""));
                }
            }
        }
    }

    public boolean isFocusPainted() {
        return this._focusPainted;
    }

    public void setFocusPainted(boolean bl) {
        boolean bl2 = this._focusPainted;
        if (bl2 != bl) {
            this._focusPainted = bl;
            this.firePropertyChange(PROPERTY_FOCUS_PAINTED, bl2, this._focusPainted);
            if (this.isFocusOwner()) {
                this.revalidate();
                this.repaint();
            }
        }
    }

    public boolean isContentAreaFilled() {
        return this._contentAreaFilled;
    }

    public void setContentAreaFilled(boolean bl) {
        boolean bl2 = this._contentAreaFilled;
        if (bl2 != bl) {
            this._contentAreaFilled = bl;
            this.firePropertyChange(PROPERTY_CONTENTAREA_FILLED, bl2, this._contentAreaFilled);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isTitlePaneOpaque() {
        return this._titlePaneOpaque;
    }

    public void setTitlePaneOpaque(boolean bl) {
        boolean bl2 = this._titlePaneOpaque;
        if (bl2 != bl) {
            this._titlePaneOpaque = bl;
            this.firePropertyChange(PROPERTY_TITLE_PANE_OPAQUE, bl2, this._titlePaneOpaque);
            this.revalidate();
            this.repaint();
        }
    }

    public Component getTitleComponent() {
        return this._titleComponent;
    }

    public void setTitleComponent(Component component) {
        Component component2 = this._titleComponent;
        if (component2 != component) {
            this._titleComponent = component;
            this.firePropertyChange(PROPERTY_TITLE_COMPONENT, component2, component);
        }
    }

    public void setTitleLabelComponent(JComponent jComponent) {
        JComponent jComponent2 = this._titleLabelComponent;
        if (jComponent2 != jComponent) {
            this._titleLabelComponent = jComponent;
            this.firePropertyChange(PROPERTY_TITLE_LABEL_COMPONENT, jComponent2, this._titleLabelComponent);
        }
    }

    public JComponent getTitleLabelComponent() {
        return this._titleLabelComponent;
    }

    public boolean isAutoExpandOnDragover() {
        return this._autoExpandOnDragover;
    }

    public void setAutoExpandOnDragover(boolean bl) {
        boolean bl2 = this._autoExpandOnDragover;
        if (bl2 != bl) {
            this._autoExpandOnDragover = bl;
            this.firePropertyChange(PROPERTY_AUTO_EXPAND_ON_DRAGOVER, bl2, this._autoExpandOnDragover);
            this.updateUI();
        }
    }

    public boolean isRollover() {
        return this._rollover;
    }

    public void setRollover(boolean bl) {
        boolean bl2 = this._rollover;
        this._rollover = bl;
        if (bl2 != this._rollover) {
            this.firePropertyChange("rollover", bl2, this._rollover);
            this.repaint();
        }
    }

    public void setExpandedIcon(Icon icon) {
        Icon icon2 = this._expandedIcon;
        this._expandedIcon = icon;
        this.firePropertyChange(PROPERTY_EXPANDED_ICON, icon2, icon);
    }

    public Icon getExpandedIcon() {
        return this._expandedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        Icon icon2 = this._collapsedIcon;
        this._collapsedIcon = icon;
        this.firePropertyChange(PROPERTY_COLLAPSED_ICON, icon2, icon);
    }

    public Icon getCollapsedIcon() {
        return this._collapsedIcon;
    }

    public void setCollapsedPercentage(int n) {
        int n2 = this._collapsedPercentage;
        this._collapsedPercentage = n;
        this.firePropertyChange(PROPERTY_COLLAPSED_PERCENTAGE, n2, n);
    }

    public int getCollapsedPercentage() {
        return this._collapsedPercentage;
    }

    public void setToggleAction(Action action) {
        Action action2 = this._toggleAction;
        this._toggleAction = action;
        this.firePropertyChange(PROPERTY_TOGGLE_ACTION, action2, action);
    }

    public Action getToggleAction() {
        if (this._toggleAction == null && this.getUI() instanceof CollapsiblePaneUI) {
            return ((CollapsiblePaneUI)this.getUI()).getToggleAction();
        }
        return this._toggleAction;
    }

    public boolean isContentBorderVisible() {
        return this._contentBorderVisible;
    }

    public void setContentBorderVisible(boolean bl) {
        boolean bl2 = this._contentBorderVisible;
        this._contentBorderVisible = bl;
        if (bl2 != this._contentBorderVisible) {
            this.firePropertyChange(PROPERTY_CONTENT_BORDER_VISIBLE, bl2, this._contentBorderVisible);
            this.repaint();
            this.revalidate();
        }
    }

    public String getResourceString(String string) {
        return Resource.getResourceBundle(this.getLocale()).getString(string);
    }

    public Function getAnimationFunction() {
        return this._animationFunction == null ? CustomAnimation.FUNC_POW2 : this._animationFunction;
    }

    public void setAnimationFunction(Function function) {
        this._animationFunction = function;
    }

    public Icon rotateIcon(Icon icon) {
        if (this.getSlidingDirection() == 7) {
            icon = IconsFactory.createRotatedImage(this, icon, 90.0);
        } else if (this.getSlidingDirection() == 1) {
            icon = IconsFactory.createRotatedImage(this, icon, 180.0);
        } else if (this.getSlidingDirection() == 3) {
            icon = IconsFactory.createRotatedImage(this, icon, 270.0);
        }
        return icon;
    }

    public boolean isRotateIcon() {
        return this._rotateIcon;
    }

    public void setRotateIcon(boolean bl) {
        this._rotateIcon = bl;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(CollapsiblePane.class.getName(), 2);
        }
        LOGGER_EVENT = Logger.getLogger(CollapsiblePane.class.getName());
    }

    class ScrollPanel
    extends JPanel
    implements Scrollable {
        public ScrollPanel() {
            this.setLayout(new BorderLayout());
        }

        public ScrollPanel(Component component) {
            this.setLayout(new BorderLayout());
            this.add(component);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (this.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)this.getParent();
                int n = jViewport.getWidth();
                Dimension dimension = this.getMinimumSize();
                Dimension dimension2 = this.getMaximumSize();
                if (n >= dimension.width && n <= dimension2.width) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            if (this.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)this.getParent();
                int n = jViewport.getHeight();
                Dimension dimension = this.getPreferredSize();
                Dimension dimension2 = this.getMaximumSize();
                if (n >= dimension.height && n <= dimension2.height) {
                    return true;
                }
            }
            return false;
        }
    }

    protected class AccessibleCollapsiblePane
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -3854196785760685510L;

        protected AccessibleCollapsiblePane() {
            super(CollapsiblePane.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return CollapsiblePane.this.getTitle();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            if (CollapsiblePane.this.isCollapsed()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                try {
                    if (number.intValue() == 0) {
                        CollapsiblePane.this.setCollapsed(true);
                    } else {
                        CollapsiblePane.this.setCollapsed(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return Integer.MAX_VALUE;
        }
    }
}

