/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.navigation;

import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.NavigationComponentHelper;
import com.jidesoft.tooltip.ExpandedTipUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class NavigationTable
extends JTable
implements NavigationComponent {
    private NavigationComponentHelper _helper;
    public static final String PROPERTY_EXPANDED_TIP = "expandedTip";
    private boolean _expandedTip = true;

    public NavigationTable() {
        this.initComponents();
    }

    public NavigationTable(TableModel tableModel) {
        super(tableModel);
        this.initComponents();
    }

    public NavigationTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initComponents();
    }

    public NavigationTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initComponents();
    }

    public NavigationTable(int n, int n2) {
        super(n, n2);
        this.initComponents();
    }

    public NavigationTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initComponents();
    }

    public NavigationTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initComponents();
    }

    private void initComponents() {
        this.setShowGrid(false);
        this._helper = this.createNavigationHelper();
        this._helper.setup(this);
        if (this._expandedTip) {
            ExpandedTipUtils.install(this);
            ExpandedTipUtils.install(this.getTableHeader());
        }
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new NavigationTableHelper();
    }

    private Rectangle getRowBounds(int n) {
        return this.getCellRect(n, 0, false).union(this.getCellRect(n, this.getColumnCount() - 1, false));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.isPaintingForPrint()) {
            this._helper.paint(graphics, this);
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Object object = this.getValueAt(n, n2);
        return tableCellRenderer.getTableCellRendererComponent(this, object, false, false, n, n2);
    }

    public boolean isExpandedTip() {
        return this._expandedTip;
    }

    public void setExpandedTip(boolean bl) {
        boolean bl2 = this._expandedTip;
        if (bl != this._expandedTip) {
            this._expandedTip = bl;
            this.firePropertyChange(PROPERTY_EXPANDED_TIP, bl2, this._expandedTip);
            if (this._expandedTip) {
                ExpandedTipUtils.install(this);
                ExpandedTipUtils.install(this.getTableHeader());
            } else {
                ExpandedTipUtils.uninstall(this);
                ExpandedTipUtils.uninstall(this.getTableHeader());
            }
        }
    }

    public int getNavigationRolloverRow() {
        return this._helper.getRolloverRow();
    }

    public void setNavigationRolloverRow(int n) {
        int n2 = this._helper.getRolloverRow();
        if (n2 != n) {
            this._helper.setRolloverRow(n);
            Rectangle rectangle = this.getRowBounds(n2);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
            if ((rectangle = this.getRowBounds(n)) != null) {
                this.repaint(rectangle);
            }
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(NavigationTable.class.getName(), 2);
        }
    }

    public class NavigationTableHelper
    extends NavigationComponentHelper {
        @Override
        public Rectangle getRowBounds(int n) {
            return NavigationTable.this.getRowBounds(n);
        }

        @Override
        public int rowAtPoint(Point point) {
            return NavigationTable.this.rowAtPoint(point);
        }

        @Override
        public int[] getSelectedRows() {
            return NavigationTable.this.getSelectedRows();
        }
    }
}

