/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.marker;

import com.jidesoft.marker.DefaultMarkerStripePainter;
import com.jidesoft.marker.Marker;
import com.jidesoft.marker.MarkerArea;
import com.jidesoft.marker.MarkerModel;
import com.jidesoft.marker.MarkerStripePainter;
import com.jidesoft.marker.MarkerSupport;
import com.jidesoft.range.IntegerRange;
import com.jidesoft.utils.HtmlUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class MarkerStripe
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected MarkerSupport _markerSupport;
    protected MarkerArea _markerArea;
    protected MarkerStripePainter _painter;
    private static final int OFFSET = 0;
    private static final int MINIMUM_SIZE = 3;

    public MarkerStripe(MarkerArea markerArea) {
        this._markerArea = markerArea;
        this._markerSupport = markerArea.getMarkerSupport();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void setMarkerSupport(MarkerSupport markerSupport) {
        this._markerSupport = markerSupport;
    }

    public MarkerStripePainter getPainter() {
        if (this._painter == null) {
            this._painter = new DefaultMarkerStripePainter();
        }
        return this._painter;
    }

    public void setPainter(MarkerStripePainter markerStripePainter) {
        this._painter = markerStripePainter;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this._markerSupport == null) {
            return;
        }
        MarkerModel markerModel = this._markerSupport.getMarkerModel();
        if (markerModel == null) {
            return;
        }
        List<Marker> list = markerModel.getMarkers();
        Color color = graphics.getColor();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Marker marker = list.get(i);
                this.paintMarker(graphics, marker);
            }
        }
        graphics.setColor(color);
    }

    protected List<Marker> getMarkersAt(Point point) {
        if (this._markerSupport != null) {
            Insets insets = this.getInsets();
            int n = this.getHeight() - this.getPainter().getMaxStripeHeight() - insets.top - insets.bottom;
            point.x -= insets.left;
            point.y -= insets.top;
            IntegerRange integerRange = this._markerSupport.pointToIndexRange(new Point(point.x - 0, point.y - 0), n);
            IntegerRange integerRange2 = this._markerSupport.pointToIndexRange(new Point(point.x + 0, point.y + 0), n);
            if (integerRange != null && integerRange2 != null) {
                MarkerModel markerModel = this._markerSupport.getMarkerModel();
                return markerModel.getMarkersAt(integerRange.getMin(), integerRange2.getMax());
            }
        }
        return null;
    }

    protected void paintMarker(Graphics graphics, Marker marker) {
        int n = marker.getStartOffset();
        Insets insets = this.getInsets();
        int n2 = this.getHeight() - this.getPainter().getMaxStripeHeight() - insets.top - insets.bottom;
        Point point = this._markerSupport.indexToPoint(n, n2);
        if (point == null) {
            return;
        }
        point.y += insets.top;
        int n3 = point.y;
        int n4 = marker.getEndOffset();
        int n5 = 3;
        if (n4 != n) {
            Point point2 = this._markerSupport.indexToPoint(n4, n2);
            if (point2 == null) {
                return;
            }
            int n6 = point2.y;
            if (n6 - n3 > n5) {
                n5 = n6 - n3;
            }
        }
        int n7 = this.getWidth() - insets.left - insets.right;
        this.getPainter().paint(this._markerArea, graphics, marker, new Rectangle(insets.left, n3, n7 - 1, n5));
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        List<Marker> list = this.getMarkersAt(mouseEvent.getPoint());
        if (list != null && list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("<html>");
            for (int i = 0; i < list.size(); ++i) {
                Marker marker = list.get(i);
                String string = marker.getToolTipText();
                stringBuffer.append(HtmlUtils.formatHtmlSubString(string));
                if (i == list.size() - 1) continue;
                stringBuffer.append("<br>");
            }
            stringBuffer.append("</html>");
            if (stringBuffer.length() <= "<html>".length() + "</html>".length()) {
                return null;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        List<Marker> list = this.getMarkersAt(mouseEvent.getPoint());
        if (list != null && list.size() > 0) {
            Marker marker = list.get(0);
            this._markerSupport.scrollTo(marker.getStartOffset(), marker.getEndOffset(), this._markerArea.isClickToSelect());
        } else {
            Insets insets = this.getInsets();
            int n = this.getHeight() - this.getPainter().getMaxStripeHeight() - insets.top - insets.bottom;
            IntegerRange integerRange = this._markerSupport.pointToIndexRange(mouseEvent.getPoint(), n);
            this._markerSupport.scrollTo(integerRange.getMin(), integerRange.getMax(), false);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        List<Marker> list = this.getMarkersAt(mouseEvent.getPoint());
        if (list != null && list.size() > 0) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

