/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.margin.AbstractRowMarginSupport;
import com.jidesoft.margin.MarginSupport;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableRowMarginSupport
extends AbstractRowMarginSupport {
    protected JTable _table;
    private TableModelListener _tableModelListener;
    private PropertyChangeListener _propertyChangeListener;

    public TableRowMarginSupport(JTable jTable, JScrollPane jScrollPane) {
        super(jScrollPane);
        this._table = jTable;
    }

    public JTable getTable() {
        return this._table;
    }

    @Override
    public int getRowCount() {
        return this._table.getRowCount();
    }

    @Override
    public void scrollTo(int n, int n2, boolean bl) {
        if (bl) {
            this._table.getSelectionModel().setSelectionInterval(Math.min(n, n2), Math.max(n, n2));
        }
        this._table.scrollRectToVisible(this._table.getCellRect(n2, 0, false));
    }

    @Override
    public int getRowHeight(int n) {
        return this._table.getRowHeight(n);
    }

    @Override
    public int positionToRow(int n) {
        int n2 = this.getViewPosition();
        Point point = new Point(0, n2 + n);
        if (this._table instanceof CellSpanTable) {
            return ((CellSpanTable)this._table).originalRowAtPoint(point);
        }
        return this._table.rowAtPoint(point);
    }

    @Override
    public int rowToPosition(int n) {
        Rectangle rectangle = this._table instanceof CellSpanTable ? ((CellSpanTable)this._table).originalGetCellRect(n, 0, false) : this._table.getCellRect(n, 0, false);
        int n2 = this.getViewPosition();
        return rectangle.y - n2;
    }

    @Override
    public int getBaselineAdjustment() {
        return -1;
    }

    @Override
    public void installListeners(MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        super.installListeners(repaintCallback, modelChangedCallback);
        if (modelChangedCallback != null) {
            if (this._tableModelListener == null) {
                this._tableModelListener = new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        modelChangedCallback.modelChanged(tableModelEvent);
                    }
                };
            }
            if (this._propertyChangeListener == null) {
                this._propertyChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object;
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 instanceof TableModel) {
                            ((TableModel)object2).removeTableModelListener(TableRowMarginSupport.this._tableModelListener);
                        }
                        if ((object = propertyChangeEvent.getNewValue()) instanceof TableModel) {
                            ((TableModel)object).addTableModelListener(TableRowMarginSupport.this._tableModelListener);
                        }
                        modelChangedCallback.modelChanged(propertyChangeEvent);
                    }
                };
            }
            this._table.addPropertyChangeListener("model", this._propertyChangeListener);
            this._table.getModel().addTableModelListener(this._tableModelListener);
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        if (this._propertyChangeListener != null) {
            this._table.removePropertyChangeListener("model", this._propertyChangeListener);
        }
        if (this._tableModelListener != null) {
            this._table.getModel().removeTableModelListener(this._tableModelListener);
        }
        super.uninstallListeners(repaintCallback, modelChangedCallback);
    }
}

