/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.lucene;

import com.jidesoft.lucene.LuceneDocumentProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;

class LuceneSupport {
    private RAMDirectory _directory = new RAMDirectory();
    private StandardAnalyzer _analyzer = new StandardAnalyzer();
    private Query _query;
    private boolean _indexing;
    private boolean _needReindex;
    private int _reindexStartRow;
    private int _reindexEndRow;
    private int _booleanQueryMaxClauseCount = 1024;
    private boolean _rangeQueryInclusive = true;
    private boolean _allowLeadingWildcard = true;
    private LuceneDocumentProvider _documentProvider;

    public LuceneSupport(LuceneDocumentProvider luceneDocumentProvider) {
        this.setIndexing(false);
        this.setNeedReindex(false);
        this.setReindexStartRow(-1);
        this.setReindexEndRow(-1);
        this._documentProvider = luceneDocumentProvider;
        this.startIndexing(0, luceneDocumentProvider.getDocumentCount() - 1, true);
    }

    public void startIndexing(int n, int n2, boolean bl) {
        this.setReindexStartRow(n);
        this.setReindexEndRow(n2);
        if (this.isIndexing()) {
            this.setNeedReindex(true);
            return;
        }
        this.setIndexing(true);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Document document;
                    int n = 0;
                    int n2 = LuceneSupport.this._documentProvider.getDocumentCount() - 1;
                    if (n2 == -1) {
                        return;
                    }
                    LuceneSupport.this.setNeedReindex(false);
                    LuceneSupport.this.setReindexStartRow(-1);
                    LuceneSupport.this.setReindexEndRow(-1);
                    IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_30, (Analyzer)LuceneSupport.this._analyzer);
                    indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                    IndexWriter indexWriter = new IndexWriter((Directory)LuceneSupport.this._directory, indexWriterConfig);
                    for (int i = n; i <= n2 && !LuceneSupport.this.isNeedReindex() && (document = LuceneSupport.this._documentProvider.getDocument(i)) != null; ++i) {
                        indexWriter.addDocument((Iterable)document);
                    }
                    if (!LuceneSupport.this.isNeedReindex()) {
                        indexWriter.commit();
                    } else {
                        indexWriter.rollback();
                    }
                    indexWriter.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    LuceneSupport.this.setIndexing(false);
                    if (LuceneSupport.this.isNeedReindex()) {
                        LuceneSupport.this.startIndexing(0, LuceneSupport.this._documentProvider.getDocumentCount() - 1, false);
                    } else {
                        LuceneSupport.this._documentProvider.notifyIndexCreated();
                    }
                }
            }
        };
        thread.start();
    }

    public Set<Integer> getMatchingRows() {
        HashSet<Integer> hashSet;
        block5: {
            Query query = this.getQuery();
            hashSet = new HashSet<Integer>();
            if (query == null) {
                for (int i = this._documentProvider.getDocumentCount() - 1; i >= 0; --i) {
                    hashSet.add(i);
                }
                return hashSet;
            }
            try {
                RAMDirectory rAMDirectory = this._directory;
                String[] stringArray = rAMDirectory.listAll();
                if (stringArray == null || stringArray.length <= 0) break block5;
                DirectoryReader directoryReader = DirectoryReader.open((Directory)rAMDirectory);
                IndexSearcher indexSearcher = new IndexSearcher((IndexReader)directoryReader);
                indexSearcher.search(query, new Collector(){

                    public void setScorer(Scorer scorer) {
                        System.out.println("setScorer");
                    }

                    public boolean acceptsDocsOutOfOrder() {
                        return true;
                    }

                    public void collect(int n) {
                        hashSet.add(n);
                    }

                    public void setNextReader(AtomicReaderContext atomicReaderContext) throws IOException {
                        System.out.println("setNextReader");
                    }
                });
                directoryReader.close();
            }
            catch (Exception exception) {
                hashSet.clear();
                for (int i = this._documentProvider.getDocumentCount() - 1; i >= 0; --i) {
                    hashSet.add(i);
                }
            }
        }
        return hashSet;
    }

    public List<Integer> getMatchingRowList() {
        ArrayList<Integer> arrayList;
        block5: {
            Query query = this.getQuery();
            arrayList = new ArrayList<Integer>();
            if (query == null) {
                for (int i = this._documentProvider.getDocumentCount() - 1; i >= 0; --i) {
                    arrayList.add(i);
                }
                return arrayList;
            }
            try {
                RAMDirectory rAMDirectory = this._directory;
                String[] stringArray = rAMDirectory.listAll();
                if (stringArray == null || stringArray.length <= 0) break block5;
                DirectoryReader directoryReader = IndexReader.open((Directory)rAMDirectory);
                IndexSearcher indexSearcher = new IndexSearcher((IndexReader)directoryReader);
                indexSearcher.search(query, new Collector(){

                    public void setScorer(Scorer scorer) {
                    }

                    public boolean acceptsDocsOutOfOrder() {
                        return true;
                    }

                    public void collect(int n) {
                        arrayList.add(n);
                    }

                    public void setNextReader(AtomicReaderContext atomicReaderContext) throws IOException {
                    }
                });
                directoryReader.close();
            }
            catch (Exception exception) {
                arrayList.clear();
                for (int i = this._documentProvider.getDocumentCount() - 1; i >= 0; --i) {
                    arrayList.add(i);
                }
            }
        }
        return arrayList;
    }

    public void createQuery(String string, String string2) {
        QueryParser queryParser = new QueryParser(string2, (Analyzer)new StandardAnalyzer()){

            protected Query newRangeQuery(String string, String string2, String string3, boolean bl, boolean bl2) {
                return super.newRangeQuery(string, string2, string3, LuceneSupport.this.isRangeQueryInclusive(), LuceneSupport.this.isRangeQueryInclusive());
            }
        };
        queryParser.setAllowLeadingWildcard(this.isAllowLeadingWildcard());
        try {
            this._query = queryParser.parse(string);
        }
        catch (ParseException parseException) {
            this._query = null;
        }
    }

    public void clearQuery() {
        this._query = null;
    }

    public Query getQuery() {
        return this._query;
    }

    private synchronized void setIndexing(boolean bl) {
        this._indexing = bl;
    }

    public synchronized boolean isIndexing() {
        return this._indexing;
    }

    private void setNeedReindex(boolean bl) {
        this._needReindex = bl;
    }

    private boolean isNeedReindex() {
        return this._needReindex;
    }

    private void setReindexStartRow(int n) {
        this._reindexStartRow = n == -1 || this._reindexStartRow == -1 ? n : Math.min(this._reindexStartRow, n);
    }

    private void setReindexEndRow(int n) {
        this._reindexEndRow = n == -1 || this._reindexEndRow == -1 ? n : Math.max(this._reindexEndRow, n);
    }

    public int getBooleanQueryMaxClauseCount() {
        return this._booleanQueryMaxClauseCount;
    }

    public void setBooleanQueryMaxClauseCount(int n) {
        this._booleanQueryMaxClauseCount = n;
        BooleanQuery.setMaxClauseCount((int)this._booleanQueryMaxClauseCount);
    }

    public boolean isRangeQueryInclusive() {
        return this._rangeQueryInclusive;
    }

    public void setRangeQueryInclusive(boolean bl) {
        this._rangeQueryInclusive = bl;
    }

    public boolean isAllowLeadingWildcard() {
        return this._allowLeadingWildcard;
    }

    public void setAllowLeadingWildcard(boolean bl) {
        this._allowLeadingWildcard = bl;
    }
}

