/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.list.ListPopupMenuCustomizer;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class ListPopupMenuInstaller
extends MouseAdapter {
    private JList _list;
    public static final String CLIENT_PROPERTY_POPUP_MENU_INSTALLER = "ListPopupMenuInstaller";
    List<ListPopupMenuCustomizer> _customizers;

    public ListPopupMenuInstaller(JList jList) {
        this._list = jList;
        this.installListeners();
    }

    public void addListPopupMenuCustomizer(ListPopupMenuCustomizer listPopupMenuCustomizer) {
        if (this._customizers == null) {
            this._customizers = new ArrayList<ListPopupMenuCustomizer>();
        }
        this._customizers.add(listPopupMenuCustomizer);
    }

    public void removeListPopupMenuCustomizer(ListPopupMenuCustomizer listPopupMenuCustomizer) {
        if (this._customizers != null) {
            this._customizers.remove(listPopupMenuCustomizer);
        }
    }

    public ListPopupMenuCustomizer[] getListPopupMenuCustomizers() {
        return this._customizers != null ? this._customizers.toArray(new ListPopupMenuCustomizer[this._customizers.size()]) : new ListPopupMenuCustomizer[]{};
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        if (!(mouseEvent.getComponent() instanceof JList)) {
            return;
        }
        JList jList = (JList)mouseEvent.getComponent();
        JPopupMenu jPopupMenu = this.createPopupMenu();
        int[] nArray = this.getTargetListItems(jList, mouseEvent.getPoint());
        this.customizeMenuItems(jList, jPopupMenu, nArray);
        if (jPopupMenu.getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jPopupMenu, jList, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    protected void customizeMenuItems(JList jList, JPopupMenu jPopupMenu, int[] nArray) {
        ListPopupMenuCustomizer[] listPopupMenuCustomizerArray;
        for (ListPopupMenuCustomizer listPopupMenuCustomizer : listPopupMenuCustomizerArray = this.getListPopupMenuCustomizers()) {
            TableHeaderPopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            listPopupMenuCustomizer.customizePopupMenu(jList, jPopupMenu, nArray);
        }
    }

    public void installListeners() {
        if (this._list != null) {
            this._list.addMouseListener(this);
        }
        this.updateClientProperty(this._list, this);
    }

    public void uninstallListeners() {
        if (this._list != null) {
            this._list.removeMouseListener(this);
        }
        this.updateClientProperty(this._list, null);
    }

    public static ListPopupMenuInstaller getListPopupMenuInstaller(JList jList) {
        Object object = jList.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
        if (object instanceof ListPopupMenuInstaller) {
            return (ListPopupMenuInstaller)object;
        }
        return null;
    }

    private void updateClientProperty(JList jList, ListPopupMenuInstaller listPopupMenuInstaller) {
        if (jList != null) {
            Object object = jList.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
            if (object instanceof ListPopupMenuInstaller && object != this) {
                ((ListPopupMenuInstaller)object).uninstallListeners();
            }
            jList.putClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER, listPopupMenuInstaller);
        }
    }

    protected int[] getTargetListItems(JList jList, Point point) {
        return jList.getSelectedIndices();
    }

    public static void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n = jPopupMenu.getComponentCount();
        if (n > 0 && !(jPopupMenu.getComponent(n - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }
}

