/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.filter.Filter;
import com.jidesoft.list.CompoundListDataEvent;
import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.FilterableListModelEvent;
import com.jidesoft.list.FilterableListModelListener;
import com.jidesoft.list.ListFilter;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;

public class FilterableListModel<E>
extends DefaultListModelWrapper<E> {
    protected List<Filter<E>> _filters = new ArrayList<Filter<E>>();
    protected boolean _filtersApplied = false;
    private boolean _andMode = true;
    private boolean _isAdjusting = false;
    private static final long serialVersionUID = -5811671171150616639L;

    public FilterableListModel() {
    }

    public FilterableListModel(ListModel<E> listModel) {
        super(listModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        super.intervalAdded(listDataEvent);
        if (this.isAdjusting()) {
            return;
        }
        int n = this.fireIndexChanging();
        try {
            int n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n3 = listDataEvent.getIndex1() - listDataEvent.getIndex0() + 1;
            if (this.isFiltersApplied() && this.hasFilter()) {
                List<Filter<E>> list = this._filters;
                for (n2 = listDataEvent.getIndex0(); n2 <= listDataEvent.getIndex1(); ++n2) {
                    boolean bl = this.shouldBeFiltered((E)n2, list);
                    if (bl) continue;
                    arrayList.add(n2);
                }
            } else {
                for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                    arrayList.add(i);
                }
            }
            int n4 = 0;
            n2 = this.getIndexes().length - 1;
            while (n2 >= 0) {
                if (this.getIndexes()[n2] < listDataEvent.getIndex0()) {
                    n4 = n2 + 1;
                    break;
                }
                int[] nArray = this.getIndexes();
                int n5 = n2--;
                nArray[n5] = nArray[n5] + n3;
            }
            if (arrayList.size() != 0) {
                this.insert(n4, arrayList);
            }
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        super.intervalRemoved(listDataEvent);
        if (this.isAdjusting()) {
            return;
        }
        int n = this.fireIndexChanging();
        try {
            int n2;
            int n3;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n4 = listDataEvent.getIndex1() - listDataEvent.getIndex0() + 1;
            if (this.isFiltersApplied() && this.hasFilter()) {
                for (n3 = listDataEvent.getIndex0(); n3 <= listDataEvent.getIndex1(); ++n3) {
                    n2 = this.getIndexAt(n3);
                    if (n2 == -1) continue;
                    arrayList.add(n3);
                }
            } else {
                for (n3 = listDataEvent.getIndex0(); n3 <= listDataEvent.getIndex1(); ++n3) {
                    arrayList.add(n3);
                }
            }
            n3 = 0;
            for (n2 = this.getIndexes().length - 1; n2 >= 0; --n2) {
                if (this.getIndexes()[n2] < listDataEvent.getIndex0()) {
                    n3 = n2 + 1;
                    break;
                }
                if (this.getIndexes()[n2] <= listDataEvent.getIndex1()) continue;
                int[] nArray = this.getIndexes();
                int n5 = n2;
                nArray[n5] = nArray[n5] - n4;
            }
            if (arrayList.size() != 0) {
                this.remove(n3, arrayList);
            }
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        super.contentsChanged(listDataEvent);
        if (this.isAdjusting()) {
            return;
        }
        if (listDataEvent.getIndex0() != listDataEvent.getIndex1()) {
            this.filter();
            return;
        }
        int n = this.fireIndexChanging();
        try {
            int n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            if (this.isFiltersApplied() && this.hasFilter()) {
                List<Filter<E>> list = this._filters;
                for (n2 = listDataEvent.getIndex0(); n2 <= listDataEvent.getIndex1(); ++n2) {
                    boolean bl = this.getIndexAt(n2) != -1;
                    boolean bl2 = this.shouldBeFiltered((E)n2, list);
                    if (bl2 && bl) {
                        arrayList3.add(n2);
                        continue;
                    }
                    if (!bl2 && !bl) {
                        arrayList2.add(n2);
                        continue;
                    }
                    if (bl2 || !bl) continue;
                    arrayList.add(n2);
                }
            } else {
                this.reallocateIndexes();
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, listDataEvent.getIndex0(), listDataEvent.getIndex1()));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
                return;
            }
            int n3 = 0;
            for (n2 = this.getIndexes().length - 1; n2 >= 0; --n2) {
                if (this.getIndexes()[n2] >= listDataEvent.getIndex0()) continue;
                n3 = n2 + 1;
                break;
            }
            if (arrayList3.size() != 0) {
                this.remove(n3, arrayList3);
            }
            if (arrayList2.size() != 0) {
                this.insert(n3, arrayList2);
            }
            if (arrayList.size() != 0) {
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, n3, n3 + arrayList.size() - 1));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
            }
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    public void refresh() {
        this.filter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void filter() {
        int n = this.fireIndexChanging();
        try {
            int n2;
            Object object;
            int n3 = this.getActualModel().getSize();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (this.isFiltersApplied() && this.hasFilter()) {
                object = this._filters;
                for (n2 = 0; n2 < n3; ++n2) {
                    boolean bl = this.shouldBeFiltered((E)n2, (List<Filter<E>>)object);
                    if (bl) continue;
                    arrayList.add(n2);
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    arrayList.add(i);
                }
            }
            object = this.getIndexes();
            this.setIndexes(new int[arrayList.size()]);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                Integer n4 = (Integer)arrayList.get(n2);
                this.getIndexes()[n2] = n4;
            }
            this.fireEvents((int[])object, this.getIndexes(), true);
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    protected boolean shouldBeFiltered(int n, List<Filter<E>> list) {
        boolean bl = false;
        if (this.isFiltersApplied() && this.hasFilter()) {
            if (n >= this.getActualModel().getSize() || n < 0) {
                return bl;
            }
            if (list != null) {
                for (Filter<E> filter : list) {
                    if (!filter.isEnabled() || !(filter instanceof ListFilter)) continue;
                    ((ListFilter)filter).setRowIndex(n);
                }
            }
            Iterator<Filter<E>> iterator = this.getActualModel().getElementAt(n);
            bl = this.shouldBeFiltered(iterator, list);
        }
        return bl;
    }

    public boolean shouldBeFiltered(E e, List<Filter<E>> list) {
        boolean bl = false;
        if (list != null) {
            if (this.isAndMode()) {
                for (Filter<E> filter : list) {
                    if (!filter.isEnabled() || !filter.isValueFiltered(e)) continue;
                    bl = true;
                    break;
                }
            } else {
                boolean bl2 = false;
                for (Filter<E> filter : list) {
                    if (!filter.isEnabled() || filter.isValueFiltered(e)) continue;
                    bl2 = true;
                    break;
                }
                if (list.size() > 0 && !bl2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void addFilterableListModelListener(FilterableListModelListener filterableListModelListener) {
        this.listenerList.add(FilterableListModelListener.class, filterableListModelListener);
    }

    public void removeFilterableListModelListener(FilterableListModelListener filterableListModelListener) {
        this.listenerList.remove(FilterableListModelListener.class, filterableListModelListener);
    }

    public FilterableListModelListener[] getFilterableTableModelListeners() {
        return (FilterableListModelListener[])this.listenerList.getListeners(FilterableListModelListener.class);
    }

    public void fireFilterChanged(FilterableListModelEvent filterableListModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FilterableListModelListener.class) continue;
            ((FilterableListModelListener)objectArray[i + 1]).filterableListModelChanged(filterableListModelEvent);
        }
    }

    public void addFilters(List<Filter<E>> list) {
        for (Filter<E> filter : list) {
            this.addFilter(filter);
        }
    }

    public void addFilter(Filter<E> filter) {
        this._filters.add(filter);
        this.fireFilterChanged(new FilterableListModelEvent(this, 7199, filter));
    }

    public void removeFilter(Filter filter) {
        this._filters.remove(filter);
        this.fireFilterChanged(new FilterableListModelEvent(this, 7200, filter));
    }

    public void clearFilters() {
        for (Filter<E> filter : this._filters) {
            this.fireFilterChanged(new FilterableListModelEvent(this, 7200, filter));
        }
        this._filters.clear();
    }

    public Filter<E>[] getFilters() {
        List<Filter<E>> list = this.internalGetFilters();
        if (list != null) {
            return list.toArray(new Filter[list.size()]);
        }
        return new Filter[0];
    }

    private List<Filter<E>> internalGetFilters() {
        return this._filters;
    }

    public void setFiltersApplied(boolean bl) {
        this._filtersApplied = bl;
        this.filter();
    }

    public boolean isFiltersApplied() {
        return this._filtersApplied;
    }

    public boolean hasFilter() {
        return this._filters != null && !this._filters.isEmpty();
    }

    public boolean isAndMode() {
        return this._andMode;
    }

    public void setAndMode(boolean bl) {
        this._andMode = bl;
    }

    private void insert(int n, List<Integer> list) {
        int[] nArray = (int[])this.getIndexes().clone();
        this.setIndexes(new int[nArray.length + list.size()]);
        System.arraycopy(nArray, 0, this.getIndexes(), 0, n);
        for (int i = 0; i < list.size(); ++i) {
            Integer n2 = list.get(i);
            this.getIndexes()[n + i] = n2;
        }
        System.arraycopy(nArray, n, this.getIndexes(), n + list.size(), this.getIndexes().length - n - list.size());
        CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
        compoundListDataEvent.addEvent(new ListDataEvent(this, 1, n, n + list.size() - 1));
        CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
    }

    private void remove(int n, List<Integer> list) {
        int n2 = list.size();
        int[] nArray = (int[])this.getIndexes().clone();
        this.setIndexes(new int[nArray.length - n2]);
        System.arraycopy(nArray, 0, this.getIndexes(), 0, n);
        System.arraycopy(nArray, n + n2, this.getIndexes(), n, this.getIndexes().length - n);
        CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
        compoundListDataEvent.addEvent(new ListDataEvent(this, 2, n, n + n2 - 1));
        CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
    }

    public boolean isAdjusting() {
        return this._isAdjusting;
    }

    public void setAdjusting(boolean bl) {
        if (this._isAdjusting != bl) {
            this._isAdjusting = bl;
            if (!this._isAdjusting) {
                this.filter();
            }
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(FilterableListModel.class.getName(), 4);
        }
    }
}

