/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.ListUndoableSupport;
import com.jidesoft.list.UndoableListDataEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public class DefaultUndoableListModel
extends DefaultListModel
implements ListUndoableSupport {
    private static final long serialVersionUID = 7693569605961906214L;
    private UndoableListDataEvent _event;
    private List<ListDataListener> _listeners;
    private UndoManager _undoManager;
    private UndoableEditSupport _undoableEditSupport;

    public void setElementAt(Object object, int n) {
        if (this._event == null) {
            this.beginCompoundEdit(false);
            if (this._event != null) {
                this._event.addEdit(n, 0, this.getElementAt(n), object);
            }
            super.setElementAt(object, n);
            this.endCompoundEdit();
        } else {
            this._event.addEdit(n, 0, this.getElementAt(n), object);
            super.setElementAt(object, n);
        }
    }

    @Override
    public void removeElementAt(int n) {
        if (this._event == null) {
            this.beginCompoundEdit(false);
            if (this._event != null) {
                this._event.addEdit(n, 2, this.getElementAt(n), null);
            }
            super.removeElementAt(n);
            this.endCompoundEdit();
        } else {
            this._event.addEdit(n, 2, this.getElementAt(n), null);
            super.removeElementAt(n);
        }
    }

    public void insertElementAt(Object object, int n) {
        if (this._event == null) {
            this.beginCompoundEdit(false);
            if (this._event != null) {
                this._event.addEdit(n, 1, null, object);
            }
            super.insertElementAt(object, n);
            this.endCompoundEdit();
        } else {
            this._event.addEdit(n, 1, null, object);
            super.insertElementAt(object, n);
        }
    }

    public void addElement(Object object) {
        this.insertElementAt(object, this.getSize());
    }

    @Override
    public boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n < 0 || n >= this.getSize()) {
            return false;
        }
        this.removeElementAt(n);
        return true;
    }

    @Override
    public void removeAllElements() {
        if (this._event == null) {
            this.beginCompoundEdit(false);
            if (this._event != null) {
                for (int i = this.getSize() - 1; i >= 0; --i) {
                    this._event.addEdit(i, 2, this.getElementAt(i), null);
                }
            }
            super.removeAllElements();
            this.endCompoundEdit();
        } else {
            for (int i = this.getSize() - 1; i >= 0; --i) {
                this._event.addEdit(i, 2, this.getElementAt(i), null);
            }
            super.removeAllElements();
        }
    }

    public Object set(int n, Object object) {
        Object object2;
        if (this._event == null) {
            this.beginCompoundEdit(false);
            if (this._event != null) {
                this._event.addEdit(n, 0, this.getElementAt(n), object);
            }
            object2 = super.set(n, object);
            this.endCompoundEdit();
        } else {
            this._event.addEdit(n, 0, this.getElementAt(n), object);
            object2 = super.set(n, object);
        }
        return object2;
    }

    public void add(int n, Object object) {
        this.insertElementAt(object, n);
    }

    public Object remove(int n) {
        Object e;
        if (this._event == null) {
            this.beginCompoundEdit(false);
            if (this._event != null) {
                this._event.addEdit(n, 2, this.getElementAt(n), null);
            }
            e = super.remove(n);
            this.endCompoundEdit();
        } else {
            this._event.addEdit(n, 2, this.getElementAt(n), null);
            e = super.remove(n);
        }
        return e;
    }

    @Override
    public void clear() {
        if (this._event == null) {
            this.beginCompoundEdit(false);
            if (this._event != null) {
                for (int i = this.getSize() - 1; i >= 0; --i) {
                    this._event.addEdit(i, 2, this.getElementAt(i), null);
                }
            }
            super.clear();
            this.endCompoundEdit();
        } else {
            for (int i = this.getSize() - 1; i >= 0; --i) {
                this._event.addEdit(i, 2, this.getElementAt(i), null);
            }
            super.clear();
        }
    }

    @Override
    public void removeRange(int n, int n2) {
        if (this._event == null) {
            this.beginCompoundEdit(false);
            if (this._event != null) {
                for (int i = n2; i >= n; --i) {
                    this._event.addEdit(i, 2, this.getElementAt(i), null);
                }
            }
            super.removeRange(n, n2);
            this.endCompoundEdit();
        } else {
            for (int i = n2; i >= n; --i) {
                this._event.addEdit(i, 2, this.getElementAt(i), null);
            }
            super.removeRange(n, n2);
        }
    }

    @Override
    public void undoableInsertElementAt(Object object, int n) {
        if (this._event != null) {
            this._event.addEdit(n, 1, null, object);
        }
        super.insertElementAt(object, n);
    }

    @Override
    public void undoableRemoveElementAt(int n) {
        if (this._event != null) {
            this._event.addEdit(n, 2, this.getElementAt(n), null);
        }
        super.removeElementAt(n);
    }

    @Override
    public void undoableSetElementAt(Object object, int n) {
        if (this._event != null) {
            this._event.addEdit(n, 0, this.getElementAt(n), object);
        }
        super.setElementAt(object, n);
    }

    @Override
    public UndoManager getUndoManager() {
        if (this._undoManager == null) {
            this._undoManager = new UndoManager();
        }
        return this._undoManager;
    }

    @Override
    public UndoableEditSupport getUndoableEditSupport() {
        if (this._undoableEditSupport == null) {
            this._undoableEditSupport = new UndoableEditSupport();
        }
        return this._undoableEditSupport;
    }

    @Override
    public void beginCompoundEdit(boolean bl) {
        if (this._event == null) {
            this._listeners = Arrays.asList(this.getListDataListeners());
            for (ListDataListener listDataListener : this._listeners) {
                this.removeListDataListener(listDataListener);
            }
            this._event = new UndoableListDataEvent(this, 0, 0, this.getSize() - 1);
            this._event.setUndoRedo(bl);
        }
    }

    @Override
    public void endCompoundEdit() {
        if (this._listeners != null) {
            for (ListDataListener listDataListener : this._listeners) {
                this.addListDataListener(listDataListener);
            }
            this._listeners = null;
        }
        if (this._event != null) {
            UndoableListDataEvent.fireListDataEvent(this, this._event);
            this._event = null;
        }
    }

    @Override
    public void fireListDataEvent(ListDataEvent listDataEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent.getType() == 1) {
                ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
                continue;
            }
            if (listDataEvent.getType() == 2) {
                ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
                continue;
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }
}

