/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.paging.PageNavigationEvent;
import com.jidesoft.paging.PageNavigationListener;
import com.jidesoft.paging.PageNavigationSupport;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class AbstractPageListModel
extends AbstractListModel
implements PageNavigationSupport,
ListDataListener {
    private static final long serialVersionUID = -8917413881021037554L;
    private int _pageSize = 10;
    private int _currentPage = -1;
    private int _pageCount;
    private static final Logger LOGGER_EVENT;
    private transient int _startRowIndex = -1;
    private transient boolean _saveRowIndex = true;

    public AbstractPageListModel() {
    }

    public AbstractPageListModel(int n) {
        this._pageSize = n;
    }

    @Override
    public int getPageSize() {
        return this._pageSize == 0 ? 10 : this._pageSize;
    }

    @Override
    public void setPageSize(int n) {
        int n2;
        if (n == 0) {
            n = 10;
        }
        if ((n2 = this._pageSize) != n) {
            this._pageSize = n;
            this.pageSizeChanged(n2, this._pageSize);
            this.firePageNavigationEvent(this, 14100, n2, this._pageSize);
        }
    }

    @Override
    public int getCurrentPage() {
        return this._currentPage;
    }

    @Override
    public void setCurrentPage(int n) {
        this.setCurrentPage(n, false);
    }

    void setCurrentPage(int n, boolean bl) {
        int n2 = this._currentPage;
        if (bl || n2 != n && (this.getPageCount() < 0 || n <= this.getPageCount() - 1) && n >= 0) {
            this._currentPage = n;
            this.pageIndexChanged(n2, this._currentPage);
            this.firePageNavigationEvent(this, 14101, n2, this._currentPage);
            if (this._saveRowIndex) {
                this.saveRowIndex();
            }
        }
    }

    private void saveRowIndex() {
        this._startRowIndex = this.getPageSize() > 0 ? this.getCurrentPage() * this.getPageSize() : 0;
    }

    protected void setPageCount(int n) {
        int n2 = this._pageCount;
        if (n2 != n) {
            this._pageCount = n;
            this.pageCountChanged(n2, this._pageCount);
            this.firePageNavigationEvent(this, 14099, n2, this._pageCount);
        }
    }

    @Override
    public int getPageCount() {
        return this._pageCount;
    }

    @Override
    public void nextPage() {
        int n = this.getCurrentPage();
        if (n < this.getPageCount() - 1) {
            this.setCurrentPage(n + 1);
        }
    }

    @Override
    public void previousPage() {
        int n = this.getCurrentPage();
        if (n > 0) {
            this.setCurrentPage(n - 1);
        }
    }

    @Override
    public void firstPage() {
        if (this.getCurrentPage() > 0) {
            this.setCurrentPage(0);
        }
    }

    @Override
    public void lastPage() {
        int n = this.getPageCount();
        if (this.getCurrentPage() < n - 1) {
            this.setCurrentPage(n - 1);
        }
    }

    @Override
    public void addPageNavigationListener(PageNavigationListener pageNavigationListener) {
        this.listenerList.add(PageNavigationListener.class, pageNavigationListener);
    }

    @Override
    public void removePageNavigationListener(PageNavigationListener pageNavigationListener) {
        this.listenerList.remove(PageNavigationListener.class, pageNavigationListener);
    }

    @Override
    public PageNavigationListener[] getPageNavigationListeners() {
        return (PageNavigationListener[])this.listenerList.getListeners(PageNavigationListener.class);
    }

    @Override
    public void firePageNavigationEvent(Object object, int n, int n2, int n3) {
        if (object == null) {
            object = this;
        }
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 14099: {
                    LOGGER_EVENT.fine("Total page count is changed from " + n2 + " => " + n3 + ", source is " + object.getClass().getName());
                    break;
                }
                case 14100: {
                    LOGGER_EVENT.fine("Page size is changed from " + n2 + " => " + n3 + ", source is " + object.getClass().getName());
                    break;
                }
                case 14101: {
                    LOGGER_EVENT.fine("The current page index is changed from " + n2 + " => " + n3 + ", source is " + object.getClass().getName());
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        PageNavigationEvent pageNavigationEvent = new PageNavigationEvent(object, n, n2, n3);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PageNavigationListener.class) continue;
            ((PageNavigationListener)objectArray[i + 1]).pageNavigationEventFired(pageNavigationEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pageSizeChanged(int n, int n2) {
        int n3 = this.getCurrentPage();
        int n4 = this.getTotalRecordCount();
        if (n4 >= 0) {
            this.setPageCount(n4 / n2 + (n4 % n2 == 0 ? 0 : 1));
        } else {
            this.setPageCount(-1);
        }
        this._saveRowIndex = false;
        try {
            if (this._startRowIndex > 0) {
                this.setCurrentPage(this._startRowIndex / n2);
            } else {
                this.setCurrentPage(0);
            }
        }
        finally {
            this._saveRowIndex = true;
        }
        int n5 = this.getCurrentPage();
        if (n5 == n3) {
            this.pageIndexChanged(n3, n5);
        }
    }

    abstract void pageCountChanged(int var1, int var2);

    abstract void pageIndexChanged(int var1, int var2);

    @Override
    public synchronized int getSize() {
        int n = this.getCurrentPage();
        int n2 = this.getTotalRecordCount();
        if (n2 >= 0 && n2 <= this.getPageSize()) {
            return n2;
        }
        if (this.getPageCount() >= 0 && n == this.getPageCount() - 1) {
            return n2 - n * this.getPageSize();
        }
        return this.getPageSize();
    }

    private int[] getOverlapRows(int n, int n2) {
        int n3;
        int n4 = this.getCurrentPage();
        int n5 = n4 * (n3 = this.getPageSize());
        if (n2 < n5) {
            return null;
        }
        int n6 = Math.min(this.getTotalRecordCount() - 1, n5 + n3);
        if (n > n6) {
            return null;
        }
        return new int[]{Math.max(n, n5) % n3, Math.min(n2, n6) % n3};
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireIntervalAdded(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireIntervalRemoved(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        int[] nArray = this.getOverlapRows(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        if (nArray != null) {
            this.fireContentsChanged(this, nArray[0], nArray[1]);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2048)) {
            Lm.showInvalidProductMessage(AbstractPageListModel.class.getName(), 2048);
        }
        LOGGER_EVENT = Logger.getLogger(PageNavigationEvent.class.getName());
    }
}

