/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DefaultMultiTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.grid.TableCustomizer;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class TableSplitPane
extends JideSplitPane {
    protected MultiTableModel _originalTableModel;
    protected MultiTableModel _originalFooterTableModel;
    protected MultiTableModel _originalHeaderTableModel;
    protected TableScrollPane[] _tableScrollPanes;
    private TableCustomizer _tableCustomizer;
    public static final String TABLE_INDEX = "TableSplitPane.index";
    public static final String TABLESPLITPANE_KEY = "TableSplitPane.Parent";

    public TableSplitPane() {
        this(new DefaultMultiTableModel(), null, false);
    }

    public TableSplitPane(MultiTableModel multiTableModel) {
        this(multiTableModel, null, false);
    }

    public TableSplitPane(MultiTableModel multiTableModel, boolean bl) {
        this(multiTableModel, null, bl);
    }

    public TableSplitPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2) {
        this(multiTableModel, multiTableModel2, false);
    }

    public TableSplitPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, boolean bl) {
        this.createTables(multiTableModel, null, multiTableModel2, bl);
    }

    public TableSplitPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3, boolean bl) {
        this.createTables(multiTableModel, multiTableModel2, multiTableModel3, bl);
    }

    protected MultiTableModel createSortableTableModel(MultiTableModel sortableTreeTableModel, boolean bl) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(sortableTreeTableModel, IExpandableTreeTableModel.class);
        SortableTableModel sortableTableModel = tableModel instanceof IExpandableTreeTableModel && bl ? (sortableTreeTableModel instanceof SortableTreeTableModel ? sortableTreeTableModel : new SortableTreeTableModel(sortableTreeTableModel)) : (!(sortableTreeTableModel instanceof ISortableTableModel) && bl ? new SortableTableModel(sortableTreeTableModel) : sortableTreeTableModel);
        return sortableTableModel;
    }

    public void setTableModels(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, boolean bl) {
        this.removeAll();
        this._tableScrollPanes = null;
        this.createTables(multiTableModel, null, multiTableModel2, bl);
    }

    public void setTableModels(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3, boolean bl) {
        this.removeAll();
        this._tableScrollPanes = null;
        this.createTables(multiTableModel, multiTableModel2, multiTableModel3, bl);
    }

    private void createTables(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3, boolean bl) {
        JTable[][] jTableArray;
        JTable[] jTableArray2;
        JTable[] jTableArray3;
        if (multiTableModel == null) {
            return;
        }
        this._originalTableModel = multiTableModel;
        this._originalFooterTableModel = multiTableModel3;
        this._originalHeaderTableModel = multiTableModel2;
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this._originalTableModel.getColumnCount(); ++i) {
            int n = this._originalTableModel.getTableIndex(i);
            if (vector.contains(new Integer(n))) continue;
            vector.add(n);
        }
        Collections.sort(vector);
        this._tableScrollPanes = new TableScrollPane[vector.size()];
        MultiTableModel multiTableModel4 = this._originalTableModel == null ? null : this.createSortableTableModel(this._originalTableModel, bl);
        MultiTableModel multiTableModel5 = this._originalFooterTableModel == null ? null : this.createSortableTableModel(this._originalFooterTableModel, bl);
        MultiTableModel multiTableModel6 = this._originalHeaderTableModel == null ? null : this.createSortableTableModel(this._originalHeaderTableModel, bl);
        for (int i = 0; i < vector.size(); ++i) {
            this._tableScrollPanes[i] = this.createTableScrollPane(multiTableModel4, multiTableModel6, multiTableModel5, i, bl);
            jTableArray3 = new JTable[]{this._tableScrollPanes[i].getRowHeaderColumnHeaderTable(), this._tableScrollPanes[i].getColumnHeaderTable(), this._tableScrollPanes[i].getRowFooterColumnHeaderTable()};
            jTableArray2 = new JTable[]{this._tableScrollPanes[i].getRowHeaderTable(), this._tableScrollPanes[i].getMainTable(), this._tableScrollPanes[i].getRowFooterTable()};
            JTable[] jTableArray4 = new JTable[]{this._tableScrollPanes[i].getRowHeaderColumnFooterTable(), this._tableScrollPanes[i].getColumnFooterTable(), this._tableScrollPanes[i].getRowFooterColumnFooterTable()};
            jTableArray = new JTable[][]{jTableArray3, jTableArray2, jTableArray4};
            TableUtils.unsynchronizeNavigationKeys(jTableArray);
            this._tableScrollPanes[i].setHorizontalScrollBarPolicy(32);
            this.addPane(this._tableScrollPanes[i]);
        }
        JTable[] jTableArray5 = new JTable[vector.size() * 3];
        jTableArray3 = new JTable[vector.size() * 3];
        jTableArray2 = new JTable[vector.size() * 3];
        for (int i = 0; i < vector.size(); ++i) {
            jTableArray5[i * 3] = this._tableScrollPanes[i].getRowHeaderColumnHeaderTable();
            jTableArray5[i * 3 + 1] = this._tableScrollPanes[i].getColumnHeaderTable();
            jTableArray5[i * 3 + 2] = this._tableScrollPanes[i].getRowFooterColumnHeaderTable();
            jTableArray3[i * 3] = this._tableScrollPanes[i].getRowHeaderTable();
            jTableArray3[i * 3 + 1] = this._tableScrollPanes[i].getMainTable();
            jTableArray3[i * 3 + 2] = this._tableScrollPanes[i].getRowFooterTable();
            jTableArray2[i * 3] = this._tableScrollPanes[i].getRowHeaderColumnFooterTable();
            jTableArray2[i * 3 + 1] = this._tableScrollPanes[i].getColumnFooterTable();
            jTableArray2[i * 3 + 2] = this._tableScrollPanes[i].getRowFooterColumnFooterTable();
        }
        JTable[][] jTableArray6 = new JTable[][]{jTableArray5, jTableArray3, jTableArray2};
        TableUtils.synchronizeNavigationKeys(jTableArray6);
        jTableArray = new Vector();
        Vector<JTable> vector2 = new Vector<JTable>();
        Vector<JTable> vector3 = new Vector<JTable>();
        for (int i = 0; i < this._tableScrollPanes.length; ++i) {
            TableScrollPane jComponent2 = this._tableScrollPanes[i];
            JideSwingUtilities.synchronizeView(this._tableScrollPanes[(i + 1) % this._tableScrollPanes.length].getViewport(), jComponent2.getViewport(), 1);
            JideSwingUtilities.synchronizeView(jComponent2.getViewport(), this._tableScrollPanes[(i + 1) % this._tableScrollPanes.length].getViewport(), 1);
            if (i != this._tableScrollPanes.length - 1) {
                jComponent2.setVerticalScrollBarPolicy(21);
            }
            if (jComponent2.getRowHeaderTable() != null) {
                jTableArray.add(jComponent2.getRowHeaderTable());
            }
            if (jComponent2.getRowHeaderColumnFooterTable() != null) {
                vector2.add(jComponent2.getRowHeaderColumnFooterTable());
            }
            if (jComponent2.getMainTable() != null) {
                jTableArray.add(jComponent2.getMainTable());
                if (i == 0) {
                    vector3.add(jComponent2.getMainTable());
                }
            }
            if (jComponent2.getColumnFooterTable() != null) {
                vector2.add(jComponent2.getColumnFooterTable());
            }
            if (jComponent2.getRowFooterTable() != null) {
                jTableArray.add(jComponent2.getRowFooterTable());
            }
            if (jComponent2.getRowFooterColumnFooterTable() == null) continue;
            vector2.add(jComponent2.getRowFooterColumnFooterTable());
        }
        for (JTable jTable : jTableArray) {
            jTable.putClientProperty(TABLESPLITPANE_KEY, this);
        }
        if (jTableArray.size() > 1) {
            TableUtils.synchronizeTables(jTableArray.toArray(new JTable[jTableArray.size()]));
        }
        if (vector2.size() > 1) {
            TableUtils.synchronizeTables(vector2.toArray(new JTable[vector2.size()]));
        }
        jTableArray.clear();
        for (int i = 0; i < this._tableScrollPanes.length; ++i) {
            TableScrollPane tableScrollPane = this._tableScrollPanes[i];
            if (tableScrollPane.getColumnFooterTable() == null) continue;
            jTableArray.add(tableScrollPane.getColumnFooterTable());
            if (i != 0) continue;
            vector3.add(tableScrollPane.getColumnFooterTable());
        }
        if (jTableArray.size() > 1) {
            TableUtils.synchronizeTables(jTableArray.toArray(new JTable[jTableArray.size()]));
        }
        if (vector3.size() > 1) {
            TableUtils.unifyTableRowSelection(vector3.toArray(new JTable[vector3.size()]));
        }
    }

    public MultiTableModel getOriginalTableModel() {
        return this._originalTableModel;
    }

    public MultiTableModel getOriginalFooterTableModel() {
        return this._originalFooterTableModel;
    }

    protected TableScrollPane createTableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3, final int n, boolean bl) {
        TableScrollPane tableScrollPane = new TableScrollPane(multiTableModel, multiTableModel2, multiTableModel3, bl, n, false){

            @Override
            public TableCustomizer getTableCustomizer() {
                return TableSplitPane.this.getTableCustomizer(n);
            }
        };
        tableScrollPane.putClientProperty(TABLE_INDEX, n);
        return tableScrollPane;
    }

    public TableScrollPane[] getTableScrollPanes() {
        return this._tableScrollPanes;
    }

    public TableCustomizer getTableCustomizer() {
        return this._tableCustomizer;
    }

    public void setTableCustomizer(TableCustomizer tableCustomizer) {
        this._tableCustomizer = tableCustomizer;
    }

    public TableCustomizer getTableCustomizer(int n) {
        return this.getTableCustomizer();
    }

    public int getSelectedRow() {
        int n;
        if (this.getTableScrollPanes().length <= 0) {
            return -1;
        }
        int n2 = 0;
        TableScrollPane tableScrollPane = this.getTableScrollPanes()[0];
        if (tableScrollPane.getMainTable() != null) {
            n = tableScrollPane.getMainTable().getSelectedRow();
            if (n != -1) {
                return n;
            }
            n2 += tableScrollPane.getMainTable().getRowCount();
        }
        if (tableScrollPane.getRowHeaderTable() != null && (n = tableScrollPane.getRowHeaderTable().getSelectedRow()) != -1) {
            return n;
        }
        if (tableScrollPane.getRowFooterTable() != null && (n = tableScrollPane.getRowFooterTable().getSelectedRow()) != -1) {
            return n;
        }
        if (tableScrollPane.getColumnFooterTable() != null && (n = tableScrollPane.getColumnFooterTable().getSelectedRow()) != -1) {
            return n + n2;
        }
        if (tableScrollPane.getRowHeaderColumnFooterTable() != null && (n = tableScrollPane.getRowHeaderColumnFooterTable().getSelectedRow()) != -1) {
            return n + n2;
        }
        if (tableScrollPane.getRowFooterColumnFooterTable() != null && (n = tableScrollPane.getRowFooterColumnFooterTable().getSelectedRow()) != -1) {
            return n + n2;
        }
        return -1;
    }

    public int getSelectedColumn() {
        int n = 0;
        for (TableScrollPane tableScrollPane : this.getTableScrollPanes()) {
            int n2;
            if (tableScrollPane.getRowHeaderTable() != null) {
                n2 = tableScrollPane.getRowHeaderTable().getSelectedColumn();
                if (n2 != -1) {
                    return n2;
                }
                n += tableScrollPane.getRowHeaderTable().getColumnCount();
            }
            if (tableScrollPane.getRowHeaderColumnFooterTable() != null && (n2 = tableScrollPane.getRowHeaderColumnFooterTable().getSelectedColumn()) != -1) {
                return n2;
            }
            if (tableScrollPane.getMainTable() != null) {
                n2 = tableScrollPane.getMainTable().getSelectedColumn();
                if (n2 != -1) {
                    return n + n2;
                }
                n += tableScrollPane.getMainTable().getColumnCount();
            }
            if (tableScrollPane.getColumnFooterTable() != null && (n2 = tableScrollPane.getColumnFooterTable().getSelectedColumn()) != -1) {
                return n2 + n - (tableScrollPane.getMainTable() != null ? tableScrollPane.getMainTable().getColumnCount() : 0);
            }
            if (tableScrollPane.getRowFooterTable() != null && (n2 = tableScrollPane.getRowFooterTable().getSelectedColumn()) != -1) {
                return n + n2;
            }
            if (tableScrollPane.getRowFooterColumnFooterTable() == null || (n2 = tableScrollPane.getRowFooterColumnFooterTable().getSelectedColumn()) == -1) continue;
            return n + n2;
        }
        return -1;
    }

    public int[] getSelectedRows() {
        int n;
        if (this.getTableScrollPanes().length <= 0) {
            return new int[0];
        }
        int n2 = 0;
        TableScrollPane tableScrollPane = this.getTableScrollPanes()[0];
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        int[] nArray3 = new int[]{};
        if (tableScrollPane.getMainTable() != null) {
            nArray = tableScrollPane.getMainTable().getSelectedRows();
            n2 += tableScrollPane.getMainTable().getRowCount();
        }
        if (tableScrollPane.getRowHeaderTable() != null) {
            nArray2 = tableScrollPane.getRowHeaderTable().getSelectedRows();
            if (tableScrollPane.getMainTable() == null) {
                n2 += tableScrollPane.getRowHeaderTable().getRowCount();
            }
        }
        if (tableScrollPane.getRowFooterTable() != null) {
            nArray3 = tableScrollPane.getRowFooterTable().getSelectedRows();
            if (tableScrollPane.getMainTable() == null && tableScrollPane.getRowHeaderTable() == null) {
                n2 += tableScrollPane.getRowFooterTable().getRowCount();
            }
        }
        int[] nArray4 = TableScrollPane.union(nArray, nArray2, nArray3);
        nArray = new int[]{};
        nArray2 = new int[]{};
        nArray3 = new int[]{};
        if (tableScrollPane.getColumnFooterTable() != null) {
            nArray = tableScrollPane.getColumnFooterTable().getSelectedRows();
            n = 0;
            while (n < nArray.length) {
                int n3 = n++;
                nArray[n3] = nArray[n3] + n2;
            }
        }
        if (tableScrollPane.getRowHeaderColumnFooterTable() != null) {
            nArray2 = tableScrollPane.getRowHeaderColumnFooterTable().getSelectedRows();
            n = 0;
            while (n < nArray2.length) {
                int n4 = n++;
                nArray2[n4] = nArray2[n4] + n2;
            }
        }
        if (tableScrollPane.getRowFooterColumnFooterTable() != null) {
            nArray3 = tableScrollPane.getRowFooterColumnFooterTable().getSelectedRows();
            n = 0;
            while (n < nArray3.length) {
                int n5 = n++;
                nArray3[n5] = nArray3[n5] + n2;
            }
        }
        int[] nArray5 = TableScrollPane.union(nArray, nArray2, nArray3);
        return TableScrollPane.concat(nArray4, nArray5);
    }

    public int[] getSelectedColumns() {
        int n = 0;
        int n2 = 0;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (TableScrollPane tableScrollPane : this.getTableScrollPanes()) {
            if (tableScrollPane.getRowHeaderTable() != null) {
                int[] nArray = tableScrollPane.getRowHeaderTable().getSelectedColumns();
                arrayList.add(nArray);
                arrayList2.add(n);
                n += tableScrollPane.getRowHeaderTable().getColumnCount();
                n2 += nArray.length;
            }
            if (tableScrollPane.getMainTable() != null) {
                int[] nArray = tableScrollPane.getMainTable().getSelectedColumns();
                arrayList.add(nArray);
                arrayList2.add(n);
                n += tableScrollPane.getMainTable().getColumnCount();
                n2 += nArray.length;
            }
            if (tableScrollPane.getRowFooterTable() == null) continue;
            int[] nArray = tableScrollPane.getRowFooterTable().getSelectedColumns();
            arrayList.add(nArray);
            arrayList2.add(n);
            n += tableScrollPane.getRowFooterTable().getColumnCount();
            n2 += nArray.length;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        block1: for (int i = 0; i < arrayList.size(); ++i) {
            int[] nArray2 = (int[])arrayList.get(i);
            n = (Integer)arrayList2.get(i);
            for (int n4 : nArray2) {
                if (n3 >= nArray.length) continue block1;
                nArray[n3++] = n4 + n;
            }
        }
        return nArray;
    }

    public int convertColumnIndexToView(int n) {
        if (n < 0 || n >= this._originalTableModel.getColumnCount()) {
            return -1;
        }
        int n2 = this._originalTableModel.getColumnType(n);
        int n3 = this._originalTableModel.getTableIndex(n);
        TableScrollPane[] tableScrollPaneArray = this.getTableScrollPanes();
        if (n3 < 0 || n3 >= tableScrollPaneArray.length) {
            return -1;
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (tableScrollPaneArray[i].getRowHeaderTable() != null) {
                n4 += tableScrollPaneArray[i].getRowHeaderTable().getColumnCount();
            }
            if (tableScrollPaneArray[i].getMainTable() != null) {
                n4 += tableScrollPaneArray[i].getMainTable().getColumnCount();
            }
            if (tableScrollPaneArray[i].getRowFooterTable() == null) continue;
            n4 += tableScrollPaneArray[i].getRowFooterTable().getColumnCount();
        }
        if (tableScrollPaneArray[n3].getRowHeaderTable() != null) {
            if (n2 == 1) {
                return tableScrollPaneArray[n3].getRowHeaderTable().convertColumnIndexToView(n);
            }
            n4 += tableScrollPaneArray[n3].getRowHeaderTable().getColumnCount();
        }
        if (tableScrollPaneArray[n3].getMainTable() != null) {
            if (n2 == 0) {
                return n4 + tableScrollPaneArray[n3].getMainTable().convertColumnIndexToView(n);
            }
            n4 += tableScrollPaneArray[n3].getMainTable().getColumnCount();
        }
        if (tableScrollPaneArray[n3].getRowFooterTable() != null && n2 == 2) {
            return n4 + tableScrollPaneArray[n3].getRowFooterTable().convertColumnIndexToView(n);
        }
        return -1;
    }

    public int getColumnCount() {
        int n = 0;
        for (TableScrollPane tableScrollPane : this.getTableScrollPanes()) {
            if (tableScrollPane.getRowHeaderTable() != null) {
                n += tableScrollPane.getRowHeaderTable().getColumnCount();
            }
            if (tableScrollPane.getMainTable() != null) {
                n += tableScrollPane.getMainTable().getColumnCount();
            }
            if (tableScrollPane.getRowFooterTable() == null) continue;
            n += tableScrollPane.getRowFooterTable().getColumnCount();
        }
        return n;
    }

    public int convertColumnIndexToModel(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            return -1;
        }
        for (TableScrollPane tableScrollPane : this.getTableScrollPanes()) {
            int n2 = tableScrollPane.getColumnCount();
            if (n < n2) {
                if (tableScrollPane.getRowHeaderTable() != null) {
                    n2 = tableScrollPane.getRowHeaderTable().getColumnCount();
                    if (n < n2) {
                        return tableScrollPane.getRowHeaderTable().convertColumnIndexToModel(n);
                    }
                    n -= n2;
                }
                if (tableScrollPane.getMainTable() != null) {
                    n2 = tableScrollPane.getMainTable().getColumnCount();
                    if (n < n2) {
                        return tableScrollPane.getMainTable().convertColumnIndexToModel(n);
                    }
                    n -= n2;
                }
                if (tableScrollPane.getRowFooterTable() == null || n >= (n2 = tableScrollPane.getRowFooterTable().getColumnCount())) break;
                return tableScrollPane.getRowFooterTable().convertColumnIndexToModel(n);
            }
            n -= n2;
        }
        return -1;
    }

    public int getSelectedRowCount() {
        return this.getSelectedRows().length;
    }

    public int getSelectedColumnCount() {
        return this.getSelectedColumns().length;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(TableSplitPane.class.getName(), 4);
        }
    }
}

