/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableScrollPaneSearchable
extends Searchable
implements TableModelListener,
PropertyChangeListener {
    private int[] _searchColumnIndices = new int[]{0};

    public TableScrollPaneSearchable(TableScrollPane tableScrollPane) {
        super(tableScrollPane);
    }

    @Override
    public void installListeners() {
        TableScrollPane tableScrollPane;
        if (this._componentListener == null) {
            this._componentListener = this.createComponentListener();
        }
        this._component.addComponentListener(this._componentListener);
        Component component = JideSwingUtilities.getScrollPane(this._component);
        if (component != null) {
            component.addComponentListener(this._componentListener);
        }
        if (this._keyListener == null) {
            this._keyListener = this.createKeyListener();
        }
        if ((tableScrollPane = (TableScrollPane)this._component).getMainTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getMainTable(), this._keyListener, 0);
        }
        if (tableScrollPane.getRowFooterTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getRowFooterTable(), this._keyListener, 0);
        }
        if (tableScrollPane.getRowHeaderTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getRowHeaderTable(), this._keyListener, 0);
        }
        if (tableScrollPane.getColumnFooterTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getColumnFooterTable(), this._keyListener, 0);
        }
        if (tableScrollPane.getRowHeaderColumnFooterTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getRowHeaderColumnFooterTable(), this._keyListener, 0);
        }
        if (tableScrollPane.getRowFooterColumnFooterTable() != null) {
            JideSwingUtilities.insertKeyListener(tableScrollPane.getRowFooterColumnFooterTable(), this._keyListener, 0);
        }
        if (this._focusListener == null) {
            this._focusListener = this.createFocusListener();
        }
        this.getComponent().addFocusListener(this._focusListener);
        tableScrollPane.getModel().addTableModelListener(this);
        this._component.addPropertyChangeListener("model", this);
    }

    @Override
    public void uninstallListeners() {
        Component component;
        if (this._componentListener != null) {
            this.getComponent().removeComponentListener(this._componentListener);
            component = JideSwingUtilities.getScrollPane(this.getComponent());
            if (component != null) {
                component.removeComponentListener(this._componentListener);
            }
            this._componentListener = null;
        }
        if (this._keyListener != null) {
            component = (TableScrollPane)this._component;
            JideSwingUtilities.insertKeyListener(((TableScrollPane)component).getMainTable(), this._keyListener, 0);
            if (((TableScrollPane)component).getMainTable() != null) {
                ((TableScrollPane)component).getMainTable().removeKeyListener(this._keyListener);
            }
            if (((TableScrollPane)component).getRowHeaderTable() != null) {
                ((TableScrollPane)component).getRowHeaderTable().removeKeyListener(this._keyListener);
            }
            if (((TableScrollPane)component).getRowFooterTable() != null) {
                ((TableScrollPane)component).getRowFooterTable().removeKeyListener(this._keyListener);
            }
            if (((TableScrollPane)component).getColumnFooterTable() != null) {
                ((TableScrollPane)component).getColumnFooterTable().removeKeyListener(this._keyListener);
            }
            if (((TableScrollPane)component).getRowHeaderColumnFooterTable() != null) {
                ((TableScrollPane)component).getRowHeaderColumnFooterTable().removeKeyListener(this._keyListener);
            }
            if (((TableScrollPane)component).getRowFooterColumnFooterTable() != null) {
                ((TableScrollPane)component).getRowFooterColumnFooterTable().removeKeyListener(this._keyListener);
            }
            this._keyListener = null;
        }
        if (this._focusListener != null) {
            this.getComponent().removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
        if (this._component instanceof TableScrollPane) {
            ((TableScrollPane)this._component).getModel().removeTableModelListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    @Override
    protected void setSelectedIndex(int n, boolean bl) {
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            int n2 = n;
            int n3 = this.getMainIndex();
            this.addTableScrollPaneSelection(tableScrollPane, n2, n3, bl);
        } else if (this.isRowSelectionAllowed(tableScrollPane)) {
            int n4 = n;
            int n5 = this.getMainIndex();
            this.addTableScrollPaneSelection(tableScrollPane, n4, n5, bl);
        } else {
            int n6 = n / tableScrollPane.getColumnCount();
            int n7 = n % tableScrollPane.getColumnCount();
            this.addTableScrollPaneSelection(tableScrollPane, n6, n7, bl);
        }
    }

    protected void addTableScrollPaneSelection(TableScrollPane tableScrollPane, int n, int n2, boolean bl) {
        if (!bl) {
            tableScrollPane.clearSelection();
        }
        if (n >= 0 && n2 >= 0 && n < tableScrollPane.getRowCount() && n2 < tableScrollPane.getColumnCount() && !tableScrollPane.isCellSelected(n, n2)) {
            tableScrollPane.changeSelection(n, n2, true, false);
        }
    }

    protected boolean isColumnSelectionAllowed(TableScrollPane tableScrollPane) {
        return this.getSearchColumnIndices().length == 1 && tableScrollPane.getColumnSelectionAllowed() && !tableScrollPane.getRowSelectionAllowed();
    }

    protected boolean isRowSelectionAllowed(TableScrollPane tableScrollPane) {
        return this.getSearchColumnIndices().length == 1 && !tableScrollPane.getColumnSelectionAllowed() && tableScrollPane.getRowSelectionAllowed();
    }

    @Override
    protected int getSelectedIndex() {
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            return tableScrollPane.getSelectedColumn();
        }
        if (this.isRowSelectionAllowed(tableScrollPane)) {
            return tableScrollPane.getSelectedRow();
        }
        return tableScrollPane.getSelectedRow() * tableScrollPane.getColumnCount() + tableScrollPane.getSelectedColumn();
    }

    @Override
    protected Object getElementAt(int n) {
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            return this.getValueAt(tableScrollPane, this.getMainIndex(), n);
        }
        if (this.isRowSelectionAllowed(tableScrollPane)) {
            return this.getValueAt(tableScrollPane, n, this.getMainIndex());
        }
        if (this.getSearchColumnIndices().length > 1) {
            int n2 = n % tableScrollPane.getColumnCount();
            int n3 = tableScrollPane.convertColumnIndexToModel(n2);
            boolean bl = true;
            for (int n4 : this.getSearchColumnIndices()) {
                if (n4 != n3) continue;
                bl = false;
            }
            if (bl) {
                return null;
            }
            int n5 = n / tableScrollPane.getColumnCount();
            return this.getValueAt(tableScrollPane, n5, n2);
        }
        int n6 = n % tableScrollPane.getColumnCount();
        int n7 = n / tableScrollPane.getColumnCount();
        return this.getValueAt(tableScrollPane, n7, n6);
    }

    private Object getValueAt(TableScrollPane tableScrollPane, int n, int n2) {
        if (n >= 0 && n < tableScrollPane.getRowCount() && n2 >= 0 && n2 < tableScrollPane.getColumnCount()) {
            return tableScrollPane.getValueAt(n, n2);
        }
        return null;
    }

    @Override
    protected int getElementCount() {
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            return tableScrollPane.getColumnCount();
        }
        if (this.isRowSelectionAllowed(tableScrollPane)) {
            return tableScrollPane.getRowCount();
        }
        return tableScrollPane.getColumnCount() * tableScrollPane.getRowCount();
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public int[] getSearchColumnIndices() {
        return this._searchColumnIndices;
    }

    public void setSearchColumnIndices(int[] nArray) {
        int[] nArray2;
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (!JideSwingUtilities.equals(nArray2 = this._searchColumnIndices, nArray, true)) {
            this._searchColumnIndices = nArray;
            this.hidePopup();
        }
    }

    public int getMainIndex() {
        if (this._searchColumnIndices.length == 0) {
            return -1;
        }
        return this._searchColumnIndices[0];
    }

    public void setMainIndex(int n) {
        int[] nArray;
        int[] nArray2 = new int[]{n};
        if (n < 0) {
            nArray2 = new int[]{};
        }
        if ((nArray = this._searchColumnIndices) != nArray2) {
            this._searchColumnIndices = nArray2;
            this.hidePopup();
        }
    }

    @Override
    protected boolean isFindNextKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            return n == 39;
        }
        if (this.isRowSelectionAllowed(tableScrollPane)) {
            return n == 40;
        }
        return n == 40 || n == 39;
    }

    @Override
    protected boolean isFindPreviousKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        TableScrollPane tableScrollPane = (TableScrollPane)this._component;
        if (this.isColumnSelectionAllowed(tableScrollPane)) {
            return n == 37;
        }
        if (this.isRowSelectionAllowed(tableScrollPane)) {
            return n == 38;
        }
        return n == 38 || n == 37;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof TableModel) {
                ((TableModel)propertyChangeEvent.getOldValue()).removeTableModelListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof TableModel) {
                ((TableModel)propertyChangeEvent.getNewValue()).addTableModelListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    protected boolean isActivateKey(KeyEvent keyEvent) {
        boolean bl = this.isSelectedCellEditable();
        return !bl && super.isActivateKey(keyEvent);
    }

    protected boolean isSelectedCellEditable() {
        int n = ((TableScrollPane)this._component).getSelectedRow();
        int n2 = ((TableScrollPane)this._component).getSelectedColumn();
        return n != -1 && n2 != -1 && ((TableScrollPane)this._component).isCellEditable(n, n2);
    }
}

