/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TableScrollPane;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.MessageFormat;
import javax.swing.JTable;

public class TableScrollPanePrintable
implements Printable {
    private TableScrollPane _tableScrollPane;
    private int totalColWidth;
    private JTable.PrintMode printMode;
    private MessageFormat headerFormat;
    private MessageFormat footerFormat;
    private int last = -1;
    private int row = 0;
    private int col = 0;
    private final Rectangle clip = new Rectangle(0, 0, 0, 0);
    private final Rectangle hclip = new Rectangle(0, 0, 0, 0);
    private final Rectangle tempRect = new Rectangle(0, 0, 0, 0);
    private static final int H_F_SPACE = 8;
    private static final float HEADER_FONT_SIZE = 18.0f;
    private static final float FOOTER_FONT_SIZE = 12.0f;
    private Font headerFont;
    private Font footerFont;

    public TableScrollPanePrintable(TableScrollPane tableScrollPane, JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) {
        this._tableScrollPane = tableScrollPane;
        this.totalColWidth = this._tableScrollPane.getTotalColumnWidth();
        this.hclip.height = this._tableScrollPane.getHeaderHeight();
        this.printMode = printMode;
        this.headerFormat = messageFormat;
        this.footerFormat = messageFormat2;
        this.headerFont = tableScrollPane.getFont().deriveFont(1, 18.0f);
        this.footerFont = tableScrollPane.getFont().deriveFont(0, 12.0f);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        int n3;
        int n4;
        Rectangle rectangle;
        int n5;
        int n6;
        int n7;
        int n8 = (int)pageFormat.getImageableWidth();
        int n9 = (int)pageFormat.getImageableHeight();
        if (n8 <= 0) {
            throw new PrinterException("Width of printable area is too small.");
        }
        Object[] objectArray = new Object[]{new Integer(n + 1)};
        String string = null;
        if (this.headerFormat != null) {
            string = this.headerFormat.format(objectArray);
        }
        String string2 = null;
        if (this.footerFormat != null) {
            string2 = this.footerFormat.format(objectArray);
        }
        Rectangle2D rectangle2D = null;
        Rectangle2D rectangle2D2 = null;
        int n10 = 0;
        int n11 = 0;
        int n12 = n9;
        if (string != null) {
            graphics.setFont(this.headerFont);
            rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
            n10 = (int)Math.ceil(rectangle2D.getHeight());
            n12 -= n10 + 8;
        }
        if (string2 != null) {
            graphics.setFont(this.footerFont);
            rectangle2D2 = graphics.getFontMetrics().getStringBounds(string2, graphics);
            n11 = (int)Math.ceil(rectangle2D2.getHeight());
            n12 -= n11 + 8;
        }
        if (n12 <= 0) {
            throw new PrinterException("Height of printable area is too small.");
        }
        double d = 1.0;
        if (this.printMode == JTable.PrintMode.FIT_WIDTH && this.totalColWidth > n8) {
            assert (n8 > 0);
            assert (this.totalColWidth > 1);
            d = (double)n8 / (double)this.totalColWidth;
        }
        assert (d > 0.0);
        if (this.last > n) {
            this.last = -1;
            this.row = 0;
            this.col = 0;
            this.clip.setBounds(0, 0, 0, 0);
            this.tempRect.setBounds(0, 0, 0, 0);
        }
        while (this.last < n) {
            if (this.row >= this._tableScrollPane.getRowCount() && this.col == 0) {
                return 1;
            }
            int n13 = (int)((double)n8 / d);
            int n14 = (int)((double)(n12 - this.hclip.height) / d);
            this.findNextClip(n13, n14);
            ++this.last;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        if (string2 != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(0, n9 - n11);
            this.printText(graphics2D, string2, rectangle2D2, this.footerFont, n8);
            graphics2D.setTransform(affineTransform);
        }
        if (string != null) {
            this.printText(graphics2D, string, rectangle2D, this.headerFont, n8);
            graphics2D.translate(0, n10 + 8);
        }
        this.tempRect.x = 0;
        this.tempRect.y = 0;
        this.tempRect.width = n8;
        this.tempRect.height = n12;
        graphics2D.clip(this.tempRect);
        if (d != 1.0) {
            graphics2D.scale(d, d);
        } else {
            int n15 = (n8 - this.clip.width) / 2;
            graphics2D.translate(n15, 0);
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        int n16 = 0;
        if (this.hclip.height > 0) {
            n7 = 0;
            n6 = this.clip.width;
            n5 = 0;
            if (this._tableScrollPane.getRowHeaderTableHeader() != null) {
                if (n5 > 0 || this._tableScrollPane.getRowHeaderTableWidth() - (this.clip.x - n7) > 0) {
                    if (n5 == 0) {
                        this.hclip.width = Math.min(n6, this._tableScrollPane.getRowHeaderTableWidth() - (this.clip.x - n7));
                        graphics2D.translate(n7 - this.clip.x, 0);
                        this.hclip.x = this.clip.x - n7;
                    } else {
                        this.hclip.width = Math.min(n6, this._tableScrollPane.getRowHeaderTableWidth());
                        graphics2D.translate(n5, 0);
                        this.hclip.x = 0;
                    }
                    graphics2D.setClip(this.hclip);
                    this._tableScrollPane.getRowHeaderTableHeader().print(graphics2D);
                    n6 -= this.hclip.width;
                    n5 = this.hclip.width;
                } else {
                    n7 += this._tableScrollPane.getRowHeaderTableWidth();
                }
            }
            if (this._tableScrollPane.getMainTableHeader() != null && n6 > 0) {
                if (n5 > 0 || this._tableScrollPane.getMainTableWidth() - (this.clip.x - n7) > 0) {
                    if (n5 == 0) {
                        this.hclip.width = Math.min(n6, this._tableScrollPane.getMainTableWidth() - (this.clip.x - n7));
                        graphics2D.translate(n7 - this.clip.x, 0);
                        this.hclip.x = this.clip.x - n7;
                    } else {
                        this.hclip.width = Math.min(n6, this._tableScrollPane.getMainTableWidth());
                        graphics2D.translate(n5, 0);
                        this.hclip.x = 0;
                    }
                    graphics2D.setClip(this.hclip);
                    this._tableScrollPane.getMainTableHeader().print(graphics2D);
                    n6 -= this.hclip.width;
                    n5 = this.hclip.width;
                } else {
                    n7 += this._tableScrollPane.getMainTableWidth();
                }
            }
            if (this._tableScrollPane.getRowFooterTableHeader() != null && n6 > 0 && (n5 > 0 || this._tableScrollPane.getRowFooterTableWidth() - (this.clip.x - n7) > 0)) {
                if (n5 == 0) {
                    this.hclip.width = Math.min(n6, this._tableScrollPane.getRowFooterTableWidth() - (this.clip.x - n7));
                    graphics2D.translate(n7 - this.clip.x, 0);
                    this.hclip.x = this.clip.x - n7;
                } else {
                    this.hclip.width = Math.min(n6, this._tableScrollPane.getRowFooterTableWidth());
                    graphics2D.translate(n5, 0);
                    this.hclip.x = 0;
                }
                graphics2D.setClip(this.hclip);
                this._tableScrollPane.getRowFooterTableHeader().print(graphics2D);
                n6 -= this.hclip.width;
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            graphics2D.translate(0, n16 += this.hclip.height);
        }
        n7 = 0;
        n6 = this.clip.height;
        n5 = 0;
        if (this._tableScrollPane.getColumnHeaderTable() != null) {
            if (n5 > 0 || this._tableScrollPane.getColumnHeaderTableHeight() - (this.clip.y - n7) > 0) {
                rectangle = new Rectangle();
                if (n5 == 0) {
                    rectangle.height = Math.min(n6, this._tableScrollPane.getColumnHeaderTableHeight() - (this.clip.y - n7));
                    rectangle.y = this.clip.y - n7;
                } else {
                    rectangle.height = Math.min(n6, this._tableScrollPane.getColumnHeaderTableHeight());
                    rectangle.y = 0;
                }
                n4 = 0;
                n3 = this.clip.width;
                n2 = 0;
                if (n2 > 0 || this._tableScrollPane.getRowHeaderTableWidth() - (this.clip.x - n4) > 0) {
                    if (n2 == 0) {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowHeaderTableWidth() - (this.clip.x - n4));
                        rectangle.x = this.clip.x - n4;
                        if (n5 == 0) {
                            graphics2D.translate(n4 - this.clip.x, n7 - this.clip.y);
                        } else {
                            graphics2D.translate(n4 - this.clip.x, 0);
                        }
                    } else {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowHeaderTableWidth());
                        rectangle.x = 0;
                        graphics2D.translate(n2, 0);
                    }
                    graphics2D.setClip(rectangle);
                    if (this._tableScrollPane.getRowHeaderColumnHeaderTable() != null) {
                        this._tableScrollPane.getRowHeaderColumnHeaderTable().print(graphics2D);
                    }
                    n3 -= rectangle.width;
                    n2 = rectangle.width;
                } else {
                    n4 += this._tableScrollPane.getRowHeaderTableWidth();
                }
                if (n3 > 0 && (n2 > 0 || this._tableScrollPane.getMainTableWidth() - (this.clip.x - n4) > 0)) {
                    if (n2 == 0) {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getMainTableWidth() - (this.clip.x - n4));
                        rectangle.x = this.clip.x - n4;
                        if (n5 == 0) {
                            graphics2D.translate(n4 - this.clip.x, n7 - this.clip.y);
                        } else {
                            graphics2D.translate(n4 - this.clip.x, 0);
                        }
                    } else {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getMainTableWidth());
                        rectangle.x = 0;
                        graphics2D.translate(n2, 0);
                    }
                    graphics2D.setClip(rectangle);
                    if (this._tableScrollPane.getColumnHeaderTable() != null) {
                        this._tableScrollPane.getColumnHeaderTable().print(graphics2D);
                    }
                    n3 -= rectangle.width;
                    n2 = rectangle.width;
                } else {
                    n4 += this._tableScrollPane.getMainTableWidth();
                }
                if (n3 > 0 && (n2 > 0 || this._tableScrollPane.getRowFooterTableWidth() - (this.clip.x - n4) > 0)) {
                    if (n2 == 0) {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowFooterTableWidth() - (this.clip.x - n4));
                        rectangle.x = this.clip.x - n4;
                        if (n5 == 0) {
                            graphics2D.translate(n4 - this.clip.x, n7 - this.clip.y);
                        } else {
                            graphics2D.translate(n4 - this.clip.x, 0);
                        }
                    } else {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowFooterTableWidth());
                        rectangle.x = 0;
                        graphics2D.translate(n2, 0);
                    }
                    graphics2D.setClip(rectangle);
                    if (this._tableScrollPane.getRowFooterColumnHeaderTable() != null) {
                        this._tableScrollPane.getRowFooterColumnHeaderTable().print(graphics2D);
                    }
                    n3 -= rectangle.width;
                } else {
                    n4 += this._tableScrollPane.getRowFooterTableWidth();
                }
                n6 -= rectangle.height;
                n5 = rectangle.height;
                graphics2D.setTransform(affineTransform);
                graphics2D.setClip(shape);
                graphics2D.translate(0, n16 += n5);
            } else {
                n7 += this._tableScrollPane.getColumnHeaderTableHeight();
            }
        }
        if (n6 > 0 && this._tableScrollPane.getMainTable() != null) {
            if (n5 > 0 || this._tableScrollPane.getMainTableHeight() - (this.clip.y - n7) > 0) {
                rectangle = new Rectangle();
                if (n5 == 0) {
                    rectangle.height = Math.min(n6, this._tableScrollPane.getMainTableHeight() - (this.clip.y - n7));
                    rectangle.y = this.clip.y - n7;
                } else {
                    rectangle.height = Math.min(n6, this._tableScrollPane.getMainTableHeight());
                    rectangle.y = 0;
                }
                n4 = 0;
                n3 = this.clip.width;
                n2 = 0;
                if (n2 > 0 || this._tableScrollPane.getRowHeaderTableWidth() - (this.clip.x - n4) > 0) {
                    if (n2 == 0) {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowHeaderTableWidth() - (this.clip.x - n4));
                        rectangle.x = this.clip.x - n4;
                        if (n5 == 0) {
                            graphics2D.translate(n4 - this.clip.x, n7 - this.clip.y);
                        } else {
                            graphics2D.translate(n4 - this.clip.x, 0);
                        }
                    } else {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowHeaderTableWidth());
                        rectangle.x = 0;
                        graphics2D.translate(n2, 0);
                    }
                    graphics2D.setClip(rectangle);
                    if (this._tableScrollPane.getRowHeaderTable() != null) {
                        this._tableScrollPane.getRowHeaderTable().print(graphics2D);
                    }
                    n3 -= rectangle.width;
                    n2 = rectangle.width;
                } else {
                    n4 += this._tableScrollPane.getRowHeaderTableWidth();
                }
                if (n3 > 0 && (n2 > 0 || this._tableScrollPane.getMainTableWidth() - (this.clip.x - n4) > 0)) {
                    if (n2 == 0) {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getMainTableWidth() - (this.clip.x - n4));
                        rectangle.x = this.clip.x - n4;
                        if (n5 == 0) {
                            graphics2D.translate(n4 - this.clip.x, n7 - this.clip.y);
                        } else {
                            graphics2D.translate(n4 - this.clip.x, 0);
                        }
                    } else {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getMainTableWidth());
                        rectangle.x = 0;
                        graphics2D.translate(n2, 0);
                    }
                    graphics2D.setClip(rectangle);
                    if (this._tableScrollPane.getMainTable() != null) {
                        this._tableScrollPane.getMainTable().print(graphics2D);
                    }
                    n3 -= rectangle.width;
                    n2 = rectangle.width;
                } else {
                    n4 += this._tableScrollPane.getMainTableWidth();
                }
                if (n3 > 0 && (n2 > 0 || this._tableScrollPane.getRowFooterTableWidth() - (this.clip.x - n4) > 0)) {
                    if (n2 == 0) {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowFooterTableWidth() - (this.clip.x - n4));
                        rectangle.x = this.clip.x - n4;
                        if (n5 == 0) {
                            graphics2D.translate(n4 - this.clip.x, n7 - this.clip.y);
                        } else {
                            graphics2D.translate(n4 - this.clip.x, 0);
                        }
                    } else {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowFooterTableWidth());
                        rectangle.x = 0;
                        graphics2D.translate(n2, 0);
                    }
                    graphics2D.setClip(rectangle);
                    if (this._tableScrollPane.getRowFooterTable() != null) {
                        this._tableScrollPane.getRowFooterTable().print(graphics2D);
                    }
                    n3 -= rectangle.width;
                } else {
                    n4 += this._tableScrollPane.getRowFooterTableWidth();
                }
                n6 -= rectangle.height;
                n5 = rectangle.height;
                graphics2D.setTransform(affineTransform);
                graphics2D.setClip(shape);
                graphics2D.translate(0, n16 += n5);
            } else {
                n7 += this._tableScrollPane.getMainTableHeight();
            }
        }
        if (n6 > 0 && this._tableScrollPane.getColumnFooterTable() != null && n6 > 0) {
            if (n5 > 0 || this._tableScrollPane.getColumnFooterTableHeight() - (this.clip.y - n7) > 0) {
                rectangle = new Rectangle();
                if (n5 == 0) {
                    rectangle.height = Math.min(n6, this._tableScrollPane.getColumnFooterTableHeight() - (this.clip.y - n7));
                    rectangle.y = this.clip.y - n7;
                } else {
                    rectangle.height = Math.min(n6, this._tableScrollPane.getColumnFooterTableHeight());
                    rectangle.y = 0;
                }
                n4 = 0;
                n3 = this.clip.width;
                n2 = 0;
                if (n2 > 0 || this._tableScrollPane.getRowHeaderTableWidth() - (this.clip.x - n4) > 0) {
                    if (n2 == 0) {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowHeaderTableWidth() - (this.clip.x - n4));
                        rectangle.x = this.clip.x - n4;
                        if (n5 == 0) {
                            graphics2D.translate(n4 - this.clip.x, n7 - this.clip.y);
                        } else {
                            graphics2D.translate(n4 - this.clip.x, 0);
                        }
                    } else {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowHeaderTableWidth());
                        rectangle.x = 0;
                        graphics2D.translate(n2, 0);
                    }
                    graphics2D.setClip(rectangle);
                    if (this._tableScrollPane.getRowHeaderColumnFooterTable() != null) {
                        this._tableScrollPane.getRowHeaderColumnFooterTable().print(graphics2D);
                    }
                    n3 -= rectangle.width;
                    n2 = rectangle.width;
                } else {
                    n4 += this._tableScrollPane.getRowHeaderTableWidth();
                }
                if (n3 > 0 && (n2 > 0 || this._tableScrollPane.getMainTableWidth() - (this.clip.x - n4) > 0)) {
                    if (n2 == 0) {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getMainTableWidth() - (this.clip.x - n4));
                        rectangle.x = this.clip.x - n4;
                        if (n5 == 0) {
                            graphics2D.translate(n4 - this.clip.x, n7 - this.clip.y);
                        } else {
                            graphics2D.translate(n4 - this.clip.x, 0);
                        }
                    } else {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getMainTableWidth());
                        rectangle.x = 0;
                        graphics2D.translate(n2, 0);
                    }
                    graphics2D.setClip(rectangle);
                    if (this._tableScrollPane.getColumnFooterTable() != null) {
                        this._tableScrollPane.getColumnFooterTable().print(graphics2D);
                    }
                    n3 -= rectangle.width;
                    n2 = rectangle.width;
                } else {
                    n4 += this._tableScrollPane.getMainTableWidth();
                }
                if (n3 > 0 && (n2 > 0 || this._tableScrollPane.getRowFooterTableWidth() - (this.clip.x - n4) > 0)) {
                    if (n2 == 0) {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowFooterTableWidth() - (this.clip.x - n4));
                        rectangle.x = this.clip.x - n4;
                        if (n5 == 0) {
                            graphics2D.translate(n4 - this.clip.x, n7 - this.clip.y);
                        } else {
                            graphics2D.translate(n4 - this.clip.x, 0);
                        }
                    } else {
                        rectangle.width = Math.min(n3, this._tableScrollPane.getRowFooterTableWidth());
                        rectangle.x = 0;
                        graphics2D.translate(n2, 0);
                    }
                    graphics2D.setClip(rectangle);
                    if (this._tableScrollPane.getRowFooterColumnFooterTable() != null) {
                        this._tableScrollPane.getRowFooterColumnFooterTable().print(graphics2D);
                    }
                    n3 -= rectangle.width;
                } else {
                    n4 += this._tableScrollPane.getRowFooterTableWidth();
                }
                n6 -= rectangle.height;
                n5 = rectangle.height;
                graphics2D.setTransform(affineTransform);
                graphics2D.setClip(shape);
                graphics2D.translate(0, n16 += n5);
            } else {
                n7 += this._tableScrollPane.getColumnFooterTableHeight();
            }
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, this.clip.width, this.hclip.height + this.clip.height);
        return 0;
    }

    private void printText(Graphics2D graphics2D, String string, Rectangle2D rectangle2D, Font font, int n) {
        int n2 = rectangle2D.getWidth() < (double)n ? (int)(((double)n - rectangle2D.getWidth()) / 2.0) : (this._tableScrollPane.getComponentOrientation().isLeftToRight() ? 0 : -((int)(Math.ceil(rectangle2D.getWidth()) - (double)n)));
        int n3 = (int)Math.ceil(Math.abs(rectangle2D.getY()));
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(font);
        graphics2D.drawString(string, n2, n3);
    }

    private void findNextClip(int n, int n2) {
        int n3;
        int n4;
        boolean bl = this._tableScrollPane.getComponentOrientation().isLeftToRight();
        if (this.col == 0) {
            this.clip.x = bl ? 0 : this.totalColWidth;
            this.clip.y += this.clip.height;
            this.clip.width = 0;
            this.clip.height = 0;
            n4 = this._tableScrollPane.getRowCount();
            n3 = this._tableScrollPane.getRowHeight(this.row);
            do {
                this.clip.height += n3;
            } while (++this.row < n4 && this.clip.height + (n3 = this._tableScrollPane.getRowHeight(this.row)) <= n2);
        }
        if (this.printMode == JTable.PrintMode.FIT_WIDTH) {
            this.clip.x = 0;
            this.clip.width = this.totalColWidth;
            return;
        }
        if (bl) {
            this.clip.x += this.clip.width;
        }
        this.clip.width = 0;
        n4 = this._tableScrollPane.getColumnCount();
        n3 = this._tableScrollPane.getColumnWidth(this.col);
        do {
            this.clip.width += n3;
            if (!bl) {
                this.clip.x -= n3;
            }
            if (++this.col < n4) continue;
            this.col = 0;
            break;
        } while (this.clip.width + (n3 = this._tableScrollPane.getColumnWidth(this.col)) <= n);
    }
}

