/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.TableResizer;
import com.jidesoft.grid.TableUtils;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class TableRowResizer
extends TableResizer {
    public static Cursor _resizeCursor = Cursor.getPredefinedCursor(8);
    private int _mouseYOffset;
    private int _resizingRow = -1;
    private boolean _variousRowHeights = true;
    private Cursor _otherCursor = _resizeCursor;
    private int _newHeight = -1;
    public static final int OFFSET = 3;
    private static final String KEY = "rowResizer";

    public TableRowResizer(JTable jTable) {
        super(jTable);
    }

    @Override
    String getClientProperty() {
        return KEY;
    }

    @Override
    public MouseInputListener createMouseInputListener() {
        return new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                TableRowResizer.this._resizingRow = TableRowResizer.this.getResizingRow(point);
                if (TableRowResizer.this._resizingRow >= 0) {
                    TableRowResizer.this._mouseYOffset = point.y - TableRowResizer.this._table.getRowHeight(TableRowResizer.this._resizingRow);
                    mouseEvent.consume();
                }
                if (TableRowResizer.this._table instanceof JideTable) {
                    TableRowResizer.this._variousRowHeights = ((JideTable)TableRowResizer.this._table).isVariousRowHeightsSet() && ((JideTable)TableRowResizer.this._table).isVariousRowHeights();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!TableRowResizer.this._variousRowHeights && TableRowResizer.this._table instanceof JideTable && TableRowResizer.this._newHeight >= 1) {
                    int n = TableUtils.getViewPositionForRow(TableRowResizer.this._table, TableRowResizer.this._resizingRow);
                    TableRowResizer.this._table.setRowHeight(TableRowResizer.this._newHeight);
                    TableUtils.setViewPositionForRow(TableRowResizer.this._table, TableRowResizer.this._resizingRow, n);
                }
                TableRowResizer.this._newHeight = -1;
                if (TableRowResizer.this._resizingRow != -1) {
                    TableRowResizer.this._resizingRow = -1;
                }
            }

            private void swapCursor() {
                if (TableRowResizer.this._table instanceof JideTable && !((JideTable)TableRowResizer.this._table).isRowResizable() && TableRowResizer.this._otherCursor == TableRowResizer.this._table.getCursor()) {
                    return;
                }
                Cursor cursor = TableRowResizer.this._table.getCursor();
                TableRowResizer.this._table.setCursor(TableRowResizer.this._otherCursor);
                TableRowResizer.this._otherCursor = cursor;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (TableRowResizer.this.getResizingRow(mouseEvent.getPoint()) >= 0 != (TableRowResizer.this._table.getCursor() == _resizeCursor)) {
                    this.swapCursor();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getY();
                if (TableRowResizer.this._resizingRow >= 0) {
                    int n2 = n - TableRowResizer.this._mouseYOffset;
                    if (n2 > 0) {
                        TableRowResizer.this._table.setRowHeight(TableRowResizer.this._resizingRow, n2);
                        TableRowResizer.this._newHeight = n2;
                    }
                    mouseEvent.consume();
                }
            }
        };
    }

    public boolean isResizing() {
        return this._resizingRow >= 0;
    }

    private int getResizingRow(Point point) {
        return this.getResizingRow(point, this._table.rowAtPoint(point));
    }

    private int getResizingRow(Point point, int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = this._table.columnAtPoint(point);
        if (n2 == -1) {
            return -1;
        }
        Rectangle rectangle = this._table.getCellRect(n, n2, true);
        rectangle.grow(0, -3);
        if (rectangle.contains(point)) {
            return -1;
        }
        int n3 = rectangle.y + rectangle.height / 2;
        return point.y < n3 ? n - 1 : n;
    }
}

