/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.JideSwingUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class TableColumnSnapshot {
    private Vector<List<Object>> _snapshot = new Vector();
    private final int MAX_SNAPSHOT = 1000;
    private static final Logger LOGGER_EVENT = Logger.getLogger(TableColumnChooser.class.getName());

    TableColumnSnapshot() {
    }

    TableColumnSnapshot(String string) {
        String[] stringArray = string.split("\t");
        try {
            if (stringArray.length <= 0) {
                return;
            }
            int n = Integer.valueOf(stringArray[0]);
            int n2 = 1;
            if (n == 0) {
                return;
            }
            while (n2 < stringArray.length) {
                int n3;
                int n4 = Integer.valueOf(stringArray[n2]);
                if (n4 == 0) {
                    this._snapshot = new Vector();
                    return;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ++n2;
                for (n3 = 0; n2 < stringArray.length && n3 < n4; ++n2, ++n3) {
                    if (n3 == 0) {
                        arrayList.add("true".equalsIgnoreCase(stringArray[n2]) || "1".equals(stringArray[n2]));
                        continue;
                    }
                    arrayList.add(stringArray[n2]);
                }
                if (n2 >= stringArray.length && n3 < n4) {
                    this._snapshot = new Vector();
                    return;
                }
                this._snapshot.add(arrayList);
                if (this._snapshot.size() < n) continue;
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public List<Object> constructNewShot(JTable jTable, boolean bl) {
        Object object;
        int n;
        if (jTable == null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(bl);
            return arrayList;
        }
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        ArrayList<Object> arrayList = new ArrayList<Object>(tableColumnModel.getColumnCount() + 1);
        arrayList.add(bl);
        HashSet<String> hashSet = null;
        GroupModelProvider groupModelProvider = (GroupModelProvider)((Object)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), GroupModelProvider.class));
        if (!(groupModelProvider == null || groupModelProvider.isDisplayGroupColumns() || groupModelProvider instanceof DefaultGroupTableModel && ((DefaultGroupTableModel)groupModelProvider).isKeepColumnOrder())) {
            hashSet = new HashSet<String>();
            for (n = 0; n < groupModelProvider.getGroupColumnCount(); ++n) {
                object = groupModelProvider.getGroupColumnIdentifier(n);
                if (object == null) {
                    if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                    LOGGER_EVENT.fine("TableColumnSnapshot \" Identifier should not be null in GroupTableModel grouping column with index as: " + n + ".");
                    continue;
                }
                String string = object.toString();
                arrayList.add(string);
                if (!string.endsWith(":::DATA:::")) continue;
                hashSet.add(string.substring(0, string.length() - ":::DATA:::".length()));
            }
        }
        for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
            object = TableUtils.eraseIdentifierFlag(tableColumnModel.getColumn(n).getIdentifier(), ":::DATA:::");
            if (hashSet != null && hashSet.contains(object)) continue;
            if (object == null) {
                if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                LOGGER_EVENT.fine("TableColumnSnapshot \" Identifier should not be null in column with index as: " + n + ".");
                continue;
            }
            if (object.equals("GROUP_COUNT:::HEADER") || object.equals("GROUP_COLUMN:::HEADER")) {
                arrayList.add(1, object.toString());
                continue;
            }
            arrayList.add(object.toString());
        }
        return arrayList;
    }

    public List<Object> constructNewShot(TableScrollPane tableScrollPane, boolean bl) {
        JTable jTable = tableScrollPane.getRowHeaderTable();
        JTable jTable2 = tableScrollPane.getMainTable();
        JTable jTable3 = tableScrollPane.getRowFooterTable();
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (jTable.getColumnCount() != 0) {
            arrayList.add(jTable);
        }
        if (jTable2.getColumnCount() != 0) {
            arrayList.add(jTable2);
        }
        if (jTable3.getColumnCount() != 0) {
            arrayList.add(jTable3);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(bl);
        GroupModelProvider groupModelProvider = (GroupModelProvider)((Object)TableModelWrapperUtils.getActualTableModel(tableScrollPane.getTableModel(), GroupModelProvider.class));
        if (!(groupModelProvider == null || groupModelProvider.isDisplayGroupColumns() || groupModelProvider instanceof DefaultGroupTableModel && ((DefaultGroupTableModel)groupModelProvider).isKeepColumnOrder())) {
            for (int i = 0; i < groupModelProvider.getGroupColumnCount(); ++i) {
                Object object = groupModelProvider.getGroupColumnIdentifier(i);
                if (object == null) {
                    if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                    LOGGER_EVENT.fine("TableColumnSnapshot \" Identifier should not be null in GroupTableModel grouping column with index as: " + i + ".");
                    continue;
                }
                arrayList2.add(object.toString());
            }
        }
        for (JTable jTable4 : arrayList) {
            TableColumnModel tableColumnModel = jTable4.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                Object object = TableUtils.eraseIdentifierFlag(tableColumnModel.getColumn(i).getIdentifier(), ":::DATA:::");
                if (object == null) {
                    if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                    LOGGER_EVENT.fine("TableColumnSnapshot \" Identifier should not be null in table: " + jTable4.getName() + " and the column with index as: " + i + ".");
                    continue;
                }
                arrayList2.add(object.toString());
            }
        }
        return arrayList2;
    }

    public boolean recordDefault(TableModel tableModel) {
        if (this._snapshot == null) {
            this._snapshot = new Vector();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(tableModel.getColumnCount() + 1);
        arrayList.add(false);
        if (tableModel instanceof DefaultGroupTableModel) {
            DefaultGroupTableModel defaultGroupTableModel = (DefaultGroupTableModel)tableModel;
            for (int i = 0; i < defaultGroupTableModel.getGroupColumnCount(); ++i) {
                Object object = TableUtils.eraseIdentifierFlag(defaultGroupTableModel.getGroupColumnIdentifier(i), ":::HEADER");
                if (object == null) {
                    if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                    LOGGER_EVENT.fine("TableColumnSnapshot \" Identifier should not be null in GroupTableModel grouping column with index as: " + i + ".");
                    continue;
                }
                arrayList.add(object.toString());
            }
        }
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            Object object;
            if (tableModel instanceof ColumnIdentifierTableModel) {
                object = TableUtils.eraseIdentifierFlag(((ColumnIdentifierTableModel)((Object)tableModel)).getColumnIdentifier(i), ":::HEADER");
                object = TableUtils.eraseIdentifierFlag(object, ":::DATA:::");
            } else {
                object = tableModel.getColumnName(i);
            }
            if (object == null) {
                if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                LOGGER_EVENT.fine("TableColumnSnapshot \" Identifier should not be null in column with index as: " + i + ".");
                continue;
            }
            arrayList.add(object.toString());
        }
        return this.record(arrayList);
    }

    public boolean record(JTable jTable, boolean bl, boolean bl2) {
        if (this._snapshot == null) {
            this._snapshot = new Vector();
        }
        List<Object> list = this.constructNewShot(jTable, bl);
        if (bl2) {
            for (int i = list.size() - 1; i >= 1; --i) {
                Object object = list.get(i);
                if (!(object instanceof String) || !((String)object).contains(":::HEADER")) continue;
                object = TableUtils.eraseIdentifierFlag(object, ":::HEADER");
                list.set(i, object.toString());
                break;
            }
        }
        return this.record(list);
    }

    public boolean record(TableScrollPane tableScrollPane, boolean bl) {
        if (this._snapshot == null) {
            this._snapshot = new Vector();
        }
        List<Object> list = this.constructNewShot(tableScrollPane, bl);
        return this.record(list);
    }

    private boolean record(List<Object> list) {
        int n;
        boolean bl = true;
        for (int i = list.size() - 1; i >= 1; --i) {
            if (list.get(i) != null) continue;
            list.remove(i);
            if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
            LOGGER_EVENT.fine("TableColumnSnapshot \" Column Name or Identifier is null, which will potentially cause the column order messed up");
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (n = 1; n < list.size(); ++n) {
            if (hashSet.add(list.get(n))) continue;
            bl = false;
            break;
        }
        if (!((Boolean)list.get(0)).booleanValue()) {
            for (n = this.getSize() - 1; n >= 0; --n) {
                if (!this.equalSet(this._snapshot.elementAt(n), list)) continue;
                this._snapshot.removeElementAt(n);
            }
        }
        this._snapshot.add(list);
        if (!bl && LOGGER_EVENT.isLoggable(Level.FINE)) {
            LOGGER_EVENT.fine("TableColumnSnapshot \" Column names duplicated in your table model. You need implement ColumnIdentifierTableModel.");
        }
        return bl;
    }

    private List<Object> getMostMatchShot(List<Object> list, Object object, int n) {
        List<Object> list2 = null;
        int n2 = -1;
        for (int i = n; i >= 0; --i) {
            if (n >= this._snapshot.size()) continue;
            List<Object> list3 = this._snapshot.elementAt(i);
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.addAll(list3);
            int n3 = 0;
            if (!hashSet.contains(object)) {
                n3 = -1;
            } else {
                for (int j = 1; j < list.size(); ++j) {
                    Object object2 = list.get(j);
                    if (!(object2 instanceof String) || !hashSet.contains(object2) && !hashSet.contains(TableUtils.eraseIdentifierFlag(object2, ":::HEADER")) && !list3.contains(object2 + ":::HEADER")) continue;
                    ++n3;
                }
            }
            if (n3 <= n2) continue;
            n2 = n3;
            list2 = list3;
        }
        return list2;
    }

    public int searchViewIndex(List<Object> list, Object object, int n) {
        List<Object> list2;
        int n2;
        if (this._snapshot == null || object == null) {
            if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                LOGGER_EVENT.fine("TableColumnSnapshot \" Snapshot or identifier should not be null.");
            }
            return -1;
        }
        object = object.toString();
        int n3 = -1;
        for (n2 = 1; n2 < list.size(); ++n2) {
            list2 = list.get(n2);
            if (!(list2 instanceof String) || ((String)((Object)list2)).contains(":::HEADER")) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0) {
            n3 = list.size();
        }
        n2 = list.size() - 1;
        list2 = this.getMostMatchShot(list, object = TableUtils.eraseIdentifierFlag(object, ":::DATA:::"), n);
        if (list2 != null) {
            n2 = this.getPotentialMatchedIndex(list, list2, this.getElementIndex(list2, object));
        }
        n2 = object instanceof String && ((String)object).contains(":::HEADER") ? Math.min(n2, n3) : Math.max(n2, n3);
        return n2 >= 1 ? n2 - 1 : 0;
    }

    private List<Object> sortIdentifierByActiveMode(List<Object> list) {
        int n;
        int n2;
        int n3 = list.size();
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = 0;
            Object object = list.get(i);
            if (object instanceof String && ((String)object).contains(":::HEADER")) {
                nArray[i] = Integer.MAX_VALUE;
                continue;
            }
            for (n2 = 2; n2 <= this.getSize(); ++n2) {
                List<Object> list2 = this._snapshot.elementAt(this.getSize() - n2);
                if (list2.contains(object)) {
                    int n4 = i;
                    nArray[n4] = nArray[n4] + 1;
                    continue;
                }
                int n5 = i;
                nArray[n5] = nArray[n5] - (this.getSize() - n2) * 1000;
            }
        }
        int[] nArray2 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray2[n] = n;
        }
        for (n = 0; n < n3; ++n) {
            int n6;
            n2 = 0;
            int n7 = nArray[nArray2[n]];
            for (n6 = n; n6 < n3; ++n6) {
                if (n7 >= nArray[nArray2[n6]]) continue;
                n7 = nArray[nArray2[n6]];
                n2 = n6;
            }
            if (n7 <= nArray[nArray2[n]]) continue;
            n6 = nArray2[n];
            nArray2[n] = nArray2[n2];
            nArray2[n2] = n6;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add(list.get(nArray2[n2]));
        }
        return arrayList;
    }

    public int[] SearchViewIndicesInSavedPreference(List<Object> list, boolean bl) {
        int n;
        if (!this.isInPreferenceState()) {
            if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                LOGGER_EVENT.fine("TableColumnSnapshot \" Wrong snapshot.");
            }
            return new int[0];
        }
        List<Object> list2 = this.sortIdentifierByActiveMode(list);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = -1;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(0, false);
        int n2 = 0;
        for (int i = 0; i < list2.size(); ++i) {
            int n3;
            Object object = list2.get(i);
            boolean bl2 = object instanceof String && ((String)object).contains(":::HEADER");
            n = -1;
            boolean bl3 = false;
            if (bl) {
                block2: for (n3 = 0; n3 < this._snapshot.size() - 1 && !bl3; ++n3) {
                    List<Object> list3 = this._snapshot.get(n3);
                    for (int j = 1; j < list3.size(); ++j) {
                        if (!JideSwingUtilities.equals(object, list3.get(j))) continue;
                        bl3 = true;
                        continue block2;
                    }
                }
            }
            if (!bl || bl3) {
                n = this.internalSearchViewIndexInSavedPreference(arrayList, object);
            }
            if (n != -1) {
                n = bl2 ? n2++ : Math.max(n2, n);
            }
            nArray[i] = n;
            if (n == -1) continue;
            for (n3 = 0; n3 < i; ++n3) {
                if (nArray[n3] < n) continue;
                int n4 = n3;
                nArray[n4] = nArray[n4] + 1;
            }
            arrayList.add(n + 1, object);
        }
        int[] nArray2 = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            n = list2.indexOf(object);
            if (n >= list.size()) {
                if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                    LOGGER_EVENT.fine("TableColumnSnapshot \" Index should not exceed the size.");
                }
                nArray2[i] = -1;
                continue;
            }
            nArray2[i] = nArray[n];
        }
        return nArray2;
    }

    private int internalSearchViewIndexInSavedPreference(List<Object> list, Object object) {
        List<Object> list2 = this._snapshot.elementAt(this.getSize() - 2);
        int n = this.getElementIndex(list2, object);
        if (n != -1) {
            int n2 = this.searchViewIndex(list, object, this.getSize() - 2);
            if (n2 == -1) {
                return 0;
            }
            return n2;
        }
        if (!list2.contains(object + ":::HEADER") && !list2.contains(TableUtils.eraseIdentifierFlag(object, ":::HEADER"))) {
            List<Object> list3;
            int n3;
            for (n3 = 0; n3 <= this.getSize() - 3; ++n3) {
                list3 = this._snapshot.elementAt(n3);
                if (!list3.contains(object + ":::HEADER") && !list3.contains(TableUtils.eraseIdentifierFlag(object, ":::HEADER"))) continue;
                return -1;
            }
            n3 = 1;
            if (this.getSize() >= 1) {
                list3 = this._snapshot.get(this.getSize() - 1);
                int n4 = list3.indexOf(object);
                for (int i = n4 + 1; i < list3.size(); ++i) {
                    if (!list.contains(list3.get(i))) continue;
                    n3 = 0;
                    break;
                }
            }
            if (n3 != 0) {
                return list.size() - 1;
            }
            int n5 = this.searchViewIndex(list, object, this.getSize() - 1);
            if (n5 == -1) {
                return list.size() - 1;
            }
            return n5;
        }
        int n6 = this.searchViewIndex(list, object, this.getSize() - 3);
        if (n6 != -1) {
            return n6;
        }
        n6 = this.searchViewIndex(list, object, this.getSize() - 1);
        if (n6 == -1) {
            return 0;
        }
        return n6;
    }

    public void remove(List<Object> list) {
        if (this._snapshot == null) {
            if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                LOGGER_EVENT.fine("TableColumnSnapshot \" Snapshot should not be null.");
            }
            return;
        }
        for (int i = this.getSize() - 1; i >= 1; --i) {
            List<Object> list2 = this._snapshot.elementAt(i);
            if (list2 == null || list2.size() < 1 || !(list2.get(0) instanceof Boolean)) {
                if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                    LOGGER_EVENT.fine("TableColumnSnapshot \" Wrong snapshot.");
                }
                return;
            }
            if (((Boolean)list2.get(0)).booleanValue() || !this.containSet(list, list2)) continue;
            this._snapshot.removeElementAt(i);
        }
    }

    public void removePreferenceSaved() {
        if (this._snapshot == null) {
            return;
        }
        for (int i = this.getSize() - 1; i >= 0; --i) {
            List<Object> list = this._snapshot.elementAt(i);
            if (list == null || list.size() < 1 || !(list.get(0) instanceof Boolean)) {
                if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                    LOGGER_EVENT.fine("TableColumnSnapshot \" Wrong snapshot.");
                }
                return;
            }
            if (!((Boolean)list.get(0)).booleanValue()) continue;
            this._snapshot.removeElementAt(i);
        }
    }

    private int getPotentialMatchedIndex(List<Object> list, List<Object> list2, int n) {
        int n2 = list2.size();
        for (int i = 1; i < n2 * 2; ++i) {
            int n3;
            if (n - i >= 1 && (n3 = this.getElementIndex(list, list2.get(n - i))) >= 0) {
                return n3 + 1;
            }
            if (n + i >= n2 || (n3 = this.getElementIndex(list, list2.get(n + i))) < 0) continue;
            return n3;
        }
        return -1;
    }

    private int getElementIndex(List<Object> list, Object object) {
        for (int i = 1; i < list.size(); ++i) {
            if (!JideSwingUtilities.equals(list.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    private boolean containSet(List<Object> list, List<Object> list2) {
        if (list.size() < list2.size()) {
            return false;
        }
        for (int i = 1; i < list2.size(); ++i) {
            if (list.contains(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean equalSet(List<Object> list, List<Object> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (Object object : list) {
            if (list2.contains(object)) continue;
            return false;
        }
        return true;
    }

    public int getSize() {
        return this._snapshot.size();
    }

    public boolean isInPreferenceState() {
        if (this._snapshot == null || this.getSize() < 2) {
            return false;
        }
        List<Object> list = this._snapshot.elementAt(this.getSize() - 1);
        if (list == null || list.size() < 1 || !(list.get(0) instanceof Boolean) || !((Boolean)list.get(0)).booleanValue()) {
            return false;
        }
        List<Object> list2 = this._snapshot.elementAt(this.getSize() - 2);
        return list2 != null && list2.size() >= 1 && list2.get(0) instanceof Boolean && (Boolean)list2.get(0) != false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getSize()).append('\t');
        for (int i = 0; i < this.getSize(); ++i) {
            List<Object> list = this._snapshot.elementAt(i);
            stringBuffer.append(list.size()).append('\t');
            stringBuffer.append((Boolean)list.get(0) != false ? "1" : "0").append('\t');
            for (int j = 1; j < list.size(); ++j) {
                Object object = list.get(j);
                stringBuffer.append(object).append('\t');
            }
        }
        return new String(stringBuffer);
    }
}

