/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ConverterContextSupport;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class StyledTableCellRenderer
extends StyledLabel
implements ConverterContextSupport,
TableCellRenderer,
Serializable {
    private ConverterContext _context;
    private Class<?> _class;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final long serialVersionUID = -6645387534547634097L;
    private Color unselectedForeground;
    private Color unselectedBackground;

    public StyledTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        this.setFont(jTable.getFont());
        if (bl2) {
            Border border = null;
            if (bl) {
                border = UIDefaultsLookup.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIDefaultsLookup.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!bl && jTable.isCellEditable(n, n2)) {
                Color color = UIDefaultsLookup.getColor("Table.focusCellForeground");
                if (color != null) {
                    super.setForeground(color);
                }
                if ((color = UIDefaultsLookup.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(color);
                }
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setIgnoreColorSettings(bl);
        this.customizeStyledLabel(jTable, object, bl, bl2, n, n2);
        return this;
    }

    protected void customizeStyledLabel(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.clearStyleRanges();
        this.setValue(object);
    }

    @Override
    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string.equals("text")) {
            super.firePropertyChange(string, object, object2);
        } else if (string.equals("labelFor") || string.equals("displayedMnemonic")) {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    protected void setValue(Object object) {
        this.setText(object == null ? "" : object.toString());
    }

    @Override
    public void setConverterContext(ConverterContext converterContext) {
        this._context = converterContext;
    }

    @Override
    public ConverterContext getConverterContext() {
        return this._context;
    }

    @Override
    public Class<?> getType() {
        return this._class;
    }

    @Override
    public void setType(Class<?> clazz) {
        this._class = clazz;
    }

    public static class UIResource
    extends StyledTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

