/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;

public class SortableTableHeaderMouseListener
extends MouseInputAdapter {
    private boolean headerResizing;

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Serializable serializable;
        Object object;
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (SystemInfo.isMacOSX() && mouseEvent.isControlDown()) {
            return;
        }
        if (!(mouseEvent.getSource() instanceof JTableHeader)) {
            return;
        }
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        if (!jTableHeader.getTable().isEnabled() || jTableHeader instanceof AutoFilterTableHeader && ((AutoFilterTableHeader)jTableHeader).isAutoFilterEnabled() && ((AutoFilterTableHeader)jTableHeader).isRolloverEnabled()) {
            return;
        }
        JTable jTable = jTableHeader.getTable();
        if (jTable.isEditing()) {
            jTable.getCellEditor().stopCellEditing();
        }
        if ((object = jTable.getClientProperty("TableScrollPane.Parent")) instanceof TableScrollPane && (serializable = ((TableScrollPane)object).getEditingTable()) != null) {
            ((JTable)serializable).getCellEditor().stopCellEditing();
        }
        this.headerResizing = (serializable = jTableHeader.getResizingColumn()) != null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        ISortableTableModel iSortableTableModel;
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isShiftDown() || mouseEvent.isAltDown()) {
            return;
        }
        if (SystemInfo.isMacOSX() && mouseEvent.isControlDown()) {
            return;
        }
        if (!(mouseEvent.getSource() instanceof JTableHeader) || ((JTableHeader)mouseEvent.getSource()).getCursor() == Cursor.getPredefinedCursor(11)) {
            return;
        }
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        JTable jTable = jTableHeader.getTable();
        int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
        if (n < 0 || n >= jTable.getColumnCount()) {
            return;
        }
        int n2 = jTable.convertColumnIndexToModel(n);
        if (!jTable.isEnabled() || jTableHeader instanceof AutoFilterTableHeader && !((AutoFilterTableHeader)jTableHeader).isUseNativeHeaderRenderer() && ((AutoFilterTableHeader)jTableHeader).isAutoFilterEnabled() && ((AutoFilterTableHeader)jTableHeader).isRolloverEnabled()) {
            return;
        }
        if (jTableHeader instanceof NestedTableHeader && !((NestedTableHeader)jTableHeader).isMouseOnOriginalTableHeader(mouseEvent.getPoint())) {
            return;
        }
        if (jTable instanceof SortableTable) {
            iSortableTableModel = ((SortableTable)jTable).getSortableTableModel();
            if (!((SortableTable)jTable).isSortable() || this.headerResizing) {
                return;
            }
            if (!((SortableTable)jTable).isSortingEnabled()) {
                return;
            }
        } else {
            return;
        }
        boolean bl = JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent);
        this.toggleSortOrder(jTable, iSortableTableModel, n2, bl);
    }

    private String saveTablePreference(JTable jTable) {
        TableScrollPane tableScrollPane = (TableScrollPane)jTable.getClientProperty("TableScrollPane.Parent");
        if (tableScrollPane == null) {
            return TableUtils.getTablePreferenceByName(jTable);
        }
        return TableUtils.getTablePreferenceByName(tableScrollPane);
    }

    private void loadTablePreference(JTable jTable, String string) {
        TableScrollPane tableScrollPane = (TableScrollPane)jTable.getClientProperty("TableScrollPane.Parent");
        if (tableScrollPane == null) {
            TableUtils.setTablePreferenceByName(jTable, string);
        } else {
            TableUtils.setTablePreferenceByName(tableScrollPane, string, false);
        }
    }

    private String saveSortableTablePreference(JTable jTable) {
        String string = null;
        if (jTable instanceof SortableTable) {
            string = TableUtils.getSortableTablePreference((SortableTable)jTable, true);
        }
        return string;
    }

    private void loadSortableTablePreference(JTable jTable, String string) {
        if (jTable instanceof SortableTable && string != null) {
            TableUtils.setSortableTablePreference((SortableTable)jTable, string, true);
        }
    }

    protected void toggleSortOrder(JTable jTable, ISortableTableModel iSortableTableModel, int n, boolean bl) {
        iSortableTableModel.toggleSortOrder(n, bl);
        if (!(jTable instanceof SortableTable) || ((SortableTable)jTable).isEnsureSelectedRowVisibleOnTogglingSort()) {
            TableUtils.ensureRowSelectionVisible(jTable);
        }
    }
}

