/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.GroupTableHeader;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortTableHeaderRenderer;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableHeaderCellDecorator;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SortableTableHeaderCellDecorator
implements TableHeaderCellDecorator {
    static final String CLIENT_PROPERTY_PAINTING_GROUP_COLUMN_INDEX = "TableHeaderUIDelegate.paintingGroupColumnIndex";

    protected TableCellRenderer getHeaderRenderer(JTableHeader jTableHeader, int n) {
        if (n < 0 || n >= jTableHeader.getColumnModel().getColumnCount()) {
            return null;
        }
        TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        return tableCellRenderer;
    }

    @Override
    public Insets getInsets(Graphics graphics, JTableHeader jTableHeader, int n, Rectangle rectangle) {
        SortInfo sortInfo = this.getSortInfo(jTableHeader, n);
        if (sortInfo != null) {
            Object object = UIDefaultsLookup.get("Theme.painter");
            TableCellRenderer tableCellRenderer = this.getHeaderRenderer(jTableHeader, n);
            if (!(!(jTableHeader.getTable() instanceof SortableTable) || tableCellRenderer instanceof SortTableHeaderRenderer && ((SortTableHeaderRenderer)tableCellRenderer).isSortArrowVisible())) {
                Color color;
                Icon icon = ((SortableTable)jTableHeader.getTable()).createSortIcon(sortInfo._ascending);
                boolean bl = ((SortableTable)jTableHeader.getTable()).isMultiColumnSortable() && sortInfo._sortIndex >= 0;
                Color color2 = color = ((SortableTable)jTableHeader.getTable()).getSortOrderForeground() != null ? ((SortableTable)jTableHeader.getTable()).getSortOrderForeground() : jTableHeader.getForeground();
                if (object instanceof ThemePainter) {
                    return ((ThemePainter)object).getSortableTableHeaderColumnCellDecoratorInsets(jTableHeader, graphics, rectangle, 0, 0, sortInfo._ascending ? 1 : 2, icon, sortInfo._sortIndex, color, bl);
                }
            }
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics, JTableHeader jTableHeader, int n, Rectangle rectangle, boolean bl) {
        SortInfo sortInfo = this.getSortInfo(jTableHeader, n);
        if (sortInfo != null) {
            Object object = UIDefaultsLookup.get("Theme.painter");
            TableCellRenderer tableCellRenderer = this.getHeaderRenderer(jTableHeader, n);
            if (!(!(jTableHeader.getTable() instanceof SortableTable) || tableCellRenderer instanceof SortTableHeaderRenderer && ((SortTableHeaderRenderer)tableCellRenderer).isSortArrowVisible())) {
                Color color;
                Icon icon = ((SortableTable)jTableHeader.getTable()).createSortIcon(sortInfo._ascending);
                boolean bl2 = ((SortableTable)jTableHeader.getTable()).isMultiColumnSortable() && sortInfo._sortIndex >= 0;
                Color color2 = color = ((SortableTable)jTableHeader.getTable()).getSortOrderForeground() != null ? ((SortableTable)jTableHeader.getTable()).getSortOrderForeground() : jTableHeader.getForeground();
                if (object instanceof ThemePainter) {
                    ((ThemePainter)object).paintSortableTableHeaderColumn(jTableHeader, graphics, rectangle, 0, 0, sortInfo._ascending ? 1 : 2, icon, sortInfo._sortIndex, color, bl2);
                }
            }
        }
    }

    protected SortInfo getSortInfo(JTableHeader jTableHeader, int n) {
        ISortableTableModel iSortableTableModel;
        int n2;
        int n3;
        Serializable serializable;
        Object object = jTableHeader.getClientProperty(CLIENT_PROPERTY_PAINTING_GROUP_COLUMN_INDEX);
        if (object instanceof Integer && jTableHeader instanceof GroupTableHeader && n < 0 && (serializable = (DefaultGroupTableModel)TableModelWrapperUtils.getActualTableModel(jTableHeader.getTable().getModel(), DefaultGroupTableModel.class)) != null && (n3 = ((Integer)object).intValue()) >= 0 && n3 < ((DefaultGroupTableModel)serializable).getGroupColumnCount() && (n2 = ((DefaultGroupTableModel)serializable).getGroupColumnOrder(n3)) != 0) {
            return new SortInfo(-1, n2 == 1);
        }
        if (n >= 0 && n < jTableHeader.getColumnModel().getColumnCount() && jTableHeader.getTable() instanceof SortableTable && (iSortableTableModel = ((SortableTable)(serializable = (SortableTable)jTableHeader.getTable())).getSortableTableModel()) != null) {
            n2 = TableModelWrapperUtils.getActualColumnAt(((JTable)serializable).getModel(), ((JTable)serializable).convertColumnIndexToModel(n), iSortableTableModel);
            List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
            if (list != null) {
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    ISortableTableModel.SortItem sortItem = list.get(i);
                    if (sortItem.getColumn() != n2) continue;
                    return new SortInfo(((SortableTable)serializable).isShowSortOrderNumber() || n4 > 1 ? i : -1, sortItem.ascending);
                }
            }
        }
        return null;
    }

    protected class SortInfo {
        int _sortIndex;
        boolean _ascending;

        public SortInfo(int n, boolean bl) {
            this._sortIndex = n;
            this._ascending = bl;
        }
    }
}

