/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class SortTableHeaderRenderer
implements TableCellRenderer,
UIResource {
    protected JPanel _headerPanel;
    protected JPanel _titlePanel;
    protected SortPanel _sortPanel;
    private Object _lastTitleValue;
    private boolean _sortArrowVisible = true;
    private int _alignment;

    public SortTableHeaderRenderer() {
        this(0);
    }

    public SortTableHeaderRenderer(int n) {
        this.setAlignment(n);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTableHeader jTableHeader;
        if (this._headerPanel == null) {
            this.initComponents();
        }
        if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
            Border border = UIDefaultsLookup.getBorder("NestedTableHeader.cellBorder");
            if (border == null) {
                border = UIDefaultsLookup.getBorder("TableHeader.cellBorder");
            }
            this._headerPanel.setBorder(border);
            this._headerPanel.setForeground(jTableHeader.getForeground());
            this._headerPanel.setBackground(jTableHeader.getBackground());
            this._headerPanel.setFont(jTableHeader.getFont());
        }
        this.updateTitlePanel(object);
        if (jTable != null && this.isSortArrowVisible()) {
            this.updateSortPanel(jTable, n2);
        }
        return this._headerPanel;
    }

    public int getDefaultHeaderWidth(String string) {
        return SortTableHeaderRenderer.getCharWidth(string);
    }

    protected void initComponents() {
        this._titlePanel = new JPanel(new GridLayout(0, 1));
        this._titlePanel.setOpaque(false);
        this._sortPanel = new SortPanel();
        this._sortPanel.setOpaque(false);
        this._sortPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 2));
        this._headerPanel = new JPanel(new BorderLayout());
        this._headerPanel.add((Component)this._titlePanel, "Center");
    }

    private void updateTitlePanel(Object object) {
        if (this._lastTitleValue != object) {
            this._lastTitleValue = object;
            this._titlePanel.removeAll();
            if (object != null) {
                if (object instanceof Icon) {
                    JLabel jLabel = this.createLabel((Icon)object);
                    this._titlePanel.add(jLabel);
                } else {
                    List<String> list = SortTableHeaderRenderer.splitHeading(object.toString());
                    for (String string : list) {
                        JLabel jLabel = this.createLabel(string);
                        jLabel.setForeground(this._headerPanel.getForeground());
                        jLabel.setBackground(this._headerPanel.getBackground());
                        jLabel.setFont(this._headerPanel.getFont());
                        this._titlePanel.add(jLabel);
                    }
                }
            }
        }
    }

    protected JLabel createLabel(Icon icon) {
        return new JLabel(icon, this.getAlignment());
    }

    protected JLabel createLabel(String string) {
        return new JLabel(string, this.getAlignment());
    }

    private static List<String> splitHeading(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList;
    }

    static int getCharWidth(String string) {
        int n = 0;
        List<String> list = SortTableHeaderRenderer.splitHeading(string);
        for (String string2 : list) {
            int n2 = string2.length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void updateSortPanel(JTable jTable, int n) {
        n = jTable.convertColumnIndexToModel(n);
        if (SortableTableModel.getSortableModel(jTable.getModel()) == null) {
            this._headerPanel.remove(this._sortPanel);
            return;
        }
        ISortableTableModel iSortableTableModel = SortableTableModel.getSortableModel(jTable.getModel());
        boolean bl = iSortableTableModel.isColumnSorted(n);
        if (bl) {
            boolean bl2 = iSortableTableModel.isColumnAscending(n);
            this._sortPanel.setDirection(jTable, bl2);
            if (iSortableTableModel.isMultiColumnSortable() && (((SortableTable)jTable).isShowSortOrderNumber() || iSortableTableModel.getSortingColumns().size() > 1)) {
                this._sortPanel.setSortNumber(iSortableTableModel.getColumnSortRank(n));
            } else {
                this._sortPanel.clearSortNumber();
            }
            this._headerPanel.add((Component)this._sortPanel, "After");
        } else {
            this._headerPanel.remove(this._sortPanel);
        }
    }

    public boolean isSortArrowVisible() {
        return this._sortArrowVisible;
    }

    public void setSortArrowVisible(boolean bl) {
        this._sortArrowVisible = bl;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int n) {
        this._alignment = n;
    }

    protected SortArrow createSortArrow() {
        DefaultSortArrow defaultSortArrow = new DefaultSortArrow();
        defaultSortArrow.setOpaque(false);
        defaultSortArrow.setIconTextGap(2);
        Font font = defaultSortArrow.getFont();
        Font font2 = SecurityUtils.createFont(font.getName(), font.getStyle(), font.getSize() - 2);
        defaultSortArrow.setFont(font2);
        return defaultSortArrow;
    }

    private class DefaultSortArrow
    extends JLabel
    implements SortArrow {
        DefaultSortArrow() {
        }

        @Override
        public void setDirection(JTable jTable, boolean bl) {
            if (jTable instanceof SortableTable) {
                this.setIcon(((SortableTable)jTable).createSortIcon(bl));
                return;
            }
            Color color = jTable.isEnabled() ? UIDefaultsLookup.getColor("controlDkShadow") : UIDefaultsLookup.getColor("controlShadow");
            if (bl) {
                Icon icon = UIDefaultsLookup.getIcon("Table.ascendingSortIcon");
                if (icon != null) {
                    this.setIcon(icon);
                } else if (CategorizedTable.DEFAULT_ASCENDING_ICON != null) {
                    this.setIcon(new ImageIcon(MaskFilter.createImage(CategorizedTable.DEFAULT_ASCENDING_ICON.getImage(), Color.black, color)));
                }
            } else {
                Icon icon = UIDefaultsLookup.getIcon("Table.descendingSortIcon");
                if (icon != null) {
                    this.setIcon(icon);
                } else if (CategorizedTable.DEFAULT_DESCENDING_ICON != null) {
                    this.setIcon(new ImageIcon(MaskFilter.createImage(CategorizedTable.DEFAULT_DESCENDING_ICON.getImage(), Color.black, color)));
                }
            }
        }
    }

    public static interface SortArrow {
        public void setDirection(JTable var1, boolean var2);

        public void setText(String var1);
    }

    private class SortPanel
    extends JPanel {
        private SortArrow _sortArrow;

        public SortPanel() {
            this.setLayout(new FlowLayout(2, 2, 0));
            this._sortArrow = SortTableHeaderRenderer.this.createSortArrow();
            this.add((JComponent)((Object)this._sortArrow));
        }

        public void setSortNumber(int n) {
            this._sortArrow.setText("" + (n + 1));
        }

        public void clearSortNumber() {
            this._sortArrow.setText(" ");
        }

        public void setDirection(JTable jTable, boolean bl) {
            this._sortArrow.setDirection(jTable, bl);
        }
    }
}

