/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.SliderForInteger;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class SliderCellEditor
extends ContextSensitiveCellEditor
implements TableCellEditor {
    public static final EditorContext CONTEXT = new EditorContext("Slider");
    private SliderForInteger slider;
    private static final long serialVersionUID = -4180089165719171598L;

    public SliderCellEditor() {
        this.slider = new SliderForInteger();
    }

    public SliderCellEditor(int n, int n2) {
        this.slider = new SliderForInteger(n, n2);
    }

    @Override
    public Object getCellEditorValue() {
        return this.slider.getValue();
    }

    public void setCellEditorValue(Object object) {
        if (object instanceof Integer) {
            this.slider.setValue((Integer)object);
        } else if (object == null) {
            this.slider.setValue(0);
        } else if (object instanceof String) {
            try {
                this.slider.setValue(Integer.parseInt((String)object));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public JSlider getSlider() {
        return this.slider.getSlider();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (jTable != null) {
            JideSwingUtilities.installColorsAndFont(this.slider, jTable.getBackground(), jTable.getForeground(), jTable.getFont());
        }
        this.setCellEditorValue(object);
        if (this.slider != null) {
            switch (this.getEditorStyle()) {
                case 2: {
                    if (this.slider.getSlider() != null) {
                        this.slider.getSlider().setEnabled(false);
                    }
                    if (this.slider.getTextField() == null) break;
                    this.slider.getTextField().setEditable(false);
                    break;
                }
                case 1: {
                    if (this.slider.getSlider() != null) {
                        this.slider.getSlider().setEnabled(true);
                    }
                    if (this.slider.getTextField() == null) break;
                    this.slider.getTextField().setEditable(false);
                    break;
                }
                case 3: {
                    if (this.slider.getSlider() != null) {
                        this.slider.getSlider().setEnabled(true);
                    }
                    if (this.slider.getTextField() == null) break;
                    this.slider.getTextField().setEditable(true);
                    break;
                }
            }
        }
        return this.slider;
    }

    @Override
    public boolean stopCellEditing() {
        this.slider.setVisible(false);
        return super.stopCellEditing();
    }

    @Override
    public boolean isEditorStyleSupported(int n) {
        return true;
    }
}

