/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.AbstractExpandable;
import com.jidesoft.grid.AbstractNode;
import com.jidesoft.grid.CategorizedTableModel;
import com.jidesoft.grid.Category;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EditorStyleTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.TreeTableModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PropertyTableModel<T extends Property>
extends TreeTableModel<T>
implements SpanModel,
CategorizedTableModel,
PropertyChangeListener,
EditorStyleTableModel {
    public static final int CATEGORIZED = 0;
    public static final int SORTED = 1;
    public static final int UNSORTED = 2;
    private int _order = 0;
    private boolean _showExpert = true;
    private Comparator<? super T> _comparator;
    private List<T> _categoriesList;
    private HashMap<String, Property> _categories;
    protected boolean _indentNonCategoryRow = false;
    private PropertyChangeSupport changeSupport;
    private String _miscCategoryName;
    private int _categoryOrder = 0;
    private List<T> _properties;
    private static final long serialVersionUID = -5965454576700448089L;

    public PropertyTableModel() {
    }

    public PropertyTableModel(List<T> list) {
        this.setOriginalProperties(list);
    }

    public PropertyTableModel(List<T> list, String[] stringArray) {
        this.setCategories(stringArray);
        this.setOriginalProperties(list);
    }

    public PropertyTableModel(List<T> list, int n) {
        this.setCategoryOrder(n);
        this.setOriginalProperties(list);
    }

    public void setOriginalProperties(List<T> list) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        this._properties = list;
        this.registerListenerForProperties(list);
        this.reloadProperties();
    }

    private void registerListenerForProperties(List list) {
        for (Object e : list) {
            if (!(e instanceof Property)) continue;
            ((Property)e).removePropertyChangeListener(this);
            ((Property)e).addPropertyChangeListener(this);
            if (!((Property)e).hasChildren()) continue;
            this.registerListenerForProperties(((Property)e).getChildren());
        }
    }

    public void releaseProperties() {
        this.releaseProperties(this._properties);
    }

    private void releaseProperties(List list) {
        for (Object e : list) {
            if (!(e instanceof Property)) continue;
            ((Property)e).removePropertyChangeListener(this);
            if (!((Property)e).hasChildren()) continue;
            this.releaseProperties(((Property)e).getChildren());
        }
    }

    public Comparator<? super T> getComparator() {
        return this._comparator;
    }

    public void setComparator(Comparator<? super T> comparator) {
        this._comparator = comparator;
    }

    protected List<T> buildProperties(List<T> list) {
        Property property;
        String string;
        if (this.getOrder() == 1) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            for (Object object : list) {
                arrayList.add((Property)object);
            }
            if (this.getComparator() != null) {
                Collections.sort(arrayList, this.getComparator());
            } else {
                Collections.sort(arrayList, new Comparator<T>(){

                    @Override
                    public int compare(T t, T t2) {
                        if (t != null && t2 != null) {
                            return ((Property)t).getDisplayName().compareTo(((Property)t2).getDisplayName());
                        }
                        return 0;
                    }
                });
            }
            ArrayList arrayList2 = new ArrayList();
            for (Property property2 : arrayList) {
                property2.setParent((Expandable)this.getRoot());
                if (this.shouldBeFiltered((T)property2)) continue;
                arrayList2.add(property2);
            }
            return arrayList2;
        }
        if (this.getOrder() == 2) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            for (Object object : list) {
                arrayList.add((Property)object);
            }
            ArrayList arrayList3 = new ArrayList();
            for (Property property3 : arrayList) {
                property3.setParent((Expandable)this.getRoot());
                if (this.filterProperty(property3)) continue;
                arrayList3.add(property3);
            }
            return arrayList3;
        }
        if (this._categoriesList == null) {
            this._categoriesList = new ArrayList<T>();
        }
        if (this._categories == null) {
            this._categories = new HashMap();
        }
        String string2 = "Misc";
        try {
            string2 = this.getMiscCategoryName();
        }
        catch (Throwable throwable) {
            System.out.println(throwable.getMessage() + " " + throwable.getCause());
        }
        for (Property property4 : list) {
            string = property4.getCategory();
            if (string != null && string.length() != 0) {
                if (this._categories.get(property4.getCategory()) != null) continue;
                property = this.createCategory(string);
                this._categories.put(string, property);
                if (this._categoriesList.contains(property)) continue;
                this._categoriesList.add(property);
                continue;
            }
            if (this._categories.get(string2) != null) continue;
            property = this.createCategory(string2);
            property.setCategoryRow(true);
            this._categories.put(string2, property);
            if (this._categoriesList.contains(property)) continue;
            this._categoriesList.add(property);
        }
        for (Property property4 : this._categoriesList) {
            if (!property4.hasChildren()) continue;
            property4.getChildren().clear();
        }
        for (Property property4 : list) {
            if (this.filterProperty(property4)) continue;
            string = property4.getCategory();
            if (string == null || string.length() == 0) {
                string = string2;
            }
            if ((property = this._categories.get(string)) == null) continue;
            property.setParent(null);
            property.addChild(property4);
        }
        for (int i = this._categoriesList.size() - 1; i >= 0; --i) {
            Property property4;
            property4 = (Property)this._categoriesList.get(i);
            if (property4.hasChildren()) continue;
            this._categoriesList.remove(property4);
            this._categories.remove(property4.getName());
        }
        if (this.getCategoryOrder() > 0) {
            Collections.sort(this._categoriesList);
        } else if (this.getCategoryOrder() < 0) {
            Collections.sort(this._categoriesList);
            Collections.reverse(this._categoriesList);
        }
        return this._categoriesList;
    }

    protected Property createCategory(String string) {
        return new Category(string);
    }

    protected boolean filterProperty(T t) {
        return ((Property)t).isHidden() || ((Property)t).isExpert() && !this.isShowExpert();
    }

    @Override
    protected boolean shouldBeFiltered(T t) {
        return this.filterProperty(t);
    }

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("The order must be one of the following values - CATEGORIZED, SORTED or UNSORTED");
        }
        this._order = n;
        this.reloadProperties();
    }

    public List<T> getProperties() {
        return this.getRows();
    }

    public List<T> getProperties(boolean bl) {
        if (!bl) {
            return this.getProperties();
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        List<T> list = this.getProperties();
        for (Property property : list) {
            if (property.hasChildren() && !property.isExpanded()) {
                this.addRecursively(arrayList, property);
                continue;
            }
            arrayList.add(property);
        }
        return arrayList;
    }

    private void addRecursively(List<T> list, T t) {
        list.add(t);
        if (((AbstractExpandable)t).hasChildren()) {
            for (int i = 0; i < ((AbstractExpandable)t).getChildrenCount(); ++i) {
                Property property = (Property)((AbstractExpandable)t).getChildAt(i);
                if (this.filterProperty(property)) continue;
                this.addRecursively(list, property);
            }
        }
    }

    public List<T> getOriginalProperties() {
        return this._properties;
    }

    public List<T> getOriginalProperties(boolean bl) {
        if (!bl) {
            return this.getOriginalProperties();
        }
        ArrayList arrayList = new ArrayList();
        for (Property property : this.getOriginalProperties()) {
            this.addRecursively(arrayList, property);
        }
        return arrayList;
    }

    public void reloadProperties() {
        this.refresh();
    }

    @Override
    public void setOriginalRows(List<? extends T> list) {
        this._properties = new ArrayList<T>();
        for (T t : list) {
            this._properties.add((Property)t);
        }
        this.reloadProperties();
    }

    @Override
    public void refresh() {
        List<T> list = this.getOriginalProperties();
        if (list != null) {
            super.setOriginalRows(this.buildProperties(list));
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        T t = this.getPropertyAt(n);
        if (t == null) {
            return;
        }
        if (n2 == 1) {
            if (!((Property)t).isEditable()) {
                return;
            }
            Object object2 = ((Property)t).getValue();
            if (!this.compares(object, object2)) {
                ((Property)t).setValue(object);
                this.firePropertyChange(((Property)t).getFullName(), object2, object);
                this.fireTableCellUpdated(n, n2);
                for (Expandable expandable = ((AbstractNode)t).getParent(); expandable != null; expandable = expandable.getParent()) {
                    int n3;
                    if (!(expandable instanceof Property) || (n3 = this.getPropertyIndex((Property)expandable)) == -1) continue;
                    this.fireTableCellUpdated(n3, n2);
                }
                if (((Property)t).getDependingProperties() != null) {
                    List<String> list = ((Property)t).getDependingProperties();
                    for (String string : list) {
                        int n4;
                        T t2 = this.getVisibleProperty(string);
                        if (t2 == null || (n4 = this.getPropertyIndex(t2)) == -1) continue;
                        this.fireTableCellUpdated(n4, n2);
                    }
                }
            }
        }
    }

    protected boolean compares(Object object, Object object2) {
        return JideSwingUtilities.equals(object2, object);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        T t = this.getPropertyAt(n);
        return t != null && ((Property)t).isEditable();
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return GridResource.getResourceBundle(Locale.getDefault()).getString("Table.name");
        }
        return GridResource.getResourceBundle(Locale.getDefault()).getString("Table.value");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public T getPropertyAt(int n) {
        return (T)((Property)this.getRowAt(n));
    }

    public int getPropertyIndex(T t) {
        return this.getRowIndex(t);
    }

    @Deprecated
    public T findProperty(String string) {
        return this.getVisibleProperty(string);
    }

    public T getVisibleProperty(String string) {
        if (this.getRows() == null || string == null || string.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < this.getRows().size(); ++i) {
            Property property = (Property)this.getRows().get(i);
            if (property instanceof Category || !string.equals(property.getFullName())) continue;
            return (T)property;
        }
        return null;
    }

    public T getProperty(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        List<T> list = this.getOriginalProperties(true);
        for (Property property : list) {
            if (!string.equals(property.getFullName())) continue;
            return (T)property;
        }
        return null;
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        if (n2 == 1) {
            T t = this.getPropertyAt(n);
            if (t != null) {
                return ((Property)t).getConverterContext();
            }
            return null;
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        if (n2 == 1) {
            T t = this.getPropertyAt(n);
            if (t != null) {
                return ((Property)t).getEditorContext();
            }
            return null;
        }
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        if (n2 == 1) {
            T t = this.getPropertyAt(n);
            if (t != null) {
                return ((Property)t).getType();
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isCategoryRow(int n) {
        T t = this.getPropertyAt(n);
        return t != null && ((Property)t).isCategoryRow();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected synchronized void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    protected void firePropertyChange(String string, int n, int n2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, n, n2);
    }

    public boolean isIndentNonCategoryRow() {
        return this._indentNonCategoryRow;
    }

    @Deprecated
    public void setIndentNonCategoryRow(boolean bl) {
        this._indentNonCategoryRow = bl;
    }

    public String getMiscCategoryName() {
        if (this._miscCategoryName == null) {
            return GridResource.getResourceBundle(Locale.getDefault()).getString("Table.misc");
        }
        return this._miscCategoryName;
    }

    public void setMiscCategoryName(String string) {
        this._miscCategoryName = string;
    }

    public void renameCategory(String string, String string2) {
        for (int i = 0; i < this.getOriginalProperties().size(); ++i) {
            Property property = (Property)this.getOriginalProperties().get(i);
            if (!string.equals(property.getCategory())) continue;
            property.setCategory(string2);
        }
        Property property = this._categories.get(string);
        if (property instanceof Category) {
            property.setName(string2);
            this._categories.remove(string);
            this._categories.put(string2, property);
        }
        this.reloadProperties();
    }

    public void setCategories(String[] stringArray) {
        this._categoriesList = new ArrayList<T>();
        this._categories = new HashMap();
        for (String string : stringArray) {
            Property property = this.createCategory(string);
            this._categoriesList.add(property);
            this._categories.put(string, property);
        }
    }

    public Property[] getCategories() {
        if (this._categoriesList == null) {
            return new Property[0];
        }
        return this._categoriesList.toArray(new Property[this._categoriesList.size()]);
    }

    public int getCategoryOrder() {
        return this._categoryOrder;
    }

    public void setCategoryOrder(int n) {
        if (n > 1) {
            n = 1;
        } else if (n < -1) {
            n = -1;
        }
        if (this._categoryOrder != n) {
            this._categoryOrder = n;
            if (this._order == 0) {
                this.reloadProperties();
            }
        }
    }

    public boolean isShowExpert() {
        return this._showExpert;
    }

    public void setShowExpert(boolean bl) {
        this._showExpert = bl;
        this.reloadProperties();
    }

    @Override
    public CellSpan getCellSpanAt(int n, int n2) {
        T t = this.getPropertyAt(n);
        if (t != null && ((Property)t).isCategoryRow()) {
            return new CellSpan(n, 0, 1, this.getColumnCount());
        }
        return null;
    }

    @Override
    public boolean isCellSpanOn() {
        return true;
    }

    @Override
    public void addRow(int n, T t, boolean bl) {
        throw new IllegalStateException("Do not call addRow method on PropertyTableModel because PropertyTableModel having its own way to manage the data. You can call getOriginalProperties to get original property list and add a new property to it, then call refresh() method to reload the table model.");
    }

    @Override
    public void addRows(T t, int n, List<? extends T> list) {
        throw new IllegalStateException("Do not call addRows method on PropertyTableModel because PropertyTableModel having its own way to manage the data. You can call getOriginalProperties to get original property list and add new properties to it, then call refresh() method to reload the table model.");
    }

    @Override
    public void addRows(int n, List<? extends T> list, boolean bl) {
        throw new IllegalStateException("Do not call addRows method on PropertyTableModel because PropertyTableModel having its own way to manage the data. You can call getOriginalProperties to get original property list and add new properties to it, then call refresh() method to reload the table model.");
    }

    @Override
    public void removeRow(int n) {
        throw new IllegalStateException("Do not call removeRow method on PropertyTableModel because PropertyTableModel having its own way to manage the data. You can call getOriginalProperties to get original property list and remove property from it, then call refresh() method to reload the table model.");
    }

    public void bind(Object object) throws Exception {
        Method method = object.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
        method.invoke(object, this);
    }

    public void unbind(Object object) throws Exception {
        Method method = object.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
        method.invoke(object, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block3: {
            block1: {
                Property property;
                block2: {
                    if (!(propertyChangeEvent.getSource() instanceof Property)) break block1;
                    property = (Property)propertyChangeEvent.getSource();
                    if (!"name".equals(propertyChangeEvent.getPropertyName())) break block2;
                    property.cellUpdated(0);
                    break block3;
                }
                if (!"value".equals(propertyChangeEvent.getPropertyName())) break block3;
                property.cellUpdated(1);
                break block3;
            }
            for (Row row : this.getOriginalProperties()) {
                if (!(row instanceof Property) || !((Property)row).getName().equals(propertyChangeEvent.getPropertyName())) continue;
                row.cellUpdated(1);
                break;
            }
        }
    }

    @Override
    public Map<Object, Boolean> getExpansionState() {
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        List<T> list = this.getProperties(true);
        for (Property property : list) {
            hashMap.put(property.getFullName(), property.isExpanded());
        }
        return hashMap;
    }

    @Override
    public void setExpansionState(Map<Object, Boolean> map) {
        List<T> list = this.getProperties(true);
        for (Property property : list) {
            Boolean bl = map.get(property.getFullName());
            if (bl == null) continue;
            property.setExpanded(bl);
        }
        this.refresh();
    }

    @Override
    public int getEditorStyleAt(int n, int n2) {
        T t;
        if (n2 == 1 && (t = this.getPropertyAt(n)) != null) {
            return ((Property)t).getEditorStyle();
        }
        return 0;
    }
}

