/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.ListExComboBox;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ConverterContextSupport;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.BooleanCheckBoxCellEditor;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellEditorValueProvider;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.DynamicValueCellRenderer;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EditorContextSupport;
import com.jidesoft.grid.ListComboBoxCellEditor;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyTableCellRenderer;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TextFieldCellEditor;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.HtmlUtils;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PropertyTable
extends TreeTable {
    private TableCellRenderer _renderer;
    private TableCellRenderer _marginRenderer;
    public static final int SHOW_NONEDITABLE_BOTH_NAME_VALUE = 3;
    public static final int SHOW_NONEDITABLE_VALUE_ONLY = 2;
    public static final int SHOW_NONEDITABLE_NAME_ONLY = 1;
    public static final int SHOW_NONEDITABLE_NEITHER = 0;
    private int _showNonEditable = 2;
    private boolean _hideMargin = false;

    public PropertyTable(TableModel tableModel) {
        super(tableModel);
        this.initializeTable();
    }

    public PropertyTable() {
        this.initializeTable();
    }

    private void initializeTable() {
        MouseMotionListener[] mouseMotionListenerArray;
        this.setSortable(false);
        this.setExpandableColumn(0);
        this.getSelectionModel().setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setAutoResizeMode(4);
        MouseMotionListener mouseMotionListener = null;
        for (MouseMotionListener mouseMotionListener2 : mouseMotionListenerArray = this.getMouseMotionListeners()) {
            if (!(mouseMotionListener2 instanceof BasicTableUI.MouseInputHandler)) continue;
            mouseMotionListener = mouseMotionListener2;
            break;
        }
        if (mouseMotionListener != null) {
            this.removeMouseMotionListener(mouseMotionListener);
        }
        if (mouseMotionListener != null) {
            this.addMouseMotionListener(mouseMotionListener);
        }
        this._renderer = this.createPropertyCellRenderer();
        this.setColumnResizable(true);
        this.setAutoStartCellEditing(true);
        this.setAlwaysRequestFocusForEditor(true);
    }

    @Override
    protected void muteDefaultKeyStroke() {
        super.muteDefaultKeyStroke();
        this.replaceAction(KeyStroke.getKeyStroke(9, 0));
    }

    protected TableCellRenderer createPropertyCellRenderer() {
        return new PropertyTableCellRenderer();
    }

    private void stopCellEditing() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    private void cancelCellEditing() {
        if (this.isEditing()) {
            this.removeEditor();
        }
    }

    @Override
    protected String convertElementToString(Object object, int n, int n2) {
        Property property = this.getPropertyAt(n);
        if (property != null) {
            return ObjectConverterManager.toString(object, property.getType(), property.getConverterContext());
        }
        return super.convertElementToString(object, n, n2);
    }

    @Override
    public void setModel(TableModel tableModel) {
        this.stopCellEditing();
        this.cancelCellEditing();
        if (!(tableModel instanceof PropertyTableModel) && TableModelWrapperUtils.getActualTableModel(tableModel, PropertyTableModel.class) == null) {
            super.setModel(new PropertyTableModel());
        } else {
            super.setModel(tableModel);
        }
    }

    Property getPropertyAt(int n) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof PropertyTableModel) {
            return ((PropertyTableModel)tableModel).getPropertyAt(n);
        }
        PropertyTableModel propertyTableModel = (PropertyTableModel)TableModelWrapperUtils.getActualTableModel(tableModel, PropertyTableModel.class);
        int n2 = TableModelWrapperUtils.getActualRowAt(tableModel, n, propertyTableModel);
        return propertyTableModel.getPropertyAt(n2);
    }

    public PropertyTableModel getPropertyTableModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof PropertyTableModel) {
            return (PropertyTableModel)tableModel;
        }
        return (PropertyTableModel)TableModelWrapperUtils.getActualTableModel(tableModel, PropertyTableModel.class);
    }

    public void setSelectedProperty(Property property) {
        this.setSelectedRow(property);
    }

    public Property getSelectedProperty() {
        int n = this.getSelectionModel().getLeadSelectionIndex();
        return this.getPropertyAt(n);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip jToolTip = super.createToolTip();
        jToolTip.setBackground(this.getBackground());
        jToolTip.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getForeground()), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
        return jToolTip;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Rectangle rectangle;
        Point point = this.getCellAt(mouseEvent.getPoint());
        if (point != null && this.needToolTip(point.y, point.x, mouseEvent) && (rectangle = this.getCellRect(mouseEvent.getPoint())) != null) {
            return rectangle.getLocation();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean needToolTip(int n, int n2, MouseEvent mouseEvent) {
        int n3;
        String string;
        Property property = this.getPropertyAt(n);
        if (property == null) {
            return false;
        }
        if (n2 == 1) {
            string = super.getToolTipText(mouseEvent);
            if (string != null) return true;
            string = ObjectConverterManager.toString(property.getValue(), property.getType(), property.getConverterContext());
        } else {
            string = property.getDisplayName();
        }
        if (string == null) return false;
        if (string.length() == 0) {
            return false;
        }
        boolean bl = false;
        if (this.convertColumnIndexToModel(n2) == 0) {
            int n4 = property.isCategoryRow() ? SwingUtilities.computeStringWidth(this.getGraphics().getFontMetrics(), string) : SwingUtilities.computeStringWidth(this.getGraphics().getFontMetrics(), string);
            int n5 = property.getLevel() * this.getIndent() + 1;
            int n6 = this.getCellRect((int)n, (int)n2, (boolean)true).width - n5 - this.getIndent() - 4 - 1;
            if (n4 <= n6) return bl;
            return true;
        }
        int n7 = SwingUtilities.computeStringWidth(this.getGraphics().getFontMetrics(), string);
        if (n7 <= (n3 = this.getCellRect((int)n, (int)n2, (boolean)true).width - 3)) return bl;
        return true;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = this.getCellAt(mouseEvent.getPoint());
        if (point != null && this.needToolTip(point.y, point.x, mouseEvent)) {
            Property property = this.getPropertyAt(point.y);
            if (point.x == 1) {
                String string = super.getToolTipText(mouseEvent);
                if (string == null) {
                    string = ObjectConverterManager.toString(property.getValue(), property.getType(), property.getConverterContext());
                }
                return "<HTML>" + HtmlUtils.formatHtmlSubString(string) + "</HTML>";
            }
            return property.getDisplayName();
        }
        return null;
    }

    protected void resizeColumn(int n) {
        TableColumn tableColumn = this.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(this.getWidth() - n);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(0);
        tableColumn2.setPreferredWidth(n);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (!this.isEnableIgnored()) {
            Property property = this.getPropertyAt(n);
            int n3 = this.getShowNonEditable();
            boolean bl = true;
            if (this.convertColumnIndexToModel(n2) == 0) {
                if ((n3 & 1) != 0 && !property.isEditable()) {
                    bl = false;
                }
            } else if (n2 == 1 && (n3 & 2) != 0 && !property.isEditable()) {
                bl = false;
            }
            if (!this.isEnabled()) {
                bl = false;
            }
            if (!bl) {
                JideSwingUtilities.setEnabledRecursively(component, false);
            }
        }
        return component;
    }

    @Override
    void internalReleaseRendererComponent(TableCellRenderer tableCellRenderer, int n, int n2, Component component, boolean bl) {
        Property property;
        super.internalReleaseRendererComponent(tableCellRenderer, n, n2, component, bl);
        if (this.convertColumnIndexToModel(n2) == 0) {
            Property property2;
            if ((this.getShowNonEditable() & 1) != 0 && !(property2 = this.getPropertyAt(n)).isEditable()) {
                component.setEnabled(true);
            }
        } else if (n2 == 1 && (this.getShowNonEditable() & 2) != 0 && !(property = this.getPropertyAt(n)).isEditable()) {
            component.setEnabled(true);
        }
        if (tableCellRenderer instanceof PropertyTableCellRenderer) {
            ((PropertyTableCellRenderer)tableCellRenderer).releaseCellRenderer();
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        Property property = this.getPropertyAt(n);
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == 0) {
            if (this._renderer instanceof PropertyTableCellRenderer) {
                TableCellRenderer tableCellRenderer = this.getActualCellRenderer(n, n2);
                ((PropertyTableCellRenderer)this._renderer).setActualCellRenderer(tableCellRenderer);
            }
            return this._renderer;
        }
        if (n3 == 1) {
            if (property == null) {
                return super.getCellRenderer(n, n2);
            }
            if (property.isCategoryRow()) {
                return this._renderer;
            }
            TableCellRenderer tableCellRenderer = property.getTableCellRenderer(n3);
            PropertyTableModel propertyTableModel = this.getPropertyTableModel();
            Class<?> clazz = property.getType();
            EditorContext editorContext = property.getEditorContext();
            ConverterContext converterContext = property.getConverterContext();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getDefaultCellRenderer();
            }
            if (tableCellRenderer == null && propertyTableModel != null) {
                int n4 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, propertyTableModel);
                clazz = propertyTableModel.getCellClassAt(n4, n3);
                editorContext = propertyTableModel.getEditorContextAt(n4, n3);
                converterContext = propertyTableModel.getConverterContextAt(n4, n3);
                tableCellRenderer = CellRendererManager.getRenderer(clazz, editorContext);
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getActualCellRenderer(n, n2);
            }
            if (tableCellRenderer instanceof ConverterContextSupport) {
                ((ConverterContextSupport)((Object)tableCellRenderer)).setType(clazz);
                ((ConverterContextSupport)((Object)tableCellRenderer)).setConverterContext(converterContext);
            }
            if (tableCellRenderer instanceof EditorContextSupport) {
                ((EditorContextSupport)((Object)tableCellRenderer)).setEditorContext(editorContext);
            }
            if (tableCellRenderer instanceof DynamicValueCellRenderer) {
                ((DynamicValueCellRenderer)tableCellRenderer).setRowIndex(n);
                ((DynamicValueCellRenderer)tableCellRenderer).setColumnIndex(n2);
                ((DynamicValueCellRenderer)tableCellRenderer).setValueProvider((CellEditorValueProvider)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), CellEditorValueProvider.class)));
            }
            return tableCellRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == 0) {
            return (TableCellEditor)CellEditorManager.getEditor(String.class);
        }
        if (n3 == 1) {
            Object object;
            Property property = this.getPropertyAt(n);
            if (property == null) {
                return super.getCellEditor(n, n2);
            }
            if (!property.isEditable()) {
                if (property.getEditorContext() == BooleanCheckBoxCellEditor.CONTEXT) {
                    return null;
                }
                TextFieldCellEditor textFieldCellEditor = new TextFieldCellEditor(property.getType());
                textFieldCellEditor.setType(property.getType());
                textFieldCellEditor.setConverterContext(property.getConverterContext());
                textFieldCellEditor.setEditorContext(property.getEditorContext());
                return textFieldCellEditor;
            }
            TableCellEditor tableCellEditor = null;
            EditorContext editorContext = property.getEditorContext();
            Class<?> clazz = property.getType();
            ConverterContext converterContext = property.getConverterContext();
            if (EditorContext.DEFAULT_CONTEXT_DYNAMIC_VALUE.equals(editorContext) && (object = (CellEditorValueProvider)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), CellEditorValueProvider.class))) != null) {
                tableCellEditor = new ListComboBoxCellEditor(object.getPossibleValues(n, n2), property.getType(), (CellEditorValueProvider)object, n, n2){
                    private static final long serialVersionUID = 6796931878361962037L;
                    final /* synthetic */ CellEditorValueProvider val$valueProvider;
                    final /* synthetic */ int val$row;
                    final /* synthetic */ int val$column;
                    {
                        this.val$valueProvider = cellEditorValueProvider;
                        this.val$row = n;
                        this.val$column = n2;
                        super(objectArray, clazz);
                    }

                    @Override
                    protected ListExComboBox createListComboBox(ComboBoxModel comboBoxModel, Class<?> clazz) {
                        ListExComboBox listExComboBox = new ListExComboBox(comboBoxModel, clazz);
                        listExComboBox.setConverter(this.val$valueProvider.getConverter(this.val$row, this.val$column));
                        listExComboBox.setEditable(false);
                        return listExComboBox;
                    }
                };
            }
            if (tableCellEditor == null) {
                tableCellEditor = (TableCellEditor)property.getCellEditor(n3);
            }
            object = this.getPropertyTableModel();
            if (tableCellEditor == null && object != null) {
                int n4 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, (TableModel)object);
                clazz = ((PropertyTableModel)object).getCellClassAt(n4, n3);
                editorContext = ((PropertyTableModel)object).getEditorContextAt(n4, n3);
                converterContext = ((PropertyTableModel)object).getConverterContextAt(n4, n3);
                tableCellEditor = (TableCellEditor)CellEditorManager.getEditor(clazz, editorContext);
            }
            if (tableCellEditor == null) {
                tableCellEditor = super.getCellEditor(n, n2);
            }
            if (tableCellEditor instanceof ConverterContextSupport) {
                ((ConverterContextSupport)((Object)tableCellEditor)).setType(clazz);
                ((ConverterContextSupport)((Object)tableCellEditor)).setConverterContext(converterContext);
            }
            if (tableCellEditor instanceof EditorContextSupport) {
                ((EditorContextSupport)((Object)tableCellEditor)).setEditorContext(editorContext);
            }
            return tableCellEditor;
        }
        return super.getCellEditor(n, n2);
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        Property property = this.getPropertyAt(n);
        if (!property.isEditable() && component instanceof JTextField) {
            ((JTextField)component).setEditable(false);
            if ((this.getShowNonEditable() & 2) != 0) {
                component.setForeground(UIDefaultsLookup.getColor("TextField.inactiveForeground"));
            }
        }
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(this);
        return component;
    }

    public int getShowNonEditable() {
        return this._showNonEditable;
    }

    public void setShowNonEditable(int n) {
        int n2 = this._showNonEditable;
        if (n2 != n) {
            this._showNonEditable = n;
            this.firePropertyChange("showNonEditable", n2, n);
        }
    }

    public TableCellRenderer getMarginRenderer() {
        return this._marginRenderer;
    }

    public void setMarginRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this._marginRenderer;
        if (tableCellRenderer2 != tableCellRenderer) {
            this._marginRenderer = tableCellRenderer;
            this.repaint();
            this.firePropertyChange("marginRenderer", tableCellRenderer2, tableCellRenderer);
        }
    }

    public boolean isHideMargin() {
        return this._hideMargin;
    }

    public void setHideMargin(boolean bl) {
        this._hideMargin = bl;
    }

    @Override
    public Rectangle getEditorCellRect(int n, int n2) {
        Rectangle rectangle = super.getEditorCellRect(n, n2);
        if (n2 == 0) {
            int n3 = 0;
            Row row = this.getRowAt(n);
            if (row != null) {
                n3 = row.getLevel() * 16;
                n3 += (this.isHideMargin() ? 0 : 16) + 0;
            }
            rectangle.x += n3;
            rectangle.width -= n3;
        }
        return rectangle;
    }
}

