/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.TableColumnGroup;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.NestedTableHeaderUIDelegate;
import com.jidesoft.plaf.basic.BasicCellStyleTableHeaderUIDelegate;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyledToolTip;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class NestedTableHeader
extends AutoFilterTableHeader {
    private static final String uiClassID = "NestedTableHeaderUI";
    private static final String uiDelegateClassID = "TableHeader.nestedTableHeaderUIDelegate";
    protected Vector<TableColumn> _columnGroups = null;
    private boolean _originalTableHeaderVisible = true;
    private int _margin = 0;
    private int _rowCount = -1;
    public static final String PROPERTY_ORIGINAL_TABLE_HEADER_VISIBLE = "originalTableHeaderVisible";

    public NestedTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    public NestedTableHeader(JTable jTable) {
        super(jTable);
        this.setTable(jTable);
    }

    @Override
    public Rectangle getHeaderRect(int n) {
        return n >= 0 && n < this.getColumnCount() ? this.getCellRect(this.getRowCount() - 1, n) : this.getBounds();
    }

    @Override
    public String getActualUIClassID() {
        return uiClassID;
    }

    @Override
    public String getUIDelegateClassID() {
        return uiDelegateClassID;
    }

    @Override
    protected void tableModelChanged(JTable jTable) {
        super.tableModelChanged(jTable);
        this.reloadAllColumnGroups(jTable);
    }

    private void reloadAllColumnGroups(JTable jTable) {
        if (this._columnGroups == null) {
            return;
        }
        Vector<TableColumn> vector = new Vector<TableColumn>();
        for (TableColumn tableColumn : this._columnGroups) {
            TableColumn tableColumn2;
            if (tableColumn instanceof TableColumnGroup) {
                this.reloadColumnGroup((TableColumnGroup)tableColumn, jTable);
                vector.add(tableColumn);
                continue;
            }
            if (tableColumn == null || (tableColumn2 = this.findNewTableColumn(tableColumn, jTable)) == null) continue;
            vector.add(tableColumn2);
        }
        this._columnGroups = vector;
        this.invalidateRowCountCache();
    }

    private TableColumn findNewTableColumn(TableColumn tableColumn, JTable jTable) {
        Object object;
        Object object2 = tableColumn.getIdentifier() == null ? tableColumn.getHeaderValue() : tableColumn.getIdentifier();
        Object object3 = tableColumn.getHeaderValue();
        Vector vector = new Vector();
        for (int i = jTable.getColumnModel().getColumnCount() - 1; i >= 0; --i) {
            object = jTable.getColumnModel().getColumn(i);
            if (JideSwingUtilities.equals(object2, ((TableColumn)object).getIdentifier())) {
                return object;
            }
            if (!JideSwingUtilities.equals(object3, ((TableColumn)object).getHeaderValue())) continue;
            vector.add(object);
        }
        Object object4 = jTable.getClientProperty("HiddenIdentifiersList");
        if (object4 instanceof List) {
            object = (List)object4;
            Iterator object5 = object.iterator();
            while (object5.hasNext()) {
                Object object6;
                Object e = object5.next();
                if (!JideSwingUtilities.equals(e, object2) || !((object6 = jTable.getClientProperty("TableColumnIdentifier:" + e)) instanceof TableColumn)) continue;
                return (TableColumn)object6;
            }
        }
        if (vector.size() == 1) {
            return (TableColumn)vector.get(0);
        }
        if (vector.size() > 1) {
            for (TableColumn tableColumn2 : vector) {
                if (tableColumn2.getModelIndex() != tableColumn.getModelIndex()) continue;
                return tableColumn2;
            }
        }
        return null;
    }

    private void reloadColumnGroup(TableColumnGroup tableColumnGroup, JTable jTable) {
        TableColumnGroup tableColumnGroup2 = new TableColumnGroup("temp");
        List list = tableColumnGroup.getChildren();
        for (Object e : list) {
            if (e instanceof TableColumnGroup) {
                this.reloadColumnGroup((TableColumnGroup)e, jTable);
                tableColumnGroup2.add(e);
                continue;
            }
            if (e instanceof TableColumn) {
                TableColumn tableColumn = this.findNewTableColumn((TableColumn)e, jTable);
                tableColumnGroup2.add(tableColumn);
                continue;
            }
            tableColumnGroup2.add(e);
        }
        tableColumnGroup.removeAll();
        for (Object e : tableColumnGroup2.getChildren()) {
            tableColumnGroup.add(e);
        }
    }

    public TableColumn[] getTableColumnGroups() {
        return this._columnGroups != null ? this._columnGroups.toArray(new TableColumn[this._columnGroups.size()]) : new TableColumn[]{};
    }

    void uninstallAllGroupListeners() {
        for (TableColumn tableColumn : this.getTableColumnGroups()) {
            if (!(tableColumn instanceof TableColumnGroup)) continue;
            ((TableColumnGroup)tableColumn).setTableHeader(null);
        }
    }

    void invalidateRowCountCache() {
        this._rowCount = -1;
    }

    public void addColumnGroup(TableColumnGroup tableColumnGroup) {
        if (this._columnGroups == null) {
            this._columnGroups = new Vector();
        }
        this._columnGroups.addElement(tableColumnGroup);
        tableColumnGroup.setTableHeader(this);
        this.invalidateRowCountCache();
        this.revalidate();
    }

    public void removeColumnGroup(TableColumnGroup tableColumnGroup) {
        if (this._columnGroups == null) {
            return;
        }
        this._columnGroups.removeElement(tableColumnGroup);
        this.invalidateRowCountCache();
        this.revalidate();
    }

    public void clearColumnGroups() {
        if (this._columnGroups == null) {
            return;
        }
        this._columnGroups.removeAllElements();
        this.invalidateRowCountCache();
        this.revalidate();
    }

    public Object getParent(TableColumn tableColumn) {
        if (this._columnGroups != null) {
            Enumeration<TableColumn> enumeration = this._columnGroups.elements();
            while (enumeration.hasMoreElements()) {
                TableColumnGroup tableColumnGroup = (TableColumnGroup)enumeration.nextElement();
                Object object = this.getParent0(tableColumnGroup, tableColumn);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public int rowAtPoint(Point point) {
        int n = this.getRowCount();
        if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof NestedTableHeaderUIDelegate) {
            NestedTableHeaderUIDelegate nestedTableHeaderUIDelegate = (NestedTableHeaderUIDelegate)((Object)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate());
            int[] nArray = new int[n];
            int n2 = 0;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                nArray[i] = nestedTableHeaderUIDelegate.getRowPreferredHeight(i);
                n2 += nArray[i];
            }
            float f = this.getHeight() / n2;
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!((float)point.y < (float)(n2 += nArray[i]) * f)) continue;
                return i;
            }
            return -1;
        }
        int n3 = this.getSize().height / n;
        if (!this.isOriginalTableHeaderVisible()) {
            return point.y / n3;
        }
        int n4 = this.getActualHeaderY();
        int n5 = this.originalColumnAtPoint(point);
        if (n5 >= 0) {
            if (point.y >= n4) {
                return n - 1;
            }
            TableColumn tableColumn = this.getColumnModel().getColumn(n5);
            Vector vector = this.getColumnGroupsVector(tableColumn);
            return vector == null ? 0 : Math.min(point.y * (this.getRowCount() - 1) / n4, vector.size());
        }
        return point.y / n3;
    }

    private Object getParent0(TableColumnGroup tableColumnGroup, TableColumn tableColumn) {
        Vector vector = tableColumnGroup._columns;
        if (vector.contains(tableColumn)) {
            return tableColumnGroup;
        }
        for (Object e : vector) {
            Object object;
            if (!(e instanceof TableColumnGroup) || (object = this.getParent0((TableColumnGroup)e, tableColumn)) == null) continue;
            return object;
        }
        return null;
    }

    public Enumeration getColumnGroups(TableColumn tableColumn) {
        if (this._columnGroups == null) {
            return null;
        }
        Enumeration<TableColumn> enumeration = this._columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)enumeration.nextElement();
            Vector vector = tableColumnGroup.getColumnGroups(tableColumn, new Vector());
            if (vector == null) continue;
            return vector.elements();
        }
        return null;
    }

    public int getRowAt(TableColumn tableColumn) {
        Vector vector = this.getColumnGroupsVector(tableColumn);
        return vector == null ? 0 : vector.size();
    }

    private Vector getColumnGroupsVector(TableColumn tableColumn) {
        if (this._columnGroups == null) {
            return null;
        }
        if (tableColumn instanceof TableColumnGroup) {
            Vector<TableColumnGroup> vector = new Vector<TableColumnGroup>();
            for (TableColumnGroup tableColumnGroup = ((TableColumnGroup)tableColumn).getParent(); tableColumnGroup != null; tableColumnGroup = tableColumnGroup.getParent()) {
                vector.add(tableColumnGroup);
            }
            return vector;
        }
        Enumeration<TableColumn> enumeration = this._columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)enumeration.nextElement();
            Vector vector = tableColumnGroup.getColumnGroups(tableColumn, new Vector());
            if (vector == null) continue;
            return vector;
        }
        return null;
    }

    public int getLevel(TableColumn tableColumn) {
        if (this._columnGroups == null) {
            return 1;
        }
        Enumeration<TableColumn> enumeration = this._columnGroups.elements();
        while (enumeration.hasMoreElements()) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)enumeration.nextElement();
            Vector vector = tableColumnGroup.getColumnGroups(tableColumn, new Vector());
            if (vector == null) continue;
            return vector.size();
        }
        return 1;
    }

    public boolean isOriginalTableHeaderVisible() {
        return this._originalTableHeaderVisible;
    }

    public void setOriginalTableHeaderVisible(boolean bl) {
        boolean bl2 = this._originalTableHeaderVisible;
        if (bl2 != bl) {
            this._originalTableHeaderVisible = bl;
            this.firePropertyChange(PROPERTY_ORIGINAL_TABLE_HEADER_VISIBLE, bl2, this._originalTableHeaderVisible);
            this.revalidate();
            if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicCellStyleTableHeaderUIDelegate) {
                ((BasicCellStyleTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate()).invalidateCache(true);
            }
        }
    }

    public boolean isMouseOnOriginalTableHeader(Point point) {
        int n = this.columnAtPoint(point);
        if (n >= 0) {
            int n2 = this.rowAtPoint(point);
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            Vector vector = this.getColumnGroupsVector(tableColumn);
            return vector == null || n2 >= vector.size();
        }
        return false;
    }

    public TableColumnGroup getTableColumnGroup(int n, int n2) {
        TableColumn tableColumn;
        Vector vector;
        if (n2 >= 0 && n >= 0 && (vector = this.getColumnGroupsVector(tableColumn = this.getColumnModel().getColumn(n2))) != null && n < vector.size()) {
            return (TableColumnGroup)vector.get(n);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this._columnGroups == null) {
            return 1;
        }
        if (this._rowCount > 0) {
            return this._rowCount;
        }
        int n = 1;
        for (TableColumn tableColumn : this._columnGroups) {
            int n2;
            if (!(tableColumn instanceof TableColumnGroup) || (n2 = this.getGroupLevel((TableColumnGroup)tableColumn)) + 1 <= n) continue;
            n = n2 + 1;
        }
        if (!this.isOriginalTableHeaderVisible() && n > 1) {
            --n;
        }
        this._rowCount = n;
        return n;
    }

    private int getGroupLevel(TableColumnGroup tableColumnGroup) {
        int n = 1;
        for (Object e : tableColumnGroup.getChildren()) {
            int n2;
            if (!(e instanceof TableColumnGroup) || (n2 = this.getGroupLevel((TableColumnGroup)e)) + 1 <= n) continue;
            n = n2 + 1;
        }
        return n;
    }

    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public CellSpan getCellSpanAt(int n, int n2) {
        int n3 = this.getRowCount();
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        Vector vector = this.getColumnGroupsVector(tableColumn);
        if (vector != null && n < vector.size()) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)vector.get(n);
            int n4 = tableColumnGroup.getColumnIndex();
            return new CellSpan(n, n4, 1, tableColumnGroup.getLastColumnIndex() - n4 + 1);
        }
        if (vector == null) {
            return new CellSpan(0, n2, n3, 1);
        }
        return new CellSpan(vector.size(), n2, n3 - vector.size(), 1);
    }

    public Rectangle originalGetCellRect(int n, int n2) {
        Rectangle rectangle = super.getHeaderRect(n2);
        int n3 = this.getRowCount();
        if (n < 0 || n2 < 0 || n3 <= n || this.getColumnCount() <= n2) {
            return rectangle;
        }
        if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof NestedTableHeaderUIDelegate) {
            int n4;
            NestedTableHeaderUIDelegate nestedTableHeaderUIDelegate = (NestedTableHeaderUIDelegate)((Object)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate());
            int[] nArray = new int[n3];
            int n5 = 0;
            int n6 = 0;
            for (n4 = 0; n4 < n3; ++n4) {
                nArray[n4] = nestedTableHeaderUIDelegate.getRowPreferredHeight(n4);
                if (n4 == n) {
                    n6 = n5;
                }
                n5 += nArray[n4];
            }
            if (n5 == this.getHeight() || n != n3 - 1) {
                rectangle.y = n6;
                rectangle.height = nArray[n];
            } else if (n5 > 0) {
                rectangle.y = 0;
                rectangle.height = this.getHeight();
                for (n4 = 0; n4 < n; ++n4) {
                    rectangle.y += nArray[n4];
                    rectangle.height -= nArray[n4];
                }
            }
        }
        return rectangle;
    }

    public Rectangle getCellRect(int n, int n2) {
        Rectangle rectangle = this.originalGetCellRect(n, n2);
        CellSpan cellSpan = this.getCellSpanAt(n, n2);
        if (cellSpan == null) {
            return rectangle;
        }
        if (n != (cellSpan = (CellSpan)cellSpan.clone()).getRow() || n2 != cellSpan.getColumn()) {
            rectangle = this.originalGetCellRect(cellSpan.getRow(), cellSpan.getColumn());
        }
        block0: for (int i = cellSpan.getRowSpan() - 1; i >= 0; --i) {
            for (int j = cellSpan.getColumnSpan() - 1; j >= 0; --j) {
                Rectangle rectangle2 = this.originalGetCellRect(cellSpan.getRow() + i, cellSpan.getColumn() + j);
                if (rectangle2.getWidth() == 0.0 && rectangle2.getHeight() == 0.0) continue;
                rectangle = rectangle.union(rectangle2);
                continue block0;
            }
        }
        return rectangle;
    }

    @Override
    public int getActualHeaderY() {
        if (this.getColumnCount() > 0 && this.getRowCount() > 0) {
            if (!this.isOriginalTableHeaderVisible()) {
                return this.getHeight();
            }
            Rectangle rectangle = this.getCellRect(this.getRowCount() - 1, 0);
            return rectangle.y;
        }
        return 0;
    }

    @Override
    public int columnAtPoint(Point point) {
        int n = super.columnAtPoint(point);
        if (this.getRowCount() <= 1 || n < 0) {
            return n;
        }
        int n2 = this.getActualHeaderY();
        if (point.y >= n2) {
            return n;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        Vector vector = this.getColumnGroupsVector(tableColumn);
        return vector == null || n2 / (this.getRowCount() - 1) * vector.size() <= point.y ? n : -1;
    }

    @Override
    public int originalColumnAtPoint(Point point) {
        return super.columnAtPoint(point);
    }

    public Object getHeaderValueAt(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        Vector vector = this.getColumnGroupsVector(tableColumn);
        if (vector != null && n < vector.size()) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)vector.get(n);
            return "" + tableColumnGroup.getHeaderValue();
        }
        return this.getColumnModel().getColumn(n2).getHeaderValue();
    }

    public int getMargin() {
        return this._margin;
    }

    public void setMargin(int n) {
        this._margin = n;
    }

    @Override
    public JToolTip createToolTip() {
        return new StyledToolTip();
    }
}

