/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.swing.AutoResizingTextArea;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;

public class MultilineTableCellEditor
extends ContextSensitiveCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 3877762374464984109L;
    public static EditorContext CONTEXT = new EditorContext("Multiline");
    protected JTextArea _textArea = this.createTextArea();
    protected JScrollPane _scrollPane = this.createScrollPane(this._textArea);

    protected JScrollPane createScrollPane(JComponent jComponent) {
        return new JScrollPane(jComponent);
    }

    protected void customizeTextArea() {
        this._textArea.setOpaque(false);
        this._textArea.setBorder(DEFAULT_CELL_EDITOR_BORDER);
        this._textArea.setLineWrap(false);
    }

    protected JTextArea createTextArea() {
        return new AutoResizingTextArea();
    }

    @Override
    public Object getCellEditorValue() {
        return this._textArea.getText();
    }

    public void setCellEditorValue(Object object) {
        int n;
        if (object != null) {
            this._textArea.setText(object.toString());
        } else {
            this._textArea.setText("");
        }
        int n2 = n = 3;
        if (object != null) {
            int n3 = ("" + object).trim().split("\n").length;
            n2 = Math.max(n, n3);
        }
        if (this._textArea instanceof AutoResizingTextArea) {
            ((AutoResizingTextArea)this._textArea).setMinRows(n);
            ((AutoResizingTextArea)this._textArea).setMaxRows(n2);
        } else {
            this._textArea.setRows(n);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (jTable != null) {
            JideSwingUtilities.installColorsAndFont(this._textArea, jTable.getBackground(), jTable.getForeground(), jTable.getFont());
        }
        this.setCellEditorValue(object);
        if (jTable != null) {
            this.customizeTextArea();
            jTable.setRowHeight(n, this._scrollPane.getPreferredSize().height);
        }
        if (this.getTextArea() != null && this.getEditorStyle() != 0) {
            this.getTextArea().setEditable(this.getEditorStyle() == 3);
        }
        return this._scrollPane;
    }

    public JTextArea getTextArea() {
        return this._textArea;
    }

    @Override
    public boolean isEditorStyleSupported(int n) {
        return n == 0 || n == 2 || n == 3;
    }
}

