/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DraggingTableHeader;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LegacySortableTableHeader
extends DraggingTableHeader {
    public LegacySortableTableHeader(SortableTable sortableTable) {
        super(sortableTable.getColumnModel());
        this.addMouseListener(sortableTable.getSortableHeaderMouseListener());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.customizeForSynthetica();
        super.paintComponent(graphics);
        this.paintSortArrows(graphics);
    }

    private void customizeForSynthetica() {
        SortableTable sortableTable = null;
        if (this.getTable() instanceof SortableTable) {
            sortableTable = (SortableTable)this.getTable();
        }
        if (sortableTable == null) {
            return;
        }
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", null);
            return;
        }
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        if (list.size() == 0) {
            sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", null);
            return;
        }
        int[] nArray = new int[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ISortableTableModel.SortItem sortItem = list.get(i);
            nArray[i] = sortableTable.convertColumnIndexToView(sortItem.getColumn());
        }
        sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", nArray);
        sortableTable.putClientProperty("SORTABLE_TABLE_PAINT_SORT_BACKGROUND", true);
    }

    protected void paintSortArrows(Graphics graphics) {
        SortableTable sortableTable = null;
        if (this.getTable() instanceof SortableTable) {
            sortableTable = (SortableTable)this.getTable();
        }
        if (sortableTable == null) {
            return;
        }
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            return;
        }
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        if (list.size() == 0) {
            return;
        }
        TableColumn tableColumn = this.getDraggedColumn();
        for (int i = 0; i < list.size(); ++i) {
            ISortableTableModel.SortItem sortItem = list.get(i);
            int n = sortItem.getColumn();
            if (n < 0) continue;
            boolean bl = false;
            if (tableColumn != null && tableColumn.getModelIndex() == n) {
                bl = true;
            }
            if ((n = sortableTable.convertColumnIndexToView(n)) == -1) continue;
            boolean bl2 = sortItem.isAscending();
            Rectangle rectangle = this.getHeaderRect(n);
            if (bl) {
                rectangle.x += this.getDraggedDistance();
            }
            this.paintSortArrow(this, sortableTable, graphics, rectangle, sortableTable.isShowSortOrderNumber() || list.size() > 1 ? i : -1, bl2);
        }
    }

    protected void paintSortArrow(JComponent jComponent, SortableTable sortableTable, Graphics graphics, Rectangle rectangle, int n, boolean bl) {
        Icon icon = this.createSortIcon(sortableTable, bl);
        boolean bl2 = sortableTable.isMultiColumnSortable();
        Color color = sortableTable.getSortOrderForeground() != null ? sortableTable.getSortOrderForeground() : jComponent.getForeground();
        Object object = UIDefaultsLookup.get("Theme.painter");
        if (object instanceof ThemePainter) {
            ((ThemePainter)object).paintSortableTableHeaderColumn(sortableTable.getTableHeader(), graphics, rectangle, 0, 0, bl ? 1 : 2, icon, n, color, bl2);
        }
    }

    protected Icon createSortIcon(SortableTable sortableTable, boolean bl) {
        return sortableTable.createSortIcon(bl);
    }

    private Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    @Override
    public int getPreferredHeight() {
        if (this._preferredHeight == -1) {
            this._preferredHeight = 0;
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                Component component = this.getHeaderRenderer(i);
                int n = component.getPreferredSize().height;
                this._preferredHeight = Math.max(this._preferredHeight, n);
            }
        }
        return this._preferredHeight;
    }

    public Dimension originalGetPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.originalGetPreferredSize();
        if (dimension.width == 0 || dimension.height == 0 || SystemInfo.isJdk15Above() && this.isPreferredSizeSet()) {
            return dimension;
        }
        return new Dimension(dimension.width, this.getPreferredHeight());
    }

    void clearPreferredSizeCache() {
        this._preferredHeight = -1;
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.clearPreferredSizeCache();
        super.columnAdded(tableColumnModelEvent);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.clearPreferredSizeCache();
        super.columnRemoved(tableColumnModelEvent);
    }
}

