/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.field.IPTextField;
import com.jidesoft.grid.AutoFillTableViewport;
import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.AutoFilterTableHeaderRenderer;
import com.jidesoft.grid.CellChangeEvent;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.ColumnWidthTableModel;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.DefaultTableSelectionModel;
import com.jidesoft.grid.DraggingTableHeader;
import com.jidesoft.grid.EditingNotStoppedException;
import com.jidesoft.grid.GridColorProvider;
import com.jidesoft.grid.GroupTableHeader;
import com.jidesoft.grid.HeaderStyleModel;
import com.jidesoft.grid.IndexChangeEvent;
import com.jidesoft.grid.IndexChangeEventGenerator;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.grid.JideCellEditor;
import com.jidesoft.grid.JideCellEditorListener;
import com.jidesoft.grid.JideTableTransferHandler;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.RendererWrapper;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.RowHeightChangeEvent;
import com.jidesoft.grid.RowHeightChangeListener;
import com.jidesoft.grid.RowHeights;
import com.jidesoft.grid.SortTableHeaderRenderer;
import com.jidesoft.grid.TableAdapter;
import com.jidesoft.grid.TableColumnAutoResizer;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableColumnGroup;
import com.jidesoft.grid.TableColumnResizer;
import com.jidesoft.grid.TableColumnWidthKeeper;
import com.jidesoft.grid.TableModelWrapperImpl;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableRowResizer;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.grid.TableSelectionEvent;
import com.jidesoft.grid.TableSelectionListener;
import com.jidesoft.grid.TableSelectionModel;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grid.ToolTipSupport;
import com.jidesoft.grid.TreeExpandablePanel;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grid.UndoableTableModelEvent;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.ExComboBoxUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.TableHeaderUIDelegate;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicCellStyleTableHeaderUIDelegate;
import com.jidesoft.swing.AutoCompletion;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.UndoableSupport;
import com.jidesoft.utils.BasicTransferable;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import com.jidesoft.utils.TypeUtils;
import com.jidesoft.validation.RowValidationObject;
import com.jidesoft.validation.RowValidator;
import com.jidesoft.validation.TableValidationObject;
import com.jidesoft.validation.ValidationResult;
import com.jidesoft.validation.Validator;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellEditor;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class JideTable
extends JTable
implements TableAdapter,
IndexChangeListener {
    private static final Logger LOGGER_EVENT;
    private static final String uiClassID = "JideTableUI";
    protected transient CellChangeEvent _cellChangeEvent = null;
    private boolean _rowAutoResizes = false;
    private boolean _nestedTableHeader = false;
    private boolean _disableUneditableCells = false;
    private Map<Integer, String> _fitted = new HashMap<Integer, String>();
    private boolean _tablePrinting;
    private int[] _autoResizeColumnWidths;
    @Deprecated
    public static final String ROW_AUTO_RESIZES_PROPERTY = "rowAutoResizes";
    public static final String PROPERTY_ROW_AUTO_RESIZES = "rowAutoResizes";
    public static final String PROPERTY_NON_CONTIGUOUS_CELL_SELECTION = "nonContiguousCellSelection";
    public static final String PROPERTY_TABLE_SELECTION_MODEL = "tableSelectionModel";
    public static final String PROPERTY_SCROLL_ROW_WHEN_ROW_HEIGHT_CHANGES = "scrollRowWhenRowHeightChanges";
    @Deprecated
    public static final String PROPERTY_CLEAR_SELECTION_ON_TABLE_DATA_CHANGES = "clearSelectionOnTableDataChanges";
    public static final String PROPERTY_LOAD_SELECTION_ON_TABLE_DATA_CHANGES = "loadSelectionOnTableDataChanges";
    public static final String PROPERTY_EDITOR_AUTO_COMPLETION_MODE = "editorAutoCompletionMode";
    public static final String PROPERTY_FILLS_RIGHT = "fillsRight";
    public static final String PROPERTY_FILLS_BOTTOM = "fillsBottom";
    public static final String PROPERTY_FILLS_GRIDS = "fillsGrids";
    public static final String CLIENT_PROPERTY_LAZY_CALCULATE_ROW_HEIGHT = "lazyCalculateRowHeight";
    public static final String ACTION_NAME_CANCEL_EDITING = "cancelEditing";
    public static final int AUTO_RESIZE_FILL = 256;
    @Deprecated
    public static final int AUTO_RESIZE_NEXT_COLUMN_FILL = 257;
    @Deprecated
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS_FILL = 258;
    @Deprecated
    public static final int AUTO_RESIZE_LAST_COLUMN_FILL = 259;
    @Deprecated
    public static final int AUTO_RESIZE_ALL_COLUMNS_FILL = 260;
    private AutoFillViewportListener _autoFillListener;
    private TableColumnModelListener _listener;
    private TableSelectionListener _selectionListener;
    private boolean _variousRowHeights = false;
    private boolean _variousRowHeightsSet = false;
    private boolean _selectInsertedRows = true;
    private RowHeightChangeListener _rowScroller;
    private boolean _clearSelectionOnTableDataChanges = false;
    private boolean _scrollRowWhenRowHeightChanges = false;
    private TableColumnWidthKeeper _tableColumnWidthKeeper;
    private boolean _autoStartCellEditing = false;
    private boolean _autoSelectTextWhenStartsEditing = true;
    protected int _clickCountToStart = 1;
    protected MouseMotionListener _headerDraggingMouseMotionListener;
    private TransferHandler _originalTransferHandler = null;
    private int[] _savedRowHeights;
    int[] _savedTableSelection;
    private boolean _indexChanging;
    private boolean _keepRowHeights = true;
    private boolean _dataOrStructureChangeProcessed;
    boolean _needLoadRowSettings;
    boolean _loadInsertedRowsOnly;
    private boolean _loadSelectionOnTableDataChanged;
    private boolean _calculateRowHeightsOnWidthChange = true;
    private boolean _alwaysRequestFocusForEditor = false;
    private boolean _couldStopEditing = true;
    private boolean _clearPropertyAtStructureChange = true;
    private boolean _enableIgnored = false;
    private boolean _autoResizeFillMode = false;
    private boolean _fillsRight = true;
    private boolean _fillsBottom = true;
    private boolean _fillsGrids = true;
    private boolean _restoreSelectionAndRowHeightAutomatically = true;
    public static final int EDITOR_AUTO_COMPLETION_MODE_NONE = 0;
    public static final int EDITOR_AUTO_COMPLETION_MODE_COLUMN = 1;
    public static final int EDITOR_AUTO_COMPLETION_MODE_ROW = 2;
    public static final int EDITOR_AUTO_COMPLETION_MODE_TABLE = 3;
    private int _editorAutoCompletionMode = 0;
    private PropertyChangeListener _tableColumnPropertyListener;
    private GridColorProvider _gridColorProvider;
    private boolean _adjustEditorLocationOnModelChanged = false;
    private List<Integer> _hiddenRows = null;
    private boolean _init;
    boolean _cellEditingStartedByKey = false;
    boolean _cellEditingStartedByF2Key = false;
    boolean _cellEditingStartedByDeleteBackspace = false;
    KeyEvent _editingKeyEvent = null;
    JTable _lastFocusTable = null;
    boolean _pageNavigationKeyProcessing = false;
    protected RowHeights _rowHeights;
    private long[] _rowHeightsValid;
    protected boolean _batchProcessing = false;
    private boolean _isEventInvokedOutside = false;
    private int _processingEventSerialNumber = -1;
    private List<Integer> _conflictEventSerialNumberList;
    boolean _avoidSelectionChange = false;
    private boolean _avoidRowHeightCalculation = false;
    private boolean _nonContiguousCellSelection = false;
    private TableSelectionModel _tableSelectionModel;
    private boolean _pending = false;
    private PropertyChangeListener _editorRemover = null;
    private PropertyChangeListener _focusLostRowValidator = null;
    protected PropertyChangeListener _rolloverEditorRemover = null;
    protected CellEditorListener _rolloverCellEditorListener;
    protected transient TableCellEditor _rolloverCellEditor = null;
    protected transient Component _rolloverEditorComp = null;
    protected transient int _rolloverRow = -1;
    protected transient int _rolloverColumn = -1;
    private int _currentRowIndex = -1;
    private ValidationResult _currentRowValidationResult = null;
    private boolean _columnSelectionAdjusting;
    protected TableColumnAutoResizer _columnAutoResizer = null;
    protected TableRowResizer _rowResizer = null;
    protected TableColumnResizer _columnResizer = null;
    private boolean _cellContentVisible = true;

    public JideTable() {
        this.initTable();
        this.initializeTable();
    }

    public JideTable(int n, int n2) {
        super(n, n2);
        this.initTable();
        this.initializeTable();
    }

    public JideTable(TableModel tableModel) {
        super(tableModel);
        this.initTable();
        this.initializeTable();
    }

    public JideTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initTable();
        this.initializeTable();
    }

    public JideTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initTable();
        this.initializeTable();
    }

    public JideTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initTable();
        this.initializeTable();
    }

    public JideTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initTable();
        this.initializeTable();
    }

    protected void initTable() {
    }

    private void initializeTable() {
        if (!this._init) {
            Serializable serializable;
            InputMap inputMap;
            if (this._headerDraggingMouseMotionListener == null) {
                this._headerDraggingMouseMotionListener = new MouseMotionAdapter(){

                    @Override
                    public void mouseDragged(MouseEvent mouseEvent) {
                        TableColumn tableColumn;
                        JTableHeader jTableHeader;
                        JTable jTable;
                        Object object = mouseEvent.getSource();
                        if (object instanceof JTableHeader && (jTable = (jTableHeader = (JTableHeader)object).getTable()).getAutoResizeMode() == 0 && (tableColumn = jTableHeader.getDraggedColumn()) != null) {
                            int n = jTable.convertColumnIndexToView(tableColumn.getModelIndex());
                            Rectangle rectangle = jTableHeader.getHeaderRect(n);
                            rectangle.x += jTableHeader.getDraggedDistance();
                            rectangle.y = jTable.getVisibleRect().y;
                            jTable.scrollRectToVisible(rectangle);
                        }
                    }
                };
            }
            this.getTableHeader().addMouseMotionListener(this._headerDraggingMouseMotionListener);
            this.addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getOldValue() instanceof JTableHeader) {
                        ((JTableHeader)propertyChangeEvent.getOldValue()).removeMouseMotionListener(JideTable.this._headerDraggingMouseMotionListener);
                    }
                    if (propertyChangeEvent.getNewValue() instanceof JTableHeader) {
                        ((JTableHeader)propertyChangeEvent.getNewValue()).addMouseMotionListener(JideTable.this._headerDraggingMouseMotionListener);
                    }
                }
            });
            if (this.getModel() instanceof TableModelWrapperImpl) {
                ((TableModelWrapperImpl)this.getModel()).addIndexChangeListener(this);
            }
            if ((inputMap = this.getInputMap(1)) != null) {
                inputMap.put(KeyStroke.getKeyStroke(27, 0), ACTION_NAME_CANCEL_EDITING);
                serializable = this.getActionMap();
                if (serializable != null) {
                    ((ActionMap)serializable).put(ACTION_NAME_CANCEL_EDITING, new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (JideTable.this.isEditing()) {
                                try {
                                    JideTable.this.getCellEditor().cancelCellEditing();
                                }
                                catch (Exception exception) {
                                    JideTable.this.removeEditor();
                                }
                            }
                        }

                        @Override
                        public boolean isEnabled() {
                            return super.isEnabled() && JideTable.this.isEditing();
                        }
                    });
                }
            }
            if ((serializable = this.getTransferHandler()) instanceof UIResource) {
                this._originalTransferHandler = serializable;
                this.setTransferHandler(this.createDefaultTransferHandler());
            }
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (JideTable.this.getUndoManager().canUndo()) {
                        JideTable.this.getUndoManager().undo();
                    } else {
                        PortingUtils.notifyUser(JideTable.this);
                    }
                }
            };
            AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (JideTable.this.getUndoManager().canRedo()) {
                        JideTable.this.getUndoManager().redo();
                    } else {
                        PortingUtils.notifyUser(JideTable.this);
                    }
                }
            };
            this.getActionMap().put("undo", abstractAction);
            this.getActionMap().put("redo", abstractAction2);
            if (this._tableColumnPropertyListener == null) {
                this._tableColumnPropertyListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        JTableHeader jTableHeader;
                        if ("headerValue".equals(propertyChangeEvent.getPropertyName()) && (jTableHeader = JideTable.this.getTableHeader()).getUI() instanceof DelegateTableHeaderUI) {
                            TableHeaderUIDelegate tableHeaderUIDelegate = ((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate();
                            if (tableHeaderUIDelegate instanceof BasicCellStyleTableHeaderUIDelegate) {
                                ((BasicCellStyleTableHeaderUIDelegate)tableHeaderUIDelegate).invalidateCache(true);
                                jTableHeader.revalidate();
                            }
                            jTableHeader.repaint();
                        }
                    }
                };
            }
            this._init = true;
        }
    }

    public void resetTransferHandler() {
        if (this._originalTransferHandler != null) {
            this.setTransferHandler(this._originalTransferHandler);
            this._originalTransferHandler = null;
        }
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (this.getModel() != null && this.getModel() instanceof IndexChangeEventGenerator) {
            ((IndexChangeEventGenerator)((Object)this.getModel())).removeIndexChangeListener(this);
        }
        super.setModel(tableModel);
        if (this.isVariousRowHeights()) {
            this.setRowHeights(this.createRowHeights());
        }
        if (this.getModel() != null && this.getModel() instanceof IndexChangeEventGenerator) {
            ((IndexChangeEventGenerator)((Object)this.getModel())).addIndexChangeListener(this);
        }
    }

    @Override
    public void setAutoResizeMode(int n) {
        if ((n & 0x100) != 0) {
            super.setAutoResizeMode(n & 0xFF);
            this._autoResizeFillMode = true;
            this.internalInstallAutoFill();
            this._autoFillListener = new AutoFillViewportListener();
            this.addHierarchyListener(this._autoFillListener);
        } else {
            Container container;
            super.setAutoResizeMode(n);
            this._autoResizeFillMode = false;
            if (this._autoFillListener != null) {
                this.removeHierarchyListener(this._autoFillListener);
                this._autoFillListener = null;
            }
            if ((container = this.getParent()) instanceof AutoFillTableViewport && container.getParent() instanceof JScrollPane) {
                this.internalUninstallAutoFill();
            }
        }
    }

    public boolean isAutoResizeFillMode() {
        return this._autoResizeFillMode;
    }

    public String getActualUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(this.getActualUIClassID()) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        try {
            Class<?> clazz = Class.forName(UIManager.getString(this.getActualUIClassID()));
            Class<JComponent> clazz2 = JComponent.class;
            Method method = clazz.getMethod("createUI", clazz2);
            if (method != null) {
                Object object = method.invoke(null, this);
                this.setUI((ComponentUI)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isNestedTableHeader() {
        return this._nestedTableHeader;
    }

    public void setNestedTableHeader(boolean bl) {
        this._nestedTableHeader = bl;
        this.setTableHeader(this.createDefaultTableHeader());
        this.configureEnclosingScrollPane();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        if (this.isNestedTableHeader()) {
            return new NestedTableHeader(this.getColumnModel()){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    String string = JideTable.this.getTableHeaderToolTipText(mouseEvent);
                    if (string != null) {
                        return string;
                    }
                    return super.getToolTipText(mouseEvent);
                }

                @Override
                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    JideTable.this.paintFillHeader(graphics);
                }
            };
        }
        return new DraggingTableHeader(this.getColumnModel()){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = JideTable.this.getTableHeaderToolTipText(mouseEvent);
                if (string != null) {
                    return string;
                }
                return super.getToolTipText(mouseEvent);
            }

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                JideTable.this.paintFillHeader(graphics);
            }
        };
    }

    protected void paintFillHeader(Graphics graphics) {
        AutoFillTableViewport autoFillTableViewport;
        if (this.getParent() instanceof AutoFillTableViewport && (autoFillTableViewport = (AutoFillTableViewport)this.getParent()) != null && this.getWidth() < autoFillTableViewport.getWidth()) {
            TableCellRenderer tableCellRenderer;
            Component component;
            int n = this.getComponentOrientation().isLeftToRight() ? this.getWidth() : 0;
            int n2 = autoFillTableViewport.getWidth() - this.getWidth();
            int n3 = this.getTableHeader().getHeight();
            int n4 = 0;
            if (this.getTableHeader() instanceof GroupTableHeader) {
                n4 = ((GroupTableHeader)this.getTableHeader()).getActualHeaderY();
                n3 = ((GroupTableHeader)this.getTableHeader()).getActualHeaderHeight();
            }
            if ((component = (tableCellRenderer = this.getTableHeader().getDefaultRenderer()).getTableCellRendererComponent(this, "", false, false, 0, -2)) instanceof AutoFilterTableHeaderRenderer) {
                ((AutoFilterTableHeaderRenderer)component).removeAll();
            }
            component.setBounds(n, n4, n2, n3);
            ((JComponent)component).setOpaque(false);
            CellRendererPane cellRendererPane = new CellRendererPane();
            if (this.getTableHeader() != null) {
                this.getTableHeader().add(cellRendererPane);
            }
            cellRendererPane.paintComponent(graphics, component, null, n, n4, n2, n3, true);
            if (this.getTableHeader() != null) {
                this.getTableHeader().remove(cellRendererPane);
            }
        }
    }

    public String getTableHeaderToolTipText(MouseEvent mouseEvent) {
        int n;
        int n2;
        Point point = mouseEvent.getPoint();
        if (this.getTableHeader() instanceof NestedTableHeader) {
            CellStyle cellStyle;
            int n3;
            NestedTableHeader nestedTableHeader = (NestedTableHeader)this.getTableHeader();
            n2 = nestedTableHeader.originalColumnAtPoint(point);
            int n4 = nestedTableHeader.rowAtPoint(point);
            TableColumnGroup tableColumnGroup = nestedTableHeader.getTableColumnGroup(n4, n2);
            if (tableColumnGroup != null && tableColumnGroup.getToolTipText() != null) {
                return tableColumnGroup.getToolTipText();
            }
            TableModel tableModel = this.getModel();
            HeaderStyleModel headerStyleModel = (HeaderStyleModel)((Object)TableModelWrapperUtils.getActualTableModel(tableModel, HeaderStyleModel.class));
            int n5 = this.convertColumnIndexToModel(n2);
            if (headerStyleModel != null && (n3 = TableModelWrapperUtils.getActualColumnAt(tableModel, n5, (TableModel)((Object)headerStyleModel))) >= 0 && n3 < ((TableModel)((Object)headerStyleModel)).getColumnCount() && (cellStyle = headerStyleModel.getHeaderStyleAt(n4, n3)) != null && cellStyle.getToolTipText() != null) {
                return cellStyle.getToolTipText();
            }
        } else {
            n2 = this.getTableHeader().columnAtPoint(point);
        }
        if (n2 != -1 && (n = this.convertColumnIndexToModel(n2)) != -1) {
            return this.getTableHeaderToolTipText(n);
        }
        return null;
    }

    public String getTableHeaderToolTipText(int n) {
        String string;
        int n2;
        CellStyle cellStyle;
        int n3;
        TableModel tableModel = this.getModel();
        HeaderStyleModel headerStyleModel = (HeaderStyleModel)((Object)TableModelWrapperUtils.getActualTableModel(tableModel, HeaderStyleModel.class));
        if (headerStyleModel != null && (n3 = TableModelWrapperUtils.getActualColumnAt(tableModel, n, (TableModel)((Object)headerStyleModel))) >= 0 && n3 < ((TableModel)((Object)headerStyleModel)).getColumnCount() && (cellStyle = headerStyleModel.getHeaderStyleAt(0, n3)) != null && cellStyle.getToolTipText() != null) {
            return cellStyle.getToolTipText();
        }
        ToolTipSupport toolTipSupport = (ToolTipSupport)((Object)TableModelWrapperUtils.getActualTableModel(tableModel, ToolTipSupport.class));
        if (toolTipSupport != null && (n2 = TableModelWrapperUtils.getActualColumnAt(tableModel, n, (TableModel)((Object)toolTipSupport))) >= 0 && n2 < ((TableModel)((Object)toolTipSupport)).getColumnCount() && (string = toolTipSupport.getToolTipText(n2)) != null && string.trim().length() != 0) {
            return string;
        }
        return null;
    }

    void inheritEditingFieldsFrom(JideTable jideTable) {
        this._cellEditingStartedByKey = jideTable._cellEditingStartedByKey;
        this._cellEditingStartedByF2Key = jideTable._cellEditingStartedByF2Key;
        this._cellEditingStartedByDeleteBackspace = jideTable._cellEditingStartedByDeleteBackspace;
        this._editingKeyEvent = jideTable._editingKeyEvent;
        this._lastFocusTable = jideTable;
    }

    void clearEditingFields() {
        this._cellEditingStartedByKey = false;
        this._cellEditingStartedByF2Key = false;
        this._cellEditingStartedByDeleteBackspace = false;
        this._editingKeyEvent = null;
        this._lastFocusTable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2;
        if (bl && (!this.isEditing() || this.isAutoStartCellEditingKey(keyStroke))) {
            if (!Character.isISOControl(keyEvent.getKeyChar())) {
                this._cellEditingStartedByKey = true;
            }
            this._cellEditingStartedByF2Key = keyStroke.getKeyCode() == 113;
            boolean bl3 = this._cellEditingStartedByDeleteBackspace = keyStroke.getKeyCode() == 127 || keyStroke.getKeyCode() == 8;
            if (this.isAutoStartCellEditing() && this.isAutoStartCellEditingKey(keyStroke)) {
                this._cellEditingStartedByKey = true;
                this._editingKeyEvent = keyEvent;
            }
        }
        this._pageNavigationKeyProcessing = this.isPageNavigationKey(keyEvent);
        try {
            bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
        finally {
            this._pageNavigationKeyProcessing = false;
        }
        this._editingKeyEvent = null;
        return bl2;
    }

    protected boolean isPageNavigationKey(KeyEvent keyEvent) {
        return (keyEvent.getKeyCode() == 34 || keyEvent.getKeyCode() == 33) && keyEvent.getModifiers() == 0;
    }

    @Override
    public void setTableHeader(JTableHeader jTableHeader) {
        JTableHeader jTableHeader2 = this.getTableHeader();
        if (jTableHeader2 != jTableHeader && jTableHeader2 != null) {
            Object object;
            this.getColumnModel().removeColumnModelListener(jTableHeader2);
            if (jTableHeader2 instanceof PropertyChangeListener) {
                this.removePropertyChangeListener("model", (PropertyChangeListener)((Object)jTableHeader2));
            }
            if (jTableHeader2.getUI() instanceof DelegateTableHeaderUI && (object = ((DelegateTableHeaderUI)((Object)jTableHeader2.getUI())).getHeaderUIDelegate()) != null) {
                ((TableHeaderUIDelegate)object).uninstallAllListeners();
            }
            if (jTableHeader2 instanceof AutoFilterTableHeader && (object = ((AutoFilterTableHeader)jTableHeader2).getFilterableTableModel()) != null) {
                object.removeFilterableTableModelListener((AutoFilterTableHeader)jTableHeader2);
            }
            if (jTableHeader2 instanceof NestedTableHeader) {
                ((NestedTableHeader)jTableHeader2).uninstallAllGroupListeners();
            }
        }
        super.setTableHeader(jTableHeader);
        this.configureEnclosingScrollPane();
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        final boolean bl = this._cellEditingStartedByF2Key;
        this._cellEditingStartedByF2Key = false;
        boolean bl2 = this._cellEditingStartedByKey;
        this._cellEditingStartedByKey = false;
        final boolean bl3 = this._cellEditingStartedByDeleteBackspace;
        this._cellEditingStartedByDeleteBackspace = false;
        if (this.startCellEditing(tableCellEditor, n, n2)) {
            final Component component = super.prepareEditor(tableCellEditor, n, n2);
            final JTextComponent jTextComponent = this.getTextComponentForEditorComponent(component);
            if (jTextComponent != null) {
                Object object;
                if (this.getEditorAutoCompletionMode(n, n2) != 0 && (object = AutoCompletion.getAutoCompletion(jTextComponent)) == null) {
                    Object[] objectArray = this.getAutoCompletionList(n, n2);
                    object = this.createCellAutoCompletion(jTextComponent, objectArray);
                    ((AutoCompletion)object).setStrict(false);
                    ((AutoCompletion)object).setStrictCompletion(false);
                }
                if (bl2) {
                    if (!bl && this.isAutoSelectTextWhenStartsEditing()) {
                        jTextComponent.selectAll();
                    }
                    if (this.isAlwaysRequestFocusForEditor()) {
                        object = new Runnable(){

                            @Override
                            public void run() {
                                jTextComponent.requestFocus();
                            }
                        };
                        SwingUtilities.invokeLater((Runnable)object);
                    }
                } else {
                    object = new Runnable(){

                        @Override
                        public void run() {
                            if (JideTable.this.isAlwaysRequestFocusForEditor() || bl3 || component != jTextComponent && (!(component instanceof AbstractComboBox) || ((AbstractComboBox)component).isEditable())) {
                                jTextComponent.requestFocus();
                            }
                            if (!bl && JideTable.this.isAutoSelectTextWhenStartsEditing()) {
                                jTextComponent.selectAll();
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread() && bl3 && !bl && this.isAutoSelectTextWhenStartsEditing()) {
                        jTextComponent.selectAll();
                    }
                    SwingUtilities.invokeLater((Runnable)object);
                }
            } else if (component != null) {
                if (bl2) {
                    if (component instanceof JPanel && ((JPanel)component).getComponentCount() >= 1 && ((JPanel)component).getComponent(0) instanceof IPTextField) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                ((JComponent)component).getComponent(0).requestFocus();
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    } else {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                component.requestFocus();
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                } else if (this.isAlwaysRequestFocusForEditor()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            component.requestFocus();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
            return component;
        }
        return null;
    }

    protected AutoCompletion createCellAutoCompletion(JTextComponent jTextComponent, Object[] objectArray) {
        return new CellAutoCompletion(jTextComponent, objectArray);
    }

    Object[] getAutoCompletionList(int n, int n2) {
        int n3;
        int n4 = this.getEditorAutoCompletionMode(n, n2);
        if (n4 == 0) {
            return new Object[0];
        }
        HashSet<String> hashSet = new HashSet<String>();
        switch (n4) {
            case 1: {
                int n5;
                if (n2 < 0 || n2 >= this.getColumnCount()) break;
                n3 = this.getRowCount();
                for (n5 = 0; n5 < n3; ++n5) {
                    Object object = this.getValueAt(n5, n2);
                    if (object == null) continue;
                    hashSet.add(this.convertElementToString(object, n5, n2));
                }
                break;
            }
            case 2: {
                int n5;
                if (n < 0 || n2 >= this.getRowCount()) break;
                n3 = this.getColumnCount();
                for (n5 = 0; n5 < n3; ++n5) {
                    Object object = this.getValueAt(n, n5);
                    if (object == null) continue;
                    hashSet.add(this.convertElementToString(object, n, n5));
                }
                break;
            }
            case 3: {
                int n5;
                n3 = this.getRowCount();
                for (n5 = 0; n5 < n3; ++n5) {
                    int n6 = this.getColumnCount();
                    for (int i = 0; i < n6; ++i) {
                        Object object = this.getValueAt(n5, i);
                        if (object == null) continue;
                        hashSet.add(this.convertElementToString(object, n5, i));
                    }
                }
                break;
            }
        }
        Object[] objectArray = new Object[hashSet.size()];
        n3 = 0;
        for (Object e : hashSet) {
            objectArray[n3] = e;
            ++n3;
        }
        if (objectArray.length >= 2) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    protected String convertElementToString(Object object, int n, int n2) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public JTextComponent getTextComponentForEditorComponent(Component component) {
        if (component instanceof TextComponentProvider) {
            return ((TextComponentProvider)((Object)component)).getTextComponent();
        }
        if (component instanceof JTextComponent) {
            return (JTextComponent)component;
        }
        if (component instanceof JComboBox && ((JComboBox)component).getEditor().getEditorComponent() instanceof JTextComponent) {
            if (((JComboBox)component).isEditable()) {
                return (JTextComponent)((JComboBox)component).getEditor().getEditorComponent();
            }
            return null;
        }
        if (component instanceof AbstractComboBox && ((AbstractComboBox)component).getEditor().getEditorComponent() instanceof JTextComponent) {
            return (JTextComponent)((AbstractComboBox)component).getEditor().getEditorComponent();
        }
        if (component instanceof JSpinner && ((JSpinner)component).getEditor() instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)((JSpinner)component).getEditor()).getTextField();
        }
        if (component != null) {
            return (JTextComponent)JideSwingUtilities.getRecursively(component, new JideSwingUtilities.GetHandler(){

                @Override
                public boolean condition(Component component) {
                    return component instanceof JTextComponent;
                }

                @Override
                public Component action(Component component) {
                    return component;
                }
            });
        }
        return null;
    }

    protected boolean startCellEditing(CellEditor cellEditor, int n, int n2) {
        if (this.fireEditingStarting(cellEditor, n, n2)) {
            this.fireEditingStarted(cellEditor, n, n2);
            return true;
        }
        return false;
    }

    protected boolean fireEditingStarting(Object object, int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != JideCellEditorListener.class) continue;
            this.initCellChangeEvent(object);
            this._cellChangeEvent.setRow(n);
            this._cellChangeEvent.setColumn(n2);
            if (((JideCellEditorListener)objectArray[i + 1]).editingStarting(this._cellChangeEvent)) continue;
            return false;
        }
        return true;
    }

    protected void fireEditingStarted(Object object, int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != JideCellEditorListener.class) continue;
            this.initCellChangeEvent(object);
            this._cellChangeEvent.setRow(n);
            this._cellChangeEvent.setColumn(n2);
            ((JideCellEditorListener)objectArray[i + 1]).editingStarted(this._cellChangeEvent);
        }
    }

    public void addCellEditorListener(JideCellEditorListener jideCellEditorListener) {
        this.listenerList.add(JideCellEditorListener.class, jideCellEditorListener);
    }

    public void removeCellEditorListener(JideCellEditorListener jideCellEditorListener) {
        this.listenerList.remove(JideCellEditorListener.class, jideCellEditorListener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
    }

    public void addValidator(Validator validator) {
        this.listenerList.add(Validator.class, validator);
    }

    public void removeValidator(Validator validator) {
        this.listenerList.remove(Validator.class, validator);
    }

    public Validator[] getValidator() {
        return (Validator[])this.listenerList.getListeners(Validator.class);
    }

    public ValidationResult validate(int n, int n2, Object object, Object object2) {
        Object object3 = object2;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != Validator.class) continue;
            TableValidationObject tableValidationObject = new TableValidationObject(this, object, object3, n, n2);
            ValidationResult validationResult = ((Validator)objectArray[i + 1]).validating(tableValidationObject);
            if (validationResult != null && !validationResult.isValid()) {
                return validationResult;
            }
            if (validationResult == null || validationResult.getNewValue() == null) continue;
            object3 = validationResult.getNewValue();
        }
        if (!JideSwingUtilities.equals(object2, object3)) {
            ValidationResult validationResult = new ValidationResult(true);
            validationResult.setNewValue(object3);
            return validationResult;
        }
        return null;
    }

    public void addRowValidator(RowValidator rowValidator) {
        this.listenerList.add(RowValidator.class, rowValidator);
    }

    public void removeRowValidator(RowValidator rowValidator) {
        this.listenerList.remove(RowValidator.class, rowValidator);
    }

    public RowValidator[] getRowValidator() {
        return (RowValidator[])this.listenerList.getListeners(RowValidator.class);
    }

    public ValidationResult validateRow(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            RowValidationObject rowValidationObject;
            ValidationResult validationResult;
            if (objectArray[i] != RowValidator.class || (validationResult = ((RowValidator)objectArray[i + 1]).validating(rowValidationObject = new RowValidationObject(this, n))) == null || validationResult.isValid()) continue;
            return validationResult;
        }
        return null;
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this._couldStopEditing = true;
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            int n = this.editingRow;
            int n2 = this.editingColumn;
            Object object = this.getValueAt(n, n2);
            Object object2 = tableCellEditor.getCellEditorValue();
            if (this.fireEditingStopping(tableCellEditor, n, n2)) {
                ValidationResult validationResult = null;
                if (tableCellEditor instanceof JideCellEditor) {
                    validationResult = ((JideCellEditor)((Object)tableCellEditor)).validate(object, object2);
                }
                if (validationResult != null && validationResult.getNewValue() != null && (object2 = validationResult.getNewValue()) == ValidationResult.NULL_VALUE) {
                    object2 = null;
                }
                if (validationResult == null || validationResult.isValid()) {
                    validationResult = this.validate(n, n2, object, object2);
                }
                if (validationResult != null && !validationResult.isValid()) {
                    PortingUtils.notifyUser();
                    switch (validationResult.getFailBehavior()) {
                        case 0: {
                            object2 = object;
                            break;
                        }
                        case 2: {
                            object2 = null;
                            break;
                        }
                        default: {
                            this._couldStopEditing = false;
                            throw new EditingNotStoppedException(tableCellEditor, validationResult);
                        }
                    }
                }
                if (validationResult != null && validationResult.getNewValue() != null && (object2 = validationResult.getNewValue()) == ValidationResult.NULL_VALUE) {
                    object2 = null;
                }
                this.setValueAt(object2, n, n2);
                this.removeEditor();
                this.fireEditingStopped(tableCellEditor, n, n2);
            }
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        this.removeEditor();
        if (tableCellEditor != null) {
            this.fireEditingCanceled(tableCellEditor, this.editingRow, this.editingColumn);
        }
    }

    private void initCellChangeEvent(Object object) {
        if (this._cellChangeEvent == null || this._cellChangeEvent.getSource() != object) {
            this._cellChangeEvent = new CellChangeEvent(object);
        }
    }

    protected boolean fireEditingStopping(Object object, int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != JideCellEditorListener.class) continue;
            this.initCellChangeEvent(object);
            this._cellChangeEvent.setRow(n);
            this._cellChangeEvent.setColumn(n2);
            if (((JideCellEditorListener)objectArray[i + 1]).editingStopping(this._cellChangeEvent)) continue;
            return false;
        }
        return true;
    }

    protected void fireEditingStopped(Object object, int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != JideCellEditorListener.class) continue;
            this.initCellChangeEvent(object);
            this._cellChangeEvent.setRow(n);
            this._cellChangeEvent.setColumn(n2);
            ((JideCellEditorListener)objectArray[i + 1]).editingStopped(this._cellChangeEvent);
        }
    }

    protected void fireEditingCanceled(Object object, int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != JideCellEditorListener.class) continue;
            this.initCellChangeEvent(object);
            this._cellChangeEvent.setRow(n);
            this._cellChangeEvent.setColumn(n2);
            ((JideCellEditorListener)objectArray[i + 1]).editingCanceled(this._cellChangeEvent);
        }
    }

    private boolean isRowHeightValid(int n) {
        if (n < 0 || n >= this.getRowCount() || !this.isRowAutoResizes()) {
            return true;
        }
        if (this._rowHeightsValid == null) {
            return true;
        }
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        return n2 < this._rowHeightsValid.length && (this._rowHeightsValid[n2] & 1L << n3) != 0L;
    }

    private void setRowHeightValid(int n) {
        if (n < 0 || n >= this.getRowCount() || !this.isRowAutoResizes()) {
            return;
        }
        if (this._rowHeightsValid == null) {
            this.clearRowHeightsValidity();
        }
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        if (n2 >= this._rowHeightsValid.length) {
            this.clearRowHeightsValidity();
        }
        int n4 = n2;
        this._rowHeightsValid[n4] = this._rowHeightsValid[n4] | 1L << n3;
    }

    public synchronized RowHeights getRowHeights() {
        if (this._rowHeights == null) {
            this.setRowHeights(this.createRowHeights());
        }
        return this._rowHeights;
    }

    RowHeights internalGetRowHeights() {
        return this._rowHeights;
    }

    protected RowHeights createRowHeights() {
        return new RowHeights(this.getRowCount(), this.getRowHeight());
    }

    public synchronized void setRowHeights(RowHeights rowHeights) {
        RowHeights rowHeights2 = this._rowHeights;
        if (rowHeights != rowHeights2) {
            if (this._rowScroller != null && this._rowHeights != null) {
                this._rowHeights.removeRowHeightChangeListener(this._rowScroller);
            }
            this._rowHeights = rowHeights;
            if (this._rowScroller == null) {
                this._rowScroller = this.createRowAutoScrollingListener();
            }
            if (this._rowHeights != null && this._rowScroller != null) {
                this._rowHeights.addRowHeightChangeListener(this._rowScroller);
            }
            this.firePropertyChange("rowHeights", rowHeights2, this._rowHeights);
            this.repaint();
        }
    }

    public boolean isScrollRowWhenRowHeightChanges() {
        return this._scrollRowWhenRowHeightChanges;
    }

    public void setScrollRowWhenRowHeightChanges(boolean bl) {
        boolean bl2 = this._scrollRowWhenRowHeightChanges;
        if (bl2 != bl) {
            this._scrollRowWhenRowHeightChanges = bl;
            this.firePropertyChange(PROPERTY_SCROLL_ROW_WHEN_ROW_HEIGHT_CHANGES, bl2, bl);
        }
    }

    protected RowHeightChangeListener createRowAutoScrollingListener() {
        return new RowHeightChangeListener(){

            @Override
            public void rowHeightChanged(RowHeightChangeEvent rowHeightChangeEvent) {
                if (JideTable.this.isScrollRowWhenRowHeightChanges()) {
                    int n = rowHeightChangeEvent.getLastRow();
                    JideTable.this.scrollRowToVisible(n);
                }
            }
        };
    }

    public void scrollRowToVisible(int n) {
        TableUtils.ensureRowVisible(this, n);
    }

    @Override
    public void setRowHeight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("New row height is less than 0");
        }
        this.setRowHeights(null);
        super.setRowHeight(n);
        this.resizeAndRepaint();
    }

    void setSuperRowHeight(int n) {
        super.setRowHeight(n);
    }

    protected boolean isBatchProcessing() {
        return this._batchProcessing;
    }

    protected void setBatchProcessing(boolean bl) {
        this._batchProcessing = bl;
    }

    @Override
    public void setRowHeight(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("New row height is less than 0");
        }
        if (this.internalGetRowHeights() == null && n2 == this.getRowHeight()) {
            return;
        }
        if (this.getRowHeights().getRowHeight(n) != n2) {
            this._variousRowHeights = true;
            this.getRowHeights().setRowHeight(n, n2);
            if (this._savedRowHeights != null) {
                int n3;
                int n4 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n);
                for (n3 = 2; n3 < this._savedRowHeights.length && this._savedRowHeights[n3] != n4; n3 += 2) {
                }
                if (n3 < this._savedRowHeights.length) {
                    this._savedRowHeights[n3 + 1] = n2;
                } else {
                    int[] nArray = new int[this._savedRowHeights.length + 2];
                    int n5 = this._savedRowHeights.length;
                    System.arraycopy(this._savedRowHeights, 0, nArray, 0, n5);
                    nArray[n5] = n4;
                    nArray[n5 + 1] = n2;
                    this._savedRowHeights = nArray;
                }
            }
            if (!this._batchProcessing) {
                this.resizeAndRepaint();
            }
        }
    }

    @Deprecated
    protected void calculateAutoResizedRowHeights(int n, int n2) {
        TableUtils.autoResizeRows(this, n, n2);
    }

    @Deprecated
    protected void calculateAutoResizedRowHeights() {
        this.calculateAutoResizedRowHeights(0, this.getRowCount() - 1);
    }

    protected int calculateRowHeight(int n) {
        int n2 = this.getRowHeight(n);
        if (n2 == 0) {
            n2 = this.getRowHeight();
        }
        int n3 = 0;
        int n4 = this.getColumnCount();
        for (int i = 0; i < n4; ++i) {
            int n5 = this.getPreferredHeight(n, i);
            if (n5 <= n3) continue;
            n3 = n5;
        }
        n3 = n4 > 0 && n3 != 0 ? (n3 += this.getIntercellSpacing().height) : n2;
        return n3;
    }

    void setAutoResizeColumnWidths(int[] nArray) {
        if (nArray == null) {
            this._autoResizeColumnWidths = null;
        } else {
            TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel());
            this._autoResizeColumnWidths = new int[tableModel.getColumnCount()];
            for (int i = 0; i < nArray.length && i < this.getColumnCount(); ++i) {
                int n = TableModelWrapperUtils.getActualColumnAt(this.getModel(), this.convertColumnIndexToModel(i));
                if (n < 0 || n >= tableModel.getColumnCount()) continue;
                this._autoResizeColumnWidths[n] = nArray[i];
            }
        }
    }

    int getPreferredHeight(int n, int n2) {
        int n3 = this.getRowHeight(n);
        if (n3 == 0) {
            n3 = this.getRowHeight();
        }
        TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
        int n4 = this.getCellRect((int)n, (int)n2, (boolean)false).width;
        Component component = this.prepareRendererForRowHeightCalculation(tableCellRenderer, n, n2);
        if (component instanceof TreeExpandablePanel) {
            ((TreeExpandablePanel)component).setColumnWidth(-1);
        }
        component.setBounds(0, 0, 0, 0);
        if (this._autoResizeColumnWidths == null || n2 < 0 || n2 >= this._autoResizeColumnWidths.length || Math.abs(this._autoResizeColumnWidths[n2] - n4) > 5) {
            if (component instanceof TreeExpandablePanel) {
                ((TreeExpandablePanel)component).setColumnWidth(n4);
            }
            component.setBounds(0, 0, n4, n3);
        }
        int n5 = component.getPreferredSize().height;
        this.internalReleaseRendererComponent(tableCellRenderer, n, n2, component, true);
        return n5;
    }

    protected boolean isRowHeightChanged(int n, int n2) {
        int n3 = this.getRowHeights().getRowHeight(n);
        return n3 != n2;
    }

    @Override
    public int getRowHeight(int n) {
        if (this.isVariousRowHeights()) {
            if (!this.isRowHeightValid(n) && this.getColumnCount() > 0) {
                this.getCellRect(n, 0, false);
            }
            if (this.isRowHeightValid(n)) {
                return this.getRowHeights().getRowHeight(n);
            }
        } else if (this.isRowHidden(n)) {
            return 0;
        }
        return this.getRowHeight();
    }

    void clearRowHeightsValidity() {
        if (this.isRowAutoResizes()) {
            this._rowHeightsValid = new long[(this.getRowCount() >> 6) + 1];
            Arrays.fill(this._rowHeightsValid, 0L);
            Object object = this.getClientProperty(CLIENT_PROPERTY_LAZY_CALCULATE_ROW_HEIGHT);
            if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
                for (int i = this.getRowCount() - 1; i >= 0; --i) {
                    this.getCellRect(i, 0, false);
                }
                for (Container container = this.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
                    container.invalidate();
                    container.repaint();
                }
            }
        }
    }

    private int getFirstInvalidRowBetween(int n, int n2) {
        int n3;
        long l;
        if (this._rowHeightsValid == null || n >= n2) {
            return -1;
        }
        int n4 = n >> 6;
        int n5 = n2 >> 6;
        if (n4 >= this._rowHeightsValid.length) {
            return -1;
        }
        if (n4 >= 0 && (l = this._rowHeightsValid[n4]) != -1L) {
            int n6 = n & 0x3F;
            for (int i = n6 + 1; i <= 63; ++i) {
                if ((this._rowHeightsValid[n4] & 1L << i) != 0L) continue;
                return n + (i - n6);
            }
        }
        for (n3 = Math.max(0, n4 + 1); n3 <= n5 && n3 < this._rowHeightsValid.length && this._rowHeightsValid[n3] == -1L; ++n3) {
        }
        if (n3 > n5 || n3 >= this._rowHeightsValid.length) {
            return -1;
        }
        for (int i = 0; i <= (n3 == n5 ? (n2 & 0x3F) - 1 : 63); ++i) {
            if ((this._rowHeightsValid[n3] & 1L << i) != 0L) continue;
            return (n3 << 6) + i;
        }
        return -1;
    }

    @Override
    public int rowAtPoint(Point point) {
        int n;
        int n2 = point.y;
        int n3 = n = this.isVariousRowHeights() && this._rowHeights != null ? this._rowHeights.getRowIndex(n2) : n2 / this.getRowHeight();
        if (n < 0) {
            return -1;
        }
        int n4 = this.getRowCount();
        if (n >= n4) {
            return -1;
        }
        if (!this.isRowAutoResizes() && !this.isVariousRowHeights() && this._hiddenRows != null) {
            int n5 = n + this.getHiddenRowCountBeforeRow(n);
            while (true) {
                int n6;
                if ((n6 = JideSwingUtilities.binarySearch(this._hiddenRows, Integer.valueOf(n5))) > 0) {
                    ++n5;
                    continue;
                }
                if (n6 == 0 && this._hiddenRows.size() > 0 && this._hiddenRows.get(0) == n5) {
                    ++n5;
                    continue;
                }
                if (n5 + n6 >= n) break;
                n5 += n - (n5 + n6);
            }
            if (n5 >= n4) {
                n5 = -1;
            }
            n = n5;
        }
        return n;
    }

    @Override
    public Rectangle getCellRect(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        Rectangle rectangle = new Rectangle();
        if (this.isRowAutoResizes() && !this.isRowHeightValid(n) && n >= 0 && n < this.getRowCount()) {
            if (this._avoidRowHeightCalculation && this.getColumnCount() != this.getModel().getColumnCount()) {
                rectangle.height = this.getRowHeight();
                rectangle.y = n * rectangle.height;
            } else {
                this.recalculateAndResizeRow(n);
                n5 = this.getFirstInvalidRowBetween(-1, n);
                while (n5 >= 0 && n5 < n) {
                    this.recalculateAndResizeRow(n5);
                    n5 = this.getFirstInvalidRowBetween(n5 + 1, n);
                }
            }
        }
        n5 = 1;
        if (n < 0) {
            n5 = 0;
        } else if (n >= this.getRowCount()) {
            rectangle.y = this.getHeight();
            n5 = 0;
        } else if (rectangle.height <= 0) {
            rectangle.height = this.getRowHeight(n);
            if (this.isVariousRowHeights() && this._rowHeights != null) {
                rectangle.y = this._rowHeights.getRowPosition(n);
            } else if (this._hiddenRows != null) {
                n4 = this.getHiddenRowCountBeforeRow(n);
                rectangle.y = (n - n4) * (rectangle.height > 0 ? rectangle.height : this.getRowHeight());
                if (rectangle.y < 0) {
                    rectangle.y = 0;
                }
            } else {
                rectangle.y = n * rectangle.height;
            }
        }
        if (n2 < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
            n5 = 0;
        } else if (n2 >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
            n5 = 0;
        } else {
            TableColumnModel tableColumnModel = this.getColumnModel();
            if (this.getComponentOrientation().isLeftToRight()) {
                for (n3 = 0; n3 < n2; ++n3) {
                    rectangle.x += tableColumnModel.getColumn(n3).getWidth();
                }
            } else {
                for (n3 = tableColumnModel.getColumnCount() - 1; n3 > n2; --n3) {
                    rectangle.x += tableColumnModel.getColumn(n3).getWidth();
                }
            }
            rectangle.width = tableColumnModel.getColumn(n2).getWidth();
        }
        if (n5 != 0 && !bl) {
            n4 = Math.min(this.getRowMargin(), rectangle.height);
            n3 = Math.min(this.getColumnModel().getColumnMargin(), rectangle.width);
            rectangle.setBounds(rectangle.x + n3 / 2, rectangle.y + n4 / 2, rectangle.width - n3, rectangle.height - n4);
        }
        return rectangle;
    }

    private void recalculateAndResizeRow(int n) {
        this.setRowHeightValid(n);
        int n2 = this.calculateRowHeight(n);
        if (this.getClientProperty("TableScrollPane.Parent") instanceof TableScrollPane) {
            TableScrollPane tableScrollPane = (TableScrollPane)this.getClientProperty("TableScrollPane.Parent");
            JTable[] jTableArray = new JTable[3];
            if (this == tableScrollPane.getRowHeaderTable() || this == tableScrollPane.getMainTable() || this == tableScrollPane.getRowFooterTable()) {
                jTableArray[0] = tableScrollPane.getRowHeaderTable();
                jTableArray[1] = tableScrollPane.getMainTable();
                jTableArray[2] = tableScrollPane.getRowFooterTable();
            } else {
                jTableArray[0] = tableScrollPane.getRowHeaderColumnFooterTable();
                jTableArray[1] = tableScrollPane.getColumnFooterTable();
                jTableArray[2] = tableScrollPane.getRowFooterColumnFooterTable();
            }
            for (JTable jTable : jTableArray) {
                int n3;
                if (jTable == this || jTable == null || (n3 = TableUtils.calculateRowHeight(jTable, n, 1)) <= n2) continue;
                n2 = n3;
            }
        }
        if (n2 > 0) {
            this.resizeTableRowHeight(n, n2);
        }
    }

    void resizeTableRowHeight(int n, int n2) {
        this.setRowHeight(n, n2);
    }

    public Rectangle getEditorCellRect(int n, int n2) {
        return this.getCellRect(n, n2, false);
    }

    private void clearSelectionAndLeadAnchor() {
        this.selectionModel.setValueIsAdjusting(true);
        this.columnModel.getSelectionModel().setValueIsAdjusting(true);
        if (this.isNonContiguousCellSelection()) {
            this.getTableSelectionModel().setValueAdjusting(true);
        }
        this.clearSelection();
        if (this.isNonContiguousCellSelection()) {
            this.getTableSelectionModel().clearSelection();
        }
        this.selectionModel.setAnchorSelectionIndex(-1);
        this.selectionModel.setLeadSelectionIndex(-1);
        this.columnModel.getSelectionModel().setAnchorSelectionIndex(-1);
        this.columnModel.getSelectionModel().setLeadSelectionIndex(-1);
        this.selectionModel.setValueIsAdjusting(false);
        this.columnModel.getSelectionModel().setValueIsAdjusting(false);
        if (this.isNonContiguousCellSelection()) {
            this.getTableSelectionModel().setValueAdjusting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDefaultColumnsFromModel() {
        TableScrollPane tableScrollPane;
        TableColumnWidthKeeper tableColumnWidthKeeper = this.getTableColumnWidthKeeper();
        Object object = null;
        if (tableColumnWidthKeeper != null) {
            object = tableColumnWidthKeeper.saveTableColumnWidth(this);
        }
        Object object2 = this.getClientProperty("TableScrollPane.Parent");
        try {
            if (object2 instanceof TableScrollPane) {
                tableScrollPane = (TableScrollPane)object2;
                tableScrollPane.setBatching(true);
            }
            super.createDefaultColumnsFromModel();
        }
        catch (Throwable throwable) {
            if (object2 instanceof TableScrollPane) {
                TableScrollPane tableScrollPane2 = (TableScrollPane)object2;
                tableScrollPane2.setBatching(false);
                for (JTable jTable : tableScrollPane2.getAllChildTablesList()) {
                    jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
                    tableScrollPane2.resizeTableToFit(jTable, jTable != tableScrollPane2.getMainTable() && jTable != tableScrollPane2.getColumnFooterTable() && jTable != tableScrollPane2.getColumnHeaderTable());
                }
            }
            throw throwable;
        }
        if (object2 instanceof TableScrollPane) {
            tableScrollPane = (TableScrollPane)object2;
            tableScrollPane.setBatching(false);
            for (JTable jTable : tableScrollPane.getAllChildTablesList()) {
                jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
                tableScrollPane.resizeTableToFit(jTable, jTable != tableScrollPane.getMainTable() && jTable != tableScrollPane.getColumnFooterTable() && jTable != tableScrollPane.getColumnHeaderTable());
            }
        }
        if (tableColumnWidthKeeper != null) {
            tableColumnWidthKeeper.restoreTableColumnWidth(this, object);
        }
    }

    public void setKeepRowHeights(boolean bl) {
        this._keepRowHeights = bl;
    }

    public boolean isKeepRowHeights() {
        return this._keepRowHeights;
    }

    private void setIndexChanging(boolean bl) {
        this._indexChanging = bl;
    }

    private boolean isIndexChanging() {
        return this._indexChanging;
    }

    private int[] mergeSavedTableSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null || nArray.length <= 4) {
            return nArray2;
        }
        if (!this.isNonContiguousCellSelection() && this.getColumnSelectionAllowed() && !this.getRowSelectionAllowed()) {
            return nArray2;
        }
        if (nArray2 == null || nArray2.length < 4) {
            return nArray;
        }
        if (!this.isNonContiguousCellSelection() && !this.getColumnSelectionAllowed() && this.getRowSelectionAllowed()) {
            int n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[] nArray3 = new int[nArray2.length - 4];
            System.arraycopy(nArray2, 4, nArray3, 0, nArray2.length - 4);
            Arrays.sort(nArray3);
            for (int i = 4; i < nArray.length; ++i) {
                n2 = JideSwingUtilities.binarySearch(nArray3, nArray[i]);
                if (n2 >= 0 && (n2 != 0 || nArray[i] == nArray3[0])) continue;
                arrayList.add(nArray[i]);
            }
            int[] nArray4 = new int[nArray2.length + arrayList.size()];
            System.arraycopy(nArray2, 0, nArray4, 0, nArray2.length);
            n2 = nArray2.length;
            int n3 = 0;
            while (n2 < nArray4.length) {
                nArray4[n2] = (Integer)arrayList.get(n3);
                ++n2;
                ++n3;
            }
            return nArray4;
        }
        Object[] objectArray = new SavedRowInfo[nArray2.length / 2 - 2];
        for (int i = 4; i < nArray2.length; i += 2) {
            objectArray[i / 2 - 2] = new SavedRowInfo(nArray2[i], nArray2[i + 1], true);
        }
        Arrays.sort(objectArray);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(objectArray));
        for (int i = 4; i < nArray.length - 1; i += 2) {
            if (nArray[i] < 0) continue;
            SavedRowInfo savedRowInfo = new SavedRowInfo(nArray[i], nArray[i + 1], false);
            n = JideSwingUtilities.binarySearch(arrayList, savedRowInfo);
            boolean bl = true;
            if (n <= 0) {
                boolean bl2 = bl = n == 0 && arrayList.size() >= 1 && JideSwingUtilities.equals(arrayList.get(0), savedRowInfo);
            }
            if (bl) continue;
            arrayList.add(-n, savedRowInfo);
        }
        int[] nArray5 = new int[4 + arrayList.size() * 2];
        System.arraycopy(nArray2, 0, nArray5, 0, 4);
        int n4 = 4;
        n = 0;
        while (n4 < nArray5.length) {
            SavedRowInfo savedRowInfo = (SavedRowInfo)arrayList.get(n);
            nArray5[n4] = savedRowInfo._rowIndex;
            nArray5[n4 + 1] = savedRowInfo._rowInfo;
            n4 += 2;
            ++n;
        }
        return nArray5;
    }

    private Row[] mergeSavedTreeTableSelection(Row[] rowArray, Row[] rowArray2) {
        if (rowArray == null) {
            return rowArray2;
        }
        if (rowArray2 == null) {
            return rowArray;
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        for (Row row : rowArray) {
            boolean bl = false;
            for (Row row2 : rowArray2) {
                if (row != row2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(row);
        }
        Row[] rowArray3 = new Row[rowArray2.length + arrayList.size()];
        System.arraycopy(rowArray2, 0, rowArray3, 0, rowArray2.length);
        int n = rowArray2.length;
        int n2 = 0;
        while (n < rowArray3.length) {
            rowArray3[n] = (Row)arrayList.get(n2);
            ++n;
            ++n2;
        }
        return rowArray3;
    }

    private int[] mergeSavedRowHeights(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray.length <= 2) {
            return nArray2;
        }
        if (nArray2 == null || nArray2.length <= 2) {
            if (nArray2 != null) {
                if (nArray2.length >= 1) {
                    nArray[0] = nArray2[0];
                }
                if (nArray2.length >= 2) {
                    nArray[1] = nArray2[1];
                }
            }
            return nArray;
        }
        Object[] objectArray = new SavedRowInfo[nArray2.length / 2 - 1];
        for (int i = 2; i < nArray2.length; i += 2) {
            objectArray[i / 2 - 1] = new SavedRowInfo(nArray2[i], nArray2[i + 1], false);
        }
        Arrays.sort(objectArray);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(objectArray));
        for (int i = 2; i < nArray.length; i += 2) {
            if (nArray[i] < 0) continue;
            SavedRowInfo savedRowInfo = new SavedRowInfo(nArray[i], nArray[i + 1], false);
            int n = JideSwingUtilities.binarySearch(arrayList, savedRowInfo);
            boolean bl = true;
            if (n <= 0) {
                boolean bl2 = bl = n == 0 && arrayList.size() >= 1 && JideSwingUtilities.equals(((SavedRowInfo)arrayList.get((int)0))._rowIndex, savedRowInfo._rowIndex);
            }
            if (bl) continue;
            arrayList.add(-n, savedRowInfo);
        }
        int[] nArray3 = new int[arrayList.size() * 2 + 2];
        nArray3[0] = nArray2[0];
        nArray3[1] = nArray2[1];
        for (int i = 0; i < arrayList.size(); ++i) {
            SavedRowInfo savedRowInfo = (SavedRowInfo)arrayList.get(i);
            nArray3[i * 2 + 2] = savedRowInfo._rowIndex;
            nArray3[i * 2 + 3] = savedRowInfo._rowInfo;
        }
        return nArray3;
    }

    public boolean isLoadSelectionOnTableDataChanged() {
        return this._loadSelectionOnTableDataChanged;
    }

    public void setLoadSelectionOnTableDataChanged(boolean bl) {
        boolean bl2 = this._loadSelectionOnTableDataChanged;
        if (bl2 != bl) {
            this._loadSelectionOnTableDataChanged = bl;
            this.firePropertyChange(PROPERTY_LOAD_SELECTION_ON_TABLE_DATA_CHANGES, bl2, bl);
        }
    }

    public boolean isFillsRight() {
        return this._fillsRight;
    }

    public void setFillsRight(boolean bl) {
        boolean bl2 = this._fillsRight;
        if (bl2 != bl) {
            this._fillsRight = bl;
            this.firePropertyChange(PROPERTY_FILLS_RIGHT, bl2, this._fillsRight);
        }
    }

    public boolean isFillsBottom() {
        return this._fillsBottom;
    }

    public void setFillsBottom(boolean bl) {
        boolean bl2 = this._fillsBottom;
        if (bl2 != bl) {
            this._fillsBottom = bl;
            this.firePropertyChange(PROPERTY_FILLS_BOTTOM, bl2, this._fillsBottom);
        }
    }

    public boolean isFillsGrids() {
        return this._fillsGrids;
    }

    protected boolean isFillsGridsBottom() {
        return this.isFillsGrids() && this.isFillsBottom();
    }

    protected boolean isFillsGridsRight() {
        return this.isFillsRight();
    }

    public void setFillsGrids(boolean bl) {
        boolean bl2 = this._fillsGrids;
        if (bl2 != bl) {
            this._fillsGrids = bl;
            this.firePropertyChange(PROPERTY_FILLS_GRIDS, bl2, this._fillsGrids);
        }
    }

    @Deprecated
    public boolean isFillRight() {
        return this._fillsRight;
    }

    @Deprecated
    public void setFillRight(boolean bl) {
        this._fillsRight = bl;
    }

    @Deprecated
    public boolean isFillBottom() {
        return this._fillsBottom;
    }

    @Deprecated
    public void setFillBottom(boolean bl) {
        this._fillsBottom = bl;
    }

    @Deprecated
    public boolean isFillGrids() {
        return this._fillsGrids;
    }

    @Deprecated
    public void setFillGrids(boolean bl) {
        this._fillsGrids = bl;
    }

    public boolean isAdjustEditorLocationOnModelChanged() {
        return this._adjustEditorLocationOnModelChanged;
    }

    public void setAdjustEditorLocationOnModelChanged(boolean bl) {
        this._adjustEditorLocationOnModelChanged = bl;
    }

    public void clearSavedSelections(boolean bl) {
        this._savedTableSelection = null;
        if (bl) {
            JTable[] jTableArray;
            for (JTable jTable : jTableArray = TableColumnChooser.getAllTablesInSplitPane(this)) {
                if (jTable == this || !(jTable instanceof JideTable)) continue;
                ((JideTable)jTable).clearSavedSelections(false);
            }
        }
    }

    protected void saveTableRowSettings(boolean bl) {
        if (this._isEventInvokedOutside && !bl) {
            return;
        }
        if (this.isKeepRowHeights() && !this.isRowAutoResizes()) {
            this.saveTableRowHeights();
        }
        this.saveTableSelection();
        if (bl) {
            this._isEventInvokedOutside = true;
        }
    }

    protected void loadTableRowSettings(boolean bl) {
        if (this._isEventInvokedOutside && !bl) {
            return;
        }
        if (this.isKeepRowHeights() && !this.isRowAutoResizes()) {
            this.loadTableRowHeights();
        }
        this.loadTableSelection();
        this._isEventInvokedOutside = false;
    }

    void saveTableRowHeights() {
        this._savedRowHeights = this.mergeSavedRowHeights(this._savedRowHeights, TableUtils.saveRowHeights(this));
    }

    void loadTableRowHeights() {
        TableUtils.loadRowHeights(this, this._savedRowHeights);
    }

    void saveTableSelection() {
        this._savedTableSelection = this.mergeSavedTableSelection(this._savedTableSelection, TableUtils.saveSelection(this));
    }

    void loadTableSelection() {
        TableUtils.loadSelection(this, this._savedTableSelection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void indexChanged(IndexChangeEvent var1_1) {
        switch (var1_1.getType()) {
            case 0: {
                if (this.isIndexChanging()) {
                    if (JideTable.LOGGER_EVENT.isLoggable(Level.FINE)) {
                        JideTable.LOGGER_EVENT.fine("JideTable \" should not get duplicate index changing events " + var1_1.getEventSerialNumber() + ", " + this._processingEventSerialNumber + ".");
                    }
                    if (this._conflictEventSerialNumberList == null) {
                        this._conflictEventSerialNumberList = new ArrayList<Integer>();
                    }
                    this._conflictEventSerialNumberList.add(this._processingEventSerialNumber);
                    if (this._conflictEventSerialNumberList.size() >= 10) {
                        var2_2 = true;
                        for (int var4_5 : this._conflictEventSerialNumberList) {
                            if (var4_5 == this._processingEventSerialNumber) continue;
                            var2_2 = false;
                            break;
                        }
                        if (var2_2) {
                            if (JideTable.LOGGER_EVENT.isLoggable(Level.FINE)) {
                                JideTable.LOGGER_EVENT.fine("JideTable \" get into dead lock at " + this._processingEventSerialNumber + ".");
                            }
                            this.setIndexChanging(false);
                            this._processingEventSerialNumber = -1;
                        } else {
                            this._conflictEventSerialNumberList.clear();
                        }
                    }
                    return;
                }
                this._processingEventSerialNumber = var1_1.getEventSerialNumber();
                if (this.isRestoreSelectionAndRowHeightAutomatically()) {
                    this.saveTableRowSettings(false);
                }
                this.setIndexChanging(true);
                this.setDataOrStructureChangeProcessed(false);
                this._needLoadRowSettings = false;
                this._loadInsertedRowsOnly = false;
                break;
            }
            case 1: {
                if (!this.isIndexChanging()) {
                    if (JideTable.LOGGER_EVENT.isLoggable(Level.FINE)) {
                        JideTable.LOGGER_EVENT.fine("JideTable \" should not get index changed event without index changing event " + var1_1.getEventSerialNumber() + ".");
                    }
                    return;
                }
                this._processingEventSerialNumber = -1;
                if (!this.isDataOrStructureChangeProcessed() && !var1_1.isForceProcess() && !this._needLoadRowSettings) ** GOTO lbl53
                var2_3 = this.isCalculateRowHeightsOnWidthChange();
                this.setCalculateRowHeightsOnWidthChange(false);
                try {
                    if (this.isRestoreSelectionAndRowHeightAutomatically()) {
                        this.loadTableRowSettings(false);
                    }
                }
                finally {
                    this._needLoadRowSettings = false;
                    this._loadInsertedRowsOnly = false;
                    this.setCalculateRowHeightsOnWidthChange(var2_3);
                    if (this.isRestoreSelectionAndRowHeightAutomatically() && this.getSelectionModel().getValueIsAdjusting()) {
                        this.getSelectionModel().setValueIsAdjusting(false);
                    }
                }
                this.setDataOrStructureChangeProcessed(false);
lbl53:
                // 2 sources

                this.resetEditingCell();
                this.setIndexChanging(false);
            }
        }
    }

    boolean isAvoidSelectionChange() {
        Object object = this.getClientProperty("TableScrollPane.Parent");
        if (object instanceof TableScrollPane) {
            return ((TableScrollPane)object).isAvoidSelectionChange();
        }
        return this._avoidSelectionChange;
    }

    void setAvoidSelectionChange(boolean bl) {
        Object object = this.getClientProperty("TableScrollPane.Parent");
        if (object instanceof TableScrollPane) {
            ((TableScrollPane)object).setAvoidSelectionChange(bl);
        } else {
            this._avoidSelectionChange = bl;
        }
    }

    boolean loadInsertedRowsOnly(CompoundTableModelEvent compoundTableModelEvent) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this._currentRowValidationResult = null;
        this.manageSavedRowSettings(tableModelEvent);
        if (tableModelEvent instanceof UndoableTableModelEvent) {
            this.addUndo((UndoableTableModelEvent)tableModelEvent);
        } else if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent() instanceof UndoableTableModelEvent) {
            this.addUndo((UndoableTableModelEvent)((CompoundTableModelEvent)tableModelEvent).getOriginalEvent());
        }
        this.putClientProperty("TableChanged", true);
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) {
            this.tableStructureChanged(tableModelEvent);
            return;
        }
        if (tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE && tableModelEvent.getColumn() == -1) {
            if (this.getTableHeader() != null) {
                this.getTableHeader().invalidate();
                this.getTableHeader().repaint();
            }
            if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getEvents() != null && ((CompoundTableModelEvent)tableModelEvent).getEvents().length > 0) {
                this.clearRowHeightsValidity();
                this._needLoadRowSettings = true;
                this.getSelectionModel().setValueIsAdjusting(true);
                this._loadInsertedRowsOnly = this.loadInsertedRowsOnly((CompoundTableModelEvent)tableModelEvent);
                block11: for (TableModelEvent tableModelEvent2 : ((CompoundTableModelEvent)tableModelEvent).getEvents()) {
                    switch (tableModelEvent2.getType()) {
                        case 1: {
                            this.tableRowsInserted(tableModelEvent2, true);
                            continue block11;
                        }
                        case -1: {
                            this.tableRowsDeleted(tableModelEvent2, true);
                            continue block11;
                        }
                        case 0: {
                            if (tableModelEvent2.getFirstRow() == -1) {
                                this.tableChanged(tableModelEvent2);
                                return;
                            }
                            if (tableModelEvent2.getLastRow() == Integer.MAX_VALUE) {
                                this.tableChanged(tableModelEvent2);
                                return;
                            }
                            this.tableRowsOrCellsUpdated(tableModelEvent2);
                            continue block11;
                        }
                        default: {
                            this.tableChanged(tableModelEvent2);
                            return;
                        }
                    }
                }
                return;
            }
            int[] nArray = null;
            Row[] rowArray = null;
            if (!this.isIndexChanging() && !this.isClearSelectionOnTableDataChanges()) {
                if (this instanceof TreeTable) {
                    rowArray = TableUtils.saveSelection((TreeTable)this);
                } else {
                    nArray = TableUtils.saveSelection(this);
                }
            }
            if (!this.isRowAutoResizes() || this.getRowHeights().getRowCount() != this.getRowCount()) {
                this.setRowHeights(null);
            }
            this.setAvoidSelectionChange(true);
            try {
                super.tableChanged(tableModelEvent);
            }
            finally {
                this.setAvoidSelectionChange(false);
            }
            boolean bl = this.isCalculateRowHeightsOnWidthChange();
            this.setCalculateRowHeightsOnWidthChange(false);
            try {
                if (!this.isIndexChanging() && !this.isClearSelectionOnTableDataChanges()) {
                    if (this instanceof TreeTable) {
                        TableUtils.loadSelection((TreeTable)this, rowArray);
                    } else if (nArray != null) {
                        TableUtils.loadSelection(this, nArray);
                    }
                }
            }
            finally {
                this.setCalculateRowHeightsOnWidthChange(bl);
                if (!this.isIndexChanging() && this.getSelectionModel().getValueIsAdjusting()) {
                    this.getSelectionModel().setValueIsAdjusting(false);
                }
            }
            this.clearRowHeightsValidity();
            this.resizeAndRepaint();
            this.setDataOrStructureChangeProcessed(true);
            return;
        }
        if (tableModelEvent.getType() == 1) {
            this.clearRowHeightsValidity();
            this.tableRowsInserted(tableModelEvent, false);
            return;
        }
        if (tableModelEvent.getType() == -1) {
            this.clearRowHeightsValidity();
            this.tableRowsDeleted(tableModelEvent, false);
            return;
        }
        this.clearRowHeightsValidity();
        this.tableRowsOrCellsUpdated(tableModelEvent);
    }

    void clearSavedRowHeights() {
        this._savedRowHeights = null;
    }

    protected void tableStructureChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof CompoundTableModelEvent && !((CompoundTableModelEvent)tableModelEvent).isOriginalChanged()) {
            this.setAvoidSelectionChange(true);
        } else {
            this._autoResizeColumnWidths = null;
            this._avoidRowHeightCalculation = true;
        }
        if (this.isClearPropertyAtStructureChange()) {
            this.clearClientProperties();
        }
        this.setRowHeights(null);
        this.clearRowHeightsValidity();
        this.clearSavedRowHeights();
        try {
            super.tableChanged(tableModelEvent);
            this.setDataOrStructureChangeProcessed(true);
            this.listenToColumnWidthChange();
        }
        finally {
            this.setAvoidSelectionChange(false);
            this._avoidRowHeightCalculation = false;
            if (!this.isIndexChanging() && this.getSelectionModel().getValueIsAdjusting()) {
                this.getSelectionModel().setValueIsAdjusting(false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void manageSavedRowSettings(TableModelEvent tableModelEvent) {
        boolean bl = false;
        if (tableModelEvent instanceof UndoableTableModelEvent || tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent() instanceof UndoableTableModelEvent) {
            bl = true;
        }
        if (tableModelEvent instanceof CompoundTableModelEvent && !bl) {
            TableModelEvent tableModelEvent2 = ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent();
            if (tableModelEvent2 != null) {
                switch (tableModelEvent2.getType()) {
                    case 1: {
                        this.adjustRowSettings(tableModelEvent2);
                        break;
                    }
                    case -1: {
                        this.adjustRowSettings(tableModelEvent2);
                        break;
                    }
                    case 0: {
                        if (tableModelEvent2.getFirstRow() == -1) {
                            bl = true;
                            break;
                        }
                        if (tableModelEvent2.getLastRow() != Integer.MAX_VALUE || this.isLoadSelectionOnTableDataChanged()) break;
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.clearSavedSelectionOnEvent();
            this._savedRowHeights = null;
        }
    }

    void adjustRowSettings(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 1) {
            TableUtils.adjustSavedRowHeightsRowsInserted(this._savedRowHeights, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
            TableUtils.adjustSavedSelectionRowsInserted(this, this._savedTableSelection, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
        } else if (tableModelEvent.getType() == -1) {
            TableUtils.adjustSavedRowHeightsRowsDeleted(this._savedRowHeights, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
            TableUtils.adjustSavedSelectionRowsDeleted(this, this._savedTableSelection, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
        }
    }

    void clearSavedSelectionOnEvent() {
        this.clearSavedSelections(true);
    }

    private void tableRowsOrCellsUpdated(TableModelEvent tableModelEvent) {
        if (this.isRowAutoResizes()) {
            this.resizeAndRepaint();
            return;
        }
        int n = tableModelEvent.getColumn();
        int n2 = Math.min(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
        int n3 = Math.max(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
        Rectangle rectangle = new Rectangle();
        int n4 = this.getRolloverRow();
        int n5 = this.getRolloverColumn();
        boolean bl = false;
        if (n == -1) {
            if (this.getColumnCount() > 0) {
                rectangle = new Rectangle(0, 0, this.getColumnModel().getTotalColumnWidth(), 0);
                rectangle.y = this.getCellRect((int)n2, (int)0, (boolean)false).y;
                Rectangle rectangle2 = this.getCellRect(n3, 0, false);
                rectangle.height = rectangle2.y + rectangle2.height - rectangle.y;
                if (n4 >= 0 && n4 >= n2 && n4 <= n3) {
                    bl = true;
                }
            }
        } else {
            int n6 = this.convertColumnIndexToView(n);
            rectangle = this.getCellRect(n2, n6, false);
            Rectangle rectangle3 = this.getCellRect(n3, n6, false);
            rectangle = rectangle.union(rectangle3);
            if (n5 == n6 && n4 >= 0 && n4 >= n2 && n4 <= n3) {
                bl = true;
            }
        }
        if (n3 != Integer.MAX_VALUE) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.clearSelectionAndLeadAnchor();
            this.resizeAndRepaint();
        }
        if (bl && this.getRolloverCellEditor() != null) {
            this.getRolloverCellEditor().stopCellEditing();
            this.rolloverCellAt(n4, n5);
        }
    }

    @Override
    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel(){

            @Override
            public void setValueIsAdjusting(boolean bl) {
                if (!bl && JideTable.this.isAvoidSelectionChange()) {
                    return;
                }
                super.setValueIsAdjusting(bl);
            }
        };
    }

    private void clearClientProperties() {
        this.putClientProperty("TableColumnSnapshot:", null);
        this.putClientProperty("HiddenIdentifiersList", null);
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            Object object = this.getModel() instanceof ColumnIdentifierTableModel ? ((ColumnIdentifierTableModel)((Object)this.getModel())).getColumnIdentifier(i) : this.getModel().getColumnName(i);
            if (object == null) continue;
            this.putClientProperty("TableColumnIdentifier:" + object.toString(), null);
        }
    }

    private void tableRowsInserted(TableModelEvent tableModelEvent, boolean bl) {
        int n = Math.min(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
        int n2 = Math.max(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = this.getRowCount() - 1;
        }
        int n3 = n2 - n + 1;
        if ((!bl || this._loadInsertedRowsOnly) && this.needProcessSelection(tableModelEvent)) {
            if (this.needLoadSelection(tableModelEvent) && !this._loadInsertedRowsOnly) {
                this._needLoadRowSettings = true;
            } else {
                if (this.isSelectInsertedRows()) {
                    this.selectionModel.insertIndexInterval(n, n3, true);
                } else {
                    this.adjustInsertedSelections(n, n3);
                }
                this.checkLeadAnchor();
            }
        }
        if (this.isVariousRowHeights() && this._rowHeights == null && this.getRowCount() == n3) {
            this.getRowHeights();
        }
        if (this.isVariousRowHeights() && this._rowHeights != null) {
            this._rowHeights.insertRows(n, n3, this.getRowHeight());
            this.revalidate();
            this.repaint();
        } else {
            int n4 = this.getRowHeight();
            Rectangle rectangle = new Rectangle(0, n * n4, this.getColumnModel().getTotalColumnWidth(), (this.getRowCount() - n) * n4);
            this.revalidate();
            this.repaint(rectangle);
        }
    }

    boolean needLoadSelection(TableModelEvent tableModelEvent) {
        return tableModelEvent instanceof CompoundTableModelEvent && !((CompoundTableModelEvent)tableModelEvent).isOriginalChanged();
    }

    private boolean needProcessSelection(TableModelEvent tableModelEvent) {
        boolean bl = true;
        Object object = this.getClientProperty("TableScrollPane.Parent");
        if (!this.isNonContiguousCellSelection() && object instanceof TableScrollPane) {
            JTable jTable = null;
            if (((TableScrollPane)object).getMainTable() != null && ((TableScrollPane)object).getMainTable().getColumnCount() > 0) {
                jTable = ((TableScrollPane)object).getMainTable();
            }
            if (jTable == null) {
                if (((TableScrollPane)object).getRowHeaderTable() != null && ((TableScrollPane)object).getRowHeaderTable().getColumnCount() > 0) {
                    jTable = ((TableScrollPane)object).getRowHeaderTable();
                }
                if (jTable == null && ((TableScrollPane)object).getRowFooterTable() != null && ((TableScrollPane)object).getRowFooterTable().getColumnCount() > 0) {
                    jTable = ((TableScrollPane)object).getRowFooterTable();
                }
            }
            JTable jTable2 = null;
            if (((TableScrollPane)object).getColumnFooterTable() != null && ((TableScrollPane)object).getColumnFooterTable().getColumnCount() > 0) {
                jTable2 = ((TableScrollPane)object).getColumnFooterTable();
            }
            if (jTable2 == null) {
                if (((TableScrollPane)object).getRowHeaderColumnFooterTable() != null && ((TableScrollPane)object).getRowHeaderColumnFooterTable().getColumnCount() > 0) {
                    jTable2 = ((TableScrollPane)object).getRowHeaderColumnFooterTable();
                }
                if (jTable2 == null && ((TableScrollPane)object).getRowFooterColumnFooterTable() != null && ((TableScrollPane)object).getRowFooterColumnFooterTable().getColumnCount() > 0) {
                    jTable2 = ((TableScrollPane)object).getRowFooterColumnFooterTable();
                }
            }
            if (jTable != this && jTable2 != this) {
                if (jTable != null && this.getSelectionModel() == jTable.getSelectionModel()) {
                    bl = false;
                }
                if (jTable2 != null && this.getSelectionModel() == jTable2.getSelectionModel()) {
                    bl = false;
                }
            }
        }
        if (bl) {
            if (tableModelEvent instanceof UndoableTableModelEvent) {
                bl = false;
            } else if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent() instanceof UndoableTableModelEvent) {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustInsertedSelections(int n, int n2) {
        this.selectionModel.setValueIsAdjusting(true);
        try {
            boolean bl = this.selectionModel.isSelectedIndex(n);
            int n3 = -1;
            if (bl) {
                n3 = this.selectionModel.getLeadSelectionIndex();
                this.selectionModel.removeSelectionInterval(n, n);
            }
            this.selectionModel.insertIndexInterval(n, n2, true);
            if (bl) {
                this.selectionModel.addSelectionInterval(n + n2, n + n2);
                if (this.selectionModel instanceof DefaultListSelectionModel && SystemInfo.isJdk15Above()) {
                    ((DefaultListSelectionModel)this.selectionModel).moveLeadSelectionIndex(n3 == n ? n + n2 : n3);
                }
            }
        }
        finally {
            this.selectionModel.setValueIsAdjusting(false);
        }
    }

    void tableRowsDeleted(TableModelEvent tableModelEvent, boolean bl) {
        int n = Math.min(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
        int n2 = Math.max(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = this.getRowCount() - 1 < 0 ? 0 : this.getRowCount() - 1;
        }
        int n3 = n2 - n + 1;
        if ((!bl || this._loadInsertedRowsOnly) && this.needProcessSelection(tableModelEvent)) {
            if (this.needLoadSelection(tableModelEvent) && !this._loadInsertedRowsOnly) {
                this._needLoadRowSettings = true;
            } else {
                this.selectionModel.removeIndexInterval(n, n2);
                this.checkLeadAnchor();
            }
        }
        if (this.isVariousRowHeights() && this._rowHeights != null) {
            this._rowHeights.removeRows(n, n3);
        }
        if (this.isEditing() && this.getEditingRow() >= n && this.getEditingRow() <= n2) {
            this.removeEditor();
        }
        this.revalidate();
        this.repaint();
    }

    private void checkLeadAnchor() {
        TableModel tableModel = this.getModel();
        if (tableModel == null) {
            return;
        }
        int n = this.selectionModel.getLeadSelectionIndex();
        int n2 = tableModel.getRowCount();
        if (n2 == 0) {
            if (n != -1) {
                this.selectionModel.setValueIsAdjusting(true);
                this.selectionModel.setAnchorSelectionIndex(-1);
                this.selectionModel.setLeadSelectionIndex(-1);
                this.selectionModel.setValueIsAdjusting(false);
            }
        } else if (n == -1 && this.selectionModel.isSelectedIndex(0)) {
            this.selectionModel.addSelectionInterval(0, 0);
        }
    }

    public boolean isRowAutoResizes() {
        return this._rowAutoResizes;
    }

    public void setRowAutoResizes(boolean bl) {
        this.setRowAutoResizes(bl, true);
    }

    void setRowAutoResizes(boolean bl, boolean bl2) {
        boolean bl3 = this._rowAutoResizes;
        if (bl3 != bl) {
            this._rowAutoResizes = bl;
            if (bl2) {
                this.firePropertyChange("rowAutoResizes", bl3, this._rowAutoResizes);
                if (this._rowAutoResizes && this.isShowing()) {
                    this.clearRowHeightsValidity();
                    this.resizeAndRepaint();
                }
            }
        }
        this.listenToColumnWidthChange();
    }

    private void listenToColumnWidthChange() {
        if (this._listener == null) {
            this._listener = new TableColumnModelListener(){

                @Override
                public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                    JideTable.this.clearRowHeightsValidity();
                    JideTable.this.resizeAndRepaint();
                }

                @Override
                public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                    JideTable.this.clearRowHeightsValidity();
                    JideTable.this.resizeAndRepaint();
                }

                @Override
                public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                }

                @Override
                public void columnMarginChanged(ChangeEvent changeEvent) {
                    JideTable.this.clearRowHeightsValidity();
                    JideTable.this.resizeAndRepaint();
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                }
            };
            this.addPropertyChangeListener("columnModel", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getOldValue() instanceof TableColumnModel) {
                        ((TableColumnModel)propertyChangeEvent.getOldValue()).removeColumnModelListener(JideTable.this._listener);
                    }
                    if (propertyChangeEvent.getNewValue() instanceof TableColumnModel && JideTable.this.isRowAutoResizes()) {
                        ((TableColumnModel)propertyChangeEvent.getNewValue()).addColumnModelListener(JideTable.this._listener);
                    }
                }
            });
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.removeColumnModelListener(this._listener);
        if (this.isRowAutoResizes()) {
            tableColumnModel.addColumnModelListener(this._listener);
        }
    }

    boolean isFitted(int n) {
        return this._fitted.get(n) != null;
    }

    void setFitted(int n) {
        if (!this.isFitted(n)) {
            this._fitted.put(n, "");
        }
    }

    void removeFitted(int n) {
        if (this.isFitted(n)) {
            this._fitted.remove(n);
        }
    }

    void clearFitted() {
        this._fitted.clear();
    }

    @Deprecated
    protected void setSortTableHeaderRenderer() {
        SortTableHeaderRenderer sortTableHeaderRenderer = this.createSortHeaderRenderer();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setHeaderRenderer(sortTableHeaderRenderer);
        }
    }

    @Deprecated
    protected SortTableHeaderRenderer createSortHeaderRenderer() {
        return new SortTableHeaderRenderer();
    }

    public boolean isNonContiguousCellSelection() {
        return this._nonContiguousCellSelection;
    }

    public void setNonContiguousCellSelection(boolean bl) {
        boolean bl2 = this._nonContiguousCellSelection;
        if (bl2 != bl) {
            this._nonContiguousCellSelection = bl;
            this.clearSavedSelections(true);
            this.firePropertyChange(PROPERTY_NON_CONTIGUOUS_CELL_SELECTION, bl2, this._nonContiguousCellSelection);
            if (this._nonContiguousCellSelection) {
                this.createDefaultTableSelectionModel();
                this.getSelectionModel().removeListSelectionListener(this);
                this.getColumnModel().getSelectionModel().removeListSelectionListener(this);
            } else {
                this.getSelectionModel().addListSelectionListener(this);
                this.getColumnModel().getSelectionModel().addListSelectionListener(this);
            }
        }
    }

    @Override
    public void setRowSelectionAllowed(boolean bl) {
        if (this.rowSelectionAllowed != bl) {
            this.clearSavedSelections(true);
        }
        super.setRowSelectionAllowed(bl);
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
        if (this.getColumnModel().getColumnSelectionAllowed() != bl) {
            this.clearSavedSelections(true);
        }
        super.setColumnSelectionAllowed(bl);
    }

    public void createDefaultTableSelectionModel() {
        this.setTableSelectionModel(new DefaultTableSelectionModel());
    }

    public void setTableSelectionModel(TableSelectionModel tableSelectionModel) {
        if (tableSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null TableSelectionModel");
        }
        TableSelectionModel tableSelectionModel2 = this._tableSelectionModel;
        if (this._selectionListener == null) {
            this._selectionListener = new TableSelectionListener(){

                @Override
                public void valueChanged(TableSelectionEvent tableSelectionEvent) {
                    if (!tableSelectionEvent.getValueIsAdjusting()) {
                        int n = tableSelectionEvent.getFirstRowIndex();
                        int n2 = tableSelectionEvent.getLastRowIndex();
                        int n3 = tableSelectionEvent.getFirstColumnIndex();
                        int n4 = tableSelectionEvent.getLastColumnIndex();
                        if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
                            JideTable.this.repaint();
                        } else {
                            Rectangle rectangle = JideTable.this.getCellRect(n, n3, true);
                            Rectangle rectangle2 = JideTable.this.getCellRect(n, n4, true);
                            Rectangle rectangle3 = JideTable.this.getCellRect(n2, n3, true);
                            Rectangle rectangle4 = JideTable.this.getCellRect(n2, n4, true);
                            JideTable.this.repaint(rectangle.union(rectangle2.union(rectangle3.union(rectangle4))));
                        }
                    }
                }
            };
        }
        this._tableSelectionModel = tableSelectionModel;
        if (tableSelectionModel2 != this._tableSelectionModel) {
            if (tableSelectionModel2 != null) {
                tableSelectionModel2.removeTableSelectionListener(this._selectionListener);
            }
            if (this._tableSelectionModel != null) {
                this._tableSelectionModel.addTableSelectionListener(this._selectionListener);
            }
        }
        tableSelectionModel.setColumns(this.getColumnModel().getColumnCount());
        this.getModel().removeTableModelListener(tableSelectionModel);
        this.getModel().addTableModelListener(tableSelectionModel);
        this.getColumnModel().removeColumnModelListener(tableSelectionModel);
        this.getColumnModel().addColumnModelListener(tableSelectionModel);
        if (tableSelectionModel2 != null) {
            this.removePropertyChangeListener(tableSelectionModel2);
        }
        this.addPropertyChangeListener(tableSelectionModel);
        this.firePropertyChange(PROPERTY_TABLE_SELECTION_MODEL, tableSelectionModel2, tableSelectionModel);
    }

    public TableSelectionModel getTableSelectionModel() {
        return this._tableSelectionModel;
    }

    @Override
    public int[] getSelectedRows() {
        if (this.isNonContiguousCellSelection() && this.getTableSelectionModel() != null) {
            return this.getTableSelectionModel().getSelectedRows();
        }
        return super.getSelectedRows();
    }

    @Override
    public int[] getSelectedColumns() {
        if (this.isNonContiguousCellSelection() && this.getTableSelectionModel() != null) {
            return this.getTableSelectionModel().getSelectedColumns();
        }
        return super.getSelectedColumns();
    }

    @Override
    public int getSelectedRow() {
        if (this.isNonContiguousCellSelection() && this.getTableSelectionModel() != null) {
            return this.getTableSelectionModel().getMinSelectedRowIndex();
        }
        return super.getSelectedRow();
    }

    @Override
    public int getSelectedColumn() {
        if (this.isNonContiguousCellSelection() && this.getTableSelectionModel() != null) {
            return this.getTableSelectionModel().getMinSelectedColumnIndex();
        }
        return super.getSelectedColumn();
    }

    @Override
    public int getSelectedRowCount() {
        if (this.isNonContiguousCellSelection() && this.getTableSelectionModel() != null) {
            return this.getTableSelectionModel().getSelectedRowCount();
        }
        return super.getSelectedRowCount();
    }

    @Override
    public int getSelectedColumnCount() {
        if (this.isNonContiguousCellSelection() && this.getTableSelectionModel() != null) {
            return this.getTableSelectionModel().getSelectedColumnCount();
        }
        return super.getSelectedColumnCount();
    }

    @Override
    public boolean isRowSelected(int n) {
        if (!this._pending && this.isNonContiguousCellSelection() && this.getTableSelectionModel() != null) {
            return this.getTableSelectionModel().isRowSelected(n);
        }
        return super.isRowSelected(n);
    }

    @Override
    public boolean isColumnSelected(int n) {
        if (!this._pending && this.isNonContiguousCellSelection() && this.getTableSelectionModel() != null) {
            return this.getTableSelectionModel().isColumnSelected(n);
        }
        return super.isColumnSelected(n);
    }

    protected boolean shouldCellBePaintedAsSelected(int n, int n2) {
        return true;
    }

    protected boolean shouldCellBePaintedAsFocused(int n, int n2) {
        return true;
    }

    @Override
    public boolean isCellSelected(int n, int n2) {
        if (!this._pending && this.isNonContiguousCellSelection() && this.getTableSelectionModel() != null) {
            return this.getTableSelectionModel().isSelected(n, n2);
        }
        return super.isCellSelected(n, n2);
    }

    private boolean isDataOrStructureChangeProcessed() {
        return this._dataOrStructureChangeProcessed;
    }

    private void setDataOrStructureChangeProcessed(boolean bl) {
        this._dataOrStructureChangeProcessed = bl;
    }

    public boolean isCalculateRowHeightsOnWidthChange() {
        return this._calculateRowHeightsOnWidthChange;
    }

    public void setCalculateRowHeightsOnWidthChange(boolean bl) {
        this._calculateRowHeightsOnWidthChange = bl;
    }

    public boolean isAlwaysRequestFocusForEditor() {
        return this._alwaysRequestFocusForEditor;
    }

    public void setAlwaysRequestFocusForEditor(boolean bl) {
        this._alwaysRequestFocusForEditor = bl;
    }

    public boolean isClearPropertyAtStructureChange() {
        return this._clearPropertyAtStructureChange;
    }

    public void setClearPropertyAtStructureChange(boolean bl) {
        this._clearPropertyAtStructureChange = bl;
    }

    public void paintCellUnderlay(Graphics graphics, Component component, int n, int n2, Rectangle rectangle) {
    }

    public void paintCellOverlay(Graphics graphics, Component component, int n, int n2, Rectangle rectangle) {
    }

    public boolean isEnableIgnored() {
        return this._enableIgnored;
    }

    public void setEnableIgnored(boolean bl) {
        this._enableIgnored = bl;
    }

    public boolean isRollover() {
        return this._rolloverCellEditor != null;
    }

    public TableCellEditor getRolloverCellEditor() {
        return this._rolloverCellEditor;
    }

    public int getRolloverRow() {
        return this._rolloverRow;
    }

    public int getRolloverColumn() {
        return this._rolloverColumn;
    }

    public boolean rolloverCellAt(int n, int n2) {
        Object object;
        if (this._rolloverCellEditor != null && !this._rolloverCellEditor.stopCellEditing()) {
            return false;
        }
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return false;
        }
        if (this._rolloverEditorRemover == null) {
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this._rolloverEditorRemover = new RolloverCellEditorRemover((KeyboardFocusManager)object);
            JideSwingUtilities.insertPropertyChangeListener((KeyboardFocusManager)object, this._rolloverEditorRemover, "permanentFocusOwner", 0);
        }
        if ((object = this.getCellEditor(n, n2)) != null) {
            this._rolloverEditorComp = this.prepareEditor((TableCellEditor)object, n, n2);
            if (this._rolloverEditorComp == null) {
                this.removeRolloverEditor();
                return false;
            }
            this._rolloverEditorComp.setBounds(this.getEditorCellRect(n, n2));
            this.add(this._rolloverEditorComp);
            this._rolloverEditorComp.validate();
            this._rolloverEditorComp.repaint();
            this._rolloverCellEditor = object;
            if (this._rolloverCellEditorListener == null) {
                this._rolloverCellEditorListener = new CellEditorListener(){

                    @Override
                    public void editingStopped(ChangeEvent changeEvent) {
                        JideTable.this.removeRolloverEditor();
                    }

                    @Override
                    public void editingCanceled(ChangeEvent changeEvent) {
                        JideTable.this.removeRolloverEditor();
                    }
                };
            }
            object.addCellEditorListener(this._rolloverCellEditorListener);
            this._rolloverRow = n;
            this._rolloverColumn = n2;
            return true;
        }
        return false;
    }

    public void removeRolloverEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this._rolloverEditorRemover);
        this._rolloverEditorRemover = null;
        TableCellEditor tableCellEditor = this._rolloverCellEditor;
        if (tableCellEditor != null) {
            tableCellEditor.removeCellEditorListener(this._rolloverCellEditorListener);
            if (this._rolloverEditorComp != null) {
                this.remove(this._rolloverEditorComp);
            }
            Rectangle rectangle = this.getCellRect(this._rolloverRow, this._rolloverColumn, false);
            this._rolloverCellEditor = null;
            this._rolloverEditorComp = null;
            this._rolloverRow = -1;
            this._rolloverColumn = -1;
            this.repaint(rectangle);
        }
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        Object object;
        if (eventObject instanceof MouseEvent && this.getClickCountToStart() > 0 && ((MouseEvent)eventObject).getClickCount() < this.getClickCountToStart()) {
            return false;
        }
        if (eventObject instanceof KeyEvent && eventObject != this._editingKeyEvent && !this.isValidCellEditingKey((KeyEvent)(object = (KeyEvent)eventObject))) {
            return false;
        }
        if (eventObject instanceof MouseEvent) {
            object = this.getEditorCellRect(n, n2);
            if (this.isRowResizable()) {
                ((Rectangle)object).y += 3;
                ((Rectangle)object).height -= 6;
            }
            if (this.isColumnResizable()) {
                ((Rectangle)object).x += 3;
                ((Rectangle)object).width -= 6;
            }
            if (!((Rectangle)object).contains(((MouseEvent)eventObject).getPoint())) {
                return false;
            }
        }
        if (!((object = this.getCellEditor()) == null || this.editingRow == n && this.editingColumn == n2 || this._couldStopEditing && this.fireEditingStopping(object, this.editingRow, this.editingColumn) && object.stopCellEditing())) {
            return false;
        }
        if (!this.shouldAllowChangingRow(n)) {
            return false;
        }
        this._currentRowIndex = n;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(n, n2)) {
            return false;
        }
        if (this._editorRemover == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this._editorRemover = this.createEditorRemover(keyboardFocusManager);
            JideSwingUtilities.insertPropertyChangeListener(keyboardFocusManager, this._editorRemover, "permanentFocusOwner", 0);
        }
        if ((object = this.getCellEditor(n, n2)) != null && object.isCellEditable(eventObject)) {
            this.editorComp = this.prepareEditor((TableCellEditor)object, n, n2);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getEditorCellRect(n, n2));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.editorComp.repaint();
            this.setCellEditor((TableCellEditor)object);
            this.setEditingRow(n);
            this.setEditingColumn(n2);
            object.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    protected CellEditorRemover createEditorRemover(KeyboardFocusManager keyboardFocusManager) {
        return new CellEditorRemover(keyboardFocusManager);
    }

    protected boolean isValidCellEditingKey(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
            return false;
        }
        if (keyEvent.getKeyCode() == 113) {
            return true;
        }
        if (keyEvent.getKeyCode() >= 112 && keyEvent.getKeyCode() <= 61451) {
            return keyEvent.getKeyChar() != '\uffff';
        }
        return true;
    }

    public void clearSelectionPermanently() {
        this.clearSavedSelections(true);
        this.clearSelection();
    }

    @Override
    public void clearSelection() {
        if (!this.isAvoidSelectionChange()) {
            this.clearSavedSelections(true);
        }
        if (!this.shouldAllowChangingRow(-1)) {
            return;
        }
        super.clearSelection();
        if (this.isNonContiguousCellSelection()) {
            this.getTableSelectionModel().clearSelection();
        }
    }

    @Override
    public void setRowSelectionInterval(int n, int n2) {
        this.clearSavedSelections(true);
        super.setRowSelectionInterval(n, n2);
    }

    @Override
    public void setColumnSelectionInterval(int n, int n2) {
        this.clearSavedSelections(true);
        super.setColumnSelectionInterval(n, n2);
    }

    @Override
    public void addRowSelectionInterval(int n, int n2) {
        this.clearSavedSelections(true);
        super.addRowSelectionInterval(n, n2);
    }

    @Override
    public void addColumnSelectionInterval(int n, int n2) {
        this.clearSavedSelections(true);
        super.addColumnSelectionInterval(n, n2);
    }

    @Override
    public void removeRowSelectionInterval(int n, int n2) {
        this.clearSavedSelections(true);
        super.removeRowSelectionInterval(n, n2);
    }

    @Override
    public void removeColumnSelectionInterval(int n, int n2) {
        this.clearSavedSelections(true);
        super.removeColumnSelectionInterval(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4;
        if (this.isEditing() && (this.getEditingColumn() != n2 || this.getEditingRow() != n)) {
            return;
        }
        if (!this.shouldAllowChangingRow(n)) {
            return;
        }
        this.clearSavedSelections(true);
        this._pending = true;
        boolean bl3 = false;
        try {
            if (this.isNonContiguousCellSelection() && this.getTableSelectionModel() != null) {
                if (bl && !bl2) {
                    this.getTableSelectionModel().setValueAdjusting(true);
                    try {
                        if (!this.getTableSelectionModel().isSelected(n, n2)) {
                            this.getTableSelectionModel().addSelection(n, n2);
                            this.getTableSelectionModel().setAnchorSelection(n, n2);
                            this.getTableSelectionModel().setLeadSelection(n, n2);
                        }
                        this.getTableSelectionModel().removeSelection(n, n2);
                    }
                    finally {
                        bl3 = true;
                    }
                } else if (!bl && !bl2) {
                    if (this.getTableSelectionModel().getLeadRowIndex() != n || this.getTableSelectionModel().getLeadColumnIndex() != n2) {
                        this.getTableSelectionModel().setValueAdjusting(true);
                        try {
                            this.getTableSelectionModel().clearSelection();
                            super.clearSelection();
                            this.getTableSelectionModel().addSelection(n, n2);
                            this.getTableSelectionModel().setAnchorSelection(n, n2);
                            this.getTableSelectionModel().setLeadSelection(n, n2);
                        }
                        finally {
                            bl3 = true;
                        }
                    } else {
                        this.getTableSelectionModel().setValueAdjusting(true);
                        try {
                            if (SystemInfo.isJdk6Above()) {
                                this.getTableSelectionModel().clearSelection();
                                super.clearSelection();
                            }
                            this.getTableSelectionModel().setSelection(n, n2);
                        }
                        finally {
                            bl3 = true;
                        }
                    }
                } else if (bl && bl2) {
                    this.getTableSelectionModel().setLeadSelection(n, n2);
                } else if (this.getTableSelectionModel().getLeadRowIndex() != n || this.getTableSelectionModel().getLeadColumnIndex() != n2) {
                    n4 = this.getTableSelectionModel().getAnchorRowIndex();
                    n3 = this.getTableSelectionModel().getAnchorColumnIndex();
                    this.getTableSelectionModel().setValueAdjusting(true);
                    try {
                        if (SystemInfo.isJdk6Above()) {
                            this.getTableSelectionModel().clearSelection();
                            super.clearSelection();
                        }
                        this.getTableSelectionModel().setAnchorSelection(n4, n3);
                        this.getTableSelectionModel().setLeadSelection(n, n2);
                    }
                    finally {
                        bl3 = true;
                    }
                }
            }
            super.changeSelection(n, n2, bl, bl2);
        }
        finally {
            this._pending = false;
            if (bl3) {
                this.getTableSelectionModel().setValueAdjusting(false);
            }
        }
        this._currentRowIndex = n;
        n4 = this.getSelectedRow();
        n3 = this.getSelectedColumn();
        if (this._editingKeyEvent != null && n4 != -1 && n3 != -1) {
            this.editCellAt(n4, n3, this._editingKeyEvent);
        }
    }

    private int limit(int n, int n2, int n3) {
        return Math.min(n3, Math.max(n, n2));
    }

    private int getAdjustedIndex(int n, boolean bl) {
        int n2 = bl ? this.getRowCount() : this.getColumnCount();
        return n < n2 ? n : -1;
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (this._columnSelectionAdjusting && !bl) {
            this._columnSelectionAdjusting = false;
            return;
        }
        this._columnSelectionAdjusting = bl;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        int n = this.limit(listSelectionEvent.getFirstIndex(), 0, this.getColumnCount() - 1);
        int n2 = this.limit(listSelectionEvent.getLastIndex(), 0, this.getColumnCount() - 1);
        int n3 = 0;
        int n4 = this.getRowCount() - 1;
        if (this.getRowSelectionAllowed()) {
            n3 = this.isNonContiguousCellSelection() ? this._tableSelectionModel.getMinSelectedRowIndex() : this.selectionModel.getMinSelectionIndex();
            n4 = this.isNonContiguousCellSelection() ? this._tableSelectionModel.getMaxSelectedRowIndex() : this.selectionModel.getMaxSelectionIndex();
            int n5 = this.getAdjustedIndex(this.isNonContiguousCellSelection() ? this._tableSelectionModel.getLeadRowIndex() : this.selectionModel.getLeadSelectionIndex(), true);
            if (n3 == -1 || n4 == -1) {
                if (n5 == -1) {
                    return;
                }
                n3 = n4 = n5;
            } else if (n5 != -1) {
                n3 = Math.min(n3, n5);
                n4 = Math.max(n4, n5);
            }
        }
        Rectangle rectangle = this.getDirtyRegion(n3, n, n4, n2);
        this.repaint(rectangle);
    }

    protected Rectangle getDirtyRegion(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getCellRect(n, n2, false);
        Rectangle rectangle2 = this.getCellRect(n3, n4, false);
        return rectangle.union(rectangle2);
    }

    private boolean shouldAllowChangingRow(int n) {
        if (this._currentRowIndex != -1 && n != this._currentRowIndex) {
            ValidationResult validationResult;
            ValidationResult validationResult2 = validationResult = this._currentRowValidationResult != null ? this._currentRowValidationResult : this.validateRow(this._currentRowIndex);
            if (validationResult != null && !validationResult.isValid()) {
                this._currentRowValidationResult = validationResult;
                return false;
            }
        }
        return true;
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        Object object;
        int n = tableColumn.getModelIndex();
        TableModel tableModel = this.getModel();
        if (tableColumn.getIdentifier() == null && tableModel instanceof ColumnIdentifierTableModel && n >= 0) {
            object = ((ColumnIdentifierTableModel)((Object)tableModel)).getColumnIdentifier(n);
            tableColumn.setIdentifier(object);
        }
        if ((object = TableModelWrapperUtils.getActualTableModel(tableModel, ColumnWidthTableModel.class)) instanceof ColumnWidthTableModel) {
            int n2;
            int n3;
            int n4 = TableModelWrapperUtils.getActualColumnAt(tableModel, n, (TableModel)object);
            int n5 = ((ColumnWidthTableModel)object).getPreferredWidth(n4);
            if (n5 != -1 && tableColumn.getPreferredWidth() == 75) {
                tableColumn.setPreferredWidth(n5);
            }
            if ((n3 = ((ColumnWidthTableModel)object).getMinimumWidth(n4)) != -1 && tableColumn.getMinWidth() == 15) {
                tableColumn.setMinWidth(n3);
            }
            if ((n2 = ((ColumnWidthTableModel)object).getMaximumWidth(n4)) != -1 && tableColumn.getMaxWidth() == Integer.MAX_VALUE) {
                tableColumn.setMaxWidth(n2);
            }
        }
        Object object2 = TableUtils.eraseIdentifierFlag(tableColumn.getIdentifier(), ":::DATA:::");
        Object object3 = this.getClientProperty("TableColumnIdentifier:" + object2);
        if (object3 == null || !(object3 instanceof TableColumn)) {
            super.addColumn(tableColumn);
            if (this._tableColumnPropertyListener != null) {
                tableColumn.removePropertyChangeListener(this._tableColumnPropertyListener);
                tableColumn.addPropertyChangeListener(this._tableColumnPropertyListener);
            }
        }
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        super.removeColumn(tableColumn);
        if (tableColumn != null && this._tableColumnPropertyListener != null) {
            tableColumn.removePropertyChangeListener(this._tableColumnPropertyListener);
        }
    }

    public void adjustSelectionWhenColumnMoved(int n, int n2) {
        TableSelectionModel tableSelectionModel = this.getTableSelectionModel();
        if (this.isNonContiguousCellSelection() && tableSelectionModel != null && !tableSelectionModel.isSelectionEmpty()) {
            for (int i = tableSelectionModel.getMinSelectedRowIndex(); i <= tableSelectionModel.getMaxSelectedRowIndex(); ++i) {
                boolean bl;
                boolean bl2 = tableSelectionModel.isSelected(i, n);
                if (bl2 == (bl = tableSelectionModel.isSelected(i, n2))) continue;
                if (bl2) {
                    tableSelectionModel.removeSelection(i, n);
                    tableSelectionModel.addSelection(i, n2);
                    continue;
                }
                tableSelectionModel.removeSelection(i, n2);
                tableSelectionModel.addSelection(i, n);
            }
        }
    }

    public void releaseRendererComponent(TableCellRenderer tableCellRenderer, int n, int n2, Component component) {
        this.internalReleaseRendererComponent(tableCellRenderer, n, n2, component, false);
    }

    void internalReleaseRendererComponent(TableCellRenderer tableCellRenderer, int n, int n2, Component component, boolean bl) {
        if (component != null && !this.isEnabled()) {
            component.setEnabled(true);
        }
    }

    Component prepareRendererForRowHeightCalculation(TableCellRenderer tableCellRenderer, int n, int n2) {
        return tableCellRenderer.getTableCellRendererComponent(this, this.getValueAt(n, n2), true, true, n, n2);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        boolean bl;
        boolean bl2;
        Object object = this.getValueAt(n, n2);
        Component component = tableCellRenderer.getTableCellRendererComponent(this, object, bl2 = !(this instanceof NavigationComponent) && (this.isNonContiguousCellSelection() && !this.isTablePrinting() || !this.isNonContiguousCellSelection() && (!SystemInfo.isJdk6Above() || !this.isPaintingForPrint())) && this.isCellSelected(n, n2) && this.shouldCellBePaintedAsSelected(n, n2), bl = !(this instanceof NavigationComponent) && this.isCellFocused(n, n2) && this.shouldCellBePaintedAsFocused(n, n2), n, n2);
        if (component != null && !this.isEnableIgnored()) {
            if (component.isEnabled() && !this.isEnabled()) {
                component.setEnabled(this.isEnabled());
            }
            if (this.isDisableUneditableCells() && this.isEnabled()) {
                component.setEnabled(this.isCellEditable(n, n2));
            }
            if (component instanceof RendererWrapper && ((RendererWrapper)((Object)component)).getActualRenderer() != null) {
                ((RendererWrapper)((Object)component)).getActualRenderer().setEnabled(component.isEnabled());
            }
        }
        return component;
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
        Class<?> clazz2;
        TableCellRenderer tableCellRenderer = super.getDefaultRenderer(clazz);
        if (tableCellRenderer == null && (clazz2 = TypeUtils.convertPrimitiveToWrapperType(clazz)) != null && clazz2 != clazz) {
            return this.getDefaultRenderer(clazz2);
        }
        return tableCellRenderer;
    }

    @Override
    public Color getSelectionBackground() {
        return this.isEnabled() || this.isEnableIgnored() ? super.getSelectionBackground() : Color.LIGHT_GRAY;
    }

    public boolean isColumnAutoResizable() {
        return this._columnAutoResizer != null;
    }

    public void setColumnAutoResizable(boolean bl) {
        if (bl) {
            if (this._columnAutoResizer == null) {
                this._columnAutoResizer = new TableColumnAutoResizer(this);
            }
        } else if (this._columnAutoResizer != null) {
            this._columnAutoResizer.uninstall();
            this._columnAutoResizer = null;
        }
    }

    public boolean isColumnResizable() {
        return this._columnResizer != null;
    }

    public void setColumnResizable(boolean bl) {
        if (bl) {
            if (this._columnResizer == null) {
                this._columnResizer = new TableColumnResizer(this);
            }
        } else if (this._columnResizer != null) {
            this._columnResizer.uninstall();
            this._columnResizer = null;
        }
    }

    public boolean isRowResizable() {
        return this._rowResizer != null;
    }

    public void setRowResizable(boolean bl) {
        if (bl) {
            if (this._rowResizer == null) {
                this._rowResizer = new TableRowResizer(this);
            }
        } else if (this._rowResizer != null) {
            this._rowResizer.uninstall();
            this._rowResizer = null;
        }
    }

    @Override
    public void selectAll() {
        if (!this.isNonContiguousCellSelection()) {
            super.selectAll();
        } else {
            if (this.isEditing()) {
                this.removeEditor();
            }
            super.selectAll();
            this.getTableSelectionModel().selectAll(this.getRowCount(), this.getColumnCount());
            this.repaint();
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(n2, n);
            Component component = this.prepareRenderer(tableCellRenderer, n2, n);
            if (component instanceof RendererWrapper) {
                component = ((RendererWrapper)((Object)component)).getActualRenderer();
            }
            if (component instanceof JComponent) {
                Rectangle rectangle = this.getCellRect(n2, n, false);
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                string = ((JComponent)component).getToolTipText(mouseEvent2);
            }
            this.releaseRendererComponent(tableCellRenderer, n2, n, component);
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public boolean isTablePrinting() {
        return this._tablePrinting;
    }

    public void setTablePrinting(boolean bl) {
        this._tablePrinting = bl;
    }

    public boolean isVariousRowHeights() {
        return this._variousRowHeights || this.isRowAutoResizes();
    }

    public void setVariousRowHeights(boolean bl) {
        this._variousRowHeightsSet = this._variousRowHeights = bl;
        this.revalidate();
        this.repaint();
    }

    boolean isVariousRowHeightsSet() {
        return this._variousRowHeightsSet;
    }

    protected TransferHandler createDefaultTransferHandler() {
        return SystemInfo.isJdk6Above() ? new JideTableTransferHandler() : this._originalTransferHandler;
    }

    public boolean isSelectInsertedRows() {
        return this._selectInsertedRows;
    }

    public void setSelectInsertedRows(boolean bl) {
        this._selectInsertedRows = bl;
    }

    @Deprecated
    public boolean isClearSelectionOnTableDataChanges() {
        return this._clearSelectionOnTableDataChanges;
    }

    @Deprecated
    public void setClearSelectionOnTableDataChanges(boolean bl) {
        boolean bl2 = this._clearSelectionOnTableDataChanges;
        if (bl2 != bl) {
            this._clearSelectionOnTableDataChanges = bl;
            this.firePropertyChange(PROPERTY_CLEAR_SELECTION_ON_TABLE_DATA_CHANGES, bl2, this._clearSelectionOnTableDataChanges);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.isNonContiguousCellSelection()) {
            super.valueChanged(listSelectionEvent);
        } else if (!listSelectionEvent.getValueIsAdjusting()) {
            this.getTableSelectionModel().moveLeadSelection(this.getSelectionModel().getLeadSelectionIndex(), this.getColumnModel().getSelectionModel().getLeadSelectionIndex());
        }
    }

    public void setClickCountToStart(int n) {
        this._clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this._clickCountToStart;
    }

    public GridColorProvider getGridColorProvider() {
        return this._gridColorProvider;
    }

    public void setGridColorProvider(GridColorProvider gridColorProvider) {
        this._gridColorProvider = gridColorProvider;
    }

    public Color getGridColor(int n) {
        GridColorProvider gridColorProvider = this.getGridColorProvider();
        if (gridColorProvider != null) {
            return gridColorProvider.getGridColor(n);
        }
        return null;
    }

    public Color getVerticalGridColor(int n) {
        GridColorProvider gridColorProvider = this.getGridColorProvider();
        if (gridColorProvider != null) {
            return gridColorProvider.getVerticalGridColor(n);
        }
        return null;
    }

    public TableColumnWidthKeeper getTableColumnWidthKeeper() {
        return this._tableColumnWidthKeeper;
    }

    public void setTableColumnWidthKeeper(TableColumnWidthKeeper tableColumnWidthKeeper) {
        this._tableColumnWidthKeeper = tableColumnWidthKeeper;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
    }

    public boolean isAutoStartCellEditing() {
        return this._autoStartCellEditing;
    }

    public void setAutoStartCellEditing(boolean bl) {
        this._autoStartCellEditing = bl;
    }

    protected boolean isAutoStartCellEditingKey(KeyStroke keyStroke) {
        return keyStroke.getKeyCode() == 9 || keyStroke.getKeyCode() == 10;
    }

    @Override
    public void addNotify() {
        if (this._focusLostRowValidator == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this._focusLostRowValidator = new FocusLostRowValidator(keyboardFocusManager);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", this._focusLostRowValidator);
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        if (this._editorRemover != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this._editorRemover);
            this._editorRemover = null;
        }
        if (this._rolloverEditorRemover != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this._rolloverEditorRemover);
            this._rolloverEditorRemover = null;
        }
        if (this._focusLostRowValidator != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this._focusLostRowValidator);
            this._focusLostRowValidator = null;
        }
        super.removeNotify();
    }

    @Override
    public void removeEditor() {
        Object object;
        Container container;
        Object object2;
        Object object3;
        AutoCompletion autoCompletion;
        Component component = this.getEditorComponent();
        JTextComponent jTextComponent = this.getTextComponentForEditorComponent(component);
        if (jTextComponent != null && (autoCompletion = AutoCompletion.getAutoCompletion(jTextComponent)) instanceof CellAutoCompletion) {
            autoCompletion.uninstallListeners();
        }
        boolean bl = false;
        if (component instanceof AbstractComboBox) {
            object3 = (AbstractComboBox)component;
            object2 = ((AbstractComboBox)object3).getPopupPanel();
            if (object2 != null) {
                container = ((JComponent)object2).getTopLevelAncestor();
                if (container instanceof JDialog) {
                    object2 = ((JDialog)container).getContentPane();
                }
                bl = (object = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && SwingUtilities.isDescendingFrom((Component)object, (Component)object2);
            }
        } else if (component instanceof ExComboBox && (object2 = ((ExComboBoxUI)((Object)((JComboBox)(object3 = (ExComboBox)component)).getUI())).getPopupPanel()) != null) {
            container = ((JComponent)object2).getTopLevelAncestor();
            if (container instanceof JDialog) {
                object2 = ((JDialog)container).getContentPane();
            }
            bl = (object = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && SwingUtilities.isDescendingFrom((Component)object, (Component)object2);
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this._editorRemover);
        this._editorRemover = null;
        object3 = this.getCellEditor();
        if (object3 != null) {
            object3.removeCellEditorListener(this);
            if (this.editorComp != null) {
                object2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean bl2 = object2 != null && SwingUtilities.isDescendingFrom((Component)object2, this);
                this.remove(this.editorComp);
                if (bl2) {
                    if (this.getClientProperty("terminateEditOnFocusLost") == Boolean.TRUE) {
                        this.requestFocusInWindow();
                    } else {
                        object = new Runnable(){

                            @Override
                            public void run() {
                                JideTable.this.requestFocusInWindow();
                            }
                        };
                        SwingUtilities.invokeLater((Runnable)object);
                    }
                }
            }
            object2 = this.getEditorCellRect(this.editingRow, this.editingColumn);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.setEditingRow(-1);
            this.editorComp = null;
            this.repaint((Rectangle)object2);
        }
        if (bl) {
            if (this.getClientProperty("terminateEditOnFocusLost") == Boolean.TRUE) {
                this.requestFocusInWindow();
            } else {
                object2 = new Runnable(){

                    @Override
                    public void run() {
                        JideTable.this.requestFocusInWindow();
                    }
                };
                SwingUtilities.invokeLater((Runnable)object2);
            }
        }
    }

    public boolean isAutoSelectTextWhenStartsEditing() {
        return this._autoSelectTextWhenStartsEditing;
    }

    public void setAutoSelectTextWhenStartsEditing(boolean bl) {
        this._autoSelectTextWhenStartsEditing = bl;
    }

    @Override
    public int convertRowIndexToView(int n) {
        if (SystemInfo.isJdk6Above()) {
            return super.convertRowIndexToView(n);
        }
        return n;
    }

    @Override
    public int convertRowIndexToModel(int n) {
        if (SystemInfo.isJdk6Above()) {
            return super.convertRowIndexToModel(n);
        }
        return n;
    }

    public boolean alwaysCalculateCellRect() {
        return false;
    }

    public boolean isCellContentVisible() {
        return this._cellContentVisible;
    }

    public void setCellContentVisible(boolean bl) {
        if (this._cellContentVisible != bl) {
            this._cellContentVisible = bl;
            if (this._cellContentVisible) {
                this.repaint();
            }
        }
    }

    public void configureEnclosingScrollPaneExplicitly() {
        super.configureEnclosingScrollPane();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl && this.isEditing()) {
            this.removeEditor();
        }
    }

    protected int getEditorAutoCompletionMode(int n, int n2) {
        return this.getEditorAutoCompletionMode();
    }

    public int getEditorAutoCompletionMode() {
        return this._editorAutoCompletionMode;
    }

    public void setEditorAutoCompletionMode(int n) {
        if (this._editorAutoCompletionMode != n) {
            int n2 = this._editorAutoCompletionMode;
            this._editorAutoCompletionMode = n;
            this.firePropertyChange(PROPERTY_EDITOR_AUTO_COMPLETION_MODE, n2, this._editorAutoCompletionMode);
        }
    }

    private void internalUninstallAutoFill() {
        Container container = this.getParent();
        if (container instanceof AutoFillTableViewport && container.getParent() instanceof JScrollPane) {
            ((AutoFillTableViewport)container).uninstallListeners();
            JScrollPane jScrollPane = (JScrollPane)container.getParent();
            JViewport jViewport = new JViewport();
            if (jScrollPane.getViewport().getView() == this) {
                this.updateViewport(jScrollPane, jViewport);
                jScrollPane.getViewport().setView(this);
                Component component = jScrollPane.getCorner("UPPER_TRAILING_CORNER");
                if (component instanceof AutoFillTableViewport.CornerFiller) {
                    jScrollPane.setCorner("UPPER_TRAILING_CORNER", null);
                }
            } else if (jScrollPane.getRowHeader() != null && jScrollPane.getRowHeader().getView() == this) {
                jViewport.setView(this);
                jViewport.setPreferredSize(jScrollPane.getRowHeader().getPreferredSize());
                jScrollPane.setRowHeader(jViewport);
            } else if (jScrollPane instanceof JideScrollPane) {
                if (((JideScrollPane)jScrollPane).getSubColumnHeader() != null && ((JideScrollPane)jScrollPane).getSubColumnHeader().getView() == this) {
                    jViewport.setView(this);
                    jViewport.setPreferredSize(((JideScrollPane)jScrollPane).getSubColumnHeader().getPreferredSize());
                    ((JideScrollPane)jScrollPane).setSubColumnHeader(jViewport);
                } else if (((JideScrollPane)jScrollPane).getRowFooter() != null && ((JideScrollPane)jScrollPane).getRowFooter().getView() == this) {
                    jViewport.setView(this);
                    jViewport.setPreferredSize(((JideScrollPane)jScrollPane).getRowFooter().getPreferredSize());
                    ((JideScrollPane)jScrollPane).setRowFooter(jViewport);
                }
            }
        }
    }

    protected boolean isCellFocused(int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.isNonContiguousCellSelection()) {
            if (this.getTableSelectionModel() != null && !this.isTablePrinting()) {
                bl = this.getTableSelectionModel().getLeadRowIndex() == n;
                bl2 = this.getTableSelectionModel().getLeadColumnIndex() == n2;
            }
        } else if (!SystemInfo.isJdk6Above() || !this.isPaintingForPrint()) {
            bl = this.getSelectionModel().getLeadSelectionIndex() == n;
            bl2 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex() == n2;
        }
        boolean bl3 = false;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null && (component == this || component == this._lastFocusTable)) {
            bl3 = true;
        }
        return bl && bl2 && bl3;
    }

    private void internalInstallAutoFill() {
        Container container = this.getParent();
        if (container instanceof JViewport && !(container instanceof AutoFillTableViewport) && container.getParent() instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container.getParent();
            AutoFillTableViewport autoFillTableViewport = new AutoFillTableViewport(this);
            if (jScrollPane.getViewport().getView() == this) {
                this.updateViewport(jScrollPane, autoFillTableViewport);
                jScrollPane.getViewport().setView(this);
                Component component = jScrollPane.getCorner("UPPER_TRAILING_CORNER");
                if (component == null || component instanceof AutoFillTableViewport.CornerFiller) {
                    jScrollPane.setCorner("UPPER_TRAILING_CORNER", AutoFillTableViewport.createCornerComponent(this));
                }
            } else if (jScrollPane.getRowHeader() != null && jScrollPane.getRowHeader().getView() == this) {
                ((JViewport)autoFillTableViewport).setView(this);
                jScrollPane.setRowHeader(autoFillTableViewport);
            } else if (jScrollPane instanceof JideScrollPane) {
                if (((JideScrollPane)jScrollPane).getSubColumnHeader() != null && ((JideScrollPane)jScrollPane).getSubColumnHeader().getView() == this) {
                    ((JViewport)autoFillTableViewport).setView(this);
                    ((JideScrollPane)jScrollPane).setSubColumnHeader(autoFillTableViewport);
                } else if (((JideScrollPane)jScrollPane).getRowFooter() != null && ((JideScrollPane)jScrollPane).getRowFooter().getView() == this) {
                    ((JViewport)autoFillTableViewport).setView(this);
                    ((JideScrollPane)jScrollPane).setRowFooter(autoFillTableViewport);
                } else if (((JideScrollPane)jScrollPane).getColumnFooter() != null && ((JideScrollPane)jScrollPane).getColumnFooter().getView() == this) {
                    ((JViewport)autoFillTableViewport).setView(this);
                    ((JideScrollPane)jScrollPane).setColumnFooter(autoFillTableViewport);
                }
            }
        }
    }

    private void unsynchronizeAllViewport(JViewport jViewport, Map<JViewport, Integer> map, Map<JViewport, Integer> map2) {
        if (jViewport == null) {
            return;
        }
        for (JViewport jViewport2 : map2.keySet()) {
            if (!(jViewport2 instanceof JViewport)) continue;
            JideSwingUtilities.unsynchronizeView(jViewport, jViewport2);
        }
        for (JViewport jViewport2 : map.keySet()) {
            if (!(jViewport2 instanceof JViewport)) continue;
            JideSwingUtilities.unsynchronizeView(jViewport2, jViewport);
        }
    }

    private void synchronizeAllViewport(JViewport jViewport, Map<JViewport, Integer> map, Map<JViewport, Integer> map2) {
        Integer n;
        if (jViewport == null) {
            return;
        }
        for (JViewport jViewport2 : map2.keySet()) {
            if (!(jViewport2 instanceof JViewport)) continue;
            n = map2.get(jViewport2);
            JideSwingUtilities.synchronizeView(jViewport, jViewport2, n instanceof Integer ? n : 0);
        }
        for (JViewport jViewport2 : map.keySet()) {
            if (!(jViewport2 instanceof JViewport)) continue;
            n = map.get(jViewport2);
            JideSwingUtilities.synchronizeView(jViewport2, jViewport, n instanceof Integer ? n : 0);
        }
    }

    private void updateViewport(JScrollPane jScrollPane, JViewport jViewport) {
        if (jScrollPane.getViewport() == jViewport) {
            return;
        }
        HashMap<JViewport, Integer> hashMap = new HashMap<JViewport, Integer>();
        HashMap<JViewport, Integer> hashMap2 = new HashMap<JViewport, Integer>();
        JViewport jViewport2 = jScrollPane.getViewport();
        if (jViewport2 != null) {
            Object object = jViewport2.getClientProperty("synchronizeViewMasterViewport");
            if (object instanceof Map) {
                hashMap.putAll((Map)object);
            }
            if ((object = jViewport2.getClientProperty("synchronizeViewSlaveViewport")) instanceof Map) {
                hashMap2.putAll((Map)object);
            }
            this.unsynchronizeAllViewport(jViewport2, hashMap, hashMap2);
        }
        jScrollPane.setViewport(jViewport);
        this.synchronizeAllViewport(jScrollPane.getViewport(), hashMap, hashMap2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        return super.getValueAt(n, n2);
    }

    public UndoManager getUndoManager() {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel(), UndoableSupport.class);
        if (tableModel instanceof UndoableSupport) {
            return ((UndoableSupport)((Object)tableModel)).getUndoManager();
        }
        return null;
    }

    private UndoableEditSupport getUndoableEditSupport() {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel(), UndoableSupport.class);
        if (tableModel instanceof UndoableSupport) {
            return ((UndoableSupport)((Object)tableModel)).getUndoableEditSupport();
        }
        return null;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        if (undoableEditSupport == null) {
            return;
        }
        undoableEditSupport.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        if (undoableEditSupport == null) {
            return;
        }
        undoableEditSupport.removeUndoableEditListener(undoableEditListener);
    }

    void updateSelectionFromUndoableEdit(UndoableTableModelEvent undoableTableModelEvent) {
        if (!(undoableTableModelEvent.getSource() instanceof TableModel)) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        UndoableTableModelEvent.TableModelEdit[] tableModelEditArray = undoableTableModelEvent.getEdits();
        TableModel tableModel = (TableModel)undoableTableModelEvent.getSource();
        if (this.isNonContiguousCellSelection()) {
            for (UndoableTableModelEvent.TableModelEdit tableModelEdit : tableModelEditArray) {
                if (tableModelEdit.getColumnIndex() < 0) {
                    int n;
                    if (tableModelEdit.getNewRowData() == null || tableModelEdit.getNewRowData().size() == 0) {
                        for (n = arrayList.size() - 2; n >= 0; n -= 2) {
                            Integer n2 = (Integer)arrayList.get(n);
                            if (n2 > tableModelEdit.getRowIndex()) {
                                arrayList.remove(n);
                                arrayList.add(n, n2 - 1);
                                continue;
                            }
                            if (n2.intValue() != tableModelEdit.getRowIndex()) continue;
                            arrayList.remove(n);
                        }
                        continue;
                    }
                    if (tableModelEdit.getOldRowData() != null && tableModelEdit.getOldRowData().size() > 0) {
                        for (n = 0; n < tableModel.getColumnCount(); ++n) {
                            boolean bl;
                            boolean bl2 = bl = n < tableModelEdit.getOldRowData().size() && n < tableModelEdit.getNewRowData().size() && JideSwingUtilities.equals(tableModelEdit.getOldRowData().get(n), tableModelEdit.getNewRowData().get(n), true);
                            if (bl) continue;
                            arrayList.add(tableModelEdit.getRowIndex());
                            arrayList.add(n);
                        }
                        continue;
                    }
                    for (n = 0; n < tableModel.getColumnCount(); ++n) {
                        arrayList.add(tableModelEdit.getRowIndex());
                        arrayList.add(n);
                    }
                    continue;
                }
                arrayList.add(tableModelEdit.getRowIndex());
                arrayList.add(tableModelEdit.getColumnIndex());
            }
            if (arrayList.size() >= 2) {
                int n = (Integer)arrayList.get(0);
                int n3 = (Integer)arrayList.get(1);
                arrayList.add(0, n);
                arrayList.add(1, n3);
                arrayList.add(2, n);
                arrayList.add(3, n3);
            }
        } else if (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
            int n = -1;
            for (UndoableTableModelEvent.TableModelEdit tableModelEdit : tableModelEditArray) {
                if (tableModelEdit.getColumnIndex() < 0 && (tableModelEdit.getNewRowData() == null || tableModelEdit.getNewRowData().size() == 0)) {
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        Integer n4 = (Integer)arrayList.get(i);
                        if (n4 > tableModelEdit.getRowIndex()) {
                            arrayList.remove(i);
                            arrayList.add(i, n4 - 1);
                            continue;
                        }
                        if (n4.intValue() != tableModelEdit.getRowIndex()) continue;
                        arrayList.remove(i);
                    }
                    continue;
                }
                arrayList.add(tableModelEdit.getRowIndex());
                if (tableModelEdit.getColumnIndex() < 0 || n >= 0) continue;
                n = tableModelEdit.getColumnIndex();
            }
            if (arrayList.size() >= 1) {
                int n5 = (Integer)arrayList.get(0);
                if (n < 0) {
                    n = TableModelWrapperUtils.getActualColumnAt(this.getModel(), this.getSelectedColumn(), tableModel);
                }
                arrayList.add(0, n5);
                arrayList.add(1, n);
                arrayList.add(2, n5);
                arrayList.add(3, n);
            }
        } else if (!this.getRowSelectionAllowed() && this.getColumnSelectionAllowed()) {
            int n = -1;
            for (UndoableTableModelEvent.TableModelEdit tableModelEdit : tableModelEditArray) {
                if (tableModelEdit.getColumnIndex() >= 0) {
                    arrayList.add(tableModelEdit.getColumnIndex());
                }
                if (tableModelEdit.getColumnIndex() < 0 && (tableModelEdit.getNewRowData() == null || tableModelEdit.getNewRowData().size() == 0) || tableModelEdit.getRowIndex() < 0 || n >= 0) continue;
                n = tableModelEdit.getRowIndex();
            }
            if (arrayList.size() >= 1) {
                int n6 = (Integer)arrayList.get(0);
                if (n < 0) {
                    n = TableModelWrapperUtils.getActualRowAt(this.getModel(), this.getSelectedRow(), tableModel);
                }
                arrayList.add(0, n);
                arrayList.add(1, n6);
                arrayList.add(2, n);
                arrayList.add(3, n6);
            }
        } else {
            for (UndoableTableModelEvent.TableModelEdit tableModelEdit : tableModelEditArray) {
                if (tableModelEdit.getColumnIndex() < 0) {
                    int n;
                    if (tableModelEdit.getNewRowData() == null || tableModelEdit.getNewRowData().size() == 0) {
                        for (n = arrayList.size() - 2; n >= 0; n -= 2) {
                            Integer n7 = (Integer)arrayList.get(n);
                            if (n7 > tableModelEdit.getRowIndex()) {
                                arrayList.remove(n);
                                arrayList.add(n, n7 - 1);
                                continue;
                            }
                            if (n7.intValue() != tableModelEdit.getRowIndex()) continue;
                            arrayList.remove(n);
                        }
                        continue;
                    }
                    if (tableModelEdit.getOldRowData() != null && tableModelEdit.getOldRowData().size() > 0) {
                        for (n = 0; n < tableModel.getColumnCount(); ++n) {
                            boolean bl;
                            boolean bl3 = bl = n < tableModelEdit.getOldRowData().size() && n < tableModelEdit.getNewRowData().size() && JideSwingUtilities.equals(tableModelEdit.getOldRowData().get(n), tableModelEdit.getNewRowData().get(n), true);
                            if (bl) continue;
                            arrayList.add(tableModelEdit.getRowIndex());
                            arrayList.add(n);
                        }
                        continue;
                    }
                    for (n = 0; n < tableModel.getColumnCount(); ++n) {
                        arrayList.add(tableModelEdit.getRowIndex());
                        arrayList.add(n);
                    }
                    continue;
                }
                arrayList.add(tableModelEdit.getRowIndex());
                arrayList.add(tableModelEdit.getColumnIndex());
            }
            if (arrayList.size() >= 2) {
                int n = (Integer)arrayList.get(0);
                int n8 = (Integer)arrayList.get(1);
                arrayList.add(0, n);
                arrayList.add(1, n8);
                arrayList.add(2, n);
                arrayList.add(3, n8);
            }
        }
        if (arrayList.size() > 0) {
            this._savedTableSelection = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this._savedTableSelection[i] = (Integer)arrayList.get(i);
            }
        }
    }

    public void addUndo(UndoableEdit undoableEdit) {
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        if (undoableEditSupport == null) {
            return;
        }
        UndoManager undoManager = this.getUndoManager();
        if (undoManager == null) {
            return;
        }
        if (undoableEdit instanceof UndoableTableModelEvent && ((UndoableTableModelEvent)undoableEdit).isUndoRedo()) {
            this.updateSelectionFromUndoableEdit((UndoableTableModelEvent)undoableEdit);
            this._needLoadRowSettings = true;
            return;
        }
        if (undoManager.getLimit() > 0) {
            undoManager.addEdit(undoableEdit);
            undoableEditSupport.postEdit(undoableEdit);
        }
    }

    private void resetEditingCell() {
        Component component = this.getEditorComponent();
        if (this.isAdjustEditorLocationOnModelChanged() && this.isEditing() && component != null && (this.getEditingRow() != this.getSelectedRow() || this.getEditingColumn() != this.getSelectedColumn())) {
            this.setEditingRow(this.getSelectedRow());
            this.setEditingColumn(this.getSelectedColumn());
            component.setBounds(this.getCellRect(this.getEditingRow(), this.getEditingColumn(), false));
            component.invalidate();
        }
    }

    public boolean addHiddenRow(int n) {
        if (this._hiddenRows == null) {
            this._hiddenRows = new ArrayList<Integer>();
        }
        int n2 = JideSwingUtilities.binarySearch(this._hiddenRows, Integer.valueOf(n));
        boolean bl = false;
        if (n2 < 0) {
            if ((n2 *= -1) < this._hiddenRows.size()) {
                this._hiddenRows.add(n2, n);
            } else {
                this._hiddenRows.add(n);
            }
            bl = true;
        } else if (n2 == 0) {
            if (this._hiddenRows.size() == 0) {
                this._hiddenRows.add(n);
                bl = true;
            }
            if (this._hiddenRows.get(0) != n) {
                this._hiddenRows.add(0, n);
                bl = true;
            }
        }
        if (bl) {
            this.invalidate();
            this.repaint();
        }
        return bl;
    }

    public void removeHiddenRow(int n) {
        if (this._hiddenRows != null) {
            Integer n2 = n;
            this._hiddenRows.remove(n2);
            this.invalidate();
            this.repaint();
        }
    }

    public void setHiddenRows(int[] nArray) {
        if (nArray == null) {
            this._hiddenRows = null;
        } else {
            this._hiddenRows = new ArrayList<Integer>();
            for (int n : nArray) {
                this._hiddenRows.add(n);
            }
        }
        this.invalidate();
        this.repaint();
    }

    public void clearHiddenRows() {
        this._hiddenRows = null;
        this.invalidate();
        this.repaint();
    }

    public int[] getHiddenRows() {
        if (this.isRowAutoResizes() || this.isVariousRowHeights() || this._hiddenRows == null) {
            return new int[0];
        }
        int[] nArray = new int[this._hiddenRows.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this._hiddenRows.get(i);
        }
        return nArray;
    }

    private int getHiddenRowCountBeforeRow(int n) {
        if (this.isRowAutoResizes() || this.isVariousRowHeights() || this._hiddenRows == null) {
            return 0;
        }
        int n2 = JideSwingUtilities.binarySearch(this._hiddenRows, Integer.valueOf(n));
        if (n2 >= 0) {
            return n2;
        }
        return 0 - n2;
    }

    public boolean isRowHidden(int n) {
        if (this.isRowAutoResizes() || this.isVariousRowHeights() || this._hiddenRows == null) {
            return false;
        }
        int n2 = JideSwingUtilities.binarySearch(this._hiddenRows, Integer.valueOf(n));
        if (n2 > 0) {
            return true;
        }
        if (n2 < 0) {
            return false;
        }
        if (this._hiddenRows == null || this._hiddenRows.size() == 0) {
            return false;
        }
        return this._hiddenRows.get(0) == n;
    }

    public boolean isDisableUneditableCells() {
        return this._disableUneditableCells;
    }

    public void setDisableUneditableCells(boolean bl) {
        this._disableUneditableCells = bl;
    }

    public boolean isRestoreSelectionAndRowHeightAutomatically() {
        return this._restoreSelectionAndRowHeightAutomatically;
    }

    public void setRestoreSelectionAndRowHeightAutomatically(boolean bl) {
        this._restoreSelectionAndRowHeightAutomatically = bl;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(JideTable.class.getName(), 4);
        }
        LOGGER_EVENT = Logger.getLogger(JideTable.class.getName());
    }

    private class CellAutoCompletion
    extends AutoCompletion {
        public CellAutoCompletion(JTextComponent jTextComponent, Object[] objectArray) {
            super(jTextComponent, objectArray);
        }
    }

    private class AutoFillViewportListener
    implements HierarchyListener {
        private AutoFillViewportListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (JideTable.this._autoFillListener != null) {
                JideTable.this.removeHierarchyListener(JideTable.this._autoFillListener);
                JideTable.this._autoFillListener = null;
            }
            JideTable.this.internalInstallAutoFill();
            JideTable.this._autoFillListener = new AutoFillViewportListener();
            JideTable.this.addHierarchyListener(JideTable.this._autoFillListener);
        }
    }

    protected static class NonContiguousTransferHandler
    extends TransferHandler
    implements UIResource,
    Serializable {
        protected NonContiguousTransferHandler() {
        }

        public Transferable createTransferableFromOutside(JComponent jComponent) {
            return this.createTransferable(jComponent);
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JideTable) {
                JideTable jideTable = (JideTable)jComponent;
                if (!jideTable.isNonContiguousCellSelection()) {
                    return null;
                }
                int[] nArray = jideTable.getSelectedRows();
                int[] nArray2 = jideTable.getSelectedColumns();
                if (nArray == null || nArray2 == null || nArray.length == 0 || nArray2.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<table>\n");
                for (int n : nArray) {
                    stringBuffer2.append("<tr>\n");
                    for (int n2 : nArray2) {
                        Object object = null;
                        if (jideTable.isCellSelected(n, n2)) {
                            object = jideTable.getValueAt(n, n2);
                        }
                        String string = this.convertElementToString(jideTable, n, n2, object);
                        stringBuffer.append(string).append("\t");
                        stringBuffer2.append("  <td>").append(string).append("</td>\n");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1).append("\n");
                    stringBuffer2.append("</tr>\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</table>\n</body>\n</html>");
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        protected String convertElementToString(JTable jTable, int n, int n2, Object object) {
            return object == null ? "" : object.toString();
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    class RolloverCellEditorRemover
    implements PropertyChangeListener,
    Serializable {
        KeyboardFocusManager focusManager;

        public RolloverCellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == JideTable.this) {
                    return;
                }
                if (!(component instanceof Window) && (!(component instanceof Applet) || component.getParent() != null)) continue;
                if (component != SwingUtilities.getRoot(JideTable.this) || !JideTable.this.isRollover() || JideTable.this._rolloverCellEditor.stopCellEditing() && !JideTable.this.isRollover()) break;
                JideTable.this._rolloverCellEditor.cancelCellEditing();
                break;
            }
        }
    }

    class FocusLostRowValidator
    implements PropertyChangeListener,
    Serializable {
        KeyboardFocusManager focusManager;

        public FocusLostRowValidator(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == JideTable.this) {
                    return;
                }
                if (!(component instanceof Window) && (!(component instanceof Applet) || component.getParent() != null)) continue;
                if (component != SwingUtilities.getRoot(JideTable.this)) break;
                JideTable.this.shouldAllowChangingRow(-1);
                JideTable.this._currentRowIndex = -1;
                break;
            }
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener,
    Serializable {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == JideTable.this) {
                    return;
                }
                if (!(component instanceof Window) && (!(component instanceof Applet) || component.getParent() != null)) continue;
                if (component != SwingUtilities.getRoot(JideTable.this) || !JideTable.this.isEditing() || JideTable.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) break;
                JideTable.this.getCellEditor().stopCellEditing();
                if (!JideTable.this.isEditing()) break;
                JideTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    private class SavedRowInfo
    implements Comparable<SavedRowInfo> {
        Integer _rowIndex;
        Integer _rowInfo;
        boolean _rowInfoCompare;

        public SavedRowInfo(int n, int n2, boolean bl) {
            this._rowIndex = n;
            this._rowInfo = n2;
            this._rowInfoCompare = bl;
        }

        @Override
        public int compareTo(SavedRowInfo savedRowInfo) {
            if (this._rowIndex == null) {
                return -1;
            }
            int n = this._rowIndex.compareTo(savedRowInfo._rowIndex);
            if (n == 0 && this._rowInfoCompare) {
                if (this._rowInfo == null) {
                    return -1;
                }
                return this._rowInfo.compareTo(savedRowInfo._rowInfo);
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof SavedRowInfo) {
                if (this._rowInfoCompare) {
                    return JideSwingUtilities.equals(this._rowIndex, ((SavedRowInfo)object)._rowIndex) && JideSwingUtilities.equals(this._rowInfo, ((SavedRowInfo)object)._rowInfo);
                }
                return JideSwingUtilities.equals(this._rowIndex, ((SavedRowInfo)object)._rowIndex);
            }
            return false;
        }
    }

    public static interface TextComponentProvider {
        public JTextComponent getTextComponent();
    }
}

