/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.DefaultTableModelWrapper;
import com.jidesoft.grid.ExpandedPanel;
import com.jidesoft.grid.HierarchicalRowHeights;
import com.jidesoft.grid.HierarchicalTableCellRenderer;
import com.jidesoft.grid.HierarchicalTableComponentFactory;
import com.jidesoft.grid.HierarchicalTableLayout;
import com.jidesoft.grid.HierarchicalTableModel;
import com.jidesoft.grid.HierarchicalTableSupport;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.IndexChangeEvent;
import com.jidesoft.grid.IndexChangeEventGenerator;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.RowHeights;
import com.jidesoft.grid.RowTableModelWrapper;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.DelegateMouseInputListener;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class HierarchicalTable
extends SortableTable
implements HierarchicalTableSupport {
    private static final String uiClassID = "HierarchicalTableUI";
    private boolean _init;
    private int _hierarchicalColumn = 0;
    private boolean _mouseEnabled = true;
    private boolean _singleExpansion = false;
    private boolean _autoRefreshOnRowUpdate = true;
    private boolean _selectRowWhenToggling = false;
    public static final String PROPERTY_SINGLE_EXPANSION = "singleExpansion";
    public static final String PROPERTY_MOUSE_ENABLED = "mouseEnabled";
    public static final String PROPERTY_HIERARCHICAL_COLUMN = "hierarchicalColumn";
    public static final String PROPERTY_SELECT_ROW_WHEN_TOGGLING = "selectRowWhenToggling";
    public static final String PROPERTY_DOUBLE_CLICK_ENABLED = "doubleClickEnabled";
    private boolean _doubleClickEnabled = true;
    private final Map<Integer, ExpandedPanel> _expanded = new HashMap<Integer, ExpandedPanel>();
    private HierarchicalTableComponentFactory _factory;
    private HierarchicalTableComponentListener _listener;
    private HierarchicalTableModelListener _tableModelListener;
    protected HierarchicalTableCellRenderer _hierarchicalTableCellRenderer;
    private boolean _originalRowsChanged;
    private boolean _paintMarginGridMarginBackground;
    private boolean _hierarchicalColumnSet = false;
    private boolean _changingSelection = false;

    public HierarchicalTable() {
        this.initializeTable();
    }

    public HierarchicalTable(TableModel tableModel) {
        super(tableModel);
        this.initializeTable();
    }

    public HierarchicalTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initializeTable();
    }

    public HierarchicalTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initializeTable();
    }

    public HierarchicalTable(int n, int n2) {
        super(n, n2);
        this.initializeTable();
    }

    public HierarchicalTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initializeTable();
    }

    public HierarchicalTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initializeTable();
    }

    @Override
    public String getActualUIClassID() {
        return uiClassID;
    }

    private void initializeTable() {
        if (!this._init) {
            Object object;
            boolean bl = false;
            if (SystemInfo.isJdk6Above() && !SystemInfo.isJdk7Above()) {
                object = this.getMouseListeners();
                MouseListener mouseListener = null;
                for (MouseListener mouseListener2 : object) {
                    if (mouseListener2.getClass().getName().indexOf("TableUI") == -1) continue;
                    mouseListener = mouseListener2;
                    this.removeMouseListener(mouseListener2);
                    if (!(mouseListener2 instanceof MouseMotionListener)) break;
                    this.removeMouseMotionListener((MouseMotionListener)((Object)mouseListener2));
                    break;
                }
                if (mouseListener != null && mouseListener instanceof MouseInputListener) {
                    MouseInputListener mouseInputListener = this.createExpandMouseInputListener((MouseInputListener)mouseListener);
                    JideSwingUtilities.insertMouseListener(this, mouseInputListener, 0);
                    JideSwingUtilities.insertMouseMotionListener(this, mouseInputListener, 0);
                    bl = true;
                }
            }
            if (!bl) {
                object = this.createExpandMouseListener();
                JideSwingUtilities.insertMouseListener(this, (MouseListener)object, 0);
                JideSwingUtilities.insertMouseMotionListener(this, (MouseMotionListener)object, 0);
            }
            this.setLayout(new HierarchicalTableLayout());
            this.installListeners(this.getModel(), null);
            this.addPropertyChangeListener("model", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HierarchicalTable.this.installListeners((TableModel)propertyChangeEvent.getNewValue(), (TableModel)propertyChangeEvent.getOldValue());
                }
            });
            this._listener = new HierarchicalTableComponentListener();
            this._init = true;
        }
    }

    private void installListeners(TableModel tableModel, TableModel tableModel2) {
        if (tableModel == tableModel2) {
            return;
        }
        if (this._tableModelListener == null) {
            this._tableModelListener = new HierarchicalTableModelListener();
        }
        if (tableModel2 != null) {
            tableModel2.removeTableModelListener(this._tableModelListener);
            if (tableModel2 instanceof IndexChangeEventGenerator) {
                ((IndexChangeEventGenerator)((Object)tableModel2)).removeIndexChangeListener(this._tableModelListener);
            }
        }
        if (tableModel != null) {
            tableModel.addTableModelListener(this._tableModelListener);
            if (tableModel instanceof IndexChangeEventGenerator) {
                ((IndexChangeEventGenerator)((Object)tableModel)).addIndexChangeListener(this._tableModelListener);
            }
        }
        if (this.getModel() != null) {
            this.collapseAllRows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Map<Integer, ExpandedPanel> map = this.getExpandedMap();
        Map<Integer, ExpandedPanel> map2 = this._expanded;
        synchronized (map2) {
            Collection<ExpandedPanel> collection = map.values();
            for (ExpandedPanel expandedPanel : collection) {
                JideSwingUtilities.setEnabledRecursively(expandedPanel, bl);
            }
        }
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        if (!this.isMouseEnabled()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        int n = this.getHierarchicalColumnViewIndex();
        HierarchicalTableModel hierarchicalTableModel = (HierarchicalTableModel)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), HierarchicalTableModel.class));
        if (this.isDoubleClickEnabled() && mouseEvent.getClickCount() == 2 && mouseEvent.getID() == 501) {
            int n2 = this.rowAtPoint(mouseEvent.getPoint());
            if (n2 != -1 && hierarchicalTableModel != null && hierarchicalTableModel.isExpandable(TableModelWrapperUtils.getActualRowAt(this.getModel(), n2, (TableModel)((Object)hierarchicalTableModel)))) {
                this.toggleRow(n2);
                mouseEvent.consume();
            }
        } else {
            int n3 = this.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0 && n3 != -1) {
                Rectangle rectangle = this.getCellRect(n3, n, true);
                if (this.getComponentOrientation().isLeftToRight()) {
                    if (mouseEvent.getX() - rectangle.x >= 0 && mouseEvent.getX() - rectangle.x < 16 && mouseEvent.getID() == 501 && mouseEvent.getY() - rectangle.y >= 0 && mouseEvent.getY() - rectangle.y < this.getActualRowHeight(n3) && hierarchicalTableModel != null && hierarchicalTableModel.isExpandable(TableModelWrapperUtils.getActualRowAt(this.getModel(), n3, (TableModel)((Object)hierarchicalTableModel)))) {
                        this.toggleRow(n3);
                        mouseEvent.consume();
                    }
                } else if (rectangle.x + rectangle.width - mouseEvent.getX() >= 0 && rectangle.x + rectangle.width - mouseEvent.getX() < 16 && mouseEvent.getID() == 501 && mouseEvent.getY() - rectangle.y >= 0 && mouseEvent.getY() - rectangle.y < this.getActualRowHeight(n3) && hierarchicalTableModel != null && hierarchicalTableModel.isExpandable(TableModelWrapperUtils.getActualRowAt(this.getModel(), n3, (TableModel)((Object)hierarchicalTableModel)))) {
                    this.toggleRow(n3);
                    mouseEvent.consume();
                }
            }
        }
    }

    @Override
    public boolean isActualRowExpanded(int n) {
        return this.getExpandedMap().get(n) != null;
    }

    @Override
    public boolean isExpanded(int n) {
        int n2 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, HierarchicalTableModel.class);
        return n2 >= 0 && this.isActualRowExpanded(n2);
    }

    private ExpandedPanel updateExpanded(int n) {
        return this.updateExpanded(n, false, null);
    }

    private ExpandedPanel updateExpanded(int n, ExpandedPanel expandedPanel) {
        if (expandedPanel != null) {
            return this.updateExpanded(n, true, expandedPanel);
        }
        return this.updateExpanded(n, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExpandedPanel updateExpanded(int n, boolean bl, ExpandedPanel expandedPanel) {
        Map<Integer, ExpandedPanel> map = this.getExpandedMap();
        Map<Integer, ExpandedPanel> map2 = this._expanded;
        synchronized (map2) {
            if (bl) {
                map.put(n, expandedPanel);
                return expandedPanel;
            }
            expandedPanel = map.get(n);
            map.remove(n);
            return expandedPanel;
        }
    }

    public boolean isAnyExpanded() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isExpanded(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getHierarchicalColumnViewIndex() {
        HierarchicalTableModel hierarchicalTableModel = (HierarchicalTableModel)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), HierarchicalTableModel.class));
        if (hierarchicalTableModel == null) {
            return -1;
        }
        if (!this._hierarchicalColumnSet) {
            return 0;
        }
        return this.convertColumnIndexToView(this.getHierarchicalColumn());
    }

    @Override
    public int getHierarchicalColumn() {
        return this._hierarchicalColumn;
    }

    @Override
    public void setHierarchicalColumn(int n) {
        if (this._hierarchicalColumn != n) {
            int n2 = this._hierarchicalColumn;
            this._hierarchicalColumn = n;
            this._hierarchicalColumnSet = true;
            this.firePropertyChange(PROPERTY_HIERARCHICAL_COLUMN, n2, this._hierarchicalColumn);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 == this.getHierarchicalColumnViewIndex()) {
            TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
            if (this._hierarchicalTableCellRenderer == null) {
                this._hierarchicalTableCellRenderer = this.createHierarchicalTableCellRenderer();
            }
            if (tableCellRenderer != null) {
                this._hierarchicalTableCellRenderer.setActualCellRenderer(tableCellRenderer);
            }
            return this._hierarchicalTableCellRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    protected HierarchicalTableCellRenderer createHierarchicalTableCellRenderer() {
        return new HierarchicalTableCellRenderer();
    }

    @Override
    public void toggleRow(int n) {
        if (this.isExpanded(n)) {
            this.collapseRow(n);
        } else {
            this.expandRow(n);
        }
    }

    @Override
    public void expandRow(int n) {
        if (!this.isExpanded(n)) {
            HierarchicalTableModel hierarchicalTableModel = (HierarchicalTableModel)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), HierarchicalTableModel.class));
            if (hierarchicalTableModel == null) {
                return;
            }
            int n2 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, HierarchicalTableModel.class);
            if (!hierarchicalTableModel.isExpandable(n2)) {
                return;
            }
            try {
                this.fireTreeWillExpand(this.getTreePathOf(n));
            }
            catch (ExpandVetoException expandVetoException) {
                return;
            }
            if (hierarchicalTableModel.hasChild(n2)) {
                Object object;
                Component component;
                HierarchicalTableComponentFactory hierarchicalTableComponentFactory = this.getComponentFactory();
                if (hierarchicalTableComponentFactory == null) {
                    return;
                }
                if (this.isSingleExpansion()) {
                    this.collapseAllRows();
                }
                if ((component = hierarchicalTableComponentFactory.createChildComponent(this, object = hierarchicalTableModel.getChildValueAt(n2), n2)) != null) {
                    component.applyComponentOrientation(this.getComponentOrientation());
                    ExpandedPanel expandedPanel = new ExpandedPanel(n2, component, this);
                    this.updateExpanded(n2, true, expandedPanel);
                    this.add(expandedPanel);
                    expandedPanel.getComponent().addComponentListener(this.getChildComponentResizeListener());
                    this.doLayout();
                    this.fireTreeExpanded(this.getTreePathOf(n));
                    this.scrollRowToVisible(n);
                }
            }
        }
        if (this.isSelectRowWhenToggling()) {
            this.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    @Override
    public void collapseRow(int n) {
        if (this.isExpanded(n)) {
            HierarchicalTableModel hierarchicalTableModel = (HierarchicalTableModel)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), HierarchicalTableModel.class));
            if (hierarchicalTableModel == null) {
                return;
            }
            int n2 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, HierarchicalTableModel.class);
            if (!hierarchicalTableModel.isExpandable(n2)) {
                return;
            }
            try {
                this.fireTreeWillCollapse(this.getTreePathOf(n));
            }
            catch (ExpandVetoException expandVetoException) {
                return;
            }
            if (hierarchicalTableModel.hasChild(n2)) {
                ExpandedPanel expandedPanel = this.updateExpanded(n2, false, null);
                this.setRowHeight(n, this.getActualRowHeight(n));
                if (expandedPanel != null) {
                    this.remove(expandedPanel);
                    expandedPanel.getComponent().removeComponentListener(this.getChildComponentResizeListener());
                    HierarchicalTableComponentFactory hierarchicalTableComponentFactory = this.getComponentFactory();
                    if (hierarchicalTableComponentFactory != null) {
                        hierarchicalTableComponentFactory.destroyChildComponent(this, expandedPanel.getComponent(), n2);
                    }
                    this.doLayout();
                    this.fireTreeCollapsed(this.getTreePathOf(n));
                }
            }
        }
        if (this.isSelectRowWhenToggling()) {
            this.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    @Override
    public void refreshRow(int n) {
        HierarchicalTableModel hierarchicalTableModel = (HierarchicalTableModel)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), HierarchicalTableModel.class));
        if (hierarchicalTableModel == null) {
            return;
        }
        int n2 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, HierarchicalTableModel.class);
        if (this.isExpanded(n)) {
            if (hierarchicalTableModel.hasChild(n2) && hierarchicalTableModel.isExpandable(n2)) {
                Object object;
                Component component;
                HierarchicalTableComponentFactory hierarchicalTableComponentFactory = this.getComponentFactory();
                if (hierarchicalTableComponentFactory == null) {
                    return;
                }
                ExpandedPanel expandedPanel = this.updateExpanded(n2, false, null);
                this.setRowHeight(n, this.getActualRowHeight(n));
                if (expandedPanel != null) {
                    this.remove(expandedPanel);
                    int n3 = expandedPanel.getVisualRow();
                    if (n3 != -1) {
                        this.setRowHeight(n3, this.getActualRowHeight(n3));
                    }
                    expandedPanel.getComponent().removeComponentListener(this.getChildComponentResizeListener());
                    hierarchicalTableComponentFactory.destroyChildComponent(this, expandedPanel.getComponent(), n2);
                }
                if (n2 < ((TableModel)((Object)hierarchicalTableModel)).getRowCount() && (component = hierarchicalTableComponentFactory.createChildComponent(this, object = hierarchicalTableModel.getChildValueAt(n2), n2)) != null) {
                    component.applyComponentOrientation(this.getComponentOrientation());
                    expandedPanel = new ExpandedPanel(n2, component, this);
                    this.updateExpanded(n2, true, expandedPanel);
                    this.add(expandedPanel);
                    expandedPanel.getComponent().addComponentListener(this.getChildComponentResizeListener());
                    this.doLayout();
                }
            } else {
                ExpandedPanel expandedPanel = this.updateExpanded(n2, false, null);
                this.setRowHeight(n, this.getActualRowHeight(n));
                if (expandedPanel != null) {
                    this.remove(expandedPanel);
                    int n4 = expandedPanel.getVisualRow();
                    if (n4 != -1) {
                        this.setRowHeight(n4, this.getActualRowHeight(n4));
                    }
                    expandedPanel.getComponent().removeComponentListener(this.getChildComponentResizeListener());
                    HierarchicalTableComponentFactory hierarchicalTableComponentFactory = this.getComponentFactory();
                    if (hierarchicalTableComponentFactory != null) {
                        hierarchicalTableComponentFactory.destroyChildComponent(this, expandedPanel.getComponent(), n2);
                    }
                    this.doLayout();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collapseAllRows() {
        this.setBatchProcessing(true);
        this.clearSavedRowHeights();
        boolean bl = this.isScrollRowWhenRowHeightChanges();
        this.setScrollRowWhenRowHeightChanges(false);
        boolean bl2 = false;
        try {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.isExpanded(i)) continue;
                this.collapseRow(i);
                bl2 = true;
            }
        }
        finally {
            if (bl2) {
                this.resizeAndRepaint();
                super.doLayout();
            }
            this.setBatchProcessing(false);
            this.setScrollRowWhenRowHeightChanges(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expandAllRows() {
        this.setBatchProcessing(true);
        this.clearSavedRowHeights();
        boolean bl = this.isScrollRowWhenRowHeightChanges();
        this.setScrollRowWhenRowHeightChanges(false);
        boolean bl2 = false;
        try {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.isExpanded(i)) continue;
                this.expandRow(i);
                bl2 = true;
            }
        }
        finally {
            if (bl2) {
                this.resizeAndRepaint();
                super.doLayout();
            }
            this.setBatchProcessing(false);
            this.setScrollRowWhenRowHeightChanges(bl);
        }
    }

    @Override
    public void doLayout() {
        if (!this.isBatchProcessing()) {
            boolean bl = this.isScrollRowWhenRowHeightChanges();
            try {
                this.setScrollRowWhenRowHeightChanges(false);
                super.doLayout();
            }
            finally {
                this.setScrollRowWhenRowHeightChanges(bl);
            }
        }
    }

    public Component getChildComponentAt(int n) {
        ExpandedPanel expandedPanel = this.getExpandedMap().get(n);
        if (expandedPanel != null) {
            return expandedPanel.getComponent();
        }
        return null;
    }

    public boolean isPaintMarginGridMarginBackground() {
        return this._paintMarginGridMarginBackground;
    }

    public void setPaintMarginGridMarginBackground(boolean bl) {
        this._paintMarginGridMarginBackground = bl;
    }

    protected void childComponentResized() {
        if (!this.isBatchProcessing()) {
            this.resizeAndRepaint();
            this.doLayout();
        }
    }

    public boolean isAutoRefreshOnRowUpdate() {
        return this._autoRefreshOnRowUpdate;
    }

    public void setAutoRefreshOnRowUpdate(boolean bl) {
        this._autoRefreshOnRowUpdate = bl;
    }

    public boolean isSingleExpansion() {
        return this._singleExpansion;
    }

    public void setSingleExpansion(boolean bl) {
        if (bl != this._singleExpansion) {
            boolean bl2 = this._singleExpansion;
            this._singleExpansion = bl;
            this.firePropertyChange(PROPERTY_SINGLE_EXPANSION, bl2, this._singleExpansion);
        }
    }

    public boolean isMouseEnabled() {
        return this._mouseEnabled;
    }

    public void setMouseEnabled(boolean bl) {
        if (bl != this._mouseEnabled) {
            boolean bl2 = this._mouseEnabled;
            this._mouseEnabled = bl;
            this.firePropertyChange(PROPERTY_SINGLE_EXPANSION, bl2, this._mouseEnabled);
        }
    }

    public HierarchicalTableComponentFactory getComponentFactory() {
        return this._factory;
    }

    public void setComponentFactory(HierarchicalTableComponentFactory hierarchicalTableComponentFactory) {
        this._factory = hierarchicalTableComponentFactory;
    }

    @Override
    protected RowHeights createRowHeights() {
        return new HierarchicalRowHeights(this.getRowCount(), this.getRowHeight());
    }

    @Override
    protected boolean isRowHeightChanged(int n, int n2) {
        if (((HierarchicalRowHeights)this.getRowHeights()).getActualRowHeight(n) != n2) {
            ((HierarchicalRowHeights)this.getRowHeights()).setActualRowHeight(n, n2);
            if (!this.isExpanded(n)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getActualRowHeight(int n) {
        if (this.getRowHeights() instanceof HierarchicalRowHeights) {
            return ((HierarchicalRowHeights)this.getRowHeights()).getActualRowHeight(n);
        }
        return super.getRowHeight(n);
    }

    @Override
    public void setActualRowHeight(int n, int n2) {
        if (this.getRowHeights() instanceof HierarchicalRowHeights) {
            if (((HierarchicalRowHeights)this.getRowHeights()).getActualRowHeight(n) != n2) {
                super.setRowHeight(n, n2);
                ((HierarchicalRowHeights)this.getRowHeights()).setActualRowHeight(n, n2);
                this.resizeAndRepaint();
            }
        } else {
            super.setRowHeight(n, n2);
        }
    }

    @Override
    void resizeTableRowHeight(int n, int n2) {
        this.setActualRowHeight(n, n2);
    }

    @Override
    protected void muteDefaultKeyStroke() {
        super.muteDefaultKeyStroke();
        this.replaceAction(KeyStroke.getKeyStroke(37, 0));
        this.replaceAction(KeyStroke.getKeyStroke(39, 0));
    }

    @Override
    protected Action createDelegateAction(Action action, KeyStroke keyStroke) {
        return new HierarchicalTableAction(action, keyStroke);
    }

    protected MouseInputListener createExpandMouseListener() {
        return new ExpandMouseListener();
    }

    protected MouseInputListener createExpandMouseInputListener(MouseInputListener mouseInputListener) {
        return new DelegateExpandMouseInputListener(mouseInputListener);
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.add(TreeExpansionListener.class, treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.remove(TreeExpansionListener.class, treeExpansionListener);
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        return (TreeExpansionListener[])this.listenerList.getListeners(TreeExpansionListener.class);
    }

    public void fireTreeExpanded(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeExpansionListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeExpansionListener)objectArray[i + 1]).treeExpanded(treeExpansionEvent);
        }
    }

    public void fireTreeCollapsed(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeExpansionListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeExpansionListener)objectArray[i + 1]).treeCollapsed(treeExpansionEvent);
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.add(TreeWillExpandListener.class, treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.remove(TreeWillExpandListener.class, treeWillExpandListener);
    }

    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        return (TreeWillExpandListener[])this.listenerList.getListeners(TreeWillExpandListener.class);
    }

    public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeWillExpandListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeWillExpandListener)objectArray[i + 1]).treeWillExpand(treeExpansionEvent);
        }
    }

    public void fireTreeWillCollapse(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeWillExpandListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeWillExpandListener)objectArray[i + 1]).treeWillCollapse(treeExpansionEvent);
        }
    }

    TreePath getTreePathOf(int n) {
        return new TreePath(n);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (!bl) {
            return bl;
        }
        Rectangle rectangle = this.editorComp.getBounds();
        rectangle.height = this.getActualRowHeight(n) - this.getIntercellSpacing().height;
        this.editorComp.setBounds(rectangle);
        return bl;
    }

    @Override
    public boolean rolloverCellAt(int n, int n2) {
        boolean bl = super.rolloverCellAt(n, n2);
        if (!bl) {
            return bl;
        }
        Rectangle rectangle = this._rolloverEditorComp.getBounds();
        rectangle.height = this.getActualRowHeight(n) - this.getIntercellSpacing().height;
        this._rolloverEditorComp.setBounds(rectangle);
        return bl;
    }

    @Override
    public Rectangle getCellRect(int n, int n2, boolean bl) {
        Rectangle rectangle = super.getCellRect(n, n2, bl);
        if (this._changingSelection && this.isExpanded(n)) {
            int n3;
            Component component = JideSwingUtilities.getScrollPane(this);
            int n4 = n3 = component == null ? this.getHeight() : component.getHeight();
            if (rectangle.height > n3) {
                rectangle.height = bl ? Math.max(n3, this.getActualRowHeight(n)) : Math.max(n3, this.getActualRowHeight(n) - this.getIntercellSpacing().height);
            }
        }
        return rectangle;
    }

    @Override
    public Rectangle getEditorCellRect(int n, int n2) {
        Rectangle rectangle = super.getEditorCellRect(n, n2);
        if (n2 == this.getHierarchicalColumnViewIndex() && this.getCellRenderer(n, n2) instanceof HierarchicalTableCellRenderer) {
            int n3 = 17;
            if (this.getComponentOrientation().isLeftToRight()) {
                rectangle.x += n3;
                rectangle.width -= n3;
            } else {
                rectangle.width -= n3;
            }
            rectangle.height = this.getActualRowHeight(n) - this.getIntercellSpacing().height;
        }
        rectangle.height = this.getActualRowHeight(n) - this.getIntercellSpacing().height;
        return rectangle;
    }

    @Override
    void internalReleaseRendererComponent(TableCellRenderer tableCellRenderer, int n, int n2, Component component, boolean bl) {
        super.internalReleaseRendererComponent(tableCellRenderer, n, n2, component, bl);
        if (tableCellRenderer instanceof HierarchicalTableCellRenderer) {
            ((HierarchicalTableCellRenderer)tableCellRenderer).releaseCellRenderer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        this._changingSelection = true;
        try {
            super.changeSelection(n, n2, bl, bl2);
        }
        finally {
            this._changingSelection = false;
        }
    }

    private Map<Integer, ExpandedPanel> getExpandedMap() {
        return this._expanded;
    }

    @Override
    public boolean isVariousRowHeights() {
        return true;
    }

    protected ComponentListener getChildComponentResizeListener() {
        return this._listener;
    }

    @Override
    public int getHorizontalLegPosition(int n) {
        return n / 2;
    }

    public boolean isSelectRowWhenToggling() {
        return this._selectRowWhenToggling;
    }

    public void setSelectRowWhenToggling(boolean bl) {
        boolean bl2 = this._selectRowWhenToggling;
        if (this._selectRowWhenToggling != bl) {
            this._selectRowWhenToggling = bl;
            this.firePropertyChange(PROPERTY_SELECT_ROW_WHEN_TOGGLING, bl2, bl);
        }
    }

    @Override
    public boolean alwaysCalculateCellRect() {
        return true;
    }

    public boolean isDoubleClickEnabled() {
        return this._doubleClickEnabled;
    }

    public void setDoubleClickEnabled(boolean bl) {
        boolean bl2 = this._doubleClickEnabled;
        if (bl2 != bl) {
            this._doubleClickEnabled = bl;
            this.firePropertyChange(PROPERTY_DOUBLE_CLICK_ENABLED, bl2, bl);
        }
    }

    @Override
    protected JideTable.CellEditorRemover createEditorRemover(KeyboardFocusManager keyboardFocusManager) {
        return new HierarchicalTableCellEditorRemover(keyboardFocusManager);
    }

    class HierarchicalTableCellEditorRemover
    extends JideTable.CellEditorRemover {
        public HierarchicalTableCellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            super(HierarchicalTable.this, keyboardFocusManager);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == HierarchicalTable.this) {
                    return;
                }
                if (!(component instanceof Window) && (!(component instanceof Applet) || component.getParent() != null)) continue;
                if (component != SwingUtilities.getRoot(HierarchicalTable.this) || !HierarchicalTable.this.isEditing() || HierarchicalTable.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) break;
                HierarchicalTable.this.getCellEditor().stopCellEditing();
                if (!HierarchicalTable.this.isEditing()) break;
                HierarchicalTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    protected static class HierarchicalTableAction
    extends CellSpanTable.DelegateAction {
        private static final long serialVersionUID = 6618398357385770062L;

        public HierarchicalTableAction(Action action, KeyStroke keyStroke) {
            super(action, keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HierarchicalTable hierarchicalTable = (HierarchicalTable)actionEvent.getSource();
            boolean bl = false;
            switch (this._keyStroke.getKeyCode()) {
                case 37: {
                    bl = this.expandSelectedRow(hierarchicalTable, false);
                    break;
                }
                case 39: {
                    bl = this.expandSelectedRow(hierarchicalTable, true);
                }
            }
            if (!bl) {
                super.actionPerformed(actionEvent);
            }
        }

        private boolean expandSelectedRow(HierarchicalTable hierarchicalTable, boolean bl) {
            int n = hierarchicalTable.getSelectedRow();
            int n2 = hierarchicalTable.getSelectedColumn();
            if (n != -1 && n2 == hierarchicalTable.getHierarchicalColumn()) {
                HierarchicalTableModel hierarchicalTableModel = (HierarchicalTableModel)((Object)TableModelWrapperUtils.getActualTableModel(hierarchicalTable.getModel(), HierarchicalTableModel.class));
                if (hierarchicalTableModel == null) {
                    return false;
                }
                int n3 = TableModelWrapperUtils.getActualRowAt(hierarchicalTable.getModel(), n, HierarchicalTableModel.class);
                if (bl && hierarchicalTableModel.isExpandable(n3) && hierarchicalTableModel.hasChild(n3) && !hierarchicalTable.isExpanded(n)) {
                    hierarchicalTable.expandRow(n);
                    return true;
                }
                if (!bl && hierarchicalTable.isExpanded(n)) {
                    hierarchicalTable.collapseRow(n);
                    return true;
                }
            }
            return false;
        }
    }

    protected class DelegateExpandMouseInputListener
    extends DelegateMouseInputListener {
        public DelegateExpandMouseInputListener(MouseInputListener mouseInputListener) {
            super(mouseInputListener);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (HierarchicalTable.this.isColumnResizable() && TableUtils.getResizingColumn(HierarchicalTable.this, mouseEvent.getPoint(), HierarchicalTable.this.columnAtPoint(mouseEvent.getPoint())) != null) {
                return;
            }
            HierarchicalTable.this.handleMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (HierarchicalTable.this._columnResizer != null && HierarchicalTable.this._columnResizer.isResizing()) {
                return;
            }
            HierarchicalTable.this.handleMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (HierarchicalTable.this._columnResizer != null && HierarchicalTable.this._columnResizer.isResizing()) {
                return;
            }
            HierarchicalTable.this.handleMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (HierarchicalTable.this._columnResizer != null && HierarchicalTable.this._columnResizer.isResizing()) {
                return;
            }
            super.mouseMoved(mouseEvent);
        }
    }

    protected class ExpandMouseListener
    extends MouseInputAdapter {
        protected ExpandMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            HierarchicalTable.this.handleMouseEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            HierarchicalTable.this.handleMouseEvent(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            HierarchicalTable.this.handleMouseEvent(mouseEvent);
        }
    }

    class HierarchicalTableModelListener
    implements TableModelListener,
    IndexChangeListener {
        private boolean _cacheEnable;

        HierarchicalTableModelListener() {
        }

        @Override
        public void indexChanged(IndexChangeEvent indexChangeEvent) {
            if (indexChangeEvent.getType() == 0) {
                if (HierarchicalTable.this.getModel() instanceof DefaultTableModelWrapper) {
                    this._cacheEnable = ((DefaultTableModelWrapper)HierarchicalTable.this.getModel()).isCacheEnabled();
                    ((DefaultTableModelWrapper)HierarchicalTable.this.getModel()).setCacheEnabled(false);
                }
            } else if (indexChangeEvent.getType() == 1 && HierarchicalTable.this.getModel() instanceof DefaultTableModelWrapper) {
                ((DefaultTableModelWrapper)HierarchicalTable.this.getModel()).setCacheEnabled(this._cacheEnable);
                this._cacheEnable = false;
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent instanceof CompoundTableModelEvent) {
                if (((CompoundTableModelEvent)tableModelEvent).isOriginalChanged()) {
                    TableModelEvent tableModelEvent2 = ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent();
                    HierarchicalTable.this._originalRowsChanged = tableModelEvent2.getType() != 0 || tableModelEvent2.getFirstRow() < 0 || tableModelEvent2.getFirstRow() > HierarchicalTable.this.getRowCount() || tableModelEvent2.getLastRow() < 0 || tableModelEvent2.getLastRow() > HierarchicalTable.this.getRowCount();
                } else {
                    HierarchicalTable.this._originalRowsChanged = false;
                }
            } else {
                HierarchicalTable.this._originalRowsChanged = true;
            }
            if (tableModelEvent.getType() == 0) {
                if (tableModelEvent.getFirstRow() == -1) {
                    if (TableModelWrapperUtils.getActualTableModel(HierarchicalTable.this.getModel()) != null) {
                        HierarchicalTable.this.collapseAllRows();
                    }
                } else if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                    if (tableModelEvent instanceof CompoundTableModelEvent) {
                        this.tableDataChanged((CompoundTableModelEvent)tableModelEvent);
                    }
                } else if (tableModelEvent.getColumn() == -1 && HierarchicalTable.this.isAutoRefreshOnRowUpdate()) {
                    this.tableRowsUpdated();
                }
            } else if (tableModelEvent instanceof CompoundTableModelEvent) {
                this.tableDataChanged((CompoundTableModelEvent)tableModelEvent);
            } else if (tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == -1) {
                this.tableRowsDeleted(tableModelEvent);
            } else if (tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 1) {
                this.tableRowsInserted(tableModelEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tableRowsUpdated() {
            HierarchicalTableModel hierarchicalTableModel = (HierarchicalTableModel)((Object)TableModelWrapperUtils.getActualTableModel(HierarchicalTable.this.getModel(), HierarchicalTableModel.class));
            if (!(hierarchicalTableModel instanceof TableModel)) {
                return;
            }
            Map map = HierarchicalTable.this.getExpandedMap();
            Map map2 = HierarchicalTable.this._expanded;
            synchronized (map2) {
                Integer[] integerArray;
                for (Integer n : integerArray = map.keySet().toArray(new Integer[map.keySet().size()])) {
                    int n2 = TableModelWrapperUtils.getRowAt(HierarchicalTable.this.getModel(), (TableModel)((Object)hierarchicalTableModel), n);
                    if (n2 < 0) continue;
                    HierarchicalTable.this.refreshRow(n2);
                }
            }
        }

        private boolean hasFilter() {
            IFilterableTableModel iFilterableTableModel = (IFilterableTableModel)TableModelWrapperUtils.getActualTableModel(HierarchicalTable.this.getModel(), IFilterableTableModel.class);
            while (iFilterableTableModel != null) {
                if (iFilterableTableModel.hasFilter() && iFilterableTableModel.isFiltersApplied()) {
                    return true;
                }
                if (!(iFilterableTableModel instanceof TableModelWrapper)) break;
                iFilterableTableModel = (IFilterableTableModel)TableModelWrapperUtils.getActualTableModel(((TableModelWrapper)((Object)iFilterableTableModel)).getActualModel(), IFilterableTableModel.class);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tableDataChanged(CompoundTableModelEvent compoundTableModelEvent) {
            TableModelEvent tableModelEvent = compoundTableModelEvent.getOriginalEvent();
            Map map = HierarchicalTable.this.getExpandedMap();
            Map map2 = HierarchicalTable.this._expanded;
            synchronized (map2) {
                if (tableModelEvent == null) {
                    Integer[] integerArray;
                    HierarchicalTableModel hierarchicalTableModel = (HierarchicalTableModel)((Object)TableModelWrapperUtils.getActualTableModel(HierarchicalTable.this.getModel(), HierarchicalTableModel.class));
                    if (!(hierarchicalTableModel instanceof TableModel)) {
                        return;
                    }
                    if (!this.hasFilter() && map.isEmpty()) {
                        return;
                    }
                    Integer[] integerArray2 = integerArray = map.keySet().toArray(new Integer[map.keySet().size()]);
                    int n = integerArray2.length;
                    for (int i = 0; i < n; ++i) {
                        int n2 = integerArray2[i];
                        int n3 = TableModelWrapperUtils.getRowAt(HierarchicalTable.this.getModel(), (TableModel)((Object)hierarchicalTableModel), n2);
                        if (n3 < 0) continue;
                        HierarchicalTable.this.refreshRow(n3);
                    }
                    return;
                }
                if (tableModelEvent.getType() == 0) {
                    if (tableModelEvent.getFirstRow() == -1) {
                        HierarchicalTable.this.collapseAllRows();
                    } else {
                        this.tableRowsUpdated();
                    }
                } else if (tableModelEvent.getType() == 1) {
                    Object[] objectArray = map.keySet().toArray(new Integer[map.keySet().size()]);
                    Arrays.sort(objectArray);
                    int n = tableModelEvent.getLastRow() - tableModelEvent.getFirstRow() + 1;
                    for (int i = objectArray.length - 1; i >= 0; --i) {
                        int n4 = (Integer)objectArray[i];
                        if (n4 < tableModelEvent.getFirstRow()) continue;
                        ExpandedPanel expandedPanel = HierarchicalTable.this.updateExpanded(n4);
                        n4 += n;
                        if (expandedPanel != null) {
                            expandedPanel.setRow(n4);
                        }
                        HierarchicalTable.this.updateExpanded(n4, expandedPanel);
                    }
                } else if (tableModelEvent.getType() == -1) {
                    Object[] objectArray = map.keySet().toArray(new Integer[map.keySet().size()]);
                    Arrays.sort(objectArray);
                    int n = tableModelEvent.getLastRow() - tableModelEvent.getFirstRow() + 1;
                    for (Object object : objectArray) {
                        ExpandedPanel expandedPanel;
                        if ((Integer)object > tableModelEvent.getLastRow()) {
                            expandedPanel = HierarchicalTable.this.updateExpanded((Integer)object);
                            object = (Integer)object - n;
                            if (expandedPanel != null) {
                                expandedPanel.setRow((Integer)object);
                            }
                            HierarchicalTable.this.updateExpanded((Integer)object, expandedPanel);
                            continue;
                        }
                        if ((Integer)object < tableModelEvent.getFirstRow() || (Integer)object > tableModelEvent.getLastRow() || (expandedPanel = HierarchicalTable.this.updateExpanded((Integer)object)) == null) continue;
                        HierarchicalTable.this.remove(expandedPanel);
                        HierarchicalTableComponentFactory hierarchicalTableComponentFactory = HierarchicalTable.this.getComponentFactory();
                        if (hierarchicalTableComponentFactory == null) continue;
                        hierarchicalTableComponentFactory.destroyChildComponent(HierarchicalTable.this, expandedPanel.getComponent(), expandedPanel.getRow());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tableRowsInserted(TableModelEvent tableModelEvent) {
            if (!(HierarchicalTable.this.getModel() instanceof RowTableModelWrapper)) {
                int n = tableModelEvent.getLastRow();
                if (n == Integer.MAX_VALUE) {
                    n = HierarchicalTable.this.getModel().getRowCount() - 1;
                }
                int n2 = n - tableModelEvent.getFirstRow() + 1;
                Map map = HierarchicalTable.this.getExpandedMap();
                Map map2 = HierarchicalTable.this._expanded;
                synchronized (map2) {
                    Object[] objectArray = map.keySet().toArray(new Integer[map.keySet().size()]);
                    Arrays.sort(objectArray);
                    for (int i = objectArray.length - 1; i >= 0; --i) {
                        int n3 = (Integer)objectArray[i];
                        if (n3 < tableModelEvent.getFirstRow()) continue;
                        ExpandedPanel expandedPanel = HierarchicalTable.this.updateExpanded(n3);
                        n3 += n2;
                        if (expandedPanel != null) {
                            expandedPanel.setRow(n3);
                        }
                        HierarchicalTable.this.updateExpanded(n3, expandedPanel);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tableRowsDeleted(TableModelEvent tableModelEvent) {
            if (!(HierarchicalTable.this.getModel() instanceof RowTableModelWrapper)) {
                int n = tableModelEvent.getLastRow();
                if (n == Integer.MAX_VALUE) {
                    n = HierarchicalTable.this.getModel().getRowCount() - 1;
                }
                int n2 = n - tableModelEvent.getFirstRow() + 1;
                Map map = HierarchicalTable.this.getExpandedMap();
                Map map2 = HierarchicalTable.this._expanded;
                synchronized (map2) {
                    Object[] objectArray = map.keySet().toArray(new Integer[map.keySet().size()]);
                    Arrays.sort(objectArray);
                    for (Object object : objectArray) {
                        ExpandedPanel expandedPanel;
                        if ((Integer)object > n) {
                            expandedPanel = HierarchicalTable.this.updateExpanded((Integer)object);
                            object = (Integer)object - n2;
                            if (expandedPanel != null) {
                                expandedPanel.setRow((Integer)object);
                            }
                            HierarchicalTable.this.updateExpanded((Integer)object, expandedPanel);
                            continue;
                        }
                        if ((Integer)object < tableModelEvent.getFirstRow() || (Integer)object > tableModelEvent.getLastRow() || (expandedPanel = HierarchicalTable.this.updateExpanded((Integer)object)) == null) continue;
                        HierarchicalTable.this.remove(expandedPanel);
                        HierarchicalTableComponentFactory hierarchicalTableComponentFactory = HierarchicalTable.this.getComponentFactory();
                        if (hierarchicalTableComponentFactory == null) continue;
                        hierarchicalTableComponentFactory.destroyChildComponent(HierarchicalTable.this, expandedPanel.getComponent(), expandedPanel.getRow());
                    }
                }
            }
        }
    }

    class HierarchicalTableComponentListener
    extends ComponentAdapter {
        HierarchicalTableComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            HierarchicalTable.this.childComponentResized();
        }
    }
}

