/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ColumnDraggableSupport;
import com.jidesoft.grid.ColumnTableModelWrapper;
import com.jidesoft.grid.GroupHeaderTableProvider;
import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.GroupTableHeader;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.basic.BasicAutoFilterTableHeaderUIDelegate;
import com.jidesoft.plaf.basic.BasicGroupTableHeaderUIDelegate;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.utils.ReflectionUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GroupTableInputListener
implements MouseListener,
MouseMotionListener,
KeyListener {
    private final GroupTableHeader _header;
    private static final int OFFSET = 2;
    private int _distanceX = 0;
    private int _distanceY = 0;
    private int _positionX = 0;
    private int _positionY = 0;
    private boolean _isDragging = false;
    private boolean _shouldCancel = true;
    private boolean _dropAllowed = true;
    private int _deltaX;
    private int _deltaY;
    private BufferedImage _image;
    private BufferedImage _shadow;
    private boolean _isAboutToDrag = false;
    private Point _startLocation;
    private Rectangle _dropArea = null;
    private int _dropSide = -1;
    private TableColumn _draggedColumn;
    private KeyEventDispatcher _keyEventDispatcher;
    private static final float ANGLE = 90.0f;
    private static final int DISTANCE = 5;

    public GroupTableInputListener(GroupTableHeader groupTableHeader) {
        this._header = groupTableHeader;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        Object object;
        Object object2;
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isShiftDown() || mouseEvent.isAltDown()) {
            return;
        }
        if (SystemInfo.isMacOSX() && mouseEvent.isControlDown()) {
            return;
        }
        int n2 = this._header.groupedColumnAtPoint(mouseEvent.getPoint());
        GroupModelProvider groupModelProvider = this._header.getGroupTableModel();
        if (groupModelProvider == null) {
            return;
        }
        int n3 = groupModelProvider.getGroupColumnCount();
        if (n2 < 0) {
            return;
        }
        Point point = mouseEvent.getPoint();
        if (n2 >= 0) {
            object2 = this._header.getGroupedHeaderRect(n2);
            object = this._header.getFilterableTableHeaderCellDecorator();
            Insets insets = object.getInsets(null, this._header, -2 - n2, (Rectangle)object2);
            if (insets != null) {
                int n4;
                n = this._header.getComponentOrientation().isLeftToRight() ? insets.left : insets.right;
                int n5 = n4 = this._header.getComponentOrientation().isLeftToRight() ? insets.right : insets.left;
                if (this._header.getComponentOrientation().isLeftToRight() ? point.x >= object2.x + object2.width - n4 && point.x < object2.x + object2.width && point.y >= object2.y && point.y < object2.y + object2.height : point.x >= object2.x && point.x < object2.x + n && point.y >= object2.y && point.y < object2.y + object2.height) {
                    return;
                }
            }
        }
        object2 = new int[n3];
        object = new int[n3];
        for (int i = 0; i < n3; ++i) {
            object2[i] = groupModelProvider.getGroupColumnAt(i);
            object[i] = groupModelProvider.getGroupColumnOrder(i);
            if (i != n2) continue;
            n = this._header.toggleSortOrder((int)object[i]);
            if (n != object[i]) {
                object[i] = n;
                continue;
            }
            return;
        }
        this.updateGroups(groupModelProvider, (int[])object2, (int[])object, false);
        mouseEvent.consume();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !this._isAboutToDrag && !this._isDragging && this._header.getResizingColumn() == null) {
            this._isAboutToDrag = true;
            this._startLocation = mouseEvent.getPoint();
            int n = this._header.columnAtPoint(this._startLocation);
            if (n == -1) {
                n = this._header.groupedColumnAtPoint(this._startLocation);
                if (n == -1) {
                    this.resetAll();
                } else {
                    GroupModelProvider groupModelProvider = this._header.getGroupTableModel();
                    if (groupModelProvider instanceof TableModelWrapper && n >= 0 && n < groupModelProvider.getGroupColumnCount()) {
                        int n2 = groupModelProvider.getGroupColumnAt(n);
                        this._draggedColumn = new TableColumn(n);
                        this._draggedColumn.setHeaderValue(((TableModelWrapper)((Object)groupModelProvider)).getActualModel().getColumnName(n2));
                    }
                }
            } else {
                int n3;
                TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), ColumnDraggableSupport.class);
                if (tableModel instanceof ColumnDraggableSupport && !((ColumnDraggableSupport)((Object)tableModel)).isColumnDraggable(n3 = TableModelWrapperUtils.getActualColumnAt(this._header.getTable().getModel(), this._header.getTable().convertColumnIndexToModel(n), tableModel))) {
                    return;
                }
                this._draggedColumn = this._header.getColumnModel().getColumn(n);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._isDragging) {
            this.endDragging(mouseEvent.getPoint());
        } else {
            this.resetAll();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this._header.setGroupedRollOverColumn(this._header.groupedColumnAtPoint(mouseEvent.getPoint()));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this._header.setGroupedRollOverColumn(-1);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this._header.setGroupedRollOverColumn(this._header.groupedColumnAtPoint(mouseEvent.getPoint()));
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this._header);
        if (this._isAboutToDrag) {
            if (Math.abs(point.x - this._startLocation.x) > 2 || Math.abs(point.y - this._startLocation.y) > 2) {
                if (this._header.getResizingColumn() == null) {
                    this._isDragging = true;
                    this.addGlobalEventHandler();
                    this.beginDragging(this._startLocation);
                } else {
                    this.resetAll();
                }
                this._isAboutToDrag = false;
            }
        } else if (this._isDragging) {
            this.dragging(point);
        }
    }

    private void addGlobalEventHandler() {
        try {
            if (this._keyEventDispatcher == null) {
                this._keyEventDispatcher = new KeyEventDispatcher(){

                    @Override
                    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                        GroupTableInputListener.this.handleKeyEvent(keyEvent);
                        return false;
                    }
                };
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this._keyEventDispatcher);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    private void removeGlobalEventHandler() {
        try {
            if (this._keyEventDispatcher != null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this._keyEventDispatcher);
            }
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    private void handleKeyEvent(AWTEvent aWTEvent) {
        if (this.isDragging() && aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 27) {
            this.cancelDragging();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.cancelDragging();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.cancelDragging();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    boolean isDragging() {
        return this._isDragging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginDragging(Point point) {
        Object object;
        if (this._draggedColumn == null) {
            this._isDragging = false;
            return;
        }
        int n = this.viewIndexForColumn(this._draggedColumn);
        Rectangle rectangle = n != -1 ? this._header.getHeaderRect(n) : this._header.getGroupedHeaderRect(this._draggedColumn.getModelIndex());
        Point point2 = rectangle.getLocation();
        this._positionX = point2.x;
        this._positionY = point2.y;
        this._deltaX = point.x - this._positionX;
        this._deltaY = point.y - this._positionY;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        this._image = graphicsConfiguration.createCompatibleImage(rectangle.width, rectangle.height, 3);
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        Object object2 = this._header.getClientProperty("TableHeaderUIDelegate.instance");
        if (object2 instanceof BasicGroupTableHeaderUIDelegate) {
            object = ReflectionUtils.callAnyWithoutException(object2, BasicAutoFilterTableHeaderUIDelegate.class, "getFilterCellDecoratorProperties", new Class[0], new Object[0]);
            this._header.putClientProperty("TableHeaderUIDelegate.filterCellDecoratorProperties", object);
            try {
                if (n != -1) {
                    ReflectionUtils.callAnyWithoutException(object2, BasicAutoFilterTableHeaderUIDelegate.class, "paintCell", new Class[]{Graphics.class, Rectangle.class, Integer.TYPE, Object.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{this._image.getGraphics(), rectangle2, n, this._draggedColumn.getHeaderValue(), true, true, true});
                } else {
                    ReflectionUtils.callAnyWithoutException(object2, BasicGroupTableHeaderUIDelegate.class, "paintGroupCell", new Class[]{Graphics.class, Rectangle.class, Integer.TYPE, Object.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{this._image.getGraphics(), rectangle2, this._draggedColumn.getModelIndex(), this._draggedColumn.getHeaderValue(), true, true});
                }
            }
            finally {
                this._header.putClientProperty("TableHeaderUIDelegate.filterCellDecoratorProperties", null);
            }
        }
        object = new ShadowFactory(5, 0.5f, Color.BLACK);
        this._shadow = ((ShadowFactory)object).createShadow(this._image);
        this._isDragging = true;
    }

    protected boolean isDropAllowed(TableColumn tableColumn, Rectangle rectangle, int n) {
        GroupModelProvider groupModelProvider;
        int n2 = this.viewIndexForColumn(tableColumn);
        if (n2 >= 0 && n2 < this._header.getColumnModel().getColumnCount() && (rectangle == null || rectangle.y < this._header.getActualHeaderY()) && (groupModelProvider = this._header.getGroupTableModel()) instanceof ColumnTableModelWrapper) {
            int n3 = ((ColumnTableModelWrapper)((Object)groupModelProvider)).getActualColumnAt(tableColumn.getModelIndex());
            return groupModelProvider.isColumnGroupable(n3);
        }
        return true;
    }

    private Point fitToTableHeaderBounds(Point point) {
        int n = this.viewIndexForColumn(this._draggedColumn);
        Rectangle rectangle = this._header.getBounds();
        rectangle.x = Math.max(rectangle.x, 0);
        rectangle.y = Math.max(rectangle.y, 0);
        Rectangle rectangle2 = this._header.getHeaderRect(n);
        point = new Point(point);
        point.x = Math.min(Math.max(point.x, rectangle.x), rectangle.x + rectangle.width - rectangle2.width);
        point.y = Math.min(Math.max(point.y, rectangle.y), rectangle.y + rectangle.height - rectangle2.height);
        return point;
    }

    private void dragging(Point point) {
        point = this.fitToTableHeaderBounds(point);
        int n = this._positionX;
        int n2 = this._positionY;
        Rectangle rectangle = this._dropArea;
        this._positionX = point.x - this._deltaX;
        this._positionY = point.y - this._deltaY;
        int n3 = this.viewIndexForColumn(this._draggedColumn);
        Rectangle rectangle2 = this._header.getBounds();
        boolean bl = this._shouldCancel = point.x < 0 || point.x >= rectangle2.width || point.y < 0 || point.y >= rectangle2.height || this._header.getColumnModel().getColumnCount() <= 1 && n3 >= 0;
        if (this._shouldCancel) {
            this.resetDropArea();
        } else {
            boolean bl2 = this._header.getComponentOrientation().isLeftToRight();
            int n4 = this._header.columnAtPoint(point);
            if (n4 != -1 && n3 >= 0 && this._header.getReorderingAllowed()) {
                this._header.setDraggedColumn(this._draggedColumn);
            } else if (n4 != -1 && n3 < 0) {
                Rectangle rectangle3 = this._header.getHeaderRect(n4);
                this._dropSide = GroupTableInputListener.sideOf(point, rectangle3);
                switch (this._dropSide) {
                    case 7: {
                        if (!bl2 && n3 == n4 - 1) {
                            this.resetDropArea();
                            break;
                        }
                        if (n3 == n4) {
                            this.resetDropArea();
                            break;
                        }
                        this._dropArea = new Rectangle(rectangle3.x - 1, rectangle3.y - 1, 2, rectangle3.height + 1);
                        break;
                    }
                    case 3: {
                        if (bl2 && n3 == n4 + 1) {
                            this.resetDropArea();
                            break;
                        }
                        if (n3 == n4) {
                            this.resetDropArea();
                            break;
                        }
                        this._dropArea = new Rectangle(rectangle3.x + rectangle3.width - 1, rectangle3.y - 1, 2, rectangle3.height + 1);
                        break;
                    }
                    default: {
                        this.resetDropArea();
                        break;
                    }
                }
            } else {
                int n5;
                int n6;
                boolean bl3 = n3 == -1;
                int n7 = -1;
                if (!bl3) {
                    GroupModelProvider groupModelProvider = this._header.getGroupTableModel();
                    if (groupModelProvider instanceof ColumnTableModelWrapper) {
                        n6 = ((ColumnTableModelWrapper)((Object)groupModelProvider)).getActualColumnAt(this._draggedColumn.getModelIndex());
                        if (n6 < 0) {
                            this.resetDropArea();
                            return;
                        }
                        for (int i = 0; i < groupModelProvider.getGroupColumnCount(); ++i) {
                            if (groupModelProvider.getGroupColumnAt(i) != n6) continue;
                            bl3 = true;
                            n7 = i;
                            break;
                        }
                    }
                } else {
                    n7 = this._draggedColumn.getModelIndex();
                }
                if ((n5 = this._header.groupedColumnAtPoint(point)) != -1) {
                    if (bl3 && n5 == n7) {
                        this.resetDropArea();
                    } else {
                        this.clearDraggedColumn();
                        Rectangle rectangle4 = this._header.getGroupedHeaderRect(n5);
                        this._dropSide = bl3 && n5 == n7 - 1 ? (bl2 ? 7 : 3) : (bl3 && n5 == n7 + 1 ? (bl2 ? 3 : 7) : GroupTableInputListener.sideOf(point, rectangle4));
                        this.calculateDropArea(rectangle4);
                    }
                } else if (point.y < this._header.getActualHeaderY()) {
                    int n8 = n6 = this._header.getGroupTableModel() == null ? 0 : this._header.getGroupTableModel().getGroupColumnCount();
                    if (n6 > 0) {
                        if (n6 - 1 != n7) {
                            this.clearDraggedColumn();
                            Rectangle rectangle5 = this._header.getGroupedHeaderRect(n6 - 1);
                            this._dropSide = bl2 ? 3 : 7;
                            this.calculateDropArea(rectangle5);
                        } else {
                            this.resetDropArea();
                        }
                    } else {
                        this.clearDraggedColumn();
                        this._dropSide = bl2 ? 7 : 3;
                        Insets insets = this._header.getMargin();
                        this._dropArea = bl2 ? new Rectangle(insets.left, insets.top, this._draggedColumn.getWidth(), this._header.getActualHeaderHeight()) : new Rectangle(this._header.getWidth() - insets.right, insets.top, this._draggedColumn.getWidth(), this._header.getActualHeaderHeight());
                    }
                } else {
                    this.resetDropArea();
                }
            }
        }
        this._dropAllowed = this.isDropAllowed(this._draggedColumn, this._dropArea, this._dropSide);
        Rectangle rectangle6 = new Rectangle(n, n2, this._shadow.getWidth() + this._distanceX, this._shadow.getHeight() + this._distanceY);
        Rectangle rectangle7 = new Rectangle(this._positionX, this._positionY, this._shadow.getWidth() + this._distanceX, this._shadow.getHeight() + this._distanceY);
        this._header.repaint(rectangle7.union(rectangle6));
        if (rectangle != null) {
            this._header.repaint(rectangle);
        }
        if (this._dropArea != null) {
            this._header.repaint(this._dropArea);
        }
        if (this._header.getTable() != null) {
            if (point.x >= this._header.getVisibleRect().x + this._header.getVisibleRect().width) {
                this._header.getTable().scrollRectToVisible(new Rectangle(point.x - 1, this._header.getTable().getVisibleRect().y, 2, 1));
            } else if (point.x < this._header.getVisibleRect().x) {
                this._header.getTable().scrollRectToVisible(new Rectangle(point.x - 1, this._header.getTable().getVisibleRect().y, 2, 1));
            }
        }
    }

    private void clearDraggedColumn() {
        this._header.setDraggedColumn(null);
        this._header.setDraggedDistance(0);
        this._header.invalidate();
        this._header.repaint();
        if (this._header.getTable() != null) {
            this._header.getTable().invalidate();
            this._header.getTable().repaint();
        }
    }

    private void calculateDropArea(Rectangle rectangle) {
        switch (this._dropSide) {
            case 7: {
                this._dropArea = new Rectangle(rectangle.x, rectangle.y, rectangle.width / 2, rectangle.height);
                break;
            }
            case 3: {
                this._dropArea = new Rectangle(rectangle.x + rectangle.width / 2, rectangle.y, rectangle.width / 2, rectangle.height);
                break;
            }
            default: {
                this.resetDropArea();
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this._header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private void resetAll() {
        this.clearDraggedColumn();
        this.resetDropArea();
        this._positionX = 0;
        this._positionY = 0;
        this._deltaX = 0;
        this._deltaY = 0;
        this._startLocation = null;
        this._isAboutToDrag = false;
        this._isDragging = false;
        this._draggedColumn = null;
        if (this._image != null) {
            this._image.flush();
            this._image = null;
        }
        if (this._shadow != null) {
            this._shadow.flush();
            this._shadow = null;
        }
    }

    private void resetDropArea() {
        this._dropArea = null;
        this._dropSide = -1;
    }

    private void cancelDragging() {
        this.removeGlobalEventHandler();
        this.clearDragImage();
        this.resetAll();
    }

    private void clearDragImage() {
        if (this._shadow != null && this._image != null) {
            Rectangle rectangle = new Rectangle(this._positionX, this._positionY, this._shadow.getWidth() + this._distanceX, this._shadow.getHeight() + this._distanceY);
            this._header.repaint(rectangle);
        }
        if (this._dropArea != null) {
            this._header.repaint(this._dropArea);
        }
    }

    private void endDragging(Point point) {
        int n;
        int n2;
        point = this.fitToTableHeaderBounds(point);
        this.clearDragImage();
        if (this._shouldCancel || !this._dropAllowed) {
            this.resetAll();
            return;
        }
        int n3 = this.viewIndexForColumn(this._draggedColumn);
        boolean bl = this._header.getComponentOrientation().isLeftToRight();
        int n4 = -1;
        GroupModelProvider groupModelProvider = this._header.getGroupTableModel();
        if (groupModelProvider == null) {
            this.resetAll();
            return;
        }
        int n5 = groupModelProvider.getGroupColumnCount();
        if (n3 >= 0) {
            if (groupModelProvider instanceof ColumnTableModelWrapper) {
                n2 = ((ColumnTableModelWrapper)((Object)groupModelProvider)).getActualColumnAt(this._draggedColumn.getModelIndex());
                if (n2 < 0) {
                    this.resetAll();
                    return;
                }
                for (n = 0; n < groupModelProvider.getGroupColumnCount(); ++n) {
                    if (groupModelProvider.getGroupColumnAt(n) != n2) continue;
                    n4 = n;
                    break;
                }
            }
        } else {
            n4 = this._draggedColumn.getModelIndex();
        }
        if ((n2 = this._header.groupedColumnAtPoint(point)) == -1) {
            if (n5 == 0) {
                n2 = 0;
            } else {
                Rectangle rectangle = this._header.getGroupedHeaderRect(n5 - 1);
                n2 = bl ? (point.x < rectangle.x + rectangle.width ? 0 : n5) : (point.x > rectangle.x ? 0 : n5);
            }
        } else if (bl && this._dropSide == 3 || !bl && this._dropSide == 7) {
            if (n4 == -1 || n4 > n2) {
                n2 = Math.min(n5, n2 + 1);
            }
        } else if (n4 != -1 && n4 < n2) {
            n2 = Math.max(0, n2 - 1);
        }
        if (n3 >= 0 && n2 < 0 && !this._header.getReorderingAllowed()) {
            this.resetAll();
            return;
        }
        if (point.y < this._header.getActualHeaderY()) {
            if (n4 < 0 && groupModelProvider instanceof ColumnTableModelWrapper) {
                n = ((ColumnTableModelWrapper)((Object)groupModelProvider)).getActualColumnAt(this._draggedColumn.getModelIndex());
                ArrayList<Integer> arrayList = new ArrayList<Integer>(n5 + 1);
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n5 + 1);
                for (int i = 0; i < n5; ++i) {
                    arrayList.add(groupModelProvider.getGroupColumnAt(i));
                    arrayList2.add(groupModelProvider.getGroupColumnOrder(i));
                }
                if (n2 == -1 || n2 >= n5) {
                    arrayList.add(n);
                    arrayList2.add(1);
                } else {
                    arrayList.add(n2, n);
                    arrayList2.add(n2, 1);
                }
                int[] nArray = new int[arrayList.size()];
                int[] nArray2 = new int[arrayList2.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)arrayList.get(i);
                    nArray2[i] = (Integer)arrayList2.get(i);
                }
                this.updateGroups(groupModelProvider, nArray, nArray2, true);
            } else if (n2 == -1) {
                if (n4 != groupModelProvider.getGroupColumnCount() - 1) {
                    n = groupModelProvider.getGroupColumnAt(n4);
                    ArrayList<Integer> arrayList = new ArrayList<Integer>(n5 + 1);
                    ArrayList<Integer> arrayList3 = new ArrayList<Integer>(n5 + 1);
                    for (int i = 0; i < groupModelProvider.getGroupColumnCount(); ++i) {
                        int n6 = groupModelProvider.getGroupColumnAt(i);
                        if (n6 == n) continue;
                        arrayList.add(n6);
                        arrayList3.add(groupModelProvider.getGroupColumnOrder(i));
                    }
                    int[] nArray = new int[arrayList.size()];
                    int[] nArray3 = new int[arrayList3.size()];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = (Integer)arrayList.get(i);
                        nArray3[i] = (Integer)arrayList3.get(i);
                    }
                    this.updateGroups(groupModelProvider, nArray, nArray3, true);
                }
            } else if (n2 != n4) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(n5 + 1);
                ArrayList<Integer> arrayList4 = new ArrayList<Integer>(n5 + 1);
                for (int i = 0; i < n5; ++i) {
                    arrayList.add(groupModelProvider.getGroupColumnAt(i));
                    arrayList4.add(groupModelProvider.getGroupColumnOrder(i));
                }
                Integer n7 = (Integer)arrayList.remove(n4);
                Integer n8 = (Integer)arrayList4.remove(n4);
                if (n2 >= arrayList.size()) {
                    n2 = arrayList.size();
                }
                arrayList.add(n2, n7);
                arrayList4.add(n2, n8);
                int[] nArray = new int[arrayList.size()];
                int[] nArray4 = new int[arrayList4.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)arrayList.get(i);
                    nArray4[i] = (Integer)arrayList4.get(i);
                }
                this.updateGroups(groupModelProvider, nArray, nArray4, true);
            }
        } else {
            Object object;
            int n9;
            JTable jTable = this._header.getTable();
            int n10 = this._header.columnAtPoint(point);
            if (n10 >= 0 && (bl && this._dropSide == 3 || !bl && this._dropSide == 7)) {
                ++n10;
            }
            boolean bl2 = false;
            if (n3 == -1 && groupModelProvider instanceof ColumnTableModelWrapper) {
                if (groupModelProvider.isDisplayGroupColumns()) {
                    --n10;
                    bl2 = true;
                }
                int n11 = groupModelProvider.getGroupColumnAt(this._draggedColumn.getModelIndex());
                n9 = -1;
                if (this._header.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this._header.getUI())).getHeaderUIDelegate() instanceof BasicGroupTableHeaderUIDelegate) {
                    n9 = ((BasicGroupTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this._header.getUI())).getHeaderUIDelegate()).getActualModelPreferredWidth(n11);
                }
                object = new ArrayList(n5 + 1);
                ArrayList<Integer> arrayList = new ArrayList<Integer>(n5 + 1);
                for (int i = 0; i < groupModelProvider.getGroupColumnCount(); ++i) {
                    int n12 = groupModelProvider.getGroupColumnAt(i);
                    if (n12 == n11) continue;
                    object.add(n12);
                    arrayList.add(groupModelProvider.getGroupColumnOrder(i));
                }
                int[] nArray = new int[object.size()];
                int[] nArray5 = new int[arrayList.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)object.get(i);
                    nArray5[i] = (Integer)arrayList.get(i);
                }
                this.updateGroups(groupModelProvider, nArray, nArray5, true);
                n3 = jTable.convertColumnIndexToView(((ColumnTableModelWrapper)((Object)groupModelProvider)).getVisualColumnAt(n11));
                if (n3 >= 0 && n3 < this._header.getColumnModel().getColumnCount() && n9 > 0) {
                    TableColumn tableColumn = this._header.getColumnModel().getColumn(n3);
                    tableColumn.setPreferredWidth(n9);
                    tableColumn.setWidth(n9);
                }
            }
            if (n3 >= 0) {
                TableColumnModel tableColumnModel = this._header.getColumnModel();
                if (n10 == -1) {
                    n9 = tableColumnModel.getColumnCount() - 1;
                    n10 = point.x > this._header.getHeaderRect((int)n9).x ? n9 : 0;
                }
                if (bl2 && groupModelProvider.groupColumnsFirst()) {
                    n10 = Math.max(n10, groupModelProvider.getGroupColumnCount());
                }
                if (n3 != (n10 = Math.min(n10, tableColumnModel.getColumnCount() - 1))) {
                    int n13;
                    n9 = 1;
                    object = TableModelWrapperUtils.getActualTableModel(this._header.getTable().getModel(), ColumnDraggableSupport.class);
                    if (object instanceof ColumnDraggableSupport && !((ColumnDraggableSupport)object).isColumnDraggable(n13 = TableModelWrapperUtils.getActualColumnAt(this._header.getTable().getModel(), this._header.getTable().convertColumnIndexToModel(n10), (TableModel)object))) {
                        n9 = 0;
                    }
                    if (n9 != 0) {
                        tableColumnModel.moveColumn(n3, n10);
                        TableUtils.saveColumnOrders(jTable, false);
                    }
                }
            }
        }
        this.resetAll();
    }

    private void updateGroups(GroupModelProvider groupModelProvider, int[] nArray, int[] nArray2, boolean bl) {
        String string = this.saveTablePreference();
        String string2 = this.saveSortableTablePreference();
        groupModelProvider.setGroupColumns(nArray, nArray2);
        if (this._header.getTable() instanceof GroupHeaderTableProvider) {
            ((GroupHeaderTableProvider)((Object)this._header.getTable())).prepareBeforeGroup();
        }
        groupModelProvider.groupAndRefresh(bl);
        this.loadTablePreference(string);
        this.loadSortableTablePreference(string2);
    }

    private String saveSortableTablePreference() {
        String string = null;
        if (this._header.getTable() instanceof SortableTable) {
            string = TableUtils.getSortableTablePreference((SortableTable)this._header.getTable(), true);
        }
        return string;
    }

    private void loadSortableTablePreference(String string) {
        if (this._header.getTable() instanceof SortableTable && string != null) {
            TableUtils.setSortableTablePreference((SortableTable)this._header.getTable(), string, true);
        }
    }

    protected String saveTablePreference() {
        JTable jTable = this._header.getTable();
        if (jTable == null) {
            return "";
        }
        TableScrollPane tableScrollPane = (TableScrollPane)jTable.getClientProperty("TableScrollPane.Parent");
        if (tableScrollPane == null) {
            return TableUtils.getTablePreferenceByName(jTable);
        }
        return TableUtils.getTablePreferenceByName(tableScrollPane);
    }

    protected void loadTablePreference(String string) {
        JTable jTable = this._header.getTable();
        if (jTable == null) {
            return;
        }
        TableScrollPane tableScrollPane = (TableScrollPane)jTable.getClientProperty("TableScrollPane.Parent");
        if (tableScrollPane == null) {
            TableUtils.setTablePreferenceByName(jTable, string);
        } else {
            TableUtils.setTablePreferenceByName(tableScrollPane, string, false);
        }
    }

    private void computeShadowPosition(double d) {
        double d2 = Math.toRadians(90.0);
        this._distanceX = (int)(Math.cos(d2) * d);
        this._distanceY = (int)(Math.sin(d2) * d);
    }

    void drawItem(Graphics graphics) {
        if (this._header.getDraggedColumn() != null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this._dropAllowed && this._dropArea != null) {
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.drawRect(this._dropArea.x, this._dropArea.y, this._dropArea.width - 1, this._dropArea.height - 1);
            graphics2D.drawRect(this._dropArea.x + 1, this._dropArea.y + 1, this._dropArea.width - 3, this._dropArea.height - 3);
        }
        int n = this._shadow.getWidth();
        int n2 = this._shadow.getHeight();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
        int n3 = this._positionX;
        int n4 = this._positionY;
        this.computeShadowPosition(6.0);
        graphics.drawImage(this._shadow, n3 + this._distanceX, n4 + this._distanceY, n, n2, null);
        n = this._image.getWidth();
        n2 = this._image.getHeight();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
        graphics.drawImage(this._image, n3, n4, n, n2, null);
        graphics2D.setComposite(composite);
    }

    private static int sideOf(Point point, Rectangle rectangle) {
        if (rectangle.contains(point)) {
            if (point.x <= rectangle.x + rectangle.width / 2) {
                return 7;
            }
            if (point.x > rectangle.x + rectangle.width / 2) {
                return 3;
            }
        }
        return -1;
    }
}

