/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AbstractGroupTableModel;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.DefaultGroupRow;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.GroupTableHeader;
import com.jidesoft.grid.IndexReferenceRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grid.ToolTipSupport;
import com.jidesoft.grid.TreeTable;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GroupTable
extends TreeTable {
    private Map<Object, TableCellRenderer> _headerRendererCache;
    private boolean _specialColumnsHidable = true;

    public GroupTable() {
    }

    public GroupTable(int n, int n2) {
        super(n, n2);
        TableUtils.saveDefaultColumnOrders(this);
        this.initializeTable();
    }

    public GroupTable(TableModel tableModel) {
        super(tableModel);
        TableUtils.saveDefaultColumnOrders(this);
        this.initializeTable();
    }

    public GroupTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        TableUtils.saveDefaultColumnOrders(this);
        this.initializeTable();
    }

    public GroupTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        TableUtils.saveDefaultColumnOrders(this);
        this.initializeTable();
    }

    public GroupTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        TableUtils.saveDefaultColumnOrders(this);
        this.initializeTable();
    }

    public GroupTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        TableUtils.saveDefaultColumnOrders(this);
        this.initializeTable();
    }

    private void initializeTable() {
        TableModel tableModel = this.getModel();
        do {
            if ((tableModel = TableModelWrapperUtils.getActualTableModel(tableModel, SortableTableModel.class)) == null) continue;
            ((SortableTableModel)tableModel).setResetOnTableStructureChangeEvent(false);
            if (tableModel instanceof SortableTreeTableModel) {
                for (int i = tableModel.getColumnCount() - 1; i >= 0; --i) {
                    ((SortableTreeTableModel)tableModel).setSortableOption(i, 2);
                }
            }
            tableModel = ((SortableTableModel)tableModel).getActualModel();
        } while (tableModel != null);
    }

    @Override
    public Icon getCollapsedIcon(int n) {
        Row row = this.getRowAt(n);
        if (row instanceof Expandable && !((Expandable)((Object)row)).isExpandable()) {
            return null;
        }
        return super.getCollapsedIcon(n);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel(), DefaultGroupTableModel.class);
        if (tableModel instanceof AbstractGroupTableModel) {
            if (((AbstractGroupTableModel)tableModel).isGroupEnabled()) {
                return super.getCellRenderer(n, n2);
            }
            return this.getActualCellRenderer(n, n2);
        }
        return super.getCellRenderer(n, n2);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        JTableHeader jTableHeader;
        boolean bl = false;
        int n = -1;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel(), DefaultGroupTableModel.class);
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) {
            boolean bl2 = bl = !(tableModelEvent instanceof CompoundTableModelEvent) || ((CompoundTableModelEvent)tableModelEvent).isOriginalChanged();
            if (tableModel instanceof DefaultGroupTableModel && ((DefaultGroupTableModel)tableModel).hasGroupColumns()) {
                n = ((DefaultGroupTableModel)tableModel).isDisplayCountColumn() || ((DefaultGroupTableModel)tableModel).isDisplaySeparateGroupColumn() || ((DefaultGroupTableModel)tableModel).isKeepColumnOrder() ? -1 : ((DefaultGroupTableModel)tableModel).getGroupColumnAt(0);
            }
        }
        if (bl) {
            if (this._headerRendererCache != null) {
                this._headerRendererCache.clear();
            }
            this._headerRendererCache = null;
        } else {
            this.updateHeaderRendererCache();
        }
        super.tableChanged(tableModelEvent);
        if (!bl) {
            this.loadHeaderRenderer();
        }
        if (n >= 0) {
            n = TableModelWrapperUtils.getColumnAt(this.getModel(), ((DefaultGroupTableModel)tableModel).getActualModel(), n);
        }
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) {
            this.setExpandableColumn(n);
        }
        if ((jTableHeader = this.getTableHeader()) != null && (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0 || tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE && tableModelEvent.getColumn() == -1)) {
            jTableHeader.revalidate();
            jTableHeader.repaint();
        }
    }

    private void loadHeaderRenderer() {
        if (this._headerRendererCache == null || this._headerRendererCache.size() == 0) {
            return;
        }
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            TableCellRenderer tableCellRenderer = null;
            Object object = tableColumn.getIdentifier();
            if (object != null) {
                tableCellRenderer = this._headerRendererCache.get(object);
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = this._headerRendererCache.get(tableColumn.getHeaderValue());
            }
            if (tableCellRenderer == null) continue;
            tableColumn.setHeaderRenderer(tableCellRenderer);
        }
    }

    private void updateHeaderRendererCache() {
        if (this._headerRendererCache == null) {
            this._headerRendererCache = new HashMap<Object, TableCellRenderer>();
        }
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            if (tableColumn.getHeaderRenderer() == null) continue;
            Object object = tableColumn.getIdentifier();
            if (object == null) {
                object = tableColumn.getHeaderValue();
            }
            this._headerRendererCache.put(object, tableColumn.getHeaderRenderer());
        }
    }

    @Override
    boolean isApplyColumnCellRenderer(int n) {
        int n2;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel(), DefaultGroupTableModel.class);
        if (tableModel instanceof DefaultGroupTableModel && ((DefaultGroupTableModel)tableModel).getRowAt(n2 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, tableModel)) instanceof DefaultGroupRow) {
            return false;
        }
        return super.isApplyColumnCellRenderer(n);
    }

    @Override
    protected void handleMouseEvent(MouseEvent mouseEvent) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel(), DefaultGroupTableModel.class);
        if (tableModel instanceof AbstractGroupTableModel && ((AbstractGroupTableModel)tableModel).isGroupEnabled()) {
            super.handleMouseEvent(mouseEvent);
        }
    }

    @Override
    boolean rowEquals(Row row, Row row2) {
        TableModel tableModel = this.getTreeTableModel();
        if (!(tableModel instanceof DefaultGroupTableModel)) {
            return super.rowEquals(row, row2);
        }
        int n = ((DefaultGroupTableModel)tableModel).getSimilarRowIndex(row);
        return n >= 0 && n == ((DefaultGroupTableModel)tableModel).getSimilarRowIndex(row2);
    }

    @Override
    void adjustRowSettings(TableModelEvent tableModelEvent) {
        block15: {
            int n;
            int n2;
            int n3;
            block14: {
                if (tableModelEvent instanceof CompoundTableModelEvent) {
                    return;
                }
                n3 = tableModelEvent.getFirstRow();
                n2 = tableModelEvent.getLastRow();
                n = n2 - n3 + 1;
                if (tableModelEvent.getType() != 1) break block14;
                if (this._savedTreeTableSelection != null) {
                    for (int i = 0; i < this._savedTreeTableSelection.length; ++i) {
                        Row row = this._savedTreeTableSelection[i];
                        if (!(row instanceof IndexReferenceRow) || ((IndexReferenceRow)row).getRowIndex() < n3) continue;
                        this._savedTreeTableSelection[i] = new IndexReferenceRow(((IndexReferenceRow)row).getTableModel(), ((IndexReferenceRow)row).getRowIndex() + n);
                    }
                }
                if (this._savedTreeTableRowHeights == null) break block15;
                Map map = this._savedTreeTableRowHeights;
                this._savedTreeTableRowHeights = new HashMap();
                for (Row row : map.keySet()) {
                    if (row instanceof IndexReferenceRow && ((IndexReferenceRow)row).getRowIndex() >= n3) {
                        this._savedTreeTableRowHeights.put(new IndexReferenceRow(((IndexReferenceRow)row).getTableModel(), ((IndexReferenceRow)row).getRowIndex() + n), map.get(row));
                        continue;
                    }
                    this._savedTreeTableRowHeights.put(row, map.get(row));
                }
                break block15;
            }
            if (tableModelEvent.getType() == -1) {
                Object object;
                if (this._savedTreeTableSelection != null) {
                    object = new ArrayList();
                    for (Row row : this._savedTreeTableSelection) {
                        if (row instanceof IndexReferenceRow) {
                            int n4 = ((IndexReferenceRow)row).getRowIndex();
                            if (n4 > n2) {
                                object.add(new IndexReferenceRow(((IndexReferenceRow)row).getTableModel(), ((IndexReferenceRow)row).getRowIndex() - n));
                                continue;
                            }
                            if (n4 >= n3) continue;
                            object.add(row);
                            continue;
                        }
                        object.add(row);
                    }
                    this._savedTreeTableSelection = object.toArray(new Row[object.size()]);
                }
                if (this._savedTreeTableRowHeights != null) {
                    object = this._savedTreeTableRowHeights;
                    this._savedTreeTableRowHeights = new HashMap();
                    for (Row row : object.keySet()) {
                        if (row instanceof IndexReferenceRow) {
                            int n5 = ((IndexReferenceRow)row).getRowIndex();
                            if (n5 > n2) {
                                this._savedTreeTableRowHeights.put(new IndexReferenceRow(((IndexReferenceRow)row).getTableModel(), ((IndexReferenceRow)row).getRowIndex() - n), object.get(row));
                                continue;
                            }
                            if (n5 >= n3) continue;
                            this._savedTreeTableRowHeights.put(row, object.get(row));
                            continue;
                        }
                        this._savedTreeTableRowHeights.put(row, object.get(row));
                    }
                }
            }
        }
    }

    @Override
    public String getTableHeaderToolTipText(MouseEvent mouseEvent) {
        String string = super.getTableHeaderToolTipText(mouseEvent);
        if (string != null || !(this.getTableHeader() instanceof GroupTableHeader) || !((GroupTableHeader)this.getTableHeader()).isGroupHeaderEnabled()) {
            return string;
        }
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getModel(), DefaultGroupTableModel.class);
        if (!(tableModel instanceof DefaultGroupTableModel)) {
            return null;
        }
        ToolTipSupport toolTipSupport = (ToolTipSupport)((Object)TableModelWrapperUtils.getActualTableModel(((DefaultGroupTableModel)tableModel).getActualModel(), ToolTipSupport.class));
        if (toolTipSupport == null) {
            return null;
        }
        for (int i = 0; i < ((DefaultGroupTableModel)tableModel).getGroupColumnCount(); ++i) {
            Rectangle rectangle = ((GroupTableHeader)this.getTableHeader()).getGroupedHeaderRect(i);
            if (rectangle == null || !rectangle.contains(mouseEvent.getPoint())) continue;
            int n = ((DefaultGroupTableModel)tableModel).getGroupColumnAt(i);
            int n2 = TableModelWrapperUtils.getActualColumnAt(((DefaultGroupTableModel)tableModel).getActualModel(), n, (TableModel)((Object)toolTipSupport));
            if (n2 < 0 || n2 >= ((TableModel)((Object)toolTipSupport)).getColumnCount()) break;
            string = toolTipSupport.getToolTipText(n2);
            break;
        }
        return string;
    }

    public boolean isSpecialColumnsHidable() {
        return this._specialColumnsHidable;
    }

    public void setSpecialColumnsHidable(boolean bl) {
        this._specialColumnsHidable = bl;
    }
}

