/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ConverterContextSupport;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.GridsResourceProvider;
import java.awt.Component;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

public class FilterListCellRenderer
extends DefaultListCellRenderer
implements ConverterContextSupport,
SwingConstants {
    public static EditorContext CONTEXT_SENSITIVE_CONTEXT = new EditorContext("ContextSensitiveCellRenderer");
    private ConverterContext _converterContext;
    private Class<?> _class;
    private EditorContext _editorContext;
    private JTable _table;
    private int _columnIndex;

    public FilterListCellRenderer() {
    }

    public FilterListCellRenderer(Class<?> clazz) {
        this._class = clazz;
    }

    public FilterListCellRenderer(ConverterContext converterContext) {
        this._converterContext = converterContext;
    }

    public FilterListCellRenderer(Class<?> clazz, ConverterContext converterContext) {
        this._class = clazz;
        this._converterContext = converterContext;
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object == null) {
            object = "(Empty)";
        }
        TableCellRenderer tableCellRenderer = CellRendererManager.getRenderer(this._class, this.getEditorContext());
        if (!(this.getTable() == null || tableCellRenderer == null || "(All)".equals(object) || "(Custom...)".equals(object) || "(Empty)".equals(object))) {
            Component component;
            if (tableCellRenderer instanceof ConverterContextSupport) {
                ((ConverterContextSupport)((Object)tableCellRenderer)).setType(this._class);
                ((ConverterContextSupport)((Object)tableCellRenderer)).setConverterContext(this._converterContext);
            }
            if ((component = tableCellRenderer.getTableCellRendererComponent(this.getTable(), object, bl, bl2, 0, this.getColumnIndex())) instanceof JLabel && ((JLabel)component).getText().length() == 0) {
                ((JLabel)component).setText(" ");
            }
            return component;
        }
        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (!(object instanceof Icon)) {
            this.setIcon(null);
            this.setText(this.convertElementToString(jList, object));
        }
        return this;
    }

    public String convertElementToString(JList jList, Object object) {
        if (jList instanceof GridsResourceProvider) {
            if ("(All)".equals(object)) {
                return ((GridsResourceProvider)((Object)jList)).getResourceString("Filter.all");
            }
            if ("(Custom...)".equals(object)) {
                return ((GridsResourceProvider)((Object)jList)).getResourceString("Filter.custom");
            }
            if (object == null || "(Empty)".equals(object)) {
                return ((GridsResourceProvider)((Object)jList)).getResourceString("Filter.null");
            }
        }
        return this.convertElementToString(jList.getLocale(), object);
    }

    public String convertElementToString(Locale locale, Object object) {
        if ("(All)".equals(object)) {
            return GridResource.getResourceBundle(locale).getString("Filter.all");
        }
        if ("(Custom...)".equals(object)) {
            return GridResource.getResourceBundle(locale).getString("Filter.custom");
        }
        if (object == null || "(Empty)".equals(object)) {
            return GridResource.getResourceBundle(locale).getString("Filter.null");
        }
        if ("".equals(object)) {
            return " ";
        }
        if (object instanceof Filter) {
            return ((Filter)object).getName();
        }
        return ObjectConverterManager.toString(object, this._class != object.getClass() ? object.getClass() : this._class, this.getConverterContext());
    }

    @Override
    public void setConverterContext(ConverterContext converterContext) {
        this._converterContext = converterContext;
    }

    @Override
    public ConverterContext getConverterContext() {
        return this._converterContext;
    }

    public void setEditorContext(EditorContext editorContext) {
        this._editorContext = editorContext;
    }

    public EditorContext getEditorContext() {
        return this._editorContext;
    }

    public void setTable(JTable jTable) {
        this._table = jTable;
    }

    public JTable getTable() {
        return this._table;
    }

    public void setColumnIndex(int n) {
        this._columnIndex = n;
    }

    public int getColumnIndex() {
        return this._columnIndex;
    }

    @Override
    public Class<?> getType() {
        return this._class;
    }

    @Override
    public void setType(Class<?> clazz) {
        this._class = clazz;
    }
}

