/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.filter.Filter;
import com.jidesoft.grid.IFilterableTableModel;
import java.util.ArrayList;
import java.util.List;

public class FilterItemSupport {
    protected List<IFilterableTableModel.FilterItem> _allFilters = new ArrayList<IFilterableTableModel.FilterItem>();
    protected boolean _filtersApplied = false;
    private boolean _andMode = true;

    public void addFilter(int n, Filter filter) {
        if (filter != null) {
            this.addFilter(new IFilterableTableModel.FilterItem(n, filter));
        }
    }

    public void addFilter(IFilterableTableModel.FilterItem filterItem) {
        this._allFilters.add(filterItem);
    }

    public void addFilter(Filter filter) {
        this.addFilter(-2, filter);
    }

    public boolean removeFilter(int n, Filter filter) {
        return filter != null && this.removeFilter(new IFilterableTableModel.FilterItem(n, filter));
    }

    public boolean removeFilter(IFilterableTableModel.FilterItem filterItem) {
        return this._allFilters.remove(filterItem);
    }

    public boolean removeFilter(Filter filter) {
        return this.removeFilter(-2, filter);
    }

    public boolean removeAllFilters(int n) {
        IFilterableTableModel.FilterItem[] filterItemArray;
        boolean bl = false;
        for (IFilterableTableModel.FilterItem filterItem : filterItemArray = this._allFilters.toArray(new IFilterableTableModel.FilterItem[this._allFilters.size()])) {
            if (filterItem.column != n) continue;
            this._allFilters.remove(filterItem);
            bl = true;
        }
        return bl;
    }

    public void removeAllFilters() {
        this.removeAllFilters(-2);
    }

    public boolean clearFilters() {
        if (this._allFilters.size() > 0) {
            this._allFilters.clear();
            return true;
        }
        return false;
    }

    public Filter[] getFilters(int n) {
        List<Filter> list = this.internalGetFilters(n);
        if (list != null) {
            return list.toArray(new Filter[list.size()]);
        }
        return new Filter[0];
    }

    List<Filter> internalGetFilters(int n) {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        if (this._allFilters != null) {
            for (IFilterableTableModel.FilterItem filterItem : this._allFilters) {
                if (filterItem == null || filterItem.column != n) continue;
                arrayList.add(filterItem.filter);
            }
        }
        return arrayList;
    }

    public List<IFilterableTableModel.FilterItem> getFilterItems() {
        return this._allFilters;
    }

    public void setFiltersApplied(boolean bl) {
        this._filtersApplied = bl;
    }

    public boolean isFiltersApplied() {
        return this._filtersApplied;
    }

    public boolean hasFilter() {
        return this._allFilters != null && !this._allFilters.isEmpty();
    }

    public boolean hasFilter(int n) {
        if (!this.hasFilter()) {
            return false;
        }
        for (IFilterableTableModel.FilterItem filterItem : this._allFilters) {
            if (!filterItem.getFilter().isEnabled() || filterItem.getColumn() != n && filterItem.getColumn() != -1 && filterItem.getColumn() != -2) continue;
            return true;
        }
        return false;
    }

    public boolean isAndMode() {
        return this._andMode;
    }

    public void setAndMode(boolean bl) {
        this._andMode = bl;
    }
}

