/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.swing.JideSwingUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.table.TableModel;

public class Field
implements Serializable {
    private static final long serialVersionUID = 1227671004369027801L;
    private String _name;
    private String _title;
    private String _description;
    private Icon _icon;
    private Class<?> _type;
    protected ConverterContext _converterContext;
    protected EditorContext _editorContext;
    private ComparatorContext _comparatorContext;
    private int _preferredWidth = 0;
    private Object[] _selectedPossibleValues;
    private Object[] _filteredPossibleValues;
    private boolean _preferSelectedPossibleValues = false;
    private boolean _isNullValueAllowed = false;
    private boolean _isCustomFilterAllowed = true;
    private boolean _customizable = true;
    private boolean _filterable = true;
    private boolean _sortable = true;
    private boolean _expandable = true;
    private boolean _visible = true;
    private Filter _filter;
    private boolean _duplicated;
    protected int _sortOrder = 1;
    public static final int SORT_ORDER_ASCENDING = 1;
    public static final int SORT_ORDER_DESCENDING = -1;
    public static final int SORT_ORDER_UNSORTED = 0;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_CONVERTER_CONTEXT = "converterContext";
    public static final String PROPERTY_EDITOR_CONTEXT = "editorContext";
    public static final String PROPERTY_FILTERABLE = "filterable";
    public static final String PROPERTY_SORTABLE = "sortable";
    public static final String PROPERTY_EXPANDABLE = "expandable";
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String PROPERTY_CUSTOMIZABLE = "customizable";
    public static final String PROPERTY_SELECTED_POSSIBLE_VALUES = "selectedPossibleValues";
    public static final String PROPERTY_DESELECTED_POSSIBLE_VALUES = "deselectedPossibleValues";
    public static final String PROPERTY_FILTER = "filter";
    public static final String PROPERTY_SORT_ORDER = "sortOrder";
    public static final String PROPERTY_PREFER_SELECTED_VALUES = "preferSelecetedValues";
    protected PropertyChangeSupport changeSupport;
    protected TableModel _tableModel;
    protected int _modelIndex;
    protected boolean _isConverterContextSet = false;
    protected boolean _isEditorContextSet = false;
    public static final String PROPERTY_ASCENDING = "ascending";

    public Field() {
    }

    public Field(String string) {
        this(string, null, String.class);
    }

    public Field(String string, Class<?> clazz) {
        this(string, null, clazz);
    }

    public Field(String string, String string2, Class<?> clazz) {
        this._name = string;
        this._title = string2;
        this._type = clazz;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        String string2 = this._name;
        this._name = string;
        this.firePropertyChange(PROPERTY_NAME, string2, string);
        if (this._title == null) {
            this.firePropertyChange(PROPERTY_TITLE, string2, string);
        }
    }

    public String getTitle() {
        return this._title == null ? this.getName() : this._title;
    }

    public void setTitle(String string) {
        if (!JideSwingUtilities.equals(string, this._title)) {
            String string2 = this._title;
            this._title = string;
            this.firePropertyChange(PROPERTY_TITLE, string2, string);
        }
    }

    public String getDescription() {
        return this._description == null ? this.getTitle() : this._description;
    }

    public void setDescription(String string) {
        String string2 = this._description;
        this._description = string;
        this.firePropertyChange(PROPERTY_DESCRIPTION, string2, string);
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this._icon;
        this._icon = icon;
        this.firePropertyChange(PROPERTY_ICON, icon2, icon);
    }

    public Class<?> getType() {
        return this._type;
    }

    public void setType(Class<?> clazz) {
        Class<?> clazz2 = this._type;
        if (clazz2 != clazz) {
            this._type = clazz;
            this.firePropertyChange(PROPERTY_TYPE, clazz2, clazz);
        }
    }

    public ConverterContext getConverterContext() {
        return this._converterContext;
    }

    public void setConverterContext(ConverterContext converterContext) {
        this._isConverterContextSet = converterContext != null;
        this.internalSetConverterContext(converterContext);
    }

    private void internalSetConverterContext(ConverterContext converterContext) {
        ConverterContext converterContext2 = this._converterContext;
        if (converterContext2 != converterContext) {
            this._converterContext = converterContext;
            this.firePropertyChange(PROPERTY_CONVERTER_CONTEXT, converterContext2, converterContext);
        }
    }

    public EditorContext getEditorContext() {
        return this._editorContext;
    }

    public void setEditorContext(EditorContext editorContext) {
        this._isEditorContextSet = editorContext != null;
        this.internalSetEditorContext(editorContext);
    }

    private void internalSetEditorContext(EditorContext editorContext) {
        EditorContext editorContext2 = this._editorContext;
        if (editorContext2 != editorContext) {
            this._editorContext = editorContext;
            this.firePropertyChange(PROPERTY_EDITOR_CONTEXT, editorContext2, editorContext);
        }
    }

    public ComparatorContext getComparatorContext() {
        return this._comparatorContext;
    }

    public void setComparatorContext(ComparatorContext comparatorContext) {
        this._comparatorContext = comparatorContext;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected synchronized void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    protected void firePropertyChange(String string, int n, int n2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, n, n2);
    }

    public int getPreferredWidth() {
        return this._preferredWidth;
    }

    public void setPreferredWidth(int n) {
        if (n > 0) {
            this._preferredWidth = n;
        }
    }

    public void setSelectedPossibleValues(Object[] objectArray) {
        Object[] objectArray2 = this._selectedPossibleValues;
        if (!JideSwingUtilities.equals(objectArray, objectArray2, true)) {
            this._selectedPossibleValues = objectArray;
            if (this._selectedPossibleValues != null) {
                this._filteredPossibleValues = null;
            }
            this.firePropertyChange(PROPERTY_SELECTED_POSSIBLE_VALUES, objectArray2, objectArray);
        }
    }

    public Object[] getSelectedPossibleValues() {
        return this._selectedPossibleValues;
    }

    public void setFilteredPossibleValues(Object[] objectArray) {
        Object[] objectArray2 = this._filteredPossibleValues;
        if (!JideSwingUtilities.equals(objectArray, objectArray2, true)) {
            this._filteredPossibleValues = objectArray;
            if (this._filteredPossibleValues != null) {
                this._selectedPossibleValues = null;
            }
            this.firePropertyChange(PROPERTY_DESELECTED_POSSIBLE_VALUES, objectArray2, this._filteredPossibleValues);
        }
    }

    public Object[] getFilteredPossibleValues() {
        return this._filteredPossibleValues;
    }

    public boolean isPreferSelectedPossibleValues() {
        return this._preferSelectedPossibleValues;
    }

    public void setPreferSelectedPossibleValues(boolean bl) {
        boolean bl2 = this._preferSelectedPossibleValues;
        if (bl2 != bl) {
            this._preferSelectedPossibleValues = bl;
            this.firePropertyChange(PROPERTY_PREFER_SELECTED_VALUES, bl2, this._preferSelectedPossibleValues);
        }
    }

    public boolean isNullValueAllowed() {
        return this._isNullValueAllowed;
    }

    public void setNullValueAllowed(boolean bl) {
        this._isNullValueAllowed = bl;
    }

    public boolean isCustomFilterAllowed() {
        return this._isCustomFilterAllowed;
    }

    public void setCustomFilterAllowed(boolean bl) {
        this._isCustomFilterAllowed = bl;
    }

    public boolean isCustomizable() {
        return this._customizable;
    }

    public void setCustomizable(boolean bl) {
        boolean bl2 = this._customizable;
        if (bl2 != bl) {
            this._customizable = bl;
            this.firePropertyChange(PROPERTY_CUSTOMIZABLE, bl2, bl);
        }
    }

    public boolean isFilterable() {
        return this._filterable;
    }

    public void setFilterable(boolean bl) {
        boolean bl2 = this._filterable;
        if (bl2 != bl) {
            this._filterable = bl;
            this.firePropertyChange(PROPERTY_FILTERABLE, bl2, bl);
        }
    }

    public boolean isExpandable() {
        return this._expandable;
    }

    public void setExpandable(boolean bl) {
        boolean bl2 = this._expandable;
        if (bl2 != bl) {
            this._expandable = bl;
            this.firePropertyChange(PROPERTY_EXPANDABLE, bl2, bl);
        }
    }

    public boolean isSortable() {
        return this._sortable;
    }

    public void setSortable(boolean bl) {
        boolean bl2 = this._sortable;
        if (bl2 != bl) {
            this._sortable = bl;
            this.firePropertyChange(PROPERTY_SORTABLE, bl2, bl);
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this._visible;
        if (bl2 != bl) {
            this._visible = bl;
            this.firePropertyChange(PROPERTY_VISIBLE, bl2, bl);
        }
    }

    public Filter getActualFilter() {
        if (this.getFilter() != null) {
            return this.getFilter();
        }
        if (this.isPreferSelectedPossibleValues()) {
            Object[] objectArray = this.getSelectedPossibleValues();
            if (objectArray != null) {
                MultipleValuesFilter<Object> multipleValuesFilter = new MultipleValuesFilter<Object>();
                multipleValuesFilter.setValues(objectArray);
                return multipleValuesFilter;
            }
        } else {
            Object[] objectArray = this.getFilteredPossibleValues();
            if (objectArray != null) {
                MultipleValuesFilter<Object> multipleValuesFilter = new MultipleValuesFilter<Object>();
                multipleValuesFilter.setValues(objectArray);
                return new NotFilter(multipleValuesFilter);
            }
        }
        return null;
    }

    public Filter getFilter() {
        return this._filter;
    }

    public void setFilter(Filter filter) {
        if (this._filter != filter) {
            Filter filter2 = this._filter;
            this._filter = filter;
            this.firePropertyChange(PROPERTY_FILTER, filter2, this._filter);
        }
    }

    public int getSortOrder() {
        return this._sortOrder;
    }

    public void setSortOrder(int n) {
        int n2 = this._sortOrder;
        if (n2 != n) {
            this._sortOrder = n;
            this.firePropertyChange(PROPERTY_SORT_ORDER, n2, this._sortOrder);
        }
    }

    public void updateFromTableModel(TableModel tableModel, int n) {
        this._tableModel = tableModel;
        this._modelIndex = n;
        String string = this.getName();
        if (this._tableModel instanceof ColumnIdentifierTableModel) {
            this.setName(((ColumnIdentifierTableModel)((Object)this._tableModel)).getColumnIdentifier(n).toString());
        } else {
            this.setName(this._tableModel.getColumnName(n));
        }
        if (!JideSwingUtilities.equals(string, this.getName())) {
            this.setType(this._tableModel.getColumnClass(n));
            if (this._tableModel instanceof ContextSensitiveTableModel) {
                try {
                    if (!this._isConverterContextSet) {
                        this.internalSetConverterContext(((ContextSensitiveTableModel)this._tableModel).getConverterContextAt(0, n));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!this._isEditorContextSet) {
                        this.internalSetEditorContext(((ContextSensitiveTableModel)this._tableModel).getEditorContextAt(0, n));
                    }
                }
                catch (Exception exception) {}
            } else {
                if (!this._isConverterContextSet) {
                    this.internalSetConverterContext(null);
                }
                if (this._isEditorContextSet) {
                    this.internalSetEditorContext(null);
                }
            }
        }
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    public int getModelIndex() {
        return this._modelIndex;
    }

    public boolean isAscending() {
        return this.getSortOrder() == 1;
    }

    public void toggleAscending() {
        this.setAscending(!this.isAscending());
    }

    public void setAscending(boolean bl) {
        boolean bl2 = this.isAscending();
        if (bl2 != bl) {
            this.setSortOrder(bl ? 1 : -1);
            this.firePropertyChange(PROPERTY_ASCENDING, bl2, bl);
        }
    }

    public boolean isDuplicated() {
        return this._duplicated;
    }

    public void setDuplicated(boolean bl) {
        this._duplicated = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Field field = (Field)object;
        return this._name != null ? this._name.equals(field._name) : field._name == null;
    }

    public int hashCode() {
        return this._name != null ? this._name.hashCode() : 0;
    }
}

