/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandablePanel;
import com.jidesoft.grid.ExpandableProvider;
import com.jidesoft.grid.GridResource;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ExpandableTableCellRenderer
extends DefaultTableCellRenderer {
    protected ExpandablePanel _cellRenderer;
    protected TableCellRenderer _actualCellRenderer;

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (!(jTable instanceof ExpandableProvider)) {
            return this.getActualCellRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        ExpandableProvider expandableProvider = (ExpandableProvider)((Object)jTable);
        if (this._cellRenderer == null) {
            this._cellRenderer = this.createExpandablePanel((CategorizedTable)jTable);
        }
        this._cellRenderer.applyComponentOrientation(jTable.getComponentOrientation());
        int n3 = jTable.convertColumnIndexToModel(n2);
        Expandable expandable = expandableProvider.getExpandableAt(n, n3);
        this._cellRenderer.setSelected(bl);
        this._cellRenderer.setHasFocus(bl2);
        TableCellRenderer tableCellRenderer = this.getActualCellRenderer();
        if (tableCellRenderer != null) {
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, this.prepareValue(object), bl, false, n, n2);
            this._cellRenderer.setNode(expandable);
            this.customizeCellRenderer(jTable, expandable, component, n, n2);
            component.setBackground(null);
            this._cellRenderer.setActualRenderer(component);
        }
        return this._cellRenderer;
    }

    protected Object prepareValue(Object object) {
        return object == null ? GridResource.getResourceBundle(this.getLocale()).getString("Filter.null") : object;
    }

    protected ExpandablePanel createExpandablePanel(CategorizedTable categorizedTable) {
        return new ExpandablePanel(categorizedTable, categorizedTable.getExpandedIcon(), categorizedTable.getCollapsedIcon(), categorizedTable.getDisabledBackground(), categorizedTable.getDisabledForeground());
    }

    protected void customizeCellRenderer(JTable jTable, Expandable expandable, Component component, int n, int n2) {
    }

    public TableCellRenderer getActualCellRenderer() {
        return this._actualCellRenderer;
    }

    public void setActualCellRenderer(TableCellRenderer tableCellRenderer) {
        this._actualCellRenderer = tableCellRenderer;
    }
}

