/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.AbstractExpandable;
import com.jidesoft.grid.AbstractGroupTableModel;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ColumnDraggableSupport;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.ColumnTableModelWrapper;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DefaultGroupRow;
import com.jidesoft.grid.DefaultGroupTableSummaryCalculator;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EditorStyleTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.GroupCondition;
import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.GroupableTableModel;
import com.jidesoft.grid.IndexChangeEventGenerator;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.grid.IndexChangeListenerHelper;
import com.jidesoft.grid.IndexReferenceRow;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.ReferenceRow;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.RowTableModelWrapper;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.SummaryCalculator;
import com.jidesoft.grid.SummaryGroupRow;
import com.jidesoft.grid.SummaryProvider;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.grouper.ObjectGrouperManager;
import com.jidesoft.swing.JideSwingUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DefaultGroupTableModel
extends AbstractGroupTableModel
implements ColumnIdentifierTableModel,
SpanModel,
RowTableModelWrapper,
ColumnTableModelWrapper,
GroupModelProvider,
EditorStyleTableModel,
ColumnDraggableSupport,
SummaryProvider,
StyleModel {
    private TableModel _tableModel;
    private GroupableTableModel _groupableTableModel;
    private List<GroupColumn> _groupColumns;
    private final List<Row> _referenceRows = new ArrayList<Row>();
    private int[] _columnMapping;
    private transient Comparator[] _cachedComparators;
    private boolean _singleLevelGrouping = false;
    private boolean _displayGroupColumns = false;
    private boolean _displayCountColumn = false;
    private boolean _keepColumnOrder = false;
    private boolean _propertyChanged = false;
    private boolean _ascendingGroupOrder = true;
    private boolean _displaySeparateGroupColumn = false;
    private boolean _displayGroupValueOnFirstColumn = false;
    private boolean _removeNullGrouper = false;
    private boolean _displayGroupRowsFirst = false;
    private boolean _keepPreviousExpandStatus = true;
    private boolean _keepGroupingOnStructureChange = false;
    private boolean _originalRowsHidden = false;
    private boolean _summaryMode = false;
    private int[] _summaryTypes;
    private SummaryCalculator _summaryCalculator;
    private boolean _tableModelAdjusting = false;
    private TableModelEvent _originalEvent;
    private static final long serialVersionUID = 5330335595254824059L;
    private int _previousGroupColumnCount = 0;
    public static final int SORT_GROUP_COLUMN_NO_SORT = 0;
    public static final int SORT_GROUP_COLUMN_ASCENDING = 1;
    public static final int SORT_GROUP_COLUMN_DESCENDING = -1;
    private PropertyChangeSupport changeSupport;
    public static final String PROPERTY_GROUPED_COLUMNS = "groupColumns";
    private ColumnComparatorContextProvider _columnComparatorContextProvider;
    private boolean _alwaysUseComparators = false;

    public DefaultGroupTableModel(TableModel tableModel) {
        this.setAutoExpand(true);
        IndexChangeListenerHelper indexChangeListenerHelper = new IndexChangeListenerHelper(this);
        this._tableModel = tableModel;
        this._groupableTableModel = (GroupableTableModel)TableModelWrapperUtils.getActualTableModel(tableModel, GroupableTableModel.class);
        if (this._tableModel instanceof IndexChangeEventGenerator) {
            ((IndexChangeEventGenerator)((Object)this._tableModel)).addIndexChangeListener(indexChangeListenerHelper);
        }
        this.resetSummaryTypes();
        this._tableModel.addTableModelListener(new TableModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean tableChangedGroupDisabled(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
                int n;
                boolean bl = false;
                if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getEvents() != null && ((CompoundTableModelEvent)tableModelEvent).getEvents().length > 0) {
                    for (TableModelEvent tableModelEvent2 : ((CompoundTableModelEvent)tableModelEvent).getEvents()) {
                        if (!this.tableChangedGroupDisabled(compoundTableModelEvent, tableModelEvent2)) continue;
                        return true;
                    }
                }
                int n2 = DefaultGroupTableModel.this.getRowCount();
                if (tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() >= 0 && tableModelEvent.getFirstRow() < n2 && tableModelEvent.getLastRow() >= 0 && tableModelEvent.getLastRow() < n2) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(DefaultGroupTableModel.this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
                } else if (tableModelEvent.getType() == 1) {
                    List list = DefaultGroupTableModel.this._referenceRows;
                    synchronized (list) {
                        n = n2 - DefaultGroupTableModel.this._referenceRows.size();
                        for (int i = 0; i < n; ++i) {
                            ReferenceRow referenceRow = DefaultGroupTableModel.this.createReferenceRow(DefaultGroupTableModel.this._tableModel, i + tableModelEvent.getFirstRow());
                            DefaultGroupTableModel.this._referenceRows.add(referenceRow);
                        }
                    }
                    bl = true;
                    compoundTableModelEvent.addEvent(new TableModelEvent(DefaultGroupTableModel.this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
                } else if (tableModelEvent.getType() == -1) {
                    List list = DefaultGroupTableModel.this._referenceRows;
                    synchronized (list) {
                        n = DefaultGroupTableModel.this._referenceRows.size() - n2;
                        for (int i = 0; i < n; ++i) {
                            DefaultGroupTableModel.this._referenceRows.remove(n2);
                        }
                    }
                    compoundTableModelEvent.addEvent(new TableModelEvent(DefaultGroupTableModel.this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
                } else {
                    bl = true;
                }
                return bl;
            }

            private void tableChangedGroupEnabled(TableModelEvent tableModelEvent) {
                if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getEvents() != null && ((CompoundTableModelEvent)tableModelEvent).getEvents().length > 0) {
                    int n = Integer.MAX_VALUE;
                    int n2 = 0;
                    int n3 = -2;
                    boolean bl = true;
                    for (TableModelEvent tableModelEvent2 : ((CompoundTableModelEvent)tableModelEvent).getEvents()) {
                        if (tableModelEvent2.getType() != 0) {
                            bl = false;
                            break;
                        }
                        if (tableModelEvent2.getFirstRow() < n) {
                            n = tableModelEvent2.getFirstRow();
                        }
                        if (tableModelEvent2.getLastRow() > n2) {
                            n2 = tableModelEvent2.getLastRow();
                        }
                        if (n3 == -2) {
                            n3 = tableModelEvent2.getColumn();
                            continue;
                        }
                        if (tableModelEvent2.getColumn() == n3) continue;
                        n3 = -1;
                    }
                    if (bl) {
                        if (n == -1) {
                            this.clearAllCache(tableModelEvent);
                            DefaultGroupTableModel.this.tableStructureChanged();
                        } else if (n2 == Integer.MAX_VALUE) {
                            this.clearAllCache(tableModelEvent);
                            DefaultGroupTableModel.this.tableDataChanged();
                        } else if (n3 == -1) {
                            DefaultGroupTableModel.this.tableRowsUpdated(n, n2);
                        } else {
                            DefaultGroupTableModel.this.tableCellsUpdated(n3, n, n2);
                        }
                        return;
                    }
                    for (TableModelEvent tableModelEvent2 : ((CompoundTableModelEvent)tableModelEvent).getEvents()) {
                        this.tableChangedGroupEnabled(tableModelEvent2);
                    }
                }
                switch (tableModelEvent.getType()) {
                    case 1: {
                        DefaultGroupTableModel.this.tableRowsInserted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        break;
                    }
                    case -1: {
                        DefaultGroupTableModel.this.tableRowsDeleted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        break;
                    }
                    case 0: {
                        if (tableModelEvent.getFirstRow() == -1) {
                            this.clearAllCache(tableModelEvent);
                            DefaultGroupTableModel.this.tableStructureChanged();
                            break;
                        }
                        if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                            this.clearAllCache(tableModelEvent);
                            DefaultGroupTableModel.this.tableDataChanged();
                            break;
                        }
                        if (tableModelEvent.getColumn() == -1) {
                            DefaultGroupTableModel.this.tableRowsUpdated(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                            break;
                        }
                        DefaultGroupTableModel.this.tableCellsUpdated(tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown TableModelEvent type: " + tableModelEvent.getType());
                    }
                }
            }

            private void clearAllCache(TableModelEvent tableModelEvent) {
                Object object;
                if ((!(tableModelEvent instanceof CompoundTableModelEvent) || ((CompoundTableModelEvent)tableModelEvent).isOriginalChanged()) && (object = DefaultGroupTableModel.this.getRoot()) instanceof RootExpandableRow) {
                    ((RootExpandableRow)object).invalidateSummaryCache();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent instanceof CompoundTableModelEvent) {
                    DefaultGroupTableModel.this._originalEvent = ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent();
                } else {
                    DefaultGroupTableModel.this._originalEvent = tableModelEvent;
                }
                try {
                    if (!DefaultGroupTableModel.this.isGroupEnabled()) {
                        CompoundTableModelEvent compoundTableModelEvent = DefaultGroupTableModel.this.createCompoundTableModelEvent();
                        if (tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) {
                            compoundTableModelEvent.addEvent(new TableModelEvent(DefaultGroupTableModel.this, -1));
                            CompoundTableModelEvent.fireTableModelEvent(DefaultGroupTableModel.this, compoundTableModelEvent);
                        } else if (this.tableChangedGroupDisabled(compoundTableModelEvent, tableModelEvent)) {
                            DefaultGroupTableModel.this.groupAndRefresh(false);
                        } else {
                            CompoundTableModelEvent.fireTableModelEvent(DefaultGroupTableModel.this, compoundTableModelEvent);
                        }
                        return;
                    }
                    DefaultGroupTableModel.this.setTableModelAdjusting(true);
                    try {
                        this.tableChangedGroupEnabled(tableModelEvent);
                    }
                    finally {
                        DefaultGroupTableModel.this.setTableModelAdjusting(false);
                    }
                }
                finally {
                    DefaultGroupTableModel.this._originalEvent = null;
                }
            }
        });
        this.groupAndRefresh(false);
    }

    @Override
    public IndexChangeListener[] getIndexChangeListeners() {
        return (IndexChangeListener[])this.getListeners(IndexChangeListener.class);
    }

    @Override
    public void fireTableRowsDeleted(int n, int n2) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        compoundTableModelEvent.addEvent(new TableModelEvent(this, n, n2, -1, -1));
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    @Override
    public void fireTableRowsInserted(int n, int n2) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        compoundTableModelEvent.addEvent(new TableModelEvent(this, n, n2, -1, 1));
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    @Override
    public void fireTableRowsUpdated(int n, int n2) {
        int[] nArray = this.getRowsNeedUpdated(n, n2);
        if (nArray != null && nArray.length == 2) {
            int n3 = nArray[0];
            int n4 = nArray[1];
            CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n3, n4, -1, 0));
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
        }
    }

    @Override
    public void fireTableCellUpdated(int n, int n2) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        compoundTableModelEvent.addEvent(new TableModelEvent(this, n, n, n2));
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    @Override
    public boolean isColumnGroupable(int n) {
        return true;
    }

    @Override
    protected CompoundTableModelEvent createCompoundTableModelEvent() {
        CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(this);
        compoundTableModelEvent.setOriginalEvent(this._originalEvent);
        return compoundTableModelEvent;
    }

    @Override
    public void groupAndRefresh() {
        this.groupAndRefresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void groupAndRefresh(boolean bl) {
        Object object;
        if (this.isKeepColumnOrder() && this.isDisplayCountColumn() && (this.getGroupColumnCount() > 0 && this._previousGroupColumnCount == 0 || this.getGroupColumnCount() == 0 && this._previousGroupColumnCount > 0)) {
            this._propertyChanged = true;
        }
        this.ensureColumnIndexMapping();
        this.setAdjusting(true);
        boolean bl2 = bl && (!this.isKeepColumnOrder() || this._propertyChanged);
        this._propertyChanged = false;
        int n = this.fireIndexChanging(false);
        try {
            object = this._referenceRows;
            synchronized (object) {
                Object object2;
                Object object3;
                DefaultGroupRow[] defaultGroupRowArray;
                ArrayList arrayList = new ArrayList();
                ((ExpandableRow)this.getRoot()).setChildren(arrayList);
                this._referenceRows.clear();
                int n2 = this._tableModel.getRowCount();
                for (int i = 0; i < n2; ++i) {
                    defaultGroupRowArray = this.createReferenceRow(this._tableModel, i);
                    this._referenceRows.add((Row)defaultGroupRowArray);
                }
                ArrayList<DefaultGroupRow> arrayList2 = new ArrayList<DefaultGroupRow>();
                defaultGroupRowArray = new DefaultGroupRow[]{};
                int n3 = 0;
                List list = this.getRows();
                if (this.isKeepPreviousExpandStatus() && (this._originalEvent == null || this._originalEvent.getFirstRow() != -1)) {
                    object3 = null;
                    for (Object t : list) {
                        if (!(t instanceof DefaultGroupRow)) continue;
                        arrayList2.add((DefaultGroupRow)t);
                        if (n3 >= ((DefaultGroupRow)t).getNumberOfConditions()) continue;
                        n3 = ((DefaultGroupRow)t).getNumberOfConditions();
                        object3 = (DefaultGroupRow)t;
                    }
                    if (object3 != null) {
                        this._cachedComparators = new Comparator[this._tableModel.getColumnCount()];
                        for (int i = 0; i < n3; ++i) {
                            int n4 = ((DefaultGroupRow)object3).getConditionColumn(i);
                            if (n4 < 0 || n4 >= this._tableModel.getColumnCount()) continue;
                            object2 = this.getComparator(n4);
                            this._cachedComparators[n4] = object2 == null ? ObjectComparatorManager.getComparator(String.class) : object2;
                        }
                        defaultGroupRowArray = arrayList2.toArray(new DefaultGroupRow[arrayList2.size()]);
                        this.sortExistingGroupRows((DefaultGroupRow[])defaultGroupRowArray.clone(), defaultGroupRowArray, 0, defaultGroupRowArray.length);
                    }
                }
                if (this.hasGroupColumns()) {
                    int n5;
                    object3 = new int[this._tableModel.getRowCount()];
                    for (n5 = 0; n5 < this._tableModel.getRowCount(); ++n5) {
                        object3[n5] = n5;
                    }
                    this.cacheComparators();
                    this.sort((int[])object3.clone(), (int[])object3, 0, this._tableModel.getRowCount());
                    for (n5 = 0; n5 < n2; ++n5) {
                        Object object4 = object3[n5];
                        object2 = this.ensureGroupRowCreatedSorted((int)object4, defaultGroupRowArray, n3);
                        if (object2 == null) {
                            Expandable expandable = (Expandable)this.getRoot();
                            for (int i = 0; i < expandable.getChildrenCount() && !(expandable.getChildAt(i) instanceof DefaultGroupRow); ++i) {
                            }
                            expandable.addChild(this._referenceRows.get((int)object4));
                            continue;
                        }
                        ((AbstractExpandable)object2).setAdjusting(true);
                        try {
                            int n6 = ((DefaultGroupRow)object2).getNumberOfConditions();
                            if (n6 == this._groupColumns.size()) {
                                ((AbstractExpandable)object2).addChild(this._referenceRows.get((int)object4));
                                continue;
                            }
                            GroupColumn groupColumn = null;
                            if (n6 >= 1) {
                                groupColumn = this._groupColumns.get(n6 - 1);
                            }
                            if (groupColumn != null && groupColumn.getColumnSorting() != 0) {
                                if (this.isDisplayGroupRowsFirst()) {
                                    ((AbstractExpandable)object2).addChild(this._referenceRows.get((int)object4));
                                    continue;
                                }
                                this.insertReferenceRow((DefaultGroupRow)object2, this._referenceRows.get((int)object4));
                                continue;
                            }
                            ((AbstractExpandable)object2).addChild(this._referenceRows.get((int)object4));
                            continue;
                        }
                        finally {
                            ((AbstractExpandable)object2).setAdjusting(false);
                        }
                    }
                    this.refresh(!bl2, false);
                    if (this.isAutoExpand(null) && !this.isKeepPreviousExpandStatus()) {
                        this.expandAll(!bl2);
                    }
                } else {
                    object3 = (ExpandableRow)this.getRoot();
                    object3.setChildren(this._referenceRows);
                    this.refresh(!bl2, false);
                }
            }
        }
        finally {
            this.setAdjusting(false);
            if (bl2) {
                object = this.createCompoundTableModelEvent();
                ((CompoundTableModelEvent)object).addEvent(new TableModelEvent(this, -1));
                CompoundTableModelEvent.fireTableModelEvent(this, (TableModelEvent)object);
            }
            this.fireIndexChanged(n);
            this._previousGroupColumnCount = this.getGroupColumnCount();
        }
    }

    private void insertReferenceRow(DefaultGroupRow defaultGroupRow, Row row) {
        int n = 0;
        int n2 = defaultGroupRow.getChildrenCount();
        int n3 = n2 / 2;
        while (n < n2) {
            Object object = defaultGroupRow.getChildAt(n3);
            if (!(object instanceof DefaultGroupRow)) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + (n2 - n) / 2;
        }
        if (++n3 >= defaultGroupRow.getChildrenCount()) {
            n3 = defaultGroupRow.getChildrenCount();
        }
        while (n3 >= 1 && defaultGroupRow.getChildAt(n3 - 1) instanceof DefaultGroupRow) {
            --n3;
        }
        defaultGroupRow.addChild(n3, row);
    }

    private DefaultGroupRow ensureGroupRowCreated(int n) {
        DefaultGroupRow defaultGroupRow = this.findGroupRow((Expandable)this.getRoot(), this._tableModel, n);
        if (defaultGroupRow == null) {
            defaultGroupRow = this.createGroupRow();
            for (GroupColumn groupColumn : this._groupColumns) {
                int n2 = groupColumn.getColumnIndex();
                Object object = this._tableModel.getValueAt(n, n2);
                if (this._groupableTableModel != null) {
                    ObjectGrouper objectGrouper = ObjectGrouperManager.getGrouper(this._groupableTableModel.getColumnClass(n2), this._groupableTableModel.getGrouperContext(n2));
                    defaultGroupRow.addCondition(n2, objectGrouper != null ? objectGrouper.getValue(object) : object, objectGrouper);
                    continue;
                }
                defaultGroupRow.addCondition(n2, object);
            }
            defaultGroupRow = this.addGroupRow((Expandable)this.getRoot(), defaultGroupRow);
        }
        return defaultGroupRow;
    }

    private DefaultGroupRow ensureGroupRowCreatedSorted(int n, DefaultGroupRow[] defaultGroupRowArray, int n2) {
        DefaultGroupRow defaultGroupRow = this.findGroupRowSorted((Expandable)this.getRoot(), this._tableModel, n);
        if (defaultGroupRow == null) {
            if (this.isRemoveNullGrouper()) {
                GroupColumn groupColumn;
                int n3;
                for (n3 = 0; n3 < this._groupColumns.size() && this._tableModel.getValueAt(n, (groupColumn = this._groupColumns.get(n3)).getColumnIndex()) == null; ++n3) {
                }
                if (n3 >= this._groupColumns.size()) {
                    return null;
                }
            }
            defaultGroupRow = this.createGroupRow();
            for (GroupColumn groupColumn : this._groupColumns) {
                int n4 = groupColumn.getColumnIndex();
                if (n4 < 0) continue;
                Object object = this._tableModel.getValueAt(n, n4);
                if (this.isRemoveNullGrouper() && object == null) continue;
                if (this._groupableTableModel != null) {
                    ObjectGrouper objectGrouper = ObjectGrouperManager.getGrouper(this._groupableTableModel.getColumnClass(n4), this._groupableTableModel.getGrouperContext(n4));
                    defaultGroupRow.addCondition(n4, objectGrouper != null ? objectGrouper.getValue(object) : object, objectGrouper);
                    continue;
                }
                defaultGroupRow.addCondition(n4, object);
            }
            this.setExpandStatusFromExistingRows(defaultGroupRow, defaultGroupRowArray, n2);
            defaultGroupRow = this.addGroupRowSorted((Expandable)this.getRoot(), defaultGroupRow, defaultGroupRowArray, n2);
        }
        return defaultGroupRow;
    }

    private void setExpandStatusFromExistingRows(DefaultGroupRow defaultGroupRow, DefaultGroupRow[] defaultGroupRowArray, int n) {
        int n2;
        if (!this.isKeepPreviousExpandStatus() || defaultGroupRow == null || defaultGroupRowArray == null) {
            return;
        }
        int n3 = defaultGroupRow.getNumberOfConditions();
        if (this.isOriginalRowsHidden() && n3 == this.getGroupColumnCount()) {
            defaultGroupRow.setExpandable(false);
            defaultGroupRow.setExpanded(false);
            return;
        }
        if (n3 > n) {
            return;
        }
        int n4 = 0;
        int n5 = n2 = defaultGroupRowArray.length - 1;
        boolean bl = false;
        while (n4 <= n2) {
            n5 = n4 + n2 >> 1;
            int n6 = this.compareGroupRows(defaultGroupRowArray[n5], defaultGroupRow);
            if (n6 < 0) {
                n4 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n2 = n5 - 1;
                continue;
            }
            bl = true;
            break;
        }
        if (bl && n5 >= 0 && n5 < defaultGroupRowArray.length && defaultGroupRowArray[n5] != null) {
            defaultGroupRow.setExpanded(defaultGroupRowArray[n5].isExpanded());
        }
    }

    protected DefaultGroupRow createGroupRow() {
        DefaultGroupRow defaultGroupRow = this.isSummaryMode() ? new SummaryGroupRow() : new DefaultGroupRow();
        defaultGroupRow.setExpanded(this.isAutoExpand(defaultGroupRow));
        return defaultGroupRow;
    }

    protected ReferenceRow createReferenceRow(TableModel tableModel, int n) {
        return new IndexReferenceRow(this, tableModel, n);
    }

    public boolean isKeepColumnOrder() {
        return this._keepColumnOrder;
    }

    public void setKeepColumnOrder(boolean bl) {
        if (this._keepColumnOrder != bl) {
            this._keepColumnOrder = bl;
            this._propertyChanged = true;
        }
    }

    @Override
    public boolean isColumnDraggable(int n) {
        String string = this.getColumnName(n);
        return !JideSwingUtilities.equals(string, this.getCountColumnName()) && !JideSwingUtilities.equals(string, this.getSeparateGroupColumnName());
    }

    private void ensureColumnIndexMapping() {
        this._columnMapping = new int[this.getColumnCount()];
        if (this.hasGroupColumns()) {
            int n = 0;
            int n2 = -1;
            if (this.isDisplayCountColumn()) {
                this._columnMapping[n++] = n2--;
            }
            if (this.isDisplaySeparateGroupColumn()) {
                this._columnMapping[n++] = n2--;
            }
            if (!this.isKeepColumnOrder()) {
                if (this.isDisplayGroupColumns()) {
                    for (GroupColumn groupColumn : this._groupColumns) {
                        this._columnMapping[n++] = groupColumn.getColumnIndex();
                    }
                }
                for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
                    boolean bl = false;
                    for (GroupColumn groupColumn : this._groupColumns) {
                        if (groupColumn.getColumnIndex() != i) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    this._columnMapping[n++] = i;
                }
            } else {
                for (int i = n; i < this._columnMapping.length; ++i) {
                    this._columnMapping[i] = i - n;
                }
            }
        } else {
            for (int i = 0; i < this._columnMapping.length; ++i) {
                this._columnMapping[i] = i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultGroupRow addGroupRow(Expandable expandable, DefaultGroupRow defaultGroupRow) {
        Object object;
        int n;
        if (this.isSingleLevelGrouping() || defaultGroupRow.getNumberOfConditions() == 1) {
            try {
                Object object2;
                int n2;
                if (expandable instanceof AbstractExpandable && this.isAdjusting()) {
                    ((AbstractExpandable)expandable).setAdjusting(true);
                }
                for (n2 = 0; !(n2 >= expandable.getChildrenCount() || (object2 = expandable.getChildAt(n2)) instanceof DefaultGroupRow && this.compareGroupRows((DefaultGroupRow)object2, defaultGroupRow) > 0); ++n2) {
                }
                expandable.addChild(n2, defaultGroupRow);
            }
            finally {
                if (expandable instanceof AbstractExpandable && this.isAdjusting()) {
                    ((AbstractExpandable)expandable).setAdjusting(false);
                }
            }
            return defaultGroupRow;
        }
        DefaultGroupRow defaultGroupRow2 = this.findParentGroupRow(expandable, defaultGroupRow);
        if (defaultGroupRow2 == null) {
            defaultGroupRow2 = (DefaultGroupRow)defaultGroupRow.configureParentCondition(this.createGroupRow());
            DefaultGroupRow defaultGroupRow3 = this.addGroupRow(expandable, defaultGroupRow2);
            try {
                if (this.isAdjusting()) {
                    defaultGroupRow3.setAdjusting(true);
                }
                defaultGroupRow3.addChild(defaultGroupRow);
            }
            finally {
                if (this.isAdjusting()) {
                    defaultGroupRow3.setAdjusting(false);
                }
            }
            return defaultGroupRow;
        }
        expandable = defaultGroupRow2;
        for (n = 0; !(n >= expandable.getChildrenCount() || (object = expandable.getChildAt(n)) instanceof DefaultGroupRow && this.compareGroupRows((DefaultGroupRow)object, defaultGroupRow) > 0); ++n) {
        }
        expandable.addChild(n, defaultGroupRow);
        return defaultGroupRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultGroupRow addGroupRowSorted(Expandable expandable, DefaultGroupRow defaultGroupRow, DefaultGroupRow[] defaultGroupRowArray, int n) {
        if (this.isSingleLevelGrouping() || defaultGroupRow.getNumberOfConditions() == 1) {
            try {
                if (expandable instanceof AbstractExpandable && this.isAdjusting()) {
                    ((AbstractExpandable)expandable).setAdjusting(true);
                }
                expandable.addChild(defaultGroupRow);
            }
            finally {
                if (expandable instanceof AbstractExpandable && this.isAdjusting()) {
                    ((AbstractExpandable)expandable).setAdjusting(false);
                }
            }
            return defaultGroupRow;
        }
        DefaultGroupRow defaultGroupRow2 = this.findParentGroupRowSorted((Expandable)this.getRoot(), defaultGroupRow);
        if (defaultGroupRow2 == null) {
            defaultGroupRow2 = (DefaultGroupRow)defaultGroupRow.configureParentCondition(this.createGroupRow());
            this.setExpandStatusFromExistingRows(defaultGroupRow2, defaultGroupRowArray, n);
            DefaultGroupRow defaultGroupRow3 = this.addGroupRowSorted(expandable, defaultGroupRow2, defaultGroupRowArray, n);
            try {
                if (this.isAdjusting()) {
                    defaultGroupRow3.setAdjusting(true);
                }
                defaultGroupRow3.addChild(defaultGroupRow);
            }
            finally {
                if (this.isAdjusting()) {
                    defaultGroupRow3.setAdjusting(false);
                }
            }
            return defaultGroupRow;
        }
        try {
            if (this.isAdjusting()) {
                defaultGroupRow2.setAdjusting(true);
            }
            defaultGroupRow2.addChild(defaultGroupRow);
        }
        finally {
            if (this.isAdjusting()) {
                defaultGroupRow2.setAdjusting(false);
            }
        }
        return defaultGroupRow;
    }

    public DefaultGroupRow findParentGroupRow(Expandable expandable, GroupCondition groupCondition) {
        for (int i = 0; i < expandable.getChildrenCount(); ++i) {
            DefaultGroupRow defaultGroupRow;
            Row row = (Row)expandable.getChildAt(i);
            if (!(row instanceof DefaultGroupRow) || !(defaultGroupRow = (DefaultGroupRow)row).contains(groupCondition)) continue;
            if (defaultGroupRow.getNumberOfConditions() == groupCondition.getNumberOfConditions() - 1) {
                return defaultGroupRow;
            }
            defaultGroupRow = this.findParentGroupRow((Expandable)((Object)row), groupCondition);
            if (defaultGroupRow == null) continue;
            return defaultGroupRow;
        }
        return null;
    }

    private DefaultGroupRow findParentGroupRowSorted(Expandable expandable, GroupCondition groupCondition) {
        DefaultGroupRow defaultGroupRow;
        Row row = (Row)expandable.getChildAt(expandable.getChildrenCount() - 1);
        if (row instanceof DefaultGroupRow && (defaultGroupRow = (DefaultGroupRow)row).contains(groupCondition)) {
            if (defaultGroupRow.getNumberOfConditions() == groupCondition.getNumberOfConditions() - 1) {
                return defaultGroupRow;
            }
            defaultGroupRow = this.findParentGroupRowSorted((Expandable)((Object)row), groupCondition);
            if (defaultGroupRow != null) {
                return defaultGroupRow;
            }
        }
        boolean bl = false;
        for (GroupColumn object : this._groupColumns) {
            if (object.getColumnSorting() != 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (int i = expandable.getChildrenCount() - 1; i >= 0; --i) {
                int n;
                int n2;
                Object object = expandable.getChildAt(i);
                if (!(object instanceof DefaultGroupRow) || (n2 = ((DefaultGroupRow)object).getNumberOfConditions()) >= (n = groupCondition.getNumberOfConditions())) continue;
                boolean bl2 = true;
                for (int j = 0; j < n2; ++j) {
                    if (JideSwingUtilities.equals(((DefaultGroupRow)object).getConditionValue(j), groupCondition.getConditionValue(j))) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                if (n2 == n - 1) {
                    return (DefaultGroupRow)object;
                }
                return this.findParentGroupRowSorted((DefaultGroupRow)object, groupCondition);
            }
        }
        return null;
    }

    protected void ensureGroupColumnsCreated() {
        if (this._groupColumns == null) {
            this._groupColumns = new ArrayList<GroupColumn>();
        }
    }

    @Override
    public boolean isGroupEnabled() {
        return this.hasGroupColumns();
    }

    public boolean isColumnGrouped(int n) {
        if (this._groupColumns == null) {
            return false;
        }
        for (GroupColumn groupColumn : this._groupColumns) {
            if (groupColumn.getColumnIndex() != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasGroupColumns() {
        return this._groupColumns != null && !this._groupColumns.isEmpty();
    }

    @Override
    public int getGroupColumnCount() {
        this.ensureGroupColumnsCreated();
        return this._groupColumns.size();
    }

    @Override
    public int getGroupColumnAt(int n) {
        this.ensureGroupColumnsCreated();
        return this._groupColumns.get(n).getColumnIndex();
    }

    @Override
    public int getGroupColumnOrder(int n) {
        this.ensureGroupColumnsCreated();
        return this._groupColumns.get(n).getColumnSorting();
    }

    public void addGroupColumn(int n) {
        this.addGroupColumn(n, 1);
    }

    public void addGroupColumn(int n, int n2) {
        this.ensureGroupColumnsCreated();
        if (this.isColumnGroupable(n)) {
            this._groupColumns.add(new GroupColumn(n, n2));
            this.firePropertyChange(PROPERTY_GROUPED_COLUMNS, -1, n);
        }
    }

    public void removeGroupColumn(int n) {
        this.ensureGroupColumnsCreated();
        for (GroupColumn groupColumn : this._groupColumns) {
            if (groupColumn.getColumnIndex() != n) continue;
            this._groupColumns.remove(groupColumn);
            this.firePropertyChange(PROPERTY_GROUPED_COLUMNS, n, -1);
            break;
        }
    }

    public void setGroupColumns(int[] nArray) {
        this.setGroupColumns(nArray, null);
    }

    @Override
    public void setGroupColumns(int[] nArray, int[] nArray2) {
        this.clearGroupColumns();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray2 != null && i < nArray2.length ? nArray2[i] : 1;
                this._groupColumns.add(new GroupColumn(nArray[i], n));
            }
            this.firePropertyChange(PROPERTY_GROUPED_COLUMNS, null, nArray);
        }
    }

    public void clearGroupColumns() {
        this.ensureGroupColumnsCreated();
        int[] nArray = new int[this._groupColumns.size()];
        for (int i = 0; i < this._groupColumns.size(); ++i) {
            GroupColumn groupColumn = this._groupColumns.get(i);
            nArray[i] = groupColumn._columnIndex;
        }
        this._groupColumns.clear();
        this.firePropertyChange(PROPERTY_GROUPED_COLUMNS, nArray, null);
    }

    @Override
    public String getColumnName(int n) {
        if (this.hasGroupColumns() && this.isDisplayCountColumn() && n == 0) {
            return this.getCountColumnName();
        }
        if (this.hasGroupColumns()) {
            int n2 = this.getActualColumnAt(n);
            if (n2 < 0 && this.isDisplaySeparateGroupColumn()) {
                return this.getSeparateGroupColumnName();
            }
            return this._tableModel.getColumnName(n2);
        }
        return this._tableModel.getColumnName(n);
    }

    @Override
    public Object getColumnIdentifier(int n) {
        if (this.hasGroupColumns() && this.isDisplayCountColumn() && n == 0) {
            return "GROUP_COUNT:::HEADER";
        }
        if (this.hasGroupColumns()) {
            if (this._tableModel instanceof ColumnIdentifierTableModel) {
                int n2 = this.getActualColumnAt(n);
                if (n2 != -1) {
                    return ((ColumnIdentifierTableModel)((Object)this._tableModel)).getColumnIdentifier(n2);
                }
                return "GROUP_COLUMN:::HEADER";
            }
            int n3 = this.getActualColumnAt(n);
            if (n3 != -1) {
                return this._tableModel.getColumnName(n3);
            }
            if (this.isDisplaySeparateGroupColumn()) {
                return "GROUP_COLUMN:::HEADER";
            }
        } else {
            if (this._tableModel instanceof ColumnIdentifierTableModel) {
                return ((ColumnIdentifierTableModel)((Object)this._tableModel)).getColumnIdentifier(n);
            }
            return this._tableModel.getColumnName(n);
        }
        return null;
    }

    @Override
    public Object getGroupColumnIdentifier(int n) {
        int n2 = this.getGroupColumnAt(n);
        if (this._tableModel instanceof ColumnIdentifierTableModel) {
            return ((ColumnIdentifierTableModel)((Object)this._tableModel)).getColumnIdentifier(n2) + ":::HEADER";
        }
        return this._tableModel.getColumnName(n2) + ":::HEADER";
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        int n3;
        EditorContext editorContext = null;
        if (this.hasGroupColumns()) {
            editorContext = super.getEditorContextAt(n, n2);
        }
        if (editorContext == null && this._tableModel instanceof ContextSensitiveTableModel && (n3 = this.getActualColumnAt(n2)) >= 0) {
            editorContext = ((ContextSensitiveTableModel)this._tableModel).getEditorContextAt(n, n3);
        }
        return editorContext;
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        int n3;
        ConverterContext converterContext = null;
        if (this.hasGroupColumns()) {
            converterContext = super.getConverterContextAt(n, n2);
        }
        if (converterContext == null && this._tableModel instanceof ContextSensitiveTableModel && (n3 = this.getActualColumnAt(n2)) >= 0) {
            converterContext = ((ContextSensitiveTableModel)this._tableModel).getConverterContextAt(n, n3);
        }
        return converterContext;
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        if (this.hasGroupColumns()) {
            Row row = this.getRowAt(n);
            if (row instanceof DefaultGroupRow) {
                if (this.isDisplayCountColumn() && n2 == 0) {
                    return this.getColumnClass(n2);
                }
                if (!this.isDisplayGroupColumns() && !this.isSummaryMode()) {
                    return DefaultGroupRow.class;
                }
            }
            if (row == null) {
                return this.getColumnClass(n2);
            }
            return row.getCellClassAt(n2);
        }
        if (this._tableModel instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)this._tableModel).getCellClassAt(n, n2);
        }
        return this.getColumnClass(n2);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (this.hasGroupColumns() && this.isDisplayCountColumn() && n == 0) {
            return Integer.class;
        }
        if (this.hasGroupColumns()) {
            int n2 = this.getActualColumnAt(n);
            if (n2 == -1) {
                if (this.isDisplaySeparateGroupColumn() && n <= 1) {
                    return DefaultGroupRow.class;
                }
                return Object.class;
            }
            return this._tableModel.getColumnClass(n2);
        }
        return this._tableModel.getColumnClass(n);
    }

    @Override
    public int getRowCount() {
        if (this.hasGroupColumns()) {
            return super.getRowCount();
        }
        return this._tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        int n = this._tableModel.getColumnCount();
        if (this.hasGroupColumns()) {
            if (this.isDisplayCountColumn()) {
                ++n;
            }
            if (!this.isKeepColumnOrder() && !this.isDisplayGroupColumns()) {
                n -= this._groupColumns.size();
                if (this.isDisplaySeparateGroupColumn()) {
                    ++n;
                }
            }
        }
        return n;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.hasGroupColumns()) {
            return super.isCellEditable(n, n2);
        }
        return this._tableModel.isCellEditable(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.hasGroupColumns()) {
            super.setValueAt(object, n, n2);
        } else {
            this._tableModel.setValueAt(object, n, n2);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.hasGroupColumns()) {
            return super.getValueAt(n, n2);
        }
        return this._tableModel.getValueAt(n, n2);
    }

    public boolean isSingleLevelGrouping() {
        return this._singleLevelGrouping;
    }

    public void setSingleLevelGrouping(boolean bl) {
        this._singleLevelGrouping = bl;
    }

    @Override
    public CellSpan getCellSpanAt(int n, int n2) {
        Row row = this.getRowAt(n);
        if (row instanceof SummaryGroupRow) {
            return null;
        }
        if (!this.isSummaryMode() && row instanceof DefaultGroupRow) {
            if (this.isDisplayGroupColumns()) {
                if (!this.isKeepColumnOrder()) {
                    int n3;
                    int n4 = ((DefaultGroupRow)row).getNumberOfConditions();
                    int n5 = n3 = this.isDisplayCountColumn() ? 1 : 0;
                    if (n2 - n3 >= n4) {
                        return new CellSpan(n, n4 + n3, 1, this.getColumnCount() - n4 - n3);
                    }
                }
            } else {
                if (this.isDisplayCountColumn()) {
                    if (n2 == 0) {
                        return new CellSpan(n, 0, 1, 1);
                    }
                    return new CellSpan(n, 1, 1, this.getColumnCount());
                }
                return new CellSpan(n, 0, 1, this.getColumnCount());
            }
        }
        return null;
    }

    public DefaultGroupRow findGroupRow(Expandable expandable, TableModel tableModel, int n) {
        for (int i = 0; i < expandable.getChildrenCount(); ++i) {
            DefaultGroupRow defaultGroupRow;
            Row row = (Row)expandable.getChildAt(i);
            if (!(row instanceof DefaultGroupRow) || !(defaultGroupRow = (DefaultGroupRow)row).satisfies(tableModel, n)) continue;
            if (defaultGroupRow.getNumberOfConditions() == this._groupColumns.size()) {
                return (DefaultGroupRow)row;
            }
            defaultGroupRow = this.findGroupRow((Expandable)((Object)row), tableModel, n);
            if (defaultGroupRow == null) continue;
            return defaultGroupRow;
        }
        return null;
    }

    private DefaultGroupRow findGroupRowSorted(Expandable expandable, TableModel tableModel, int n) {
        DefaultGroupRow defaultGroupRow;
        Row row = (Row)expandable.getChildAt(expandable.getChildrenCount() - 1);
        if (row instanceof DefaultGroupRow && (defaultGroupRow = (DefaultGroupRow)row).satisfies(tableModel, n)) {
            if (defaultGroupRow.getNumberOfConditions() == this._groupColumns.size()) {
                return (DefaultGroupRow)row;
            }
            defaultGroupRow = this.findGroupRowSorted((Expandable)((Object)row), tableModel, n);
            if (defaultGroupRow != null) {
                return defaultGroupRow;
            }
            if (this.isRemoveNullGrouper()) {
                GroupColumn object2;
                int n2;
                for (n2 = ((DefaultGroupRow)row).getNumberOfConditions(); n2 < this._groupColumns.size() && tableModel.getValueAt(n, (object2 = this._groupColumns.get(n2)).getColumnIndex()) == null; ++n2) {
                }
                if (n2 >= this._groupColumns.size()) {
                    return (DefaultGroupRow)row;
                }
            }
        }
        boolean bl = false;
        for (GroupColumn groupColumn : this._groupColumns) {
            if (groupColumn.getColumnSorting() != 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (int i = expandable.getChildrenCount() - 1; i >= 0; --i) {
                Object object = expandable.getChildAt(i);
                if (!(object instanceof DefaultGroupRow) || !((DefaultGroupRow)object).satisfies(tableModel, n)) continue;
                if (((DefaultGroupRow)object).getNumberOfConditions() == this._groupColumns.size()) {
                    return (DefaultGroupRow)object;
                }
                return this.findGroupRowSorted((DefaultGroupRow)object, tableModel, n);
            }
        }
        return null;
    }

    public DefaultGroupRow findGroupRow(Row row, int n) {
        do {
            if (!(row instanceof DefaultGroupRow)) continue;
            int n2 = ((DefaultGroupRow)row).getNumberOfConditions();
            if (!(this.isSingleLevelGrouping() ? n2 >= n : n2 == n)) continue;
            return (DefaultGroupRow)row;
        } while ((row = (Row)((Object)row.getParent())) != null);
        return null;
    }

    int getSimilarRowIndex(Row row) {
        if (row == null) {
            return -1;
        }
        int n = this.getRowIndex(row);
        if (n >= 0) {
            return n;
        }
        if (this.getRoot() instanceof Expandable) {
            Expandable expandable = (Expandable)this.getRoot();
            if (row instanceof DefaultGroupRow) {
                int n2 = ((DefaultGroupRow)row).getNumberOfConditions();
                for (int i = 0; i < n2; ++i) {
                    Object object = ((DefaultGroupRow)row).getConditionValue(i);
                    int n3 = ((DefaultGroupRow)row).getConditionColumn(i);
                    DefaultGroupRow defaultGroupRow = null;
                    for (Object obj : expandable.getChildren()) {
                        if (!(obj instanceof DefaultGroupRow)) continue;
                        if (((DefaultGroupRow)obj).getNumberOfConditions() <= i || ((DefaultGroupRow)obj).getConditionColumn(i) != n3) {
                            return -1;
                        }
                        if (!JideSwingUtilities.equals(((DefaultGroupRow)obj).getConditionValue(i), object)) continue;
                        defaultGroupRow = (DefaultGroupRow)obj;
                        break;
                    }
                    if (defaultGroupRow == null) continue;
                    expandable = defaultGroupRow;
                }
                if (expandable instanceof DefaultGroupRow && ((DefaultGroupRow)expandable).getNumberOfConditions() == n2) {
                    return this.getRowIndex((Row)((Object)expandable));
                }
            } else if (row instanceof IndexReferenceRow) {
                int n4 = ((IndexReferenceRow)row).getRowIndex();
                return this.getVisualRowAt(n4);
            }
        }
        return -1;
    }

    @Override
    public Row getRowAt(int n) {
        return this.getRowAt(n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Row getRowAt(int n, boolean bl) {
        List<Row> list = this._referenceRows;
        synchronized (list) {
            if (this.hasGroupColumns() || bl) {
                return super.getRowAt(n);
            }
            if (n >= 0 && n < this._referenceRows.size() && this._referenceRows.get(n) instanceof IndexReferenceRow && ((IndexReferenceRow)this._referenceRows.get(n)).getRowIndex() == n) {
                return this._referenceRows.get(n);
            }
            for (Row row : this._referenceRows) {
                int n2;
                if (!(row instanceof IndexReferenceRow) || n != (n2 = ((IndexReferenceRow)row).getRowIndex())) continue;
                return row;
            }
            return null;
        }
    }

    @Override
    public int getRowIndex(Row row) {
        if (this.hasGroupColumns()) {
            return super.getRowIndex(row);
        }
        if (row instanceof IndexReferenceRow) {
            return ((IndexReferenceRow)row).getRowIndex();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceRow getReferenceRow(int n) {
        List<Row> list = this._referenceRows;
        synchronized (list) {
            return n >= this._referenceRows.size() || n < 0 ? null : (ReferenceRow)this._referenceRows.get(n);
        }
    }

    @Override
    public boolean isCellSpanOn() {
        return this.hasGroupColumns();
    }

    @Override
    public int getColumnType(int n) {
        int n2 = this.getActualColumnAt(n);
        if (this.getActualModel() instanceof MultiTableModel && n2 >= 0) {
            return ((MultiTableModel)this.getActualModel()).getColumnType(n2);
        }
        return super.getColumnType(n);
    }

    @Override
    public int getTableIndex(int n) {
        int n2 = this.getActualColumnAt(n);
        if (this.getActualModel() instanceof MultiTableModel && n2 >= 0) {
            return ((MultiTableModel)this.getActualModel()).getTableIndex(n2);
        }
        return super.getTableIndex(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tableRowsInserted(int n, int n2) {
        List<Row> list = this._referenceRows;
        synchronized (list) {
            this.updateReference(n, n2 - n + 1);
            for (int i = n2; i >= n; --i) {
                Object object;
                int n3;
                ReferenceRow referenceRow = this.createReferenceRow(this._tableModel, i);
                DefaultGroupRow defaultGroupRow = this.ensureGroupRowCreated(i);
                int n4 = defaultGroupRow.getChildrenCount();
                for (n3 = 0; !(n3 >= n4 || (object = defaultGroupRow.getChildAt(n3)) instanceof IndexReferenceRow && ((IndexReferenceRow)object).getRowIndex() > i); ++n3) {
                }
                defaultGroupRow.addChild(n3, referenceRow);
                if (defaultGroupRow instanceof SummaryGroupRow) {
                    ((SummaryGroupRow)defaultGroupRow).invalidateSummaryCacheToRoot();
                }
                int n5 = defaultGroupRow.getNumberOfConditions();
                this._referenceRows.add(n, referenceRow);
                if (!this.isOriginalRowsHidden() || n5 != this.getGroupColumnCount()) continue;
                defaultGroupRow.setExpandable(false);
                defaultGroupRow.setExpanded(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tableRowsDeleted(int n, int n2) {
        List<Row> list = this._referenceRows;
        synchronized (list) {
            ReferenceRow referenceRow;
            int n3;
            ArrayList<ReferenceRow> arrayList = new ArrayList<ReferenceRow>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (n3 = n; n3 <= n2; ++n3) {
                referenceRow = this.getReferenceRow(n3);
                arrayList.add(referenceRow);
                arrayList2.add(n3);
            }
            this.updateReference(n, -(n2 - n + 1));
            for (n3 = arrayList.size() - 1; n3 >= 0; --n3) {
                referenceRow = (ReferenceRow)arrayList.get(n3);
                if (referenceRow == null || referenceRow.getParent() == null) continue;
                Expandable expandable = referenceRow.getParent();
                if (expandable instanceof SummaryGroupRow) {
                    ((SummaryGroupRow)expandable).invalidateSummaryCacheToRoot();
                }
                expandable.removeChild(referenceRow);
                this._referenceRows.remove((Integer)arrayList2.get(n3));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateReference(int n, int n2) {
        List<Row> list = this._referenceRows;
        synchronized (list) {
            int n3;
            if (n2 == 0) {
                return;
            }
            int n4 = n3 = n2 > 0 ? n : n - n2;
            while (n3 < this._referenceRows.size()) {
                int n5;
                Row row = this._referenceRows.get(n3);
                if (row instanceof IndexReferenceRow && (n5 = ((IndexReferenceRow)row).getRowIndex()) >= n) {
                    ((IndexReferenceRow)row).setRowIndex(n5 + n2);
                }
                ++n3;
            }
        }
    }

    protected void tableRowsUpdated(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            DefaultGroupRow defaultGroupRow;
            ReferenceRow referenceRow = this.getReferenceRow(i);
            if (referenceRow == null) continue;
            Expandable expandable = referenceRow.getParent();
            if (expandable instanceof SummaryGroupRow) {
                ((SummaryGroupRow)expandable).invalidateSummaryCacheToRoot();
            }
            if (expandable instanceof DefaultGroupRow) {
                defaultGroupRow = (DefaultGroupRow)expandable;
                if (defaultGroupRow.satisfies(this._tableModel, i)) {
                    referenceRow.rowUpdated();
                    continue;
                }
                defaultGroupRow.removeChild(referenceRow);
                defaultGroupRow = this.ensureGroupRowCreated(i);
                defaultGroupRow.addChild(referenceRow);
                if (!(defaultGroupRow instanceof SummaryGroupRow)) continue;
                ((SummaryGroupRow)defaultGroupRow).invalidateSummaryCacheToRoot();
                continue;
            }
            if (expandable != this.getRoot() || !this.isRemoveNullGrouper()) continue;
            defaultGroupRow = this.ensureGroupRowCreated(i);
            if (defaultGroupRow == null) {
                referenceRow.rowUpdated();
                continue;
            }
            expandable.removeChild(referenceRow);
            defaultGroupRow.addChild(referenceRow);
            if (!(defaultGroupRow instanceof SummaryGroupRow)) continue;
            ((SummaryGroupRow)defaultGroupRow).invalidateSummaryCacheToRoot();
        }
    }

    protected void tableCellsUpdated(int n, int n2, int n3) {
        if (!this.isColumnGrouped(n)) {
            for (int i = n2; i <= n3; ++i) {
                ReferenceRow referenceRow = this.getReferenceRow(i);
                if (referenceRow == null) continue;
                Expandable expandable = referenceRow.getParent();
                if (expandable instanceof SummaryGroupRow) {
                    ((SummaryGroupRow)expandable).invalidateSummaryCacheToRoot();
                }
                referenceRow.cellUpdated(n);
            }
        } else {
            this.tableRowsUpdated(n2, n3);
        }
    }

    protected void tableStructureChanged() {
        if (!this.isKeepGroupingOnStructureChange()) {
            this.clearGroupColumns();
        }
        this.resetSummaryTypes();
        this.groupAndRefresh(true);
    }

    protected void tableDataChanged() {
        this.groupAndRefresh(false);
    }

    public int[] getColumnMapping() {
        return this._columnMapping;
    }

    @Override
    public TableModel getActualModel() {
        return this._tableModel;
    }

    @Override
    public int getActualRowAt(int n) {
        if (this.isGroupEnabled()) {
            Row row = this.getRowAt(n);
            if (row instanceof IndexReferenceRow) {
                return ((IndexReferenceRow)row).getRowIndex();
            }
            return -1;
        }
        return n;
    }

    @Override
    public int getVisualRowAt(int n) {
        if (this.isGroupEnabled()) {
            ReferenceRow referenceRow = this.getReferenceRow(n);
            if (referenceRow != null) {
                return this.getRowIndex(referenceRow);
            }
            return -1;
        }
        return n;
    }

    @Override
    public int getActualColumnAt(int n) {
        if (this.getColumnMapping() == null || !this.hasGroupColumns()) {
            return n;
        }
        if (n >= 0 && n < this.getColumnMapping().length) {
            return this.getColumnMapping()[n] < 0 ? -1 : this.getColumnMapping()[n];
        }
        return -1;
    }

    @Override
    public int getVisualColumnAt(int n) {
        if (this.getColumnMapping() == null) {
            return n;
        }
        for (int i = 0; i < this.getColumnMapping().length; ++i) {
            int n2 = this.getColumnMapping()[i];
            if (n != n2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isDisplayGroupColumns() {
        return this._displayGroupColumns;
    }

    @Override
    public boolean groupColumnsFirst() {
        return false;
    }

    public void setDisplayGroupColumns(boolean bl) {
        if (this._displayGroupColumns != bl) {
            this._displayGroupColumns = bl;
            this._propertyChanged = true;
        }
    }

    public boolean isDisplaySeparateGroupColumn() {
        return !this.isSummaryMode() && !this.isKeepColumnOrder() && !this.isDisplayGroupColumns() && this._displaySeparateGroupColumn;
    }

    public void setDisplaySeparateGroupColumn(boolean bl) {
        this._displaySeparateGroupColumn = bl;
    }

    public boolean isFirstColumn(int n) {
        return n == 0;
    }

    public boolean isDisplayGroupValueOnFirstColumn() {
        return !this.isDisplayGroupColumns() && !this.isDisplaySeparateGroupColumn() && this._displayGroupValueOnFirstColumn;
    }

    public void setDisplayGroupValueOnFirstColumn(boolean bl) {
        this._displayGroupValueOnFirstColumn = bl;
    }

    protected String getCountColumnName() {
        return "Count";
    }

    protected String getSeparateGroupColumnName() {
        return "Grouped Columns";
    }

    public boolean isDisplayCountColumn() {
        return this._displayCountColumn;
    }

    public void setDisplayCountColumn(boolean bl) {
        if (this._displayCountColumn != bl) {
            this._displayCountColumn = bl;
            this._propertyChanged = true;
        }
    }

    @Override
    public void expandRow(ExpandableRow expandableRow, boolean bl) {
        if (this.hasGroupColumns()) {
            super.expandRow(expandableRow, bl);
        }
    }

    @Override
    public void expandAll() {
        this.expandAll(true);
    }

    protected void expandAll(boolean bl) {
        if (this.hasGroupColumns()) {
            this.expandAll(this.getRows(), true, true, bl);
        }
    }

    @Override
    public void expandFirstLevel() {
        if (this.hasGroupColumns()) {
            super.expandFirstLevel();
        }
    }

    @Override
    public void collapseAll() {
        if (this.hasGroupColumns()) {
            super.collapseAll();
        }
    }

    @Override
    public void collapseFirstLevel() {
        if (this.hasGroupColumns()) {
            super.collapseFirstLevel();
        }
    }

    public void expandGroupColumn(int n) {
        if (!(this.getRoot() instanceof Row) || n < 0 || n >= this.getGroupColumnCount()) {
            return;
        }
        boolean bl = this.expandGroupColumn((Row)this.getRoot(), n, true);
        if (bl) {
            this.refresh(true, true);
        }
    }

    public void collapseGroupColumn(int n) {
        if (!(this.getRoot() instanceof Row) || n < 0 || n >= this.getGroupColumnCount()) {
            return;
        }
        boolean bl = this.expandGroupColumn((Row)this.getRoot(), n, false);
        if (bl) {
            this.refresh(true, true);
        }
    }

    private boolean expandGroupColumn(Row row, int n, boolean bl) {
        List<?> list;
        int n2;
        if (row instanceof DefaultGroupRow) {
            n2 = ((DefaultGroupRow)row).getNumberOfConditions();
            if (n2 == n + 1) {
                if (((DefaultGroupRow)row).isExpandable() && bl != ((DefaultGroupRow)row).isExpanded()) {
                    ((DefaultGroupRow)row).setExpanded(bl);
                    return true;
                }
                return false;
            }
            if (n2 > n + 1) {
                return false;
            }
        }
        n2 = 0;
        if (row instanceof Expandable && (list = ((Expandable)((Object)row)).getChildren()) != null) {
            for (Object obj : list) {
                boolean bl2;
                if (!(obj instanceof Row) || !(bl2 = this.expandGroupColumn((Row)obj, n, bl))) continue;
                n2 = 1;
            }
        }
        return n2 != 0;
    }

    private void sortExistingGroupRows(DefaultGroupRow[] defaultGroupRowArray, DefaultGroupRow[] defaultGroupRowArray2, int n, int n2) {
        this.shuttleSortExistingGroupRows(defaultGroupRowArray, defaultGroupRowArray2, n, n2);
    }

    private void shuttleSortExistingGroupRows(DefaultGroupRow[] defaultGroupRowArray, DefaultGroupRow[] defaultGroupRowArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttleSortExistingGroupRows(defaultGroupRowArray2, defaultGroupRowArray, n, n3);
        this.shuttleSortExistingGroupRows(defaultGroupRowArray2, defaultGroupRowArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compareGroupRows(defaultGroupRowArray[n3 - 1], defaultGroupRowArray[n3]) <= 0) {
            System.arraycopy(defaultGroupRowArray, n, defaultGroupRowArray2, n, n2 - n);
            return;
        }
        for (int i = n; i < n2; ++i) {
            if (n5 >= n2 || n4 < n3 && this.compareGroupRows(defaultGroupRowArray[n4], defaultGroupRowArray[n5]) <= 0) {
                defaultGroupRowArray2[i] = defaultGroupRowArray[n4];
                ++n4;
                continue;
            }
            defaultGroupRowArray2[i] = defaultGroupRowArray[n5];
            ++n5;
        }
    }

    protected int compareGroupRows(DefaultGroupRow defaultGroupRow, DefaultGroupRow defaultGroupRow2) {
        int n = defaultGroupRow.getNumberOfConditions();
        int n2 = defaultGroupRow2.getNumberOfConditions();
        for (int i = 0; i < Math.min(n, n2); ++i) {
            int n3;
            Object object;
            Object object2 = defaultGroupRow.getConditionValue(i);
            int n4 = this.compare(object2, object = defaultGroupRow2.getConditionValue(i), n3 = defaultGroupRow.getConditionColumn(i));
            if (n4 == 0) continue;
            if (i < this.getGroupColumnCount() && this.getGroupColumnOrder(i) == -1) {
                n4 = -n4;
            }
            return n4;
        }
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    protected void sort(int[] nArray, int[] nArray2, int n, int n2) {
        this.shuttleSort(nArray, nArray2, n, n2);
    }

    private void shuttleSort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttleSort(nArray2, nArray, n, n3);
        this.shuttleSort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            System.arraycopy(nArray, n, nArray2, n, n2 - n);
            return;
        }
        for (int i = n; i < n2; ++i) {
            if (n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0) {
                nArray2[i] = nArray[n4];
                ++n4;
                continue;
            }
            nArray2[i] = nArray[n5];
            ++n5;
        }
    }

    protected int compare(int n, int n2) {
        for (GroupColumn groupColumn : this._groupColumns) {
            int n3;
            int n4 = groupColumn.getColumnIndex();
            int n5 = groupColumn.getColumnSorting();
            ObjectGrouper objectGrouper = this._groupableTableModel == null ? null : ObjectGrouperManager.getGrouper(this._groupableTableModel.getColumnClass(n4), this._groupableTableModel.getGrouperContext(n4));
            Object object = this._tableModel.getValueAt(n, n4);
            if (objectGrouper != null) {
                object = objectGrouper.getValue(object);
            }
            Object object2 = this._tableModel.getValueAt(n2, n4);
            if (objectGrouper != null) {
                object2 = objectGrouper.getValue(object2);
            }
            if ((n3 = n5 != 0 ? this.compare(object, object2, n4) : 0) == 0) continue;
            if (n3 == Integer.MAX_VALUE || n3 == Integer.MIN_VALUE) {
                return n3;
            }
            return n5 == 1 ? n3 : -n3;
        }
        return 0;
    }

    protected int compare(Object object, Object object2, int n) {
        try {
            if (this.isAlwaysUseComparators() && this._cachedComparators != null && n < this._cachedComparators.length && this._cachedComparators[n] != null) {
                return this._cachedComparators[n].compare(object, object2);
            }
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof String && object2 instanceof String) {
                return ((String)object).compareTo((String)object2);
            }
            if (object instanceof Comparable && object2 instanceof Comparable && object.getClass().isAssignableFrom(object2.getClass())) {
                return ((Comparable)object).compareTo(object2);
            }
            if (object instanceof Comparable && object2 instanceof Comparable && object2.getClass().isAssignableFrom(object.getClass())) {
                return ((Comparable)object2).compareTo(object);
            }
            if (this._cachedComparators != null && n < this._cachedComparators.length && this._cachedComparators[n] != null) {
                return this._cachedComparators[n].compare(object, object2);
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected void cacheComparators() {
        this._cachedComparators = new Comparator[this._tableModel.getColumnCount()];
        for (GroupColumn groupColumn : this._groupColumns) {
            int n = groupColumn.getColumnIndex();
            if (n < 0 || n >= this._tableModel.getColumnCount()) continue;
            Comparator comparator = this.getComparator(n);
            if (comparator == null) {
                this._cachedComparators[n] = ObjectComparatorManager.getComparator(String.class);
                continue;
            }
            this._cachedComparators[n] = comparator;
        }
    }

    public Comparator getComparator(int n) {
        ObjectGrouper objectGrouper;
        ObjectGrouper objectGrouper2 = objectGrouper = this._groupableTableModel == null ? null : ObjectGrouperManager.getGrouper(this._groupableTableModel.getColumnClass(n), this._groupableTableModel.getGrouperContext(n));
        if (objectGrouper != null) {
            return ObjectComparatorManager.getComparator(objectGrouper.getType(), objectGrouper.getComparatorContext());
        }
        return ObjectComparatorManager.getComparator(this._tableModel.getColumnClass(n), this.getColumnComparatorContext(n));
    }

    protected ComparatorContext getColumnComparatorContext(int n) {
        ColumnComparatorContextProvider columnComparatorContextProvider = this.getColumnComparatorContextProvider();
        if (columnComparatorContextProvider == null) {
            return null;
        }
        return columnComparatorContextProvider.getColumnComparatorContext(this.getActualModel(), n);
    }

    public boolean isRemoveNullGrouper() {
        return this._removeNullGrouper;
    }

    public void setRemoveNullGrouper(boolean bl) {
        if (this._removeNullGrouper != bl) {
            this._removeNullGrouper = bl;
            this.groupAndRefresh();
        }
    }

    public boolean isDisplayGroupRowsFirst() {
        return this._displayGroupRowsFirst;
    }

    public void setDisplayGroupRowsFirst(boolean bl) {
        this._displayGroupRowsFirst = bl;
    }

    public ColumnComparatorContextProvider getColumnComparatorContextProvider() {
        return this._columnComparatorContextProvider;
    }

    public void setColumnComparatorContextProvider(ColumnComparatorContextProvider columnComparatorContextProvider) {
        this._columnComparatorContextProvider = columnComparatorContextProvider;
        if (this._columnComparatorContextProvider != null) {
            this.setAlwaysUseComparators(true);
        }
    }

    public boolean isAlwaysUseComparators() {
        return this._alwaysUseComparators;
    }

    public void setAlwaysUseComparators(boolean bl) {
        this._alwaysUseComparators = bl;
    }

    @Override
    public Map<Object, Boolean> getExpansionState() {
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        List list = this.getRows();
        for (Object t : list) {
            if (!(t instanceof DefaultGroupRow) || !((DefaultGroupRow)t).isExpanded()) continue;
            hashMap.put(ObjectConverterManager.toString(t, DefaultGroupRow.class), true);
        }
        return hashMap;
    }

    @Override
    public void setExpansionState(Map map) {
        if (map == null) {
            return;
        }
        List list = this.getRows();
        this.collapseAll(list, false, true, false);
        this.setExpansionState(map, list);
        this.refresh();
    }

    private void setExpansionState(Map map, List list) {
        for (Object e : list) {
            Object v;
            if (!(e instanceof DefaultGroupRow) || !((v = map.get(ObjectConverterManager.toString(e, DefaultGroupRow.class))) instanceof Boolean) || !((Boolean)v).booleanValue()) continue;
            ((DefaultGroupRow)e).setExpanded(true);
            this.setExpansionState(map, ((DefaultGroupRow)e).getChildren());
        }
    }

    @Override
    public int getEditorStyleAt(int n, int n2) {
        if (this.getActualModel() instanceof EditorStyleTableModel) {
            return ((EditorStyleTableModel)((Object)this.getActualModel())).getEditorStyleAt(this.getActualRowAt(n), this.getActualColumnAt(n2));
        }
        return 0;
    }

    @Deprecated
    public boolean isAscendingGroupOrder() {
        return this._ascendingGroupOrder;
    }

    @Deprecated
    public void setAscendingGroupOrder(boolean bl) {
        if (bl != this._ascendingGroupOrder) {
            this._ascendingGroupOrder = bl;
            this.tableDataChanged();
        }
    }

    boolean isTableModelAdjusting() {
        return this._tableModelAdjusting;
    }

    void setTableModelAdjusting(boolean bl) {
        this._tableModelAdjusting = bl;
    }

    public boolean isKeepPreviousExpandStatus() {
        return this._keepPreviousExpandStatus;
    }

    public void setKeepPreviousExpandStatus(boolean bl) {
        this._keepPreviousExpandStatus = bl;
    }

    public boolean isKeepGroupingOnStructureChange() {
        return this._keepGroupingOnStructureChange;
    }

    public void setKeepGroupingOnStructureChange(boolean bl) {
        this._keepGroupingOnStructureChange = bl;
    }

    public boolean isSummaryMode() {
        return this._summaryMode;
    }

    public void setSummaryMode(boolean bl) {
        this._summaryMode = bl;
    }

    @Override
    public int getSummaryTypeAt(int n) {
        if (this._summaryTypes == null) {
            this.resetSummaryTypes();
        }
        if (n >= this._summaryTypes.length || n < 0) {
            return -2;
        }
        if (n == 0 && this.isDisplayGroupValueOnFirstColumn() && !this.isDisplayCountColumn()) {
            return -2;
        }
        return this._summaryTypes[n];
    }

    private void resetSummaryTypes() {
        this._summaryTypes = new int[this.getActualModel().getColumnCount()];
        Arrays.fill(this._summaryTypes, -2);
    }

    public void setSummaryType(int n, int n2) {
        boolean bl = false;
        if (this._summaryTypes == null) {
            bl = true;
            this.resetSummaryTypes();
        }
        if (n >= 0 && n < this._summaryTypes.length && this._summaryTypes[n] != n2) {
            bl = true;
            this._summaryTypes[n] = n2;
        }
        if (bl) {
            if (this.getRoot() instanceof RootExpandableRow) {
                ((RootExpandableRow)this.getRoot()).invalidateSummaryCache();
            }
            CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(this);
            compoundTableModelEvent.addEvent(new TableModelEvent(this));
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
        }
    }

    @Override
    public CellStyle getCellStyleAt(int n, int n2) {
        Row row = this.getRowAt(n);
        CellStyle cellStyle = this.getCellStyleFromRowCellStyleProvider(n, n2);
        if (cellStyle != null) {
            return cellStyle;
        }
        if (row instanceof IndexReferenceRow) {
            int n3 = this.getActualRowAt(n);
            int n4 = this.getActualColumnAt(n2);
            if (this.getActualModel() instanceof StyleModel) {
                return ((StyleModel)((Object)this.getActualModel())).getCellStyleAt(n3, n4);
            }
        }
        return null;
    }

    @Override
    public boolean isCellStyleOn() {
        return true;
    }

    public boolean isOriginalRowsHidden() {
        return this._originalRowsHidden;
    }

    public void setOriginalRowsHidden(boolean bl) {
        this._originalRowsHidden = bl;
    }

    public SummaryCalculator getSummaryCalculator() {
        if (this._summaryCalculator != null) {
            return this._summaryCalculator;
        }
        return new DefaultGroupTableSummaryCalculator();
    }

    public void setSummaryCalculator(SummaryCalculator summaryCalculator) {
        this._summaryCalculator = summaryCalculator;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected synchronized void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected synchronized void firePropertyChange(String string, boolean bl, boolean bl2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    protected synchronized void firePropertyChange(String string, int n, int n2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, n, n2);
    }

    private class GroupColumn {
        private int _columnIndex;
        private int _columnSorting;

        public GroupColumn(int n, int n2) {
            this._columnIndex = n;
            this._columnSorting = n2;
        }

        public int getColumnIndex() {
            return this._columnIndex;
        }

        public int getColumnSorting() {
            return this._columnSorting;
        }
    }

    public static interface ColumnComparatorContextProvider {
        public ComparatorContext getColumnComparatorContext(TableModel var1, int var2);
    }
}

