/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.ColumnTableModelWrapper;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DefaultWrappedRow;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.WrappedRootExpandableRow;
import com.jidesoft.grid.WrappedRow;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DefaultColumnTableModelWrapper
extends AbstractTableModel
implements ColumnTableModelWrapper,
ContextSensitiveTableModel,
StyleModel,
SpanModel,
MultiTableModel,
TableModelListener,
ColumnIdentifierTableModel,
ITreeTableModel {
    private static final long serialVersionUID = 2752858268342182484L;
    protected TableModel _model;
    protected int[] _indexes;
    private TableModelEvent _originalEvent;

    public DefaultColumnTableModelWrapper(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("model passed to DefaultColumnTableModelWrapper cannot be null");
        }
        this._model = tableModel;
        this._model.addTableModelListener(this);
    }

    @Override
    public TableModel getActualModel() {
        return this._model;
    }

    @Override
    public int getActualColumnAt(int n) {
        if (n < 0 || n >= this._indexes.length) {
            return -1;
        }
        return this._indexes[n];
    }

    @Override
    public int getVisualColumnAt(int n) {
        for (int i = 0; i < this._indexes.length; ++i) {
            int n2 = this._indexes[i];
            if (n2 != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = this.getActualColumnAt(n2);
        return n3 >= 0 ? this._model.getValueAt(n, n3) : null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3 = this.getActualColumnAt(n2);
        if (n3 >= 0) {
            this._model.setValueAt(object, n, n3);
        }
    }

    @Override
    public int getRowCount() {
        return this._model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this._indexes.length;
    }

    @Override
    public String getColumnName(int n) {
        int n2 = this.getActualColumnAt(n);
        return n2 >= 0 ? this._model.getColumnName(n2) : "" + n;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        int n2 = this.getActualColumnAt(n);
        return n2 >= 0 ? this._model.getColumnClass(n2) : Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        int n3 = this.getActualColumnAt(n2);
        return n3 >= 0 && this._model.isCellEditable(n, n3);
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        int n3 = this.getActualColumnAt(n2);
        if (this._model instanceof ContextSensitiveTableModel && n3 >= 0) {
            return ((ContextSensitiveTableModel)this._model).getConverterContextAt(n, n3);
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        int n3 = this.getActualColumnAt(n2);
        if (this._model instanceof ContextSensitiveTableModel && n2 >= 0) {
            return ((ContextSensitiveTableModel)this._model).getEditorContextAt(n, n3);
        }
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        int n3 = this.getActualColumnAt(n2);
        if (this._model instanceof ContextSensitiveTableModel && n3 >= 0) {
            return ((ContextSensitiveTableModel)this._model).getCellClassAt(n, n3);
        }
        return this.getColumnClass(n2);
    }

    @Override
    public Object getColumnIdentifier(int n) {
        int n2 = this.getActualColumnAt(n);
        if (this._model instanceof ColumnIdentifierTableModel && n2 >= 0) {
            return ((ColumnIdentifierTableModel)((Object)this._model)).getColumnIdentifier(n2);
        }
        return null;
    }

    protected void reallocateIndexes() {
        int n = this._model.getColumnCount();
        this._indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this._indexes[i] = i;
        }
    }

    public int[] getIndexes() {
        return this._indexes;
    }

    public void setIndexes(int[] nArray) {
        this._indexes = nArray;
    }

    @Override
    public CellStyle getCellStyleAt(int n, int n2) {
        int n3 = this.getActualColumnAt(n2);
        if (this._model instanceof StyleModel && n2 >= 0) {
            return ((StyleModel)((Object)this._model)).getCellStyleAt(n, n3);
        }
        return null;
    }

    @Override
    public boolean isCellStyleOn() {
        return this._model instanceof StyleModel && ((StyleModel)((Object)this._model)).isCellStyleOn();
    }

    @Override
    public CellSpan getCellSpanAt(int n, int n2) {
        int n3 = this.getActualColumnAt(n2);
        if (this._model instanceof SpanModel && n3 >= 0) {
            CellSpan cellSpan = ((SpanModel)((Object)this._model)).getCellSpanAt(n, n3);
            if (cellSpan != null) {
                int n4 = cellSpan.getColumnSpan();
                int n5 = this.getVisualColumnAt(cellSpan.getRow());
                for (int i = 1; i < cellSpan.getColumnSpan(); ++i) {
                    int n6 = this.getVisualColumnAt(cellSpan.getColumn() + i);
                    if (n6 == -1) {
                        --n4;
                        continue;
                    }
                    if (n5 != -1) continue;
                    --n4;
                    n5 = n6;
                }
                if (n4 <= 0) {
                    return null;
                }
                cellSpan.setColumnSpan(n4);
                cellSpan.setColumn(n5);
            }
            return cellSpan;
        }
        return null;
    }

    @Override
    public boolean isCellSpanOn() {
        return this._model instanceof SpanModel && ((SpanModel)((Object)this._model)).isCellSpanOn();
    }

    @Override
    public int getColumnType(int n) {
        int n2 = this.getActualColumnAt(n);
        if (this.getActualModel() instanceof MultiTableModel && n2 >= 0) {
            return ((MultiTableModel)this.getActualModel()).getColumnType(n2);
        }
        return 0;
    }

    @Override
    public int getTableIndex(int n) {
        int n2 = this.getActualColumnAt(n);
        if (this.getActualModel() instanceof MultiTableModel && n2 >= 0) {
            return ((MultiTableModel)this.getActualModel()).getTableIndex(n2);
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this._originalEvent = tableModelEvent instanceof CompoundTableModelEvent ? ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent() : tableModelEvent;
        try {
            switch (tableModelEvent.getType()) {
                case 1: {
                    this.tableRowsInserted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    return;
                }
                case -1: {
                    this.tableRowsDeleted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    return;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() == -1) {
                        this.tableStructureChanged();
                        return;
                    } else if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        if (tableModelEvent instanceof CompoundTableModelEvent) {
                            this.tableDataChanged((CompoundTableModelEvent)tableModelEvent);
                            return;
                        } else {
                            this.tableDataChanged();
                            return;
                        }
                    } else if (tableModelEvent.getColumn() == -1) {
                        this.tableRowsUpdated(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        return;
                    } else {
                        this.tableCellsUpdated(tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        finally {
            this._originalEvent = null;
        }
    }

    protected void tableRowsInserted(int n, int n2) {
        this.fireTableRowsInserted(n, n2);
    }

    protected void tableRowsDeleted(int n, int n2) {
        this.fireTableRowsDeleted(n, n2);
    }

    protected void tableRowsUpdated(int n, int n2) {
        this.fireTableRowsUpdated(n, n2);
    }

    public void fireTableCellsUpdated(int n, int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, n3));
    }

    protected void tableCellsUpdated(int n, int n2, int n3) {
        this.fireTableCellsUpdated(n2, n3, this.getVisualColumnAt(n));
    }

    protected void tableDataChanged(CompoundTableModelEvent compoundTableModelEvent) {
        if (compoundTableModelEvent == null || compoundTableModelEvent.getEvents() == null || compoundTableModelEvent.getEvents().length <= 0) {
            this.tableDataChanged();
            return;
        }
        CompoundTableModelEvent compoundTableModelEvent2 = this.createCompoundTableModelEvent();
        block5: for (TableModelEvent tableModelEvent : compoundTableModelEvent.getEvents()) {
            switch (tableModelEvent.getType()) {
                case 1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, 1));
                    continue block5;
                }
                case -1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, -1));
                    continue block5;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() == -1) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, -1));
                        continue block5;
                    }
                    if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this));
                        continue block5;
                    }
                    if (tableModelEvent.getColumn() == -1) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, 0));
                        continue block5;
                    }
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), 0));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Embedded TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent2);
    }

    protected CompoundTableModelEvent createCompoundTableModelEvent() {
        CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(this);
        compoundTableModelEvent.setOriginalEvent(this._originalEvent);
        return compoundTableModelEvent;
    }

    protected void tableDataChanged() {
        this.fireTableDataChanged();
    }

    protected void tableStructureChanged() {
        this.fireTableStructureChanged();
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            super.fireTableChanged(tableModelEvent);
        } else {
            CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
            compoundTableModelEvent.addEvent(tableModelEvent);
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
        }
    }

    @Override
    public Row getRowAt(int n) {
        Row row;
        Row row2 = row = this._model instanceof ITreeTableModel ? ((ITreeTableModel)((Object)this._model)).getRowAt(n) : null;
        if (!(row instanceof ExpandableRow)) {
            return null;
        }
        return this.createWrappedRow((ExpandableRow)row);
    }

    protected Row createWrappedRow(ExpandableRow expandableRow) {
        return new DefaultWrappedRow(this, expandableRow);
    }

    public int getRowIndex(Row row) {
        if (row instanceof WrappedRow) {
            row = ((WrappedRow)((Object)row)).getOriginalRow();
        }
        return this._model instanceof ITreeTableModel ? ((ITreeTableModel)((Object)this._model)).getRowIndex(row) : -1;
    }

    @Override
    public Object getRoot() {
        Object object;
        Object object2 = object = this._model instanceof ITreeTableModel ? ((ITreeTableModel)((Object)this._model)).getRoot() : null;
        if (object instanceof RootExpandableRow) {
            object = new WrappedRootExpandableRow(this, (RootExpandableRow)object);
        }
        return object;
    }
}

