/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.DateExComboBox;
import com.jidesoft.combobox.DateModel;
import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.ExComboBoxCellEditor;
import com.jidesoft.validation.ValidationResult;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DateCellEditor
extends ExComboBoxCellEditor {
    public static final EditorContext DATETIME_CONTEXT = new EditorContext("DateTime");
    private static final long serialVersionUID = 8744449229325567818L;
    private boolean _timeDisplayed = false;
    public static final int TYPE_UTIL_CALENDAR = 0;
    public static final int TYPE_UTIL_DATE = 1;
    public static final int TYPE_SQL_DATE = 2;
    public static final int TYPE_SQL_TIME = 3;
    public static final int TYPE_SQL_TIMESTAMP = 4;
    private int _dataType = 0;

    public DateCellEditor() {
        this(false);
    }

    public DateCellEditor(boolean bl) {
        this._dataType = bl ? 1 : 0;
    }

    public DateCellEditor(DateModel dateModel) {
        ((DateExComboBox)this.getComboBox()).setDateModel(dateModel);
    }

    public DateCellEditor(DateModel dateModel, boolean bl) {
        this._dataType = bl ? 1 : 0;
        ((DateExComboBox)this.getComboBox()).setDateModel(dateModel);
    }

    @Override
    public ExComboBox createExComboBox() {
        return this.createDateComboBox();
    }

    protected DateExComboBox createDateComboBox() {
        DateExComboBox dateExComboBox = new DateExComboBox();
        dateExComboBox.setEditable(true);
        dateExComboBox.setTimeDisplayed(this.isTimeDisplayed());
        return dateExComboBox;
    }

    public int getDataType() {
        return this._dataType;
    }

    public void setDataType(int n) {
        this._dataType = n;
    }

    @Override
    public Object getCellEditorValue() {
        Object object = this._comboBox.getEditor().getItem();
        switch (this.getDataType()) {
            case 1: {
                if (object instanceof Calendar) {
                    return ((Calendar)object).getTime();
                }
                if (!(object instanceof Date)) break;
                return object;
            }
            case 3: {
                if (object instanceof Time) {
                    return object;
                }
                if (object instanceof java.sql.Date) {
                    return new Time(((Date)object).getTime());
                }
                if (object instanceof Calendar) {
                    return new Time(((Calendar)object).getTimeInMillis());
                }
                if (!(object instanceof Date)) break;
                return new Time(((Date)object).getTime());
            }
            case 4: {
                if (object instanceof Timestamp) {
                    return object;
                }
                if (object instanceof java.sql.Date) {
                    return new Timestamp(((Date)object).getTime());
                }
                if (object instanceof Calendar) {
                    return new Timestamp(((Calendar)object).getTimeInMillis());
                }
                if (!(object instanceof Date)) break;
                return new Timestamp(((Date)object).getTime());
            }
            case 2: {
                if (object instanceof java.sql.Date) {
                    return object;
                }
                if (object instanceof Time) {
                    return new java.sql.Date(((Date)object).getTime());
                }
                if (object instanceof Calendar) {
                    return new java.sql.Date(((Calendar)object).getTimeInMillis());
                }
                if (!(object instanceof Date)) break;
                return new java.sql.Date(((Date)object).getTime());
            }
            default: {
                if (object instanceof Calendar) {
                    return object;
                }
                if (!(object instanceof Date)) break;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)object);
                return calendar;
            }
        }
        return null;
    }

    @Override
    public void setCellEditorValue(Object object) {
        if (object instanceof java.sql.Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            this._comboBox.setSelectedItem(calendar);
            this._dataType = 2;
        } else if (object instanceof Time) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            this._comboBox.setSelectedItem(calendar);
            this._dataType = 3;
        } else if (object instanceof Timestamp) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            this._comboBox.setSelectedItem(calendar);
            this._dataType = 4;
        } else if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            this._comboBox.setSelectedItem(calendar);
            this._dataType = 1;
        } else if (object instanceof Calendar) {
            this._comboBox.setSelectedItem(object);
            this._dataType = 0;
        } else {
            this._comboBox.setSelectedItem(object);
        }
    }

    @Override
    public ValidationResult validate(Object object, Object object2) {
        if (object2 instanceof Calendar) {
            if (((DateExComboBox)this._comboBox).getDateModel().isValidDate((Calendar)object2)) {
                return super.validate(object, object2);
            }
        } else if (object2 instanceof Date) {
            Calendar calendar = ((DateExComboBox)this._comboBox).createCalendarInstance();
            calendar.setTime((Date)object2);
            if (((DateExComboBox)this._comboBox).getDateModel().isValidDate(calendar)) {
                return super.validate(object, object2);
            }
        } else if (object2 == null) {
            return super.validate(object, object2);
        }
        return new ValidationResult(0, false, this.getDefaultErrorBehavior(), "Date is invalid");
    }

    public boolean isTimeDisplayed() {
        return this._timeDisplayed;
    }

    public void setTimeDisplayed(boolean bl) {
        this._timeDisplayed = bl;
        if (this._comboBox != null) {
            ((DateExComboBox)this._comboBox).setTimeDisplayed(this._timeDisplayed);
        }
    }
}

