/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.BooleanCheckBoxCellRenderer;
import com.jidesoft.grid.ColorCellRenderer;
import com.jidesoft.grid.ContextSensitiveCellRenderer;
import com.jidesoft.grid.DynamicValueCellRenderer;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.FontNameCellEditor;
import com.jidesoft.grid.IconCellRenderer;
import com.jidesoft.grid.MultilineStringCellRenderer;
import com.jidesoft.grid.MultilineTableCellRenderer;
import com.jidesoft.grid.NumberCellRenderer;
import com.jidesoft.grid.PasswordCellRenderer;
import com.jidesoft.grid.TristateCheckBoxCellRenderer;
import com.jidesoft.grid.VerticalContextSensitiveCellRenderer;
import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.utils.CacheMap;
import com.jidesoft.utils.RegistrationListener;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class CellRendererManager {
    private static CacheMap<Object, EditorContext> _cache = new CacheMap(EditorContext.DEFAULT_CONTEXT);
    private static TableCellRenderer _defaultCellRenderer = new DefaultTableCellRenderer();
    private static boolean _inited = false;
    private static boolean _initing = false;
    private static boolean _autoInit = true;
    private static List<CellRendererCustomizer> _cellRendererCustomizers = new Vector<CellRendererCustomizer>();

    public static void registerRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        CellRendererManager.registerRenderer(clazz, tableCellRenderer, EditorContext.DEFAULT_CONTEXT);
    }

    public static void registerRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer, EditorContext editorContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        if (editorContext == null) {
            editorContext = EditorContext.DEFAULT_CONTEXT;
        }
        if (CellRendererManager.isAutoInit() && !_inited && !_initing) {
            CellRendererManager.initDefaultRenderer();
        }
        _cache.register(clazz, tableCellRenderer, editorContext);
    }

    public static void unregisterRenderer(Class<?> clazz, EditorContext editorContext) {
        if (editorContext == null) {
            editorContext = EditorContext.DEFAULT_CONTEXT;
        }
        if (CellRendererManager.isAutoInit() && !_inited && !_initing) {
            CellRendererManager.initDefaultRenderer();
        }
        _cache.unregister(clazz, editorContext);
    }

    public static void unregisterRenderer(Class<?> clazz) {
        CellRendererManager.unregisterRenderer(clazz, EditorContext.DEFAULT_CONTEXT);
    }

    public static void unregisterAllRenderers(Class<?> clazz) {
        _cache.remove(clazz);
    }

    public static void unregisterAllRenderers() {
        _cache.clear();
    }

    public static TableCellRenderer getRenderer(Class<?> clazz, EditorContext editorContext) {
        Object object;
        if (CellRendererManager.isAutoInit() && !_inited && !_initing) {
            CellRendererManager.initDefaultRenderer();
        }
        if (editorContext == null) {
            editorContext = EditorContext.DEFAULT_CONTEXT;
        }
        if ((object = _cache.getRegisteredObject(clazz, editorContext)) != null && object instanceof TableCellRenderer) {
            CellRendererManager.customizeCellRenderer((TableCellRenderer)object);
            return (TableCellRenderer)object;
        }
        if (editorContext.equals(EditorContext.DEFAULT_CONTEXT)) {
            return null;
        }
        return CellRendererManager.getRenderer(clazz, EditorContext.DEFAULT_CONTEXT);
    }

    public static TableCellRenderer getRenderer(Class<?> clazz) {
        return CellRendererManager.getRenderer(clazz, EditorContext.DEFAULT_CONTEXT);
    }

    public static void updateUI() {
        CellRendererManager.updateUI0(_defaultCellRenderer);
        List<Object> list = _cache.getValues();
        for (Object object : list) {
            CellRendererManager.updateUI0(object);
        }
    }

    private static void updateUI0(Object object) {
        if (object == null) {
            return;
        }
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        if (object instanceof DefaultCellEditor) {
            component = ((DefaultCellEditor)object).getComponent();
        }
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
    }

    public static boolean isAutoInit() {
        return _autoInit;
    }

    public static void setAutoInit(boolean bl) {
        _autoInit = bl;
    }

    public static void addRegistrationListener(RegistrationListener registrationListener) {
        _cache.addRegistrationListener(registrationListener);
    }

    public static void removeRegistrationListener(RegistrationListener registrationListener) {
        _cache.removeRegistrationListener(registrationListener);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return _cache.getRegistrationListeners();
    }

    private static void customizeCellRenderer(TableCellRenderer tableCellRenderer) {
        for (CellRendererCustomizer cellRendererCustomizer : _cellRendererCustomizers) {
            if (cellRendererCustomizer == null) continue;
            cellRendererCustomizer.customize(tableCellRenderer);
        }
    }

    public static CellRendererCustomizer[] getCellRendererCustomizers() {
        return _cellRendererCustomizers.toArray(new CellRendererCustomizer[_cellRendererCustomizers.size()]);
    }

    public static void addCellRendererCustomizer(CellRendererCustomizer cellRendererCustomizer) {
        if (!_cellRendererCustomizers.contains(cellRendererCustomizer)) {
            _cellRendererCustomizers.add(cellRendererCustomizer);
        }
    }

    public static void removeCellRendererCustomizer(CellRendererCustomizer cellRendererCustomizer) {
        if (_cellRendererCustomizers.contains(cellRendererCustomizer)) {
            _cellRendererCustomizers.remove(cellRendererCustomizer);
        }
    }

    public static EditorContext[] getEditorContexts(Class<?> clazz) {
        return _cache.getKeys(clazz, (EditorContext[])new EditorContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultRenderer() {
        if (_inited) {
            return;
        }
        _initing = true;
        try {
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                        CellRendererManager.updateUI();
                    }
                }
            });
            DynamicValueCellRenderer dynamicValueCellRenderer = new DynamicValueCellRenderer();
            CellRendererManager.registerRenderer(Object.class, dynamicValueCellRenderer, EditorContext.DEFAULT_CONTEXT_DYNAMIC_VALUE);
            ContextSensitiveCellRenderer contextSensitiveCellRenderer = new ContextSensitiveCellRenderer();
            CellRendererManager.registerRenderer(Object.class, contextSensitiveCellRenderer);
            CellRendererManager.registerRenderer(String.class, contextSensitiveCellRenderer);
            CellRendererManager.registerRenderer(String.class, contextSensitiveCellRenderer, FontNameCellEditor.CONTEXT);
            CellRendererManager.registerRenderer(Object.class, new MultilineTableCellRenderer(), MultilineTableCellRenderer.CONTEXT);
            CellRendererManager.registerRenderer(Object.class, new MultilineStringCellRenderer(), MultilineStringCellRenderer.CONTEXT);
            VerticalContextSensitiveCellRenderer verticalContextSensitiveCellRenderer = new VerticalContextSensitiveCellRenderer();
            CellRendererManager.registerRenderer(Object.class, verticalContextSensitiveCellRenderer, VerticalContextSensitiveCellRenderer.CONTEXT);
            VerticalContextSensitiveCellRenderer verticalContextSensitiveCellRenderer2 = new VerticalContextSensitiveCellRenderer();
            verticalContextSensitiveCellRenderer2.setClockwise(false);
            CellRendererManager.registerRenderer(Object.class, verticalContextSensitiveCellRenderer2, VerticalContextSensitiveCellRenderer.CONTEXT_COUNTER_CLOCKWISE);
            NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
            CellRendererManager.registerRenderer(Number.class, numberCellRenderer);
            CellRendererManager.registerRenderer(Integer.TYPE, numberCellRenderer);
            CellRendererManager.registerRenderer(Double.TYPE, numberCellRenderer);
            CellRendererManager.registerRenderer(Float.TYPE, numberCellRenderer);
            CellRendererManager.registerRenderer(Short.TYPE, numberCellRenderer);
            CellRendererManager.registerRenderer(Long.TYPE, numberCellRenderer);
            CellRendererManager.registerRenderer(AbstractNumericRange.class, numberCellRenderer);
            CellRendererManager.registerRenderer(Color.class, new ColorCellRenderer());
            BooleanCheckBoxCellRenderer booleanCheckBoxCellRenderer = new BooleanCheckBoxCellRenderer();
            CellRendererManager.registerRenderer(Boolean.class, booleanCheckBoxCellRenderer, BooleanCheckBoxCellRenderer.CONTEXT);
            CellRendererManager.registerRenderer(Boolean.TYPE, booleanCheckBoxCellRenderer, BooleanCheckBoxCellRenderer.CONTEXT);
            IconCellRenderer iconCellRenderer = new IconCellRenderer();
            CellRendererManager.registerRenderer(Icon.class, iconCellRenderer);
            CellRendererManager.registerRenderer(char[].class, new PasswordCellRenderer(), PasswordCellRenderer.CONTEXT);
            TristateCheckBoxCellRenderer tristateCheckBoxCellRenderer = new TristateCheckBoxCellRenderer();
            CellRendererManager.registerRenderer(Integer.TYPE, tristateCheckBoxCellRenderer, TristateCheckBoxCellRenderer.CONTEXT);
            CellRendererManager.registerRenderer(Integer.class, tristateCheckBoxCellRenderer, TristateCheckBoxCellRenderer.CONTEXT);
        }
        finally {
            _initing = false;
            _inited = true;
        }
    }

    public static void resetInit() {
        _inited = false;
    }

    public static void clear() {
        CellRendererManager.resetInit();
        _cache.clear();
    }

    public static interface CellRendererCustomizer {
        public void customize(TableCellRenderer var1);
    }
}

