/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.RowTableModelWrapper;
import com.jidesoft.grid.TableModelWrapperImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class CachedTableModel
extends TableModelWrapperImpl
implements Serializable,
RowTableModelWrapper {
    private static final long serialVersionUID = -8691770717399648640L;
    private boolean _isSparseData = false;
    protected transient List<Object> _cachedValueList;
    protected int[] _cachedColumns = null;
    protected int[] _conversionIndex = null;
    private boolean _cacheEnabled = true;

    public CachedTableModel(TableModel tableModel) {
        super(tableModel);
    }

    public boolean isCacheEnabled() {
        return this._cacheEnabled;
    }

    public void setCacheEnabled(boolean bl) {
        if (this._cacheEnabled != bl) {
            this._cacheEnabled = bl;
            this.invalidateCache();
        }
    }

    @Override
    protected void tableRowsInserted(int n, int n2) {
        if (this.isCacheEnabled()) {
            for (int i = n; i <= n2; ++i) {
                this.insertCache(i);
            }
        }
        super.tableRowsInserted(n, n2);
    }

    @Override
    protected void tableRowsDeleted(int n, int n2) {
        if (this.isCacheEnabled()) {
            for (int i = n2; i >= n; --i) {
                this.removeCache(i);
            }
        }
        super.tableRowsDeleted(n, n2);
    }

    @Override
    protected void tableRowsUpdated(int n, int n2) {
        if (this.isCacheEnabled()) {
            for (int i = n; i <= n2; ++i) {
                this.invalidateCache(i);
            }
        }
        super.tableRowsUpdated(n, n2);
    }

    @Override
    protected void tableCellsUpdated(int n, int n2, int n3) {
        if (this.isCacheEnabled()) {
            for (int i = n2; i <= n3; ++i) {
                this.invalidateCache(i, n);
            }
        }
        super.tableCellsUpdated(n, n2, n3);
    }

    @Override
    protected void tableDataChanged() {
        if (this.isCacheEnabled()) {
            this.invalidateCache();
        }
        super.tableDataChanged();
    }

    @Override
    protected void tableStructureChanged() {
        if (this.isCacheEnabled()) {
            this.invalidateCache();
        }
        super.tableStructureChanged();
    }

    protected boolean isCachedValueValid(int n, int n2) {
        CachedValue cachedValue = this.getCachedValue(n, n2);
        return cachedValue != null && cachedValue.valid;
    }

    public void invalidateCache() {
        this._cachedValueList = null;
    }

    public void invalidateCache(int n) {
        if (this._cachedValueList == null) {
            return;
        }
        List<Object> list = this.getCachedRows();
        if (list.size() > n) {
            CachedValue[] cachedValueArray;
            for (CachedValue cachedValue : cachedValueArray = (CachedValue[])list.get(n)) {
                if (cachedValue == null) continue;
                cachedValue.invalidate();
            }
        }
    }

    public void invalidateCache(int n, int n2) {
        if (this._cachedValueList == null) {
            return;
        }
        CachedValue cachedValue = this.getCachedValue(n, n2);
        if (cachedValue != null) {
            cachedValue.invalidate();
        }
    }

    protected void removeCache(int n) {
        if (this._cachedValueList == null) {
            return;
        }
        List<Object> list = this.getCachedRows();
        if (list.size() > n) {
            list.remove(n);
        }
    }

    protected void insertCache(int n) {
        this.getCachedRows().add(n, this.createRowData(this.getColumnCount()));
    }

    protected void updateCachedValue(Object object, int n, int n2) {
        CachedValue cachedValue = this.getCachedValue(n, n2);
        if (cachedValue == null) {
            cachedValue = new CachedValue();
            if (this.isSparseData()) {
                ((Map)this.getCachedRows().get(n)).put(n2, cachedValue);
            } else {
                ((CachedValue[])this.getCachedRows().get((int)n))[this.getColumnIndexInCache((int)n2)] = cachedValue;
            }
        }
        cachedValue.valid = true;
        cachedValue.value = object;
        cachedValue.editable = super.isCellEditable(n, n2);
        cachedValue.clazz = super.getCellClassAt(n, n2);
        cachedValue.converterContext = super.getConverterContextAt(n, n2);
        cachedValue.editorContext = super.getEditorContextAt(n, n2);
    }

    private CachedValue updatedCachedCell(int n, int n2) {
        Object object = super.getValueAt(n, n2);
        this.updateCachedValue(object, n, n2);
        return this.getCachedValue(n, n2);
    }

    private CachedValue getCachedValue(int n, int n2) {
        if (this.isSparseData()) {
            Map map = (Map)this.getCachedRows().get(n);
            return (CachedValue)map.get(n2);
        }
        CachedValue[] cachedValueArray = (CachedValue[])this.getCachedRows().get(n);
        return cachedValueArray[this.getColumnIndexInCache(n2)];
    }

    private int getColumnIndexInCache(int n) {
        return this._cachedColumns == null ? n : this.getConversionIndex()[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.isColumnCached(n2) && n >= 0 && n < this.getRowCount()) {
            CachedValue cachedValue = this.getCachedValue(n, n2);
            if (cachedValue != null && cachedValue.valid) {
                return cachedValue.value;
            }
            cachedValue = this.updatedCachedCell(n, n2);
            if (cachedValue != null) {
                return cachedValue.value;
            }
        }
        return this.getActualModel().getValueAt(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.isColumnCached(n2) && n >= 0 && n < this.getRowCount()) {
            CachedValue cachedValue = this.getCachedValue(n, n2);
            if (cachedValue != null && cachedValue.valid) {
                return cachedValue.editable;
            }
            cachedValue = this.updatedCachedCell(n, n2);
            return cachedValue.editable;
        }
        return this.getActualModel().isCellEditable(n, n2);
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        if (this.isColumnCached(n2) && n >= 0 && n < this.getRowCount()) {
            CachedValue cachedValue = this.getCachedValue(n, n2);
            if (cachedValue != null && cachedValue.valid) {
                return cachedValue.clazz;
            }
            cachedValue = this.updatedCachedCell(n, n2);
            return cachedValue.clazz;
        }
        return super.getCellClassAt(n, n2);
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        if (this.isColumnCached(n2) && n >= 0 && n < this.getRowCount()) {
            CachedValue cachedValue = this.getCachedValue(n, n2);
            if (cachedValue != null && cachedValue.valid) {
                return cachedValue.converterContext;
            }
            cachedValue = this.updatedCachedCell(n, n2);
            return cachedValue.converterContext;
        }
        return super.getConverterContextAt(n, n2);
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        if (this.isColumnCached(n2) && n >= 0 && n < this.getRowCount()) {
            CachedValue cachedValue = this.getCachedValue(n, n2);
            if (cachedValue != null && cachedValue.valid) {
                return cachedValue.editorContext;
            }
            cachedValue = this.updatedCachedCell(n, n2);
            return cachedValue.editorContext;
        }
        return super.getEditorContextAt(n, n2);
    }

    protected List<Object> getCachedRows() {
        block4: {
            if (this._cachedValueList != null) break block4;
            this._cachedValueList = new ArrayList<Object>();
            int n = this.getColumnCount();
            int n2 = this.getRowCount();
            if (this.isSparseData()) {
                for (int i = 0; i < n2; ++i) {
                    this._cachedValueList.add(this.createRowMap(n));
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    this._cachedValueList.add(this.createRowData(n));
                }
            }
        }
        return this._cachedValueList;
    }

    private boolean isSparseData() {
        return this._isSparseData;
    }

    private void setSparseData(boolean bl) {
        this._isSparseData = bl;
    }

    private CachedValue[] createRowData(int n) {
        return new CachedValue[this.getCachedColumns() == null ? n : this.getCachedColumns().length];
    }

    private Map<Object, Object> createRowMap(int n) {
        return new Hashtable<Object, Object>();
    }

    public void cacheIt() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.getValueAt(i, j);
            }
        }
    }

    public int[] getCachedColumns() {
        return this._cachedColumns;
    }

    public void setCachedColumns(int[] nArray) {
        this._cachedColumns = (int[])(nArray != null && nArray.length == 0 ? null : nArray);
        this._conversionIndex = null;
    }

    public boolean isColumnCached(int n) {
        return this.isCacheEnabled() && (this._cachedColumns == null || this.getConversionIndex()[n] != -1);
    }

    private int[] getConversionIndex() {
        if (this.getCachedColumns() == null) {
            this._conversionIndex = null;
        } else if (this._conversionIndex == null) {
            this._conversionIndex = new int[this.getColumnCount()];
            block0: for (int i = 0; i < this._conversionIndex.length; ++i) {
                this._conversionIndex[i] = -1;
                for (int j = 0; j < this._cachedColumns.length; ++j) {
                    int n = this._cachedColumns[j];
                    if (n != i) continue;
                    this._conversionIndex[i] = j;
                    continue block0;
                }
            }
        }
        return this._conversionIndex;
    }

    @Override
    public int getActualRowAt(int n) {
        return n;
    }

    @Override
    public int getVisualRowAt(int n) {
        return n;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.invalidateCache(n, n2);
        super.setValueAt(object, n, n2);
    }

    private static class CachedValue {
        Object value = null;
        Class<?> clazz = null;
        boolean editable = false;
        ConverterContext converterContext = null;
        EditorContext editorContext = null;
        boolean valid = false;

        private CachedValue() {
        }

        public void invalidate() {
            this.valid = false;
            this.value = null;
            this.clazz = null;
            this.editable = false;
            this.converterContext = null;
            this.editorContext = null;
        }
    }
}

