/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.paging.PageNavigationEvent;
import com.jidesoft.paging.PageNavigationListener;
import com.jidesoft.paging.PageNavigationSupport;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractPageTableModel
extends AbstractTableModel
implements ContextSensitiveTableModel,
MultiTableModel,
PageNavigationSupport,
TableModelListener {
    private static final long serialVersionUID = 5801822175946179395L;
    private int _pageSize = 10;
    private int _currentPage = -1;
    private int _pageCount;
    private TableModelEvent _originalEvent;
    private static final Logger LOGGER_EVENT;
    private transient int _startRowIndex = -1;
    private transient boolean _saveRowIndex = true;

    public AbstractPageTableModel() {
    }

    public AbstractPageTableModel(int n) {
        this._pageSize = n;
    }

    @Override
    public int getPageSize() {
        return this._pageSize == 0 ? 10 : this._pageSize;
    }

    @Override
    public void setPageSize(int n) {
        int n2 = this._pageSize;
        if (n2 != n) {
            this._pageSize = n;
            this.pageSizeChanged(n2, this.getPageSize());
            this.firePageNavigationEvent(this, 14100, n2, this.getPageSize());
        }
    }

    @Override
    public int getCurrentPage() {
        return this._currentPage;
    }

    @Override
    public void setCurrentPage(int n) {
        this.setCurrentPage(n, false);
    }

    void setCurrentPage(int n, boolean bl) {
        int n2 = this._currentPage;
        if (bl || n2 != n && (this.getPageCount() < 0 || n <= this.getPageCount() - 1) && n >= 0) {
            this._currentPage = n;
            this.pageIndexChanged(n2, this._currentPage);
            this.firePageNavigationEvent(this, 14101, n2, this._currentPage);
            if (this._saveRowIndex) {
                this.saveRowIndex();
            }
        }
    }

    private void saveRowIndex() {
        this._startRowIndex = this.getPageSize() > 0 ? this.getCurrentPage() * this.getPageSize() : 0;
    }

    protected void setPageCount(int n) {
        int n2 = this._pageCount;
        if (n2 != n) {
            this._pageCount = n;
            this.pageCountChanged(n2, this._pageCount);
            this.firePageNavigationEvent(this, 14099, n2, this._pageCount);
            if (this.getCurrentPage() >= this.getPageCount()) {
                this.setCurrentPage(this.getPageCount() - 1);
            } else if (this.getCurrentPage() < 0) {
                this.setCurrentPage(0);
            }
        }
    }

    @Override
    public int getPageCount() {
        return this._pageCount;
    }

    @Override
    public void nextPage() {
        int n = this.getCurrentPage();
        if (n < this.getPageCount() - 1) {
            this.setCurrentPage(n + 1);
        }
    }

    @Override
    public void previousPage() {
        int n = this.getCurrentPage();
        if (n > 0) {
            this.setCurrentPage(n - 1);
        }
    }

    @Override
    public void firstPage() {
        if (this.getCurrentPage() > 0) {
            this.setCurrentPage(0);
        }
    }

    @Override
    public void lastPage() {
        int n = this.getPageCount();
        if (this.getCurrentPage() < n - 1) {
            this.setCurrentPage(n - 1);
        }
    }

    @Override
    public void addPageNavigationListener(PageNavigationListener pageNavigationListener) {
        this.listenerList.add(PageNavigationListener.class, pageNavigationListener);
    }

    @Override
    public void removePageNavigationListener(PageNavigationListener pageNavigationListener) {
        this.listenerList.remove(PageNavigationListener.class, pageNavigationListener);
    }

    @Override
    public PageNavigationListener[] getPageNavigationListeners() {
        return (PageNavigationListener[])this.listenerList.getListeners(PageNavigationListener.class);
    }

    @Override
    public void firePageNavigationEvent(Object object, int n, int n2, int n3) {
        if (object == null) {
            object = this;
        }
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 14099: {
                    LOGGER_EVENT.fine("Total page count is changed from " + n2 + " => " + n3 + ", source is " + object.getClass().getName());
                    break;
                }
                case 14100: {
                    LOGGER_EVENT.fine("Page size is changed from " + n2 + " => " + n3 + ", source is " + object.getClass().getName());
                    break;
                }
                case 14101: {
                    LOGGER_EVENT.fine("The current page index is changed from " + n2 + " => " + n3 + ", source is " + object.getClass().getName());
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        PageNavigationEvent pageNavigationEvent = new PageNavigationEvent(object, n, n2, n3);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PageNavigationListener.class) continue;
            ((PageNavigationListener)objectArray[i + 1]).pageNavigationEventFired(pageNavigationEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pageSizeChanged(int n, int n2) {
        int n3 = this.getCurrentPage();
        int n4 = this.getTotalRecordCount();
        if (n4 >= 0) {
            this.setPageCount(n4 / n2 + (n4 % n2 == 0 ? 0 : 1));
        } else {
            this.setPageCount(-1);
        }
        this._saveRowIndex = false;
        try {
            if (this._startRowIndex > 0) {
                this.setCurrentPage(this._startRowIndex / n2);
            } else {
                this.setCurrentPage(0);
            }
        }
        finally {
            this._saveRowIndex = true;
        }
        int n5 = this.getCurrentPage();
        if (n5 == n3) {
            this.pageIndexChanged(n3, n5);
        }
    }

    protected abstract void pageCountChanged(int var1, int var2);

    protected abstract void pageIndexChanged(int var1, int var2);

    @Override
    public synchronized int getRowCount() {
        int n = this.getCurrentPage();
        int n2 = this.getTotalRecordCount();
        if (n2 >= 0 && n2 <= this.getPageSize()) {
            return n2;
        }
        if (this.getPageCount() >= 0 && n == this.getPageCount() - 1) {
            return n2 - n * this.getPageSize();
        }
        return this.getPageSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            this._originalEvent = ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent();
        }
        try {
            switch (tableModelEvent.getType()) {
                case 1: {
                    this.tableRowsInserted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    return;
                }
                case -1: {
                    this.tableRowsDeleted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    return;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() == -1) {
                        this.tableStructureChanged();
                        return;
                    } else if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        if (tableModelEvent instanceof CompoundTableModelEvent) {
                            this.tableDataChanged((CompoundTableModelEvent)tableModelEvent);
                            return;
                        } else {
                            this.tableDataChanged();
                            return;
                        }
                    } else if (tableModelEvent.getColumn() == -1) {
                        this.tableRowsUpdated(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        return;
                    } else {
                        this.tableCellsUpdated(tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        finally {
            this._originalEvent = null;
        }
    }

    private int[] getOverlapRows(int n, int n2) {
        int n3;
        int n4 = this.getCurrentPage();
        int n5 = n4 * (n3 = this.getPageSize());
        if (n2 < n5) {
            return null;
        }
        int n6 = Math.min(this.getTotalRecordCount() - 1, n5 + n3);
        if (n > n6) {
            return null;
        }
        return new int[]{Math.max(n, n5) % n3, Math.min(n2, n6) % n3};
    }

    protected void tableRowsInserted(int n, int n2) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        this.internalTableRowsInserted(compoundTableModelEvent, n, n2);
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    private void internalTableRowsInserted(CompoundTableModelEvent compoundTableModelEvent, int n, int n2) {
        compoundTableModelEvent.addEvent(new TableModelEvent(this, n, n2, -1, 1));
    }

    protected void tableRowsDeleted(int n, int n2) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        this.internalTableRowsDeleted(compoundTableModelEvent, n, n2);
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    private void internalTableRowsDeleted(CompoundTableModelEvent compoundTableModelEvent, int n, int n2) {
        compoundTableModelEvent.addEvent(new TableModelEvent(this, n, n2, -1, -1));
    }

    protected void tableRowsUpdated(int n, int n2) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        this.internalTableRowsUpdated(compoundTableModelEvent, n, n2);
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    private void internalTableRowsUpdated(CompoundTableModelEvent compoundTableModelEvent, int n, int n2) {
        int[] nArray = this.getOverlapRows(n, n2);
        if (nArray != null) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, nArray[0], nArray[1], -1, 0));
        }
    }

    public void fireTableCellsUpdated(int n, int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, n3));
    }

    protected void tableCellsUpdated(int n, int n2, int n3) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        this.internalTableCellsUpdated(compoundTableModelEvent, n, n2, n3);
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    protected CompoundTableModelEvent createCompoundTableModelEvent() {
        CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(this);
        compoundTableModelEvent.setOriginalEvent(this._originalEvent);
        return compoundTableModelEvent;
    }

    private void internalTableCellsUpdated(CompoundTableModelEvent compoundTableModelEvent, int n, int n2, int n3) {
        int[] nArray = this.getOverlapRows(n2, n3);
        if (nArray != null) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, nArray[0], nArray[1], n));
        }
    }

    private void tableDataChanged(CompoundTableModelEvent compoundTableModelEvent) {
        if (compoundTableModelEvent == null || compoundTableModelEvent.getEvents() == null || compoundTableModelEvent.getEvents().length <= 0) {
            this.tableDataChanged();
            return;
        }
        CompoundTableModelEvent compoundTableModelEvent2 = this.createCompoundTableModelEvent();
        block5: for (TableModelEvent tableModelEvent : compoundTableModelEvent.getEvents()) {
            switch (tableModelEvent.getType()) {
                case 1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, 1));
                    continue block5;
                }
                case -1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, -1));
                    continue block5;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() == -1) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, -1));
                        continue block5;
                    }
                    if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this));
                        continue block5;
                    }
                    if (tableModelEvent.getColumn() == -1) {
                        this.internalTableRowsUpdated(compoundTableModelEvent2, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        continue block5;
                    }
                    this.internalTableCellsUpdated(compoundTableModelEvent2, tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Embedded TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent2);
    }

    protected void tableDataChanged() {
        this.fireTableDataChanged();
    }

    protected void tableStructureChanged() {
        this.fireTableStructureChanged();
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            super.fireTableChanged(tableModelEvent);
        } else {
            CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
            compoundTableModelEvent.addEvent(tableModelEvent);
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
        }
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        return this.getColumnClass(n2);
    }

    @Override
    public int getColumnType(int n) {
        return 0;
    }

    @Override
    public int getTableIndex(int n) {
        return 0;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2048)) {
            Lm.showInvalidProductMessage(AbstractPageTableModel.class.getName(), 2048);
        }
        LOGGER_EVENT = Logger.getLogger(PageNavigationEvent.class.getName());
    }
}

