/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.gauge.AbstractIndicatorRenderer;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import com.jidesoft.gauge.BulletAxisPlacement;
import com.jidesoft.gauge.IndicatorStyle;
import com.jidesoft.gauge.PointerIndicatorPlacement;
import com.jidesoft.gauge.PointerLabelPlacement;
import com.jidesoft.swing.ShadowRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;

public class PointerIndicatorRenderer
extends AbstractIndicatorRenderer<Bullet> {
    private static final double DEFAULT_POINTER_BREADTH = 0.15;
    private static final double DEFAULT_POINTER_LENGTH = 0.15;
    private double pointerBreadth = 0.15;
    private double pointerLength = 0.15;
    private PointerIndicatorPlacement pointerPlacement = PointerIndicatorPlacement.LEADING_INSIDE;
    private PointerLabelPlacement labelPlacement = PointerLabelPlacement.ABOVE;

    public PointerIndicatorRenderer() {
    }

    public PointerIndicatorRenderer(PointerIndicatorPlacement pointerIndicatorPlacement) {
        this();
        this.setPointerPlacement(pointerIndicatorPlacement);
    }

    public double getPointerBreadth() {
        return this.pointerBreadth;
    }

    public void setPointerBreadth(double d) {
        this.pointerBreadth = d;
    }

    public double getPointerLength() {
        return this.pointerLength;
    }

    public void setPointerLength(double d) {
        this.pointerLength = d;
    }

    public BulletAxisPlacement getAxisPlacement() {
        switch (this.pointerPlacement) {
            case LEADING_INSIDE: 
            case LEADING_OUTSIDE: {
                return BulletAxisPlacement.LEADING;
            }
            case TRAILING_INSIDE: 
            case TRAILING_OUTSIDE: {
                return BulletAxisPlacement.TRAILING;
            }
        }
        throw new IllegalStateException("Unexpected pointer placement: " + (Object)((Object)this.pointerPlacement));
    }

    public void setAxisPlacement(BulletAxisPlacement bulletAxisPlacement) {
        if (bulletAxisPlacement == BulletAxisPlacement.LEADING) {
            this.setPointerPlacement(PointerIndicatorPlacement.LEADING_INSIDE);
        } else if (bulletAxisPlacement == BulletAxisPlacement.TRAILING) {
            this.setPointerPlacement(PointerIndicatorPlacement.TRAILING_INSIDE);
        } else {
            throw new IllegalArgumentException("Unexpected BulletAxisPlacement: " + (Object)((Object)bulletAxisPlacement));
        }
    }

    public PointerIndicatorPlacement getPointerPlacement() {
        return this.pointerPlacement;
    }

    public void setPointerPlacement(PointerIndicatorPlacement pointerIndicatorPlacement) {
        if (pointerIndicatorPlacement == null) {
            throw new IllegalArgumentException("PointerPlacement cannot be null");
        }
        this.pointerPlacement = pointerIndicatorPlacement;
    }

    public PointerLabelPlacement getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setLabelPlacement(PointerLabelPlacement pointerLabelPlacement) {
        this.labelPlacement = pointerLabelPlacement;
    }

    private double[] computePositions(Bullet bullet, Double d) {
        Orientation orientation = bullet.getOrientation();
        BulletAxis bulletAxis = bullet.getAxis();
        double d2 = bullet.calculatePixelCoordinate(bulletAxis, d);
        double d3 = bullet.getBulletBreadth();
        double d4 = bullet.getMidY();
        double d5 = bullet.getMidX();
        double d6 = this.pointerBreadth * d3;
        double d7 = this.pointerLength * d3;
        return this.computePositions(orientation, d2, d5, d4, d3, d6, d7);
    }

    private double[] computePositions(Orientation orientation, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        double d10;
        block13: {
            double d11;
            double d12;
            block12: {
                double d13 = d3 - d4 / 2.0;
                double d14 = d3 + d4 / 2.0;
                d12 = d2 - d4 / 2.0;
                d11 = d2 + d4 / 2.0;
                if (orientation != Orientation.horizontal) break block12;
                d10 = d - d5 / 2.0;
                d9 = d + d5 / 2.0;
                switch (this.pointerPlacement) {
                    case LEADING_INSIDE: {
                        d8 = d14 - d6 - 1.0;
                        d7 = d14 - 1.0;
                        break block13;
                    }
                    case LEADING_OUTSIDE: {
                        d8 = d14 + 1.0;
                        d7 = d14 + 1.0 + d6;
                        break block13;
                    }
                    case TRAILING_INSIDE: {
                        d8 = d13 + 1.0;
                        d7 = d13 + d6 + 1.0;
                        break block13;
                    }
                    case TRAILING_OUTSIDE: {
                        d8 = d13 - 1.0 - d6;
                        d7 = d13 - 1.0;
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected pointer placement: " + (Object)((Object)this.pointerPlacement));
                    }
                }
            }
            d8 = d - d5 / 2.0;
            d7 = d + d5 / 2.0;
            switch (this.pointerPlacement) {
                case LEADING_INSIDE: {
                    d10 = d12 + 1.0;
                    d9 = d12 + 1.0 + d6;
                    break;
                }
                case LEADING_OUTSIDE: {
                    d10 = d12 - 1.0 - d6;
                    d9 = d12 - 1.0;
                    break;
                }
                case TRAILING_INSIDE: {
                    d10 = d11 - d6 - 1.0;
                    d9 = d11 - 1.0;
                    break;
                }
                case TRAILING_OUTSIDE: {
                    d10 = d11 + 1.0;
                    d9 = d11 + 1.0 + d6;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected pointer placement: " + (Object)((Object)this.pointerPlacement));
                }
            }
        }
        return new double[]{d10, d9, d8, d7};
    }

    @Override
    protected Shape calculateShape(Bullet bullet, Double d) {
        BulletAxis bulletAxis = bullet.getAxis();
        double d2 = bullet.calculatePixelCoordinate(bulletAxis, d);
        double[] dArray = this.computePositions(bullet, d);
        Orientation orientation = bullet.getOrientation();
        return this.calculateShape(orientation, d2, dArray);
    }

    protected Shape calculateShape(Orientation orientation, double d, double[] dArray) {
        int[] nArray;
        int[] nArray2;
        block13: {
            double d2;
            double d3;
            double d4;
            double d5;
            block12: {
                d5 = dArray[0];
                d4 = dArray[1];
                d3 = dArray[2];
                d2 = dArray[3];
                if (orientation != Orientation.horizontal) break block12;
                nArray2 = new int[]{(int)d, (int)d5, (int)d4};
                switch (this.pointerPlacement) {
                    case LEADING_INSIDE: {
                        nArray = new int[]{(int)d2, (int)d3, (int)d3};
                        break block13;
                    }
                    case LEADING_OUTSIDE: {
                        nArray = new int[]{(int)d3, (int)d2, (int)d2};
                        break block13;
                    }
                    case TRAILING_INSIDE: {
                        nArray = new int[]{(int)d3, (int)d2, (int)d2};
                        break block13;
                    }
                    case TRAILING_OUTSIDE: {
                        nArray = new int[]{(int)d2, (int)d3, (int)d3};
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected pointer placement: " + (Object)((Object)this.pointerPlacement));
                    }
                }
            }
            nArray = new int[]{(int)d, (int)d3, (int)d2};
            switch (this.pointerPlacement) {
                case LEADING_INSIDE: {
                    nArray2 = new int[]{(int)d5, (int)d4, (int)d4};
                    break;
                }
                case LEADING_OUTSIDE: {
                    nArray2 = new int[]{(int)d4, (int)d5, (int)d5};
                    break;
                }
                case TRAILING_INSIDE: {
                    nArray2 = new int[]{(int)d4, (int)d5, (int)d5};
                    break;
                }
                case TRAILING_OUTSIDE: {
                    nArray2 = new int[]{(int)d5, (int)d4, (int)d4};
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected pointer placement: " + (Object)((Object)this.pointerPlacement));
                }
            }
        }
        return new Polygon(nArray2, nArray, 3);
    }

    @Override
    protected void drawIndicator(Graphics2D graphics2D, Bullet bullet, Shape shape, IndicatorStyle indicatorStyle) {
        double d = bullet.getBulletBreadth();
        this.drawIndicator(graphics2D, d, shape, indicatorStyle);
    }

    @Override
    protected void drawIndicator(Graphics2D graphics2D, double d, Shape shape, IndicatorStyle indicatorStyle) {
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setPaint(indicatorStyle.getFill());
        graphics2D2.fill(shape);
        graphics2D2.draw(shape);
        Color color = indicatorStyle.getOutline();
        if (color != null) {
            Color color2 = graphics2D2.getColor();
            Stroke stroke = graphics2D2.getStroke();
            float f = indicatorStyle.getOutlineWidth();
            float f2 = (float)((double)f * d / 100.0);
            if (f2 < 1.0f) {
                f2 = 1.0f;
            }
            BasicStroke basicStroke = new BasicStroke(f2);
            graphics2D2.setStroke(basicStroke);
            graphics2D2.setColor(color);
            graphics2D2.draw(shape);
            graphics2D2.setColor(color2);
            graphics2D2.setStroke(stroke);
        }
        graphics2D2.dispose();
    }

    @Override
    public void paintLabel(Graphics2D graphics2D, Bullet bullet, Double d, IndicatorStyle indicatorStyle) {
        String string = this.generateLabel(d);
        if (string != null && this.labelPlacement != null && this.labelVisible) {
            Orientation orientation = bullet.getOrientation();
            Font font = this.getLabelFont() == null ? UIManager.getFont("Label.font") : this.getLabelFont();
            Dimension dimension = bullet.getFontComparisonSize();
            Font font2 = ChartUtils.deriveResizedFont(font, dimension, bullet);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
            int n = fontMetrics.stringWidth("o");
            int n2 = fontMetrics.stringWidth(string);
            Float f = null;
            Float f2 = null;
            double[] dArray = this.computePositions(bullet, d);
            double d2 = dArray[0];
            double d3 = dArray[1];
            double d4 = dArray[2];
            double d5 = dArray[3];
            if (orientation == Orientation.horizontal) {
                if (this.labelPlacement == PointerLabelPlacement.ABOVE) {
                    f = Float.valueOf((float)((d2 + d3) / 2.0 - (double)n2 / 2.0));
                    f2 = Float.valueOf((float)(d4 - (double)fontMetrics.getDescent()));
                } else if (this.labelPlacement == PointerLabelPlacement.BELOW) {
                    f = Float.valueOf((float)((d2 + d3) / 2.0 - (double)n2 / 2.0));
                    f2 = Float.valueOf((float)(d5 + (double)fontMetrics.getAscent()));
                } else if (this.labelPlacement == PointerLabelPlacement.LEFT) {
                    f = Float.valueOf((float)(d2 + 0.25 * (d3 - d2) - (double)n / 2.0 - (double)n2));
                    f2 = Float.valueOf((float)(d5 + d4) / 2.0f + (float)fontMetrics.getAscent() / 2.0f);
                } else if (this.labelPlacement == PointerLabelPlacement.RIGHT) {
                    f = Float.valueOf((float)(d2 + 0.75 * (d3 - d2) + (double)((float)n / 2.0f)));
                    f2 = Float.valueOf((float)(d5 + d4) / 2.0f + (float)fontMetrics.getAscent() / 2.0f);
                }
            } else if (this.labelPlacement == PointerLabelPlacement.ABOVE) {
                f = Float.valueOf((float)((d2 + d3) / 2.0 - (double)((float)n2 / 2.0f)));
                f2 = Float.valueOf((float)(d4 - (double)fontMetrics.getDescent()));
            } else if (this.labelPlacement == PointerLabelPlacement.BELOW) {
                f = Float.valueOf((float)((d2 + d3) / 2.0 - (double)((float)n2 / 2.0f)));
                f2 = Float.valueOf((float)(d5 + (double)fontMetrics.getAscent()));
            } else if (this.labelPlacement == PointerLabelPlacement.LEFT) {
                f = Float.valueOf((float)(d2 - (double)((float)n / 2.0f) - (double)n2));
                f2 = Float.valueOf((float)((d5 + d4) / 2.0 + (double)((float)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0f) - (double)fontMetrics.getDescent()));
            } else if (this.labelPlacement == PointerLabelPlacement.RIGHT) {
                f = Float.valueOf((float)(d3 + (double)((float)n / 2.0f)));
                f2 = Float.valueOf((float)((d5 + d4) / 2.0 + (double)((float)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0f) - (double)fontMetrics.getDescent()));
            }
            if (f != null && f2 != null) {
                Color color = this.getLabelColor();
                graphics2D.setColor(color == null ? Color.BLACK : color);
                graphics2D.setFont(font2);
                graphics2D.drawString(string, f.floatValue(), f2.floatValue());
            }
        }
    }

    @Override
    public Shape paintLegendItem(Graphics graphics, Bullet bullet, IndicatorStyle indicatorStyle, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BulletAxis bulletAxis = bullet.getAxis();
        double d = bulletAxis.minimum();
        Orientation orientation = bullet.getOrientation();
        double d2 = bullet.calculatePixelCoordinate(bulletAxis, d);
        double d3 = 10.0;
        double d4 = d3 / 0.15;
        double d5 = 0.15 * d4;
        double[] dArray = this.computePositions(orientation, d2, 0.0, 0.0, d4, d5, d3);
        Shape shape = this.calculateShape(orientation, d2, dArray);
        Rectangle rectangle = shape.getBounds();
        graphics2D.translate(-rectangle.x, -rectangle.y);
        this.drawIndicator(graphics2D, d4, shape, indicatorStyle);
        int n3 = n / 2 - rectangle.width / 2;
        int n4 = n2 / 2 - rectangle.height / 2;
        ShadowRenderer shadowRenderer = this.getShadowRenderer();
        if (bullet.isShadowVisible()) {
            BufferedImage bufferedImage2 = shadowRenderer.createShadow(bufferedImage);
            graphics.drawImage(bufferedImage2, n3, n4, bullet);
        }
        graphics.drawImage(bufferedImage, n3, n4, bullet);
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.dispose();
        return null;
    }
}

