/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.gauge.Dial;
import com.jidesoft.gauge.MarkerShape;
import com.jidesoft.gauge.MarkerShapeFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class DialValueMarker
implements Drawable {
    private double radius = 0.95;
    private Dial dial;
    private double position;
    private Paint fill = Color.gray;
    private Color borderColor = Color.gray;
    private double width = 0.08;
    private double height = 0.08;
    private Stroke borderStroke = new BasicStroke(1.0f);
    private MarkerShapeFactory shapeFactory = MarkerShape.DOWN_TRIANGLE;

    public DialValueMarker(Dial dial) {
        this.setDial(dial);
    }

    public DialValueMarker(Dial dial, double d, double d2) {
        this.setDial(dial);
        this.setPosition(d);
        this.setRadius(d2);
    }

    public Dial getDial() {
        return this.dial;
    }

    public void setDial(Dial dial) {
        this.dial = dial;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double d) {
        this.position = d;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fill = paint;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(Stroke stroke) {
        this.borderStroke = stroke;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setSize(double d) {
        this.setWidth(d);
        this.setHeight(d);
    }

    public MarkerShapeFactory getShape() {
        return this.shapeFactory;
    }

    public void setShape(MarkerShapeFactory markerShapeFactory) {
        this.shapeFactory = markerShapeFactory;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = this.dial.getPivotX();
        int n2 = this.dial.getPivotY();
        double d = this.dial.getAngle(this.position);
        float f = this.dial.getRadius();
        double d2 = (double)n + (double)f * this.radius * Math.cos(Math.toRadians(d));
        double d3 = (double)n2 - (double)f * this.radius * Math.sin(Math.toRadians(d));
        double d4 = (double)f * this.width;
        double d5 = (double)f * this.height;
        if (this.shapeFactory != null) {
            Shape shape = this.shapeFactory.createShape(d2, d3, d4, d5);
            double d6 = Math.toRadians(Dial.normalizeAngle(90.0 - d));
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d6, d2, d3);
            Shape shape2 = affineTransform.createTransformedShape(shape);
            graphics2D.setPaint(this.fill);
            graphics2D.fill(shape2);
            graphics2D.setColor(this.borderColor);
            graphics2D.setStroke(this.borderStroke);
            graphics2D.draw(shape2);
        }
        graphics2D.dispose();
    }
}

