/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.gauge.AbstractGauge;
import com.jidesoft.gauge.NeedleEndShape;
import com.jidesoft.gauge.NeedleFillFactory;
import com.jidesoft.gauge.NeedleRenderer;
import com.jidesoft.gauge.NeedleStyle;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.swing.ShadowRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class DefaultNeedleRenderer
implements NeedleRenderer {
    private ShadowRenderer shadowRenderer = new ShadowFactory();
    private NeedleFillFactory needleFillFactory = new SimpleNeedleFillFactory();
    private BufferedImage needleImage = null;

    public DefaultNeedleRenderer() {
        ShadowFactory shadowFactory = new ShadowFactory();
        shadowFactory.setRenderingHint("blur_quality", "fast");
        this.setShadowRenderer(shadowFactory);
    }

    public ShadowRenderer getShadowRenderer() {
        return this.shadowRenderer;
    }

    public void setShadowRenderer(ShadowRenderer shadowRenderer) {
        if (shadowRenderer == null) {
            throw new NullPointerException("Shadow Renderer cannot be null");
        }
        this.shadowRenderer = shadowRenderer;
    }

    @Override
    public Shape paintNeedle(Graphics2D graphics2D, AbstractGauge abstractGauge, Double d, double d2, double d3, double d4, double d5, NeedleStyle needleStyle) {
        Shape shape = this.createNeedle(d4, d2, d3, d5, needleStyle);
        Rectangle rectangle = shape.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            if (abstractGauge.isShadowVisible()) {
                BasicStroke basicStroke = needleStyle.getOutlineStroke();
                if (basicStroke == null) {
                    basicStroke = new BasicStroke(1.0f);
                }
                float f = basicStroke.getLineWidth();
                rectangle = new Rectangle((int)((float)rectangle.x - f), (int)((float)rectangle.y - f), (int)((float)rectangle.width + 2.0f * f), (int)((float)rectangle.height + 2.0f * f));
                if (this.needleImage != null && this.needleImage.getWidth() == rectangle.width && this.needleImage.getHeight() == rectangle.height) {
                    ChartUtils.clearBufferedImage(this.needleImage, Color.black);
                } else {
                    this.needleImage = new BufferedImage(rectangle.width, rectangle.height, 2);
                }
                Graphics2D graphics2D2 = (Graphics2D)this.needleImage.getGraphics();
                graphics2D2.translate(-rectangle.x, -rectangle.y);
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.drawNeedle(graphics2D2, shape, d, d2, d3, d4, d5, needleStyle);
                BufferedImage bufferedImage = this.shadowRenderer.createShadow(this.needleImage);
                graphics2D.translate(rectangle.x, rectangle.y);
                graphics2D.drawImage((Image)bufferedImage, 0, 0, abstractGauge);
                graphics2D.drawImage((Image)this.needleImage, 0, 0, abstractGauge);
                graphics2D.translate(-rectangle.x, -rectangle.y);
                graphics2D2.dispose();
            } else {
                this.drawNeedle(graphics2D, shape, d, d2, d3, d4, d5, needleStyle);
            }
        }
        return shape;
    }

    private Shape createNeedle(double d, double d2, double d3, double d4, NeedleStyle needleStyle) {
        double d5 = d4 * needleStyle.getBaseWidth();
        double d6 = d4 * needleStyle.getHeadLength();
        double d7 = d4 * needleStyle.getTailLength();
        double d8 = d4 * needleStyle.getHeadWidth();
        double d9 = d4 * needleStyle.getTailWidth();
        GeneralPath generalPath = this.createNeedleEnd(d, d2, d3, d6, d5, d8, needleStyle.getHeadShape());
        GeneralPath generalPath2 = this.createNeedleEnd(d - 180.0, d2, d3, d7, d5, d9, needleStyle.getTailShape());
        generalPath.append(generalPath2, true);
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath createNeedleEnd(double d, double d2, double d3, double d4, double d5, double d6, NeedleEndShape needleEndShape) {
        GeneralPath generalPath = new GeneralPath();
        double d7 = Math.toRadians(d);
        double d8 = d2 - 0.5 * d5 * Math.sin(d7);
        double d9 = d3 - 0.5 * d5 * Math.cos(d7);
        double d10 = d2 + 0.5 * d5 * Math.sin(d7);
        double d11 = d3 + 0.5 * d5 * Math.cos(d7);
        double d12 = d2 + d4 * Math.cos(d7);
        double d13 = d3 - d4 * Math.sin(d7);
        double d14 = d12 + 0.5 * d6 * Math.sin(d7);
        double d15 = d13 + 0.5 * d6 * Math.cos(d7);
        double d16 = d12 - 0.5 * d6 * Math.sin(d7);
        double d17 = d13 - 0.5 * d6 * Math.cos(d7);
        generalPath.moveTo(d10, d11);
        generalPath.lineTo(d14, d15);
        if (needleEndShape == NeedleEndShape.ROUND) {
            Arc2D.Double double_ = new Arc2D.Double(d12 - d6 / 2.0, d13 - d6 / 2.0, d6, d6, d - 90.0, 180.0, 0);
            generalPath.append(double_, true);
        } else if (needleEndShape == NeedleEndShape.TRIANGULAR) {
            double d18 = d2 + (d4 + d6) * Math.cos(d7);
            double d19 = d3 - (d4 + d6) * Math.sin(d7);
            generalPath.lineTo(d18, d19);
            generalPath.lineTo(d16, d17);
        }
        generalPath.lineTo(d16, d17);
        generalPath.lineTo(d8, d9);
        return generalPath;
    }

    private void drawNeedle(Graphics2D graphics2D, Shape shape, Double d, double d2, double d3, double d4, double d5, NeedleStyle needleStyle) {
        Color color = needleStyle.getOutlineColor();
        Paint paint = this.needleFillFactory.createNeedleFill(d, d2, d3, d4, d5, needleStyle);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        if (color != null) {
            graphics2D.setColor(color);
            BasicStroke basicStroke = needleStyle.getOutlineStroke();
            if (basicStroke == null) {
                basicStroke = new BasicStroke(1.0f);
            }
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(shape);
        }
    }

    static class SimpleNeedleFillFactory
    implements NeedleFillFactory {
        SimpleNeedleFillFactory() {
        }

        @Override
        public Paint createNeedleFill(Double d, double d2, double d3, double d4, double d5, NeedleStyle needleStyle) {
            return needleStyle.getFillPaint();
        }
    }
}

